! mar_hy : mar microphysics (hydrometeors)
! ========================================
module mar_hy
    use mardim
    implicit none
    ! turnHY: set = T when rhcrHY is reached => microphysics turned on
    logical, save :: turnHY
    ! cminHY : cloud fraction (minimum)
    real, save :: cminHY
    ! rhcrHY: critical relative humidity value for condensation
    real, save :: rhcrHY
    ! tim_HY: time at which microphysics are taken into account
    real, save :: tim_HY
    ! cfraHY : cloud fraction
    real, save, allocatable :: cfraHY(:, :, :)
    ! ccnwHY : cloud dropplets number concentration (Nb/m3)
    real, save, allocatable :: ccnwHY(:, :, :)
    ! ccniHY : cloud ice crystals number concentration (Nb/m3)
    real, save, allocatable :: ccniHY(:, :, :)
    ! qwHY : cloud dropplets concentration (kg/kg)
    real, save, allocatable :: qwHY(:, :, :)
    ! qiHY : cloud ice crystals concentration (kg/kg)
    real, save, allocatable :: qiHY(:, :, :)
    ! qrHY : rain concentration (kg/kg)
    real, save, allocatable :: qrHY(:, :, :)
    ! qsHY : snow flakes concentration (kg/kg)
    real, save, allocatable :: qsHY(:, :, :)
    ! qgHY : graupels concentration (kg/kg)
    !          (translucent snow pellets encased in a thin layer of ice)
    real, save, allocatable :: qgHY(:, :, :)
    ! snfHY : qsHY to snowfall in the atmosphere [m w.e.]
    real, save, allocatable :: snfHY(:, :, :)
    ! sblHY : snowfall sublimation in the atmosphere [m w.e.]
    real, save, allocatable :: sblHY(:, :, :)
    ! rnfHY : qrHY to rainfall in the atmosphere [m w.e.]
    real, save, allocatable :: rnfHY(:, :, :)
    ! evpHY : rainfall evaporation in the atmosphere [m w.e.]
    real, save, allocatable :: evpHY(:, :, :)
    real, save, allocatable :: smtHY(:, :, :)
    ! depHY : snowfall condensation in the atmosphere [m w.e.]
    real, save, allocatable :: depHY(:, :, :)
    ! qssblHY : snow sublimated mass in the atmosphere (kg/kg)
    real, save, allocatable :: qssblHY(:, :, :)
    ! rainHY : integrated precipited rain
    real, save :: rainHY(mx, my)
    ! rai0HY : integrated precipited rain (previous time step)
    real, save, allocatable :: rai0HY(:, :)
    ! snowHY : integrated precipited/eroded snow
    real, save :: snowHY(mx, my)
    ! sno0HY : integrated precipited/eroded snow (previous time step)
    real, save, allocatable :: sno0HY(:, :)
    real, save, allocatable :: crysHY(:, :)
    ! sfa0HY : integrated precipited snow (previous time step)
    real, save, allocatable :: sfa0HY(:, :)
    ! qsrfHY : Blowing Snow Concentration  (0.325 m above the surface)
    real, save, allocatable :: qsrfHY(:, :)
    ! uss_HY : Blowing Snow Turbulent Flux (0.325 m above the surface)
    real, save, allocatable :: uss_HY(:, :)
    real, save, allocatable :: qbs_HY(:, :)
    ! hlatHY : latent heat release [K/s] &
    !          BLOWN * SUBLIMATION [m w.e.] (for k=1)
    real, save, allocatable :: hlatHY(:, :, :)
    !  dqiHY :  Sublimation(-) /   Deposition(+) [m w.e.]
    real, save, allocatable :: dqiHY(:, :, :)
    !  dqwHY : Vaporisation(-) / Condensation(+) [m w.e.]
    real, save, allocatable :: dqwHY(:, :, :)
    ! Hcd_HY : latent heat release [mm w.e.]
    real, save, allocatable :: Hcd_HY(:, :)
    ! Tcd_HY : latent heat release weighted Air Temperature [K]
    real, save, allocatable :: Tcd_HY(:, :)
    real, save, allocatable :: zcd_HY(:, :)
    ! Hsb_HY : latent heat absorb. [mm w.e.]
    real, save, allocatable :: Hsb_HY(:, :)
    ! Tsb_HY : latent heat absorb. weighted Air Temperature [K]
    real, save, allocatable :: Tsb_HY(:, :)
    real, save, allocatable :: zsb_HY(:, :)
    ! hsubHY : latent heat release [K/s] &
    !          BLOWN * SUBLIMATION [kg/kg] per vertical level
    real, save, allocatable :: hsubHY(:, :, :)
    integer, save :: icntHY

contains
    
    subroutine mar_hy_init()
        
        use mardim, only : mx, my, mz
        implicit none
        
        allocate(cfraHY(mx, my, mz))
        allocate(ccnwHY(mx, my, mz))
        allocate(ccniHY(mx, my, mz))
        allocate(qwHY(mx, my, mz))
        allocate(qiHY(mx, my, mz))
        allocate(qrHY(mx, my, mz))
        allocate(qsHY(mx, my, mzz))
        allocate(qgHY(mx, my, mz))
        allocate(snfHY(mx, my, mz))
        allocate(sblHY(mx, my, mz))
        allocate(rnfHY(mx, my, mz))
        allocate(evpHY(mx, my, mz))
        allocate(smtHY(mx, my, mz))
        allocate(depHY(mx, my, mz))
        allocate(qssblHY(mx, my, mz))
        allocate(rai0HY(mx, my))
        allocate(sno0HY(mx, my))
        allocate(crysHY(mx, my))
        allocate(sfa0HY(mx, my))
        allocate(qsrfHY(mx, my))
        allocate(uss_HY(mx, my))
        allocate(qbs_HY(mx, my))
        allocate(hlatHY(mx, my, mz))
        allocate(dqiHY(mx, my, mz))
        allocate(dqwHY(mx, my, mz))
        allocate(Hcd_HY(mx, my))
        allocate(Tcd_HY(mx, my))
        allocate(zcd_HY(mx, my))
        allocate(Hsb_HY(mx, my))
        allocate(Tsb_HY(mx, my))
        allocate(zsb_HY(mx, my))
        allocate(hsubHY(mx, my, mz))
    
    endsubroutine mar_hy_init
    
endmodule mar_hy
