module mar_ge

    use mardim

    implicit none

    ! labmGE : Month Label
    character(len=3), parameter :: labmGE(0:12) = (/'---', 'Jan', 'Feb', &
                                                    'Mar', 'Apr', 'May', 'Jun', 'Jul', &
                                                    'Aug', 'Sep', 'Oct', 'Nov', 'Dec'/)
    ! iyr0GE : Initial Year
    integer, save :: iyr0GE
    ! iyrrGE : Current Year
    integer, save :: iyrrGE
    ! mma0GE : Initial Month
    integer, save :: mma0GE
    ! mmarGE : Current Month
    integer, save :: mmarGE
    ! jda0GE : Initial Day
    integer, save :: jda0GE
    ! jdarGE : Current Day
    integer, save :: jdarGE
    ! jhu0GE : Initial Hour (UT)
    integer, save :: jhu0GE
    ! jhurGE : Current Hour (UT)
    integer, save :: jhurGE
    ! jhl0GE : Initial Hour (LT)
    integer, save :: jhl0GE
    ! jhlrGE : Current Hour (LT)
    integer, save :: jhlrGE(mx, my)
    ! minuGE : Minute
    integer, save :: minuGE
    ! jsecGE : second
    integer, save :: jsecGE
    ! ksecGE : Cent.of second
    integer, save :: ksecGE
    ! itizGE : Time Zone (numero du fuseau horaire)
    integer, save :: itizGE(mx, my)
    ! njyrGE : Number of Days since Begin of the Year before Current Month
    integer, save :: njyrGE(0:12)
    ! njybGE : Leap Year Correction to current Day of the Year
    integer, save :: njybGE(0:12)
    ! njmoGE : Number of Days in each Month of the Year
    integer, save :: njmoGE(0:12)
    ! njmbGE : Leap Year Correction to each Month of the Year
    integer, save :: njmbGE(0:12)
    ! nhyrGE : Number of Hours in one Year
    integer, save :: nhyrGE
    ! GElat0 : Latitude (Degrees)
    real, save :: GElat0
    ! GElon0 : Longitude (Degrees)
    real, save :: GElon0
    ! GElatr : Latitude (Radians)
    real, save :: GElatr(mx, my)
    ! GElonh : Longitude (Hours)
    real, save :: GElonh(mx, my)
    ! GEtrue : On Oblique Stereographic Projection:
    !   Relative CoLatitude where distances (Degrees)
    !   on Proj.plane = distances on sphere
    real, save :: GEtrue
    ! GEddxx : Direction x-axis (Degrees)
    real, save :: GEddxx
    ! slatGE : Sine of Latitude
    real, save :: slatGE(mx, my)
    ! clatGE : Cosine of Latitude
    real, save :: clatGE(mx, my)
    real, save :: deglon2D(mx, my)
    real, save :: deglat2D(mx, my)
    integer, parameter :: n_azim = 8
    ! czenGE : Cosine  of Solar Zenith Angle
    real, save :: czenGE(mx, my)
    ! cz0_GE : Cosine  of Solar Zenith Angle (Minimum Value for solari call)
    real, save :: cz0_GE
    ! omenGE : Azimuth of Fall Line (Radians)
    real, save :: omenGE(mx, my)
    ! slopGE : Cosine of Fall Line Angle
    real, save :: slopGE(mx, my)
    ! cmntGE : Cosine  of Solar Zenith Angle
    !          (Minimum Value from Mountains Mask / All Directions)
    real, save :: cmntGE(mx, my, n_azim)
    ! daziGE : Unit Angle for Mountains Mask (Radians)
    real, save :: daziGE
    ! czmnGE : Cosine  of Solar Zenith Angle (Minimum Value from Mountains Mask)
    real, save :: czmnGE(mx, my)
    ! cverGE : Cosine  of Solar Normal Angle
    real, save :: cverGE(mx, my)
    ! rsunGE : Insolation (Top of the Atmosphere) (W/m2)
    real, save :: rsunGE
    ! tlsrGE : Sun Rise Local Time / (iSND,jSND) (hour)
    real, save :: tlsrGE
    ! tlssGE : Sun Set  Local Time / (iSND,jSND) (hour)
    real, save :: tlssGE
    ! tl__GE : Current  Local Time / (iSND,jSND) (hour)
    real, save :: tl__GE
    !calendar type
    character(len=10),save :: calGE
    ! MAR version
    character(len=10),save :: verGE

contains

    integer(kind=8) function ou2sGE(yr, mo, da, hh, mm, ss)
        ! +----------------------------------------------------------------+
        ! | MAR INPUT                                    31-11-2012-XF MAR |
        ! +----------------------------------------------------------------+

        implicit none

        integer, intent(in) :: yr
        integer, intent(in) :: mo
        integer, intent(in) :: da
        integer, intent(in) :: hh
        integer, intent(in) :: mm
        integer, intent(in) :: ss
        integer :: y

        ou2sGE = 0
        do y = iyr0GE, yr - 1
            ou2sGE = ou2sGE + 365 + njmbGE(2) * max(0, 1 - mod(y, 4))
        enddo

        ou2sGE = ou2sGE + njyrGE(mo) + &
                 njybGE(mo) * max(0, 1 - mod(yr, 4)) + da - 1

        ou2sGE = ou2sGE * 24 + hh
        ou2sGE = ou2sGE * 3600 + mm * 60 + ss

        return
    endfunction ou2sGE

endmodule mar_ge
