! mar_dy: mar dynamical variables
! ===============================
module mar_dy
    use mardim
    implicit none
    logical, save :: openmp
    ! iyrDYN: Year
    integer, save :: iyrDYN
    ! mmaDYN: Month
    integer, save :: mmaDYN
    ! jdaDYN: Day
    integer, save :: jdaDYN
    ! jhuDYN: Hour  (UT)
    integer, save :: jhuDYN
    ! uairDY : x-wind speed component (m/s)
    real, save :: uairDY(mx, my, mz)
    ! vairDY : y-wind speed component (m/s)
    real, save :: vairDY(mx, my, mz)
    ! pktaDY : potential temperature divided by 100.[kPa]**(R/Cp)
    real, save :: pktaDY(mx, my, mzz)
    ! tairDY : real temperature (K)
    real, save :: tairDY(mx, my, mz)
    ! pkDY : Exner Potential = p[kPa]**(R/Cp)
    real, save, allocatable :: pkDY(:, :, :)
    ! qvsiDY : Saturation Specific Humidity over Ice (kg/kg)
    real, save, allocatable :: qvsiDY(:, :, :)
    ! qvDY : Specific Humidity (kg/kg)
    real, save :: qvDY(mx, my, mz)
    ! qvswDY : Saturation Specific Humidity over Water (kg/kg)
    real, save, allocatable :: qvswDY(:, :, :)
    ! pstDY1 : Model Pressure Depth at INITIAL Time Step (kPa)
    real, save :: pstDY1(mx, my)
    ! opstDY : Model Pressure Depth at previous Time Step (kPa)
    real, save :: opstDY(mx, my)
    ! pstDY : Model Pressure Depth at current Time Step (kPa)
    real, save :: pstDY(mx, my)
    ! pstDYn: Model Pressure Depth at next Time Step (kPa)
    real, save :: pstDYn(mx, my)
    ! pstDY2: Model Pressure Depth (current) (squared) (kPa2)
    real, save :: pstDY2(mx, my)
    ! ptopDY: Pressure at Model Top (kPa)
    real, save :: ptopDY
    ! fcorDY: Coriolis Parameter (s-1)
    real, save :: fcorDY(mx, my)
    ! SFm_DY: Map Scale Factor (-)
    real, save :: SFm_DY(mx, my)
    ! rolvDY: air specific mass index (i,j,k) at (i,j,k) (Ton/m3)
    real, save :: rolvDY(mx, my, mz)
    ! romiDY: air specific mass index (i,j,k) at (i,j,k+1/2) (Ton/m3)
    real, save, allocatable :: romiDY(:, :, :)
    ! virDY: air loading by water (vapor, liquid and solid)
    real, save :: virDY(mx, my, mz)
    ! ubefDY: uairDY at Previous Time Step (in the Leap-Frog)
    real, save, allocatable :: ubefDY(:, :, :)
    ! vbefDY: vairDY at Previous Time Step (in the Leap-Frog)
    real, save, allocatable :: vbefDY(:, :, :)
    ! dgzXDY is the geopotential gradient just before current time step
    !    X=(x->x direction, y->y direction)
    real, save, allocatable :: dgzxDY(:, :, :)
    real, save, allocatable :: dgzyDY(:, :, :)
    ! dg1XDY is the geopotential gradient just before previous time step
    !    X=(x->x direction, y->y direction)
    real, save, allocatable :: dg1xDY(:, :, :)
    real, save, allocatable :: dg1yDY(:, :, :)
    ! wairDY : Vertical Wind Speed (in z coordinate) (cm/s)
    real, save :: wairDY(mx, my, mz)
    ! psigDY : p* X Vertical Wind Speed (in sigma coordinate)
    real, save :: psigDY(mx, my, mz)
    ! wsigDY : Vertical Wind Speed (in sigma coordinate)
    real, save :: wsigDY(mx, my, mz)
    ! CFLzDY : Vertical CFL (in sigma coordinate)
    real, save :: CFLzDY
    ! gplvDY: Geopotential of sigma Levels (= g z)
    real, save :: gplvDY(mx, my, mzz)
    ! gpmiDY: Geopotential between sigma Levels (i,j,k)->layer(i,j,k-1/2)
    real, save :: gpmiDY(mx, my, mzz)
    ! ugeoDY: x-geostrophic wind speed (assumed external) (m/s)
    real, save, allocatable :: ugeoDY(:, :, :)
    ! vgeoDY: y-geostrophic wind speed (assumed external) (m/s)
    real, save, allocatable :: vgeoDY(:, :, :)

contains
    
    subroutine mar_dy_init()
        
        use mardim, only : mx, my, mz, mzz
        implicit none
        
        allocate(pkDY(mx, my, mz))
        allocate(qvsiDY(mx, my, mzz))
        allocate(qvswDY(mx, my, mzz))
        allocate(romiDY(mx, my, mz))
        allocate(ubefDY(mx, my, mz))
        allocate(vbefDY(mx, my, mz))
        allocate(dgzxDY(mx, my, mz))
        allocate(dgzyDY(mx, my, mz))
        allocate(ugeoDY(mx, my, mz))
        allocate(vgeoDY(mx, my, mz))
        allocate(dg1xDY(mx, my, mz))
        allocate(dg1yDY(mx, my, mz))
    
    endsubroutine mar_dy_init

endmodule mar_dy

