! mar_ca : convective adjustment scheme
! =====================================
module mar_ca
    use mardim
    implicit none
    ! Time interval (transformed in number of iterations)
    ! between two checks of convective unstability
    integer, save :: adj_CA(mx, my)
    integer, save :: int_CA
    ! Characteristic Time Scale for Convection
    real, save :: capeCA(mx, my)
    real, save, allocatable :: dpktCA(:, :, :)
    real, save, allocatable :: dqv_CA(:, :, :)
    real, save, allocatable :: dqw_CA(:, :, :)
    real, save, allocatable :: dqi_CA(:, :, :)
    real, save :: drr_CA(mx, my)
    real, save :: dss_CA(mx, my)
    real, save :: dsn_CA(mx, my)
    real, save :: rainCA(mx, my)
    real, save :: snowCA(mx, my)
    real, save :: tau_CA(mx, my)

contains
    
    subroutine mar_ca_init()
        
        use mardim, only : mx, my, mz
        implicit none
        
        allocate(dpktCA(mx, my, mz))
        allocate(dqv_CA(mx, my, mz))
        allocate(dqw_CA(mx, my, mz))
        allocate(dqi_CA(mx, my, mz))
    
    endsubroutine mar_ca_init

endmodule mar_ca
