! mar_bs : mar blowing snow
! =========================
module mar_bs
    use mardim
    implicit none
    integer, parameter :: nn_pro = 30
    ! BS_pro : Normalized Blowing Snow Profile (Suspension Layer)
    real, save :: BS_pro(nn_pro)
    ! z0SaBS : Z0 due to Sastrugi Height [m]
    real, save, allocatable :: z0SaBS(:, :, :)
    ! z0emBS : Z0 due to Snow Erosion [m]
    real, save, allocatable :: z0emBS(:, :, :)
    ! hSalBS : Height  above the Surface  (Top of Saltation  Layer) [m]
    real, save :: hSalBS(mx, my)
    ! u_stBS : Time Ave. Frict. Vel. for Blowing Snow Surface Turbulent Flux [m/s]
    real, save :: u_stBS(mx, my)
    ! wSalBS : Blowing Snow Sedimentation (Top of Saltation  Layer) [m/s]
    real, save :: wSalBS(mx, my)
    real, save :: FracBS
    real, save :: ua_0BS(mx, my)
    real, save :: va_0BS(mx, my)
    real, save :: VVs_BS(mx, my)
    real, save :: DDs_BS(mx, my)
    real, save :: RRs_BS(mx, my)


contains
    
    subroutine mar_bs_init()
        
        use mardim, only : mx, my, mw
        implicit none
        
        allocate(z0SaBS(mx, my, mw))
        allocate(z0emBS(mx, my, mw))
    
    endsubroutine mar_bs_init


endmodule mar_bs
