! mar_ao : atmosphere-ocean (MAR-NEMO) coupling
! =============================================
! Sea Ice/Snow albedo for SISVAT albAOsisv is defined in MARySV.inc
module mar_ao
    use mardim
    implicit none
    ! fields given by ocean/ice model
    ! ===============================
    ! sicsAO:  sea ice fraction (from 0 to 1)
    real(kind = 8), save, allocatable :: sicsAO(:, :)
    ! hicAO : sea ice thickness
    real(kind = 8), save, allocatable :: hicAO(:, :)
    ! hsnoAO : snow thickness over sea ice
    real(kind = 8), save, allocatable :: hsnoAO(:, :)
    ! albAO : weighted albedo on sea-ice (2) or on open-water (1)
    real(kind = 8), save, allocatable :: albAO(:, :, :)
    ! UoceAO : surface ocean velocity along X-axis
    real(kind = 8), save, allocatable :: UoceAO(:, :)
    ! VoceAO : surface ocean velocity along Y-axis
    real(kind = 8), save, allocatable :: VoceAO(:, :)
    ! UiceAO : surface ice velocity along X-axis
    real(kind = 8), save, allocatable :: UiceAO(:, :)
    ! ViceAO : surface ice velocity along Y-axis
    real(kind = 8), save, allocatable :: ViceAO(:, :)
    ! srftAO : surf. temperature (K)
    real(kind = 8), save, allocatable :: srftAO(:, :, :)
    integer, save :: aoss
    integer, save :: aogla
    integer, save :: aoalb
    integer, save :: aotic
    integer, save :: aohic
    integer, save :: aohsn
    integer, save :: ao_uo
    integer, save :: ao_vo
    ! if gt 0 then MAR has receveid the field => update of the value
    integer, save :: ao_ui
    integer, save :: ao_vi
    ! fields used to feat the ocean/ice model
    ! =======================================
    ! hlatAO : downard latent turbulent heat flux (W.m-2)
    real(kind = 8), save, allocatable :: hlatAO(:, :, :)
    ! hsenAO : downard sensible turbulent heat flux (W.m-2)
    real(kind = 8), save, allocatable :: hsenAO(:, :, :)
    ! radsolAO : downard solar heat flux (W.m-2)
    real(kind = 8), save, allocatable :: radsolAO(:, :, :)
    ! radirAO : downard infrared heat flux (W.m-2)
    real(kind = 8), save, allocatable :: radirAO(:, :, :)
    ! radtotAO : downard total non solar heat flux (W.m-2)
    real(kind = 8), save, allocatable :: radtotAO(:, :, :)
    ! DFlAO : latent flux derivative /temperature (W.m-2.K-1)
    real(kind = 8), save, allocatable :: DFlAO(:, :, :)
    ! DFsAO : sensible flux derivative /temperature (W.m-2.K-1)
    real(kind = 8), save, allocatable :: DFsAO(:, :, :)
    ! DFiAO : infrared flux derivative /temperature (W.m-2.K-1)
    real(kind = 8), save, allocatable :: DFiAO(:, :, :)
    ! DFtotAO : total non solar heat flux derivative /temperature (W.m-2.K-1)
    real(kind = 8), save, allocatable :: DFtotAO(:, :, :)
    real(kind = 8), save :: normdUAO
    real(kind = 8), save, allocatable :: ievpAO(:, :)
    ! lp_accuAO,sp_accuAO,lprecipAO_t1,lprecipAO_t2,sprecipAO_t1,sprecipAO_t2
    !                 (usefull to express lprecip and sprecip in kg.m-2.s-1)
    real(kind = 8), save, allocatable :: lp_accuAO(:, :)
    real(kind = 8), save, allocatable :: sp_accuAO(:, :)
    ! evapAO : evaporation on ice or water (kg.m-2.s-1)
    real(kind = 8), save, allocatable :: evapAO(:, :)
    ! lprecipAO : liquid precipitation (kg.m-2.s-1)
    real(kind = 8), save, allocatable :: lprecipAO(:, :)
    real(kind = 8), save, allocatable :: lprecipAO_t1(:, :)
    real(kind = 8), save, allocatable :: lprecipAO_t2(:, :)
    ! sprecipAO : solid precipitation (kg.m-2.s-1)
    real(kind = 8), save, allocatable :: sprecipAO(:, :)
    real(kind = 8), save, allocatable :: sprecipAO_t1(:, :)
    real(kind = 8), save, allocatable :: sprecipAO_t2(:, :)
    ! upsnowAO : surface upward snow flux where sea ice (kg.m-2.s-1)
    ! UsrfAO : surface wind following the X-axis (m.s-1)
    real(kind = 8), save, allocatable :: UsrfAO(:, :)
    ! VsrfAO : surface wind following the Y-axis (m.s-1)
    real(kind = 8), save, allocatable :: VsrfAO(:, :)
    ! TauxuAO : weighted surface downward X-axis stress on U-grid (Pa)
    real(kind = 8), save, allocatable :: TauxuAO(:, :, :)
    ! TauyuAO : weighted surface downward Y-axis stress on U-grid (Pa)
    real(kind = 8), save, allocatable :: TauyuAO(:, :, :)
    ! TauxvAO : weighted surface downward X-axis stress on V-grid (Pa)
    real(kind = 8), save, allocatable :: TauxvAO(:, :, :)
    ! TauyvAO : weighted surface downward Y-axis stress on V-grid (Pa)
    real(kind = 8), save, allocatable :: TauyvAO(:, :, :)
    ! TauxtAO : weighted surface downward X-axis stress on T-grid (Pa)
    real(kind = 8), save, allocatable :: TauxtAO(:, :, :)
    ! TauytAO : weighted surface downward Y-axis stress on T-grid (Pa)
    real(kind = 8), save, allocatable :: TauytAO(:, :, :)
    ! usefull fields for coupling
    ! ===========================
    ! il_time_secs : time counter for coupling
    integer, save :: il_time_secs
    ! jtCpl : frequency of coupling (in time steps)
    integer, save :: jtCpl
    ! iH2O : time counter usefull for precip calculation
    integer, save :: iH2O
    integer, save :: info
    integer, save :: il_time_exp0
    integer, save :: tocken_AO
    ! t_Cpl : time between 2 intocpl call (s)
    real, save :: t_Cpl
    ! epsAO : emissivity
    real, save :: epsAO
    ! cpv : water vapor specific heat (J/kg/K)
    real, save :: cpv
    ! cpa : air specific heat (wet air) (J/kg/K)
    real, save :: cpa
    ! cpvir : [cpv/cp - 1] (usefull value for qsat) (-)
    real, save :: cpvir
    ! R_Rv : [gas cste dry air=287.0] / [gas cste moist air=461.5]
    real, save :: R_Rv
    ! uuao: uair_dy (u component of the wind) on a regular grid
    real, save :: uuao(mx, my)
    ! vvao: vair_dy (v component of the wind) on a regular grid
    real, save :: vvao(mx, my)
    logical coupling_ao
    real, save :: weightao(mx, my)
    real, save :: weightao_sst(mx, my)
    real, save :: weightao_sic(mx, my)
    real, save :: weightao_st(mx, my)
    real, save :: weightao_al(mx, my)
    real, save :: weightao_sit(mx, my)
    real, save :: weightao_snt(mx, my)
    character(len = 300) fileao

contains
    
    subroutine mar_ao_init()
        
        use mardim, only : mx, my, mw
        implicit none
        
        allocate(sicsAO(mx, my))
        allocate(hicAO(mx, my))
        allocate(hsnoAO(mx, my))
        allocate(albAO(mx, my, mw))
        allocate(UoceAO(mx, my))
        allocate(VoceAO(mx, my))
        allocate(UiceAO(mx, my))
        allocate(ViceAO(mx, my))
        allocate(srftAO(mx, my, mw))
        allocate(hlatAO(mx, my, mw))
        allocate(hsenAO(mx, my, mw))
        allocate(radsolAO(mx, my, mw))
        allocate(radirAO(mx, my, mw))
        allocate(radtotAO(mx, my, mw))
        allocate(DFlAO(mx, my, mw))
        allocate(DFsAO(mx, my, mw))
        allocate(DFiAO(mx, my, mw))
        allocate(DFtotAO(mx, my, mw))
        allocate(ievpAO(mx, my))
        allocate(lp_accuAO(mx, my))
        allocate(sp_accuAO(mx, my))
        allocate(evapAO(mx, my))
        allocate(lprecipAO(mx, my))
        allocate(lprecipAO_t1(mx, my))
        allocate(lprecipAO_t2(mx, my))
        allocate(sprecipAO(mx, my))
        allocate(sprecipAO_t1(mx, my))
        allocate(sprecipAO_t2(mx, my))
        allocate(UsrfAO(mx, my))
        allocate(VsrfAO(mx, my))
        allocate(TauxuAO(mx, my, mw))
        allocate(TauyuAO(mx, my, mw))
        allocate(TauxvAO(mx, my, mw))
        allocate(TauyvAO(mx, my, mw))
        allocate(TauxtAO(mx, my, mw))
        allocate(TauytAO(mx, my, mw))
    
    endsubroutine mar_ao_init

endmodule mar_ao
