subroutine MAR_2_OASIS
    ! +--------------------------------------------------------------------------+
    ! |                                                                1-12-2019 |
    ! |   subroutine MAR_2_OASIS transfers MAR variables to OASIS                |
    ! |                                                                          |
    ! |                                                                          |
    ! |      A chaque pas de tps, apres fromcpl, intocpl est appele ici;         |
    ! |      si il_time_secs correspond au pas de temps precedant le couplage,   |
    ! |      alors son action est effective        (via prism_put),              |
    ! |         et MAR envoie ses champs            via givfld (oasis)           |
    ! |                       a NEMO au pas de temps du couplage.                |
    ! |      L'appel a chaque pas de temps sert au moins au calcul de moyennes   |
    ! |                                            (cf AVERAGE dans namcouple)   |
    ! |                                                                          |
    ! |      cf mar_module.f90                                                   |
    ! |      cf OASIS-3 user guide (december 2004)                               |
    ! +--------------------------------------------------------------------------+
    USE mod_oasis
    USE mar_module

    use marctr
    use marphy
    use mardim
    use margrd
    use mar_ge
    use mar_dy
    use mar_hy
    use mar_ra
    use mar_sl
    use mar_ao
    use mar_wk

    implicit none

    ! +--MAR    Variables
    ! +  ----------------

    integer i, j, k, m, n

    ! +--cpl-1 Let's extract or calculate the usefull fields
    ! +  ===================================================

    if(iterun == 0) then
        write(6, *) 'Ini summed precip for OASIS'
        write(6, *) 'MAR first time step :  iterun = ', iterun
        do i = 1, mx; do j = 1, my
                lprecipAO_t2(i, j) = 0
                sprecipAO_t2(i, j) = 0
            enddo; 
        enddo
    endif

    !cleaning
    do i = 1, mx; do j = 1, my
            evapAO(i, j) = 0.
            ievpAO(i, j) = 0.
            lprecipAO(i, j) = 0.
            sprecipAO(i, j) = 0.
        enddo; 
    enddo

    !rotation of wind on a regular grid
    call wind_rot(UairDY(:, :, mz), VairDY(:, :, mz), uuao, vvao)

    do i = 2, mx - 1
        do j = 2, my - 1
            lprecipAO_t1(i, j) = lprecipAO_t2(i, j)                                          !total liq. precip since iterun=0 at dt-1
            lprecipAO_t2(i, j) = rainHY(i, j)                                                !total liq. precip since iterun=0 at dt
            lprecipAO(i, j) = (lprecipAO_t2(i, j) - lprecipAO_t1(i, j))                        !liquid precip between dt-1 and dt (mm.w.e)

            sprecipAO_t1(i, j) = sprecipAO_t2(i, j)                                          !total sol. precip since iterun=0 dt-1
            sprecipAO_t2(i, j) = snowHY(i, j) + crysHY(i, j)                                    !total sol. precip since iterun=0 (at itexpe)
            sprecipAO(i, j) = (sprecipAO_t2(i, j) - sprecipAO_t1(i, j))                        !solid  precip between dt-1 and dt (mm.w.e)

            !Conversion m.w.e to kg.m-2.s-1
            lprecipAO(i, j) = lprecipAO(i, j) * 1000./dt
            sprecipAO(i, j) = sprecipAO(i, j) * 1000./dt

            ! for blowing snow ?
            !            if (sprecipAO(i,j).ge.0.) then
            !                 upsnowAO(i,j) =  0.
            !            else
            !                 upsnowAO(i,j) = -sprecipAO(i,j)
            !                sprecipAO(i,j) =  0.
            !            end if

            evapAO(i, j) = -SLuqsl(i, j, 1) * rolvDY(i, j, mz) * 1.e3                       !evaporation over ocean (negative, kg.m-2.s-1)
            ievpAO(i, j) = -SLuqsl(i, j, 2) * rolvDY(i, j, mz) * 1.e3                       !sublimation over sea ice (negative, kg.m-2.s-1)
            evapAO(i, j) = evapAO(i, j) + ievpAO(i, j)                                     !Evap total (ocean + sublimation)

            !Utilise maintenant vent rot au lieu de uairDY, vairDY

            do n = 1, 2
                if(n == 1) then ! ocean
                    cpa = cp * (1 + qvswDY(i, j, mz) * cpvir)

                    ! downward solar (W.m-2)
                    radsolAO(i, j, n) = RAdsol(i, j) * (1.0 - albAO(i, j, n))
                    ! downward IR (net, W.m-2)
                    radirAO(i, j, n) = RAd_ir(i, j) &
                                       - EmiWatao * stefan * tsrfsl(i, j, n)**4
                    ! downward sensible (W.m-2)
                    hsenAO(i, j, n) = SLutsl(i, j, n) * cpa * rolvDY(i, j, mz) * 1.e3
                    ! downward latent (W.m-2)
                    hlatAO(i, j, n) = SLuqsl(i, j, n) * rolvDY(i, j, mz) * 1.e3 * Lv_H2O
                    ! downward non solar (W.m-2)
                    radtotAO(i, j, n) = radirAO(i, j, n) &
                                        + hsenAO(i, j, n) &
                                        + hlatAO(i, j, n)

                    ! UoceAO en dehors de domaine NEMO mais dans MAR = valeur plus proche voisin
                    ! dans NEMO lors du couplage. Evite les 0 sur les bords?

                    normdUAO = sqrt((uuao(i, j) - UoceAO(i, j))**2 &
                                    + (vvao(i, j) - VoceAO(i, j))**2)
                    ! wind stress on T grid (N.m-2)
                    TauxtAO(i, j, n) = cdmSL(i, j, n)**2 * normdUAO * rolvDY(i, j, mz) &
                                       * (uuao(i, j) - UoceAO(i, j)) * 1.e3
                    TauytAO(i, j, n) = cdmSL(i, j, n)**2 * normdUAO * rolvDY(i, j, mz) &
                                       * (vvao(i, j) - VoceAO(i, j)) * 1.e3

                endif
                if(n == 2) then ! sea ice
                    ! moist air heat capacity for ice
                    cpa = cp * (1 + qvsiDY(i, j, mz) * cpvir)

                    ! downward solar (W.m-2)
                    radsolAO(i, j, n) = RAdsol(i, j) * (1.0 - albAO(i, j, n))
                    ! downward IR (net, W.m-2)
                    radirAO(i, j, n) = RAd_ir(i, j) &
                                       - Emisnoao * stefan * tsrfsl(i, j, n)**4
                    ! downward sensible (W.m-2)
                    hsenAO(i, j, n) = SLutsl(i, j, n) * cpa * rolvDY(i, j, mz) * 1.e3
                    ! downward latent (W.m-2)
                    hlatAO(i, j, n) = SLuqsl(i, j, n) * rolvDY(i, j, mz) * 1.e3 * Ls_H2O
                    ! downward non solar (W.m-2)
                    radtotAO(i, j, n) = radirAO(i, j, n) &
                                        + hsenAO(i, j, n) &
                                        + hlatAO(i, j, n)

                    ! Derivee des flux non solaire selon la temperature pour eviter les oscillations
                    ! latent flux derivative/T Clausius-Clapeyron for Dqsat/DT
                    DFlAO(i, j, n) = -rolvDY(i, j, mz) * SLuusl(i, j, n) &
                                     * cdhSL(i, j, n) * R_Rv * 1.e3 &
                                     * (Ls_H2O)**2 &
                                     * (qvsiDY(i, j, mzz)) &
                                     / (RDryAi * tsrfsl(i, j, n)**2)
                    ! sensible flux derivative/T
                    DFsAO(i, j, n) = -rolvDY(i, j, mz) * cpa * 1.e+3 &
                                     * cdhSL(i, j, n) * SLuusl(i, j, n)
                    ! IR flux derivative/T
                    DFiAO(i, j, n) = -4 * epsAO * stefan * tsrfsl(i, j, n)**3
                    !  total         derivative/T
                    DFtotAO(i, j, n) = DFlAO(i, j, n) + DFsAO(i, j, n) + DFiAO(i, j, n)

                    ! UiceAO ViceAO en dehors de domaine NEMO mais dans MAR = valeur plus proche
                    ! voisin dans NEMO lors du couplage. Evite les 0 sur les bords?
                    normdUAO = sqrt((uuao(i, j) - UiceAO(i, j))**2 &
                                    + (vvao(i, j) - ViceAO(i, j))**2)

                    !uairday and vairday has been changed by rorated wind
                    !wind stress on T grid (N.m-2)
                    TauxtAO(i, j, n) = cdmSL(i, j, n)**2 * normdUAO * rolvDY(i, j, mz) &
                                       * (uuao(i, j) - UiceAO(i, j)) * 1.e3
                    TauytAO(i, j, n) = cdmSL(i, j, n)**2 * normdUAO * rolvDY(i, j, mz) &
                                       * (vvao(i, j) - ViceAO(i, j)) * 1.e3

                endif

            enddo

        enddo
    enddo

    do n = 1, 2
        do i = 1, mx - 1
            do j = 1, my - 1
                TauxuAO(i, j, n) = 0.5 * (TauxtAO(i, j, n) + TauxtAO(i + 1, j, n)) ! U grid
                TauyuAO(i, j, n) = 0.5 * (TauytAO(i, j, n) + TauytAO(i + 1, j, n)) ! U grid
                TauxvAO(i, j, n) = 0.5 * (TauxtAO(i, j, n) + TauxtAO(i, j + 1, n)) ! V grid
                TauyvAO(i, j, n) = 0.5 * (TauytAO(i, j, n) + TauytAO(i, j + 1, n)) ! V grid
            enddo
        enddo
        do i = 1, mx !bord des grilles
            TauxvAO(i, my, n) = TauxtAO(i, my, n)
            TauyvAO(i, my, n) = TauxtAO(i, my, n)
        enddo
        do j = 1, my
            TauxuAO(mx, j, n) = TauxtAO(mx, j, n)
            TauyuAO(mx, j, n) = TauxtAO(mx, j, n)
        enddo
    enddo

    do i = 1, mx
        do j = 1, my
            do n = 1, 2
                if(maskSL(i, j) /= 1) then
                    TauxuAO(i, j, n) = 0.
                    TauyuAO(i, j, n) = 0.
                    TauxvAO(i, j, n) = 0.
                    TauyvAO(i, j, n) = 0.
                    DFtotAO(i, j, n) = 0.
                endif
            enddo
        enddo
    enddo

    ! +--cpl-2 Now let's give the fields to oasis
    ! +  ========================================

    il_time_secs = iterun * idt
    ! temps en sec depuis le debut du run, au pas precedant
    !        write(*, *) '     call intocpl, itexpe =', itexpe !for debug

    call intocpl(il_time_secs, radsolAO(:, :, 2), radsolAO(:, :, 1), &
                 radtotAO(:, :, 2), radtotAO(:, :, 1), DFtotAO(:, :, 2), &
                 evapAO, lprecipAO, sprecipAO, &
                 ievpAO, &
                 TauxuAO(:, :, 1), TauxuAO(:, :, 2), &
                 TauyuAO(:, :, 1), TauyuAO(:, :, 2), &
                 TauxvAO(:, :, 1), TauxvAO(:, :, 2), &
                 TauyvAO(:, :, 1), TauyvAO(:, :, 2))
    ! +  *******

    return
endsubroutine MAR_2_OASIS

