module mar0sv
    use mardim
    use mar_sv
    use mardsv
    implicit none
    integer, save :: islpSV(-nsol:0)
    integer, save :: isnpSV(nsno)
    integer, save :: islmSV(-nsol:0)
    integer, parameter :: nkhy = 50
    real, save :: Implic, Explic
    ! dzmiSV : dz_(i-1/2)
    real, save :: dzmiSV(-nsol:0)
    ! dzi_SV : dz_(i-1)/(dz_(i)+dz_(i-1))
    real, save :: dzi_SV(-nsol:0)
    ! dziiSV : dz_(i)  /(dz_(i)+dz_(i-1))
    real, save :: dziiSV(-nsol:0)
    ! dtz_SV : dt / dz
    real, save :: dtz_SV(-nsol:0)
    ! dtz_SV2 : dt / dz
    real, save :: dtz_SV2(-nsol:0)
    ! dz78SV : 7/8 (dz)
    real, save :: dz78SV(-nsol:0)
    ! dz34SV : 3/4 (dz)
    real, save :: dz34SV(-nsol:0)
    ! dz_8SV : 1/8 (dz)
    real, save :: dz_8SV(-nsol:0)
    ! dzAvSV : 1/8dz_(-1)+3/4dz+1/8dz_(+1)
    real, save :: dzAvSV(-nsol:0)
    ! OcndSV : Swab Ocean / Soil Ratio
    real, save :: OcndSV
    ! RF__SV : Root Fraction
    real, save :: RF__SV(0:nvgt, -nsol:0)
    ! rocsSV : Soil Contribution to (ro c)_s
    real, save :: rocsSV(0:nsot)
    ! etamSV : Soil Minimum Humidity
    real, save :: etamSV(0:nsot)
    ! s1__SV : ... X eta**( b+2), DR97(3.36)
    real, save :: s1__SV(0:nsot)
    ! s2__SV : ... X eta**(2b+3), DR97(3.35)
    real, save :: s2__SV(0:nsot)
    ! aKdtSV : Khyd=a*eta+b: a * dt
    real, save :: aKdtSV(0:nsot, 0:nkhy)
    ! bKdtSV : Khyd=a*eta+b: b * dt
    real, save :: bKdtSV(0:nsot, 0:nkhy)
    ! aKdtSV2 : Khyd=a*eta+b: a * dt
    real, save :: aKdtSV2(0:nsot, 0:nkhy)
    ! bKdtSV2 : Khyd=a*eta+b: b * dt
    real, save :: bKdtSV2(0:nsot, 0:nkhy)
endmodule mar0sv
