#include "MAR_pp.def"
! +************************************************************************+
! |                                                                        |
! |                                                                        |
! |                                                                        |
! |                                                                        |
! |                                                                        |
! |                                                                        |
! |                                                                        |
! |               M        M       AAAAAAA        RRRRRRR                  |
! |               MM      MM      A       A      R       R                 |
! |               M M    M M      A       A      R       R                 |
! |               M  M  M  M      A       A      R       R                 |
! |               M   MM   M      A AAAAA A      R RRRRR R                 |
! |               M        M      A       A      R R                       |
! |     (MODELE tridimensionnel ATMOSPHERIQUE a l'echelle REGIONALE)       |
! |               M        M      A       A      R   R                     |
! |               M        M      A       A      R    R                    |
! |               M        M      A       A      R     R                   |
! |               M        M      A       A      R      R                  |
! |                                                                        |
! |                 \__ _                    ____ /                        |
! |               \_/     @@@@              /    \                         |
! |               / \    @@@@@@            /    / \                        |
! |              /   \  @@@@@@            |    /   |                       |
! |                    ... ***             \  /   / LGGE/IGE/LSCE/CNRS     |
! |                   .... **               \/___/                         |
! |                  .... **                / IAG/UCL  ULIEGE/FNRS         |
! |                                                                        |
! |   Laboratoire de Glaciologie et de Geophysique de l'Environnement      |
! |      Institut d'Astronomie   et de Geophysique Georges Lemaitre        |
! |   Laboratoire d'etudes des Transferts en Hydrologie et Environnement   |
! |                                                                        |
! |                                                                        |
! |                                                                        |
! +************************************************************************+
! |                                                                        |
! | Version: see below                                                     |
! |                                                                        |
! +************************************************************************+
! |                                                                        |
! |     MAR CURRENT CONTRIBUTORS:                                          |
! |                                                                        |
! | H. Gallee, X. Fettweis, C. Agosta,  C. Amory, C. Kittel, ...           |
! |                                                                        |
! +************************************************************************+
! |                                                                        |
! | SUMMARY : THE MODEL USES THE FULL COMPRESSIBLE PRIMITIVES EQUATIONS    |
! | ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^    |
! |                                                                        |
! | Vertical Coordinate : Normalized Pressure Sigma                        |
! | Horizontal Grid     : Arakawa A-grid                                   |
! |                       (Purser and Leslie, MWR 116, 2069--2080, 1988)   |
! | Modes : 1-Dimensional (mx=1,my=1,mz) OR                                |
! | ^^^^^^^ 2-Dimensional (mx  ,my=1,mz) OR                                |
! |         3-Dimensional (mx  ,my  ,mz)                                   |
! |             Condition  mx > my       must be fulfilled in this case    |
! |                       (cfr."MARdim.inc")                               |
! |                                                                        |
! +************************************************************************+
! |                                                                        |
! | THE FILE MAR___.FOR contains the BASIC SOURCE CODE                     |
! | ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^                     |
! |                                                                        |
! | It may be used as is in 1-D, 2-D or 3-D Mode                           |
! | It may be modified in order to allow other possibilities.              |
! |    Modifications are performed by replacing labels `c #XY' by blanks.  |
! |   (see Preprocessor MAR_pp.for)                                        |
! |                                                                        |
! | #    MAIN       OPTIONS:                                               |
! | #^^^^^^^^^^^^^^^^^^^^^^^                                               |
! |                                                                        |
! | #     ADDITIONAL OPTIONS: Dynamics                                     |
! | #^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^                                     |
! |                                                                        |
! | #     ADDITIONAL OPTIONS: Sea, Polynya and Snow Models                 |
! | #^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^                 |
! |                                                                        |
! | #     ADDITIONAL OPTIONS:                                              |
! | #^^^^^^^^^^^^^^^^^^^^^^^^                                              |
! |                                                                        |
! | #     ADDITIONAL OPTIONS: BOUNDARY CONDITIONS                          |
! | #^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^                          |
! |                                                                        |
! | #     ADDITIONAL OPTIONS: CONVECTIVE ADJUSTMENT                        |
! | #^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^                        |
! |                                                                        |
! | #     ADDITIONAL OPTIONS: VERTICAL  TURBULENCE                         |
! | #^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^                         |
! |                                                                        |
! | #     ADDITIONAL OPTIONS: SURFACE LAYER                                |
! | #^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^                                |
! |                                                                        |
! | #     ADDITIONAL OPTIONS: HORIZONTAL DifFUSION                         |
! | #^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^                         |
! |  !. `Standard' Horizontal Diffusion is performed on Sigma Surfaces     |
! |  !.  Smagorinski Relation (see Tag et al. 1979, JAM 18, 1429--1441)    |
! |  !.  CAUTION: Horizontal Diffusion is switched on with turhor = .true. |
! |  2.      _PE, _HH,     : Diffus.on Sigma Surfaces (%Grad.) +Vert.Corr. |
! |  3.      _PE, _HH, #CR : Diffus.on Sigma Surfaces (%Grad.) +all  Corr. |
! |  4. #DF, #PE,          : Diffus.on Sigma Surfaces (%Strain)+Vert.Corr. |
! |  5. #DF, #PE, #DC, #CR : Diffus.on Sigma Surfaces (%Strain)+all  Corr. |
! |                          (#DC -> u,v; #CR -> other Variables)          |
! |  CAUTION: if #QE, then #qe MUST BE SWITCHED ON before 2, 3, 4 OR 5     |
! |  ^^^^^^^  if #HY, then #se MUST BE SWITCHED ON before 2, 3, 4 OR 5     |
! |                                                                        |
! +************************************************************************+

program MAR
    use mardim
#ifdef AO
    ! Coupling Module / OASIS
    ! ========================
    !AO_CK 20/02/2020
    use mod_OASIS
    use mar_module
    ! USE flincom            !CK??
#endif
    use marctr
    use marphy
    use margrd
    use mar_ge
    use marsnd
    use mar_dy
    use marqqm
#ifdef NH
    use mar_nh
#endif
    use mar_lb
    use mar_ub
    use mar_te
    use mar_tu
    use mar_ca
    use mar_fi
    use mar_hy
#ifdef TC
    use mar_tc
#endif
    use mar_ra
    use mar_sl
#ifdef AO
    use mar_ao
#endif
    use mar_wk
    use mar_sv
    use mardsv
    use mar_tv
    use marlsv
    use marssn
    use mar_ib
    use mar_io
    use marmagic
#ifdef RM
    use radcep
#endif
    use marvec
    use trackwind, only : track_wind, delta_u, delta_v, uairDY_save, vairDY_save, &
                         i_dyndgz, i_dynfil, i_coriol, i_turhor, i_turabl, i_lbcnud, trackwind_init
    use trackwater, only: track_water, delta_qv, qvDY_save, trackwater_init, &
                          j_dynadv, j_turhor, j_turabl, j_sspray, j_hydgen, j_lbcnud, j_cvagen

#ifdef iso
    use mariso, only : mariso_constants
#endif
    implicit none

#ifdef iso
    ! iso_time : number of the output file increment
    integer :: iso_time
    ! iso_label : label of output increment
    character*10 :: iso_label
#endif
    ! +--Local  Variables
    ! +  ================
    integer ipr_nc
    logical qqmass
    integer norder_0
    integer newlbc_0
    real rhcrit_0
    real tstart_0
    character * 3 DYNadv
    real dt_inv, dtLLoc, dtDifH, dt_Out, deltaF, cfladv, csnd
    real hham, hhac, fham, thac, argham, hhhnnn, tdt, afdt
    real pav, ppp, wwwabs, wwwmax, ectnew, pente, dthdz, adum, adu
    real pnhLav, pnh_av, ave_swd
    integer i, j, k, m
    integer n, mlg, mlh, mlm, mld, iargum, i__min, i__max
    integer kk, kdim, ksig, iv, iw
    integer nt_Loc, jt_Loc, it_Loc, ntLLoc, itLLoc, itPhys
    integer iham, nham, ihamr, nhamr, jham, ibd
    integer jmmd, jm10, jh10, jh1, jd10, jd1
    integer iteChi
    integer iprint, log_nc
    integer iout, idum, jdum, id6, i_wmax, j_wmax, k_wmax
    integer ntracr, lotrac
    ! Auxil. Variables (variable nt_Mix)
    logical ntFlog
    integer nt_BAK, nt_sig, nt_smooth, nt_Mix_min
    integer nt_Mix_nbr(20), nt_tmp1, nt_tmp2
    real VLoc, VLocmx, rtFact, CFLinv, TLocmn
    integer iLocmx, jLocmx, kLocmx
    ! DistST: Normalized Earth's Sun Distance
    real DistST
    character(len = 8) ttime
    ! +--Check openmp
    ! +  ------------
    integer number_threads
    integer omp_get_thread_num, omp_get_max_threads
    ! +--Vertically Integrated Normalized Mass Flux
    ! +  ------------------------------------------
    real fu(mx, my), fv(mx, my)
    ! +--Machine Precision
    ! +  -----------------
    real reamin, reamax
    ! +--IO
    ! +  --
    real zza(5)
    real tta(5)

    ! MAR allocate
    call mar_allocate()
 
    ! +--Flags
    ! +  =====
    openmp = .false.
    !$  openmp = .true.
    ini_KA_TE = .false.
    VSISVAT = .true.
    iniIRs = .false.
    iniOUT = .false.
    ! +--Blowing Snow
    ! +  ~~~~~~~~~~~~
    BloMod = .false.
#ifdef AE
    BloMod = .true.
#endif
    ! +--Advection
    ! +  ~~~~~~~~~
    DYNadv = 'LFB'
#ifdef UW
    DYNadv = 'UPW'
#endif
    no_vec = .true.
    ntFlog = .false.
    openLB = .false.
    sommlb = .false.
    ! SBLitr=.true. ==> SBL is iterated
    SBLitr = .true.
    tur_25 = .false.
    ! +--CONSTANTS
    ! +  =========
    ntracr = 0
#ifdef TC
    ntracr = ntrac
#endif
    ! +--Grid Constants
    ! +  --------------
    rxy = 1.e-6 / (mx * my)
    m = mx
    m1 = m - 1
    m2 = m - 2
    m3 = m - 3
    m4 = m - 4
    mn3 = mn - 3
    mn4 = mn - 4
    
    ttime = '        '

    write(6, *) "                                     "
    write(6, *) " *********************************** "
    write(6, *) " *                                 * "
    write(6, *) " *  MM      MM   AAAA   RRRRRR     * " 
    write(6, *) " *  MMMM  MMMM AA    AA RR    RR   * " 
    write(6, *) " *  MM  MM  MM AAAAAAAA RRRRRR     * "
    write(6, *) " *  MM      MM AA    AA RR  RR     * "
    write(6, *) " *  MM      MM AA    AA RR    RR   * "
    write(6, *) " *                                 * "
    write(6, *) " *  Modele Atmospherique Regional  * "
    write(6, *) " *                                 * "
    write(6, *) " *********************************** "
    write(6, *) "                                     "
                                    verGE="3.14.3"
    write(6, *) "     - MARv"//trim(verGE)//" - 23/06/2025 -     "
    write(6, *) "                                     "

    
    !$  number_threads = omp_get_max_threads()
    
    write(6, 7) "                     OMP CPU=", number_threads
    write(6, 7) "                          mx=", mx
    write(6, 7) "                          my=", my
    write(6, 7) "                          mz=", mz
    write(6, 7) "                          mw=", mw
    write(6, 7) "                        nsno=", nsno
    write(6, 7) "                      mzabso=", mzabso
    write(6, 7) "                       mzhyd=", mzhyd
    write(6, *) ""
    write(6, 8) "              humidity_magic=", humidity_magic
    write(6, 8) "                 cloud_magic=", cloud_magic
    write(6, 8) "correction_humidity_boundary=", correction_humidity_boundary
#ifdef RM
    write(6, *) "           radiative scheme= radCEP (old)"
#endif
#ifdef RE
    write(6, *) "           radiative scheme= EcRad (new)"
#endif
    write(6, *) ""
    
    if(cloud_magic < 0 .or. cloud_magic > 1 .or. humidity_magic < 0) then
        print *, "error in cloud_magic [0,1] or humidity_magic [0,100]"
        stop
    endif
    
    if(correction_humidity_boundary < -0.5 .or. correction_humidity_boundary > 0.5) then
        print *, "error in correction_humidity_boundary [-0.5,0.5]"
        stop
    endif
    
    if(klonv > 1 .or. klon > 1) then
        print *, "klonv/klon must be = 1 in mar_sv_mod.f90/MARdim_mod.f90"
        stop
    endif
    
    7   format(a29, i4)
    8   format(a29, f6.2)
    
    ! +--Machine Precision
    ! +  =================
    rrmin = 0.1e-36
    rrmax = 0.1e+38
    
    ! +--Min and Max Arguments of Function exp(x)
    ! +  ----------------------------------------
    argmin = log(rrmin)
    iargum = argmin
    i__min = iargum + 7
    argmax = log(rrmax)
    iargum = argmax
    i__max = iargum - 8
    ! write(6,600) argmin,i__min,argmax,i__max
    ! 600  format(/, ' Function  exp(x)    :   Arguments:', &
    !         /, ' Minimum Value       : ', e12.4, 5x, '==> (', i3, ')', &
    !         /, ' Maximum Value       : ', e12.4, 5x, '==> (', i3, ')')
    argmin = i__min
    argmax = i__max
    
    ! +--PHYSICAL DATA
    ! +  =============
    ! +  ******
    call phymar
    ! +  ******
#ifdef iso
    ! iso constants
    call mariso_constants
#endif
    
    ! +--CONTROL PARAMETERS
    ! +  ==================
    open(unit = 3, status = 'old', file = 'MARctr.dat')
    rewind 3
    read(3, 31) reaVAR, reaLBC, safVAR
    31  format(l12)
    if(.not. reaVAR) geoNST = .false.
    ! hamfil: Initialisation based on Temporal Filtering  (Hamming)
    read(3, 31) hamfil
    ! conmas: Initialis. Constrained (Mass            Conservation)
    read(3, 31) conmas
    ! potvor: Initialis. Constrained (Potent. Vortic. Conservation)
    read(3, 31) potvor
    ! brocam: Brown and Campana Time Scheme Switch
    read(3, 31) brocam
    ! center=.T. => Pressure Spatial Scheme  centered
    read(3, 31) center
    ! nordps= 4  :  Pressure Spatial Scheme Precision
    read(3, 32) nordps
    ! staggr=.T. => Vertical  Grid staggered
    read(3, 31) staggr
    32  format(i12)
    ! turhor=.T.: Horizontal Diffusion (Smagorinsky) Switch
    read(3, 31) turhor
    ! chimod=.F.: Atmospheric Chemical Model  turned OFF
    ! chimod=.T.: Atmospheric Chemical Model  turned ON
    read(3, 31) chimod
    ! convec=.T.: Mass Flux convective Scheme turned ON
    read(3, 31) convec
    ! micphy=.F.: only the dry model is run
    ! micphy=.T.: the explicit hydrological cycle is included
    read(3, 31) micphy
    ! fracld=.T.: Fraction.Cloudiness Scheme  turned ON
    read(3, 31) fracld
    ! rhcrit_0: relative humidity critical saturation value
    read(3, 43) rhcrit_0
    ! rhcrHY: relative humidity critical saturation value
    rhcrHY = rhcrit_0
    !CAa:[TO DO] -> to be changed to accept supersaturation?
    if(rhcrHY > 1.) then
        write(6, 300) rhcrHY
        300     format(/, ' *********************************************************************', &
                /, ' * Critical Humidity =', f6.2, ' [%] / new units: [-] => divide by 100 *', &
                /, ' *********************************************************************', /, 1x)
        rhcrHY = rhcrHY * 10.**(-2)
    endif
    read(3, 43) tstart_0
    ! tim_HY: hydrological cycle starting time (prefarably uses 0.)
    tim_HY = tstart_0
    43  format(f12.4)
    ! cz0_GE : Cosine  of Solar Zenith Angle (Minimum Value for solari call)
    read(3, 34) cz0_GE
    34  format(d12.4)
    ! physic: Physics are included
    read(3, 31) physic
    ! vegmod =.true. : Interactive SVAT turned ON
    read(3, 31) vegmod
    if(.not. physic) vegmod = .false.
    ! snomod =.true. : Interactive Snow Model turned ON
    read(3, 31) snomod
    if(.not. physic) snomod = .false.
    ! polmod =.true. : Interactive Polynya Dynamics turned ON
    read(3, 31) polmod
    ! hic0   : assumed initial sea-ice Thickness
    read(3, 43) hic0
    ! fxlead : assumed initial minimal Leads Fraction
    read(3, 43) fxlead
    ! qsolSL: Deardorff model for soil humidity
    read(3, 31) qsolSL
    read(3, 43) dt
    dt_inv = 1.0 / dt
    ! nboucl : nb of time steps between each print
    read(3, 32) nboucl
    read(3, 32) nprint
    read(3, 32) ntFast
    if(mod(ntFast, 2) == 0) then
        write(6, 301) ntFast
        301     format(/, ' *******************************************************************', &
                /, ' * Value of   ntFast =', i6, ' is even (precluded) =====> 1 is added *', &
                /, ' *******************************************************************', /, 1x)
        ! Fixed ntFast
        ntFast = ntFast + 1
    endif
    ! XF no usefull to have ntFast=3
    ntFast = 1
    itexpe = 0
    ! variable nt_Mix
    nt_Mix = 3
    nt_Mix_min = 1
    nt_Mix_nbr = 0
    nt_smooth = 0
    ! dtDiff : Calibrated Subgrid Scale Time Step
    read(3, 43) dtDiff
    ! dtPhys : Surface Physics Time Step
    read(3, 43) dtPhys
    ! dtRadi : Radiation Time Step
    read(3, 43) dtRadi
    ! rxbase : Nudging Coefficient
    read(3, 34) rxbase
    ! rxfact : Lateral Sponge Coefficient
    read(3, 34) rxfact
    close(unit = 3)
    
    ! +--New Control Parameters
    ! +  ----------------------
#ifdef NH
    ! +--Non-Hydrostatic Dynamics
    ! +  ~~~~~~~~~~~~~~~~~~~~~~~~
    ! csnd: Prescribed Sound Speed (m/s)
    csnd = 330.
    c2NH = csnd * csnd
#endif
    ! +--Chemical Model
    ! +  ~~~~~~~~~~~~~~
    lotrac = 0
#ifdef TC
    lotrac = 1
    jtAdvH = 1
    dtAdvH = dt
    jt_ODE = 1
    if(.not. chimod) then
        dt_ODE = dt
        jt_ODE = 1
        nt_ODE = 1
        ikTC(1) = 1
    endif
#endif
    ! +--Print Characteristic
    ! +  --------------------
    if(nprint < 0) then
        nprint = -nprint
        log_nc = 1
    else
        log_nc = 0
    endif
    log_nc     = 1

    ! ipr_nc (npr_nc): Netcdf Output File: Current No (Total Nb) of Prints
    ipr_nc = 0
    npr_nc = 1 + nprint
    nterun = nboucl * nprint
#ifdef AO
    !$OMP BARRIER
    !$OMP MASTER
    ! +-- Initialize coupling  (cpl)
    ! +   ==========================
    coupling_ao = .false.
    write(6, *) 'Initialize coupling in MAR'
    ! inicma : Define coupling fields in MAR
    ! coupling_ao => .true.
    ! +   *****
    call inicma
    ! +   *****
    if(coupling_ao) then
        write(6, *) 'Coupling initialization done in MAR'
        write(6, *) coupling_ao
        ! else
        !   write(6,*) 'error in coupling init', coupling_ao
        !   stop
    endif
    !$OMP END MASTER
    !$OMP BARRIER
#endif
    ! +--OUTPUT Files
    ! +  ============
    open(unit = 4, status = 'replace', file = 'MARphy.out')
    rewind 4
    open(unit = 21, status = 'new', file = 'MAR.log')
    rewind 21
    
    ! +--Katabatic Jump Diagnostics
    ! +  --------------------------
    if(mx > 1 .and. my <= 1) then
        open(unit = 22, status = 'unknown', file = 'MAR.uuu')
        rewind 22
        open(unit = 23, status = 'unknown', file = 'MAR.ttt')
        rewind 23
        open(unit = 24, status = 'unknown', file = 'MAR.ppp')
        rewind 24
    endif
    
    ! ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    ! +++ INITIALISATION +++++++++++++++++++++++++++++++++++++++++++++++++++++++
    ! ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    !$OMP BARRIER
    !$OMP MASTER
    ! +  ******
    call inigen
    ! +  ******
    !$OMP END MASTER
    !$OMP BARRIER
    if(track_wind) then
        call trackwind_init()
    endif
    if(track_water) then
        ! allocate and set water budget variables to zero before time loop
        call trackwater_init()
    end if

#ifdef iso
    ! iso outputs
    call mariso_create_file
    ! initialize output file time increment
    iso_time = 1
    iso_label = 'create    '
    call mariso_write_file(iso_time, iso_label) ! 1
#endif
    
    ! +--PBL Initialization Parameter
    ! +  ============================
    if(itexpe <= 0) then
        log_1D = 0
    else
        log_1D = 1
    endif
    
    ! +--HAMMING Filter Parameters
    ! +  =========================
    iham = 0
    nham = 0
    
    ihamr = iham
    nhamr = nham
    
    ! +--Domain Averaged Pressure Thickness
    ! +  ==================================
    pav = 0.
    do j = 1, my
        do i = 1, mx
            pav = pav + pstDYn(i, j)
        enddo
    enddo
    pav = pav / (mx * my)
    
    ! +--OUTPUT
    ! +  ======
    if(IO_loc >= 2) then
        do i = 1, 5
            tta(i) = tsrfSL(igrdIO(i), jgrdIO(i), 1) - TfSnow
        enddo
        write(21, 607)(igrdIO(i), jgrdIO(i), i = 1, 5), &
                (sh(igrdIO(i), jgrdIO(i)), tta(i), i = 1, 5)
        607     format(//, 5(5x, ' (', i4, ',', i4, ')', 5x, '!! '), &
                /, 5(' altitude ! temperat. ', '!! '), &
                /, 5(10('-'), '!', 11('-'), '!!-'), &
                /, 5(f8.1, '  ! ', f8.2, '  !! '))
        do kk = 1, mz
            k = mz + 1 - kk
            do i = 1, 5
                zza(i) = gplvDY(igrdIO(i), jgrdIO(i), k) * grvinv
                tta(i) = pktaDY(igrdIO(i), jgrdIO(i), k) * pcap
            enddo
            write(21, 609)(zza(i), tta(i), i = 1, 5)
            609         format(5(f8.1, '  ! ', f8.2, '  !! '))
        enddo
        write(21, 611)
        611     format(1x)
    endif
    
    if(mmx > 1 .and. mmy <= 1) then
        write(22, 221) itexpe, (xxkm(i), i = imez - 10, imez + 30)
        write(23, 221) itexpe, (xxkm(i), i = imez - 10, imez + 30)
        write(24, 221) itexpe, (xxkm(i), i = imez - 10, imez + 30)
    endif
    
    ! +--NetCDF Files
    ! +  ------------
    nbhour = 0
    do while(mod(3600 * nbhour, idt) /= 0)
        !CAa 1  continue
        nbhour = nbhour + 1
    enddo
    !CAa if (mod(3600 * nbhour, idt)/=0) go to 1
    if(log_nc == 1) then
        dt_Loc = dt
        ipr_nc = ipr_nc + 1
        ! +  ******
        call out_nc(ipr_nc)
        ! +  ******
    endif
    
    ! ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    ! +++ BEGIN of the EXTERNAL TIME INCREMENTATION (nprint over dt * nboucl) ++
    ! ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    
    do iprint = 0, nprint - 1
        ! +--Output Files Label
        ! +  ==================
        fnam(1:3) = 'si_'
        jmmd = 1 + mod(minuGE, 10)
        jm10 = 1 + minuGE / 10
        jh10 = 1 + jhaMAR / 10
        jh1 = 1 + mod(jhaMAR, 10)
        jd10 = 1 + jdaMAR / 10
        if(jd10 > 10) then
            fnam(3:3) = '+'
            jd10 = mod(jd10, 10)
        endif
        jd1 = 1 + mod(jdaMAR, 10)
        fnam(4:4) = labnum(jd10)
        fnam(5:5) = labnum(jd1)
        fnam(6:6) = labnum(jh10)
        fnam(7:7) = labnum(jh1)
        fnam(8:8) = labnum(jm10)
        fnam(9:9) = labnum(jmmd)
        fnam(10:10) = '.'
        fnam(11:13) = explIO
        fnam(14:16) = '   '
        
        ! ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        ! +++ BEGIN of the INTERNAL TIME INCREMENTATION (nboucl over dt) +++++++++++
        ! ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        !CAa iboucl = 1
        !CAa 2  continue
        do iboucl = 1, nboucl
#ifdef AO
            ! +--cpl : GET FIELDS FROM OASIS
            ! +  ===========================
            !$OMP BARRIER
            !$OMP MASTER
            ! +  ***********
            call OASIS_2_MAR
            ! +  ***********
            !$OMP END MASTER
            !$OMP BARRIER
#endif
#ifdef SB
            ! +--Modification of the Surface Forcing
            ! +  ===================================
            ! +  ******
            call sbcnew
            ! +  ******
#endif
#ifdef iso
            iso_label = 'sbcnew    '
            iso_time = iso_time + 1
            call mariso_write_file(iso_time, iso_label) ! 2
#endif(iso)
            
            ! +  ******
            call filatmo
            ! +  ******
            
            if(iterun <= 1 .or. mod(iterun, 6 * 3600 / int(dt)) == 0) call time_steps
            
            if(itexpe <= 1) then
                do j = 1, my
                    do i = 1, mx
                        do k = 1, mw
                            if(ivegTV(i, j, k) > nvgt .or. ivegTV(i, j, k) < 0) then
                                print *, "Error in vegetation type", i, j, k, ivegTV(i, j, k)
                                print *, "Have you initialized your snowpack ?"
                                stop
                            endif
                        enddo
                    enddo
                enddo
            endif
            
            ! ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            ! +++ BEGIN of DIABATIC INITIALISATION +++++++++++++++++++++++++++++++++++++
            ! ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            
            if(mmx > 1 .and. log_1D == 1) then
                ! ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
                ! +++ BEGIN of FAST PROPAGATING WAVES DYNAMICS     (HYDROSTATIC PART) ++++++
                ! ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
                
                ! +...``Dynamics'' is active only after the 1-D Initialisation Phase
                ! +--Update of Horizontal Wind Speed and Mass
                ! +  ========================================
                do k = 1, mz
                    do j = 1, my
                        do i = 1, mx
                            ubefDY(i, j, k) = uairDY(i, j, k)
                            vbefDY(i, j, k) = vairDY(i, j, k)
                        enddo
                    enddo
                enddo
                
                do j = 1, my
                    do i = 1, mx
                        pstDY(i, j) = pstDYn(i, j)
                        opstDY(i, j) = pstDYn(i, j)
                    enddo
                enddo
                
                ! +--Update of nt_Mix parameter (CFL criterion on Max Wind Speed)
                ! +  ============================================================
                if(.not. ntFlog) then
                    ntFlog = .true.
                    ! CFLinv : Inverse CFL Number
                    CFLinv = dt / dx
                    ! rtFact : Sound Speed upper Bound (500m/s) normalized by the CFL Number
                    rtFact = 500.0 * CFLinv
                    ! +--Local Wind Speed
                    ! +  ----------------
                    VLocmx = 0.
                    TLocmn = 273.15
                    iLocmx = 0
                    jLocmx = 0
                    kLocmx = 0
                    do k = 1, mz
                        do j = 1, my
                            do i = 1, mx
                                WKxyz1(i, j, k) = (abs(uairDY(i, j, k)) &
                                        + min(1, my - 1) * abs(vairDY(i, j, k)))
                            enddo
                        enddo
                    enddo
                    
                    do k = 1, mz
                        do j = 1, my
                            do i = 1, mx
                                VLocmx = max(VLocmx, WKxyz1(i, j, k))
                            enddo
                        enddo
                    enddo
                    
                    do j = 1, my
                        do i = 1, mx
                            TLocmn = min(TLocmn, tairDY(i, j, mz - 1))
                        enddo
                    enddo
                    
                    do k = 1, mz
                        do j = 1, my
                            do i = 1, mx
                                if(WKxyz1(i, j, k) > VLocmx - epsi) then
                                    iLocmx = i
                                    jLocmx = j
                                    kLocmx = k
                                endif
                            enddo
                        enddo
                    enddo
                    
                    TLocmn = TLocmn - 273.15
                    nt_sig = 1 + CFLzDY / ntFast
                    nt_BAK = nt_Mix
                    nt_Mix = max(nt_sig, int(rtFact + CFLinv * VLocmx))
                    nt_Mix = max(3, nt_Mix)
                    if(itexpe < 100) nt_Mix = max(8, nt_Mix)
                    
                    dtFast = dt / ((ntFast + 1) * nt_Mix) ! see inigen
                    FIfstu = FIslou / ((ntFast + 1)) ! see grdmar
                    FIfstp = FIslop / ((ntFast + 1)) ! see grdmar
                    do k = 1, mz
                        FIk_fu(k) = max(FIk_fu(k), FIfstu / max(0.1, sigma(k))) ! see grdmar
                        FIk_fp(k) = max(FIk_fp(k), FIfstp / max(0.1, sigma(k))) ! see grdmar
                    enddo
                    
                    write(6, 1001) &
                            TLocmn, VLocmx, iLocmx, jLocmx, kLocmx &
                            , nt_BAK, nt_Mix, itexpe &
                            , jdarGE, labmGE(mmarGE), iyrrGE &
                            , jhurGE, minuGE, jsecGE
                    1001                format('WARNING: TT min =', f8.2, &
                            ' S(|V|)max =', f8.1, ' (', 3i4, ')', &
                            ' ==> update nt_Mix(=', i4, ');:=', i4, ' at iteration', i8, &
                            '     Time is ', i2, '-', a3, '-', i4, &
                            '/', i2, '.', i2, '.', i2, ' UT')
                endif
                
                ! +--Begin of the Fast Time Loop
                ! +  ===========================
                
                nt_tmp1 = max(2, min(5, nt_Mix / 2 + 1))
                nt_tmp2 = max(1, min(3, ntFast / 2 + 1))
                
                do it_Mix = 1, nt_Mix
                    do itFast = 1, ntFast + 1
                        if(.not. brocam) then
                            ! +--Integration of the Hydrostatic Relation
                            ! +  =======================================
                            ! CAa : in classic config, brocam = .true., we don't go here
                            ! +  ******
                            call dyngpo_mp
                            ! +  ******
                            ! + WARNING : Place of this routine DYNgpo in the organigram depends
                            ! + if Brown-Campana (1978, MWR, p.1125) time scheme is used or not!
                            ! + Here is the place when the Brown-Campana time scheme is not used.
                        endif
                        ! +--Mass Continuity
                        ! +  ===============
                        norder_0 = nordps
                        ! +  ******
                        call DYNdps_mp(norder_0)
                        ! +  ******
                        
                        ! +--Filtering
                        ! +  ---------
                        if(FIfstp > 0. .and. mod(it_mix, nt_tmp1) == 0) then
                            do j = 1, my
                                do i = 1, mx
                                    dumy3D(i, j, 1) = pstDYn(i, j) - pstDY1(i, j)
                                enddo
                            enddo
                            dumeps(1) = FIfstp
                            kdim = 1
                            if(mmy <= 1) then
                                ! +  *********
                                call DYNfil_1D(dumy3D, dumeps, kdim)
                                ! +  *********
                            else
                                ! +  *********
                                call DYNfil_3D(dumy3D, dumeps, kdim)
                                ! +  *********
                            endif
                            do j = 1, my
                                do i = 1, mx
                                    pstDYn(i, j) = dumy3D(i, j, 1) + pstDY1(i, j)
                                enddo
                            enddo
                        endif
                        
                        if(brocam) then
                            ! +--Integration of the Hydrostatic Relation
                            ! +  =======================================
                            ! CAa : in classic config, brocam = .true.
                            ! + WARNING : The place of routine DYNgpo in the organigram depends
                            ! + if Brown-Campana (1978, MWR, p.1125) time scheme is used or not!
                            ! + Here is the place when Brown-Campana time scheme is used.
                            ! +                                    *********
                            if(itFast == 1 .and. it_mix == 1) call dyngpo_mp
                            ! +                                    *********
                        endif
                        
                        ! +--Contribution of Horizontal Pressure Gradient Force
                        ! +  ==================================================
                        if(track_wind) then
                            uairDY_save = uairDY
                            vairDY_save = vairDY
                            ! track_wind also inside dyndgz_mp with track_wind_dgz
                        endif
                        norder_0 = nordps
                        ! +  **********
                        call dyndgz_mp(norder_0)
                        ! +  **********
                        
                        if(track_wind) then
                            delta_u(:, :, :, i_dyndgz) = delta_u(:, :, :, i_dyndgz) + (uairDY - uairDY_save)
                            delta_v(:, :, :, i_dyndgz) = delta_v(:, :, :, i_dyndgz) + (vairDY - vairDY_save)
                        endif
                        
                        if(itFast == nt_tmp2) then
                            ! +--Filtering of the Horizontal Wind Speed Components
                            ! +  =================================================
                            if(FIk_fu(1) > 0.0 .and. mod(it_Mix, nt_tmp1) == 0) then
                                if(mmy <= 1) stop
                                do k = 1, mz
                                    dumeps(k) = FIk_fu(k)
                                enddo
                                kdim = mz
                                do k = 1, mz
                                    do j = 1, my
                                        do i = 1, mx
                                            dumy3D(i, j, k) = uairDY(i, j, k)
                                            if(track_wind) then
                                                uairDY_save(i, j, k) = uairDY(i, j, k)
                                            endif
                                        enddo
                                    enddo
                                enddo
                                ! +  ************
                                call DYNfil_3D_mp(dumy3D, dumeps, kdim)
                                ! +  ************
                                do k = 1, mz
                                    do j = 1, my
                                        do i = 1, mx
                                            uairDY(i, j, k) = dumy3D(i, j, k)
                                            dumy3D(i, j, k) = vairDY(i, j, k)
                                            if(track_wind) then
                                                delta_u(i, j, k, i_dynfil) = delta_u(i, j, k, i_dynfil) + &
                                                        (uairDY(i, j, k) - uairDY_save(i, j, k))
                                                vairDY_save(i, j, k) = vairDY(i, j, k)
                                            endif
                                        enddo
                                    enddo
                                enddo
                                
                                ! +  ************
                                call DYNfil_3D_mp(dumy3D, dumeps, kdim)
                                ! +  ************
                                do k = 1, mz
                                    do j = 1, my
                                        do i = 1, mx
                                            vairDY(i, j, k) = dumy3D(i, j, k)
                                            if(track_wind) then
                                                delta_v(i, j, k, i_dynfil) = delta_v(i, j, k, i_dynfil) + &
                                                        (vairDY(i, j, k) - vairDY_save(i, j, k))
                                            endif
                                        enddo
                                    enddo
                                enddo
                            endif
                        else
                            if(itFast == ntFast + 1) then
                                ! +--Filtering of the Vertical H Wind Speed Component
                                ! +  ================================================
                                if(FIk_fp(1) > 0.0 .and. mod(it_Mix, nt_tmp1) == 0) then
                                    if(mmy <= 1) then
                                        do k = 1, mz
                                            do i = 1, mx
                                                dumy3D(i, 1, k) = psigDY(i, 1, k)
                                            enddo
                                            dumeps(k) = FIk_fp(k)
                                        enddo
                                        kdim = mz
                                        
                                        ! +  *********
                                        call DYNfil_1D(dumy3D, dumeps, kdim)
                                        ! +  *********
                                        
                                        ! + The PGF does not contribute to v in the 2-D version
                                        ! +         making the filtering of v unnecessary.
                                        do k = 1, mz
                                            do i = 1, mx
                                                psigDY(i, 1, k) = dumy3D(i, 1, k)
                                            enddo
                                        enddo
                                    else
                                        do k = 1, mz
                                            dumeps(k) = FIk_fp(k)
                                        enddo
                                        kdim = mz
                                        do k = 1, mz
                                            do j = 1, my
                                                do i = 1, mx
                                                    dumy3D(i, j, k) = psigDY(i, j, k)
                                                enddo
                                            enddo
                                        enddo
                                        
                                        ! +  **********
                                        call DYNfil_3D_mp(dumy3D, dumeps, kdim)
                                        ! +  **********
                                        
                                        do k = 1, mz
                                            do j = 1, my
                                                do i = 1, mx
                                                    psigDY(i, j, k) = dumy3D(i, j, k)
                                                enddo
                                            enddo
                                        enddo
                                    endif
                                endif
                            endif
                        endif
                    enddo
                enddo
#ifdef iso
                iso_label = 't_loop    '
                iso_time = iso_time + 1
                call mariso_write_file(iso_time, iso_label) ! 4
#endif(iso)
                ! +--Update of nt_Mix parameter (CFL criterion on Max Wind Speed)
                ! +  ============================================================
                ! +--Local Wind Speed
                ! +  ----------------
                VLocmx = 0.
                TLocmn = 273.15
                iLocmx = 0
                jLocmx = 0
                kLocmx = 0
                do k = 1, mz
                    do j = 1, my
                        do i = 1, mx
                            WKxyz1(i, j, k) = (abs(uairDY(i, j, k)) &
                                    + min(1, my - 1) * abs(vairDY(i, j, k)))
                        enddo
                    enddo
                enddo
                
                do k = 1, mz
                    do j = 1, my
                        do i = 1, mx
                            VLocmx = max(VLocmx, WKxyz1(i, j, k))
                        enddo
                    enddo
                enddo
                
                do j = 1, my
                    do i = 1, mx
                        TLocmn = min(TLocmn, tairDY(i, j, mz - 1))
                    enddo
                enddo
                
                do k = 1, mz
                    do j = 1, my
                        do i = 1, mx
                            if(WKxyz1(i, j, k) > VLocmx - epsi) then
                                iLocmx = i
                                jLocmx = j
                                kLocmx = k
                            endif
                        enddo
                    enddo
                enddo
                
                TLocmn = TLocmn - 273.15
                nt_sig = 1 + CFLzDY / ntFast
                nt_BAK = nt_Mix
                nt_Mix = max(nt_sig, int(rtFact + CFLinv * VLocmx))
                nt_Mix = max(nt_Mix, nt_BAK - 1)
                nt_Mix = max(nt_Mix, nt_Mix_min)
                if(nt_mix > 10 .and. ntFast == 1) then
                    ntFast = 3
                    nt_Mix = 4
                    nt_BAK = 4
                endif
                if(nt_mix > 10 .and. ntFast == 3) then
                    ntFast = 5
                    nt_Mix = 4
                    nt_BAK = 4
                endif
                if(nt_mix > 20) stop 'Nt_mix is too high !! MAR is too instable !!'
                
                nt_smooth = max(0, nt_smooth - 1)
                ! nt_Mix can not decrease during at least 15 min
                if(nt_smooth > 0) nt_Mix = max(nt_Mix, nt_BAK)
                if(nt_Mix /= nt_BAK) then
                    nt_smooth = sqrt(real(nt_Mix)) * 900. / dt ! 15 min
                    nt_smooth = max(nt_smooth, 15)
                    dtFast = dt / ((ntFast + 1) * nt_Mix) ! see inigen
                    FIfstu = FIslou / ((ntFast + 1)) ! see grdmar
                    FIfstp = FIslop / ((ntFast + 1)) ! see grdmar
                    
                    if(ntFast == 1) then
                        do k = 1, mz
                            FIk_fu(k) = max(FIk_fu(k), FIfstu / max(0.1, sigma(k))) ! see grdmar
                            FIk_fp(k) = max(FIk_fp(k), FIfstp / max(0.1, sigma(k))) ! see grdmar
                        enddo
                    else
                        do k = 1, mz
                            FIk_fu(k) = FIfstu / max(0.1, sigma(k))  ! see grdmar
                            FIk_fp(k) = FIfstp / max(0.1, sigma(k))  ! see grdmar
                        enddo
                    endif
                    
                    if(nt_Mix > nt_BAK) then
                        do i = 1, nt_BAK
                            nt_Mix_nbr(i) = nt_Mix_nbr(i) + 1
                            if(nt_Mix_nbr(i) > 3) nt_Mix_min = min(4, i + 1)
                        enddo
                        write(6, 1001) &
                                TLocmn, VLocmx, iLocmx, jLocmx, kLocmx &
                                , nt_BAK, nt_Mix, itexpe &
                                , jdarGE, labmGE(mmarGE), iyrrGE &
                                , jhurGE, minuGE, jsecGE
                    endif
                endif
                ! ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
                ! +++ end   of FAST PROPAGATING WAVES DYNAMICS     (HYDROSTATIC PART) ++++++
                ! ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
#ifdef NH
                ! ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
                ! +++ BEGIN of FAST PROPAGATING WAVES DYNAMICS (NON-HYDROSTATIC PART) ++++++
                ! ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
                
                ! +--Non-Hydrostatic Dynamics
                ! +  ========================
                ! +  ******
                call DYN_NH
                ! +  ******
                ! +--Filtering
                ! +  ---------
                ! +  *********
                call DYNfil_NH
                ! +  *********
                
                ! ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
                ! +++ end   of FAST PROPAGATING WAVES DYNAMICS (NON-HYDROSTATIC PART) ++++++
                ! ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
#endif
                ! ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
                ! +++ BEGIN of SLOW PROPAGATING WAVES DYNAMICS +++++++++++++++++++++++++++++
                ! ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
                
                ! +--Advection
                ! +  =========
                
                ! +--Leapfrog Backward Scheme
                ! +  ------------------------
                if(DYNadv == 'LFB') then
                    ! CAa : in classic config, DYNadv == 'LFB'
                    if(track_water) then
                        qvDY_save = qvDY
                    endif
#ifdef iso
                    iso_label = 'LFB__0    '
                    iso_time = iso_time + 1
                    call mariso_write_file(iso_time, iso_label) ! 5
#endif(iso)
                    norder_0 = nordps
                    ! +  **********
                    call DYNadv_LFB(norder_0)
                    ! +  **********
                    if(track_water) then
                        delta_qv(:, :, :, j_dynadv) = delta_qv(:, :, :, j_dynadv) + (qvDY - qvDY_save)
                    endif
#ifdef iso
                    iso_label = 'LFB__1    '
                    iso_time = iso_time + 1
                    call mariso_write_file(iso_time, iso_label)
#endif(iso)
                endif
                
                ! +--Forward Scheme
                ! +  --------------
                if(DYNadv == 'UPW') then
                    ! CAa : in classic config, DYNadv == 'LFB'
                    ! +--Vertical Advection: (Thermo)Dynamics
                    ! +  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
                    ! +  **********
                    call DYNadv_ver
                    ! +  **********
                    
                    ! +--Vertical Advection: Water    Species
                    ! +  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
                    if(.not. micphy) then
                        ! +  ***********
                        call DYNadv_verq
                        ! +  ***********
                    
                    else
                        ! +  **********
                        call HYDadv_ver
                        ! +  **********
                    
                    endif
#ifdef TC
                    ! +--Vertical Advection: Tracers
                    ! +  ~~~~~~~~~~~~~~~~~~~~~~~~~~~
                    ! +  **********
                    call TRCadv_ver
                    ! +  **********
#endif
                    ! +--Horizontal Advection: Momentum
                    ! +  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
                    FirstC = .false.
                    qqmass = .false.
                    ! +  **********
                    call DYNadv_hor(qqmass, uairDY, opstDY, pstDYn, uairDY, vairDY)
                    ! +  **********
                    
                    ! +  **********
                    call DYNadv_hor(qqmass, vairDY, opstDY, pstDYn, uairDY, vairDY)
                    ! +  **********
                    
                    ! +--Horizontal Advection: (Thermo)dynamics
                    ! +  ~~~~~~~~~~~~~~~~~~~~~ Water    Species
                    ! +                        ~~~~~~~~~~~~~~~~
                    FirstC = .true.
                    qqmass = .true.
                    do k = 1, mz
                        do j = 1, my
                            do i = 1, mx
                                dumy3D(i, j, k) = pktaDY(i, j, k)
                            enddo
                        enddo
                    enddo
                    
                    ! +  **********
                    call DYNadv_hor(qqmass, dumy3D, opstDY, pstDYn, uairDY, vairDY)
                    ! +  **********
                    
                    do k = 1, mz
                        do j = 1, my
                            do i = 1, mx
                                pktaDY(i, j, k) = dumy3D(i, j, k)
                            enddo
                        enddo
                    enddo
                    
                    FirstC = .false.
                    
                    ! +  **********
                    call DYNadv_hor(qqmass, qvDY, opstDY, pstDYn, uairDY, vairDY)
                    ! +  **********
                    
                    if(micphy) then
                        
                        ! +  **********
                        call DYNadv_hor(qqmass, ccniHY, opstDY, pstDYn, uairDY, vairDY)
                        ! +  **********
                        
                        ! +  **********
                        call DYNadv_hor(qqmass, qiHY, opstDY, pstDYn, uairDY, vairDY)
                        ! +  **********
                        
                        ! +  **********
                        call DYNadv_hor(qqmass, qsHY, opstDY, pstDYn, uairDY, vairDY)
                        ! +  **********
                        
                        ! +  **********
                        call DYNadv_hor(qqmass, qwHY, opstDY, pstDYn, uairDY, vairDY)
                        ! +  **********
                        
                        ! +  **********
                        call DYNadv_hor(qqmass, qrHY, opstDY, pstDYn, uairDY, vairDY)
                        ! +  **********
                    
                    endif
#ifdef BS
                    ! +--Horizontal Advection: Saltating Snow
                    ! +  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
                    ! +  **********
                    call DYNadv_sal
                    ! +  **********
#endif
#ifdef TC
                    ! +--Horizontal Advection: Tracers
                    ! +  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
                    if(mod(itexpe, jtAdvH) == 0) then
                        qqmass = .true.
                        ! +  **********
                        call TRCadv_hor
                        ! +  **********
                        ! +--New Time Step
                        ! +  ~~~~~~~~~~~~~
                        cfladv = epsi
                        do k = 1, mz
                            do j = 1, my
                                do i = 1, mx
                                    cfladv = max(cfladv, abs(uairDY(i, j, k)))
                                    cfladv = max(cfladv, abs(vairDY(i, j, k)))
                                enddo
                            enddo
                        enddo
                        dtAdvH = demi * dx / cfladv
                        dtAdvH = min(dtAdvH, dt_ODE)
                        dtAdvH = max(dtAdvH, dt)
                        ! jtAdvH :  Number of  Dynamical Steps for 1 Advection     Step
                        jtAdvH = dtAdvH / dt
                        ! dtAdvH :  Calibrated Advection       Time Step
                        dtAdvH = dt * jtAdvH
                        ntAdvH = 1
                    endif
#endif
                endif
                
                ! +--Rayleigh Friction (Ref. ARPS 4.0 User's Guide, para 6.4.3 p.152)
                ! +  =================
                do k = 1, mzabso
                    do j = 1, my
                        do i = 1, mx
                            pktaDY(i, j, k) = (pktaDY(i, j, k) + Ray_UB(k) * dt * pktaUB(i, j, k) &
                                                                      / min(100., max(1., (k - mzhyd+1)*2.))) &
                                              / (1.0 + Ray_UB(k) * dt / min(100., max(1., (k - mzhyd+1)*2.)))
!                           pktaDY(i, j, k) = (pktaDY(i, j, k) + Ray_UB(k) * dt * pktaUB(i, j, k) )&
!                                             / (1.0 + Ray_UB(k) * dt)
                        enddo
                    enddo
                enddo
                ! ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
                ! +++ end of SLOW PROPAGATING WAVES DYNAMICS +++++++++++++++++++++++++++++
                ! ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            else !CAa not(if (mmx > 1 .and. log_1D == 1))
                !CAa +++++++++++++++++++++++++++++++++++++++++++++++++++
                !CAa First initialization (log_1D == 0) ++++++++++++++++
                !CAa +++++++++++++++++++++++++++++++++++++++++++++++++++
                ! +  ******
                call dyngpo_mp
                ! +  ******
                
                ! +--Mid-Level Geopotential
                ! +  ----------------------
                k = 1
                do j = 1, my
                    do i = 1, mx
                        gpmiDY(i, j, k) = 0.5 * (3.5 * gplvDY(i, j, 1) - 0.5d0 * gplvDY(i, j, 2))
                    enddo
                enddo
                
                do k = kp1(1), mz
                    do j = 1, my
                        do i = 1, mx
                            gpmiDY(i, j, k) = 0.5 * (gplvDY(i, j, k - 1) + gplvDY(i, j, k))
                        enddo
                    enddo
                enddo
                
                k = mzz
                do j = 1, my
                    do i = 1, mx
                        gpmiDY(i, j, k) = (0.5 * z__SBL + sh(i, j)) * gravit
                    enddo
                enddo
                !CAa +++++++++++++++++++++++++++++++++++++++++++++++++++
                !CAa END of First initialization (log_1D == 0) +++++++++
                !CAa +++++++++++++++++++++++++++++++++++++++++++++++++++
            endif
            
            ! +--Specific Mass
            ! +  =============
            ! +  ******
            call dynrho
            ! +  ******
            
            ! +--Saturation Specific Humidity
            ! +  ============================
            ! +  ******
            call qsat3d
            ! +  ******
            
            ! +--Vertical Velocity in Cartesian Coordinates
            ! +  ==========================================
            if(convec .and. mmx > 1) then
                ! +  ******
                call dynwww
                ! +  ******
            endif
            ! ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            ! +++ BEGIN of MAR "SUBGRID ZONE" (INCLUDING CORIOLIS FORCE) +++++++++++++++
            ! ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            
            ! +--Local Temporal Parameters
            ! +  =========================
           
            if(log_1D == 0 .and. tequil > 0.) then
                ! +--Boundary Layer Initialisation over time tequil
                ! +  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
                tequil = tequil * 3600.
                ! +... Conversion [h]->[s]
                dt_Loc = dtquil
                nt_Loc = tequil / dtquil
                jt_Loc = 1
            else
                ! +--Boundary Layer is iterated over time dt
                ! +  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
                dt_Loc = dtDiff
                nt_Loc = ntDiff
                jt_Loc = jtDiff
            endif
 
            ! +--Begin of Subgrid Loop
            ! +  =====================
            if(mod(itexpe, jt_Loc) == 0) then
                do it_Loc = 1, nt_Loc
                    ! +--Coriolis Force Contribution (Implicit Scheme)
                    ! +  ---------------------------------------------
                    if(track_wind) then
                        uairDY_save = uairDY
                        vairDY_save = vairDY
                    endif
                    
                    do i = 1, mx
                        do j = 1, my
                            do k = 1, mz
                                uairDY(i, j, k) = uairDY(i, j, k) &
                                        + fcorDY(i, j) * (vairDY(i, j, k) - vgeoDY(i, j, k)) * dt_Loc
                                vairDY(i, j, k) = vairDY(i, j, k) &
                                        - fcorDY(i, j) * (uairDY(i, j, k) - ugeoDY(i, j, k)) * dt_Loc
                            enddo
                        enddo
                    enddo
                    
                    if(track_wind) then
                        delta_u(:, :, :, i_coriol) = delta_u(:, :, :, i_coriol) + (uairDY - uairDY_save)
                        delta_v(:, :, :, i_coriol) = delta_v(:, :, :, i_coriol) + (vairDY - vairDY_save)
                    endif
                    
                    ! +--Horizontal Subgrid Processes
                    ! +  ----------------------------
                    if(turhor .and. log_1D == 1 .and. mmx > 1) then
                        ! +--Horizontal Diffusion Coefficient
                        ! +  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
                        ! +  *********
                        call turhor_kh
                        ! +  *********
                        
                        ! +--Contribution of Horizontal Diffusion
                        ! +  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
                        if(track_wind) then
                            uairDY_save = uairDY
                            vairDY_save = vairDY
                        endif
                        if(track_water) then
                            qvDY_save = qvDY
                        end if
                        ! +  **********
                        call turhor_dyn(dtDifH)
                        ! +  **********
                        if(track_wind) then
                            delta_u(:, :, :, i_turhor) = delta_u(:, :, :, i_turhor) + (uairDY - uairDY_save)
                            delta_v(:, :, :, i_turhor) = delta_v(:, :, :, i_turhor) + (vairDY - vairDY_save)
                        endif
                        if(track_water) then
                            delta_qv(:, :, :, j_turhor) = delta_qv(:, :, :, j_turhor) + (qvDY - qvDY_save)
                        endif
#ifdef iso
                        iso_label = 'turhor_dyn'
                        iso_time = iso_time + 1
                        call mariso_write_file(iso_time, iso_label)
#endif(iso)
                    endif
                    ! +--Water Vapor and Precipitation Loading
                    ! +  -------------------------------------
                    ! +  ******
                    call dynloa
                    ! +  ******
                    
                    ! +--Vertical Subgrid Processes
                    ! +  --------------------------
                    if(dtDiff > 0.) then
                        ! +--Turbulent Kinetic Energy
                        ! +  ~~~~~~~~~~~~~~~~~~~~~~~~
                        if(jt_Loc > 1) then
                            dtLLoc = min(dt_Loc, dtAdvH)
                            ! CAUTION: dtDifH computed in turhor_dyn
                            dtLLoc = min(dtLLoc, dtDifH)
                            dtLLoc = max(dtLLoc, dt)
                            ntLLoc = dt_Loc / dtLLoc
                            ntLLoc = max(ntLLoc, iun)
                            dtLLoc = dt_Loc / ntLLoc
                        else
                            dtLLoc = dt_Loc
                            ntLLoc = 1
                        endif
                        do itLLoc = 1, ntLLoc
                            ! +               ****************
                            if(mmx > 1) call turtke_advh(dtLLoc)
                            if(mmx > 1) call turtke_advv(dtLLoc)
                            if(mmx > 1) call turtke_difh(dtLLoc)
                            call turtke_difv(dtLLoc, 0.)
                            call turtke_gen(dtLLoc)
                            ! +               ***************
                        enddo
                        
                        ! +--Surface Layer
                        ! +  ~~~~~~~~~~~~~
                        do k = 1, mz
                            do j = 1, my
                                do i = 1, mx
                                    ssvSL(i, j, k) = sqrt(max(uairDY(i, j, k) * uairDY(i, j, k) &
                                            + vairDY(i, j, k) * vairDY(i, j, k) &
                                            , epsi))
                                enddo
                            enddo
                        enddo
                        
                        itConv = itexpe * nt_Loc / jt_Loc + it_Loc
                        ! if (convec.and.itexpe*dt> 24*3600) then
                        
                        ! end if
                        
                        ! +--Contribution of Turbulent Vertical Diffusion
                        ! +  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
                        if(track_wind) then
                            uairDY_save = uairDY
                            vairDY_save = vairDY
                        endif
                        if(track_water) then
                            qvDY_save = qvDY
                        endif
                        ! +  ******
                        call TURabl
                        ! +  ******
                        if(track_wind) then
                            delta_u(:, :, :, i_turabl) = delta_u(:, :, :, i_turabl) + (uairDY - uairDY_save)
                            delta_v(:, :, :, i_turabl) = delta_v(:, :, :, i_turabl) + (vairDY - vairDY_save)
                        endif
                        if(track_water) then
                            delta_qv(:, :, :, j_turabl) = delta_qv(:, :, :, j_turabl) + (qvDY - qvDY_save)
                        endif

#ifdef iso
                        ! todo : qi, qw, qr, qs, rain, snow, ...
                        iso_label = 'turabl    '
                        iso_time = iso_time + 1
                        call mariso_write_file(iso_time, iso_label)
#endif(iso)
                        if(track_water) then
                            qvDY_save = qvDY
                        endif
                        ! +  ******
                        call sspray
                        ! +  ******
                        if(track_water) then
                            delta_qv(:, :, :, j_sspray) = delta_qv(:, :, :, j_sspray) + (qvDY - qvDY_save)
                        endif
#ifdef iso
                        iso_label = 'sspray    '
                        iso_time = iso_time + 1
                        call mariso_write_file(iso_time, iso_label)
#endif(iso)
#ifdef NH
                        ! +--Contribution of Turbulent Vertical Diffusion (Non Hydrostatic Variables)
                        ! +  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
                        ! +  ******
                        call TURvNH
                        ! +  ******
#endif
                    endif
                enddo
            endif

#ifdef TC
            ! +--Tracers Turbulent Transfert
            ! +  ===========================
            if(dt_ODE /= dtDiff) then
                if(mod(itexpe, jt_ODE) == 0) then
                    dt_Loc = dt_ODE
                    nt_Loc = nt_ODE
                    do it_Loc = 1, nt_Loc
                        ! +  *********
                        call TURabl_TC
                        ! +  *********
                    enddo
                endif
            endif
#endif
            
            ! +--Initialized Temperature Vertical Profiles
            ! +  =========================================
            if(IO_loc >= 2 .and. log_1D == 0) then
                do i = 1, 5
                    tta(i) = tsrfSL(igrdIO(i), jgrdIO(i), 1) - TfSnow
                enddo
                write(21, 607)(igrdIO(i), jgrdIO(i), i = 1, 5), &
                        (sh(igrdIO(i), jgrdIO(i)), tta(i), i = 1, 5)
                do kk = 1, mz
                    k = mzz - kk
                    do i = 1, 5
                        zza(i) = gplvDY(igrdIO(i), jgrdIO(i), k) * grvinv
                        tta(i) = pktaDY(igrdIO(i), jgrdIO(i), k) * pcap
                    enddo
                    write(21, 609)(zza(i), tta(i), i = 1, 5)
                enddo
                write(21, 611)
            endif
            ! log_1D = 1 <==> PBL initialisation is performed
            log_1D = 1
            
            ! ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            ! +++ end   of MAR "SUBGRID ZONE" (INCLUDING CORIOLIS FORCE) +++++++++++++++
            ! +++ EXPLICIT HYDROLOGICAL CYCLE  +++++++++++++++++++++++++++++++++++++++++
            ! ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            
            ! +--Cloud Microphysical Processes
            ! +  =============================
            if(micphy) then
                if(track_water) then
                    qvDY_save = qvDY
                endif
                ! +  ******
                call HYDgen
                ! +  ******
                if(track_water) then
                    delta_qv(:, :, :, j_hydgen) = delta_qv(:, :, :, j_hydgen) + (qvDY - qvDY_save)
                endif
#ifdef iso
                iso_label = 'hydgen    '
                iso_time = iso_time + 1
                call mariso_write_file(iso_time, iso_label)
#endif(iso)
            else
                ! +--Elimination of Water Vapor in Excess
                ! +  ====================================
                do k = 1, mz
                    do j = 1, my
                        do i = 1, mx
                            qvDY(i, j, k) = max(zero, qvDY(i, j, k))
                            qvDY(i, j, k) = min(qvswDY(i, j, k), qvDY(i, j, k))
                        enddo
                    enddo
                enddo
            endif
            
            ! ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            ! +++ BEGIN of LATERAL BOUNDARY CONDITIONS and FILTERING +++++++++++++++++++
            ! ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            ! +--Modification of the External Forcing
            ! +  ====================================
            if(mmx > 1) then
                if(reaLBC) then
                    ! +--LBC are provided by a Large Scale (3-D) Model
                    ! +  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
                    ! +  ******
                    call INIlbc(ihamr, nhamr, newlbc_0)
                    call INIubc(ihamr, nhamr, newlbc_0)
                    ! +  ******
                    ! +                     **********
                    if(newlbc_0 == 1) call lbcnud_par
                    ! +                     **********
                else
                    ! +--LBC are provided by one Sounding (Horizontal Homogeneity is assumed)
                    ! +  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
                    ! +  ******
                    call inisnd
                    ! +  ******
                    
                    ! +  **********
                    call lbcnud_par
                    ! +  **********
                endif
                
                ! +--Lateral Boundary Conditions  for Mass Continuity p*
                ! +  ("Nudging" Type / Davies, QJRMS, 1976, pp.405--418)
                ! +    ("Open" Lateral Boundary Condition is possible)
                ! +  ===================================================
                ksig = 1
                iv = 5
                
                do j = 1, my
                    do i = 1, mx
                        dumy3D(i, j, 1) = pstDYn(i, j)
                    enddo
                enddo
                ! +  **********
                call LBCnud_atm(dumy3D, iv, ksig)
                ! +  **********
                do j = 1, my
                    do i = 1, mx
                        pstDYn(i, j) = dumy3D(i, j, 1)
                    enddo
                enddo
                
                ! +--START of:
                ! +--Lateral Boundary Conditions  for Wind, Temperature, Specific Humidity
                ! +  ("Nudging" Type / Davies, QJRMS, 1976, pp.405--418)
                ! +  =====================================================================
                
                ! +--Radiative Lateral Boundary Conditions: Auxiliary Variables
                ! +  ==========================================================
                kdim = mz
                
                ! +--Lateral Boundary Conditions and Horizontal Filter
                ! +  =================================================
                ! +--Wind x-Direction
                ! +  ----------------
                iv = 1
                ! +--Dummy Variable
                ! +  ~~~~~~~~~~~~~~
                do k = 1, mz
                    do j = 1, my
                        do i = 1, mx
                            dumy3D(i, j, k) = uairDY(i, j, k)
                            if(track_wind) then
                                uairDY_save(i, j, k) = uairDY(i, j, k)
                            endif
                        enddo
                    enddo
                enddo
                
                ! +  **********
                call LBCnud_atm(dumy3D, iv, kdim)
                ! +  **********
                
                ! +--Horizontal Filter
                ! +  ~~~~~~~~~~~~~~~~~
                if(FIk_fu(1) > 0.0) then
                    do k = 1, mz
                        dumeps(k) = FIk_fu(k)
                    enddo
                    kdim = mz
                    if(mmy <= 1) then
                        ! +  *********
                        call DYNfil_1D(dumy3D, dumeps, kdim)
                        ! +  *********
                    else
                        ! +  **********
                        call DYNfil_3D_mp(dumy3D, dumeps, kdim)
                        ! +  **********
                    endif
                endif
                
                ! +--Update
                ! +  ~~~~~~
                do k = 1, mz
                    do j = 1, my
                        do i = 1, mx
                            uairDY(i, j, k) = dumy3D(i, j, k)
                            if(track_wind) then
                                delta_u(i, j, k, i_lbcnud) = delta_u(i, j, k, i_lbcnud) + &
                                        (uairDY(i, j, k) - uairDY_save(i, j, k))
                            endif
                        enddo
                    enddo
                enddo
                
                ! +--Wind y-Direction
                ! +  ----------------
                iv = 2
                do k = 1, mz
                    do j = 1, my
                        do i = 1, mx
                            dumy3D(i, j, k) = vairDY(i, j, k)
                            if(track_wind) then
                                vairDY_save(i, j, k) = vairDY(i, j, k)
                            endif
                        enddo
                    enddo
                enddo
                
                ! +  **********
                call LBCnud_atm(dumy3D, iv, kdim)
                ! +  **********
                
                ! +--Horizontal Filter
                ! +  ~~~~~~~~~~~~~~~~~
                if(FIk_fu(1) > 0.0) then
                    if(mmy <= 1) then
                        do k = 1, mz
                            dumeps(k) = FIk_su(k)
                        enddo
                        kdim = mz
                        ! +  *********
                        call DYNfil_1D(dumy3D, dumeps, kdim)
                        ! +  *********
                    else
                        do k = 1, mz
                            dumeps(k) = FIk_fu(k)
                        enddo
                        kdim = mz
                        ! +  **********
                        call DYNfil_3D_mp(dumy3D, dumeps, kdim)
                        ! +  **********
                    endif
                endif
                
                do k = 1, mz
                    do j = 1, my
                        do i = 1, mx
                            vairDY(i, j, k) = dumy3D(i, j, k)
                            if(track_wind) then
                                delta_v(i, j, k, i_lbcnud) = delta_v(i, j, k, i_lbcnud) + &
                                        (vairDY(i, j, k) - vairDY_save(i, j, k))
                            endif
                        enddo
                    enddo
                enddo
                
                ! +--Specific Humidity
                ! +  -----------------
                iv = 3
                do k = 1, mz
                    do j = 1, my
                        do i = 1, mx
                            dumy3D(i, j, k) = qvDY(i, j, k)
                        enddo
                    enddo
                enddo
                
                if(track_water) then
                    qvDY_save = qvDY
                endif

                ! +--Water Mass
                ! +  ~~~~~~~~~~
                ! +  ******
                call DYNqqm(dumy3D, 1, 'BAK', 'FIL_Qv')
                ! +  ******
                
                ! +  **********
                call LBCnud_atm(dumy3D, iv, kdim)
                ! +  **********
                
                ! +--Horizontal Filter
                ! +  ~~~~~~~~~~~~~~~~~
                if(FIk_st(1) > 0.0) then
                    do k = 1, mz
                        ! dumeps(k) = FIslot/max(0.1,sigma(k)) ! too high filtering
                        dumeps(k) = FIslot / max(0.1, sqrt(sigma(k)))
                    enddo
                    kdim = mz
                    if(mmy <= 1) then
                        ! +  *********
                        call DYNfil_1D(dumy3D, dumeps, kdim)
                        ! +  *********
                    else
                        ! +  **********
                        call DYNfil_3D_mp(dumy3D, dumeps, kdim)
                        ! +  **********
                    endif
                endif
                
                do k = 1, mz
                    do j = 1, my
                        do i = 1, mx
                            dumy3Q(i, j, k) = max(dumy3D(i, j, k), epsq)
                        enddo
                    enddo
                enddo
                
                ! +--Restore the Water Vapor total Mass
                ! +  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
                ! +  ******
                call DYNqqm(dumy3Q, 1, 'SET', 'FIL_Qv')
                ! +  ******
                
                do k = 1, mz
                    do j = 1, my
                        do i = 1, mx
                            qvDY(i, j, k) = dumy3Q(i, j, k)
                        enddo
                    enddo
                enddo
                if(track_water) then
                    delta_qv(:, :, :, j_lbcnud) = delta_qv(:, :, :, j_lbcnud) + (qvDY - qvDY_save)
                endif
#ifdef iso
                iso_label = 'DYNqqm_qv '
                iso_time = iso_time + 1
                call mariso_write_file(iso_time, iso_label)
#endif(iso)
                
                ! +--Potential Temperature
                ! +  ---------------------
                iv = 4
                do k = 1, mz
                    do j = 1, my
                        do i = 1, mx
                            dumy3D(i, j, k) = pktaDY(i, j, k)
                        enddo
                    enddo
                enddo
                
                ! +  **********
                call LBCnud_atm(dumy3D, iv, kdim)
                ! +  **********
                
                ! +
                ! +--Horizontal Filter
                ! +  ~~~~~~~~~~~~~~~~~
                if(FIk_st(1) > 0.0) then
                    do k = 1, mz
                        dumeps(k) = FIk_st(k)
                    enddo
                    kdim = mz
                    if(mmy <= 1) then
                        ! +  *********
                        call DYNfil_1D(dumy3D, dumeps, kdim)
                        ! +  *********
                    else
                        ! +  **********
                        call DYNfil_3D_mp(dumy3D, dumeps, kdim)
                        ! +  **********
                    endif
                endif
                
                do k = 1, mz
                    do j = 1, my
                        do i = 1, mx
                            pktaDY(i, j, k) = dumy3D(i, j, k)
                        enddo
                    enddo
                enddo
                
                ! +--TKE (Filtering only)
                ! +  --------------------
                
                ! +--Lateral Boundary Conditions and Horizontal Filter (Microphysics)
                ! +  ================================================================
                
                if(iterun == 0) then
                    FIsloQ = FIslot
                endif
                
                if(micphy) then
                    ! +--Filter Parameter, H2O Variables
                    ! +  -------------------------------
                    do k = 1, mz
                        
                        dumeps(k) = FIsloQ / max(0.1, sqrt(sigma(k)))
                        !XF
                    enddo
                    kdim = mz
                    
                    ! +--Cloud Ice Crystals Number
                    ! +  -------------------------
                    iv = 3
                    kdim = mz
                    ! +
                    do k = 1, mz
                        dumeps(k) = FIsloQ * 10.
                        do j = 1, my
                            do i = 1, mx
                                dumy3D(i, j, k) = ccniHY(i, j, k)
                            enddo
                        enddo
                    enddo
                    
                    ! +--Water Mass
                    ! +  ~~~~~~~~~~
                    ! +  ******
                    call DYNqqm(dumy3D, mzhyd, 'BAK', 'FIL_CN')
                    ! +  ******
                    
                    ! +--Nudging   LBC
                    ! +  ~~~~~~~~~~~~~
                    ! +  **********
                    call LBCnud_000(dumy3D, iv, kdim)
                    ! +  **********
                    
                    ! +--Horizontal Filter
                    ! +  ~~~~~~~~~~~~~~~~~
                    if(FIsloQ > 0.0) then
                        if(mmy <= 1) then
                            ! +  *********
                            call DYNfil_1D(dumy3D, dumeps, kdim)
                            ! +  *********
                        else
                            ! +  **********
                            call DYNfil_3D_mp(dumy3D, dumeps, kdim)
                            ! +  **********
                        endif
                    endif
                    
                    do k = 1, mz
                        do j = 1, my
                            do i = 1, mx
                                dumy3Q(i, j, k) = max(dumy3D(i, j, k), zero)
                            enddo
                        enddo
                    enddo
                    
                    ! +--Restore the Hydrometeor total Mass
                    ! +  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
                    ! +  ******
                    call DYNqqm(dumy3Q, mzhyd, 'SET', 'FIL_CN')
                    ! +  ******
                    do k = 1, mz
                        do j = 1, my
                            do i = 1, mx
                                ccniHY(i, j, k) = dumy3Q(i, j, k)
                            enddo
                        enddo
                    enddo
                    
                    ! +--Cloud Ice Crystals Concentration
                    ! +  --------------------------------
                    iv = 3
                    kdim = mz
                    do k = 1, mz
                        dumeps(k) = FIsloQ * 10.
                        do j = 1, my
                            do i = 1, mx
                                dumy3D(i, j, k) = qiHY(i, j, k)
                            enddo
                        enddo
                    enddo
                    
                    ! +--Water Mass
                    ! +  ~~~~~~~~~~
                    ! +  ******
                    call DYNqqm(dumy3D, mzhyd, 'BAK', 'FIL_Qi')
                    ! +  ******
                    
                    ! +--Nudging LBC
                    ! +  ~~~~~~~~~~~
                    ! +  **********
                    call LBCnud_000(dumy3D, iv, kdim)
                    ! +  **********
                    
                    ! +--Horizontal Filter
                    ! +  ~~~~~~~~~~~~~~~~~
                    if(FIsloQ > 0.0) then
                        if(mmy <= 1) then
                            ! +  *********
                            call DYNfil_1D(dumy3D, dumeps, kdim)
                            ! +  *********
                        else
                            ! +  **********
                            call DYNfil_3D_mp(dumy3D, dumeps, kdim)
                            ! +  **********
                        endif
                    endif
                    
                    do k = 1, mz
                        do j = 1, my
                            do i = 1, mx
                                dumy3Q(i, j, k) = max(dumy3D(i, j, k), zero)
                            enddo
                        enddo
                    enddo
                    
                    ! +--Restore the Hydrometeor total Mass
                    ! +  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
                    ! +  ******
                    call DYNqqm(dumy3Q, mzhyd, 'SET', 'FIL_Qi')
                    ! +  ******
                    
                    do k = 1, mz
                        do j = 1, my
                            do i = 1, mx
                                qiHY(i, j, k) = dumy3Q(i, j, k)
                            enddo
                        enddo
                    enddo
#ifdef iso
                    iso_label = 'DYNqqm_qi '
                    iso_time = iso_time + 1
                    call mariso_write_file(iso_time, iso_label)
#endif(iso)
                    
                    ! +--Snow Flakes
                    ! +  -----------
                    iv = 3
                    kdim = mz
                    do k = 1, mz
                        dumeps(k) = FIsloQ / max(0.1, sqrt(sigma(k)))
                        do j = 1, my
                            do i = 1, mx
                                dumy3D(i, j, k) = qsHY(i, j, k)
                            enddo
                        enddo
                    enddo
                    
                    ! +--Water Mass
                    ! +  ~~~~~~~~~~
                    ! +  ******
                    call DYNqqm(dumy3D, mzhyd, 'BAK', 'FIL_Qs')
                    ! +  ******
                    
                    ! +--Nudging LBC
                    ! +  ~~~~~~~~~~~
                    ! +  **********
                    call LBCnud_000(dumy3D, iv, kdim)
                    ! +  **********
                    
                    ! +--Horizontal Filter
                    ! +  ~~~~~~~~~~~~~~~~~
                    if(FIsloQ > 0.0) then
                        if(mmy <= 1) then
                            ! +  *********
                            call DYNfil_1D(dumy3D, dumeps, kdim)
                            ! +  *********
                        else
                            ! +  **********
                            call DYNfil_3D_mp(dumy3D, dumeps, kdim)
                            ! +  **********
                        endif
                    endif
                    
                    do k = 1, mz
                        do j = 1, my
                            do i = 1, mx
                                dumy3Q(i, j, k) = max(dumy3D(i, j, k), zero)
                            enddo
                        enddo
                    enddo
                    
                    ! +--Restore the Hydrometeor total Mass
                    ! +  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
                    ! +  ******
                    call DYNqqm(dumy3Q, mzhyd, 'SET', 'FIL_Qs')
                    ! +  ******
                    do k = 1, mz
                        do j = 1, my
                            do i = 1, mx
                                qsHY(i, j, k) = dumy3Q(i, j, k)
                            enddo
                        enddo
                    enddo
#ifdef iso
                    iso_label = 'DYNqqm_qs '
                    iso_time = iso_time + 1
                    call mariso_write_file(iso_time, iso_label)
#endif(iso)
                    
                    ! +--Cloud Droplets
                    ! +  --------------
                    iv = 3
                    kdim = mz
                    do k = 1, mz
                        dumeps(k) = FIsloQ * 10.
                        do j = 1, my
                            do i = 1, mx
                                dumy3D(i, j, k) = qwHY(i, j, k)
                            enddo
                        enddo
                    enddo
                    
                    ! +--Water Mass
                    ! +  ~~~~~~~~~~
                    ! +  ******
                    call DYNqqm(dumy3D, mzhyd, 'BAK', 'FIL_Qw')
                    ! +  ******
                    
                    ! +--Nudging   LBC
                    ! +  ~~~~~~~~~~~~~
                    ! +  **********
                    call LBCnud_000(dumy3D, iv, kdim)
                    ! +  **********
                    
                    ! +--Horizontal Filter
                    ! +  ~~~~~~~~~~~~~~~~~
                    if(FIsloQ > 0.0) then
                        if(mmy <= 1) then
                            ! +  *********
                            call DYNfil_1D(dumy3D, dumeps, kdim)
                            ! +  *********
                        else
                            ! +  **********
                            call DYNfil_3D_mp(dumy3D, dumeps, kdim)
                            ! +  **********
                        endif
                    endif
                    
                    do k = 1, mz
                        do j = 1, my
                            do i = 1, mx
                                dumy3Q(i, j, k) = max(dumy3D(i, j, k), zero)
                            enddo
                        enddo
                    enddo
                    
                    ! +--Restore the Hydrometeor total Mass
                    ! +  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
                    ! +  ******
                    call DYNqqm(dumy3Q, mzhyd, 'SET', 'FIL_Qw')
                    ! +  ******
                    
                    do k = 1, mz
                        do j = 1, my
                            do i = 1, mx
                                qwHY(i, j, k) = dumy3Q(i, j, k)
                            enddo
                        enddo
                    enddo
#ifdef iso
                    iso_label = 'DYNqqm_qw '
                    iso_time = iso_time + 1
                    call mariso_write_file(iso_time, iso_label)
#endif(iso)
                    ! +--Rain Drops
                    ! +  ----------
                    iv = 3
                    kdim = mz
                    do k = 1, mz
                        dumeps(k) = FIsloQ / max(0.1, sqrt(sigma(k)))
                        do j = 1, my
                            do i = 1, mx
                                dumy3D(i, j, k) = qrHY(i, j, k)
                            enddo
                        enddo
                    enddo
                    
                    ! +--Water Mass
                    ! +  ~~~~~~~~~~
                    ! +  ******
                    call DYNqqm(dumy3D, mzhyd, 'BAK', 'FIL_Qr')
                    ! +  ******
                    
                    ! +--Nudging   LBC
                    ! +  ~~~~~~~~~~~~~
                    ! +  **********
                    call LBCnud_000(dumy3D, iv, kdim)
                    ! +  **********
                    
                    ! +--Horizontal Filter
                    ! +  ~~~~~~~~~~~~~~~~~
                    if(FIsloQ > 0.0) then
                        if(mmy <= 1) then
                            ! +  *********
                            call DYNfil_1D(dumy3D, dumeps, kdim)
                            ! +  *********
                        else
                            ! +  **********
                            call DYNfil_3D_mp(dumy3D, dumeps, kdim)
                            ! +  **********
                        endif
                    endif
                    
                    do k = 1, mz
                        do j = 1, my
                            do i = 1, mx
                                dumy3Q(i, j, k) = max(dumy3D(i, j, k), zero)
                            enddo
                        enddo
                    enddo
                    
                    ! +--Restore the Hydrometeor total Mass
                    ! +  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
                    ! +  ******
                    call DYNqqm(dumy3Q, mzhyd, 'SET', 'FIL_Qr')
                    ! +  ******
                    
                    do k = 1, mz
                        do j = 1, my
                            do i = 1, mx
                                qrHY(i, j, k) = dumy3Q(i, j, k)
                            enddo
                        enddo
                    enddo
                endif
#ifdef iso
                iso_label = 'DYNqqm_qr '
                iso_time = iso_time + 1
                call mariso_write_file(iso_time, iso_label)
#endif(iso)
                
                ! +--Filtering  of Tracer Variables
                ! +  ==============================
                if(ntracr > 0) then
#ifdef TC
                    do n = 1, ntrac
                        ! +--Mass
                        ! +  ----
                        do k = 1, mz
                            sumv(k) = 0.0
                            dumeps(k) = FIsloQ
                            do j = 1, my
                                do i = 1, mx
                                    sumv(k) = qxTC(i, j, k, n) * pstDYn(i, j) + sumv(k)
                                    dumy3D(i, j, k) = qxTC(i, j, k, n)
                                enddo
                            enddo
                        enddo
                        ! +--Filtering (2D)
                        ! +  --------------
                        if(mmy <= 1) then
                            ! +           **************
                            call DYNfil_1D(dumy3D, dumeps, kdim)
                            ! +           **************
                        else
                            ! +--Filtering (3D)
                            ! +  --------------
                            if(no_vec) then
                                if(openmp) then
                                    ! +  **********
                                    call DYNfil_3D_mp(dumy3D, dumeps, kdim)
                                    ! +  **********
                                else
                                    ! +  **********
                                    call DYNfil_3D(dumy3D, dumeps, kdim)
                                    ! +  **********
                                endif
                            else
                                ! +               **************
                                call DYNfilv3D(dumy3D, dumeps, kdim)
                                ! +               **************
                            endif
                        endif
                        ! +--Restore Mass
                        ! +  ------------
                        do k = 1, mz
                            sumvn = 0.0
                            do j = 1, my
                                do i = 1, mx
                                    qxTC(i, j, k, n) = max(zero, dumy3D(i, j, k))
                                    sumvn = qxTC(i, j, k, n) * pstDYn(i, j) + sumvn
                                enddo
                            enddo
                            if(sumvn > 0.0) then
                                sumvn = sumv(k) / sumvn
                                do j = 1, my
                                    do i = 1, mx
                                        qxTC(i, j, k, n) = qxTC(i, j, k, n) * sumvn
                                    enddo
                                enddo
                            else
                                do j = 1, my
                                    do i = 1, mx
                                        qxTC(i, j, k, n) = 0.0
                                    enddo
                                enddo
                            endif
                        enddo
                    enddo
#endif
                endif
            endif
            
            ! ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            ! +++ end of DIABATIC INITIALISATION +++++++++++++++++++++++++++++++++++++++
            ! ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            
            ! +--Global Correction for p*
            ! +  ========================
            
            ! ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            ! +++ PHYSICS ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            ! ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            
            ! +--Radiative Processes and 1D Surface Physics
            ! +  ==========================================
            if(physic) then
                if(track_water) then
                    qvDY_save = qvDY
                endif
                ! +  **********
                call CVAgen_MNH
                ! +  **********
                if(track_water) then
                    delta_qv(:, :, :, j_cvagen) = delta_qv(:, :, :, j_cvagen) + (qvDY - qvDY_save)
                endif
#ifdef iso
                iso_label = 'CVAgen_MNH'
                iso_time = iso_time + 1
                call mariso_write_file(iso_time, iso_label)
#endif(iso)
                if(mod(iterun, jtRadi) == 0) then
                    ! +  **********
                    call PHYrad_top(DistST)
#ifdef RM
                    call PHYrad_CEP_in(DistST)
#endif
#ifdef RE
                    call PHYrad_ECRAD_in(DistST)
#endif
                    ! +  **********
                    ave_swd = 0
                    do i = 2, mx - 1
                        do j = 2, my - 1
                            ave_swd = ave_swd + RAdsol(i, j)
                        enddo
                    enddo
                    
                    ave_swd = ave_swd / real((mx - 2) * (my - 2))
                    
                                                     jtRadi =      jtRadi2
                    if(ave_swd <= 50.and.OutdyIB==1) jtRadi = nint(jtRadi2 * 1.5)
                    if(ave_swd <= 10.and.OutdyIB==1) jtRadi = nint(jtRadi2 * 2.0)
                    if(ave_swd <= 1 .and.OutdyIB==1) jtRadi = nint(jtRadi2 * 3.0)
                    
                    dtRadi = max(600., min(7200., dt * jtRadi))
                    jtRadi = nint(real(dtRadi) / dt)
                endif
                if(mod(iterun, jtPhys) == 0) then
                    call PHY_SISVAT_MP(ihamr, nhamr)
#ifdef iso
                    iso_label = 'PHY_SISVAT'
                    iso_time = iso_time + 1
                    call mariso_write_file(iso_time, iso_label)
#endif(iso)
                endif
            endif
            
            ! +--Update of Surface Temperature
            ! +  =============================
            do n = 1, mw
                do j = 1, my
                    do i = 1, mx
                        tsrfSL(i, j, n) = tsrfSL(i, j, n) + dtgSL(i, j, n)
                    enddo
                enddo
            enddo
            if(reaLBC) then
                ! +  **********
                call LBCnud_srf
                ! +  **********
            
            endif
            
            do j = 1, my
                do i = 1, mx
                    TairSL(i, j) = 0.
                enddo
            enddo
            do iw = 1, mw
                do j = 1, my
                    do i = 1, mx
                        TairSL(i, j) = TairSL(i, j) + SLsrfl(i, j, iw) * tsrfSL(i, j, iw)
                    enddo
                enddo
            enddo
            do j = 1, my
                do i = 1, mx
                    pktaDY(i, j, mzz) = TairSL(i, j) / exp(cap * log(pstDY(i, j) + ptopDY))
                enddo
            enddo
            do k = 1, mz
                do j = 1, my
                    do i = 1, mx
#ifdef GR
                        ! 2D Gravity Current Simulation (Forcing : -10C/jour)
                        ! if (i >= imez-2.and.  &
                        !     i <= imez+2     ) &
                        !   pktRAd(i,j,k) = pktRAd(i,j,k) -31.d-6*dt
#endif
                        pktaDY(i, j, k) = pktaDY(i, j, k) + pktRAd(i, j, k)
                    enddo
                enddo
            enddo
#ifdef AO
            ! +--cpl : GIVE FIELDS TO OASIS
            ! +  ==========================
            !$OMP BARRIER
            !$OMP MASTER
            ! +  ***********
            call MAR_2_OASIS
            ! +  ***********
            !$OMP END MASTER
            !$OMP BARRIER
#endif
            ! ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            ! +++ TIME BASE ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            ! ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            
            itexpe = itexpe + 1
            iterun = iterun + 1
            
            ! +  ******
            call timgeo
            call timcur
            ! +  ******
            
            ! ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            ! +++ OUTPUT +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            ! ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            
            ! +--Ice-Sheet Surface Mass Balance
            ! +  ==============================
            if(iterun <= 1) then
                nbr_call_outice = ((3600. * 24. / OutdyIB) / (dt * 144.)) ! every 10min if 1 day
                nbr_call_outice = max(1, min(10, nbr_call_outice))
                do while(mod(int(real(3600. * 24. / OutdyIB) / dt) &
                        , nbr_call_outice) /= 0 .and. nbr_call_outice /= 1)
                    nbr_call_outice = nbr_call_outice - 1
                enddo
            endif
            if(iterun == 1 .or. mod(iterun, nbr_call_outice) == 0) then
                ! +  ******
                call OUTice
                ! +  ******
            endif
            
            ! +--Particular Output for Wind Vector
            ! +  =================================
            iout = 0
            
            if(mmy > 1 .and. mod(jmmMAR, 2) == 0 .and. jssMAR == 0) iout = 1
            if(mmy == 1 .and. mod(jmmMAR, 10) == 0 .and. jssMAR == 0) iout = 1
            
            if(iout == 1) then
                idum = 1
                jdum = 1
                adum = 0.0
                do i = ip11, mx1
                    do j = 1, my
                        if(adum < abs(uairDY(ip1(i), j, mz) - uairDY(im1(i), j, mz))) then
                            idum = i
                            jdum = j
                            adum = abs(uairDY(ip1(i), j, mz) - uairDY(im1(i), j, mz))
                        endif
                    enddo
                enddo
#ifdef NH
                ! +--Non-Hydrostatic Pressure Perturbation
                ! +  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
                pnhLav = 0.
                pnh_av = 0.
                do k = 1, mz
                    do j = jp11, my1
                        pnhLav = pnhLav + pairNH(ip11, j, k) * pstDYn(ip11, j) * sigma(k) &
                                + pairNH(mx1, j, k) * pstDYn(mx1, j) * sigma(k)
                    enddo
                    if(mmy > 1) then
                        do i = ip11, mx1
                            pnhLav = pnhLav + pairNH(i, jp11, k) * pstDYn(i, jp11) * sigma(k) &
                                    + pairNH(i, my1, k) * pstDYn(i, my1) * sigma(k)
                        enddo
                    endif
                    do j = jp11, my1
                        do i = ip11, mx1
                            pnh_av = pnh_av + pairNH(i, j, k) * pstDYn(i, j) * sigma(k)
                        enddo
                    enddo
                enddo
                if(mmy == 1) then
                    pnhLav = pnhLav / (2 * mz)
                    pnh_av = pnh_av / ((mx - 2) * mz)
                else
                    pnhLav = pnhLav / ((2 * (mx - 2) + 2 * (my - 2)) * mz)
                    pnh_av = pnh_av / ((mx - 2) * (my - 2) * mz)
                endif
#endif
                ! 2-D and 3-D Simulations
                id6 = 6
                idum = max(idum, 7)
                idum = min(idum, mx - 6)
#ifdef GR
                ! idum = mx - 6
#endif
#ifdef BS
                if(mmy == 1) idum = imez
#endif
                if(mmx == 1) then
                    ! 1-D Simulations
                    id6 = 0
                    idum = 1
                endif
                do i = idum - id6, idum + id6
                    vecx1(i) = 10.0 * (pstDYn(i, jdum) + ptopDY)
#ifdef NH
                    vecx3(i) = 10.0 * pstDYn(i, jdum) * pairNH(i, jdum, mz)
#endif
#ifdef BS
                    vecx4(i) = 0.0
                    do k = 1, mz
                        vecx4(i) = vecx4(i) + ssvSL(i, jdum, k) * qsHY(i, jdum, k) &
                                * pstDY(i, jdum) * dsigm1(k) &
                                * 1.0e3 * grvinv
                    enddo
#endif
                enddo
                if(mmx > 1 .and. mmy == 1) then
                    do i = imez - 10, imez + 30
                        vecx2(i) = 10.0 * (pstDYn(i, 1) - pstDYn(imez - 10, 1) &
                                - pstDY1(i, 1) + pstDY1(imez - 10, 1))
                    enddo
                endif
                if(mmx == 1) then
                    write(21, 21) itexpe, jdarGE, labmGE(mmarGE), iyrrGE, &
                            jhlrGE(iSND, jSND), minuGE, jsecGE, &
                            (uairDY(1, 1, k), k = mz - 9, mz), &
                            (vairDY(1, 1, k), k = mz - 9, mz)
                    21                  format(i5, i3, '-', a3, '-', i4, '/', i2, '.', i2, '.', i2, ' ||', 10f6.2, &
                            /, 24x, 'LT ||', 10f6.2)
                else
                    if(mmy > 1) then
                        
                        write(21, 22) itexpe, jdarGE, labmGE(mmarGE), iyrrGE, &
                                jhurGE, minuGE, jsecGE, &
                                (uairDY(i, jdum, mz), i = idum - 6, idum - 1), &
                                idum, jdum, (uairDY(i, jdum, mz), i = idum, idum + 5), &
                                ttime, itizGE(idum, jdum), &
                                (vecx1(i), i = idum - 6, idum - 1), &
                                xxkm(idum) / 1000., (vecx1(i), i = idum, idum + 5)
                        
                        22                      format(i9, i3, '-', a3, '-', i4, '/', i2, '.', i2, '.', i2, ' ||', 6f7.1, &
                                ' | (', i3, ',', i3, ')', f5.1, ' |', 5f7.1, &
                                /, 3x, a8, 9x, 'UT (', i3, ')   ||', 6f7.1, &
                                ' |', f6.0, 'km', f7.1, ' |', 5f7.1 &
                                )
                    else
                        
                        write(21, 23) itexpe, jdarGE, labmGE(mmarGE), iyrrGE, &
                                jhurGE, minuGE, jsecGE, &
                                (uairDY(i, jdum, mz), i = idum - 6, idum - 1), &
                                idum, jdum, (uairDY(i, jdum, mz), i = idum, idum + 5), &
                                ttime, itizGE(idum, jdum), &
                                (vecx1(i), i = idum - 6, idum - 1), &
                                xxkm(idum), (vecx1(i), i = idum, idum + 5)
                        
                        23                      format(i7, i3, '-', a3, '-', i4, '/', i2, '.', i2, '.', i2, ' ||', 6f7.1, &
                                ' | (', i4, ',', i2, ')', f5.1, ' |', 5f7.1, &
                                /, 3x, a8, 9x, 'UT (', i3, ') ||', 6f7.1, &
                                ' |', f6.0, 'km', f7.1, ' |', 5f7.1 &
                                )
                    endif
#ifdef NH
                    write(21, 24)(vecx3(i), i = idum - 6, idum - 1), &
                            (vecx3(i), i = idum, idum + 5)
#endif
                    24                  format(3x, 8x, 9x, '    ', 3x, '  ||', 6f7.1, &
                            ' |', 6x, '  ', f7.1, ' |', 5f7.1)
                    
                    25                  format('   p_HN Averages (Domain/LB) ||', 42x, &
                            ' | [Pa]   ', f7.1, ' |', f7.1)
                endif
                ! +
                if(mmx > 1 .and. mmy == 1) then
                    ppp = 10 * pstDY(imez - 10, 1)
                    write(22, 221) itexpe, (uairDY(i, 1, mz), i = imez - 10, imez + 30)
                    write(23, 221) itexpe, ((tairDY(i, 1, mz) - TfSnow), i = imez - 10, imez + 30)
                    221                 format(i10, 20f5.1, /, 10x, 21f5.1)
                    write(24, 223) itexpe, (vecx2(i), i = imez - 10, imez + 30)
                    223                 format(i10, 20f5.2, /, 10x, 21f5.2)
                endif
                ! +
            
            endif
            
            ! +
            ! ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            ! +++ end   of the INTERNAL TIME INCREMENTATION (nboucl over dt) +++++++++++
            ! ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            ! +
#ifdef iso
            iso_label = 'TIME end  '
            iso_time = iso_time + 1
            call mariso_write_file(iso_time, iso_label)
#endif(iso)
        enddo
        !CAa iboucl = iboucl + 1
        !CAa if (iboucl <= nboucl)       go to  2
        ! +
        ! +--Vertical Wind Speed wairDY (z Coordinate system)
        ! +  ================================================
        ! +
        ! CAa : stand alone surface model disactivated for simplification (GO TO)
        !    #ifdef SA
        !    if (sALONE) go to 40
        !    #endif
        ! +
        ! +                               ******
        if(.not. convec .and. mmx > 1) call dynwww
        ! +                               ******
        ! +
        ! +
        
        !CAa 40 continue
        
        ! +--OUTPUT for Graphs
        ! +  =================
        !CAa iprint = iprint + 1
        if(log_nc == 1) then
            ! + dt_Loc is assumed
            ! +  ******
            ipr_nc = ipr_nc + 1
            call out_nc(ipr_nc)
            ! +  ******
        else
            ! +  ******
            call OUTgks
            ! +  ******
        endif
        
        ! +--Save of Model Variables
        ! +  =======================
        if(safVAR .and. jdh_LB /= -1) then
            ! +  ******
            call outsav
            ! +  ******
        else if(jdh_LB == -1) then
            write(6, 6600)
            6600        format(/, '############################################', &
                    /, '# NO LATERAL BOUNDARY CONDITIONS AVAILABLE #', &
                    /, '############################################', /, 1x)
            stop
        endif
        
        ! ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        ! +++ end   of the EXTERNAL TIME INCREMENTATION (nprint over dt * nboucl) ++
        ! ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    enddo
    !CAa if (iprint >= nprint) go to 30
    !CAa go to 3
    !CAa 30 continue
    
    ! ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    ! +++ CLOSE FILES ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    ! ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    close(unit = 4)
    close(unit = 21)
    
    if(mx > 1 .and. my <= 1) then
        close(unit = 22)
        close(unit = 23)
        close(unit = 24)
    endif
    
    ! ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    ! +++ end OF RUN +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    ! ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

#ifdef SB
    ! +  ******
    call sbcnew
    ! +  ******
#endif
#ifdef AO
    ! +--Coupling termination
    ! +  ====================
    !$OMP BARRIER
    !$OMP MASTER
    ! +  *********************
    call oasis_terminate(info)
    ! +  *********************
    if(info /= OASIS_Ok) then
        WRITE(6, *) 'An error occured in '
        WRITE(6, *) 'oasis_terminate = '
        WRITE(6, *) info
    endif
    !$OMP END MASTER
    !$OMP BARRIER
#endif
    
    ! +--MAR termination
    ! +  ===============
    open(unit = 1, status = 'unknown', file = 'MAR.OK')
    write(1, 1000) itexpe, jdarGE, labmGE(mmarGE), iyrrGE, &
            jhurGE, minuGE, jsecGE
    write(6, 1000) itexpe, jdarGE, labmGE(mmarGE), iyrrGE, &
            jhurGE, minuGE, jsecGE
    1000 format('MAR execution stopped normaly at iteration', i8, &
            /, 'Time          is', i13, '-', a3, '-', i4, &
            '/', i2, '.', i2, '.', i2, ' UT')
    close(unit = 1)
    
    stop
endprogram mar
