PWD=$pwd

CODEdir=".."

echo "fpp: $CODEdir/src/*.f90 -> $CODEdir/"
for file in *.f90 ; do
  fpp -P $file > $CODEdir/$file
done

export PATH="$PATH":"$HOME/.local/bin"

# fix comment indentation with fprettify: https://github.com/pseewald/fprettify
echo "indent: fprettify"
check_fprettify=$(pip list | grep fprettify | wc -l)
[[ $check_fprettify == 0 ]] && pip install --upgrade fprettify
cd $CODEdir
i=1
for file in *.f90 ; do
  sed -i 's/^!/ !/g' $file 
  echo $file
  fprettify -w 4 --whitespace-intrinsics False --indent 4  $file &
  i=$(( $i + 1 ))
  [ $i -ge 5 ] && i=1 && wait
done

cd $PWD
