#include "MAR_pp.def"
subroutine LBCnud_srf
    ! +------------------------------------------------------------------------+
    ! | MAR, Routine LBCnud_srf                                 4-06-2002  MAR |
    ! |              LBCnud_srf includes the Surface Boundary Conditions       |
    ! |              corresponding to Surface Variables                        |
    ! |                                                                        |
    ! +------------------------------------------------------------------------+
    ! |                                                                        |
    ! |   INPUT : sst_LB: Surface Temperature LBC                              |
    ! |   ^^^^^^^                                                              |
    ! |                                                                        |
    ! |   OUTPUT: tsrfSL: Surface Temperature                                  |
    ! |   ^^^^^^^                                                              |
    ! +------------------------------------------------------------------------+
    ! +
    use marctr
    use marphy
    use mardim
    use margrd
    use mar_lb
    use mar_sl
    ! +
    implicit none
    ! +
    ! +--Local  Variables
    ! +  ================
    ! +
    integer i, j, k, m
    logical MAR_SI
    ! +
    ! +
    ! +--Initialization
    ! +  ==============
    ! +
    MAR_SI = .false.
    if(VSISVAT) MAR_SI = .true.
    ! +
    ! +
    ! +--LBC: New Surface Temperatures
    ! +  =============================
    ! +
    if(.not. polmod .and. .not. MAR_SI) then
        do j = 1, my
            do i = 1, mx
                if(isolSL(i, j) <= 2) then
                    tsrfSL(i, j, 1) = sst_LB(i, j)

                    ! +---1. Open Water
                    ! +   ~~~~~~~~~~~~~
                    if(sst_LB(i, j) > Tfr_LB) then
                        isolSL(i, j) = 1
                        d1_SL(i, j) = 2.09d+8
                        albeSL(i, j) = 0.10
                        eps0SL(i, j) = 0.97
                        SL_z0(i, j, 1) = zs_SL
                        SL_r0(i, j, 1) = 0.1 * zs_SL
                        ch0SL(i, j) = 0.00132
                        rsurSL(i, j) = 0.0

                        ! +---2. Sea Ice
                        ! +   ~~~~~~~~~~
                    else
                        isolSL(i, j) = 2
                        d1_SL(i, j) = 1.05d+5
                        albeSL(i, j) = 0.70d00
                        eps0SL(i, j) = 0.97d00
                        SL_z0(i, j, 1) = zn_SL
                        SL_r0(i, j, 1) = 0.1 * zn_SL
                        ch0SL(i, j) = 0.0021
                        ! +...          (Kondo and Yamazaki, 1990, JAM 29, p.376)
                        rsurSL(i, j) = 0.0
                    endif
                endif
            enddo
        enddo
    endif
    ! +
    return
endsubroutine LBCnud_srf
