#include "MAR_pp.def"
subroutine lbcnud_par
    ! +------------------------------------------------------------------------+
    ! | MAR DYNAMICS LBC                                       26-09-2001  MAR |
    ! |   subroutine lbcnud_par initialize the implicit numerical scheme       |
    ! |               for LBC on Wind Component parallel to the Boundary       |
    ! |                                                                        |
    ! +------------------------------------------------------------------------+
    ! |                                                                        |
    ! |   REFER. : Davies, QJRMS 102, pp.405--418, 1976                        |
    ! |   ^^^^^^^^                                                             |
    ! |                                                                        |
    ! |   INPUT  : vaXX : large scale values of relevant dependant variables   |
    ! |   ^^^^^^^^   ^X=(x->x axis border, y->y axis border)                   |
    ! |               ^X=(g->x small, d->x large, b->y small, h->y large)      |
    ! |                                                                        |
    ! |   OUTPUT : wiXX : coefficient used in semi-implicit numerical scheme   |
    ! |   ^^^^^^^^ tiXX : independant term of semi-implicit numerical scheme   |
    ! |              ^X=(x->x axis border--variable v,                         |
    ! |                  y->y axis border--variable u)                         |
    ! |               ^X=(g->x small, d->x large, b->y small, h->y large)      |
    ! |                                                                        |
    ! +------------------------------------------------------------------------+
    use marctr
    use marphy
    use mardim
    use margrd
    use mar_lb

    implicit none

    ! +--Local  Variables
    ! +  ================
    integer i, j, k, m
    integer il, ic, ii, nn, n2, n3, n4, lmin, lmax, jl, jc, iv_nup, n1
    real wkxd(mx - n6:mx1, mx - n6:mx1)

    ! +--Matrix Inversion for x large (Reference Boundary)
    ! +  =================================================
    ! +
    if(iterun == 0) then
        ! +
        if(mmx > 1) then
            ! +
            do il = mx - n6, mx1
                do ic = mx - n6, mx1
                    wkxd(il, ic) = 0.d0
                enddo
            enddo
            ! +
            do ii = mx - n6, mmx2
                wkxd(ii, ii + 1) = rxLB(ii + 1) - rxLB(ii)
            enddo
            do ii = mx - n6, mmx1
                wkxd(ii, ii) = 1 + 2 * rxLB(ii) + rxLB(ii + 1) - rxLB(ii - 1)
            enddo
#ifdef OB
            wkxd(mx1, mx1) = 1 + rxLB(mx) - rxLB(mmx2)
#endif
            do ii = mx - n6 + 1, mmx1
                wkxd(ii, ii - 1) = rxLB(ii)
            enddo
            do nn = 1, n6 - 3
                n2 = nn + 1
                n3 = nn + 2
                n4 = n6 - 1 - nn
                do ii = mx - n4, mmx1
                    wkxd(ii, ii - n2) = rxLB(ii - nn) - rxLB(ii - n3)
                enddo
            enddo
            ! +
            wkxd(mx1, mx - n6) = rxLB(mmx5)
            ! +
            lmin = mx - n6
            lmax = mx1
            ! +
            ! +  ******
            call matinv(wkxd, wixdLB, lmin, lmax)
            ! +  ******
            ! +
            ! +--Inverted Matrices at Other Boundaries
            ! +  =====================================
            ! +
            do il = 2, n7
                do ic = 2, n7
                    wixgLB(il, ic) = wixdLB(mx + 1 - il, mx + 1 - ic)
                enddo
            enddo
            ! +...    x small
            ! +
        endif
        ! +
        if(mmy > 1) then
            ! +
            do jl = 2, n7
                do jc = 2, n7
                    wiyiLB(jl, jc) = wixgLB(jl, jc)
                enddo
            enddo
            ! +...    y small
            ! +
            do jl = 2, n7
                do jc = 2, n7
                    wiysLB(my + 1 - jl, my + 1 - jc) = wiyiLB(jl, jc)
                enddo
            enddo
            ! +...    y large
            ! +
        endif
    endif
    ! +
    ! +
    ! +--Independant Terms (Constant Coefficients)
    ! +  =========================================
    ! +
    ! +--x Boundaries
    ! +  ------------
    ! +
    if(mmx > 1) then
        ! +
        iv_nup = 2
        do k = 1, mz
            do j = 1, my
                ! +
                ! +--x large
                ! +  ~~~~~~~
                do i = mx - n6, mmx1
                    tixdLB(i, j, k) = rxLB(n50xLB) * vaxdLB(mx - n6, j, k, iv_nup)
                enddo
                do i = mx - n6, mmx2
                    tixdLB(i, j, k) = tixdLB(i, j, k) + (rxLB(i + 1) &
                                                         - rxLB(i)) * vaxdLB(i + 1, j, k, iv_nup)
                enddo
                do i = mx - n6 + 1, mmx2
                    tixdLB(i, j, k) = tixdLB(i, j, k) + (2 * rxLB(i) + rxLB(i + 1) &
                                                         - rxLB(i - 1)) * vaxdLB(i, j, k, iv_nup)
                enddo
                do i = mx - n6 + 2, mmx1
                    tixdLB(i, j, k) = tixdLB(i, j, k) &
                                      + rxLB(n40xLB) * vaxdLB(n50xLB, j, k, iv_nup)
                enddo
                ! +
                do nn = n6 - 4, n6 - 3
                    n1 = nn + 1
                    n2 = nn + 2
                    do i = mx - nn, mmx1
                        tixdLB(i, j, k) = tixdLB(i, j, k) &
                                          + (rxLB(mx - nn) - rxLB(mx - n2)) * &
                                          vaxdLB(mx - n1, j, k, iv_nup)
                    enddo
                enddo
                ! +
#ifdef OB
                if(openLB) then
                    tixdLB(mx1, j, k) = tixdLB(mx1, j, k) &
                                        + (rxLB(mmx1) - rxLB(mmx3)) * &
                                        vaxdLB(mmx2, j, k, iv_nup) &
                                        + 3 * rxLB(mmx1) * vaxdLB(mmx1, j, k, iv_nup)
                else
#endif
                    tixdLB(mx1, j, k) = tixdLB(mx1, j, k) &
                                        + (rxLB(mmx1) - rxLB(mmx3)) * &
                                        vaxdLB(mmx2, j, k, iv_nup) &
                                        + 2 * rxLB(mmx1) * vaxdLB(mmx1, j, k, iv_nup)
#ifdef OB
                endif
#endif
                ! +
                ! +--x small
                ! +  ~~~~~~~
                do i = n7mxLB, 2, -1
                    tixgLB(i, j, k) = rxLB(n6mxLB) * &
                                      vaxgLB(n7mxLB, j, k, iv_nup)
                enddo
                do i = n7mxLB, 3, -1
                    tixgLB(i, j, k) = tixgLB(i, j, k) + (rxLB(i - 1) &
                                                         - rxLB(i)) * vaxgLB(i - 1, j, k, iv_nup)
                enddo
                do i = n6, 3, -1
                    tixgLB(i, j, k) = tixgLB(i, j, k) + &
                                      (2 * rxLB(i) + rxLB(i - 1) &
                                       - rxLB(i + 1)) * vaxgLB(i, j, k, iv_nup)
                enddo
                do i = n6 - 1, 2, -1
                    tixgLB(i, j, k) = tixgLB(i, j, k) &
                                      + rxLB(n5mxLB) * vaxgLB(n6mxLB, j, k, iv_nup)
                enddo
                ! +
                do nn = n6 - 3, n6 - 2
                    n1 = nn + 1
                    n2 = nn + 2
                    do i = nn, 2, -1
                        tixgLB(i, j, k) = tixgLB(i, j, k) &
                                          + (rxLB(nn) - rxLB(n2)) * &
                                          vaxgLB(n1, j, k, iv_nup)
                    enddo
                enddo
                ! +
#ifdef OB
                if(openLB) then
                    tixgLB(2, j, k) = tixgLB(2, j, k) &
                                      + (rxLB(m0x2) - rxLB(m0x4)) * &
                                      vaxgLB(m0x3, j, k, iv_nup) + &
                                      3 * rxLB(m0x2) * vaxgLB(m0x2, j, k, iv_nup)
                else
#endif
                    tixgLB(2, j, k) = tixgLB(2, j, k) + &
                                      (rxLB(m0x2) - rxLB(m0x4)) * &
                                      vaxgLB(m0x3, j, k, iv_nup) + &
                                      2 * rxLB(m0x2) * vaxgLB(m0x2, j, k, iv_nup)
#ifdef OB
                endif
#endif
            enddo
            ! +
        enddo
        ! +
    endif
    ! +
    ! +
    ! +--y Boundaries
    ! +  ------------
    ! +
    if(mmy > 1) then
        ! +
        iv_nup = 1
        do k = 1, mz
            do i = 1, mx
                ! +
                ! +--y large
                ! +  ~~~~~~~
                do j = my - n6, mmy1
                    tiysLB(i, j, k) = ryLB(n50yLB) &
                                      * vaysLB(i, my - n6myLB, k, iv_nup)
                enddo
                do j = my - n6, mmy2
                    tiysLB(i, j, k) = tiysLB(i, j, k) + (ryLB(j + 1) &
                                                         - ryLB(j)) * vaysLB(i, j + 1, k, iv_nup)
                enddo
                do j = my - n6 + 1, mmy2
                    tiysLB(i, j, k) = tiysLB(i, j, k) + (2 * ryLB(j) + ryLB(j + 1) &
                                                         - ryLB(j - 1)) * vaysLB(i, j, k, iv_nup)
                enddo
                do j = my - n6 + 2, mmy1
                    tiysLB(i, j, k) = tiysLB(i, j, k) &
                                      + ryLB(n40yLB) * vaysLB(i, my - n6 + 1, k, iv_nup)
                enddo
                ! +
                do nn = n6 - 4, n6 - 3
                    n1 = nn + 1
                    n2 = nn + 2
                    do j = my - 3, mmy1
                        tiysLB(i, j, k) = tiysLB(i, j, k) &
                                          + (ryLB(my - nn) - ryLB(my - n2)) * vaysLB(i, my - n1, k, iv_nup)
                    enddo
                enddo
                ! +
#ifdef OB
                if(openLB) then
                    tiysLB(i, my1, k) = tiysLB(i, my1, k) &
                                        + (ryLB(mmy1) - ryLB(mmy3)) * vaysLB(i, mmy2, k, iv_nup) &
                                        + 3 * ryLB(mmy1) * vaysLB(i, mmy1, k, iv_nup)
                else
#endif
                    tiysLB(i, my1, k) = tiysLB(i, my1, k) &
                                        + (ryLB(mmy1) - ryLB(mmy3)) * vaysLB(i, mmy2, k, iv_nup) &
                                        + 2 * ryLB(mmy1) * vaysLB(i, mmy1, k, iv_nup)
#ifdef OB
                endif
#endif
                ! +
                ! +--y small
                ! +  ~~~~~~~
                do j = n7, 2, -1
                    tiyiLB(i, j, k) = ryLB(n6myLB) * vayiLB(i, n7myLB, k, iv_nup)
                enddo
                do j = n7, 3, -1
                    tiyiLB(i, j, k) = tiyiLB(i, j, k) + (ryLB(j - 1) &
                                                         - ryLB(j)) * vayiLB(i, j - 1, k, iv_nup)
                enddo
                do j = n6, 3, -1
                    tiyiLB(i, j, k) = tiyiLB(i, j, k) + (2 * ryLB(j) + ryLB(j - 1) &
                                                         - ryLB(j + 1)) * vayiLB(i, j, k, iv_nup)
                enddo
                do j = n6 - 1, 2, -1
                    tiyiLB(i, j, k) = tiyiLB(i, j, k) &
                                      + ryLB(n5myLB) * vayiLB(i, n6myLB, k, iv_nup)
                enddo
                ! +
                do nn = n6 - 3, n6 - 2
                    n1 = nn + 1
                    n2 = nn + 2
                    do j = nn, 2, -1
                        tiyiLB(i, j, k) = tiyiLB(i, j, k) &
                                          + (ryLB(nn) - ryLB(n2)) * vayiLB(i, n2, k, iv_nup)
                    enddo
                enddo
                ! +
                j = 2
#ifdef OB
                if(openLB) then
                    tiyiLB(i, 2, k) = tiyiLB(i, 2, k) &
                                      + (ryLB(m0y2) - ryLB(m0y4)) * vayiLB(i, m0y3, k, iv_nup) &
                                      + 3 * ryLB(m0y2) * vayiLB(i, m0y2, k, iv_nup)
                else
#endif
                    tiyiLB(i, 2, k) = tiyiLB(i, 2, k) &
                                      + (ryLB(m0y2) - ryLB(m0y4)) * vayiLB(i, m0y3, k, iv_nup) &
                                      + 2 * ryLB(m0y2) * vayiLB(i, m0y2, k, iv_nup)
#ifdef OB
                endif
#endif
            enddo
        enddo
        ! +
    endif
    ! +
    return
endsubroutine lbcnud_par
