#include "MAR_pp.def"
subroutine lbcnud_ini
    ! +------------------------------------------------------------------------+
    ! | MAR DYNAMICS LBC                                       18-09-2001  MAR |
    ! |   subroutine lbcnud_ini initialize the Nudging Coefficient             |
    ! |                 for the lateral boundary conditions of Davies, 1983    |
    ! |                                                                        |
    ! +------------------------------------------------------------------------+
    ! |                                                                        |
    ! |   REFER. : Davies, MWR   111, p.1002-1012, 1983                        |
    ! |   ^^^^^^^^                                                             |
    ! |                                                                        |
    ! |   OUTPUT : rxLB,ryLB: nudging coefficients of the relaxation zones     |
    ! |   ^^^^^^^^                                                             |
    ! +------------------------------------------------------------------------+
    use marctr
    use marphy
    use mardim
    use margrd
    use mar_lb
    use mar_io

    implicit none

    ! +--Local  Variables
    ! +  ================
    integer i, j, k, m
    real d25
#ifdef da
    real cspeed
    ! +--Nudging Coefficient Multiplied by the Time Step
    ! +  ===============================================
    cspeed = 300.d0 * max(n6 - 1, 1) * max(n6 - 1, 1) &
             / (max(n6 - 2, 1) * max(n6 - 2, 1))
    ! rxbase: Optimal Maximum Relaxation Coefficient
    !         (see Davies 1983, MWR 111 p. 1007, 2e col. K*  = K(dx)/c,
    !                           with K*~0.5, c= c_max= sqrt(gH)=300m/s)
    rxbase = cspeed / (2.d0 * dx)
    ! rxfact: Such that nu* < 1, but Diffusion_Relaxation replaces Diffusion
    !         (see Davies 1983, MWR 111 p. 1004, 1e col. nu* = K(dx)/c,
    !                                   p. 1007, 1e col. 21b)
    rxfact = 0.5 * dt * max(n6 - 1, 1) * max(n6 - 1, 1) &
             / (max(n6 - 2, 1) * max(n6 - 2, 1))
#endif
    if(IO_loc >= 2) write(21, 999) rxbase, rxfact
999 format(/, '   --- Initialisation / lbcnud_ini ---', &
            /, '       K(relax)max =', f14.6, ' (Davies 1983 MWR)', &
            /, '       K_H(fac)    =', f14.6)
    ! +
    d25 = (n6 - 1) * (n6 - 1)
    rxLB(1) = 0.d0
    rxLB(mx) = 0.d0
    if(mmx > 1) then
        do i = ip11, mx1
            rxLB(i) = (max(0, n6 - i) * max(0, n6 - i) &
                       + max(0, n6 - 1 + i - mx) * max(0, n6 - 1 + i - mx)) &
                      * rxbase / d25
        enddo
    endif
    ! +
    ryLB(1) = 0.d0
    ryLB(my) = 0.d0
    if(mmy > 1) then
        do j = jp11, my1
            ryLB(j) = (max(0, n6 - j) * max(0, n6 - j) &
                       + max(0, n6 - 1 + j - my) * max(0, n6 - 1 + j - my)) &
                      * rxbase / d25
        enddo
    endif
    ! +
    return
endsubroutine lbcnud_ini
