#include "MAR_pp.def"
subroutine LBCnud_000(f_LBC0, iv_nu0, kd_nu0)
    ! +------------------------------------------------------------------------+
    ! | MAR DYNAMICS LBC                                       29-01-2020  MAR |
    ! |   subroutine LBCnud_000 computes the Lateral Boundary Conditions       |
    ! |              following the Davies (1976) scheme                        |
    ! |              assuming  zero Outer Fields                               |
    ! |                                                                        |
    ! +------------------------------------------------------------------------+
    ! |                                                                        |
    ! |   INPUT / OUTPUT : f_LBC0, i.e. w,pairNH, ccniHY, qi,qs,qr,qwHY        |
    ! |   ^^^^^^^^     for iv_nu0 =            3,      3,  3, 3, 3,   3)       |
    ! |                    f_LBC0 reevalued on a 5-points width boundary zone  |
    ! |                                                                        |
    ! |   INPUT:   iv_nu0: Index of the Variable to relax to Outer Conditions  |
    ! |   ^^^^^^   kd_nu0: Maximum Value of the k (vertical) Index             |
    ! |                                                                        |
    ! |   INPUT (via common block)                                             |
    ! |   ^^^^^    reaLBC: Input INI: Previous Dyn.Simulation (MAR .or. GCM)   |
    ! |            rxfact: Lateral Sponge Coefficient         (A89)            |
    ! |            rxLB,ryLB: Nudging Coefficient                              |
    ! |            Independant Term  used in the Implicit Scheme               |
    ! |                                                                        |
    ! |   REFER. : Davies, QJRMS 102, pp.405--418, 1976  (relation 11 p.409)   |
    ! |   ^^^^^^^^                                                             |
    ! +------------------------------------------------------------------------+
    use marctr
    use marphy
    use mardim
    use margrd
    use mar_lb
    use mar_wk

    implicit none

    !    Global Variables
    !    ================

    real f_LBC0(mx, my, mz)
    integer iv_nu0, kd_nu0

    !    Local  Variables
    !    ================

    integer i, j, k, m
    logical relaxg

    ! fmag0X:magnification factor (=>nudging selectively modified)
    real fmag0g(6), fmag0d(6), fmag0b(6), fmag0h(6)
    data fmag0g/1.0e0, 1.0e0, 1.0e0, 1.0e0, 1.0e0, 1.0e0/
    data fmag0d/1.0e0, 1.0e0, 1.0e0, 1.0e0, 1.0e0, 1.0e0/
    data fmag0b/1.0e0, 1.0e0, 1.0e0, 1.0e0, 1.0e0, 1.0e0/
    data fmag0h/1.0e0, 1.0e0, 1.0e0, 1.0e0, 1.0e0, 1.0e0/
#ifdef OG
    ! relaxg=.false.==> NO nudging  at the left boundary.
    data relaxg/.false./
#endif

    !    x Boundaries
    !    ============

!$OMP PARALLEL do default(shared) private(i,j,k)
    do k = 1, kd_nu0

        if(mmx > 1) then

#ifdef OG
            if(relaxg) then
#endif
                do i = ip11, n6 - 1
                    !         do k=  1 ,kd_nu0
                    do j = jp11, my1
                        f_LBC0(i, j, k) = f_LBC0(i, j, k) &
                                          / (1.0 + fmag0g(iv_nu0) * rxLB(i))
                    enddo
                    !         end do
                enddo
#ifdef OG
            endif
#endif

            do i = mx - n6 + 2, mx1
                !         do k=  1    ,kd_nu0
                do j = jp11, my1
                    f_LBC0(i, j, k) = f_LBC0(i, j, k) &
                                      / (1.0 + fmag0d(iv_nu0) * rxLB(i))
                enddo
                !         end do
            enddo

            !    Zero Gradient at x LBC if fmag0g,d = 0
            !    --------------------------------------

            !         do k=  1 ,kd_nu0
            do j = jp11, my1
                f_LBC0(1, j, k) = (1.-fmag0g(iv_nu0)) * f_LBC0(ip11, j, k) ! 0-grad.
                !    .                       +     fmag0g(iv_nu0) *f_LBC0(   1,j,k) ! 0 at x-LB
                f_LBC0(mx, j, k) = (1.-fmag0d(iv_nu0)) * f_LBC0(mx1, j, k) ! 0-grad.
                !    .                       +     fmag0d(iv_nu0) *f_LBC0( mx ,j,k) ! 0 at x-LB
            enddo
            !         end do

            !    Nudging to zero in in the lateral Sponge
            !    ----------------------------------------

            do i = ip11, n6 - 1
                !         do k=  1 ,kd_nu0
                do j = jp11, my1
                    WKxyz1(i, j, k) = f_LBC0(i, j, k) + rxfact * rxLB(i) &
                                      * (f_LBC0(i + 1, j, k) + f_LBC0(i - 1, j, k) &
                                         - f_LBC0(i, j, k) - f_LBC0(i, j, k))
                enddo
                !         end do
            enddo

            do i = ip11, n6 - 1
                !         do k=  1 ,kd_nu0
                do j = jp11, my1
                    f_LBC0(i, j, k) = WKxyz1(i, j, k)
                enddo
                !         end do
            enddo

            do i = mx - n6 + 2, mx1
                !         do k=  1    ,kd_nu0
                do j = jp11, my1
                    WKxyz1(i, j, k) = f_LBC0(i, j, k) + rxfact * rxLB(i) &
                                      * (f_LBC0(i + 1, j, k) + f_LBC0(i - 1, j, k) &
                                         - f_LBC0(i, j, k) - f_LBC0(i, j, k))
                enddo
                !         end do
            enddo

            do i = mx - n6 + 2, mx1
                !         do k=  1    ,kd_nu0
                do j = jp11, my1
                    f_LBC0(i, j, k) = WKxyz1(i, j, k)
                enddo
                !         end do
            enddo

            !    Zero Gradient at x LBC if fmag0g,d = 0
            !    --------------------------------------

            !         do k=  1 ,kd_nu0
            do j = jp11, my1
                f_LBC0(1, j, k) = (1.-fmag0g(iv_nu0)) * f_LBC0(ip11, j, k) ! 0-grad.
                !    .                       +     fmag0g(iv_nu0) *f_LBC0(   1,j,k) ! 0 at x-LB
                f_LBC0(mx, j, k) = (1.-fmag0d(iv_nu0)) * f_LBC0(mx1, j, k) ! 0-grad.
                !    .                       +     fmag0d(iv_nu0) *f_LBC0( mx ,j,k) ! 0 at x-LB
            enddo
            !         end do

        endif

        !    y Boundaries
        !    ============

        if(mmy > 1) then

            do j = jp11, n6 - 1
                !         do k=  1 ,kd_nu0
                do i = 1, mx
                    f_LBC0(i, j, k) = f_LBC0(i, j, k) &
                                      / (1.0 + fmag0b(iv_nu0) * ryLB(j))
                enddo
                !         end do
            enddo

            do j = my - n6 + 2, my1
                !         do k=  1    ,kd_nu0
                do i = 1, mx
                    f_LBC0(i, j, k) = f_LBC0(i, j, k) &
                                      / (1.0 + fmag0h(iv_nu0) * ryLB(j))
                enddo
                !         end do
            enddo

            !    Zero Gradient at y LBC if fmag0b,h = 0
            !    --------------------------------------

            !         do k=  1 ,kd_nu0
            do i = 1, mx
                f_LBC0(i, 1, k) = (1.-fmag0b(iv_nu0)) * f_LBC0(i, jp11, k) ! 0-grad.
                !    .                     +     fmag0b(iv_nu0) *f_LBC0(i,   1,k) ! 0 at y-LB
                f_LBC0(i, my, k) = (1.-fmag0h(iv_nu0)) * f_LBC0(i, my1, k) ! 0-grad.
                !    .                     +     fmag0h(iv_nu0) *f_LBC0(i, my ,k) ! 0 at y-LB
            enddo
            !         end do

            !    Nudging to zero in in the lateral Sponge
            !    ----------------------------------------

            do j = 2, n6 - 1
                !         do k=  1 ,kd_nu0
                do i = ip11, mx1
                    WKxyz2(i, j, k) = f_LBC0(i, j, k) + rxfact * ryLB(j) &
                                      * (f_LBC0(i, j + 1, k) + f_LBC0(i, j - 1, k) &
                                         - f_LBC0(i, j, k) - f_LBC0(i, j, k))
                enddo
                !         end do
            enddo

            do j = 2, n6 - 1
                !         do k=  1 ,kd_nu0
                do i = ip11, mx1
                    f_LBC0(i, j, k) = WKxyz2(i, j, k)
                enddo
                !         end do
            enddo

            do j = my - n6 + 2, my1
                !         do k=  1    ,kd_nu0
                do i = ip11, mx1
                    WKxyz2(i, j, k) = f_LBC0(i, j, k) + rxfact * ryLB(j) &
                                      * (f_LBC0(i, j + 1, k) + f_LBC0(i, j - 1, k) &
                                         - f_LBC0(i, j, k) - f_LBC0(i, j, k))
                enddo
                !         end do
            enddo

            do j = my - n6 + 2, my1
                !         do k=  1    ,kd_nu0
                do i = ip11, mx1
                    f_LBC0(i, j, k) = WKxyz2(i, j, k)
                enddo
                !         end do
            enddo

            !    Zero Gradient at y LBC if fmag0b,h = 0
            !    --------------------------------------

            !         do k=  1 ,kd_nu0
            do j = jp11, my1
                f_LBC0(i, 1, k) = (1.-fmag0b(iv_nu0)) * f_LBC0(i, jp11, k) ! 0-grad.
                !    .                     +     fmag0b(iv_nu0) *f_LBC0(i,   1,k) ! 0 at y-LB
                f_LBC0(i, my, k) = (1.-fmag0h(iv_nu0)) * f_LBC0(i, my1, k) ! 0-grad.
                !    .                     +     fmag0h(iv_nu0) *f_LBC0(i, my ,k) ! 0 at y-LB
            enddo
            !         end do

#ifdef OB
            do k = 1, kd_nu0
                f_LBC0(1, 1, k) = (f_LBC0(1, jp11, k) + f_LBC0(ip11, 1, k)) * 0.5
                f_LBC0(mx, 1, k) = (f_LBC0(mx, jp11, k) + f_LBC0(mx1, 1, k)) * 0.5
                f_LBC0(1, my, k) = (f_LBC0(1, my1, k) + f_LBC0(ip11, my, k)) * 0.5
                f_LBC0(mx, my, k) = (f_LBC0(mx, my1, k) + f_LBC0(mx1, my, k)) * 0.5
            enddo
#endif

        endif

        ! +--Work Arrays Reset
        ! +  =================

        !         do k=1,mz
        do j = 1, my
            do i = 1, mx
                WKxyz1(i, j, k) = 0.0
                WKxyz2(i, j, k) = 0.0
            enddo
        enddo
    enddo
!$OMP END PARALLEL DO

    return
endsubroutine LBCnud_000
