#include "MAR_pp.def"
subroutine INIubc(ihamr_ubc, nhamr_ubc, newubcINI)
    ! +------------------------------------------------------------------------+
    ! | MAR INPUT    Upper Sponge                          Thu 05-11-2009  MAR |
    ! |   subroutine INIubc is used to initialize MAR Upper Sponge Refer.State |
    ! |                                                                        |
    ! +------------------------------------------------------------------------+
    ! |                                                                        |
    ! |   INPUT:  ihamr_ubc: Time Digital Filter Status                        |
    ! |   ^^^^^   nhamr_ubc: Time Digital Filter Set Up                        |
    ! |                                                                        |
    ! |   OUTPUT: newubcINI: (0,1) ==> (NO new ubc , new ubc)                  |
    ! |   ^^^^^^^                                                              |
    ! |                                                                        |
    ! |   OUTPUT: uairUB: Current                     x-Wind Speed Component   |
    ! |   ^^^^^^^ ua1_UB: Previous Nesting Time Step  x-Wind Speed Component   |
    ! |           ua2_UB: Next     Nesting Time Step  x-Wind Speed Component   |
    ! |           vairUB, va1_UB, va2_UB, pktaUB, pkt1UB, pkt2UB: idem         |
    ! |           tim1UB,tim2UB:   Times  n, n+1  of  uairUB, vairUB, pktaUB   |
    ! |                                                                        |
    ! |   CAUTION: It is assumed that tim1UB and tim2UB do not change when the |
    ! |   ^^^^^^^^ Variables are reassigned after the dynamical Initialization |
    ! |            (Reassignation => itexpe := nham => timar := timar-nham*dt) |
    ! |                                                                        |
    ! |   MODIF.   5 Nov 2009   : Map Scaling Factor SFm_DY scales (u,v) at UB |
    ! |   ^^^^^                   (i.e., ua2_UB, va2_UB are divided by SFm_DY) |
    ! |                                                                        |
    ! +------------------------------------------------------------------------+

    use marctr
    use marphy
    use mardim
    use margrd
    use mar_ge
    use mar_dy
    use mar_ub

    implicit none

    integer ihamr_ubc, nhamr_ubc
    integer newubcINI

    ! +--Local  Variables
    ! +  ================

    integer i, j, k, m
    integer(kind=8) itimUB
    real rate

    ! +--Current Time
    ! +  ============

    itimUB = ou2sGE(iyrrGE, mmarGE, jdarGE, jhurGE, minuGE, jsecGE)
#ifdef HF
    itimUB = itimUB + (ihamr_ubc + nhamr_ubc) * idt
#endif

    ! +--Reinitialization of the Upper Sponge Reference State
    ! +  ----------------------------------------------------

    if(iterun == 0) then
        jdh_UB = 1
        iyr_UB = iyrrGE
        mma_UB = mmarGE
        jda_UB = jdarGE
        jhu_UB = jhurGE
        tim1UB = itimUB
        tim2UB = itimUB
        do k = 1, mzabso
            do j = 1, my
                do i = 1, mx
                    ua1_UB(i, j, k) = uairUB(i, j, k)
                    ua2_UB(i, j, k) = uairUB(i, j, k)
                    va1_UB(i, j, k) = vairUB(i, j, k)
                    va2_UB(i, j, k) = vairUB(i, j, k)
                    pkt1UB(i, j, k) = pktaUB(i, j, k)
                    pkt2UB(i, j, k) = pktaUB(i, j, k)
                enddo
            enddo
        enddo

    endif

    ! +--New UBC
    ! +  =======

    if(itimUB > tim2UB) then

        tim1UB = tim2UB

       !write(6, 6001) jda_UB, labmGE(mma_UB), iyr_UB, &
       !    jhu_UB, tim1UB, &
       !    jdarGE, labmGE(mmarGE), iyrrGE, &
       !    jhurGE, minuGE, jsecGE, itimUB
6001    format(/, '  1st UBC /', i3, '-', a3, '-', i4, i3, ' ', 2x, '/', 2x, &
                '   t =', i12, 's A.P.', &
                /, '  Current /', i3, '-', a3, '-', i4, i3, ':', i2, ':', i2, &
                '   t =', i12)
        ! +
        if(jdh_UB == 0) jdh_UB = -1
        open(unit=11, status='old', form='unformatted', file='MARubc.DAT')
        rewind 11
11      continue
        if(jdh_UB <= 0) go to 10

        ! +--UBC at nesting time step n
        ! +  --------------------------

        do k = 1, mzabso
            do j = 1, my
                do i = 1, mx
                    ua1_UB(i, j, k) = ua2_UB(i, j, k)
                    va1_UB(i, j, k) = va2_UB(i, j, k)
                    pkt1UB(i, j, k) = pkt2UB(i, j, k)
                    ua2_UB(i, j, k) = 0.d0
                    va2_UB(i, j, k) = 0.d0
                    pkt2UB(i, j, k) = 0.d0
                enddo
            enddo
        enddo

        ! +--UBC at nesting time step n+1
        ! +  ----------------------------

        read(11) iyr_UB, mma_UB, jda_UB, jhu_UB, jdh_UB
        read(11) ua2_UB, va2_UB, pkt2UB

        tim2UB = ou2sGE(iyr_UB, mma_UB, jda_UB, jhu_UB, 0, 0)

        do k = 1, mzabso
            do j = 1, my
                do i = 1, mx
                    ua2_UB(i, j, k) = ua2_UB(i, j, k) / SFm_DY(i, j)
                    va2_UB(i, j, k) = va2_UB(i, j, k) / SFm_DY(i, j)
                enddo
            enddo
        enddo

        if(itimUB > tim2UB) go to 11

       !write(6, 6002) jda_UB, labmGE(mma_UB), iyr_UB, &
       !    jhu_UB, jdh_UB, tim2UB
6002    format('  2nd UBC /', i3, '-', a3, '-', i4, i3, ' ', 2x, '/(', i1, &
               ')  t =', i12)

10      continue
        close(unit=11)

    else
#ifdef WR
        write(6, 6003) jdarGE, labmGE(mmarGE), iyrrGE, &
            jhurGE, minuGE, jsecGE, itimUB
6003    format('  Current /', i3, '-', a3, '-', i4, i3, ':', i2, ':', i2, &
               '   t =', i12, 's A.P.')
#endif
    endif

    ! +--Time Interpolation
    ! +  ==================

    if(itimUB <= tim2UB .and. tim1UB < tim2UB) then

        rate = float(itimUB - tim1UB) / float(tim2UB - tim1UB)
        do k = 1, mzabso
            do j = 1, my
                do i = 1, mx
                    uairUB(i, j, k) = ua1_UB(i, j, k) + &
                                      (ua2_UB(i, j, k) - ua1_UB(i, j, k)) * rate
                    vairUB(i, j, k) = va1_UB(i, j, k) + &
                                      (va2_UB(i, j, k) - va1_UB(i, j, k)) * rate
                    pktaUB(i, j, k) = pkt1UB(i, j, k) + &
                                      (pkt2UB(i, j, k) - pkt1UB(i, j, k)) * rate
                enddo
            enddo
        enddo

        newubcINI = 1

    else
        newubcINI = 0
    endif

    return
end
