#include "MAR_pp.def"
subroutine inisnd_vl(pij, ptopDY, sigmid, sigma, u_ij, v_ij)
    ! +------------------------------------------------------------------------+
    ! | MAR INPUT      ATMOS                                   17-02-2004  MAR |
    ! |   subroutine inisnd_vl initializes                                     |
    ! |     HORIZONTAL WIND COMPONENTS                     vertical profiles   |
    ! |     from sounding data (observations or academic situation)            |
    ! |                                                                        |
    ! +------------------------------------------------------------------------+
    ! |                                                                        |
    ! |   INPUT:    pij -> pstDY (i,j) : Model Pressure Thickness              |
    ! |   ^^^^^     ptopDY               Model Pressure Top                    |
    ! |             sigmid               Model Layer    Interface Coordinate   |
    ! |             sigma                Model Level              Coordinate   |
    ! |                                                                        |
    ! |   INPUT (via common)                                                   |
    ! |   ^^^^^     uuSND                Sounding       U-Wind    Speed        |
    ! |             vvSND                Sounding       V-Wind    Speed        |
    ! |                                                                        |
    ! |   OUTPUT:    u_ij       -> ugeoDY(i,j,1->mz)                           |
    ! |   ^^^^^^     v_ij       -> vgeoDY(i,j,1->mz)                           |
    ! |                                                                        |
    ! |   CAUTION:   non-zero loav generates erroneous results                 |
    ! |   ^^^^^^^                                                              |
    ! +------------------------------------------------------------------------+

    use marphy
    use mardim
    use marsnd

    implicit none

    real pij, ptopDY
    real sigma(mz)
    real sigmid(mzz)

    real u_ij(mz, 2), v_ij(mz, 2)

    ! +--Local  Variables
    ! +  ================

    integer k, ksnd, loav
    real gra, prl, pr1, pr2
    real guu, uu1, uu2, uuav
    real gvv, vv1, vv2, vvav

    ! +--Scheme Initialisation
    ! +  =====================

    gra = -gravit / RDryAi
    loav = 0

    ! +--Geostrophic Wind Vertical Profile
    ! +  =================================

    k = mz
    ksnd = 1
    ! +...     ksnd    =  1 (when pSND(mz) -> pSND(0:mz), etc...)

    ! + - -do until
100 continue
    if(k == 1) then
        pr1 = pij * 0.5d1 * sigma(1) + ptopDY
    else
        pr1 = pij * 1.0d1 * sigmid(k) + ptopDY
    endif
    pr2 = pij * 1.0d1 * sigmid(k + 1) + ptopDY
    ! +...     Factor 10 is needed for [cb] --> [mb]

    ! + - - do until
110 continue
    if(pSND(ksnd, nSND) < pr2) go to 111
    ksnd = ksnd + 1
    go to 110
111 continue
    ! + - - end do

    guu = (uuSND(ksnd) - uuSND(ksnd - 1)) &
          / (pSND(ksnd, nSND) - pSND(ksnd - 1, nSND))
    uu2 = uuSND(ksnd - 1) + guu * (pr2 - pSND(ksnd - 1, nSND))
    gvv = (vvSND(ksnd) - vvSND(ksnd - 1)) &
          / (pSND(ksnd, nSND) - pSND(ksnd - 1, nSND))
    vv2 = vvSND(ksnd - 1) + gvv * (pr2 - pSND(ksnd - 1, nSND))

    if(pSND(ksnd, nSND) >= pr1) then
        uuav = -(uu2 + uuSND(ksnd)) &
               * (pr2 - pSND(ksnd, nSND)) * 0.5
        vvav = -(vv2 + vvSND(ksnd)) &
               * (pr2 - pSND(ksnd, nSND)) * 0.5
    else
        loav = 0
        uuav = zero
        vvav = zero
    endif

    ! + - - do until
120 continue
    if(pSND(ksnd, nSND) < pr1) go to 121
    ksnd = ksnd + 1
    go to 120
121 continue
    ! + - - end do

    guu = (uuSND(ksnd) - uuSND(ksnd - 1)) &
          / (pSND(ksnd, nSND) - pSND(ksnd - 1, nSND))
    uu1 = uuSND(ksnd - 1) + guu * (pr1 - pSND(ksnd - 1, nSND))
    gvv = (vvSND(ksnd) - vvSND(ksnd - 1)) &
          / (pSND(ksnd, nSND) - pSND(ksnd - 1, nSND))
    vv1 = vvSND(ksnd - 1) + gvv * (pr1 - pSND(ksnd - 1, nSND))

    if(loav > 0) then
        uuav = uuav &
               + (uuSND(ksnd - 1) + uu1) &
               * (pSND(ksnd - 1, nSND) - pr1) * 0.5
        vvav = vvav &
               + (vvSND(ksnd - 1) + vv1) &
               * (pSND(ksnd - 1, nSND) - pr1) * 0.5
    else
        uuav = &
            (uu2 + uu1) &
            * (pr2 - pr1) * 0.5
        vvav = &
            (vv2 + vv1) &
            * (pr2 - pr1) * 0.5
    endif

    ! +--Layer Average
    ! +  =============

    uuav = uuav / (pr2 - pr1)
    vvav = vvav / (pr2 - pr1)

    ! +--Large Scale Wind Components in the MAR Coordinate System
    ! +  ========================================================

    u_ij(k, nSND) = uuav
    v_ij(k, nSND) = vvav

    if(k <= 1) go to 101
    k = k - 1
    go to 100
101 continue
    ! + - -end do

    return
end
