#include "MAR_pp.def"
subroutine inisnd_th(pij, ptopDY, sigmid, sigma, t_ij, q_ij)
    ! +------------------------------------------------------------------------+
    ! | MAR INPUT      ATMOS                                   25-09-2001  MAR |
    ! |   subroutine inisnd_th initializes                                     |
    ! |     ATMOSPHERIC TEMPERATURES and SPECIFIC HUMIDITIES vertical profiles |
    ! |     from sounding data (observations or academic situation)            |
    ! |                                                                        |
    ! +------------------------------------------------------------------------+
    ! |                                                                        |
    ! |   INPUT:    pij -> pstDY (i,j) : Model Pressure Thickness              |
    ! |   ^^^^^     ptopDY               Model Pressure Top                    |
    ! |             sigmid               Model Layer    Interface Coordinate   |
    ! |             sigma                Model Level              Coordinate   |
    ! |                                                                        |
    ! |   INPUT (via common)                                                   |
    ! |   ^^^^^     tpSND                Sounding       Potential Temperature  |
    ! |                                                                        |
    ! |   OUTPUT:    t_ij       -> tairDY(i,j,1->mz)                           |
    ! |   ^^^^^^     q_ij       ->   qvDY(i,j,1->mz)                           |
    ! |                                                                        |
    ! |   CAUTION:  The Sounding must be in Hydrostatic Balance                |
    ! |   ^^^^^^^                                                              |
    ! +------------------------------------------------------------------------+
    ! +
    use marphy
    use mardim
    use marsnd
    ! +
    implicit none
    ! +
    ! +
    real pij, ptopDY
    real sigmid(mzz)
    real sigma(mz)
    ! +
    real t_ij(mz, 2), q_ij(mz, 2)
    ! +
    ! +
    ! +--Local  Variables
    ! +  ================
    ! +
    integer k, ksnd, lsnd
    real gra, prl, pr1, pr2
    real gsnd, tt1, tt2, ttav
    real gqv, qv1, qv2, qvav
    ! +
    ! +
    ! +--Scheme Initialisation
    ! +  =====================
    ! +
    gra = -gravit / RDryAi
    ! +
    ! +--Temperature Vertical Profile
    ! +  ============================
    ! +
    k = mz
    ksnd = 1
    ! +...     ksnd    =  1 (when pSND(mz) -> pSND(0:mz), etc...)
    ! +
    ! + - -do until
100 continue
    prl = pij * sigma(k) + ptopDY
    if(k == 1) then
        pr1 = (pij * 0.5 * sigma(1) + ptopDY) * 10.0
    else
        pr1 = (pij * sigmid(k) + ptopDY) * 10.0
    endif
    pr2 = (pij * sigmid(k + 1) + ptopDY) * 10.0
    ! +...     Factor 10 is needed for [cb] --> [mb]
    ! +
    ! + - - do until
110 continue
    if(pSND(ksnd, nSND) < pr2) go to 111
    ksnd = ksnd + 1
    go to 110
111 continue
    ! + - - end do
    ! +
    gsnd = (tpSND(ksnd, nSND) - tpSND(ksnd - 1, nSND)) &
           / (pSND(ksnd, nSND) - pSND(ksnd - 1, nSND))
    tt2 = tpSND(ksnd - 1, nSND) + gsnd * (pr2 - pSND(ksnd - 1, nSND))
    ! +
    gqv = (qsnd(ksnd, nSND) - qSND(ksnd - 1, nSND)) &
          / (pSND(ksnd, nSND) - pSND(ksnd - 1, nSND))
    qv2 = qSND(ksnd - 1, nSND) + gqv * (pr2 - pSND(ksnd - 1, nSND))
    ! +
    if(pSND(ksnd, nSND) >= pr1) then
        ttav = (tt2 + tpSND(ksnd, nSND)) &
               * (pr2 - pSND(ksnd, nSND))
        qvav = (qv2 + qSND(ksnd, nSND)) &
               * (pr2 - pSND(ksnd, nSND))
    else
        ttav = zero
        qvav = zero
    endif
    ! +
    ! + - - do until
    lsnd = 0
120 continue
    if(pSND(ksnd, nSND) < pr1) go to 121
    ksnd = ksnd + 1
    lsnd = 1
    if(pSND(ksnd, nSND) >= pr1) then
        ttav = ttav &
               + (tpSND(ksnd - 1, nSND) + tpSND(ksnd, nSND)) &
               * (pSND(ksnd - 1, nSND) - pSND(ksnd, nSND))
        qvav = qvav &
               + (qSND(ksnd - 1, nSND) + qSND(ksnd, nSND)) &
               * (pSND(ksnd - 1, nSND) - pSND(ksnd, nSND))
    else
        gsnd = (tpSND(ksnd, nSND) - tpSND(ksnd - 1, nSND)) &
               / (pSND(ksnd, nSND) - pSND(ksnd - 1, nSND))
        tt1 = tpSND(ksnd - 1, nSND) + gsnd * (pr1 - pSND(ksnd - 1, nSND))
        ttav = ttav &
               + (tpSND(ksnd - 1, nSND) + tt1) &
               * (pSND(ksnd - 1, nSND) - pr1)
        ttav = ttav * 0.5 / (pr2 - pr1)
        ! +
        gqv = (qSND(ksnd, nSND) - qSND(ksnd - 1, nSND)) &
              / (pSND(ksnd, nSND) - pSND(ksnd - 1, nSND))
        qv1 = qSND(ksnd - 1, nSND) + gqv * (pr1 - pSND(ksnd - 1, nSND))
        qvav = qvav &
               + (qSND(ksnd - 1, nSND) + qv1) &
               * (pSND(ksnd - 1, nSND) - pr1)
        qvav = qvav * 0.5 / (pr2 - pr1)
    endif
    go to 120
121 continue
    ! + - - end do
    ! +
    if(lsnd == 0) then
        tt1 = tpSND(ksnd - 1, nSND) + gsnd * (pr1 - pSND(ksnd - 1, nSND))
        ttav = (tt2 + tt1) * 0.5
        ! +
        qv1 = qSND(ksnd - 1, nSND) + gqv * (pr1 - pSND(ksnd - 1, nSND))
        qvav = (qv2 + qv1) * 0.5
    endif
    ! +
    ! +
    ! +--Interpolated/Integrated Values
    ! +  ==============================
    ! +
    t_ij(k, nSND) = ttav * prl**cap / pcap
    q_ij(k, nSND) = qvav
    ! +
    ! +
    ! +--Continue Interpolation
    ! +  ======================
    ! +
    if(k <= 1) go to 101
    k = k - 1
    go to 100
101 continue
    ! + - -end do
    ! +
    return
endsubroutine inisnd_th
