#include "MAR_pp.def"
subroutine INIsic(ihamr_sic, nhamr_sic, newsicINI)
    ! +------------------------------------------------------------------------+
    ! | MAR INPUT    Sea-Ice                                   03-03-2004  MAR |
    ! |   subroutine INIsic is used to initialize MAR Sea-Ice    Fractions     |
    ! |                                                                        |
    ! +------------------------------------------------------------------------+
    ! |                                                                        |
    ! |   INPUT:  ihamr_sic: Time Digital Filter Status                        |
    ! |   ^^^^^   nhamr_sic: Time Digital Filter Set Up                        |
    ! |                                                                        |
    ! |   OUTPUT: newsicINI: (0,1) ==> (NO new sic , new sic)                  |
    ! |   ^^^^^^^                                                              |
    ! |                                                                        |
    ! |   OUTPUT: sicsIB: Current                     Sea-Ice    Fraction      |
    ! |   ^^^^^^^ sic1sI: Previous Nesting Time Step  Sea-Ice    Fraction      |
    ! |           sic2sI: Next     Nesting Time Step  Sea-Ice    Fraction      |
    ! |           tim1sI,tim2sI:   Times  n, n+1  of  Sea-Ice    Fraction      |
    ! |                                                                        |
    ! |   CAUTION: It is assumed that tim1sI and tim2sI do not change when the |
    ! |   ^^^^^^^^ Variables are reassigned after the dynamical Initialization |
    ! |            (Reassignation => itexpe := nham => timar := timar-nham*dt) |
    ! |                                                                        |
    ! +------------------------------------------------------------------------+

    use marctr
    use marphy
    use mardim
    use margrd
    use mar_ge
    use mar_sl
    use mar_sv
    use mar_TV
    use marsib
#ifdef AO
    use mar_ao
#endif

    implicit none

    integer ihamr_sic, nhamr_sic
    integer newsicINI

    ! +--Local  Variables
    ! +  ================

    integer i, j, k, m
    !XF
    integer(kind=8) itisIB
    real rate

    ! +--Current Time
    ! +  ============

    itisIB = ou2sGE(iyrrGE, mmarGE, jdarGE, jhurGE, minuGE, jsecGE)
#ifdef HF
    itisIB = itisIB + (ihamr_sic + nhamr_sic) * idt
#endif

    ! +--Reinitialization of the Sea-Ice Fraction
    ! +  ----------------------------------------

    if(iterun == 0) then
        jdh_sI = 1
        iyr_sI = iyrrGE
        mma_sI = mmarGE
        jda_sI = jdarGE
        jhu_sI = jhurGE
        tim1sI = itisIB
        tim2sI = itisIB
        do j = 1, my
            do i = 1, mx
                sic1sI(i, j) = sicsIB(i, j)
                sic2sI(i, j) = sicsIB(i, j)
            enddo
        enddo

    endif

    ! +--New sIB
    ! +  =======

    if(itisIB > tim2sI) then

        tim1sI = tim2sI

       !write(6, 6001) jda_sI, labmGE(mma_sI), iyr_sI, &
       !    jhu_sI, tim1sI, &
       !    jdarGE, labmGE(mmarGE), iyrrGE, &
       !    jhurGE, minuGE, jsecGE, itisIB
6001    format(/, '  1st sIB /', i3, '-', a3, '-', i4, i3, ' ', 2x, '/', 2x, &
                '   t =', i12, 's A.P.', &
                /, '  Current /', i3, '-', a3, '-', i4, i3, ':', i2, ':', i2, &
                '   t =', i12)
        ! +
        if(jdh_sI == 0) jdh_sI = -1
        open(unit=11, status='old', form='unformatted', file='MARsic.DAT')
        rewind 11
11      continue
        if(jdh_sI <= 0) go to 10

        ! +--sIB at nesting time step n
        ! +  --------------------------

        do j = 1, my
            do i = 1, mx
                sic1sI(i, j) = sic2sI(i, j)
                sic2sI(i, j) = 0.d0
            enddo
        enddo

        ! +--sIB at nesting time step n+1
        ! +  ----------------------------

        read(11) iyr_sI, mma_sI, jda_sI, jhu_sI, jdh_sI
        read(11) sic2sI

        tim2sI = ou2sGE(iyr_sI, mma_sI, jda_sI, jhu_sI, 0, 0)

        if(itisIB > tim2sI) go to 11

       !write(6, 6002) jda_sI, labmGE(mma_sI), iyr_sI, &
       !    jhu_sI, jdh_sI, tim2sI
6002    format('  2nd sIB /', i3, '-', a3, '-', i4, i3, ' ', 2x, '/(', i1, &
               ')  t =', i12)

10      continue
        close(unit=11)

    else
#ifdef WR
        write(6, 6003) jdarGE, labmGE(mmarGE), iyrrGE, &
            jhurGE, minuGE, jsecGE, itisIB
6003    format('  Current /', i3, '-', a3, '-', i4, i3, ':', i2, ':', i2, &
               '   t =', i12, 's A.P.')
#endif
    endif

    ! +--Time Interpolation
    ! +  ==================

    if(itisIB <= tim2sI .and. tim1sI < tim2sI) then

        rate = float(itisIB - tim1sI) / float(tim2sI - tim1sI)
        do j = 1, my
            do i = 1, mx
                !Coupling:    inside NEMO domaine sicsIB changed in
                !            - inigen.f (first timpe step)
                !            -oasis_2_mar.f (all the others)
                !           outside MAJ sicsIB here with the usual sic rate
                ! CK_AO 28/02/2020

                ! old way
                !c #AO       sic1sI(i,j)=sicsIB(i,j)
                !c #AO       sic2sI(i,j)=sicsIB(i,j)

                sicsIB(i, j) = sic1sI(i, j) + &
                               (sic2sI(i, j) - sic1sI(i, j)) * rate

#ifdef AO
                if(weightAO_sic(i, j) /= 1) then
                    sicsIB(i, j) = (1.-weightao_sic(i, j)) * sicsAO(i, j) + &
                                   (weightAO_sic(i, j) * sicsIB(i, j))
                endif
#endif
            enddo
        enddo

        newsicINI = 1

    else
        newsicINI = 0
    endif

    return
endsubroutine INIsic
