#include "MAR_pp.def"
subroutine iniphy
    ! +------------------------------------------------------------------------+
    ! | MAR INPUT      ATMOS                              Thu 21-Jul-2011  MAR |
    ! |   subroutine iniphy Initializes coupling Variables  between            |
    ! |                                 MAR Surface and     Atmosphere         |
    ! |                     Calls       MAR Surface Model initializing Routines|
    ! |                     Initializes MAR Cloud   Microphysical      Scheme  |
    ! |                                                                        |
    ! +------------------------------------------------------------------------+
    ! |                                                                        |
    ! |    INPUT:      itexpe: Experiment Iteration Counter                    |
    ! |    ^^^^^       micphy: Cloud Microphysics   Switch                     |
    ! |                fxlead: Lead (in Sea ice)    Fraction                   |
    ! |                polmod: Polynya Model        Switch                     |
    ! |                snomod: Snow    Model        Switch                     |
    ! |                reaVAR: Previous OR Large Scale Variables Switch        |
    ! |                reaLBC: LBC:        Large Scale Variables Switch        |
    ! |                                                                        |
    ! |    INPUT (via common block)                                            |
    ! |    ^^^^^       pstDY (mx,my)    : Atmosphere Thickness           [kPa] |
    ! |    (itexpe=0): TairSL(mx,my)    : Surface Air Temperature          [K] |
    ! |                                  (Sounding Extrapolated to the Surface |
    ! |                                   - dtagSL                            )|
    ! |    (itexpe=1): pktaDY(mx,my,mzz): Reduced Potential Temperature        |
    ! |                sh    (mx,my)    : Surface Elevation                [m] |
    ! |                                                                        |
    ! |   OUTPUT (via common block)                                            |
    ! |   ^^^^^^       tsrfSL(mx,my,mw) : Surface Temperature              [K] |
    ! |    (itexpe=1): TairSL(mx,my)    : Surface Air Temperature          [K] |
    ! |               (CAUTION: CRUDE REINITIALISATION                         |
    ! |                         BE CAREFULL WHEN USING PRESCRIBED TEMPERATURE) |
    ! |                SLsrfl(mx,my,mw) : Surface Type Area                    |
    ! |    (itexpe=0): pktaDY(mx,my,mzz): Reduced Potential Temperature        |
    ! |                gplvDY(mx,my,mzz): Geopotential                 [m2/s2] |
    ! |                                                                        |
    ! +------------------------------------------------------------------------+
    use marctr
    use marphy
    use mardim
    use margrd
    use mar_dy
    use mar_lb
    use mar_hy
    use mar_ca
    use mar_sl
    use mar_sv
    use mar_tv
#ifdef AO
    use mar_ao
#endif
#ifdef BS
    use mar_bs
#endif
#ifdef iso
    use mariso, only: qiHY_iso, qsHY_iso, qwHY_iso, qrHY_iso, &
                      rainHY_iso, snowHY_iso, crysHY_iso, rainCA_iso, snowCA_iso
#endif

    implicit none

    ! +--Local  Variables
    ! +  ================
    integer i, j, k, m, n
    real tsrf, rowat2

    ! +--First Guess Initialization
    ! +  ==========================
    if(.not. reaVAR) then
        ! +--Surface Geopotential
        ! +  --------------------
        do j = 1, my
            do i = 1, mx
                gplvDY(i, j, mzz) = sh(i, j) * gravit
            enddo
        enddo
        ! +--Grid BOXES Area (First Guess)
        ! +  -----------------------------
        do j = 1, my
            do i = 1, mx
                SLsrfl(i, j, 1) = 1.0
                SLsrfl(i, j, 2) = 0.0
            enddo
        enddo
        ! +--Surface Temperature (First Guess)
        ! +  ---------------------------------
        do n = 1, mw
            do j = 1, my
                do i = 1, mx
                    tsrfSL(i, j, n) = TairSL(i, j)
                enddo
            enddo
        enddo
        do j = 1, my
            do i = 1, mx
                go to(101, 102, 103, 104, 105) isolSL(i, j)
101             continue
                if(reaLBC) then
                    tsrfSL(i, j, 1) = sst_LB(i, j)
                else
                    tsrfSL(i, j, 1) = max(sst_SL, tfrwat)
                endif
                go to 106
102             continue
#ifdef OM
                tsrf = tsrfSL(i, j, 1)
#endif
                tsrfSL(i, j, 1) = min(tsrfSL(i, j, 1), TfSnow)
#ifdef OM
                tsrfSL(i, j, 1) = tsrf
#endif
                tsrfSL(i, j, 2) = sst_SL
                go to 106
103             continue
                tsrfSL(i, j, 1) = min(tsrfSL(i, j, 1), TfSnow)
                go to 106
104             continue
                go to 106
105             continue
                go to 106
106             continue
            enddo
        enddo
    endif

#ifdef PO
    ! +--Polynya Model
    ! +  =============
    ! +--Polynya Model Initialisation
    ! +  ----------------------------
    ! CAa : SRFini_pol not found
    !    ! +  **********
    !    call SRFini_pol
    !    ! +  **********
#endif

    ! +--Snow Model
    ! +  ==========
    ! CAaiso : ro_SL is not used, replaced with sisvat variables
    rowat2 = ro_Wat**1.88
    do j = 1, my
        do i = 1, mx
            ro_SL0(i, j) = (d1_SL(i, j) / sqrt(csnow * cdice * cs2SL / rowat2))**(1.0 / 1.44)
            ro_SL(i, j) = ro_SL0(i, j)
            ! SaltSL: Here an impossible Value
            !        (Preclude Saltation)
            SaltSL(i, j) = 1.e2
        enddo
    enddo

    if(.not. snomod) then
        do j = 1, my
            do i = 1, mx
                if(isolSL(i, j) >= 2 .and. tsrfSL(i, j, 1) < TfSnow) then
                    ro_SL(i, j) = 0.00
                    ! SaltSL: Threshold Friction Velocity for Blowing Snow
                    !        (Budd et al., 1966, Byrd Snow Project)
                    SaltSL(i, j) = 0.38
                endif
            enddo
        enddo
    endif

    ! +--Soil Model
    ! +  ==========
    do j = 1, my
        do i = 1, mx
            roseSL(i, j) = 0.0
            hmelSL(i, j) = 0.0
        enddo
    enddo

    do j = 1, my
        do i = 1, mx
            go to(51, 51, 53, 54, 51) isolSL(i, j)
51          continue
            t2_SL(i, j) = tsrfSL(i, j, 1)
            go to 59
53          continue
            if(.not. snomod) then
                t2_SL(i, j) = tsrfSL(i, j, 1)
            endif
            go to 59
54          continue
            t2_SL(i, j) = tsrfSL(i, j, 1)
            w2_SL(i, j) = w20SL
            wg_SL(i, j) = wg0SL
            wk_SL(i, j) = wk0SL
            wx_SL(i, j) = wx0SL
            go to 59
59          continue
        enddo
    enddo

    ! +--Grid BOXES Area (Update)
    ! +  ========================
    if(VSISVAT) then
        do j = 1, my
            do i = 1, mx
                nSLsrf(i, j) = nvx
            enddo
        enddo
        do n = 1, nvx
            do j = 1, my
                do i = 1, mx
                    SLsrfl(i, j, n) = ifraTV(i, j, n)
                    SLsrfl(i, j, n) = SLsrfl(i, j, n) * 0.01
                enddo
            enddo
        enddo
    else
        do j = 1, my
            do i = 1, mx
                if(isolSL(i, j) <= 4) then
                    nSLsrf(i, j) = max(iun, nSLsrf(i, j))
                    SLsrfl(i, j, 1) = 1.-SLsrfl(i, j, 2)
                else
                    nSLsrf(i, j) = 1
                    SLsrfl(i, j, 1) = 1.
                    nSLsrf(i, j) = nvx
                    do n = 1, nvx
                        SLsrfl(i, j, n) = ifraTV(i, j, n)
                        SLsrfl(i, j, n) = SLsrfl(i, j, n) * 0.01
                    enddo
                endif
            enddo
        enddo
    endif

    ! +--Surface Temperature (Update)
    ! +  ============================
    do j = 1, my
        do i = 1, mx
            TairSL(i, j) = 0.
            do n = 1, mw
                TairSL(i, j) = TairSL(i, j) + SLsrfl(i, j, n) * tsrfSL(i, j, n)
            enddo
            pktaDY(i, j, mzz) = TairSL(i, j) / ((pstDY(i, j) + ptopDY)**cap)
        enddo
    enddo

    ! +--Microphysics
    ! +  ============

    if(micphy) then
        turnHY = .false.
        qiHY = 0.0
        qsHY = 0.0
        qwHY = 0.0
        qrHY = 0.0
#ifdef iso
        qiHY_iso = 0.0
        qsHY_iso = 0.0
        qwHY_iso = 0.0
        qrHY_iso = 0.0
#endif
        hlatHY = 0.0
        snfHY = 0.0
        depHY = 0.0
        sblHY = 0.0
        rnfHY = 0.0
        evpHY = 0.0
        smtHY = 0.0
        qssblHY = 0.0
#ifdef iso
        ! todo : check if snfHY, sblHY, rnfHY, evpHY needed with isotopes
        ! todo : check if snf2D, sbl2D, rnf2D, evp2D needed with isotopes
#endif
#ifdef qg
        qgHY = 0.0
#endif
        rainHY = 0.0
        snowHY = 0.0
        crysHY = 0.0
        rainCA = 0.0
        snowCA = 0.0
#ifdef iso
        rainHY_iso = 0.0
        snowHY_iso = 0.0
        crysHY_iso = 0.0
        rainCA_iso = 0.0
        snowCA_iso = 0.0
#endif
    endif

    return
endsubroutine iniphy
