#include "MAR_pp.def"
subroutine INIlbc(ihamr_lbc, nhamr_lbc, newlbc)
    ! +------------------------------------------------------------------------+
    ! | MAR INPUT      ATMOS                               Tue 27-10-2017  MAR |
    ! |   subroutine INIlbc initializes MAR Lateral Boundaries                 |
    ! |                     verifies    MARlbc.DAT  EOF                        |
    ! |                                                                        |
    ! +------------------------------------------------------------------------+
    ! |                                                                        |
    ! |   INPUT:  ihamr_lbc : Time Digital Filter Status                       |
    ! |   ^^^^^   nhamr_lbc : Time Digital Filter Set Up                       |
    ! |                                                                        |
    ! |   OUTPUT: newlbc    : (0,1) ==> (NO new LBC ,new LBC)                  |
    ! |   ^^^^^^^                                                              |
    ! |                                                                        |
    ! |   OUTPUT (via common block)                                            |
    ! |   ^^^^^^  vaxgLB,vaxdLB,vayiLB,vaysLB: Current                    LBCs |
    ! |           v1xgLB,v1xdLB,v1yiLB,v1ysLB: Previous Nesting Time Step LBCs |
    ! |           v2xgLB,v2xdLB,v2yiLB,v2ysLB: Next     Nesting Time Step LBCs |
    ! |           tim1LB,tim2LB              : LBC Nesting      Times  n, n+1  |
    ! |                                                                        |
    ! |   CAUTION: It is assumed that tim1LB and tim2LB do not change when the |
    ! |   ^^^^^^^^ Variables are reassigned after the dynamical Initialization |
    ! |            (Reassignation => itexpe:= nham => itimar:= itimar-nham*dt) |
    ! |                                                                        |
    ! +------------------------------------------------------------------------+

    use marctr
    use marphy
    use mardim
    use margrd
    use mar_ge
    use mar_dy
    use mar_lb
    use mar_sl
    use marmagic
    use marsnd
#ifdef AO
    use mar_ao
#endif

    implicit none

    integer i, j, k, m
    integer ihamr_lbc, nhamr_lbc
    integer newlbc
    real pst__1, pst_mx
    common / INIlbcRLoc / pst__1, pst_mx

    ! +--Local  Variables
    ! +  ================

    integer(kind=8) itimar, iv_ilb
    real rate, correction_humidity
    real vax_An, vax_Ap, vax_A
    real qsat0D, qs, tt
#ifdef CE
    real qse_0D, qse
#endif
#ifdef FS
    ! rh_min : relative humidity above which clouds exist
    real rh_min, qq
    ! fac_qq : prescribed specific humidity tuning at LBC
    real fac_qq
    data rh_min/0.80/
    ! fac_qq = 1.50  ==> 0.8 + 1.5 * 0.2 = 1.1
    data fac_qq/1.50/
#endif
    ! +--Current Time
    ! +  ============

    itimar = ou2sGE(iyrrGE, mmarGE, jdarGE, jhurGE, minuGE, jsecGE)
#ifdef HF
    itimar = +(ihamr_lbc + nhamr_lbc) * idt
#endif

    !XF
    ! WARNING Compile with -i8 if the simulation run > 50yrs!!
    !XF

    ! initialize iSND jSND for PHYrad_top initialization
    ! ==================================================
    iSND = 1
    jSND = 1

    ! +--New LBC
    ! +  =======

    if(itimar > tim2LB) then

        tim1LB = tim2LB

        write(6, 6001) jda_LB, labmGE(mma_LB), iyr_LB, &
            jhu_LB, tim1LB, &
            jdarGE, labmGE(mmarGE), iyrrGE, &
            jhurGE, minuGE, jsecGE, itimar
6001    format(/, ' 1st LBC /', i3, '-', a3, '-', i4, i3, ' ', 2x, '/', 2x, &
                '   t =', i12, 's A.P.', &
                /, ' Current /', i3, '-', a3, '-', i4, i3, ':', i2, ':', i2, &
                '   t =', i12)

        if(jdh_LB == 0) jdh_LB = -1
        open(unit=11, status='old', form='unformatted', file='MARlbc.DAT')
        rewind 11
11      continue
        if(jdh_LB <= 0) go to 10

        ! +--LBC at nesting time step n
        ! +  --------------------------

        do iv_ilb = 1, 5
            do i = 1, n7mxLB
                do k = 1, mz
                    do j = 1, my
                        v1xgLB(i, j, k, iv_ilb) = v2xgLB(i, j, k, iv_ilb)
                        v2xgLB(i, j, k, iv_ilb) = 0.0
                    enddo
                enddo
            enddo

            do i = mx - n6mxLB, mx
                do k = 1, mz
                    do j = 1, my
                        v1xdLB(i, j, k, iv_ilb) = v2xdLB(i, j, k, iv_ilb)
                        v2xdLB(i, j, k, iv_ilb) = 0.0
                    enddo
                enddo
            enddo

            do j = 1, n7myLB
                do k = 1, mz
                    do i = 1, mx
                        v1yiLB(i, j, k, iv_ilb) = v2yiLB(i, j, k, iv_ilb)
                        v2yiLB(i, j, k, iv_ilb) = 0.0
                    enddo
                enddo
            enddo

            do j = my - n6myLB, my
                do k = 1, mz
                    do i = 1, mx
                        v1ysLB(i, j, k, iv_ilb) = v2ysLB(i, j, k, iv_ilb)
                        v2ysLB(i, j, k, iv_ilb) = 0.0
                    enddo
                enddo
            enddo

        enddo

        do j = 1, my
            do i = 1, mx
                sst1LB(i, j) = sst2LB(i, j)
            enddo
        enddo

        ! +--LBC at nesting time step n+1
        ! +  ----------------------------

        read(11) iyr_LB, mma_LB, jda_LB, jhu_LB, jdh_LB
        read(11) v2xgLB, v2xdLB, v2yiLB, v2ysLB
        read(11) sst2LB

        tim2LB = ou2sGE(iyr_LB, mma_LB, jda_LB, jhu_LB, 0, 0)

        do iv_ilb = 1, 2
            do i = 1, n7mxLB
                do k = 1, mz
                    do j = 1, my
                        v2xgLB(i, j, k, iv_ilb) = v2xgLB(i, j, k, iv_ilb) / SFm_DY(i, j)
                    enddo
                enddo
            enddo

            do i = mx - n6mxLB, mx
                do k = 1, mz
                    do j = 1, my
                        v2xdLB(i, j, k, iv_ilb) = v2xdLB(i, j, k, iv_ilb) / SFm_DY(i, j)
                    enddo
                enddo
            enddo

            do j = 1, n7myLB
                do k = 1, mz
                    do i = 1, mx
                        v2yiLB(i, j, k, iv_ilb) = v2yiLB(i, j, k, iv_ilb) / SFm_DY(i, j)
                    enddo
                enddo
            enddo

            do j = my - n6myLB, my
                do k = 1, mz
                    do i = 1, mx
                        v2ysLB(i, j, k, iv_ilb) = v2ysLB(i, j, k, iv_ilb) / SFm_DY(i, j)
                    enddo
                enddo
            enddo

        enddo

        if(itimar > tim2LB) go to 11

        write(6, 6002) jda_LB, labmGE(mma_LB), iyr_LB, &
            jhu_LB, jdh_LB, tim2LB
6002    format(' 2nd LBC /', i3, '-', a3, '-', i4, i3, ' ', 2x, '/(', i1, &
               ')  t =', i12,/)

10      continue
        close(unit=11)

        ! +--Force Sursaturation where relative humidity larger than rh_min (i.e., 80%)
        ! +  --------------------------------------------------------------------------

        do i = 1, n7mxLB
            do k = 1, mz
                do j = 1, my
                    tt = v2xgLB(i, j, k, 4) &
                         * exp(cap * log(v2xgLB(i, j, 1, 5) * sigma(k) + ptopDY))
                    qs = qsat0D(tt, sigma(k), v2xgLB(i, j, 1, 5), ptopDY, 0)
#ifdef FS
                    qq = qs * rh_min
#endif
#ifdef CE
                    qse = qse_0D(tt, sigma(k), v2xgLB(i, j, 1, 5), ptopDY)
#endif
#ifdef FS
                    v2xgLB(i, j, k, 3) = min(v2xgLB(i, j, k, 3), qq) &
                                         + fac_qq * max(v2xgLB(i, j, k, 3) - qq, 0.)
#endif
#ifdef CE
                    v2xgLB(i, j, k, 3) = v2xgLB(i, j, k, 3) * qs / qse
#endif

                enddo
            enddo
        enddo

        do i = mx - n6mxLB, mx
            do k = 1, mz
                do j = 1, my
                    tt = v2xdLB(i, j, k, 4) &
                         * exp(cap * log(v2xdLB(i, j, 1, 5) * sigma(k) + ptopDY))
                    qs = qsat0D(tt, sigma(k), v2xdLB(i, j, 1, 5), ptopDY, 0)
#ifdef FS
                    qq = qs * rh_min
#endif
#ifdef CE
                    qse = qse_0D(tt, sigma(k), v2xdLB(i, j, 1, 5), ptopDY)
#endif
#ifdef FS
                    v2xdLB(i, j, k, 3) = min(v2xdLB(i, j, k, 3), qq) &
                                         + fac_qq * max(v2xdLB(i, j, k, 3) - qq, 0.)
#endif
#ifdef CE
                    v2xdLB(i, j, k, 3) = v2xdLB(i, j, k, 3) * qs / qse
#endif

                enddo
            enddo
        enddo

        do j = 1, n7myLB
            do k = 1, mz
                do i = 1, mx
                    tt = v2yiLB(i, j, k, 4) &
                         * exp(cap * log(v2yiLB(i, j, 1, 5) * sigma(k) + ptopDY))
                    qs = qsat0D(tt, sigma(k), v2yiLB(i, j, 1, 5), ptopDY, 0)
#ifdef FS
                    qq = qs * rh_min
#endif
#ifdef CE
                    qse = qse_0D(tt, sigma(k), v2yiLB(i, j, 1, 5), ptopDY)
#endif
#ifdef FS
                    v2yiLB(i, j, k, 3) = min(v2yiLB(i, j, k, 3), qq) &
                                         + fac_qq * max(v2yiLB(i, j, k, 3) - qq, 0.)
#endif
#ifdef CE
                    v2yiLB(i, j, k, 3) = v2yiLB(i, j, k, 3) * qs / qse
#endif

                enddo
            enddo
        enddo

        do j = my - n6myLB, my
            do k = 1, mz
                do i = 1, mx
                    tt = v2ysLB(i, j, k, 4) &
                         * exp(cap * log(v2ysLB(i, j, 1, 5) * sigma(k) + ptopDY))
                    qs = qsat0D(tt, sigma(k), v2ysLB(i, j, 1, 5), ptopDY, 0)
#ifdef FS
                    qq = qs * rh_min
#endif
#ifdef CE
                    qse = qse_0D(tt, sigma(k), v2ysLB(i, j, 1, 5), ptopDY)
#endif
#ifdef FS
                    v2ysLB(i, j, k, 3) = min(v2ysLB(i, j, k, 3), qq) &
                                         + fac_qq * max(v2ysLB(i, j, k, 3) - qq, 0.)
#endif
#ifdef CE
                    v2ysLB(i, j, k, 3) = v2ysLB(i, j, k, 3) * qs / qse
#endif

                enddo
            enddo
        enddo

    else
#ifdef WR
        write(6, 6003) jdarGE, labmGE(mmarGE), iyrrGE, &
            jhurGE, minuGE, jsecGE, itimar
6003    format('  Current /', i3, '-', a3, '-', i4, i3, ':', i2, ':', i2, &
               '   t =', i12, 's A.P.')
#endif
    endif

    ! +--Time Interpolation
    ! +  ==================

    if(itimar <= tim2LB .and. tim1LB < tim2LB) then

        rate = float(itimar - tim1LB) / float(tim2LB - tim1LB)
        do iv_ilb = 1, 5
            do i = 1, n7mxLB
                do k = 1, mz
                    do j = 1, my
                        vaxgLB(i, j, k, iv_ilb) = v1xgLB(i, j, k, iv_ilb) + &
                                                  (v2xgLB(i, j, k, iv_ilb) - v1xgLB(i, j, k, iv_ilb)) * rate

                        if(iv_ilb == 3 .and. correction_humidity_boundary /= 0.) &
                            vaxgLB(i, j, k, iv_ilb) = vaxgLB(i, j, k, iv_ilb) * (1.+ &
                                                                                 correction_humidity_boundary)

                    enddo
                enddo
            enddo

            do i = mx - n6mxLB, mx
                do k = 1, mz
                    do j = 1, my
                        vaxdLB(i, j, k, iv_ilb) = v1xdLB(i, j, k, iv_ilb) + &
                                                  (v2xdLB(i, j, k, iv_ilb) - v1xdLB(i, j, k, iv_ilb)) * rate

                        if(iv_ilb == 3 .and. correction_humidity_boundary /= 0.) &
                            vaxdLB(i, j, k, iv_ilb) = vaxdLB(i, j, k, iv_ilb) * (1.+ &
                                                                                 correction_humidity_boundary)

                    enddo
                enddo
            enddo

            do j = 1, n7myLB
                do k = 1, mz
                    do i = 1, mx
                        vayiLB(i, j, k, iv_ilb) = v1yiLB(i, j, k, iv_ilb) + &
                                                  (v2yiLB(i, j, k, iv_ilb) - v1yiLB(i, j, k, iv_ilb)) * rate

                        if(iv_ilb == 3 .and. correction_humidity_boundary /= 0.) &
                            vayiLB(i, j, k, iv_ilb) = vayiLB(i, j, k, iv_ilb) * (1.+ &
                                                                                 correction_humidity_boundary)

                    enddo
                enddo
            enddo

            do j = my - n6myLB, my
                do k = 1, mz
                    do i = 1, mx
                        vaysLB(i, j, k, iv_ilb) = v1ysLB(i, j, k, iv_ilb) + &
                                                  (v2ysLB(i, j, k, iv_ilb) - v1ysLB(i, j, k, iv_ilb)) * rate

                        if(iv_ilb == 3 .and. correction_humidity_boundary /= 0.) &
                            vaysLB(i, j, k, iv_ilb) = vaysLB(i, j, k, iv_ilb) * (1.+ &
                                                                                 correction_humidity_boundary)

                    enddo
                enddo
            enddo
        enddo

        ! +--Zonally Averaged Version
        ! +  ------------------------

        if(mmy == 1) then
            if(itexpe == 1) then
                pst__1 = vaxgLB(1, 1, 1, 5)
                pst_mx = vaxdLB(mx, 1, 1, 5)
            endif
#ifdef IN
            ! +--LBC: Smooth Set up of the Large Scale Wind
            ! +  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
            if(itexpe * dt < 86400.) then
                rate = itexpe * dt / 86400.
                do iv_ilb = 1, 2
                    do i = 1, n7mxLB
                        do k = 1, mz
                            do j = 1, my
                                vaxgLB(i, j, k, iv_ilb) = vaxgLB(i, j, k, iv_ilb) * rate
                            enddo
                        enddo
                    enddo
                    do i = mx - n6mxLB, mx
                        do k = 1, mz
                            do j = 1, my
                                vaxdLB(i, j, k, iv_ilb) = vaxdLB(i, j, k, iv_ilb) * rate
                            enddo
                        enddo
                    enddo
                enddo
            endif
#endif
            ! +--Meridional Wind: zero Mass Flux Correction, excedent Mass Flux Reduction
            ! +  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
            iv_ilb = 2
            j = 1
            do i = 1, n7mxLB
                vax_An = 0.
                vax_Ap = 0.
                do k = 1, mz
                    vax_An = vax_An + min(real(vaxgLB(i, j, k, iv_ilb)), 0.) &
                             * dsigm1(k)
                    vax_Ap = vax_Ap + max(real(vaxgLB(i, j, k, iv_ilb)), 0.) &
                             * dsigm1(k)
                enddo
                vax_A = vax_An + vax_Ap
                if(vax_A > 0.) then
                    vax_A = (vax_Ap - vax_A) / max(epsi, vax_Ap)
                    do k = 1, mz
                        if(vaxgLB(i, j, k, iv_ilb) > 0.) &
                            vaxgLB(i, j, k, iv_ilb) = vaxgLB(i, j, k, iv_ilb) * vax_A
                    enddo
                else
                    vax_A = (vax_An - vax_A) / min(-epsi, vax_An)
                    do k = 1, mz
                        if(vaxgLB(i, j, k, iv_ilb) < 0.) &
                            vaxgLB(i, j, k, iv_ilb) = vaxgLB(i, j, k, iv_ilb) * vax_A
                    enddo
                endif
            enddo

            do i = mx - n6mxLB, mx
                vax_An = 0.
                vax_Ap = 0.
                do k = 1, mz
                    vax_An = vax_An + min(real(vaxdLB(i, j, k, iv_ilb)), 0.) &
                             * dsigm1(k)
                    vax_Ap = vax_Ap + max(real(vaxdLB(i, j, k, iv_ilb)), 0.) &
                             * dsigm1(k)
                enddo
                vax_A = vax_An + vax_Ap
                if(vax_A > 0.) then
                    vax_A = (vax_Ap - vax_A) / max(epsi, vax_Ap)
                    do k = 1, mz
                        if(vaxdLB(i, j, k, iv_ilb) > 0.) &
                            vaxdLB(i, j, k, iv_ilb) = vaxdLB(i, j, k, iv_ilb) * vax_A
                    enddo
                else
                    vax_A = (vax_An - vax_A) / min(-epsi, vax_An)
                    do k = 1, mz
                        if(vaxdLB(i, j, k, iv_ilb) < 0.) &
                            vaxdLB(i, j, k, iv_ilb) = vaxdLB(i, j, k, iv_ilb) * vax_A
                    enddo
                endif
            enddo

            ! +--Surface Pressure:  no Mass       Variation
            ! +  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
            do i = 1, n7mxLB
                vaxgLB(i, 1, 1, 5) = pst__1                             ! [kPa]
            enddo
            do i = mx - n6mxLB, mx
                vaxdLB(i, 1, 1, 5) = pst_mx                             ! [kPa]
            enddo
        endif

        ! +--Sea Surface Temperatures
        ! +  ------------------------

        do j = 1, my
            do i = 1, mx

                !Coupling:    inside NEMO domaine sst_LB changed in
                !            - inigen.f (first timpe step)
                !            -oasis_2_mar.f (all the others)
                !           outside MAJ sst_LB here with the usual sst rate
                ! CK_AO 28/02/2020

                !old way
                !c #AO       sst1LB(i,j)     =sst_LB(i,j)
                !c #AO       sst2LB(i,j)     =sst_LB(i,j)

                sst_LB(i, j) = sst1LB(i, j) + &
                               (sst2LB(i, j) - sst1LB(i, j)) * rate
#ifdef AO
                if(weightao_sst(i, j) /= 1) then
                    sst_LB(i, j) = (1.-weightao_sst(i, j)) * srftAO(i, j, 1) + &
                                   (weightAO_sst(i, j) * sst_LB(i, j))
                endif
#endif
            enddo
        enddo

        newlbc = 1

    else
        newlbc = 0
    endif

    return
end
