#include "MAR_pp.def"
subroutine INIglf(ihamr_glf, nhamr_glf, newglfINI)
    ! +------------------------------------------------------------------------+
    ! | MAR INPUT      SVAT                                     7-06-2002  MAR |
    ! |   subroutine INIglf is used to initialize MAR Green Leaf Fractions     |
    ! |                                                                        |
    ! +------------------------------------------------------------------------+
    ! |                                                                        |
    ! |   INPUT:  ihamr_glf: Time Digital Filter Status                        |
    ! |   ^^^^^   nhamr_glf: Time Digital Filter Set Up                        |
    ! |                                                                        |
    ! |   OUTPUT: newglfINI: (0,1) ==> (NO new glf , new glf)                  |
    ! |   ^^^^^^^                                                              |
    ! |                                                                        |
    ! |   OUTPUT: alaiTV: Current                     Leaf  Area Index    (LAI)|
    ! |   ^^^^^^^ LAI1VB: Previous Nesting Time Step  Leaf  Area Index         |
    ! |           LAI2VB: Next     Nesting Time Step  Leaf  Area Index         |
    ! |           glf_TV: Current                     Green Leaf Fraction (GLF)|
    ! |           glf1VB: Previous Nesting Time Step  Green Leaf Fraction      |
    ! |           glf2VB: Next     Nesting Time Step  Green Leaf Fraction      |
    ! |           tim1VB,tim2VB:   Times  n, n+1  of  LAI and GLF              |
    ! |                                                                        |
    ! |   CAUTION: It is assumed that tim1VB and tim2VB do not change when the |
    ! |   ^^^^^^^^ Variables are reassigned after the dynamical Initialization |
    ! |            (Reassignation => itexpe := nham => timar := timar-nham*dt) |
    ! |                                                                        |
    ! +------------------------------------------------------------------------+
    ! +
    use marctr
    use marphy
    use mardim
    use margrd
    use mar_ge
    use mar_sl
    use mar_sv
    use mar_tv
    use mar_vb
    ! +
    implicit none

    integer i, j, k, m
    integer ihamr_glf, nhamr_glf
    integer newglfINI
    ! +
    ! +
    ! +--Local  Variables
    ! +  ================
    ! +
    !XF
    integer(kind=8) itisva, iv_glf
    ! int*8 is needed for making future projections!!!!
    real rate
    ! +
    ! +
    ! +--Current Time
    ! +  ============
    ! +
    itisva = ou2sGE(iyrrGE, mmarGE, jdarGE, jhurGE, minuGE, jsecGE)
#ifdef HF
    itisva = itisva + (ihamr_glf + nhamr_glf) * idt
#endif
    ! +
    ! +
    ! +--Reinitialization of the Leaf Area Index and the Green Leaf Fraction
    ! +  -------------------------------------------------------------------
    ! +
    if(iterun == 0) then
        jdh_VB = 1
        iyr_VB = iyrrGE
        mma_VB = mmarGE
        jda_VB = jdarGE
        jhu_VB = jhurGE
        tim1VB = itisva
        tim2VB = itisva
        do iv_glf = 1, nvx
            do j = 1, my
                do i = 1, mx
#ifdef LN
                    LAI1VB(i, j, iv_glf) = alaiTV(i, j, iv_glf)
                    LAI2VB(i, j, iv_glf) = alaiTV(i, j, iv_glf)
#endif
                    glf1VB(i, j, iv_glf) = glf_TV(i, j, iv_glf)
                    glf2VB(i, j, iv_glf) = glf_TV(i, j, iv_glf)
                enddo
            enddo
        enddo
        ! +
    endif
    ! +
    ! +
    ! +--New VBC
    ! +  =======
    ! +
    if(itisva > tim2VB) then
        ! +
        tim1VB = tim2VB
        ! +
        write(6, 6001) jda_VB, labmGE(mma_VB), iyr_VB, &
            jhu_VB, tim1VB, &
            jdarGE, labmGE(mmarGE), iyrrGE, &
            jhurGE, minuGE, jsecGE, itisva
6001    format(/, '  1st VBC /', i3, '-', a3, '-', i4, i3, ' ', 2x, '/', 2x, &
                '   t =', i12, 's A.P.', &
                /, '  Current /', i3, '-', a3, '-', i4, i3, ':', i2, ':', i2, &
                '   t =', i12)
        ! +
        if(jdh_VB == 0) jdh_VB = -1
        open(unit=11, status='old', form='unformatted', file='MARglf.DAT')
        rewind 11
11      continue
        if(jdh_VB <= 0) go to 10
        ! +
        ! +
        ! +--VBC at nesting time step n
        ! +  --------------------------
        ! +
        do iv_glf = 1, nvx
            do j = 1, my
                do i = 1, mx
#ifdef LN
                    LAI1VB(i, j, iv_glf) = LAI2VB(i, j, iv_glf)
#endif
                    glf1VB(i, j, iv_glf) = glf2VB(i, j, iv_glf)
#ifdef LN
                    LAI2VB(i, j, iv_glf) = 0.d0
#endif
                    glf2VB(i, j, iv_glf) = 0.d0
                enddo
            enddo
        enddo
        ! +
        ! +
        ! +--VBC at nesting time step n+1
        ! +  ----------------------------
        ! +
        read(11) iyr_VB, mma_VB, jda_VB, jhu_VB, jdh_VB
        read(11) glf2VB
#ifdef LN
        read(11) LAI2VB
#endif
        ! +
        tim2VB = ou2sGE(iyr_VB, mma_VB, jda_VB, jhu_VB, 0, 0)
        ! +
        if(itisva > tim2VB) go to 11
        ! +
        write(6, 6002) jda_VB, labmGE(mma_VB), iyr_VB, &
            jhu_VB, jdh_VB, tim2VB
6002    format('  2nd VBC /', i3, '-', a3, '-', i4, i3, ' ', 2x, '/(', i1, &
               ')  t =', i12, /, 1x)
        ! +
10      continue
        close(unit=11)
        ! +
    else
#ifdef WR
        write(6, 6003) jdarGE, labmGE(mmarGE), iyrrGE, &
            jhurGE, minuGE, jsecGE, itisva
#endif
6003    format('  Current /', i3, '-', a3, '-', i4, i3, ':', i2, ':', i2, &
               '   t =', i12, 's A.P.')
    endif
    ! +
    ! +
    ! +--Time Interpolation
    ! +  ==================
    ! +
    if(itisva <= tim2VB .and. tim1VB < tim2VB) then
        ! +
        rate = float(itisva - tim1VB) / float(tim2VB - tim1VB)
        do iv_glf = 1, nvx
            do j = 1, my
                do i = 1, mx
#ifdef LN
                    alaiTV(i, j, iv_glf) = LAI1VB(i, j, iv_glf) + &
                                           (LAI2VB(i, j, iv_glf) - LAI1VB(i, j, iv_glf)) * rate
#endif
                    glf_TV(i, j, iv_glf) = glf1VB(i, j, iv_glf) + &
                                           (glf2VB(i, j, iv_glf) - glf1VB(i, j, iv_glf)) * rate
                enddo
            enddo
        enddo
        ! +
        newglfINI = 1
        ! +
    else
        newglfINI = 0
    endif
    ! +
    return
endsubroutine INIglf
