#include "MAR_pp.def"
subroutine inigen
    ! +------------------------------------------------------------------------+
    ! | MAR INPUT                                              11-04-2023  MAR |
    ! |   subroutine inigen set up MAR Initialization Procedure                |
    ! |                                                                        |
    ! +------------------------------------------------------------------------+

#ifdef AO
    use mod_oasis
    ! mar_module : TANGO modules
    use mar_module
#endif

    ! +--Global Variables
    ! +  ================
    use marctr
    use marphy
    use mardim
    use margrd
    use mar_ge
    use marsnd
    use mar_dy
    use mar_lb
    use mar_ub
    use marsib
    use mar_te
    use mar_tu
    use mar_fi
    use mar_ra
    use mar_hy
    use mar_ca
    use mar_pb
    use mar_io
    use marssn
    use mar_sl
#ifdef NH
    use mar_nh
#endif
#ifdef Di
    ! include 'MAR_DI.inc' #CAa
#endif
#ifdef TC
    use mar_tc
#endif
#ifdef AO
    use mar_ao
    use mar_tv
#endif
#ifdef PO
    use mar_po
#endif
    use mar_sv
#ifdef BS
    use mar_bs
#endif
#ifdef OL
    use mar_ol
#endif
#ifdef iso
    use mariso, only: iso_init_type, qvDY_iso, qvapSL_iso, &
                      dqv_CA_iso, dqw_CA_iso, dqi_CA_iso, &
                      drr_CA_iso, dss_CA_iso, dsn_CA_iso, &
                      rainCA_iso, snowCA_iso, &
                      qiHY_iso, qsHY_iso, qwHY_iso, &
                      qrHY_iso, rainHY_iso, rai0HY_iso, &
                      snowHY_iso, sno0HY_iso, sfa0HY_iso, crysHY_iso, &
                      SLuqs_iso, SLuqsl_iso
#endif

    implicit none

#ifdef AO
    character * 100 filein
    character * 3 mxc, myc
    logical file_exists
#endif

    ! +--Local Variables and DATA
    ! +  ========================
    integer i, j, k, m
    external zext
    integer zext
    logical zoro
    logical verti0
    integer itever, itexpe2
#ifdef NH
    integer iyrONH, mmaONH, jdaONH, jhuONH
#endif
    integer iyrCVA, mmaCVA, jdaCVA, jhuCVA
    integer iyrHYD, mmaHYD, jdaHYD, jhuHYD
#ifdef TC
    integer iyrTCA, mmaTCA, jdaTCA, jhuTCA
#endif
    integer iyrTUR, mmaTUR, jdaTUR, jhuTUR
    integer iyrSOL, mmaSOL, jdaSOL, jhuSOL
#ifdef PO
    integer iyrPOL, mmaPOL, jdaPOL, jhuPOL
#endif
    integer imezdy, jmezdy, mzabs1, itizon
    integer lo_CAU, ipri, iv_ini, n, isl

    ! +--Modified Time Step
    ! +  ~~~~~~~~~~~~~~~~~~
    integer YYtmp, MMtmp, DDtmp
    real dtdom, zmin_0, aavu_0, bbvu_0, ccvu_0, ps_sig
#ifdef HF
    real hham, nham, hhac, thac
#endif
    real aladyn, alodyn, gradTz, rhcrit, tstart
    real sh2(mx, my), sh3(mx, my, mw - 1)
    character * 3 swich(0:1)
    data swich/'OFF', 'ON '/
    data ps_sig/100./

    ! ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    ! +++ INITIALISATION of the DOMAIN characterISTICS +++++++++++++++++++++++++
    ! ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

    open(unit=1, status='old', file='MARdom.dat')
    rewind 1
    read(1, 141) explIO
141 format(a3)
    read(1, 145) GElat0, GElon0, GEddxx
    read(1, 1425) mma0GE, jda0GE, jhu0GE, itizon, iyr0GE
1425 format(4i4, i4)
    read(1, 1426) imez, jmez, maptyp, GEtrue
1426 format(3i4, 28x, e13.6)
    read(1, 1427) igrdIO
1427 format(5i4)
    read(1, 1427) jgrdIO
    read(1, 1427) IO_gen
    IO_loc = IO_gen
    read(1, 1427) mxw1IO, mxw2IO, ixw_IO
    read(1, 1427) myw1IO, myw2IO, iyw_IO
    read(1, 1427) mzw1IO, mzw2IO, izw_IO
    ! kkatIO, kmidIO : For output on NetCDF Files:
    !                  Assumed Levels of Bound.Layer / Mid Troposph.
    read(1, 1427) kkatIO, kmidIO
    read(1, 145) dx, dy, dtdom
145 format(4d13.6)
    read(1, 1450) verti0
1450 format(l3)
    ! ptopDY: model top pressure
    read(1, 145) ptopDY
    read(1, 145) zmin_0, aavu_0, bbvu_0, ccvu_0
    z__SBL = zmin_0
    read(1, 145) FIslot, FIslou, FIslop, FIkhmn
    read(1, 145) TUkhff, TUkhmx
    TUkhmx = TUkhmx * dtdom / dt
    read(1, 145) tequil, dtquil
    read(1, 145) zs_SL, zn_SL, zl_SL, cs2SL
    read(1, 145) sst_SL
    read(1, 145) dtagSL
    read(1, 145) w20SL, wg0SL, wk0SL, wx0SL
    read(1, 1430)
1430 format(1x)
    read(1, 143) isolSL
143 format((10i13))
    read(1, 1430)
    read(1, 1432) sh2
    if(itexpe <= 1) then
        sh = sh2
    endif
1432 format((10d13.6))
    read(1, 1430)
    read(1, 1432) SL_z0
    read(1, 1430)
    read(1, 1432) SL_r0
    read(1, 1430)
    read(1, 1432) ch0SL
    read(1, 1430)
    read(1, 1432) rsurSL
    read(1, 1430)

    ! +--Underlaying Surface Albedo (to which Surface alb0SL is set,
    ! +  ~~~~~~~~~~~~~~~~~~~~~~~~~~  unless NOT 1st Run, itexpe /= 0)
    read(1, 1432) albsSL
    alb0SL = albsSL
    read(1, 1430)
    read(1, 1432) eps0SL
    read(1, 1430)
    read(1, 1432) d1_SL
#ifdef po
    read(1, 1430)
    read(1, 1432) uocnPO
    read(1, 1430)
    read(1, 1432) vocnPO
    read(1, 1430)
    read(1, 1432) aPOlyn
#endif
    if(geoNST) then
        read(1, 1430)
        read(1, 1432)((GElonh(i, j), i=1, mx), j=1, my)
        read(1, 1430)
        read(1, 1432)((GElatr(i, j), i=1, mx), j=1, my)
        read(1, 1430)
        read(1, 1432) sigma

        ! degrees --> radians
        GElatr = GElatr * degrad
        ! degrees --> hours
        GElonh = GElonh / 15.

        do k = 1, mz
            zsigma(k) = -(sst_SL / 0.0065) * ((1.e0 + (sigma(k) - 1.) &
                                               * (1.e2 / ps_sig))**(RDryAi * 0.0065 / gravit) - 1.)
        enddo

        if(IO_gen >= 2) then
            write(21, 130)(sigma(k), k=1, mz)
130         format(/, '  Sigma    Levels :', /,(1x, 15f8.4))
            write(21, 131)(zsigma(k), k=1, mz)
131         format(/, '  Altitude Levels :', /,(1x, 15f8.1))
        endif
    endif

#ifdef OR
    ! +--Orography Roughness
    ! +  ~~~~~~~~~~~~~~~~~~~
    do k = 1, mw
        do j = 1, my
            do i = 1, mx
                SLzoro(i, j, k) = SL_z0(i, j, k)
            enddo
        enddo
    enddo
    zoro = .true.
    zoro = .false.
    if(zoro) STOP '@#! Uses Andreas parameterization of z0_h with z0_oro'
#endif
    close(unit=1)

    ! + ***   *CL* Read subgrid topography   ***
    if(mw == 5) then
        open(unit=555, status='old', file='MARdom2.dat')
        print *, '***************************'
        print *, '*   Read of MARdom2.dat   *'
        print *, '***************************'
        read(555, '(f12.6)') sh3
        if(itexpe <= 1) then
            do i = 1, mx
                do j = 1, my
                    do k = 1, nsx - 1
                        sh_int(i, j, k) = sh3(i, j, k)
                    enddo
                    sh_int(i, j, nsx) = sh(i, j)
                enddo
            enddo
        endif
        close(unit=555)
    endif

#ifdef AO
    ! + ***  AO_CK ***
    ! Read Weight file (combine SSC from reanalysis and ocean model)   ***
    print *, "check if coupling AO:", coupling_ao
    if(coupling_ao) then
        write(mxc, '(i3)') mx
        if(mx < 100) write(mxc, '(i2)') mx
        write(myc, '(i3)') my
        if(my < 100) write(myc, '(i2)') my
        filein = 'TROUPLE-'//trim(mxc)//'x'//trim(myc)//'.cdf'
        inquire(file=trim(filein), exist=file_exists)
        if(file_exists) then
            call CF_READ2D(trim(filein), 'WEIGHT', 1, mx, my, 1, weightao)
            print *, 'Read ', trim(filein)
        else
            print *, 'Define TROUPLE file before coupling!'
            stop
        endif
        do i = 1, mx
            do j = 1, my
                ! NO NEMO field in the first 3 pixels from the relaxation zone
                ! They MUST also be considered as LAND for OASIS
                if(i <= 3) weightao(i, j) = 1.
                ! even if they are ocean
                if(j <= 3) weightao(i, j) = 1.
                if(i >= mx - 2) weightao(i, j) = 1.
                if(j >= my - 2) weightao(i, j) = 1.
            enddo
        enddo
        ! USING variable from coupling
        ! 1 = rean everywhere 0=NEMO everywhere
        !   = weightao NEMO/REANALYSIS
        ! weightao_sst : sst
        weightao_sst = weightao
        ! weightao_sic : SIC
        weightao_sic = weightao
        ! weightao_st : Sea ice/ Snow on ice surface temp
        weightao_st = weightao
        ! weightao_al : Sea/Snow on ice Albedo
        weightao_al = weightao
        ! weightao_sit : Sea ice thickness
        weightao_sit = weightao
        ! weightao_snt : Snow on ice thickness
        weightao_snt = weightao
        print *, "If doubt(s) on coupling, check weightao definition"
    endif
#endif

    ! +--SVAT IO
    ! +  -------
    if(vegmod .and. .not. reaVAR) then
        ! +  ******
        call svasav('read')
        ! +  ******
    endif

    ! +--Time Discretisation
    ! +  ===================

    ! +--Slow Dynamics
    ! +  -------------
    idt = dt
    jdt = (dt - idt) * 100.

    ! +--Fast Dynamics
    ! +  -------------
    dtfast = dt / (ntFast + 1)

    ! +--Subgrids
    ! +  --------
    if(dtDiff < dt) then
        if(dtDiff > 0.) then
            ! ntDiff : Number of Subgrid Scale Steps for 1 Dynamical Step
            ntDiff = dt / dtDiff
            ! dtDiff : Calibrated Subgrid Scale Time Step
            dtDiff = dt / ntDiff
            jtDiff = 1
        else
            ntDiff = 1
            jtDiff = nboucl * nprint + 1
        endif
    else
        ! jtDiff : Number of Dynamical Steps for 1 Subgrid Scale Step
        jtDiff = dtDiff / dt
        jtDiff = max(jtDiff, 1)
        ! dtDiff : Calibrated Subgrid Scale Time Step
        dtDiff = dt * jtDiff
        ntDiff = 1
    endif
    if(dtDiff > 0.) then
        !XF
        ntDiff = 1
        dtDiff = dt
        jtDiff = 1
        !XF
    endif

    ! +--Surface   Physics
    ! +  -----------------
    if(dtPhys < dt) then
        ! ntPhys : Number of Surface Phys. Steps for 1 Dynamical Step
        ntPhys = dt / dtPhys
        ! dtPhys :  Calibrated Surface Phys. Time Step
        dtPhys = dt / ntPhys
        jtPhys = 1
    else
        ! jtPhys : Number of Dynamical Steps for 1 Surface Phys. Step
        jtPhys = dtPhys / dt
        jtPhys = max(jtPhys, 1)
        ! dtPhys : Calibrated Surface Physics Time Step
        dtPhys = dt * jtPhys
        ntPhys = 1
    endif

    !XF
    ntPhys = 1
    dtPhys = dt
    jtPhys = 1
    !XF

    ! +--Radiation Physics
    ! +  -----------------
    if(dtRadi < dt) then
        write(6, *) ' NO Split Time Differ.  on dtRadi  !!#�@|#@&##!!     EMERGENCY EXIT '
        STOP
        ! ntRadi : Number of Surface Phys. Steps for 1 Dynamical Step
        ntRadi = dt / dtRadi
        ! dtRadi : Calibrated Surface Phys. Time Step
        dtRadi = dt / ntRadi
        jtRadi2 = 1
    else
        ! jtRadi : Number of Dynamical Steps for 1 Surface Phys. Step
        jtRadi2 = dtRadi / dt
        ! dtRadi : Calibrated Surface Physics Time Step
        dtRadi = dt * jtRadi2
        ntRadi = 1
    endif

    ! +--Other Constants
    ! +  ---------------

    t2SLtn = 1.0 / dtPhys - 0.50 / cs2SL
    t2SLtd = 1.0 / dtPhys + 0.50 / cs2SL
    ! fracSL : Fractional Time (Blowing Snow Srf Flux Computation)
    !          Factor   1.8d3 is the Turbulence Time Scale (1/2 h)
    !          Factor   0.6d3 is used.
    fracSL = dt / 0.6e3
    fracSL = min(unun, fracSL)

    ! +--Coriolis Parameter
    ! +  ==================
    ! fcorDY : Coriolis Parameter (Indicative Value)
    fcorDY(imez, jmez) = 2.0 * earthv * sin(GElat0 * degrad)

    ! +--OUTPUT
    ! +  ======
    if(IO_loc >= 1) then
        write(21, 600) explIO, GElat0, GElon0, &
            jda0GE, mma0GE, jhu0GE, itizon, &
            minuGE, jsecGE, fcorDY(imez, jmez), cz0_GE
600     format(/, ' SIMULATION ', a3, /, ' ++++++++++++++', //, &
                ' Lat.', f5.1, 3x, 'Long.', f6.1, 4x, 'Date :', i3, '-', i2, &
                ' / ', i2, ' h.UT +(', i3, ')LT', i3, ' min.', i3, ' sec.', &
                //, ' f(Coriolis) = ', e12.5, &
                /, ' cos(Z) min  : ', e12.5)
        write(21, *) ' CODE STATUS  +++++++++++'
#ifdef HF
        write(21, *) '#HF Initialisation of Huang and Lynch 1993   (HAMMING Filter)'
#endif
#ifdef NH
        write(21, *) '#NH DYNAMICS: Non-Hydrost. Code  (adapted from Laprise, 1992)'
#endif
#ifdef ON
        write(21, *) '#ON DYNAMICS: Non-Hydrost. Corr. (Weisman &al.1997 MWR p.541)'
#endif
#ifdef DD
        write(21, *) '#DD DYNAMICS: Mass Divergence Damper (Skamarock &Klemp, 1992)'
#endif
        write(21, *) '#VN DYNAMICS: Variable Number of Leap-Frog Loops (Fast Waves)'
#ifdef IL
        write(21, *) '#IL DYNAMICS: PGF: SBL Fraction with  Air = Surface Temperat.'
#endif
#ifdef GE
        write(21, *) '#GE DYNAMICS: Geographic Coordinates may be red in MARdom.dat'
#endif
#ifdef CC
        write(21, *) '#CC DYNAMICS: Constant Coriolis Parameter = fcorDY(imez,jmez)'
#endif
#ifdef HE
        write(21, *) '#HE DYNAMICS: NORLAM       Vertical Discretisation(29 Levels)'
#endif
#ifdef lm
        write(21, *) '#lm DYNAMICS: LMDZ   Model Vertical Discretisation(11 Levels)'
#endif
#ifdef PA
        write(21, *) '#PA DYNAMICS: Parish Model Vertical Discretisation(10 Levels)'
#endif
#ifdef PV
        write(21, *) '#PV DYNAMICS: Large Scale Flow conserves Pot. Vort. (2D ONLY)'
#endif
#ifdef pv
        write(21, *) '#pv DYNAMICS: Large Scale Flow conserves Pot. Temp. (2D ONLY)'
#endif
#ifdef UW
        write(21, *) '#UW DYNAMICS: Advect.  3rd Accurate in Space Upstream Scheme '
#endif
#ifdef UP
        write(21, *) '#UP DYNAMICS: Vertical 1st Accurate in Space Upstream Scheme '
#endif
#ifdef ZU
        write(21, *) '#ZU DYNAMICS: Vertical Advection: Cubic Spline (4th accurate)'
#endif
#ifdef ZO
        write(21, *) '#ZO DYNAMICS: Vertical Advection: Cubic Spline (+Open  SrfBC)'
#endif
#ifdef UR
        write(21, *) '#UR DYNAMICS: Vertical Advection/ Upper Radiating Bound.Cond.'
#endif
#ifdef EP
        write(21, *) '#EP DYNAMICS: Lateral Sponge included in    Horizontal Filter'
#endif
#ifdef RB
        write(21, *) '#RB DYNAMICS: Lateral BC: Carpenter(1982) Sommerfeld Modified'
#endif
        write(21, *) '#DA DYNAMICS: Lateral BC: Davies (1976) BC on Wind // Lat.B. '
#ifdef da
        write(21, *) '#da DYNAMICS: Lateral BC: Davies (1976) BC: K, nu  computed. '
#endif
#ifdef FB
        write(21, *) '#FB DYNAMICS: Lateral BC: Fixed in Horizontal Cubic Spline   '
#endif
#ifdef OB
        write(21, *) '#OB DYNAMICS: Lateral BC: Zero Gradient                      '
#endif
#ifdef OG
        write(21, *) '#OG DYNAMICS: Lateral BC: (Left) NO Nudging if relaxg=.false.'
#endif
#ifdef ob
        write(21, *) '#ob DYNAMICS: Lateral BC: Zero Gradient (Subroutine LBC000)  '
#endif
        write(21, *) '#RF DYNAMICS: Top BC: Rayleight Friction in the Top Sponge   '
#ifdef Di
        write(21, *) '#Di DYNAMICS: Top BC: Dirichlet  (fixed)                     '
#endif
#ifdef V
        write(21, *) '#V+ DYNAMICS: Top BC: Von Neuman (prescrib.non zero-gradient)'
#endif
#ifdef PS
        write(21, *) '#PS DYNAMICS: Domain Averaged Pressure Thickness   maintained'
#endif
#ifdef DY
        write(21, *) '#DY DYNAMICS: OUTPUT: Components  lowest Level Forces Balance'
#endif
#ifdef _PE
        write(21, *) '_PE DIFFUSION:(%Grad.)   Slope      USE+ _HH or     (_HH #CR)'
#endif
#ifdef PE
        write(21, *) '#PE DIFFUSION:(%Deform.) Slope      USE+ #DF or (#DF #DC #CR)'
#endif
#ifdef _HH
        write(21, *) '_HH DIFFUSION:(%Grad.)   Vert.Cor.  USE+ _PE                 '
#endif
#ifdef DF
        write(21, *) '#DF DIFFUSION:(%Deform.) Vert.Cor.  USE+ #PE or (#PE #DC #CR)'
#endif
#ifdef DC
        write(21, *) '#DC DIFFUSION:(%Deform.)            USE+        (#DF #PE #CR)'
#endif
#ifdef CR
        write(21, *) '#CR DIFFUSION: Cross Corr.    USE+ (_PE _HH) or (#DF #PE #DC)'
#endif
#ifdef FE
        write(21, *) '#FE FILTERING: Digital Filtering of TKE                      '
#endif
#ifdef fe
        write(21, *) '#fe FILTERING: Digital Filtering of TKE  is   not vectorized '
#endif
#ifdef FO
        write(21, *) '#FO FILTERING: Digital Filtering of TKE (zero gradient at LB)'
#endif
#ifdef KS
        write(21, *) '#KS FILTERING: Upper Sponge is solved by horizontal filtering'
#endif
#ifdef BR
        write(21, *) '#BR TURBULENCE: 2.5 Level  2nd Order  (Brasseur         1997)'
#endif
        write(21, *) '#CA CONVECTIVE  Adjustment (general                 Set Up)  '
#ifdef cA
        write(21, *) '#cA CONVECTIVE  Adjustment (no Double Counting      Set Up)  '
#endif
        write(21, *) '#ca CONVECTIVE  Adjustment (no Vector               Set Up)NV'
#ifdef FC
        write(21, *) '#FC CONVECTIVE  Adjustment (Fritsch & Chappell 1980 Set Up)  '
#endif
#ifdef fc
        write(21, *) '#fc CONVECTIVE  Adjustment (Fritsch & Chappell 1980 Set Up)NV'
#endif
#ifdef kf
        write(21, *) '#kf CONVECTIVE  Adjustment (Kain    & Fritsch  1990 Improvm.)'
#endif
#ifdef IT
        write(21, *) '#IT CONVECTIVE  Adjustment (over 5km Adiabatics Starting Pts)'
#endif
#ifdef AN
        write(21, *) '#AN CONVECTIVE  Adjustment (Subgrid Mountain Breeze included)'
#endif
#ifdef WD
        write(21, *) '#WD CONVECTIVE  Adjustment (Water Detrainment       included)'
#endif
#ifdef CG
        write(21, *) '#CG CONVECTIVE  Adjustment (Cloud Glaciation        included)'
#endif
#ifdef ND
        write(21, *) '#ND CONVECTIVE  Adjustment (No Precip if LevFSink<LiftCond.L)'
#endif
#ifdef vT
        write(21, *) '#vT CONVECTIVE  Adjustment (Virtual Temperature  is computed)'
#endif
        write(21, *) '#PB CONVECTIVE  Adjustment (Peter Bechtold     2000 Set Up)  '
        write(21, *) '#pb CONVECTIVE  Adjustment (Peter Bechtold     2000 Set Up)NV'
#ifdef KE
        write(21, *) '#KE CONVECTIVE  Adjustment (Emanuel & Zivkovic 1999 Set Up)  '
#endif
#ifdef LE
        write(21, *) '#LE TURBULENCE: K  : Louis                      (1979) BLM 17'
#endif
#ifdef Kl
        write(21, *) '#Kl TURBULENCE: K-l: Therry & Lacarrere         (1983) BLM 25'
#endif
#ifdef PD
        write(21, *) '#PD TURBULENCE: K-e: Original Duynkerke         (1988) JAS 45'
#endif
        write(21, *) '#TA TURBULENCE: K-e: Dissipation + Advect.Horiz.TKE Transport'
        write(21, *) '#TD TURBULENCE: K-e: Dissipation + Diffus.Horiz.TKE Transport'
#ifdef AV
        write(21, *) '#AV TURBULENCE: K-e: Buoyancy includes      Aerosol Loading  '
#endif
#ifdef HR
        write(21, *) '#HR TURBULENCE: K-e: Huang & Raman              (1991) BLM 55'
#endif
#ifdef KI
        write(21, *) '#KI TURBULENCE: K-e: Kitada                     (1987) BLM 41'
#endif
#ifdef BH
        write(21, *) '#BH TURBULENCE: K-e: Kitada (modified)           USE with #KI'
#endif
#ifdef KC
        write(21, *) '#KC TURBULENCE: T.K.E.(mz1) := T.K.E.(mz)                    '
#endif
        write(21, *) '#KA TURBULENCE: T.K.E. & e(T.K.E.) Filter along the vertical '
#ifdef AM
        write(21, *) '#AM TURBULENCE: u*   Time Mean (BOX Moving Average)          '
#endif
#ifdef AT
        write(21, *) '#AT TURBULENCE: u*T* Time Mean (BOX Moving Average)          '
#endif
#ifdef AS
        write(21, *) '#AS TURBULENCE: u*s* Time Mean (BOX Moving Average)          '
#endif
#ifdef VX
        write(21, *) '#VX TURBULENCE: u*q* limited to SBL Saturat. Specif. Humidity'
#endif
#ifdef De
        write(21, *) '#De TURBULENCE: Top BC: Dirichlet (fixed) (ect_TE and eps_TE)'
#endif
#ifdef WE
        write(21, *) '#WE TURBULENCE: T.K.E. OUTPUT on File MAR.TKE                '
#endif
#ifdef AE
        write(21, *) '#AE TURBULENCE: Aerosols Erosion / Turbulent Diffusion Coeff.'
#endif
        write(21, *) '#SY TURBULENCE: Sea Spray Parameterization (Andreas, 199x) ON'
#ifdef DU
        write(21, *) '#DU SBL: Univ.Funct.:    Duynkerke(1991)                     '
#endif
#ifdef BU
        write(21, *) '#BU SBL: Univ.Funct.:    Businger (1973)  USE with _NO OR #NO'
#endif
#ifdef _NO
        write(21, *) '_NO SBL: Univ.Funct.: NO Noilhan  (1987)  USE with #BU OR #DR'
#endif
#ifdef NO
        write(21, *) '#NO SBL: Univ.Funct.:    Noilhan  (1987)  USE with #BU       '
#endif
#ifdef DR
        write(21, *) '#DR SBL: Univ.Funct.:    Dyer     (1974)  USE with _NO       '
#endif
#ifdef LP
        write(21, *) '#LP SBL: Blowing Snow Fric. Veloc. Thr. (Li and Pomeroy 1997)'
#endif
#ifdef DS
        write(21, *) '#DS SBL: Blowing Snow SBL   Flux   (analytical Form of dq/dz)'
#endif
        write(21, *) '#ZS SBL: Mom.: Roughn.Length= F(u*) Chamberlain (1983),  Sea '
#ifdef ZN
        write(21, *) '#ZN SBL: Mom.: Roughn.Length= F(u*) Shao  & Lin (1999), Snow '
#endif
#ifdef ZA
        write(21, *) '#ZA SBL: Mom.: Roughn.Length= F(u*) Andreas &al.(2004), Snow '
#endif
#ifdef RN
        write(21, *) '#RN SBL: Heat: Roughn.Length= F(u*,z0)  Andreas (1987)       '
#endif
        write(21, *) '#ZM SBL: M/H   Roughn.Length: Box Moving Average (in Time)   '
#ifdef OR
        write(21, *) '#OR SBL: Orography Roughness included from SL_z0 in MARdom   '
#endif
#ifdef SB
        write(21, *) '#SB Surface Boundary: modified externally (from Campain Data)'
#endif
        write(21, *) '#TI Turbul. Heat Surface Flux: Implicit numerical Scheme     '
        write(21, *) '#QE Turbul. H2O  Surface Flux: Explicit numerical Scheme     '
        write(21, *) '#FI Turbul. Mom. Surface Flux: Implicit numerical Scheme     '
#ifdef BI
        write(21, *) '#BI Blowing Snow Surface Flux: Implicit numerical Scheme     '
#endif
#ifdef OL
        write(21, *) '#OL TEST:      Linear Mountain Wave: Specific IO    (2D ONLY)'
#endif
#ifdef OM
        write(21, *) '#OM TEST: (Non)Linear Mountain Wave: Specific INPUT (2D ONLY)'
#endif
#ifdef OS
        write(21, *) '#OS TEST:      Linear Mountain Wave: Specific IO    (2D ONLY)'
#endif
#ifdef K1
        write(21, *) '#K1 TEST: LBC: Katab. Atmos.Warming                 (1D ONLY)'
#endif
#ifdef EK
        write(21, *) '#EK TEST: EKMAN Spiral: Constant Vertical Turbul. Coefficient'
#endif
#ifdef CL
        write(21, *) '#CL TEST: Convective Mixed Layer Test         (HS = 100 W/m2)'
#endif
#ifdef NL
        write(21, *) '#NL TEST: Nearly   Neutral Layer Test         (HS =   0 W/m2)'
#endif
#ifdef TC
        write(21, *) '#TC TraCer   Advection-Diffusion Equation        is turned ON'
#endif
#ifdef tc
        write(21, *) '#tc TraCer   Filtering is  not vectorized                    '
#endif
#ifdef TO
        write(21, *) '#TO TraCer   Open Lateral Boundary Conditions on digit.Filter'
#endif
#ifdef TS
        write(21, *) '#TS TraCer   Tracer Deposition diagnostic        is turned ON'
#endif
#ifdef BD
        write(21, *) '#BD TraCer   Aeolian Erosion  Submodel           is turned ON'
#endif
#ifdef DV
        write(21, *) '#DV TraCer   Aeolian Erosion  Submodel: Air Loading by Dust  '
#endif
#ifdef CH
        write(21, *) '#CH Chemical Atmospheric         Model       may be turned ON'
#endif
#ifdef MV
        write(21, *) '#MV TraCer   Total Mass          Verification    is turned ON'
#endif
        write(21, *) '#HY Explicit Cloud MICROPHYSICS              may be turned ON'
        write(21, *) '#hy Explicit Cloud MICROPHYSICS: NO Vectorisation Optmization'
#ifdef HM
        write(21, *) '#HM Explicit Cloud MICROPHYSICS: Hallett-Mossop Ice Multipl. '
#endif
#ifdef hm
        write(21, *) '#hm Explicit Cloud MICROPHYSICS: Hallett-Mossop Ice Mult.  NV'
#endif
#ifdef LI
        write(21, *) '#LI Explicit Cloud MICROPHYSICS: Lin et al. (1983) Autoconv. '
#endif
#ifdef BS
        write(21, *) '#BS Explicit Cloud MICROPHYSICS: Blow. *(Snow)         Model '
#endif
        write(21, *) '#HV Explicit Cloud MICROPHYSICS: Air Loading by Hydrometeors '
#ifdef BV
        write(21, *) '#BV Explicit Cloud MICROPHYSICS: SBL Loading by all Water Sp.'
#endif
#ifdef bv
        write(21, *) '#bv Explicit Cloud MICROPHYSICS: SBL Loading not vectorized  '
#endif
#ifdef SS
        write(21, *) '#SS Explicit Cloud MICROPHYSICS: Blow. *(Snow)  Linear Model '
#endif
#ifdef S0
        write(21, *) '#S0 Explicit Cloud MICROPHYSICS: Blow. *(Byrd)  Linear Model '
#endif
#ifdef EM
        write(21, *) '#EM Explicit Cloud MICROPHYSICS: de Montmollin Parameterizat.'
#endif
#ifdef BW
        write(21, *) '#BW Explicit Cloud MICROPHYSICS: Blowing Snow Statistics     '
#endif
#ifdef b2
        write(21, *) '#b2 Explicit Cloud MICROPHYSICS: Blowing Snow Statistics (II)'
#endif
#ifdef EV
        write(21, *) '#EV Explicit Cloud MICROPHYSICS: Snow Erosion Statistics     '
#endif
        write(21, *) '#HW Explicit Cloud MICROPHYSICS: OUTPUT of qr,qs, qw,qi on NC'
#ifdef EW
        write(21, *) '#EW Explicit Cloud MICROPHYSICS: OUTPUT (Ener./Mass) (Unit 6)'
#endif
#ifdef WH
        write(21, *) '#WH Explicit Cloud MICROPHYSICS: OUTPUT              (Unit 6)'
#endif
#ifdef WQ
        write(21, *) '#WQ Explicit Cloud MICROPHYSICS: OUTPUT (Full Verif) (Unit 6)'
#endif
#ifdef WB
        write(21, *) '#WB Explicit Cloud MICROPHYSICS: Water Conservation Controled'
#endif
#ifdef WW
        write(21, *) '#WW Explicit Cloud MICROPHYSICS: Water Conservation Summary  '
#endif
#ifdef ww
        write(21, *) '#WW Explicit Cloud MICROPHYSICS: Water Conservation Summary +'
#endif
#ifdef WF
        write(21, *) '#WF Explicit Cloud MICROPHYSICS: Water Conservation is Forced'
#endif
#ifdef HO
        write(21, *) '#HO Explicit Cloud MICROPHYSICS: Zero-Gradient Lat.Bound.Cond'
#endif
#ifdef MR
        write(21, *) '#MR PHYSICS: MARrad: Solar/Infrared     (Laurent LI set up)  '
#endif
#ifdef AZ
        write(21, *) '#AZ PHYSICS: Solar : Direct Radiation:   Surface Slope Impact'
#endif
#ifdef MM
        write(21, *) '#MM PHYSICS: Solar : Direct Radiation:   Mountains Mask    ON'
#endif
#ifdef TR
        write(21, *) '#TR PHYSICS: Solarn: Clear Sky, without Underlying Reflection'
#endif
        write(21, *) '#EE PHYSICS: radCEP: ECMWF   routine    (cfr. JJ Morcrette)  '
#ifdef LL
        write(21, *) '#LL PHYSICS: radLMD: radlwsw routine    (Laurent LI set up)  '
#endif
#ifdef ll
        write(21, *) '#ll PHYSICS: radLMD: radlwsw routine    (Laurent LI set up)NV'
#endif
#ifdef AR
        write(21, *) '#AR PHYSICS: radLMD: radlwsw routine Interactive Terr.Aerosol'
#endif
#ifdef WL
        write(21, *) '#WL PHYSICS: radLMD: radlwsw routine IO (Laurent LI set up)  '
#endif
#ifdef SA
        write(21, *) '#SA PHYSICS: MAR Code behaves  as a Stand Alone Surface Model'
#endif
#ifdef FR
        write(21, *) '#FR Surface Model: Force Restore (Deardorff) at least   is ON'
#endif
#ifdef WG
        write(21, *) '#WG Soil Humidity: Force Restore (Deardorff) may be turned ON'
#endif
#ifdef AO
        write(21, *) '#AO COUPLING with  NEMO  Ocean-Sea-Ice Model using OASIS     '
#endif
#ifdef PO
        write(21, *) '#PO POLYNYA Model                            may be turned ON'
#endif
#ifdef FD
        write(21, *) '#FD POLYNYA Model: Sea-Ice Velocity is Free Drift            '
#endif
#ifdef HA
        write(21, *) '#HA POLYNYA Model: POLYNYA Surface Energy Balance:  2000 W/m2'
#endif
#ifdef HI
        write(21, *) '#HI POLYNYA Model: Hibler (1979) Parameteriz. of Ice Strength'
#endif
#ifdef CN
        write(21, *) '#CN POLYNYA Model: Prescription of a Local Avective Time Step'
#endif
#ifdef ST
        write(21, *) '#ST EVOLUTIVE SST (Sea Surface Temperature/Swab Ocean)       '
#endif
        write(21, *) '#SN SNOW Model                               may be turned ON'
#ifdef AB
        write(21, *) '#AB SNOW Model: Interactive Albedo f(Grain) (Brun et al.1991)'
#endif
#ifdef AG
        write(21, *) '#AG SNOW Model: Snow Aging Col de Porte     (Brun et al.1991)'
#endif
        write(21, *) '#CZ SNOW Model: Zenithal Angle Correction  (Segal et al.1991)'
#ifdef DG
        write(21, *) '#DG SNOW Model: Snow Settling when Melting | Minimum Density '
#endif
#ifdef Se
        write(21, *) '#Se SNOW Model: Energy Conserv. Verific.: Summary, Output    '
#endif
#ifdef SE
        write(21, *) '#SE SNOW Model: Energy Conserv. Verific.: Summary, Output+   '
#endif
#ifdef SF
        write(21, *) '#SF SNOW Model: Energy Conserv. Verific.: Forcing, Conduction'
#endif
#ifdef SW
        write(21, *) '#SW SNOW Model: Water  Conserv. Verific.: Melting, Freezing  '
#endif
#ifdef HS
        write(21, *) '#HS SNOW Model: Hardened SNOW Pack Initialization            '
#endif
#ifdef MA
        write(21, *) '#MA SNOW Model: Increased polar B* Mobility (Mann et al.2000)'
#endif
#ifdef NP
        write(21, *) '#NP SNOW Model: Fallen Snow Density = f(V)  (Kotlyakov, 1961)'
#endif
        write(21, *) '#SD SNOW Model: Antarct.,Fallen Snow Density (NP must be OFF)'
#ifdef RU
        write(21, *) '#RU SNOW Model: Slush:  Internal Run OFF of Water Excess     '
#endif
#ifdef GK
        write(21, *) '#GK SNOW Model: Interactive Albedo (Greuell &Konzelmann 1994)'
#endif
#ifdef SL
        write(21, *) '#SL SNOW Model: Interactive Albedo (Zuo     &Oerlemans  1995)'
#endif
#ifdef SM
        write(21, *) '#SM SNOW Model: Melting/Freezing Diagnostics                 '
#endif
#ifdef SZ
        write(21, *) '#SZ SNOW Model: Z0 Dependance on varying Sastrugi Height     '
#endif
#ifdef TZ
        write(21, *) '#TZ SNOW Model: Z0 (Momentum) (typical value in polar models)'
#endif
#ifdef CP
        write(21, *) '#CP SNOW Model: For Validation on Col de Porte Data          '
#endif
#ifdef GL
        write(21, *) '#GL SNOW Model: ETH-Camp & Greenland 3D simulations          '
#endif
#ifdef PP
        write(21, *) '#PP PROJECTION: Polar Stereographic Projection               '
#endif
        write(21, *) '#TV Soil /Vegetation Variables                  are used     '
#ifdef GP
        write(21, *) '#GP Soil /Vegetation Model: LAI, GLF Variations NOT prescrib.'
#endif
#ifdef LN
        write(21, *) '#LN Soil /Vegetation Model: LAI(x,y,t) prescribed(MARglf.DAT)'
#endif
#ifdef SV
        write(21, *) '#SV Soil /Vegetation Model (Koen De Ridder)  may be turned ON'
#endif
#ifdef SH
        write(21, *) '#SH Soil /Vegetation Model: Hapex-Sahel   Vegetation     DATA'
#endif
#ifdef V1
        write(21, *) '#V1 Soil /Vegetation Model: (KD) Vegetat. IGBP Classification'
#endif
#ifdef V2
        write(21, *) '#V2 Soil /Vegetation Model: (KD) Vegetat. MAR  Classification'
#endif
#ifdef GA
        write(21, *) '#GA SISVAT: Soil Humidity Geometric Average at Layer Interfac'
#endif
#ifdef GF
        write(21, *) '#GF SISVAT: Gravitational Saturation Front          turned ON'
#endif
#ifdef GH
        write(21, *) '#GH SISVAT: Gravitational Saturation Front - Horton turned ON'
#endif
#ifdef OP
        write(21, *) '#OP SISVAT: Interactive Sea Surface Temperature     turned ON'
#endif
#ifdef op
        write(21, *) '#op SISVAT: SST Nudging -->   prescribed values     turned ON'
#endif
        write(21, *) '#IP SISVAT: Sea-Ice Fraction prescribed from SMMR and SSM/I  '
        write(21, *) '#SI SISVAT: Sea-Ice Fraction calculated from prescribed SST  '
#ifdef IA
        write(21, *) '#IA SISVAT: Sea-Ice Bottom   accretion  and  ocean cooling   '
#endif
#ifdef MT
        write(21, *) '#MT SISVAT: Monin-Obukhov Theory is linearized (Garrat schem)'
#endif
#ifdef SR
        write(21, *) '#SR SISVAT: traces & OUTPUT a variable among called routines '
#endif
#ifdef WV
        write(21, *) '#WV SISVAT: performs OUTPUT on an ASCII File (1 file each pt)'
#endif
        write(21, *) '#sa SISVAT: must be pre-processed, except for stand-alone run'
#ifdef CS
        write(21, *) '#CS  INPUT: Constant Sounding during 1st Hours     (2-D ONLY)'
#endif
        write(21, *) '#IB OUTPUT: Ice-Sheet Surface Mass Balance  (on MARphy File )'
        write(21, *) '#ID OUTPUT: Main Dependant Variables        (on NetCDF File )'
        write(21, *) '#UL OUTPUT: Time Dimension is UNLIMITED     (on NetCDF File )'
#ifdef T2
        write(21, *) '#T2 OUTPUT: 2-m  Air Temperature            (on NetCDF File )'
#endif
#ifdef W6
        write(21, *) '#W6 OUTPUT, Additional: Simulation Statistics      on MAR.log'
#endif
#ifdef w6
        write(21, *) '#w6 OUTPUT, Additional: Simulation Statistics (NH) on MAR.log'
#endif
#ifdef WA
        write(21, *) '#WA OUTPUT, Additional:                            DYNadv_ver'
#endif
#ifdef WR
        write(21, *) '#WR OUTPUT, Additional: INIsnd, infra, SRFmod_sno, SRFmod_pol'
#endif
        write(21, *) '#vL PORTABILITY: Vectorization enhanced                      '
        write(21, *) '#vN PORTABILITY: Vectorization enhanced: Leap Frog Counter   '
        write(21, *) '#vK PORTABILITY: Vectorization enhanced: TKE                 '
        write(21, *) '#vH PORTABILITY: Vectorization enhanced: Hydrological Cycle  '
#ifdef vB
        write(21, *) '#vB PORTABILITY: Vectorization enhanced: Blowing  Snow *     '
#endif
#ifdef vD
        write(21, *) '#vD PORTABILITY: Vectorization enhanced: Blowing  Dust .     '
#endif
#ifdef vR
        write(21, *) '#vR PORTABILITY: Vectorization enhanced: Sastrugi Height     '
#endif
        write(21, *) '#vS PORTABILITY: Vectorization enhanced: Snow     Model      '
        write(21, *) '#vV PORTABILITY: Vectorization enhanced: SVAT                '
        write(21, *) '#vZ PORTABILITY: Vectorization enhanced: Av.Roughness Length '
        write(21, *) '#HP PORTABILITY: Enables use of own    library on Linux Syst.'
        write(21, *) '#NV PORTABILITY: Vectorization  is     turned  OFF           '
#ifdef iso
        write(21, *) '#iso Tracers: Water isotopes                                 '
#endif
        write(21, 602) &
            reaVAR, swich(-zext(reaVAR)), reaLBC, swich(-zext(reaLBC)), &
            safVAR, swich(-zext(safVAR)), hamfil, swich(-zext(hamfil))
602     format(//, ' OPTIONS', /, ' +++++++', /, &
                /, '  reaVAR=', l2, 4x, ' => Input: Prev.Dyn.Sim.(MAR/GCM) ', a3, &
                /, '  reaLBC=', l2, 4x, ' => LBC:   Prev.Dyn.Sim.(MAR/GCM) ', a3, &
                /, '  safVAR=', l2, 4x, ' => Saving    on Files MARxxx.DAT ', a3, &
                /, '  hamfil=', l2, 4x, ' => Diabatic Initialisation       ', a3)
#ifdef HF
        if(hamfil) write(21, 603) hham, nham, hhac, thac
603     format( &
            '  Hamming Filter Characteristics:', &
            /, '   Time       =', f11.4, '=> N(Hamming)= ', i12, &
            /, '   Cutoff     =', f11.4, '=> Frequency = ', f12.4, /, 1x)
#endif
        rhcrit = 0.0
        tstart = 0.0
        rhcrit = rhcrHY
        tstart = tim_HY
        write(21, 604) &
            conmas, swich(-zext(conmas)), potvor, swich(-zext(potvor)), &
            brocam, swich(-zext(brocam)), turhor, swich(-zext(turhor)), &
            convec, swich(-zext(convec)), &
            micphy, swich(-zext(micphy)), 1.d+2 * rhcrit, tstart, &
            fracld, swich(-zext(fracld)), &
            chimod, swich(-zext(chimod)), &
            physic, swich(-zext(physic)), &
            snomod, swich(-zext(snomod)), polmod, swich(-zext(polmod)), fxlead, &
            vegmod, swich(-zext(vegmod)), qsolSL, swich(-zext(qsolSL)), &
            rxbase, rxfact
604     format( &
            '  conmas=', l2, 4x, ' => Mass  Conservation Constraint ', a3, &
            /, '  potvor=', l2, 4x, ' => PV    Conservation Constraint ', a3, &
            /, '  brocam=', l2, 4x, ' => Brown and Campana Time Scheme ', a3, &
            /, '  turhor=', l2, 4x, ' => Horizontal Diffusion          ', a3, &
            /, '  convec=', l2, 4x, ' => Mass Flux convective Scheme   ', a3, &
            /, '  micphy=', l2, 4x, ' => Cloud Microphysics            ', a3, &
            /, '  rhcrHY=', f6.0, ' %  Critical Relative Humidity Value  ', &
            /, '  tim_HY=', f6.0, '    Cloud Microphysics Starting Time  ', &
            /, '  fracld=', l2, 4x, ' => Fractional Cloudiness Scheme  ', a3, &
            /, '  chimod=', l2, 4x, ' => Chemical Atmospheric  Model   ', a3, &
            /, '  physic=', l2, 4x, ' => Atmosphere / Surface  Physics ', a3, &
            /, '  snomod=', l2, 4x, ' => Interactive Snow      Model   ', a3, &
            /, '  polmod=', l2, 4x, ' => Interactive Polynya   Model   ', a3, &
            /, '  fxlead=', f5.2, '     Initial Minimal Lead   Fraction    ', &
            /, '  vegmod=', l2, 4x, ' => Interactive SVAT      Model   ', a3, &
            /, '  qsolSL=', l2, 4x, ' => Soil Humidity         Model   ', a3, &
            /, '  rxbase=', f6.3, '    Nudging Coeff.(Anthes et al. 1989)', &
            /, '  rxfact=', f6.1, '    Lateral Sponge Coefficient   (A89)')
        write(21, 605) dx, mx, dy, my, &
            dt, dtfast, ntFast, &
            center, nordps, staggr, &
            dtRadi, jtRadi, ntRadi, &
            dtPhys, jtPhys, ntPhys, &
            dtDiff, jtDiff, ntDiff, &
            FIslot, FIkhmn, TUkhff, TUkhmx, FIslou, FIslop
605     format(//, ' MAR DISCRETISATION', /, ' ++++++++++++++++++', &
                //, '  dx         =', f8.1, ' m   /  Nb Points : ', i12, &
                /, '  dy         =', f8.1, ' m   /  Nb Points : ', i12, &
                /, '  dt         =', f8.1, ' sec', &
                /, '  dt Lamb    =', f8.1, ' sec', &
                /, '  nt Lamb    =', i6, &
                /, '  p* Discret.=', l6, 5x, '  /  p* Precis.= ', i12, &
                /, '  Vert.Stagg.=', l6, &
                //, '  dt Sol./IR =', f8.1, ' sec => jt Sol./IR= ', i12, &
                /, '                              nt Sol./IR= ', i12, &
                //, '  dt Surface =', f8.1, ' sec => jt Surface= ', i12, &
                /, '                              nt Surface= ', i12, &
                /, ' CAUTION: := dt', &
                //, '  dt Turbul. =', f8.1, ' sec => jt Turbul.= ', i12, &
                /, '                           /  nt Turbul.= ', i12, &
                /, ' CAUTION: := dt', &
                //, '  delta T    =', f11.4, '  => Kh(delta) = ', e12.4, &
                /, '              ', 11x, '  -- fac. (Kh) = ', f12.4, &
                /, '  Absorbing Layer          -> Kh max    = ', e12.4, &
                /, '  delta u    =', f11.4, &
                /, '  delta p    =', f11.4)
    endif
    ! +
    ! +--WARNINGS
    ! +  ========
    ! +
    ! +--Time Step
    ! +  ---------
    ! +
    !     if (abs(dt-dtdom) > epsi) write(6,2) dt,dtdom
    !2    format(/,' ***********************************',
    !    .          '********************************',
    !    .       /,' * CAUTION: dt(MARctr.dat)=',f8.2,'s',
    !    .          '  /=  dt(MARdom.dat)=',f8.2,'s *',
    !    .       /,' ***********************************',
    !    .          '********************************',/,1x)
    ! +
    ! +
    ! +--Topography
    ! +  ----------
    ! +
    lo_CAU = 0
    if(n7mxLB > 1) then
        do j = 1, my
            do i = 1, n7mxLB - 1
                if(abs(sh(i, j) - sh(ip1(i), j)) > epsi) lo_CAU = 1
            enddo
        enddo
    endif
    ! +
    if(n6mxLB > 0) then
        do j = 1, my
            do i = mx - n6mxLB + 1, mx
                if(abs(sh(i, j) - sh(im1(i), j)) > epsi) lo_CAU = 1
            enddo
        enddo
    endif
    ! +
    if(n7myLB > 1) then
        do j = 1, n7myLB - 1
            do i = 1, mx
                if(abs(sh(i, j) - sh(i, jp1(j))) > epsi) lo_CAU = 1
            enddo
        enddo
    endif
    ! +
    if(n6myLB > 0) then
        do i = 1, mx
            do j = my - n6myLB + 1, my
                if(abs(sh(i, j) - sh(i, jm1(j))) > epsi) lo_CAU = 1
            enddo
        enddo
    endif
    ! +
    if(lo_CAU == 1) then
        write(6, 1)
1       format(' ******************************************************************', &
               /, ' * CAUTION: Lateral Sponge too large OR Lateral Plateau too small *', &
               /, ' ******************************************************************', /, 1x)
    endif

    ! ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    ! +++ INITIALISATION INCLUDING A SAVED STATE OF THE VARIABLES ++++++++++++++
    ! ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    if(reaVAR) then
        ! +--Timing
        ! +  ======
        iterun = 0
        ! +--Dynamics
        ! +  ========
        open(unit=11, status='old', form='unformatted', file='MARdyn.DAT')
        rewind 11

        read(11,err=9998) itexpe, jdh_LB

        go to 9999
 9998   continue
        print *, "itexpe is integer*4 in MARdyn.DAT => integer*8"
        close (11)
        open(unit=11, status='old', form='unformatted', file='MARdyn.DAT')
        rewind 11
        read(11) itexpe2,jdh_LB ; itexpe=itexpe2
 9999   continue

        ! ------------------------------------------------------------------------------------------ !
        ! +...    Time    Parameters
        read(11) iyrDYN, mmaDYN, jdaDYN, jhuDYN
        ! +--Modified Time Step (BEGIN)
        ! +  ~~~~~~~~~~~~~~~~~~~~~~~~~~
        YYtmp = -1
        MMtmp = -1
        DDtmp = -1
        dt_old = -1
        dt_new = -1
        open(unit=51, status='old', file='MARtime.ctr', err=51)
        read(51, *, err=51) YYtmp, MMtmp, DDtmp, dt_old, dt_new
51      continue
        close(51)
        if(YYtmp == iyrDYN .and. MMtmp == mmaDYN .and. &
           DDtmp == jdaDYN .and. dt_old > 0 .and. dt_new > 0) then
            write(6, *) ' '
            write(6, *) 'WARNING--WARNING--WARING--WARING--WARNING'
            write(6, *) 'itexpe modified by MARtime.ctr'
            write(6, *) 'dt_old =', dt_old
            write(6, *) 'dt_new =', dt_new
            write(6, *) 'WARNING--WARNING--WARING--WARING--WARNING'
            write(6, *) ' '
            itexpe = (itexpe * dt_old) / dt_new
        endif
        ! +--Modified Time Step   (end)
        ! +  ~~~~~~~~~~~~~~~~~~~~~~~~~~
        ! Spatial Parameters
        read(11) imezdy, jmezdy
        read(11) aladyn, alodyn
        ! Discretisation
        read(11) sigma, ptopDY, dx, dy
        ! Dynamics
        read(11) uairDY
        read(11) vairDY
        read(11) pktaDY
        read(11) pstDY
        read(11) qvDY
        read(11) sh
#ifdef GL
        ! MAR-GRISLI coupling
        call ice_sheet_model_coupling
#endif
        read(11) pstDY1
        ! Lateral Boundary Conditions
        read(11) iyr_LB, mma_LB, jda_LB, jhu_LB, jdh_LB
        read(11) vaxgLB, vaxdLB, vayiLB, vaysLB
        read(11) sst_LB
        ! Upper Sponge Reference State
        read(11) uairUB, vairUB, pktaUB
        if(jdh_LB <= 0) then
            ! write(6,6000) jdh_LB
! 6000        format(/, '##############################################', &
!                     /, '# CAUTION: previous jdh_LB =', i6, ' set:= 1 #', &
!                     /, '##############################################',/)
            jdh_LB = 1
        endif
        if(itexpe > 0) then
            read(11) pstDYn
            read(11) RAd_ir
            read(11) IRsoil
            read(11) virDY
            read(11) tim1LB, v1xgLB, v1xdLB, v1yiLB, v1ysLB
            read(11) tim2LB, v2xgLB, v2xdLB, v2yiLB, v2ysLB
            read(11) sst1LB, sst2LB
            read(11) ua1_UB, ua2_UB
            read(11) va1_UB, va2_UB
            read(11) pkt1UB, pkt2UB
            if(my == 1) then
                read(11) ugeoDY
                read(11) vgeoDY
#ifdef PV
                stop '    ?!&~@|@[#@#  PV not conserved! EMERGENCY STOP'
#endif
            endif
        endif
        close(unit=11)
#ifdef iso
        if(itexpe == 0) then
            call mariso_init_dy(iso_init_type, qvDY, qvDY_iso)
        else
            ! read isotopic composition of dynamical variables
            open(unit=11, status='old', form='unformatted', file='MARdyn_iso.DAT')
            rewind 11
            read(11) qvDY_iso
            close(unit=11)
        endif
#endif

        ! +--sigma-levels Height
        ! +  -------------------
        do k = 1, mz
            zsigma(k) = -(sst_SL / 0.0065) * ((1.e0 + (sigma(k) - 1.) &
                                               * (1.e2 / ps_sig)) &
                                              **(RDryAi * 0.0065 / gravit) - 1.)
        enddo
        if(IO_gen >= 2) then
            write(21, 130)(sigma(k), k=1, mz)
            write(21, 131)(zsigma(k), k=1, mz)
        endif

        ! +--Auxiliary Grid Parameters
        ! +  -------------------------
        ! +  ******
        call grdmar
        ! +  ******

        ! +--Geographical Coordinates
        ! +  ------------------------
        ! +  ******
        call grdgeo
        ! +  ******

        ! +--Local Time of the Model Center
        ! +  ------------------------------
        ! +  ******
        call timcur
        call timgeo
        ! +  ******

        ! +--LBC Coefficients
        ! +  ----------------
        if(itexpe == 0) then
            tim1LB = ou2sGE(iyr_LB, mma_LB, jda_LB, jhu_LB, 0, 0)
            tim2LB = tim1LB
            do iv_ini = 1, 5
                do i = 1, n7mxLB
                    do k = 1, mz
                        do j = 1, my
                            v1xgLB(i, j, k, iv_ini) = vaxgLB(i, j, k, iv_ini)
                            v2xgLB(i, j, k, iv_ini) = vaxgLB(i, j, k, iv_ini)
                        enddo
                    enddo
                enddo
                do i = mx - n6mxLB, mx
                    do k = 1, mz
                        do j = 1, my
                            v1xdLB(i, j, k, iv_ini) = vaxdLB(i, j, k, iv_ini)
                            v2xdLB(i, j, k, iv_ini) = vaxdLB(i, j, k, iv_ini)
                        enddo
                    enddo
                enddo
                do j = 1, n7myLB
                    do k = 1, mz
                        do i = 1, mx
                            v1yiLB(i, j, k, iv_ini) = vayiLB(i, j, k, iv_ini)
                            v2yiLB(i, j, k, iv_ini) = vayiLB(i, j, k, iv_ini)
                        enddo
                    enddo
                enddo
                do j = my - n6myLB, my
                    do k = 1, mz
                        do i = 1, mx
                            v1ysLB(i, j, k, iv_ini) = vaysLB(i, j, k, iv_ini)
                            v2ysLB(i, j, k, iv_ini) = vaysLB(i, j, k, iv_ini)
                        enddo
                    enddo
                enddo
            enddo
        endif

        ! +  **********
        call lbcnud_ini
        ! +  **********

        ! +  **********
        call lbcnud_par
        ! +  **********

        ! +--Soil Model
        ! +  ==========
        open(unit=11, status='old', form='unformatted', file='MARsol.DAT')
        rewind 11
        read(11) itever
        read(11) iyrSOL, mmaSOL, jdaSOL, jhuSOL
        if(itever /= itexpe .or. &
           iyrSOL /= iyrDYN .or. &
           mmaSOL /= mmaDYN .or. &
           jdaSOL /= jdaDYN .or. &
           jhuSOL /= jhuDYN) then
            write(6, 817)
817         format(' ++WARNING++ MARsol improperly specified ')
        endif
        read(11) nSLsrf
        read(11) SLsrfl
        read(11) TairSL
        read(11) tsrfSL
        read(11) alb0SL, eps0SL
        read(11) SaltSL
        read(11) ro_SL0
        read(11) ro_SL
        read(11) d1_SL
        read(11) t2_SL
        read(11) w2_SL, wg_SL
        read(11) roseSL
        read(11) qvapSL
        read(11) hsnoSL
        read(11) hmelSL
        read(11) SLuusl, SL_z0
        read(11) SLutsl, SL_r0
        if(itexpe > 0) then
            read(11) pktaSL
            read(11) sicsIB
            read(11) sic1sI, sic2sI
            read(11) albeSL
            read(11) SLuus, SLuts
            read(11) SLuqs, SLuqsl
            read(11) duusSL
            read(11) dutsSL
            read(11) cdmSL, cdhSL
            read(11) V_0aSL
            read(11) dT0aSL
#ifdef AM
            read(11) u_0aSL
#endif
#ifdef AT
            read(11) uT0aSL
#endif
#ifdef AS
            read(11) us0aSL
#endif
#ifdef VX
            read(11) WV__SL
#endif
            read(11) SLlmo, SLlmol
#ifdef BV
            read(11) virSL
#endif
        endif
        close(unit=11)
#ifdef iso
        if(itexpe == 0) then
            call mariso_init_sl(iso_init_type, qvapSL, qvapSL_iso)
        else
            ! read isotopic composition of surface air water
            open(unit=11, status='old', form='unformatted', file='MARsol_iso.DAT')
            rewind 11
            read(11) qvapSL_iso
            read(11) SLuqs_iso
            read(11) SLuqsl_iso
            close(unit=11)
        endif
#endif
        if(itexpe == 0) then
            open(unit=11, status='old', form='unformatted', file='MARsic.DAT')
            rewind 11
            read(11) iyr_sI, mma_sI, jda_sI, jhu_sI, jdh_sI
            read(11) sicsIB
            close(unit=11)
        endif
        ! +--Update of Soil Parameters
        ! +  -------------------------
        Tfr_LB = tfrwat
        do j = 1, my
            do i = 1, mx
                if(isolSL(i, j) <= 2) then
                    ! +---1. Open Water
                    ! +   ~~~~~~~~~~~~~
                    if(sst_LB(i, j) >= Tfr_LB) then
                        isolSL(i, j) = 1
                        d1_SL(i, j) = 2.09e+8
                        albeSL(i, j) = 0.10
                        eps0SL(i, j) = 0.97
                        SL_z0(i, j, 1) = zs_SL
                        SL_r0(i, j, 1) = 0.1 * zs_SL
                        ch0SL(i, j) = 0.00132
                        rsurSL(i, j) = 0.0
                    else
                        ! +---2. Sea Ice
                        ! +   ~~~~~~~~~~
                        ! (Kondo and Yamazaki, 1990, JAM 29, p.376)
                        isolSL(i, j) = 2
                        d1_SL(i, j) = 1.05e+5
                        albeSL(i, j) = 0.70
                        eps0SL(i, j) = 0.97
                        SL_z0(i, j, 1) = zn_SL
                        SL_r0(i, j, 1) = 0.1 * zn_SL
                        ch0SL(i, j) = 0.0021
                        rsurSL(i, j) = 0.0
                    endif
                endif
            enddo
        enddo

        ! +--SVAT Model
        ! +  ==========
        if(vegmod) then
            ! +       ***********
            call svasav('read')
            ! +       ***********
        endif

#ifdef AO
        ! +--Ocean Model
        ! +  ===========
        !AO_CK 20/02/2020
        ! +--cpl Get fields from oasis initialisation files
        ! +  ----------------------------------------------
        ! il_time_secs : temps depuis le debut du run (au pas de temps precedant)
        il_time_secs = 0
        ! +--read fields from NEMO at 1st time step of this run
        ! +  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        write(6, *) '     call fromcpl, itexpe =', itexpe
        write(6, *) '     call fromcpl, il_time_secs =', il_time_secs

        call fromcpl(il_time_secs, srftAO(:, :, 1), aoss, &
                     sicsAO, aogla, albAO(:, :, 2), aoalb, srftAO(:, :, 2), aotic, &
                     hicAO, aohic, hsnoAO, aohsn, UoceAO, ao_uo, VoceAO, ao_vo, &
                     UiceAO, ao_ui, ViceAO, ao_vi)
        ! +  *******
        ! tocken_AO : not to call fromcpl further at the first time step
        tocken_AO = 1

        !No need to check if fields have been updated as they came from restart files (=update)
        print *, "AO/coupling: warning on your first restart files"
        do j = 1, my
            do i = 1, mx
                ! +--NEMO temperature
                if(weightao_sst(i, j) /= 1) then
                    srftAO(i, j, 1) = min(max(srftAO(i, j, 1) / (1 - sicsAO(i, j)) &
                                              , 271.01), 300.15)
                    sst_LB(i, j) = (1.-weightao_sst(i, j)) * srftAO(i, j, 1) &
                                   + (weightAO_sst(i, j) * sst_LB(i, j))
                endif
                ! +--NEMO SIC
                if(weightao_sic(i, j) /= 1) then
                    sicsIB(i, j) = (1.-weightao_sic(i, j)) * sicsAO(i, j) &
                                   + (weightAO_sic(i, j) * sicsIB(i, j))
                endif
            enddo
        enddo

        ! +--NEMO other parameters:
        ! snow and sea ice thickness, albedo
        ! => not coupled at ini of MAR to increase MAR stability
        ! (one thing at a time) #CK
        ! SST/ Sea ice Surface temperature cf below

        ! +--Open Water Albedo
        ! +  -----------------
        if(itexpe == 0) then
            do i = 1, mx
                do j = 1, my
                    ! open water albedo prescribed at first time step
                    albAO(i, j, 1) = 0.066
                    ! clear sky value in flx_core.h90 (NEMO)
                enddo
            enddo
            ! ck not sure that is still needed
            do i = 1, mx
                do j = 1, my
                    if(sicsIB(i, j) == 0) then
                        ! where no sea ice, albedo begin with
                        ! value (taking into account solar ze cloud cover)
                        albAO(i, j, 1) = albeSL(i, j)
                    else
                        ! elsewhere, albedo ove
                        ! and albedo over ice is NEMO's albed
                        ! by sending solar zenith angle and c
                        ! so that it computes himself ocean a
                        albAO(i, j, 1) = 0.066
                    endif
                enddo
            enddo
        endif
        do j = 1, my
            do i = 1, mx
                if(isolSL(i, j) <= 2) then
                    albsSL(i, j) = albAO(i, j, 1) * (1.-sicsAO(i, j)) &
                                   + albAO(i, j, 2) * sicsAO(i, j)
                    albeSL(i, j) = albsSL(i, j)
                endif
            enddo
        enddo
        do i = 1, mx
            do j = 1, my
                if(isolSL(i, j) <= 2) then
                    maskSL(i, j) = 1  !ocean/sea-ice
                    do n = 1, 2
                        ! to be sure that they have a value => tairdy(i,j,mz)
                        if(i == 1) tsrfSL(i, j, n) = tairDY(i, j, mz)
                        if(j == 1) tsrfSL(i, j, n) = tairDY(i, j, mz)
                        if(i == mx) tsrfSL(i, j, n) = tairDY(i, j, mz)
                        if(j == my) tsrfSL(i, j, n) = tairDY(i, j, mz)
                        tsrfSL(i, j, n) = srftAO(i, j, n) * (1.-weightao_st(i, j)) &
                                          + (weightAO_st(i, j) * tsrfSL(i, j, n))

                        do isl = -nsol, 0
                            if(n == 1) then !ocean
                                ! Prescribed SST
                                TsolTV(i, j, n, 1 - isl) = tsrfSL(i, j, n)
                                SLsrfl(i, j, n) = 1.-sicsIB(i, j)
                            endif
                            if(n == 2) then
                                ! sea ice
                                ! Prescribed SST beneath Ice
                                TsolTV(i, j, n, 1 - isl) = 271.2
                                SLsrfl(i, j, n) = sicsIB(i, j)
                            endif
                        enddo
                    enddo
                else
                    ! land
                    maskSL(i, j) = 0
                endif
            enddo
        enddo
#endif
        if(itexpe > 0) then
#ifdef NH
            ! +--Non-Hydrostatic Dynamics
            ! +  ========================
            open(unit=11, status='unknown', form='unformatted', file='MARonh.DAT')
            rewind 11
            ! Time Parameters
            read(11) itever
            read(11) iyrONH, mmaONH, jdaONH, jhuONH
            if(itever /= itexpe .or. &
               iyrONH /= iyrDYN .or. &
               mmaONH /= mmaDYN .or. &
               jdaONH /= jdaDYN .or. &
               jhuONH /= jhuDYN) write(6, 810)
810         format(' ++WARNING++ MARonh improperly specified ')
            ! +...       Dynamics
            read(11) wa0_NH
            read(11) ua0_NH
            read(11) va0_NH
            read(11) wairNH
            read(11) pairNH
            close(unit=11)
#endif
            ! +--Mass Flux convective Scheme
            ! +  ===========================
            if(convec) then
                open(unit=11, status='old', form='unformatted', file='MARcva.DAT')
                rewind 11
                read(11) itever
                ! Time    Parameters
                read(11) iyrCVA, mmaCVA, jdaCVA, jhuCVA
                if(itever /= itexpe .or. &
                   iyrCVA /= iyrDYN .or. &
                   mmaCVA /= mmaDYN .or. &
                   jdaCVA /= jdaDYN .or. &
                   jhuCVA /= jhuDYN) then
                    write(6, 811)
811                 format(' ++WARNING++ MARcva improperly specified ')
                endif
                read(11) adj_CA
                read(11) int_CA
                read(11) dpktCA
                read(11) dqv_CA
                read(11) dqw_CA
                read(11) dqi_CA
                read(11) drr_CA
                read(11) dss_CA
                read(11) dsn_CA
                read(11) rainCA
                read(11) snowCA
                read(11) tau_CA
                read(11) Kstep1
                read(11) K_CbT1
                read(11) K_CbB1
                read(11) P_CH_0
                read(11) PdCH_1
                read(11) PdTa_1
                read(11) PdQa_1
                read(11) PdQw_1
                read(11) PdQi_1
                read(11) Pdrr_1
                read(11) Pdss_1
                read(11) PuMF_1
                read(11) PdMF_1
                read(11) Pfrr_1
                read(11) Pfss_1
                read(11) Pcape1
                close(unit=11)
#ifdef iso
                ! read isotopic composition of convective variables
                open(unit=11, status='old', form='unformatted', file='MARcva_iso.DAT')
                rewind 11
                read(11) dqv_CA_iso
                read(11) dqw_CA_iso
                read(11) dqi_CA_iso
                read(11) drr_CA_iso
                read(11) dss_CA_iso
                read(11) dsn_CA_iso
                read(11) rainCA_iso
                read(11) snowCA_iso
                close(unit=11)
#endif
            endif

            ! +--Microphysics
            ! +  ============
            if(micphy) then
                open(unit=11, status='old', form='unformatted', file='MARcld.DAT')
                rewind 11
                read(11) itever
                read(11) iyrHYD, mmaHYD, jdaHYD, jhuHYD
                if(itever /= itexpe .or. &
                   iyrHYD /= iyrDYN .or. &
                   mmaHYD /= mmaDYN .or. &
                   jdaHYD /= jdaDYN .or. &
                   jhuHYD /= jhuDYN) write(6, 812)
812             format(' ++WARNING++ MARcld improperly specified ')
                ! +
                read(11) turnHY
                read(11) ccniHY
                read(11) qiHY
                read(11) qsHY
                ! +HG read(11) qgHY
                read(11) qwHY
                read(11) qrHY
                read(11) rainHY, rai0HY
                read(11) snowHY, sno0HY, sfa0HY
                read(11) crysHY
                read(11) rainCA
#ifdef BS
                read(11) uss_HY
#endif
                close(unit=11)
#ifdef iso
                ! read isotopic composition of microphysics water
                open(unit=11, status='old', form='unformatted', file='MARcld_iso.DAT')
                rewind 11
                read(11) qiHY_iso
                read(11) qsHY_iso
                read(11) qwHY_iso
                read(11) qrHY_iso
                read(11) rainHY_iso, rai0HY_iso
                read(11) snowHY_iso, sno0HY_iso, sfa0HY_iso
                read(11) crysHY_iso
                ! rainCA_iso already in 'MARcva_iso.DAT'
                ! read(11) rainCA_iso
                close(unit=11)
#endif
            endif
#ifdef TC
            ! +--Atmospheric Tracers
            ! +  ===================
            open(unit=11, status='old', form='unformatted', file='MARtca.DAT')
            rewind 11
            read(11) itever
            read(11) iyrTCA, mmaTCA, jdaTCA, jhuTCA
            read(11) dt_ODE, dt2ODE, nt_ODE, jt_ODE
            if(itever /= itexpe .or. &
               iyrTCA /= iyrDYN .or. &
               mmaTCA /= mmaDYN .or. &
               jdaTCA /= jdaDYN .or. &
               jhuTCA /= jhuDYN) write(6, 813)
813         format(' ++WARNING++ MARtca improperly specified ')
            read(11) qxTC
            read(11) qsTC
            read(11) uqTC
            close(unit=11)
#endif
#ifdef PO
            ! +--Polynya Model
            ! +  =============
            if(polmod) then
                open(unit=11, status='old', form='unformatted', file='MARpol.DAT')
                rewind 11
                read(11) itever
                read(11) iyrPOL, mmaPOL, jdaPOL, jhuPOL
                if(itever /= itexpe .or. &
                   iyrPOL /= iyrDYN .or. &
                   mmaPOL /= mmaDYN .or. &
                   jdaPOL /= jdaDYN .or. &
                   jhuPOL /= jhuDYN) then
                    write(6, 814)
814                 format(' ++WARNING++ MARpol improperly specified ')
                endif
                read(11) isolSL
                read(11) iPO1, iPO2, jPO1, jPO2, iPO3, iPO4, jPO3, jPO4
                read(11) hfraPO, vgriPO, uocnPO, vocnPO, swsaPO, focnPO
                read(11) silfPO, hicePO, aicePO, uicePO, vicePO, dtPO
                close(unit=11)
            endif
#endif
            ! +--Turbulence
            ! +  ==========
            open(unit=11, status='old', form='unformatted', file='MARtur.DAT')
            rewind 11
            read(11) itever
            read(11) iyrTUR, mmaTUR, jdaTUR, jhuTUR
            if(itever /= itexpe .or. &
               iyrTUR /= iyrDYN .or. &
               mmaTUR /= mmaDYN .or. &
               jdaTUR /= jdaDYN .or. &
               jhuTUR /= jhuDYN) then
                write(6, 816)
816             format(' ++WARNING++ MARtur improperly specified ')
            endif
            ! TURBULENT KINETIC ENERGY (TKE) and DISSIPATION (e)
            read(11) ect_TE
            read(11) eps_TE
            read(11) tranTE
            ! TURBULENT DifFUSION COEFFICIENT
            read(11) TUkvm
            read(11) TUkvh
            close(unit=11)
        else
            ! +--Timing
            ! +  ======
            itexpe = 0
            iterun = 0
            ! +--Atmosphere
            ! +  ==========
            ! +
            do j = 1, my
                do i = 1, mx
                    pstDYn(i, j) = pstDY(i, j)
                enddo
            enddo
            ! +  *********
            call dyngpo_mp
            ! +  *********
            ! +--Microphysics and Surface
            ! +  ========================
            ! +  ******
            call iniphy
            ! +  ******
            ! +--Water Vapor and Precipitation Loading
            ! +  -------------------------------------
            ! +  ******
            call dynloa
            ! +  ******
            ! +--Surface Albedo (set to underlaying Soil Albedo)
            ! +  --------------
            do j = 1, my
                do i = 1, mx
                    alb0SL(i, j) = max(albsSL(i, j), alb0SL(i, j))
                    albeSL(i, j) = max(albsSL(i, j), albeSL(i, j))
                enddo
            enddo
        endif
    else
        ! ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        ! +++ INITIALISATION INCLUDING A SOUNDING ++++++++++++++++++++++++++++++++++
        ! ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        ! CAaiso : no isotope for sounding
        ! +--Timing
        ! +  ======
        itexpe = 0
        iterun = 0
        ! +--Dynamics
        ! +  ========
        ! +--Vertical  Grid Initialisation
        ! +  -----------------------------
        ! +                   ******
        if(.not. geoNST) call grdsig(zmin_0, aavu_0, bbvu_0, ccvu_0, verti0)
        ! +                   ******
        ! +
        ! +--Auxiliary Grid Parameters
        ! +  -------------------------
        ! +  ******
        call grdmar
        ! +  ******
        ! +
        ! +--Geographical Coordinates
        ! +  ------------------------
        ! +  ******
        call grdgeo
        ! +  ******
        ! +
        ! +--Local Time of the Model Center
        ! +  ------------------------------
        ! +  ******
        call timcur
        call timgeo
        ! +  ******
        ! +
        ! +--Initialisation assuming horizontal Homogeneity
        ! +  ----------------------------------------------
        ! +  ******
        call inisnd
        ! +  ******
        ! +
        ! +  **********
        call lbcnud_ini
        ! +  **********
        ! +
        ! +  **********
        call lbcnud_par
        ! +  **********
        ! +
        ! +--Leapfrog Auxiliary Variables
        ! +  ============================
        do j = 1, my
            do i = 1, mx
                pstDYn(i, j) = pstDY(i, j)
            enddo
        enddo
        ! +
        ! +--Microphysics and Surface
        ! +  ========================
        ! +  ******
        call iniphy
        ! +  ******
        ! +
        ! +--Water Vapor and Precipitation Loading
        ! +  -------------------------------------
        ! +  ******
        call dynloa
        ! +  ******
        ! +
        ! +--Surface Albedo (set to underlaying Soil Albedo)
        ! +  --------------
        do j = 1, my
            do i = 1, mx
                alb0SL(i, j) = max(albsSL(i, j), alb0SL(i, j))
                albeSL(i, j) = max(albsSL(i, j), albeSL(i, j))
            enddo
        enddo
    endif
    ! +
    ! +
    ! ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    ! +++ AUXILIARY VARIABLES INITIALISATION +++++++++++++++++++++++++++++++++++
    ! ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    ! +
    ! +
    ! +--Parameters
    ! +  ==========
    ! +
    ipri = 0
    ! +... print parameter used in Model  Validation
    ! +                         on Linear Mountain Waves Simulations
    ! +
    ! +--Atmospheric variables
    ! +  =====================
    ! +
    ! +
    ! +--Leapfrog Auxiliary Variables
    ! +  ----------------------------
    ! +
    do k = 1, mz
        do j = 1, my
            do i = 1, mx
                ubefDY(i, j, k) = uairDY(i, j, k)
                vbefDY(i, j, k) = vairDY(i, j, k)
            enddo
        enddo
    enddo
    ! +
    ! +
    ! +--Surface Geopotential
    ! +  --------------------
    ! +
    do j = 1, my
        do i = 1, mx
            gplvDY(i, j, mzz) = gravit * sh(i, j)
        enddo
    enddo
    ! +
    ! +
    ! +--Exner Potential, Temperature and Level Geopotential
    ! +  ---------------------------------------------------
    ! +
    ! +  *********
    call dyngpo_mp
    ! +  *********
    ! +
    ! +--Mid-Level Geopotential
    ! +  ----------------------
    ! +
    k = 1
    do j = 1, my
        do i = 1, mx
            gpmiDY(i, j, k) = 0.5 * (3.5 * gplvDY(i, j, 1) - 0.5d0 * gplvDY(i, j, 2))
        enddo
    enddo
    ! +
    do k = kp1(1), mzz
        do j = 1, my
            do i = 1, mx
                gpmiDY(i, j, k) = 0.5 * (gplvDY(i, j, k - 1) + gplvDY(i, j, k))
            enddo
        enddo
    enddo
    ! +
    k = mzz
    do j = 1, my
        do i = 1, mx
            gpmiDY(i, j, k) = (0.5 * z__SBL + sh(i, j)) * gravit
        enddo
    enddo
    ! +--Vertical Temperature Gradient at Sponge Base
    ! +  --------------------------------------------
    ! +
    gradTz = 1.0e+3 * grvinv
    if(mzabso > 1) then
        mzabs1 = max(mzabso - 1, 1)
        do j = 1, my
            do i = 1, mx
                gradTz = min(gradTz,(tairDY(i, j, mzabs1) - tairDY(i, j, mzabso)) &
                             / (epsi + gplvDY(i, j, mzabs1) - gplvDY(i, j, mzabso)))
            enddo
        enddo
    endif
    gradTz = gradTz * gravit * 1.0d+3
#ifdef OL
    ! +--Sigma Surfaces Initial Altitudes for Linear Mountain Wave Experiments
    ! +  ---------------------------------------------------------------------
    ! +
    do k = 1, mz
        do j = 1, my
            do i = 1, mx
                gp00OL(i, j, k) = gplvDY(i, j, k)
            enddo
        enddo
    enddo
#endif
#ifdef PE
    ! +--Slopes of the Sigma Surfaces
    ! +  ----------------------------
    ! +
    ! +  ******
    ! _PE call INIpen
    ! +  ******
    ! +
    ! CAa : subroutine INIpen not found
    ! +    ******
    ! call INIpen
    ! +    ******
    ! +
    ! +
#endif
#ifdef Di
    ! +--Top / Bottom Boundaries
    ! +  -----------------------
    ! +
    ! do j=1,my
    ! do i=1,mx
    !   qvtoDI(i,j) =   qvDY(i,j,1)
    !   pkttDI(i,j) = pktaDY(i,j,1)
    !   uairDI(i,j) = uairDY(i,j,1)
    !   vairDI(i,j) = vairDY(i,j,1)
    ! end do
    ! end do
#endif
    ! +
    ! +
    ! +--Specific Mass
    ! +  -------------
    ! +  ******
    call dynrho
    ! +  ******
    ! +
    ! +--Surface Variables
    ! +  =================
    ! +
    ! +--Land-Sea Mask
    ! +  -------------
    do j = 1, my
        do i = 1, mx
            if(isolSL(i, j) <= 2) then
                maskSL(i, j) = 1
            else
                maskSL(i, j) = 0
            endif
        enddo
    enddo
    ! +--OUTPUT
    ! +  ======
    if(IO_loc >= 1) then
        write(21, 606) jdaMAR, jhaMAR, itexpe, nboucl, nprint, &
            0.1 * pSND(1, 1), pstSND, sst_SL, dtagSL, &
            zs_SL, zn_SL, gradtz, mzabso
606     format(//, ' EXECUTION STATUS', /, ' ++++++++++++++++', /, &
                /, ' Preceding Execution stopped after', i5, ' day(s)', i5, ' hour(s)', &
                /, '  itexpe =', i8, 8x, '  nboucl =', i8, 8x, 'nprint =', i8, &
                /, '  p MSL  =', f8.1, ' cb', 5x, 'p* 0   =', f8.1, ' cb', &
                /, '  SST    =', f8.1, ' K ', 5x, 'T0-Tg  =', f8.1, ' K ', &
                /, '  zs     =', f8.5, ' m ', 5x, 'zn     =', f8.5, ' m ', &
                /, '  dT/dz >=', f8.2, ' K/km / mzabso =', i8, ' Sponge Base')
        if(gradtz < -4.0) write(6, 607) gradtz, mzabso
607     format(/, ' WARNING: dT/dz Min =', f8.2, ' K/km at Sponge Base (k=mzabso=', i2, ')')
    endif
    return
endsubroutine inigen

integer function zext(logvar)
    logical, intent(in) :: logvar
    if(logvar) then
        zext = -1
    else
        zext = 0
    endif
    return
endfunction zext
