#include "MAR_pp.def"
subroutine HYDgen
    ! +------------------------------------------------------------------------+
    ! | MAR HYDROLOGIC CYCLE                                   19-01-2023  MAR |
    ! |   subroutine HYDgen contains .main. of the EXPLICIT HYDROLOGICAL CYCLE |
    ! |                                                                        |
    ! +------------------------------------------------------------------------+
    ! |                                                                        |
    ! |   INPUT / OUTPUT:    qvDY(mx,my,mz) : air   specific humidity     (kg/kg) |
    ! |   ^^^^^^^^^^^^^^^ qwHY(mx,my,mz) : cloud drops                 (kg/kg) |
    ! |                   qrHY(mx,my,mz) : rain  drops                 (kg/kg) |
    ! |                   qiHY(mx,my,mz) : ice   crystals concentration(kg/kg) |
    ! |                   qsHY(mx,my,mz) : snow  flakes                (kg/kg) |
    ! |                 rainHY(mx,my)    : rain  Precipitation             (m) |
    ! |                 snowHY(mx,my)    : snow  Precipitation         (m w.e) |
    ! |                 crysHY(mx,my)    : ice   Precipitation         (m w.e) |
    ! |                 hlatHY(mx,my,mz) : Latent Heat Release           (K/s) |
    ! |                                                                        |
    ! |   OUTPUT:                                                              |
    ! |   ^^^^^^^                                                              |
    ! |                                                                        |
    ! |   REFER. : 1) Ntezimana, unpubl.thes.LLN, 115 pp,     1993             |
    ! |   ^^^^^^^^ 2) Lin et al.       JCAM   22, 1065--1092, 1983             |
    ! |               (very similar, except that graupels are represented)     |
    ! |            3) Emde and Kahlig, An.Geo. 7,  405-- 414, 1989             |
    ! |                                                                        |
    ! | # OPTIONS: #WH  Additional Output (Each Process  is detailed)          |
    ! | # ^^^^^^^^ #EW  Additional Output (Energy and Water Conservation)      |
    ! |                                                                        |
    ! +------------------------------------------------------------------------+

    use marctr
    use marphy
    use mardim
    use margrd
    use mar_ge
    use mar_dy
    use mar_hy
    use mar_ca
    use mar_te
    use mar_tu
    use mar_sl
    use mar_wk
    use mar_io
    use mar_sv
    use mar_tv
#ifdef EW
    use mar_ew
#endif
    use mar_fi
    use mar_ra
    use marmagic
#ifdef iso
    use mariso, only: wiso, niso, qvDY_iso
#endif

    implicit none
    ! Local variables
    ! ===============
#ifdef iso
    real :: fac
    ! iso_time : number of the output file increment
    integer :: iso_time
    ! iso_label : label of output increment
    character*10 :: iso_label
#endif
    integer ioutIO(5)
    real :: ccni2D(klon, klev)
    real :: ccnw2D(klon, klev)
    real :: cfra2D(klon, klev)
    real :: crys2D(klon)
    real :: dqi2D(klon, klev)
    real :: dqw2D(klon, klev)
    real :: ect_2D(klon, klev)
    real :: enr01D(klon)
    real :: enr11D(klon)
    real :: enr21D(klon)
    real :: gplv2D(klon, klev + 1)
    real :: gpmi2D(klon, klev + 1)
    real :: hlat2D(klon, klev)
    integer :: jhlr2D(klon)
    character(len=20) :: mphy2D(klon)
    real :: pk2D(klon, klev)
    real :: pkta2D(klon, klev)
    real :: prec2D(klon)
    real :: pst2D(klon)
    real :: pst2Dn(klon)
    real :: qg2D(klon, klev)
    real :: qi2D(klon, klev)
    real :: qr2D(klon, klev)
    real :: qs2D(klon, klev)
    ! qssbl2D : sublimated snow flakes (kg/kg)
    real :: qssbl2D(klon, klev)
    real :: qv2D(klon, klev)
    real :: qvsi2D(klon, klev + 1)
    real :: qvsw2D(klon, klev + 1)
    real :: qw2D(klon, klev)
    real :: rain2D(klon)
    real :: rolv2D(klon, klev)
    real :: snoh2D(klon)
    real :: snow2D(klon)
    real :: tair2D(klon, klev)
    real :: tsrf2D(klon)
    real :: TUkv2D(klon, klev)
    real :: uair2D(klon, klev)
    real :: vair2D(klon, klev)
    real :: wair2D(klon, klev)
    real :: wat01D(klon)
    real :: wat11D(klon)
    real :: wat21D(klon)
    real :: watf1D(klon)
    real :: snf2D(klon, klev)
    real :: sbl2D(klon, klev)
    ! dep2D : atm. snow condensation (m w.e.)
    real :: dep2D(klon, klev)
    real :: rnf2D(klon, klev)
    real :: evp2D(klon, klev)
    ! smt2D : atm. (integr) snow transport (kg/m)
    real :: smt2D(klon, klev)

#ifdef wx
    ! OUTPUT in SISVAT at specified i,j,k,n (see assignation in PHY_SISVAT)
    ! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    ! integer    iSV_v1, jSV_v1, nSV_v1, kSV_v1, lSV_v1
    ! common  /SISVAT_EV/    iSV_v1, jSV_v1, nSV_v1, kSV_v1, lSV_v1
#endif

    integer i, j, k, nbr,m
    character * 3 vecthy
    integer klhyOK, io, io___1, io___5, iklon, itPhys, nthyd2
    integer il_mmc, il__mm, i___mm, j___mm, il_mez, kk_pp
#ifdef wH
    integer i_fvv(klon), j_fvv(klon), klfvv, i0fvv, j0fvv, k0fvv
    common / DebuggHy / i_fvv, j_fvv, klfvv, i0fvv, j0fvv, k0fvv
#endif

    real qs99, hrelmx, erosmx, facLHR
    real uq1, uq2, vq1, vq2, sq1, sq2
    real uInFlw, uOutFl, pp, pkt0, ta_MAR
    real vInFlw, vOutFl
    real cloud_magic2, dthyd2, qqp

    ! +--DATA
    ! +  ====

    data i___mm/0/
    data j___mm/0/
    data qs99/0.99e+0/
#ifdef wH
    i0fvv = 26                     ! i ccordinate (detailled output)
    j0fvv = 17                     ! j ccordinate (detailled output)
    k0fvv = 24                     ! k ccordinate (detailled output)
#endif

    cloud_magic2 = 0.
#ifdef EU
    cloud_magic2 = cloud_magic / (10.*real(ntHyd))
#endif

    ! +--Set UP Verification
    ! +  ===================
#ifdef wH
    write(6, 6020) itexpe, jdarGE, mmarGE, iyrrGE, jhurGE, minuGE, jsecGE
6020 format(/, 'Clouds Microphysics', 2i6, '-', i2, '-', i4, i6, 'h', i2, ':', i2)
#endif
    if(itexpe == 0) then
        klhyOK = mx2 * my2
        klhyOK = 1
        if(klon /= klhyOK) then
            if(klon > 1) then
                vecthy = 'NON'
            else
                vecthy = '   '
            endif
            write(6, 6000) klon, klhyOK, vecthy
6000        format(/, '++++++++ klon (mardim_mod.f90) =', i6, ' .NE.', i6, ' ++++++++++++++', &
                    /, '++++++++ NOT adapted to a ', a3, ' vectorized code ++++++++++++++', &
                    /, '++++++++ BAD SET UP of #hy or klon parameter  ++++++++++++++', &
                    /, '     ==> !?%@&* Emergency EXIT in HYDgen')
            stop
        endif

        ! +--Cloud Microphysics Initialization
        ! +  =================================
        do j = 1, my
            do i = 1, mx
                rai0HY(i, j) = 0.
                rainHY(i, j) = 0.
                sno0HY(i, j) = 0.
                sfa0HY(i, j) = 0.
                snowHY(i, j) = 0.
                crysHY(i, j) = 0.
            enddo
        enddo
        do k = 1, mz
            do j = 1, my
                do i = 1, mx
                    ccniHY(i, j, k) = 0.
                    qiHY(i, j, k) = 0.
                    qsHY(i, j, k) = 0.
                    qwHY(i, j, k) = 0.
                    qrHY(i, j, k) = 0.
                    snfHY(i, j, k) = 0.
                    sblHY(i, j, k) = 0.
                    depHY(i, j, k) = 0.
                    rnfHY(i, j, k) = 0.
                    evpHY(i, j, k) = 0.
                    smtHY(i, j, k) = 0.
                    qssblHY(i, j, k) = 0.
                enddo
            enddo
        enddo

    endif

    !XF (not cumulated precip because in real*4) !!!!
    if(iterun == 0) then
        do i = 1, mx
            do j = 1, my
                do k = 1, mz
                    snfHY(i, j, k) = 0.
                    sblHY(i, j, k) = 0.
                    depHY(i, j, k) = 0.
                    rnfHY(i, j, k) = 0.
                    evpHY(i, j, k) = 0.
                    smtHY(i, j, k) = 0.
                    qssblHY(i, j, k) = 0.
                enddo
                rai0HY(i, j) = 0.
                rainHY(i, j) = 0.
                rainCA(i, j) = 0.
                sno0HY(i, j) = 0.
                sfa0HY(i, j) = 0.
                snowHY(i, j) = 0.
                snowCA(i, j) = 0.
                crysHY(i, j) = 0.
                runoTV(i, j) = 0.
                draiTV(i, j) = 0.
                evapTV(i, j) = 0.
            enddo
        enddo
    endif
    !XF

    ! +--Cloud Microphysics OFF ==> Reset of the Air Relative Humidity
    ! +  =============================================================
    if(jhaRUN < tim_HY) then
        ! +...Hydrological cycle is inhibited until jhaRUN = tim_HY
        do k = 1, mz
            do j = 1, my
                do i = 1, mx
                    tairDY(i, j, k) = pktaDY(i, j, k) * pkDY(i, j, k)
                enddo
            enddo
        enddo
        ! +  ******
        call qsat3d
        ! +  ******
        do k = 1, mz
            do j = 1, my
                do i = 1, mx
#ifdef iso
                    fac = qvsiDY(i, j, k) * min(qs99, qvDY(i, j, k) / qvsiDY(i, j, k)) / qvDY(i, j, k)
                    do wiso = 1, niso
                        qvDY_iso(wiso, i, j, k) = fac * qvDY_iso(wiso, i, j, k)
                    enddo
#endif
                    qvDY(i, j, k) = qvsiDY(i, j, k) * min(qs99, qvDY(i, j, k) / qvsiDY(i, j, k))
                enddo
            enddo
        enddo
        turnHY = .true.
    endif

    ! +--Decide to set ON Cloud Microphysics if Air Relative Humidity > Crit.
    ! +  ====================================================================
    if(.not. turnHY) then
#ifdef BS
        erosmx = -1.0
#endif
        ! +  ******
        call qsat3d
        ! +  ******
        hrelmx = 0.0
        do j = 1, my
            do i = 1, mx
                do k = 1, mz
                    !CAa todo : check here if relevant ? why 2 lines ? why the second ?
                    hrelmx = max(hrelmx, qvDY(i, j, k) / qvsiDY(i, j, k))
                    hrelmx = max(hrelmx, qvDY(i, j, k) / qvswDY(i, j, k))
#ifdef BS
                    erosmx = max(erosmx, SLuusl(i, j, 1) - SaltSL(i, j))
#endif
                enddo
            enddo
        enddo
        if(hrelmx > rhcrHY) turnHY = .true.
#ifdef BS
        if(erosmx > 0.0) turnHY = .true.
#endif
    endif

#ifdef iso
    iso_label = 'hydgen->1 '
    iso_time = iso_time + 1
    call mariso_write_file(iso_time, iso_label)
#endif(iso)

    ! +--Hydrological Cycle Initialization
    ! +  =================================
    if(turnHY) then
        ! +----From 3D to 2D arrays
        ! +    --------------------
        do io = 1, 5
            ioutIO(io) = igrdIO(io) + mx * (jgrdIO(io) - 1)
        enddo
#ifdef WH
        if(il__mm == 0) then
            i___mm = imez
            j___mm = jmez
            il__mm = imez + (jmez - 1) * mx2
        endif
#endif
#ifdef EW
        il_mez = imez + (jmez - 1) * mx2
#endif
        ! +
        iklon = 0

        !$OMP PARALLEL DO &
        !$OMP private(i,j,k,nbr,iklon,facLHR,qqp,dtHyd2,ntHyd2, &
        !$OMP         io___1,io___5,il__mm,i___mm,j___mm,il_mez,kk_pp, &
        !$OMP      ccni2D,ccnw2D,cfra2D,crys2D, &
        !$OMP       dqi2D, dqw2D,ect_2D,enr01D, &
        !$OMP      enr11D,enr21D,gplv2D, &
        !$OMP      gpmi2D,hlat2D,jhlr2D,mphy2D, &
        !$OMP        pk2D,pkta2D,prec2D, pst2D, &
        !$OMP      pst2Dn,  qg2D,  qi2D,  qr2D, &
        !$OMP        qs2D,  qv2D,qvsi2D,qvsw2D, &
        !$OMP        qw2D,rain2D,rolv2D,snoh2D, &
        !$OMP      snow2D,tair2D,tsrf2D,TUkv2D, &
        !$OMP      uair2D,vair2D,wair2D,wat01D, &
        !$OMP      wat11D,wat21D,watf1D,qssbl2D, &
        !$OMP      snf2D,sbl2D,dep2D,rnf2D,evp2D,smt2D) &
        !$OMP schedule(dynamic)

        do j = 1, my
            do i = 1, mx
                nbr=1 ; iklon = 1
 1234           continue
                qqp = 0

                if(i > 1 .and. i < mx .and. j > 1 .and. j < my) then
                    do k = 1, klev
                        pk2D(iklon, k) = pkDY(i, j, k)
                        pkta2D(iklon, k) = pktaDY(i, j, k)
                        tair2D(iklon, k) = tairDY(i, j, k)
                        uair2D(iklon, k) = uairDY(i, j, k)
                        vair2D(iklon, k) = vairDY(i, j, k)
                        wair2D(iklon, k) = wairDY(i, j, k)*.01 + sqrt(2.*ect_TE(i, j, k) / 3.)
                        rolv2D(iklon, k) = rolvDY(i, j, k)
#ifdef kk
                        ! qv2D(iklon, k) = max(qvDY(i, j, k), epsq)
#endif
                        qv2D(iklon, k) = &
                            max(qvDY(i, j, k), epsi)
                        qw2D(iklon, k) = qwHY(i, j, k)
                        qr2D(iklon, k) = qrHY(i, j, k)
                        qi2D(iklon, k) = qiHY(i, j, k)
                        qs2D(iklon, k) = max(qsHY(i, j, k), zero)
                        qqp = max(qqp,(qr2D(iklon, k) + qs2D(iklon, k)) / 2.)
#ifdef qg
                        qg2D(iklon, k) = qgHY(i, j, k)
#endif
                        cfra2D(iklon, k) = cfraHY(i, j, k)
                        ccnw2D(iklon, k) = ccnwHY(i, j, k)
                        ccni2D(iklon, k) = ccniHY(i, j, k)
                        dqi2D(iklon, k) = 0.
                        dqw2D(iklon, k) = 0.
                        hlat2D(iklon, k) = hlatHY(i, j, k)
                        ect_2D(iklon, k) = ect_TE(i, j, k)
                        TUkv2D(iklon, k) = TUkvh(i, j, k)
                        snf2D(iklon, k) = snfHY(i, j, k)
                        sbl2D(iklon, k) = sblHY(i, j, k)
                        dep2D(iklon, k) = depHY(i, j, k)
                        rnf2D(iklon, k) = rnfHY(i, j, k)
                        evp2D(iklon, k) = evpHY(i, j, k)
                        smt2D(iklon, k) = smtHY(i, j, k)
                        qssbl2D(iklon, k) = qssblHY(i, j, k)
                    enddo

                    do k = max(1, mzhyd - 1), klev + 1
                        gplv2D(iklon, k) = gplvDY(i, j, k)
                        gpmi2D(iklon, k) = gpmiDY(i, j, k)
                        qvsw2D(iklon, k) = qvswDY(i, j, k)
                        qvsi2D(iklon, k) = qvsiDY(i, j, k)
                    enddo

                    kk_pp = klev / 2
                    do k = klev, klev / 2, -1
                        if(gplvDY(i, j, k) * grvinv - sh(i, j) < 100) kk_pp = k
                    enddo

                    ! do k = max(1, mzhyd - 1), klev
                    !     if(qvDY(i, j, k)>=qvswDY(i, j, k) .and. tairDY(i, j, k)>=273.15) qqp = 1
                    !     if(qvDY(i, j, k)>=qvsiDY(i, j, k) .and. tairDY(i, j, k)<=273.15) qqp = 1
                    !     if(qqp>2 * eps9) goto 777
                    ! end do
                    ! 777       continue

                    pst2D(iklon) = pstDY(i, j)
                    pst2Dn(iklon) = pstDYn(i, j)
                    rain2D(iklon) = rainHY(i, j)
                    snow2D(iklon) = snowHY(i, j)
                    crys2D(iklon) = crysHY(i, j)
                    prec2D(iklon) = precSL(i, j)
                    snoh2D(iklon) = snohSL(i, j)
                    tsrf2D(iklon) = TairSL(i, j)
#ifdef EW
                    wat01D(iklon) = wat0EW(i, j)
                    wat11D(iklon) = wat1EW(i, j)
                    wat21D(iklon) = wat2EW(i, j)
                    watf1D(iklon) = watfEW(i, j)
                    enr01D(iklon) = enr0EW(i, j)
                    enr11D(iklon) = enr1EW(i, j)
                    enr21D(iklon) = enr2EW(i, j)
                    mphy2D(iklon) = mphyEW(i, j)
#endif
                    jhlr2D(iklon) = jhlrGE(i, j)

                    ! +----Call Cloud Microphysics, in case of NO vectorization
                    ! +    ----------------------------------------------------

                    io___1 = 0
                    io___5 = 0
                    do io = 1, 5
                        if(ioutIO(io) == iklon) then
                            io___1 = io
                            io___5 = io
                        endif
                    enddo
                    if(i == i___mm .and. j == j___mm) then
                        il__mm = 1
                    else
                        il__mm = 0
                    endif
                    if(i == imez .and. j == jmez) then
                        il_mez = 1
                    else
                        il_mez = 0
                    endif

                    dtHyd2 = dt / real(ntHyd)
                    ntHyd2 = ntHyd

                    if(qqp <= epsi * 100.) then
                        ntHyd2 = min(2, ntHyd)
                        dtHyd2 = dt / real(ntHyd2)
                    endif
                    if(qqp <= epsi * 10. .or. i <= 10 .or. j <= 10 .or. i >= mx - 9 .or. j >= my - 9) then
                        ntHyd2 = min(1, ntHyd)
                        dtHyd2 = dt / real(ntHyd2)
                    endif
                    do itPhys = 1, max(1, ntHyd2)
                        do k = mzhyd, klev
                            qw2D(iklon, k) = qw2D(iklon, k) + cloud_magic2 * qr2D(iklon, k)
                            qr2D(iklon, k) = qr2D(iklon, k) * (1.-cloud_magic2)
                            if(qi2D(iklon, k) < qs2D(iklon, k) * 10e-3 .and. &
                               gplvDY(i, j, k) * grvinv - sh(i, j) > 200.) then
                                qi2D(iklon, k) = qi2D(iklon, k) + cloud_magic2 * qs2D(iklon, k)
                                qs2D(iklon, k) = qs2D(iklon, k) * (1.-cloud_magic2)
                            endif
                        enddo
                        ! +  ***********
                        call HYDmic(io___1, io___5, ioutIO, &
                                    il__mm, i___mm, j___mm, il_mez, kk_pp, &
                                    ccni2D, ccnw2D, cfra2D, crys2D, &
                                    dqi2D, dqw2D, ect_2D, enr01D, &
                                    enr11D, enr21D, gplv2D, &
                                    gpmi2D, hlat2D, jhlr2D, mphy2D, &
                                    pk2D, pkta2D, prec2D, pst2D, &
                                    pst2Dn, qg2D, qi2D, qr2D, &
                                    qs2D, qv2D, qvsi2D, qvsw2D, &
                                    qw2D, rain2D, rolv2D, snoh2D, &
                                    snow2D, tair2D, tsrf2D, TUkv2D, &
                                    uair2D, vair2D, wair2D, wat01D, &
                                    wat11D, wat21D, watf1D, dtHyd2, &
                                    snf2D, sbl2D, dep2D, rnf2D, evp2D, &
                                    smt2D, qssbl2D, itPhys, ntHyd2)
                        ! +  ***********
                    enddo

                    do k = 1, klev
                     if(isnan(tair2D(iklon, k)).or.isnan(qs2D(iklon, k)).or.isnan(qi2D(iklon, k)))then
                      print *,"NaN in Hydmic at pixel (i,j,k):",i,j,k
                      nbr=nbr+1
                      if(nbr<10) goto 1234
                      stop
                     endif
                    enddo

                    ! +----From 2D to 3D arrays,    in case of NO vectorization
                    ! +    ----------------------------------------------------

                    do k = 1, klev
                        pktaDY(i, j, k) = pkta2D(iklon, k)
                        tairDY(i, j, k) = tair2D(iklon, k)
                        rolvDY(i, j, k) = rolv2D(iklon, k)
                        qvsiDY(i, j, k) = qvsi2D(iklon, k)
                        qvswDY(i, j, k) = qvsw2D(iklon, k)
                        qvDY(i, j, k) = qv2D(iklon, k)
                        qwHY(i, j, k) = qw2D(iklon, k)
                        qrHY(i, j, k) = qr2D(iklon, k)
                        qiHY(i, j, k) = qi2D(iklon, k)
                        qsHY(i, j, k) = qs2D(iklon, k)
                        snfHY(i, j, k) = snf2D(iklon, k)
                        sblHY(i, j, k) = sbl2D(iklon, k)
                        depHY(i, j, k) = dep2D(iklon, k)
                        rnfHY(i, j, k) = rnf2D(iklon, k)
                        evpHY(i, j, k) = evp2D(iklon, k)
#ifdef qg
                        qgHY(i, j, k) = qg2D(iklon, k)
#endif
                        cfraHY(i, j, k) = cfra2D(iklon, k)
                        ccnwHY(i, j, k) = ccnw2D(iklon, k)
                        ccniHY(i, j, k) = ccni2D(iklon, k)
                        dqiHY(i, j, k) = dqi2D(iklon, k) * dsigm1(k) * pstDYn(i, j)
                        dqwHY(i, j, k) = dqw2D(iklon, k) * dsigm1(k) * pstDYn(i, j)
                        hlatHY(i, j, k) = hlat2D(iklon, k)
                        smthy(i, j, k) = smt2D(iklon, k)
                        qssblHY(i, j, k) = qssbl2D(iklon, k)
                    enddo

                    rainHY(i, j) = rain2D(iklon)
                    snowHY(i, j) = snow2D(iklon)
                    crysHY(i, j) = crys2D(iklon)
                    precSL(i, j) = prec2D(iklon)
                    snohSL(i, j) = snoh2D(iklon)
#ifdef ew
                    wat0EW(i, j) = wat01D(iklon)
                    wat1EW(i, j) = wat11D(iklon)
                    wat2EW(i, j) = wat21D(iklon)
                    watfEW(i, j) = watf1D(iklon)
                    enr0EW(i, j) = enr01D(iklon)
                    enr1EW(i, j) = enr11D(iklon)
                    enr2EW(i, j) = enr21D(iklon)
                    mphyEW(i, j) = mphy2D(iklon)
#endif

                    ! +----Call Cloud Microphysics, in case of    vectorization
                    ! +    ----------------------------------------------------
#ifdef hy
                    ! if (klon.gt.1) then
#endif
                    ! io___1  =  1
                    ! io___5  =  5
#ifdef WH
                    ! + ***********
                    !   call HYDmic(io___1,io___5,il__mm,i___mm,j___mm,il_mez)
                    ! + ***********
                    !
                    ! il_mmc = il__mm
                    ! j___mm =      0
                    ! 1000   continue
                    ! il_mmc = il_mmc-(my2-jp11+1)
                    ! j___mm = j___mm  + 1
                    ! if (il_mmc.gt.0) go to 1000
                    ! i___mm = il_mmc+(my2-jp11+1) + ip11
#endif

                    ! +----From 2D to 3D arrays,    in case of    vectorization
                    ! +    ----------------------------------------------------
                    ! iklon = 0
                    ! do j = jp11,my1
                    !     do i = ip11,mx1
                    !  iklon  = iklon + 1
                    !  do k=1,klev
                    !      pktaDY(i,j,k)=pkta2D(iklon,k)
                    !      tairDY(i,j,k)=tair2D(iklon,k)
                    !      rolvDY(i,j,k)=rolv2D(iklon,k)
                    !      qvsiDY(i,j,k)=qvsi2D(iklon,k)
                    !      qvswDY(i,j,k)=qvsw2D(iklon,k)
                    !      qvDY(i,j,k)=  qv2D(iklon,k)
                    !      qwHY(i,j,k)=  qw2D(iklon,k)
                    !      qrHY(i,j,k)=  qr2D(iklon,k)
                    !      qiHY(i,j,k)=  qi2D(iklon,k)
                    !      qsHY(i,j,k)=  qs2D(iklon,k)
                    !      snfHY(i,j,k)= snf2D(iklon,k)
                    !      smthy(i,j,k)= smt2D(iklon,k)
                    !      sblHY(i,j,k)= sbl2D(iklon,k)
                    !      rnfHY(i,j,k)= rnf2D(iklon,k)
                    !      evpHY(i,j,k)= evp2D(iklon,k)
                    !#ifdef qg
                    !      qgHY(i,j,k)=  qg2D(iklon,k)
                    !#endif
                    !      cfraHY(i,j,k)=cfra2D(iklon,k)
                    !      ccnwHY(i,j,k)=ccnw2D(iklon,k)
                    !      ccniHY(i,j,k)=ccni2D(iklon,k)
                    !      dqiHY(i,j,k)= dqi2D(iklon,k)*dsigm1(k)*pstDYn(i,j)
                    !      dqwHY(i,j,k)= dqw2D(iklon,k)*dsigm1(k)*pstDYn(i,j)
                    !      hlatHY(i,j,k)=hlat2D(iklon,k)
                    ! end do
                    ! rainHY(i,j)  =rain2D(iklon)
                    ! snowHY(i,j)  =snow2D(iklon)
                    ! crysHY(i,j)  =crys2D(iklon)
                    ! precSL(i,j)  =prec2D(iklon)
                    ! snohSL(i,j)  =snoh2D(iklon)
#ifdef EW
                    ! wat0EW(i, j) = wat01D(iklon)
                    ! wat1EW(i, j) = wat11D(iklon)
                    ! wat2EW(i, j) = wat21D(iklon)
                    ! watfEW(i, j) = watf1D(iklon)
                    ! enr0EW(i, j) = enr01D(iklon)
                    ! enr1EW(i, j) = enr11D(iklon)
                    ! enr2EW(i, j) = enr21D(iklon)
                    ! mphyEW(i, j) = mphy2D(iklon)
#endif
                    !     end do
                    !     end do
#ifdef hy
                    ! end if
#endif
                    ! +--Isotopes Proxies: Diagnostics
                    ! +  =============================
                    WKxy1(i, j) = 0.
                    WKxy2(i, j) = 0.
                    WKxy3(i, j) = 0.
                    WKxy4(i, j) = 0.
                    WKxy5(i, j) = 0.
                    WKxy6(i, j) = 0.
                    do k = 2, klev
                        WKxy1(i, j) = WKxy1(i, j) &
                                      + dsigm1(k) * max(hlatHY(i, j, k), 0.)
                        WKxy2(i, j) = WKxy2(i, j) &
                                      - dsigm1(k) * min(hlatHY(i, j, k), 0.)
                        WKxy3(i, j) = WKxy3(i, j) &
                                      + dsigm1(k) * max(hlatHY(i, j, k), 0.) * tairDY(i, j, k)
                        WKxy4(i, j) = WKxy4(i, j) &
                                      - dsigm1(k) * min(hlatHY(i, j, k), 0.) * tairDY(i, j, k)
                        WKxy5(i, j) = WKxy5(i, j) &
                                      + dsigm1(k) * max(hlatHY(i, j, k), 0.) * gplvDY(i, j, k)
                        WKxy6(i, j) = WKxy6(i, j) &
                                      - dsigm1(k) * min(hlatHY(i, j, k), 0.) * gplvDY(i, j, k)
                    enddo
                    facLHR = (cp / Ls_H2O) * pstDYn(i, j) * 1.e3 * grvinv * dt
                    Hcd_HY(i, j) = Hcd_HY(i, j) + WKxy1(i, j) * facLHR
                    Hsb_HY(i, j) = Hsb_HY(i, j) + WKxy2(i, j) * facLHR
                    Tcd_HY(i, j) = Tcd_HY(i, j) + WKxy3(i, j) * facLHR
                    Tsb_HY(i, j) = Tsb_HY(i, j) + WKxy4(i, j) * facLHR
                    zcd_HY(i, j) = zcd_HY(i, j) + WKxy5(i, j) * facLHR
                    zsb_HY(i, j) = zsb_HY(i, j) + WKxy6(i, j) * facLHR
                endif

                icntHY = icntHY + 1

                ! +--Hydrological Cycle Lateral Boundary Conditions
                ! +  ==============================================

                if(i == 1) then
                    do k = mzhyd, mz
                        WKxyz1(1, j, k) = max(0., sign(1., uairDY(1, j, k)))  ! u_In_Flow
                        WKxyz2(1, j, k) = 1.-WKxyz1(1, j, k)    ! u_OutFlow
                        WKxyz3(1, j, k) = (sigma(k) * pstDY(1, j) + ptopDY)**cap ! pp
                        WKxyz4(1, j, k) = pktaDY(1, j, k)

                        WKxyz1(mx, j, k) = max(0., sign(1., uairDY(mx, j, k)))
                        WKxyz2(mx, j, k) = 1.-WKxyz1(mx, j, k)
                        WKxyz3(mx, j, k) = (sigma(k) * pstDY(mx, j) + ptopDY)**cap
                        WKxyz4(mx, j, k) = pktaDY(mx, j, k)
                    enddo

                    do k = mzhyd, mz
                        qwHY(1, j, k) = qwHY(1, j, k) * WKxyz2(1, j, k)
                        qiHY(1, j, k) = qiHY(1, j, k) * WKxyz2(1, j, k)
                        qrHY(1, j, k) = qrHY(1, j, k) * WKxyz2(1, j, k)
                        qsHY(1, j, k) = qsHY(1, j, k) * WKxyz2(1, j, k)
                        WKxyz5(1, j, k) = tairDY(1, j, k) * WKxyz2(1, j, k)

                        qwHY(mx, j, k) = qwHY(mx, j, k) * WKxyz1(mx, j, k)
                        qiHY(mx, j, k) = qiHY(mx, j, k) * WKxyz1(mx, j, k)
                        qrHY(mx, j, k) = qrHY(mx, j, k) * WKxyz1(mx, j, k)
                        qsHY(mx, j, k) = qsHY(mx, j, k) * WKxyz1(mx, j, k)
                        WKxyz5(mx, j, k) = tairDY(mx, j, k) * WKxyz1(mx, j, k)
                    enddo

                    do k = mzhyd, mz
                        pktaDY(1, j, k) = pktaDY(1, j, k) * WKxyz1(1, j, k) &
                                          + WKxyz5(1, j, k) / WKxyz3(1, j, k)

                        pktaDY(mx, j, k) = pktaDY(mx, j, k) * WKxyz2(mx, j, k) &
                                           + WKxyz5(mx, j, k) / WKxyz3(mx, j, k)
                    enddo

                    do k = mzhyd, mz
                        hlatHY(1, j, k) = WKxyz5(1, j, k) &
                                          * (1.0 - WKxyz4(1, j, k) / pktaDY(1, j, k)) / dt

                        hlatHY(mx, j, k) = WKxyz5(mx, j, k) &
                                           * (1.0 - WKxyz4(mx, j, k) / pktaDY(mx, j, k)) / dt
                    enddo
                endif

                if(j == 1) then
                    do k = mzhyd, mz
                        WKxyz1(i, 1, k) = max(0., sign(1., vairDY(i, 1, k)))  ! v_In_Flow
                        WKxyz2(i, 1, k) = 1.-WKxyz1(i, 1, k)    ! v_OutFlow
                        WKxyz3(i, 1, k) = (sigma(k) * pstDY(i, 1) + ptopDY)**cap ! pp
                        WKxyz4(i, 1, k) = pktaDY(i, 1, k)

                        WKxyz1(i, my, k) = max(0., sign(1., vairDY(i, my, k)))
                        WKxyz2(i, my, k) = 1.-WKxyz1(i, my, k)
                        WKxyz3(i, my, k) = (sigma(k) * pstDY(i, my) + ptopDY)**cap
                        WKxyz4(i, my, k) = pktaDY(i, my, k)
                    enddo

                    do k = mzhyd, mz
                        qwHY(i, 1, k) = qwHY(i, 1, k) * WKxyz2(i, 1, k)
                        qiHY(i, 1, k) = qiHY(i, 1, k) * WKxyz2(i, 1, k)
                        qrHY(i, 1, k) = qrHY(i, 1, k) * WKxyz2(i, 1, k)
                        qsHY(i, 1, k) = qsHY(i, 1, k) * WKxyz2(i, 1, k)
                        WKxyz5(i, 1, k) = tairDY(i, 1, k) * WKxyz2(i, 1, k)

                        qwHY(i, my, k) = qwHY(i, my, k) * WKxyz1(i, my, k)
                        qiHY(i, my, k) = qiHY(i, my, k) * WKxyz1(i, my, k)
                        qrHY(i, my, k) = qrHY(i, my, k) * WKxyz1(i, my, k)
                        qsHY(i, my, k) = qsHY(i, my, k) * WKxyz1(i, my, k)
                        WKxyz5(i, my, k) = tairDY(i, my, k) * WKxyz1(i, my, k)
                    enddo

                    do k = mzhyd, mz
                        pktaDY(i, 1, k) = pktaDY(i, 1, k) * WKxyz1(i, 1, k) &
                                          + WKxyz5(i, 1, k) / WKxyz3(i, 1, k)

                        pktaDY(i, my, k) = pktaDY(i, my, k) * WKxyz2(i, my, k) &
                                           + WKxyz5(i, my, k) / WKxyz3(i, my, k)
                    enddo

                    do k = mzhyd, mz
                        hlatHY(i, 1, k) = WKxyz5(i, 1, k) &
                                          * (1.0 - WKxyz4(i, 1, k) / pktaDY(i, 1, k)) / dt

                        hlatHY(i, my, k) = WKxyz5(i, my, k) &
                                           * (1.0 - WKxyz4(i, my, k) / pktaDY(i, my, k)) / dt
                    enddo
                endif
                WKxy1(i, j) = 0.
                WKxy2(i, j) = 0.
                WKxy3(i, j) = 0.
                WKxy4(i, j) = 0.
                WKxy5(i, j) = 0.
                WKxy6(i, j) = 0.

            enddo
        enddo
        !$OMP END PARALLEL DO
    endif
#ifdef wx
    ! OUTPUT in SISVAT at specified i,j,k,n (see assignation in PHY_SISVAT)
    ! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    ! if (lSV_v1>0  .and.  lSV_v1<=2)  then
    !     write(6, 6010)  ((qsHY(iSV_v1, jSV_v1, k) * 1.e3), k = mz, mz - 4, -1)
    !     6010   format(10x, 'After HYDmic   : q   [g/kg] =', 5f9.6)
    ! end if
#endif
    return
endsubroutine HYDgen
