#include "MAR_pp.def"
subroutine filatmo
    ! +------------------------------------------------------------------------+
    ! | MAR Filtering                                        14-03-2018-XF MAR |
    ! +------------------------------------------------------------------------+

    use marphy
    use marctr
    use mar_sv
    use mardim
    use margrd
    use mar_ge
    use mar_dy
    use mar_lb
    use mar_sl
    use mar_bs
    use mar_io
    use mar_tv
    use marssn
    use mar_ib
    use mardsv

    implicit none
    integer i, j, k, m
    real min_tt_sea, min_tt_land, diff_max
#ifdef AC
    data min_tt_sea/-80./ !degree C
    data min_tt_land/-90./ !degree C
#endif
    data min_tt_sea/-70./ !degree C
    data min_tt_land/-75./ !degree C
    data diff_max/35./ !degree C

    real :: min_tt, tt, diff, ww, w
    real :: pk, ua, va, wa, gp, ps
    real :: force_filtering(mx, my)

    integer :: n, ii, jj, step

    if(iterun <= 1) then
        write(6, 11) min_tt_sea, min_tt_land
11      format(' WARNING: filatmo min Temp. over  sea=', f5.0, &
               ' min Temp. over land=', f5.0)
    else
        force_filtering = 0
        step = 0
999     continue
        !$OMP PARALLEL do default(shared) &
        !$OMP private(i,j,k,min_tt,diff,pk,ua,va,wa,gp,ps,ww,ii,jj) &
        !$OMP schedule(dynamic)
        do k = mz / 3, mz
            do i = 2, mx - 1
                do j = 2, my - 1
                    if(isolSL(i, j) <= 2) then
                        min_tt = min_tt_sea
                    else
                        min_tt = min_tt_land
                    endif

                    if(isnan(uairDY(i, j, k)) .or. isnan(tairDY(i, j, k)) &
                       .or. isnan(vairDY(i, j, k)) .or. tairDY(i, j, k) < 173.15) then
                        call time_steps
                        print *, "STOP in filatmo.f: NaN on pixel(i,j,k)", i, j, k
                        print *, tairDY(i, j, k), uairDY(i, j, k), vairDY(i, j, k)
                        stop
                    endif

                    diff = 0

                    if(tairdy(i, j, k) - 273.15 < min(-30., min_tt + 30.)) then
                        diff = max(diff, abs(tairdy(i, j, k) - tairdy(i - 1, j, k)))
                        diff = max(diff, abs(tairdy(i, j, k) - tairdy(i + 1, j, k)))
                        diff = max(diff, abs(tairdy(i, j, k) - tairdy(i, j - 1, k)))
                        diff = max(diff, abs(tairdy(i, j, k) - tairdy(i, j + 1, k)))
                    endif

                    if(tairdy(i, j, k) - 273.15 < min_tt .or. diff > diff_max .or. &
                       isnan(pktaDY(i, j, k)) .or. &
                       force_filtering(i, j) > 0) then
                        pk = 0
                        ua = 0
                        va = 0
                        wa = 0
                        gp = 0
                        ps = 0
                        ww = 0
                        do ii = -1, 1
                            do jj = -1, 1
                                w = 1
                                if(ii == 0 .or. jj == 0) w = 2
                                if(ii == 0 .and. jj == 0) w = 0
                                if(tairdy(i + ii, j + jj, k) > tairdy(i, j, k) + 20. .and. &
                                   .not. isnan(pktaDY(i + ii, j + jj, k))) then
                                    pk = pk + w * pktaDY(i + ii, j + jj, k)
                                    ! ua = ua + w * uairDY(i+ii, j+jj, k)
                                    ! va = va + w * vairDY(i+ii, j+jj, k)
                                    ! wa = wa + w * wairDY(i+ii, j+jj, k)
                                    gp = gp + w * gplvDY(i + ii, j + jj, k)
                                    ps = ps + w * pstDY(i + ii, j + jj)
                                    ww = ww + w
                                else
                                    force_filtering(i + ii, j + jj) = 1
                                endif
                            enddo
                        enddo

                        if(ww > 2) then
                            pktaDY(i, j, k) = pk / ww
                            ! uairDY(i, j, k) = ua / ww
                            ! vairDY(i, j, k) = va / ww
                            ! wairDY(i, j, k) = wa / ww
                            gplvDY(i, j, k) = gp / ww
                            pstDY(i, j) = ps / ww
                            tt = -273.15 + pktaDY(i, j, k) * ((pstDY(i, j) * sigma(k) + ptopDY)**cap)
                            !$OMP CRITICAL
                            write(6, 12) iyrrGE, mmarGE, jdarGE, jhurGE, minuGE, &
                                i, j, k, tairdy(i, j, k) - 273.15, tt
12                          format('ERROR filatmo', &
                                   i5, 4i3, ' for (', i3, ','i3, ',', i2, ')', f6.0, '=>', f6.0)
                            write(6, *)
                            !$OMP END CRITICAL
                            tairdy(i, j, k) = pktaDY(i, j, k) * ((pstDY(i, j) * sigma(k) + ptopDY)**cap)
                            force_filtering(i, j) = 1
                        endif
                    endif
                enddo
            enddo
        enddo
        !$OMP END PARALLEL DO

        do i = 2, mx - 1
            do j = 2, my - 1
                if(force_filtering(i, j) > 0 .and. step <= 1) then
                    step = step + 1
                    goto 999
                endif
            enddo
        enddo

    endif

endsubroutine filatmo
