INTERFACE
SUBROUTINE RADIATION_SCHEME &
     & (KIDIA, KFDIA, KLON, KLEV, KAEROSOL, &
     &  TIME_SEED, &
     &  PSOLAR_IRRADIANCE, &
     &  PMU0, PTEMPERATURE_SKIN, PALBEDO_DIF, PALBEDO_DIR, &
     &  PEMIS, PEMIS_WINDOW, &
     &  PCCN_LAND, PCCN_SEA, &
     &  PGELAM, PGEMU, PLAND_SEA_MASK, &
     &  PPRESSURE, PTEMPERATURE, &
     &  PPRESSURE_H, PTEMPERATURE_H, &
     &  PQ, PCO2, PCH4, PN2O, PCFC11, PCFC12, PHCFC22, PCCL4, PO3, &
     &  PCLOUD_FRAC, PQ_LIQUID, PQ_ICE, PQ_RAIN, PQ_SNOW, &
     &  PAEROSOL_OLD, PAEROSOL, &
     &  PFLUX_SW, PFLUX_LW, PFLUX_SW_CLEAR, PFLUX_LW_CLEAR, &
     &  PFLUX_SW_DN, PFLUX_LW_DN, PFLUX_SW_DN_CLEAR, PFLUX_LW_DN_CLEAR, &
     &  PFLUX_DIR, PFLUX_DIR_CLEAR, PFLUX_DIR_INTO_SUN, &
     &  PFLUX_UV, PFLUX_PAR, PFLUX_PAR_CLEAR, &
     &  PFLUX_SW_DN_TOA, PEMIS_OUT, PLWDERIVATIVE, &
     &  PSWDIFFUSEBAND, PSWDIRECTBAND, & 
     &  PSW_SPECTRAL, PSW_SPECTRAL_DIR, &
     &  PSW_SPECTRAL_RAW, PSW_SPECTRAL_RAW_DIR)
USE PARKIND1, ONLY : JPRB, JPIM
USE YOERAD, ONLY : NSW
INTEGER(KIND=JPIM), INTENT(IN) :: KIDIA
INTEGER(KIND=JPIM), INTENT(IN) :: KFDIA
INTEGER(KIND=JPIM), INTENT(IN) :: KLON
INTEGER(KIND=JPIM), INTENT(IN) :: KLEV
INTEGER(KIND=JPIM), INTENT(IN) :: KAEROSOL
INTEGER, INTENT(IN) :: TIME_SEED
REAL(KIND=JPRB),   INTENT(IN) :: PSOLAR_IRRADIANCE
REAL(KIND=JPRB),   INTENT(IN) :: PMU0(KLON)
REAL(KIND=JPRB),   INTENT(IN) :: PTEMPERATURE_SKIN(KLON)
REAL(KIND=JPRB),   INTENT(IN) :: PALBEDO_DIF(KLON,NSW)
REAL(KIND=JPRB),   INTENT(IN) :: PALBEDO_DIR(KLON,NSW)
REAL(KIND=JPRB),   INTENT(IN) :: PEMIS(KLON)
REAL(KIND=JPRB),   INTENT(IN) :: PEMIS_WINDOW(KLON)
REAL(KIND=JPRB),   INTENT(IN) :: PCCN_LAND(KLON) 
REAL(KIND=JPRB),   INTENT(IN) :: PCCN_SEA(KLON) 
REAL(KIND=JPRB),   INTENT(IN) :: PGELAM(KLON)
REAL(KIND=JPRB),   INTENT(IN) :: PGEMU(KLON)
REAL(KIND=JPRB),   INTENT(IN) :: PLAND_SEA_MASK(KLON) 
REAL(KIND=JPRB),   INTENT(IN) :: PPRESSURE(KLON,KLEV)
REAL(KIND=JPRB),   INTENT(IN) :: PTEMPERATURE(KLON,KLEV)
REAL(KIND=JPRB),   INTENT(IN) :: PPRESSURE_H(KLON,KLEV+1)
REAL(KIND=JPRB),   INTENT(IN) :: PTEMPERATURE_H(KLON,KLEV+1)
REAL(KIND=JPRB),   INTENT(IN) :: PQ(KLON,KLEV) 
REAL(KIND=JPRB),   INTENT(IN) :: PCO2(KLON,KLEV) 
REAL(KIND=JPRB),   INTENT(IN) :: PCH4(KLON,KLEV) 
REAL(KIND=JPRB),   INTENT(IN) :: PN2O(KLON,KLEV)
REAL(KIND=JPRB),   INTENT(IN) :: PCFC11(KLON,KLEV) 
REAL(KIND=JPRB),   INTENT(IN) :: PCFC12(KLON,KLEV) 
REAL(KIND=JPRB),   INTENT(IN) :: PHCFC22(KLON,KLEV) 
REAL(KIND=JPRB),   INTENT(IN) :: PCCL4(KLON,KLEV) 
REAL(KIND=JPRB),   INTENT(IN) :: PO3(KLON,KLEV)
REAL(KIND=JPRB),   INTENT(IN) :: PCLOUD_FRAC(KLON,KLEV)
REAL(KIND=JPRB),   INTENT(IN) :: PQ_LIQUID(KLON,KLEV)
REAL(KIND=JPRB),   INTENT(IN) :: PQ_ICE(KLON,KLEV)
REAL(KIND=JPRB),   INTENT(IN) :: PQ_RAIN(KLON,KLEV)
REAL(KIND=JPRB),   INTENT(IN) :: PQ_SNOW(KLON,KLEV)
REAL(KIND=JPRB),   INTENT(IN) :: PAEROSOL_OLD(KLON,6,KLEV)
REAL(KIND=JPRB),   INTENT(IN) :: PAEROSOL(KLON,KLEV,KAEROSOL)
REAL(KIND=JPRB),  INTENT(OUT) :: PFLUX_SW(KLON,KLEV+1) 
REAL(KIND=JPRB),  INTENT(OUT) :: PFLUX_LW(KLON,KLEV+1) 
REAL(KIND=JPRB),  INTENT(OUT) :: PFLUX_SW_CLEAR(KLON,KLEV+1) 
REAL(KIND=JPRB),  INTENT(OUT) :: PFLUX_LW_CLEAR(KLON,KLEV+1) 
REAL(KIND=JPRB),  INTENT(OUT) :: PFLUX_SW_DN(KLON) 
REAL(KIND=JPRB),  INTENT(OUT) :: PFLUX_LW_DN(KLON) 
REAL(KIND=JPRB),  INTENT(OUT) :: PFLUX_SW_DN_CLEAR(KLON)
REAL(KIND=JPRB),  INTENT(OUT) :: PFLUX_LW_DN_CLEAR(KLON)
REAL(KIND=JPRB),  INTENT(OUT) :: PFLUX_DIR(KLON)
REAL(KIND=JPRB),  INTENT(OUT) :: PFLUX_DIR_CLEAR(KLON)
REAL(KIND=JPRB),  INTENT(OUT) :: PFLUX_DIR_INTO_SUN(KLON)
REAL(KIND=JPRB),  INTENT(OUT) :: PFLUX_UV(KLON)
REAL(KIND=JPRB),  INTENT(OUT) :: PFLUX_PAR(KLON)
REAL(KIND=JPRB),  INTENT(OUT) :: PFLUX_PAR_CLEAR(KLON)
REAL(KIND=JPRB),  INTENT(OUT) :: PFLUX_SW_DN_TOA(KLON)
REAL(KIND=JPRB),  INTENT(OUT) :: PEMIS_OUT(KLON)   
REAL(KIND=JPRB),  INTENT(OUT) :: PLWDERIVATIVE(KLON,KLEV+1)
REAL(KIND=JPRB),  INTENT(OUT) :: PSWDIFFUSEBAND(KLON,NSW)
REAL(KIND=JPRB),  INTENT(OUT) :: PSWDIRECTBAND(KLON,NSW)
REAL(KIND=JPRB), INTENT(INOUT), ALLOCATABLE :: PSW_SPECTRAL(:,:)
REAL(KIND=JPRB), INTENT(INOUT), ALLOCATABLE :: PSW_SPECTRAL_DIR(:,:)
REAL(KIND=JPRB), INTENT(INOUT), ALLOCATABLE :: PSW_SPECTRAL_RAW(:,:)
REAL(KIND=JPRB), INTENT(INOUT), ALLOCATABLE :: PSW_SPECTRAL_RAW_DIR(:,:)
END SUBROUTINE RADIATION_SCHEME
END INTERFACE
