SUBROUTINE SURRTPK

!     Adapted from Eli J. Mlawer, Atmospheric & Environmental Research.
!     by JJMorcrette, ECMWF
!     ABozzo 201306 updated to rrtmg v4.85
!     changes in nspa (band 3 from 10 to 9 and band 9 from 11 to 9)
!     changes in nspb (band 4 from 6 to 5)
!     ------------------------------------------------------------------

USE PARKIND1  ,ONLY : JPRB
!USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK

USE YOERRTWN , ONLY : NG        ,NSPA      ,NSPB      ,&
 & DELWAVE    , TOTPLNK  !       ,WAVENUM1  ,WAVENUM2 

!     ------------------------------------------------------------------

IMPLICIT NONE
!REAL(KIND=JPRB) :: ZHOOK_HANDLE
!IF (LHOOK) CALL DR_HOOK('SURRTPK',0,ZHOOK_HANDLE)
NG( :) = (/16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16/)
NSPA( :) = (/1, 1,9, 9, 9, 1, 9, 1,9, 1, 1, 9, 9, 1, 9, 9/)
NSPB( :) = (/1, 1, 5, 5, 5, 0, 1, 1, 1, 1, 1, 0, 0, 1, 0, 0/)
!WAVENUM1( :) = (/&
! & 10._JPRB, 250._JPRB, 500._JPRB, 630._JPRB, 700._JPRB, 820._JPRB, 980._JPRB,1080._JPRB &
! & ,1180._JPRB,1390._JPRB,1480._JPRB,1800._JPRB,2080._JPRB,2250._JPRB,2380._JPRB,2600._JPRB/)  
!WAVENUM2( :) = (/&
! & 250._JPRB, 500._JPRB, 630._JPRB, 700._JPRB, 820._JPRB, 980._JPRB,1080._JPRB,1180._JPRB &
! & ,1390._JPRB,1480._JPRB,1800._JPRB,2080._JPRB,2250._JPRB,2380._JPRB,2600._JPRB,3000._JPRB/)  
DELWAVE( :) = (/&
 & 340._JPRB, 150._JPRB, 130._JPRB,  70._JPRB, 120._JPRB, 160._JPRB, 100._JPRB, 100._JPRB &
 & , 210._JPRB,  90._JPRB, 320._JPRB, 280._JPRB, 170._JPRB, 130._JPRB, 220._JPRB, 650._JPRB/)  

TOTPLNK(1:50,  1) = (/ &
   &  0.14783E-05_JPRB,0.15006E-05_JPRB,0.15230E-05_JPRB,0.15455E-05_JPRB,0.15681E-05_JPRB, &
   &  0.15908E-05_JPRB,0.16136E-05_JPRB,0.16365E-05_JPRB,0.16595E-05_JPRB,0.16826E-05_JPRB, &
   &  0.17059E-05_JPRB,0.17292E-05_JPRB,0.17526E-05_JPRB,0.17762E-05_JPRB,0.17998E-05_JPRB, &
   &  0.18235E-05_JPRB,0.18473E-05_JPRB,0.18712E-05_JPRB,0.18953E-05_JPRB,0.19194E-05_JPRB, &
   &  0.19435E-05_JPRB,0.19678E-05_JPRB,0.19922E-05_JPRB,0.20166E-05_JPRB,0.20412E-05_JPRB, &
   &  0.20658E-05_JPRB,0.20905E-05_JPRB,0.21153E-05_JPRB,0.21402E-05_JPRB,0.21652E-05_JPRB, &
   &  0.21902E-05_JPRB,0.22154E-05_JPRB,0.22406E-05_JPRB,0.22659E-05_JPRB,0.22912E-05_JPRB, &
   &  0.23167E-05_JPRB,0.23422E-05_JPRB,0.23678E-05_JPRB,0.23934E-05_JPRB,0.24192E-05_JPRB, &
   &  0.24450E-05_JPRB,0.24709E-05_JPRB,0.24968E-05_JPRB,0.25229E-05_JPRB,0.25490E-05_JPRB, &
   &  0.25751E-05_JPRB,0.26014E-05_JPRB,0.26277E-05_JPRB,0.26540E-05_JPRB,0.26805E-05_JPRB/)
TOTPLNK(51:100,  1) = (/ &
   &  0.27070E-05_JPRB,0.27335E-05_JPRB,0.27602E-05_JPRB,0.27869E-05_JPRB,0.28136E-05_JPRB, &
   &  0.28404E-05_JPRB,0.28673E-05_JPRB,0.28943E-05_JPRB,0.29213E-05_JPRB,0.29483E-05_JPRB, &
   &  0.29754E-05_JPRB,0.30026E-05_JPRB,0.30298E-05_JPRB,0.30571E-05_JPRB,0.30845E-05_JPRB, &
   &  0.31119E-05_JPRB,0.31393E-05_JPRB,0.31669E-05_JPRB,0.31944E-05_JPRB,0.32220E-05_JPRB, &
   &  0.32497E-05_JPRB,0.32774E-05_JPRB,0.33052E-05_JPRB,0.33330E-05_JPRB,0.33609E-05_JPRB, &
   &  0.33888E-05_JPRB,0.34168E-05_JPRB,0.34448E-05_JPRB,0.34729E-05_JPRB,0.35010E-05_JPRB, &
   &  0.35292E-05_JPRB,0.35574E-05_JPRB,0.35857E-05_JPRB,0.36140E-05_JPRB,0.36424E-05_JPRB, &
   &  0.36708E-05_JPRB,0.36992E-05_JPRB,0.37277E-05_JPRB,0.37563E-05_JPRB,0.37848E-05_JPRB, &
   &  0.38135E-05_JPRB,0.38421E-05_JPRB,0.38708E-05_JPRB,0.38996E-05_JPRB,0.39284E-05_JPRB, &
   &  0.39572E-05_JPRB,0.39861E-05_JPRB,0.40150E-05_JPRB,0.40440E-05_JPRB,0.40730E-05_JPRB/)
TOTPLNK(101:150,  1) = (/ &
   &  0.41020E-05_JPRB,0.41311E-05_JPRB,0.41602E-05_JPRB,0.41893E-05_JPRB,0.42185E-05_JPRB, &
   &  0.42477E-05_JPRB,0.42770E-05_JPRB,0.43063E-05_JPRB,0.43356E-05_JPRB,0.43650E-05_JPRB, &
   &  0.43944E-05_JPRB,0.44238E-05_JPRB,0.44533E-05_JPRB,0.44828E-05_JPRB,0.45124E-05_JPRB, &
   &  0.45419E-05_JPRB,0.45715E-05_JPRB,0.46012E-05_JPRB,0.46309E-05_JPRB,0.46606E-05_JPRB, &
   &  0.46903E-05_JPRB,0.47201E-05_JPRB,0.47499E-05_JPRB,0.47797E-05_JPRB,0.48096E-05_JPRB, &
   &  0.48395E-05_JPRB,0.48695E-05_JPRB,0.48994E-05_JPRB,0.49294E-05_JPRB,0.49594E-05_JPRB, &
   &  0.49895E-05_JPRB,0.50196E-05_JPRB,0.50497E-05_JPRB,0.50798E-05_JPRB,0.51100E-05_JPRB, &
   &  0.51402E-05_JPRB,0.51704E-05_JPRB,0.52007E-05_JPRB,0.52309E-05_JPRB,0.52612E-05_JPRB, &
   &  0.52916E-05_JPRB,0.53219E-05_JPRB,0.53523E-05_JPRB,0.53827E-05_JPRB,0.54132E-05_JPRB, &
   &  0.54436E-05_JPRB,0.54741E-05_JPRB,0.55047E-05_JPRB,0.55352E-05_JPRB,0.55658E-05_JPRB/)
TOTPLNK(151:181,  1) = (/ &
   &  0.55964E-05_JPRB,0.56270E-05_JPRB,0.56576E-05_JPRB,0.56883E-05_JPRB,0.57190E-05_JPRB, &
   &  0.57497E-05_JPRB,0.57804E-05_JPRB,0.58112E-05_JPRB,0.58420E-05_JPRB,0.58728E-05_JPRB, &
   &  0.59036E-05_JPRB,0.59345E-05_JPRB,0.59653E-05_JPRB,0.59962E-05_JPRB,0.60272E-05_JPRB, &
   &  0.60581E-05_JPRB,0.60891E-05_JPRB,0.61201E-05_JPRB,0.61511E-05_JPRB,0.61821E-05_JPRB, &
   &  0.62131E-05_JPRB,0.62442E-05_JPRB,0.62753E-05_JPRB,0.63064E-05_JPRB,0.63376E-05_JPRB, &
   &  0.63687E-05_JPRB,0.63998E-05_JPRB,0.64310E-05_JPRB,0.64622E-05_JPRB,0.64935E-05_JPRB, &
   &  0.65247E-05_JPRB/)
TOTPLNK(1:50,  2) = (/ &
   &  0.20262E-05_JPRB,0.20757E-05_JPRB,0.21257E-05_JPRB,0.21763E-05_JPRB,0.22276E-05_JPRB, &
   &  0.22794E-05_JPRB,0.23319E-05_JPRB,0.23849E-05_JPRB,0.24386E-05_JPRB,0.24928E-05_JPRB, &
   &  0.25477E-05_JPRB,0.26031E-05_JPRB,0.26591E-05_JPRB,0.27157E-05_JPRB,0.27728E-05_JPRB, &
   &  0.28306E-05_JPRB,0.28889E-05_JPRB,0.29478E-05_JPRB,0.30073E-05_JPRB,0.30673E-05_JPRB, &
   &  0.31279E-05_JPRB,0.31890E-05_JPRB,0.32507E-05_JPRB,0.33129E-05_JPRB,0.33757E-05_JPRB, &
   &  0.34391E-05_JPRB,0.35029E-05_JPRB,0.35674E-05_JPRB,0.36323E-05_JPRB,0.36978E-05_JPRB, &
   &  0.37638E-05_JPRB,0.38304E-05_JPRB,0.38974E-05_JPRB,0.39650E-05_JPRB,0.40331E-05_JPRB, &
   &  0.41017E-05_JPRB,0.41708E-05_JPRB,0.42405E-05_JPRB,0.43106E-05_JPRB,0.43812E-05_JPRB, &
   &  0.44524E-05_JPRB,0.45240E-05_JPRB,0.45961E-05_JPRB,0.46687E-05_JPRB,0.47418E-05_JPRB, &
   &  0.48153E-05_JPRB,0.48894E-05_JPRB,0.49639E-05_JPRB,0.50389E-05_JPRB,0.51143E-05_JPRB/)
TOTPLNK(51:100,  2) = (/ &
   &  0.51902E-05_JPRB,0.52666E-05_JPRB,0.53434E-05_JPRB,0.54207E-05_JPRB,0.54985E-05_JPRB, &
   &  0.55767E-05_JPRB,0.56553E-05_JPRB,0.57343E-05_JPRB,0.58139E-05_JPRB,0.58938E-05_JPRB, &
   &  0.59742E-05_JPRB,0.60550E-05_JPRB,0.61362E-05_JPRB,0.62179E-05_JPRB,0.63000E-05_JPRB, &
   &  0.63825E-05_JPRB,0.64654E-05_JPRB,0.65487E-05_JPRB,0.66324E-05_JPRB,0.67166E-05_JPRB, &
   &  0.68011E-05_JPRB,0.68860E-05_JPRB,0.69714E-05_JPRB,0.70571E-05_JPRB,0.71432E-05_JPRB, &
   &  0.72297E-05_JPRB,0.73166E-05_JPRB,0.74039E-05_JPRB,0.74915E-05_JPRB,0.75796E-05_JPRB, &
   &  0.76680E-05_JPRB,0.77567E-05_JPRB,0.78459E-05_JPRB,0.79354E-05_JPRB,0.80252E-05_JPRB, &
   &  0.81155E-05_JPRB,0.82061E-05_JPRB,0.82970E-05_JPRB,0.83883E-05_JPRB,0.84799E-05_JPRB, &
   &  0.85719E-05_JPRB,0.86643E-05_JPRB,0.87569E-05_JPRB,0.88499E-05_JPRB,0.89433E-05_JPRB, &
   &  0.90370E-05_JPRB,0.91310E-05_JPRB,0.92254E-05_JPRB,0.93200E-05_JPRB,0.94150E-05_JPRB/)
TOTPLNK(101:150,  2) = (/ &
   &  0.95104E-05_JPRB,0.96060E-05_JPRB,0.97020E-05_JPRB,0.97982E-05_JPRB,0.98948E-05_JPRB, &
   &  0.99917E-05_JPRB,0.10089E-04_JPRB,0.10186E-04_JPRB,0.10284E-04_JPRB,0.10382E-04_JPRB, &
   &  0.10481E-04_JPRB,0.10580E-04_JPRB,0.10679E-04_JPRB,0.10778E-04_JPRB,0.10877E-04_JPRB, &
   &  0.10977E-04_JPRB,0.11077E-04_JPRB,0.11178E-04_JPRB,0.11279E-04_JPRB,0.11380E-04_JPRB, &
   &  0.11481E-04_JPRB,0.11583E-04_JPRB,0.11684E-04_JPRB,0.11786E-04_JPRB,0.11889E-04_JPRB, &
   &  0.11992E-04_JPRB,0.12094E-04_JPRB,0.12198E-04_JPRB,0.12301E-04_JPRB,0.12405E-04_JPRB, &
   &  0.12509E-04_JPRB,0.12613E-04_JPRB,0.12717E-04_JPRB,0.12822E-04_JPRB,0.12927E-04_JPRB, &
   &  0.13032E-04_JPRB,0.13138E-04_JPRB,0.13244E-04_JPRB,0.13349E-04_JPRB,0.13456E-04_JPRB, &
   &  0.13562E-04_JPRB,0.13669E-04_JPRB,0.13776E-04_JPRB,0.13883E-04_JPRB,0.13990E-04_JPRB, &
   &  0.14098E-04_JPRB,0.14206E-04_JPRB,0.14314E-04_JPRB,0.14422E-04_JPRB,0.14531E-04_JPRB/)
TOTPLNK(151:181,  2) = (/ &
   &  0.14639E-04_JPRB,0.14748E-04_JPRB,0.14857E-04_JPRB,0.14967E-04_JPRB,0.15076E-04_JPRB, &
   &  0.15186E-04_JPRB,0.15296E-04_JPRB,0.15407E-04_JPRB,0.15517E-04_JPRB,0.15628E-04_JPRB, &
   &  0.15739E-04_JPRB,0.15850E-04_JPRB,0.15961E-04_JPRB,0.16072E-04_JPRB,0.16184E-04_JPRB, &
   &  0.16296E-04_JPRB,0.16408E-04_JPRB,0.16521E-04_JPRB,0.16633E-04_JPRB,0.16746E-04_JPRB, &
   &  0.16859E-04_JPRB,0.16972E-04_JPRB,0.17085E-04_JPRB,0.17198E-04_JPRB,0.17312E-04_JPRB, &
   &  0.17426E-04_JPRB,0.17540E-04_JPRB,0.17654E-04_JPRB,0.17769E-04_JPRB,0.17883E-04_JPRB, &
   &  0.17998E-04_JPRB/)

TOTPLNK( :, 3) = (/&
 & 1.34822E-06_JPRB,1.39134E-06_JPRB,1.43530E-06_JPRB,1.48010E-06_JPRB,1.52574E-06_JPRB,&
 & 1.57222E-06_JPRB,1.61956E-06_JPRB,1.66774E-06_JPRB,1.71678E-06_JPRB,1.76666E-06_JPRB,&
 & 1.81741E-06_JPRB,1.86901E-06_JPRB,1.92147E-06_JPRB,1.97479E-06_JPRB,2.02898E-06_JPRB,&
 & 2.08402E-06_JPRB,2.13993E-06_JPRB,2.19671E-06_JPRB,2.25435E-06_JPRB,2.31285E-06_JPRB,&
 & 2.37222E-06_JPRB,2.43246E-06_JPRB,2.49356E-06_JPRB,2.55553E-06_JPRB,2.61837E-06_JPRB,&
 & 2.68207E-06_JPRB,2.74664E-06_JPRB,2.81207E-06_JPRB,2.87837E-06_JPRB,2.94554E-06_JPRB,&
 & 3.01356E-06_JPRB,3.08245E-06_JPRB,3.15221E-06_JPRB,3.22282E-06_JPRB,3.29429E-06_JPRB,&
 & 3.36662E-06_JPRB,3.43982E-06_JPRB,3.51386E-06_JPRB,3.58876E-06_JPRB,3.66451E-06_JPRB,&
 & 3.74112E-06_JPRB,3.81857E-06_JPRB,3.89688E-06_JPRB,3.97602E-06_JPRB,4.05601E-06_JPRB,&
 & 4.13685E-06_JPRB,4.21852E-06_JPRB,4.30104E-06_JPRB,4.38438E-06_JPRB,4.46857E-06_JPRB,&
 & 4.55358E-06_JPRB,4.63943E-06_JPRB,4.72610E-06_JPRB,4.81359E-06_JPRB,4.90191E-06_JPRB,&
 & 4.99105E-06_JPRB,5.08100E-06_JPRB,5.17176E-06_JPRB,5.26335E-06_JPRB,5.35573E-06_JPRB,&
 & 5.44892E-06_JPRB,5.54292E-06_JPRB,5.63772E-06_JPRB,5.73331E-06_JPRB,5.82970E-06_JPRB,&
 & 5.92688E-06_JPRB,6.02485E-06_JPRB,6.12360E-06_JPRB,6.22314E-06_JPRB,6.32346E-06_JPRB,&
 & 6.42455E-06_JPRB,6.52641E-06_JPRB,6.62906E-06_JPRB,6.73247E-06_JPRB,6.83664E-06_JPRB,&
 & 6.94156E-06_JPRB,7.04725E-06_JPRB,7.15370E-06_JPRB,7.26089E-06_JPRB,7.36883E-06_JPRB,&
 & 7.47752E-06_JPRB,7.58695E-06_JPRB,7.69712E-06_JPRB,7.80801E-06_JPRB,7.91965E-06_JPRB,&
 & 8.03201E-06_JPRB,8.14510E-06_JPRB,8.25891E-06_JPRB,8.37343E-06_JPRB,8.48867E-06_JPRB,&
 & 8.60463E-06_JPRB,8.72128E-06_JPRB,8.83865E-06_JPRB,8.95672E-06_JPRB,9.07548E-06_JPRB,&
 & 9.19495E-06_JPRB,9.31510E-06_JPRB,9.43594E-06_JPRB,9.55745E-06_JPRB,9.67966E-06_JPRB,&
 & 9.80254E-06_JPRB,9.92609E-06_JPRB,1.00503E-05_JPRB,1.01752E-05_JPRB,1.03008E-05_JPRB,&
 & 1.04270E-05_JPRB,1.05539E-05_JPRB,1.06814E-05_JPRB,1.08096E-05_JPRB,1.09384E-05_JPRB,&
 & 1.10679E-05_JPRB,1.11980E-05_JPRB,1.13288E-05_JPRB,1.14601E-05_JPRB,1.15922E-05_JPRB,&
 & 1.17248E-05_JPRB,1.18581E-05_JPRB,1.19920E-05_JPRB,1.21265E-05_JPRB,1.22616E-05_JPRB,&
 & 1.23973E-05_JPRB,1.25337E-05_JPRB,1.26706E-05_JPRB,1.28081E-05_JPRB,1.29463E-05_JPRB,&
 & 1.30850E-05_JPRB,1.32243E-05_JPRB,1.33642E-05_JPRB,1.35047E-05_JPRB,1.36458E-05_JPRB,&
 & 1.37875E-05_JPRB,1.39297E-05_JPRB,1.40725E-05_JPRB,1.42159E-05_JPRB,1.43598E-05_JPRB,&
 & 1.45044E-05_JPRB,1.46494E-05_JPRB,1.47950E-05_JPRB,1.49412E-05_JPRB,1.50879E-05_JPRB,&
 & 1.52352E-05_JPRB,1.53830E-05_JPRB,1.55314E-05_JPRB,1.56803E-05_JPRB,1.58297E-05_JPRB,&
 & 1.59797E-05_JPRB,1.61302E-05_JPRB,1.62812E-05_JPRB,1.64327E-05_JPRB,1.65848E-05_JPRB,&
 & 1.67374E-05_JPRB,1.68904E-05_JPRB,1.70441E-05_JPRB,1.71982E-05_JPRB,1.73528E-05_JPRB,&
 & 1.75079E-05_JPRB,1.76635E-05_JPRB,1.78197E-05_JPRB,1.79763E-05_JPRB,1.81334E-05_JPRB,&
 & 1.82910E-05_JPRB,1.84491E-05_JPRB,1.86076E-05_JPRB,1.87667E-05_JPRB,1.89262E-05_JPRB,&
 & 1.90862E-05_JPRB,1.92467E-05_JPRB,1.94076E-05_JPRB,1.95690E-05_JPRB,1.97309E-05_JPRB,&
 & 1.98932E-05_JPRB,2.00560E-05_JPRB,2.02193E-05_JPRB,2.03830E-05_JPRB,2.05472E-05_JPRB,&
 & 2.07118E-05_JPRB,2.08768E-05_JPRB,2.10423E-05_JPRB,2.12083E-05_JPRB,2.13747E-05_JPRB,&
 & 2.15414E-05_JPRB/)  

TOTPLNK( :, 4) = (/&
 & 8.90528E-07_JPRB,9.24222E-07_JPRB,9.58757E-07_JPRB,9.94141E-07_JPRB,1.03038E-06_JPRB,&
 & 1.06748E-06_JPRB,1.10545E-06_JPRB,1.14430E-06_JPRB,1.18403E-06_JPRB,1.22465E-06_JPRB,&
 & 1.26618E-06_JPRB,1.30860E-06_JPRB,1.35193E-06_JPRB,1.39619E-06_JPRB,1.44136E-06_JPRB,&
 & 1.48746E-06_JPRB,1.53449E-06_JPRB,1.58246E-06_JPRB,1.63138E-06_JPRB,1.68124E-06_JPRB,&
 & 1.73206E-06_JPRB,1.78383E-06_JPRB,1.83657E-06_JPRB,1.89028E-06_JPRB,1.94495E-06_JPRB,&
 & 2.00060E-06_JPRB,2.05724E-06_JPRB,2.11485E-06_JPRB,2.17344E-06_JPRB,2.23303E-06_JPRB,&
 & 2.29361E-06_JPRB,2.35519E-06_JPRB,2.41777E-06_JPRB,2.48134E-06_JPRB,2.54592E-06_JPRB,&
 & 2.61151E-06_JPRB,2.67810E-06_JPRB,2.74571E-06_JPRB,2.81433E-06_JPRB,2.88396E-06_JPRB,&
 & 2.95461E-06_JPRB,3.02628E-06_JPRB,3.09896E-06_JPRB,3.17267E-06_JPRB,3.24741E-06_JPRB,&
 & 3.32316E-06_JPRB,3.39994E-06_JPRB,3.47774E-06_JPRB,3.55657E-06_JPRB,3.63642E-06_JPRB,&
 & 3.71731E-06_JPRB,3.79922E-06_JPRB,3.88216E-06_JPRB,3.96612E-06_JPRB,4.05112E-06_JPRB,&
 & 4.13714E-06_JPRB,4.22419E-06_JPRB,4.31227E-06_JPRB,4.40137E-06_JPRB,4.49151E-06_JPRB,&
 & 4.58266E-06_JPRB,4.67485E-06_JPRB,4.76806E-06_JPRB,4.86229E-06_JPRB,4.95754E-06_JPRB,&
 & 5.05383E-06_JPRB,5.15113E-06_JPRB,5.24946E-06_JPRB,5.34879E-06_JPRB,5.44916E-06_JPRB,&
 & 5.55053E-06_JPRB,5.65292E-06_JPRB,5.75632E-06_JPRB,5.86073E-06_JPRB,5.96616E-06_JPRB,&
 & 6.07260E-06_JPRB,6.18003E-06_JPRB,6.28848E-06_JPRB,6.39794E-06_JPRB,6.50838E-06_JPRB,&
 & 6.61983E-06_JPRB,6.73229E-06_JPRB,6.84573E-06_JPRB,6.96016E-06_JPRB,7.07559E-06_JPRB,&
 & 7.19200E-06_JPRB,7.30940E-06_JPRB,7.42779E-06_JPRB,7.54715E-06_JPRB,7.66749E-06_JPRB,&
 & 7.78882E-06_JPRB,7.91110E-06_JPRB,8.03436E-06_JPRB,8.15859E-06_JPRB,8.28379E-06_JPRB,&
 & 8.40994E-06_JPRB,8.53706E-06_JPRB,8.66515E-06_JPRB,8.79418E-06_JPRB,8.92416E-06_JPRB,&
 & 9.05510E-06_JPRB,9.18697E-06_JPRB,9.31979E-06_JPRB,9.45356E-06_JPRB,9.58826E-06_JPRB,&
 & 9.72389E-06_JPRB,9.86046E-06_JPRB,9.99793E-06_JPRB,1.01364E-05_JPRB,1.02757E-05_JPRB,&
 & 1.04159E-05_JPRB,1.05571E-05_JPRB,1.06992E-05_JPRB,1.08422E-05_JPRB,1.09861E-05_JPRB,&
 & 1.11309E-05_JPRB,1.12766E-05_JPRB,1.14232E-05_JPRB,1.15707E-05_JPRB,1.17190E-05_JPRB,&
 & 1.18683E-05_JPRB,1.20184E-05_JPRB,1.21695E-05_JPRB,1.23214E-05_JPRB,1.24741E-05_JPRB,&
 & 1.26277E-05_JPRB,1.27822E-05_JPRB,1.29376E-05_JPRB,1.30939E-05_JPRB,1.32509E-05_JPRB,&
 & 1.34088E-05_JPRB,1.35676E-05_JPRB,1.37273E-05_JPRB,1.38877E-05_JPRB,1.40490E-05_JPRB,&
 & 1.42112E-05_JPRB,1.43742E-05_JPRB,1.45380E-05_JPRB,1.47026E-05_JPRB,1.48680E-05_JPRB,&
 & 1.50343E-05_JPRB,1.52014E-05_JPRB,1.53692E-05_JPRB,1.55379E-05_JPRB,1.57074E-05_JPRB,&
 & 1.58778E-05_JPRB,1.60488E-05_JPRB,1.62207E-05_JPRB,1.63934E-05_JPRB,1.65669E-05_JPRB,&
 & 1.67411E-05_JPRB,1.69162E-05_JPRB,1.70920E-05_JPRB,1.72685E-05_JPRB,1.74459E-05_JPRB,&
 & 1.76240E-05_JPRB,1.78029E-05_JPRB,1.79825E-05_JPRB,1.81629E-05_JPRB,1.83440E-05_JPRB,&
 & 1.85259E-05_JPRB,1.87086E-05_JPRB,1.88919E-05_JPRB,1.90760E-05_JPRB,1.92609E-05_JPRB,&
 & 1.94465E-05_JPRB,1.96327E-05_JPRB,1.98199E-05_JPRB,2.00076E-05_JPRB,2.01961E-05_JPRB,&
 & 2.03853E-05_JPRB,2.05752E-05_JPRB,2.07658E-05_JPRB,2.09571E-05_JPRB,2.11491E-05_JPRB,&
 & 2.13418E-05_JPRB,2.15352E-05_JPRB,2.17294E-05_JPRB,2.19241E-05_JPRB,2.21196E-05_JPRB,&
 & 2.23158E-05_JPRB/)  

TOTPLNK( :, 5) = (/&
 & 5.70230E-07_JPRB,5.94788E-07_JPRB,6.20085E-07_JPRB,6.46130E-07_JPRB,6.72936E-07_JPRB,&
 & 7.00512E-07_JPRB,7.28869E-07_JPRB,7.58019E-07_JPRB,7.87971E-07_JPRB,8.18734E-07_JPRB,&
 & 8.50320E-07_JPRB,8.82738E-07_JPRB,9.15999E-07_JPRB,9.50110E-07_JPRB,9.85084E-07_JPRB,&
 & 1.02093E-06_JPRB,1.05765E-06_JPRB,1.09527E-06_JPRB,1.13378E-06_JPRB,1.17320E-06_JPRB,&
 & 1.21353E-06_JPRB,1.25479E-06_JPRB,1.29698E-06_JPRB,1.34011E-06_JPRB,1.38419E-06_JPRB,&
 & 1.42923E-06_JPRB,1.47523E-06_JPRB,1.52221E-06_JPRB,1.57016E-06_JPRB,1.61910E-06_JPRB,&
 & 1.66904E-06_JPRB,1.71997E-06_JPRB,1.77192E-06_JPRB,1.82488E-06_JPRB,1.87886E-06_JPRB,&
 & 1.93387E-06_JPRB,1.98991E-06_JPRB,2.04699E-06_JPRB,2.10512E-06_JPRB,2.16430E-06_JPRB,&
 & 2.22454E-06_JPRB,2.28584E-06_JPRB,2.34821E-06_JPRB,2.41166E-06_JPRB,2.47618E-06_JPRB,&
 & 2.54178E-06_JPRB,2.60847E-06_JPRB,2.67626E-06_JPRB,2.74514E-06_JPRB,2.81512E-06_JPRB,&
 & 2.88621E-06_JPRB,2.95841E-06_JPRB,3.03172E-06_JPRB,3.10615E-06_JPRB,3.18170E-06_JPRB,&
 & 3.25838E-06_JPRB,3.33618E-06_JPRB,3.41511E-06_JPRB,3.49518E-06_JPRB,3.57639E-06_JPRB,&
 & 3.65873E-06_JPRB,3.74221E-06_JPRB,3.82684E-06_JPRB,3.91262E-06_JPRB,3.99955E-06_JPRB,&
 & 4.08763E-06_JPRB,4.17686E-06_JPRB,4.26725E-06_JPRB,4.35880E-06_JPRB,4.45150E-06_JPRB,&
 & 4.54537E-06_JPRB,4.64039E-06_JPRB,4.73659E-06_JPRB,4.83394E-06_JPRB,4.93246E-06_JPRB,&
 & 5.03215E-06_JPRB,5.13301E-06_JPRB,5.23504E-06_JPRB,5.33823E-06_JPRB,5.44260E-06_JPRB,&
 & 5.54814E-06_JPRB,5.65484E-06_JPRB,5.76272E-06_JPRB,5.87177E-06_JPRB,5.98199E-06_JPRB,&
 & 6.09339E-06_JPRB,6.20596E-06_JPRB,6.31969E-06_JPRB,6.43460E-06_JPRB,6.55068E-06_JPRB,&
 & 6.66793E-06_JPRB,6.78636E-06_JPRB,6.90595E-06_JPRB,7.02670E-06_JPRB,7.14863E-06_JPRB,&
 & 7.27173E-06_JPRB,7.39599E-06_JPRB,7.52142E-06_JPRB,7.64802E-06_JPRB,7.77577E-06_JPRB,&
 & 7.90469E-06_JPRB,8.03477E-06_JPRB,8.16601E-06_JPRB,8.29841E-06_JPRB,8.43198E-06_JPRB,&
 & 8.56669E-06_JPRB,8.70256E-06_JPRB,8.83957E-06_JPRB,8.97775E-06_JPRB,9.11706E-06_JPRB,&
 & 9.25753E-06_JPRB,9.39915E-06_JPRB,9.54190E-06_JPRB,9.68580E-06_JPRB,9.83085E-06_JPRB,&
 & 9.97704E-06_JPRB,1.01243E-05_JPRB,1.02728E-05_JPRB,1.04224E-05_JPRB,1.05731E-05_JPRB,&
 & 1.07249E-05_JPRB,1.08779E-05_JPRB,1.10320E-05_JPRB,1.11872E-05_JPRB,1.13435E-05_JPRB,&
 & 1.15009E-05_JPRB,1.16595E-05_JPRB,1.18191E-05_JPRB,1.19799E-05_JPRB,1.21418E-05_JPRB,&
 & 1.23048E-05_JPRB,1.24688E-05_JPRB,1.26340E-05_JPRB,1.28003E-05_JPRB,1.29676E-05_JPRB,&
 & 1.31361E-05_JPRB,1.33056E-05_JPRB,1.34762E-05_JPRB,1.36479E-05_JPRB,1.38207E-05_JPRB,&
 & 1.39945E-05_JPRB,1.41694E-05_JPRB,1.43454E-05_JPRB,1.45225E-05_JPRB,1.47006E-05_JPRB,&
 & 1.48797E-05_JPRB,1.50600E-05_JPRB,1.52413E-05_JPRB,1.54236E-05_JPRB,1.56070E-05_JPRB,&
 & 1.57914E-05_JPRB,1.59768E-05_JPRB,1.61633E-05_JPRB,1.63509E-05_JPRB,1.65394E-05_JPRB,&
 & 1.67290E-05_JPRB,1.69197E-05_JPRB,1.71113E-05_JPRB,1.73040E-05_JPRB,1.74976E-05_JPRB,&
 & 1.76923E-05_JPRB,1.78880E-05_JPRB,1.80847E-05_JPRB,1.82824E-05_JPRB,1.84811E-05_JPRB,&
 & 1.86808E-05_JPRB,1.88814E-05_JPRB,1.90831E-05_JPRB,1.92857E-05_JPRB,1.94894E-05_JPRB,&
 & 1.96940E-05_JPRB,1.98996E-05_JPRB,2.01061E-05_JPRB,2.03136E-05_JPRB,2.05221E-05_JPRB,&
 & 2.07316E-05_JPRB,2.09420E-05_JPRB,2.11533E-05_JPRB,2.13657E-05_JPRB,2.15789E-05_JPRB,&
 & 2.17931E-05_JPRB/)  

TOTPLNK( :, 6) = (/&
 & 2.73493E-07_JPRB,2.87408E-07_JPRB,3.01848E-07_JPRB,3.16825E-07_JPRB,3.32352E-07_JPRB,&
 & 3.48439E-07_JPRB,3.65100E-07_JPRB,3.82346E-07_JPRB,4.00189E-07_JPRB,4.18641E-07_JPRB,&
 & 4.37715E-07_JPRB,4.57422E-07_JPRB,4.77774E-07_JPRB,4.98784E-07_JPRB,5.20464E-07_JPRB,&
 & 5.42824E-07_JPRB,5.65879E-07_JPRB,5.89638E-07_JPRB,6.14115E-07_JPRB,6.39320E-07_JPRB,&
 & 6.65266E-07_JPRB,6.91965E-07_JPRB,7.19427E-07_JPRB,7.47666E-07_JPRB,7.76691E-07_JPRB,&
 & 8.06516E-07_JPRB,8.37151E-07_JPRB,8.68607E-07_JPRB,9.00896E-07_JPRB,9.34029E-07_JPRB,&
 & 9.68018E-07_JPRB,1.00287E-06_JPRB,1.03860E-06_JPRB,1.07522E-06_JPRB,1.11274E-06_JPRB,&
 & 1.15117E-06_JPRB,1.19052E-06_JPRB,1.23079E-06_JPRB,1.27201E-06_JPRB,1.31418E-06_JPRB,&
 & 1.35731E-06_JPRB,1.40141E-06_JPRB,1.44650E-06_JPRB,1.49257E-06_JPRB,1.53965E-06_JPRB,&
 & 1.58773E-06_JPRB,1.63684E-06_JPRB,1.68697E-06_JPRB,1.73815E-06_JPRB,1.79037E-06_JPRB,&
 & 1.84365E-06_JPRB,1.89799E-06_JPRB,1.95341E-06_JPRB,2.00991E-06_JPRB,2.06750E-06_JPRB,&
 & 2.12619E-06_JPRB,2.18599E-06_JPRB,2.24691E-06_JPRB,2.30895E-06_JPRB,2.37212E-06_JPRB,&
 & 2.43643E-06_JPRB,2.50189E-06_JPRB,2.56851E-06_JPRB,2.63628E-06_JPRB,2.70523E-06_JPRB,&
 & 2.77536E-06_JPRB,2.84666E-06_JPRB,2.91916E-06_JPRB,2.99286E-06_JPRB,3.06776E-06_JPRB,&
 & 3.14387E-06_JPRB,3.22120E-06_JPRB,3.29975E-06_JPRB,3.37953E-06_JPRB,3.46054E-06_JPRB,&
 & 3.54280E-06_JPRB,3.62630E-06_JPRB,3.71105E-06_JPRB,3.79707E-06_JPRB,3.88434E-06_JPRB,&
 & 3.97288E-06_JPRB,4.06270E-06_JPRB,4.15380E-06_JPRB,4.24617E-06_JPRB,4.33984E-06_JPRB,&
 & 4.43479E-06_JPRB,4.53104E-06_JPRB,4.62860E-06_JPRB,4.72746E-06_JPRB,4.82763E-06_JPRB,&
 & 4.92911E-06_JPRB,5.03191E-06_JPRB,5.13603E-06_JPRB,5.24147E-06_JPRB,5.34824E-06_JPRB,&
 & 5.45634E-06_JPRB,5.56578E-06_JPRB,5.67656E-06_JPRB,5.78867E-06_JPRB,5.90213E-06_JPRB,&
 & 6.01694E-06_JPRB,6.13309E-06_JPRB,6.25060E-06_JPRB,6.36947E-06_JPRB,6.48968E-06_JPRB,&
 & 6.61126E-06_JPRB,6.73420E-06_JPRB,6.85850E-06_JPRB,6.98417E-06_JPRB,7.11120E-06_JPRB,&
 & 7.23961E-06_JPRB,7.36938E-06_JPRB,7.50053E-06_JPRB,7.63305E-06_JPRB,7.76694E-06_JPRB,&
 & 7.90221E-06_JPRB,8.03887E-06_JPRB,8.17690E-06_JPRB,8.31632E-06_JPRB,8.45710E-06_JPRB,&
 & 8.59928E-06_JPRB,8.74282E-06_JPRB,8.88776E-06_JPRB,9.03409E-06_JPRB,9.18179E-06_JPRB,&
 & 9.33088E-06_JPRB,9.48136E-06_JPRB,9.63323E-06_JPRB,9.78648E-06_JPRB,9.94111E-06_JPRB,&
 & 1.00971E-05_JPRB,1.02545E-05_JPRB,1.04133E-05_JPRB,1.05735E-05_JPRB,1.07351E-05_JPRB,&
 & 1.08980E-05_JPRB,1.10624E-05_JPRB,1.12281E-05_JPRB,1.13952E-05_JPRB,1.15637E-05_JPRB,&
 & 1.17335E-05_JPRB,1.19048E-05_JPRB,1.20774E-05_JPRB,1.22514E-05_JPRB,1.24268E-05_JPRB,&
 & 1.26036E-05_JPRB,1.27817E-05_JPRB,1.29612E-05_JPRB,1.31421E-05_JPRB,1.33244E-05_JPRB,&
 & 1.35080E-05_JPRB,1.36930E-05_JPRB,1.38794E-05_JPRB,1.40672E-05_JPRB,1.42563E-05_JPRB,&
 & 1.44468E-05_JPRB,1.46386E-05_JPRB,1.48318E-05_JPRB,1.50264E-05_JPRB,1.52223E-05_JPRB,&
 & 1.54196E-05_JPRB,1.56182E-05_JPRB,1.58182E-05_JPRB,1.60196E-05_JPRB,1.62223E-05_JPRB,&
 & 1.64263E-05_JPRB,1.66317E-05_JPRB,1.68384E-05_JPRB,1.70465E-05_JPRB,1.72559E-05_JPRB,&
 & 1.74666E-05_JPRB,1.76787E-05_JPRB,1.78921E-05_JPRB,1.81069E-05_JPRB,1.83230E-05_JPRB,&
 & 1.85404E-05_JPRB,1.87591E-05_JPRB,1.89791E-05_JPRB,1.92005E-05_JPRB,1.94232E-05_JPRB,&
 & 1.96471E-05_JPRB/)  

TOTPLNK( :, 7) = (/&
 & 1.25349E-07_JPRB,1.32735E-07_JPRB,1.40458E-07_JPRB,1.48527E-07_JPRB,1.56954E-07_JPRB,&
 & 1.65748E-07_JPRB,1.74920E-07_JPRB,1.84481E-07_JPRB,1.94443E-07_JPRB,2.04814E-07_JPRB,&
 & 2.15608E-07_JPRB,2.26835E-07_JPRB,2.38507E-07_JPRB,2.50634E-07_JPRB,2.63229E-07_JPRB,&
 & 2.76301E-07_JPRB,2.89864E-07_JPRB,3.03930E-07_JPRB,3.18508E-07_JPRB,3.33612E-07_JPRB,&
 & 3.49253E-07_JPRB,3.65443E-07_JPRB,3.82195E-07_JPRB,3.99519E-07_JPRB,4.17428E-07_JPRB,&
 & 4.35934E-07_JPRB,4.55050E-07_JPRB,4.74785E-07_JPRB,4.95155E-07_JPRB,5.16170E-07_JPRB,&
 & 5.37844E-07_JPRB,5.60186E-07_JPRB,5.83211E-07_JPRB,6.06929E-07_JPRB,6.31355E-07_JPRB,&
 & 6.56498E-07_JPRB,6.82373E-07_JPRB,7.08990E-07_JPRB,7.36362E-07_JPRB,7.64501E-07_JPRB,&
 & 7.93420E-07_JPRB,8.23130E-07_JPRB,8.53643E-07_JPRB,8.84971E-07_JPRB,9.17128E-07_JPRB,&
 & 9.50123E-07_JPRB,9.83969E-07_JPRB,1.01868E-06_JPRB,1.05426E-06_JPRB,1.09073E-06_JPRB,&
 & 1.12810E-06_JPRB,1.16638E-06_JPRB,1.20558E-06_JPRB,1.24572E-06_JPRB,1.28680E-06_JPRB,&
 & 1.32883E-06_JPRB,1.37183E-06_JPRB,1.41581E-06_JPRB,1.46078E-06_JPRB,1.50675E-06_JPRB,&
 & 1.55374E-06_JPRB,1.60174E-06_JPRB,1.65078E-06_JPRB,1.70087E-06_JPRB,1.75200E-06_JPRB,&
 & 1.80421E-06_JPRB,1.85749E-06_JPRB,1.91186E-06_JPRB,1.96732E-06_JPRB,2.02389E-06_JPRB,&
 & 2.08159E-06_JPRB,2.14040E-06_JPRB,2.20035E-06_JPRB,2.26146E-06_JPRB,2.32372E-06_JPRB,&
 & 2.38714E-06_JPRB,2.45174E-06_JPRB,2.51753E-06_JPRB,2.58451E-06_JPRB,2.65270E-06_JPRB,&
 & 2.72210E-06_JPRB,2.79272E-06_JPRB,2.86457E-06_JPRB,2.93767E-06_JPRB,3.01201E-06_JPRB,&
 & 3.08761E-06_JPRB,3.16448E-06_JPRB,3.24261E-06_JPRB,3.32204E-06_JPRB,3.40275E-06_JPRB,&
 & 3.48476E-06_JPRB,3.56808E-06_JPRB,3.65271E-06_JPRB,3.73866E-06_JPRB,3.82595E-06_JPRB,&
 & 3.91456E-06_JPRB,4.00453E-06_JPRB,4.09584E-06_JPRB,4.18851E-06_JPRB,4.28254E-06_JPRB,&
 & 4.37796E-06_JPRB,4.47475E-06_JPRB,4.57293E-06_JPRB,4.67249E-06_JPRB,4.77346E-06_JPRB,&
 & 4.87583E-06_JPRB,4.97961E-06_JPRB,5.08481E-06_JPRB,5.19143E-06_JPRB,5.29948E-06_JPRB,&
 & 5.40896E-06_JPRB,5.51989E-06_JPRB,5.63226E-06_JPRB,5.74608E-06_JPRB,5.86136E-06_JPRB,&
 & 5.97810E-06_JPRB,6.09631E-06_JPRB,6.21597E-06_JPRB,6.33713E-06_JPRB,6.45976E-06_JPRB,&
 & 6.58388E-06_JPRB,6.70950E-06_JPRB,6.83661E-06_JPRB,6.96521E-06_JPRB,7.09531E-06_JPRB,&
 & 7.22692E-06_JPRB,7.36005E-06_JPRB,7.49468E-06_JPRB,7.63084E-06_JPRB,7.76851E-06_JPRB,&
 & 7.90773E-06_JPRB,8.04846E-06_JPRB,8.19072E-06_JPRB,8.33452E-06_JPRB,8.47985E-06_JPRB,&
 & 8.62674E-06_JPRB,8.77517E-06_JPRB,8.92514E-06_JPRB,9.07666E-06_JPRB,9.22975E-06_JPRB,&
 & 9.38437E-06_JPRB,9.54057E-06_JPRB,9.69832E-06_JPRB,9.85762E-06_JPRB,1.00185E-05_JPRB,&
 & 1.01810E-05_JPRB,1.03450E-05_JPRB,1.05106E-05_JPRB,1.06777E-05_JPRB,1.08465E-05_JPRB,&
 & 1.10168E-05_JPRB,1.11887E-05_JPRB,1.13621E-05_JPRB,1.15372E-05_JPRB,1.17138E-05_JPRB,&
 & 1.18920E-05_JPRB,1.20718E-05_JPRB,1.22532E-05_JPRB,1.24362E-05_JPRB,1.26207E-05_JPRB,&
 & 1.28069E-05_JPRB,1.29946E-05_JPRB,1.31839E-05_JPRB,1.33749E-05_JPRB,1.35674E-05_JPRB,&
 & 1.37615E-05_JPRB,1.39572E-05_JPRB,1.41544E-05_JPRB,1.43533E-05_JPRB,1.45538E-05_JPRB,&
 & 1.47558E-05_JPRB,1.49595E-05_JPRB,1.51647E-05_JPRB,1.53716E-05_JPRB,1.55800E-05_JPRB,&
 & 1.57900E-05_JPRB,1.60017E-05_JPRB,1.62149E-05_JPRB,1.64296E-05_JPRB,1.66460E-05_JPRB,&
 & 1.68640E-05_JPRB/)  

TOTPLNK( :, 8) = (/&
 & 6.74445E-08_JPRB,7.18176E-08_JPRB,7.64153E-08_JPRB,8.12456E-08_JPRB,8.63170E-08_JPRB,&
 & 9.16378E-08_JPRB,9.72168E-08_JPRB,1.03063E-07_JPRB,1.09184E-07_JPRB,1.15591E-07_JPRB,&
 & 1.22292E-07_JPRB,1.29296E-07_JPRB,1.36613E-07_JPRB,1.44253E-07_JPRB,1.52226E-07_JPRB,&
 & 1.60540E-07_JPRB,1.69207E-07_JPRB,1.78236E-07_JPRB,1.87637E-07_JPRB,1.97421E-07_JPRB,&
 & 2.07599E-07_JPRB,2.18181E-07_JPRB,2.29177E-07_JPRB,2.40598E-07_JPRB,2.52456E-07_JPRB,&
 & 2.64761E-07_JPRB,2.77523E-07_JPRB,2.90755E-07_JPRB,3.04468E-07_JPRB,3.18673E-07_JPRB,&
 & 3.33381E-07_JPRB,3.48603E-07_JPRB,3.64352E-07_JPRB,3.80638E-07_JPRB,3.97474E-07_JPRB,&
 & 4.14871E-07_JPRB,4.32841E-07_JPRB,4.51395E-07_JPRB,4.70547E-07_JPRB,4.90306E-07_JPRB,&
 & 5.10687E-07_JPRB,5.31699E-07_JPRB,5.53357E-07_JPRB,5.75670E-07_JPRB,5.98652E-07_JPRB,&
 & 6.22315E-07_JPRB,6.46672E-07_JPRB,6.71731E-07_JPRB,6.97511E-07_JPRB,7.24018E-07_JPRB,&
 & 7.51266E-07_JPRB,7.79269E-07_JPRB,8.08038E-07_JPRB,8.37584E-07_JPRB,8.67922E-07_JPRB,&
 & 8.99061E-07_JPRB,9.31016E-07_JPRB,9.63797E-07_JPRB,9.97417E-07_JPRB,1.03189E-06_JPRB,&
 & 1.06722E-06_JPRB,1.10343E-06_JPRB,1.14053E-06_JPRB,1.17853E-06_JPRB,1.21743E-06_JPRB,&
 & 1.25726E-06_JPRB,1.29803E-06_JPRB,1.33974E-06_JPRB,1.38241E-06_JPRB,1.42606E-06_JPRB,&
 & 1.47068E-06_JPRB,1.51630E-06_JPRB,1.56293E-06_JPRB,1.61056E-06_JPRB,1.65924E-06_JPRB,&
 & 1.70894E-06_JPRB,1.75971E-06_JPRB,1.81153E-06_JPRB,1.86443E-06_JPRB,1.91841E-06_JPRB,&
 & 1.97350E-06_JPRB,2.02968E-06_JPRB,2.08699E-06_JPRB,2.14543E-06_JPRB,2.20500E-06_JPRB,&
 & 2.26573E-06_JPRB,2.32762E-06_JPRB,2.39068E-06_JPRB,2.45492E-06_JPRB,2.52036E-06_JPRB,&
 & 2.58700E-06_JPRB,2.65485E-06_JPRB,2.72393E-06_JPRB,2.79424E-06_JPRB,2.86580E-06_JPRB,&
 & 2.93861E-06_JPRB,3.01269E-06_JPRB,3.08803E-06_JPRB,3.16467E-06_JPRB,3.24259E-06_JPRB,&
 & 3.32181E-06_JPRB,3.40235E-06_JPRB,3.48420E-06_JPRB,3.56739E-06_JPRB,3.65192E-06_JPRB,&
 & 3.73779E-06_JPRB,3.82502E-06_JPRB,3.91362E-06_JPRB,4.00359E-06_JPRB,4.09494E-06_JPRB,&
 & 4.18768E-06_JPRB,4.28182E-06_JPRB,4.37737E-06_JPRB,4.47434E-06_JPRB,4.57273E-06_JPRB,&
 & 4.67254E-06_JPRB,4.77380E-06_JPRB,4.87651E-06_JPRB,4.98067E-06_JPRB,5.08630E-06_JPRB,&
 & 5.19339E-06_JPRB,5.30196E-06_JPRB,5.41201E-06_JPRB,5.52356E-06_JPRB,5.63660E-06_JPRB,&
 & 5.75116E-06_JPRB,5.86722E-06_JPRB,5.98479E-06_JPRB,6.10390E-06_JPRB,6.22453E-06_JPRB,&
 & 6.34669E-06_JPRB,6.47042E-06_JPRB,6.59569E-06_JPRB,6.72252E-06_JPRB,6.85090E-06_JPRB,&
 & 6.98085E-06_JPRB,7.11238E-06_JPRB,7.24549E-06_JPRB,7.38019E-06_JPRB,7.51646E-06_JPRB,&
 & 7.65434E-06_JPRB,7.79382E-06_JPRB,7.93490E-06_JPRB,8.07760E-06_JPRB,8.22192E-06_JPRB,&
 & 8.36784E-06_JPRB,8.51540E-06_JPRB,8.66459E-06_JPRB,8.81542E-06_JPRB,8.96786E-06_JPRB,&
 & 9.12197E-06_JPRB,9.27772E-06_JPRB,9.43513E-06_JPRB,9.59419E-06_JPRB,9.75490E-06_JPRB,&
 & 9.91728E-06_JPRB,1.00813E-05_JPRB,1.02471E-05_JPRB,1.04144E-05_JPRB,1.05835E-05_JPRB,&
 & 1.07543E-05_JPRB,1.09267E-05_JPRB,1.11008E-05_JPRB,1.12766E-05_JPRB,1.14541E-05_JPRB,&
 & 1.16333E-05_JPRB,1.18142E-05_JPRB,1.19969E-05_JPRB,1.21812E-05_JPRB,1.23672E-05_JPRB,&
 & 1.25549E-05_JPRB,1.27443E-05_JPRB,1.29355E-05_JPRB,1.31284E-05_JPRB,1.33229E-05_JPRB,&
 & 1.35193E-05_JPRB,1.37173E-05_JPRB,1.39170E-05_JPRB,1.41185E-05_JPRB,1.43217E-05_JPRB,&
 & 1.45267E-05_JPRB/)  

TOTPLNK( :, 9) = (/&
 & 2.61522E-08_JPRB,2.80613E-08_JPRB,3.00838E-08_JPRB,3.22250E-08_JPRB,3.44899E-08_JPRB,&
 & 3.68841E-08_JPRB,3.94129E-08_JPRB,4.20820E-08_JPRB,4.48973E-08_JPRB,4.78646E-08_JPRB,&
 & 5.09901E-08_JPRB,5.42799E-08_JPRB,5.77405E-08_JPRB,6.13784E-08_JPRB,6.52001E-08_JPRB,&
 & 6.92126E-08_JPRB,7.34227E-08_JPRB,7.78375E-08_JPRB,8.24643E-08_JPRB,8.73103E-08_JPRB,&
 & 9.23832E-08_JPRB,9.76905E-08_JPRB,1.03240E-07_JPRB,1.09039E-07_JPRB,1.15097E-07_JPRB,&
 & 1.21421E-07_JPRB,1.28020E-07_JPRB,1.34902E-07_JPRB,1.42075E-07_JPRB,1.49548E-07_JPRB,&
 & 1.57331E-07_JPRB,1.65432E-07_JPRB,1.73860E-07_JPRB,1.82624E-07_JPRB,1.91734E-07_JPRB,&
 & 2.01198E-07_JPRB,2.11028E-07_JPRB,2.21231E-07_JPRB,2.31818E-07_JPRB,2.42799E-07_JPRB,&
 & 2.54184E-07_JPRB,2.65983E-07_JPRB,2.78205E-07_JPRB,2.90862E-07_JPRB,3.03963E-07_JPRB,&
 & 3.17519E-07_JPRB,3.31541E-07_JPRB,3.46039E-07_JPRB,3.61024E-07_JPRB,3.76507E-07_JPRB,&
 & 3.92498E-07_JPRB,4.09008E-07_JPRB,4.26050E-07_JPRB,4.43633E-07_JPRB,4.61769E-07_JPRB,&
 & 4.80469E-07_JPRB,4.99744E-07_JPRB,5.19606E-07_JPRB,5.40067E-07_JPRB,5.61136E-07_JPRB,&
 & 5.82828E-07_JPRB,6.05152E-07_JPRB,6.28120E-07_JPRB,6.51745E-07_JPRB,6.76038E-07_JPRB,&
 & 7.01010E-07_JPRB,7.26674E-07_JPRB,7.53041E-07_JPRB,7.80124E-07_JPRB,8.07933E-07_JPRB,&
 & 8.36482E-07_JPRB,8.65781E-07_JPRB,8.95845E-07_JPRB,9.26683E-07_JPRB,9.58308E-07_JPRB,&
 & 9.90732E-07_JPRB,1.02397E-06_JPRB,1.05803E-06_JPRB,1.09292E-06_JPRB,1.12866E-06_JPRB,&
 & 1.16526E-06_JPRB,1.20274E-06_JPRB,1.24109E-06_JPRB,1.28034E-06_JPRB,1.32050E-06_JPRB,&
 & 1.36158E-06_JPRB,1.40359E-06_JPRB,1.44655E-06_JPRB,1.49046E-06_JPRB,1.53534E-06_JPRB,&
 & 1.58120E-06_JPRB,1.62805E-06_JPRB,1.67591E-06_JPRB,1.72478E-06_JPRB,1.77468E-06_JPRB,&
 & 1.82561E-06_JPRB,1.87760E-06_JPRB,1.93066E-06_JPRB,1.98479E-06_JPRB,2.04000E-06_JPRB,&
 & 2.09631E-06_JPRB,2.15373E-06_JPRB,2.21228E-06_JPRB,2.27196E-06_JPRB,2.33278E-06_JPRB,&
 & 2.39475E-06_JPRB,2.45790E-06_JPRB,2.52222E-06_JPRB,2.58773E-06_JPRB,2.65445E-06_JPRB,&
 & 2.72238E-06_JPRB,2.79152E-06_JPRB,2.86191E-06_JPRB,2.93354E-06_JPRB,3.00643E-06_JPRB,&
 & 3.08058E-06_JPRB,3.15601E-06_JPRB,3.23273E-06_JPRB,3.31075E-06_JPRB,3.39009E-06_JPRB,&
 & 3.47074E-06_JPRB,3.55272E-06_JPRB,3.63605E-06_JPRB,3.72072E-06_JPRB,3.80676E-06_JPRB,&
 & 3.89417E-06_JPRB,3.98297E-06_JPRB,4.07315E-06_JPRB,4.16474E-06_JPRB,4.25774E-06_JPRB,&
 & 4.35217E-06_JPRB,4.44802E-06_JPRB,4.54532E-06_JPRB,4.64406E-06_JPRB,4.74428E-06_JPRB,&
 & 4.84595E-06_JPRB,4.94911E-06_JPRB,5.05376E-06_JPRB,5.15990E-06_JPRB,5.26755E-06_JPRB,&
 & 5.37671E-06_JPRB,5.48741E-06_JPRB,5.59963E-06_JPRB,5.71340E-06_JPRB,5.82871E-06_JPRB,&
 & 5.94559E-06_JPRB,6.06403E-06_JPRB,6.18404E-06_JPRB,6.30565E-06_JPRB,6.42885E-06_JPRB,&
 & 6.55364E-06_JPRB,6.68004E-06_JPRB,6.80806E-06_JPRB,6.93771E-06_JPRB,7.06898E-06_JPRB,&
 & 7.20190E-06_JPRB,7.33646E-06_JPRB,7.47267E-06_JPRB,7.61056E-06_JPRB,7.75010E-06_JPRB,&
 & 7.89133E-06_JPRB,8.03423E-06_JPRB,8.17884E-06_JPRB,8.32514E-06_JPRB,8.47314E-06_JPRB,&
 & 8.62284E-06_JPRB,8.77427E-06_JPRB,8.92743E-06_JPRB,9.08231E-06_JPRB,9.23893E-06_JPRB,&
 & 9.39729E-06_JPRB,9.55741E-06_JPRB,9.71927E-06_JPRB,9.88291E-06_JPRB,1.00483E-05_JPRB,&
 & 1.02155E-05_JPRB,1.03844E-05_JPRB,1.05552E-05_JPRB,1.07277E-05_JPRB,1.09020E-05_JPRB,&
 & 1.10781E-05_JPRB/)  

TOTPLNK( :,10) = (/&
 & 8.89300E-09_JPRB,9.63263E-09_JPRB,1.04235E-08_JPRB,1.12685E-08_JPRB,1.21703E-08_JPRB,&
 & 1.31321E-08_JPRB,1.41570E-08_JPRB,1.52482E-08_JPRB,1.64090E-08_JPRB,1.76428E-08_JPRB,&
 & 1.89533E-08_JPRB,2.03441E-08_JPRB,2.18190E-08_JPRB,2.33820E-08_JPRB,2.50370E-08_JPRB,&
 & 2.67884E-08_JPRB,2.86402E-08_JPRB,3.05969E-08_JPRB,3.26632E-08_JPRB,3.48436E-08_JPRB,&
 & 3.71429E-08_JPRB,3.95660E-08_JPRB,4.21179E-08_JPRB,4.48040E-08_JPRB,4.76294E-08_JPRB,&
 & 5.05996E-08_JPRB,5.37201E-08_JPRB,5.69966E-08_JPRB,6.04349E-08_JPRB,6.40411E-08_JPRB,&
 & 6.78211E-08_JPRB,7.17812E-08_JPRB,7.59276E-08_JPRB,8.02670E-08_JPRB,8.48059E-08_JPRB,&
 & 8.95508E-08_JPRB,9.45090E-08_JPRB,9.96873E-08_JPRB,1.05093E-07_JPRB,1.10733E-07_JPRB,&
 & 1.16614E-07_JPRB,1.22745E-07_JPRB,1.29133E-07_JPRB,1.35786E-07_JPRB,1.42711E-07_JPRB,&
 & 1.49916E-07_JPRB,1.57410E-07_JPRB,1.65202E-07_JPRB,1.73298E-07_JPRB,1.81709E-07_JPRB,&
 & 1.90441E-07_JPRB,1.99505E-07_JPRB,2.08908E-07_JPRB,2.18660E-07_JPRB,2.28770E-07_JPRB,&
 & 2.39247E-07_JPRB,2.50101E-07_JPRB,2.61340E-07_JPRB,2.72974E-07_JPRB,2.85013E-07_JPRB,&
 & 2.97467E-07_JPRB,3.10345E-07_JPRB,3.23657E-07_JPRB,3.37413E-07_JPRB,3.51623E-07_JPRB,&
 & 3.66298E-07_JPRB,3.81448E-07_JPRB,3.97082E-07_JPRB,4.13212E-07_JPRB,4.29848E-07_JPRB,&
 & 4.47000E-07_JPRB,4.64680E-07_JPRB,4.82898E-07_JPRB,5.01664E-07_JPRB,5.20991E-07_JPRB,&
 & 5.40888E-07_JPRB,5.61369E-07_JPRB,5.82440E-07_JPRB,6.04118E-07_JPRB,6.26410E-07_JPRB,&
 & 6.49329E-07_JPRB,6.72887E-07_JPRB,6.97095E-07_JPRB,7.21964E-07_JPRB,7.47506E-07_JPRB,&
 & 7.73732E-07_JPRB,8.00655E-07_JPRB,8.28287E-07_JPRB,8.56635E-07_JPRB,8.85717E-07_JPRB,&
 & 9.15542E-07_JPRB,9.46122E-07_JPRB,9.77469E-07_JPRB,1.00960E-06_JPRB,1.04251E-06_JPRB,&
 & 1.07623E-06_JPRB,1.11077E-06_JPRB,1.14613E-06_JPRB,1.18233E-06_JPRB,1.21939E-06_JPRB,&
 & 1.25730E-06_JPRB,1.29610E-06_JPRB,1.33578E-06_JPRB,1.37636E-06_JPRB,1.41785E-06_JPRB,&
 & 1.46027E-06_JPRB,1.50362E-06_JPRB,1.54792E-06_JPRB,1.59319E-06_JPRB,1.63942E-06_JPRB,&
 & 1.68665E-06_JPRB,1.73487E-06_JPRB,1.78410E-06_JPRB,1.83435E-06_JPRB,1.88564E-06_JPRB,&
 & 1.93797E-06_JPRB,1.99136E-06_JPRB,2.04582E-06_JPRB,2.10137E-06_JPRB,2.15801E-06_JPRB,&
 & 2.21576E-06_JPRB,2.27463E-06_JPRB,2.33462E-06_JPRB,2.39577E-06_JPRB,2.45806E-06_JPRB,&
 & 2.52153E-06_JPRB,2.58617E-06_JPRB,2.65201E-06_JPRB,2.71905E-06_JPRB,2.78730E-06_JPRB,&
 & 2.85678E-06_JPRB,2.92749E-06_JPRB,2.99946E-06_JPRB,3.07269E-06_JPRB,3.14720E-06_JPRB,&
 & 3.22299E-06_JPRB,3.30007E-06_JPRB,3.37847E-06_JPRB,3.45818E-06_JPRB,3.53923E-06_JPRB,&
 & 3.62161E-06_JPRB,3.70535E-06_JPRB,3.79046E-06_JPRB,3.87695E-06_JPRB,3.96481E-06_JPRB,&
 & 4.05409E-06_JPRB,4.14477E-06_JPRB,4.23687E-06_JPRB,4.33040E-06_JPRB,4.42538E-06_JPRB,&
 & 4.52180E-06_JPRB,4.61969E-06_JPRB,4.71905E-06_JPRB,4.81991E-06_JPRB,4.92226E-06_JPRB,&
 & 5.02611E-06_JPRB,5.13148E-06_JPRB,5.23839E-06_JPRB,5.34681E-06_JPRB,5.45681E-06_JPRB,&
 & 5.56835E-06_JPRB,5.68146E-06_JPRB,5.79614E-06_JPRB,5.91242E-06_JPRB,6.03030E-06_JPRB,&
 & 6.14978E-06_JPRB,6.27088E-06_JPRB,6.39360E-06_JPRB,6.51798E-06_JPRB,6.64398E-06_JPRB,&
 & 6.77165E-06_JPRB,6.90099E-06_JPRB,7.03198E-06_JPRB,7.16468E-06_JPRB,7.29906E-06_JPRB,&
 & 7.43514E-06_JPRB,7.57294E-06_JPRB,7.71244E-06_JPRB,7.85369E-06_JPRB,7.99666E-06_JPRB,&
 & 8.14138E-06_JPRB/)  

TOTPLNK( :,11) = (/&
 & 2.53767E-09_JPRB,2.77242E-09_JPRB,3.02564E-09_JPRB,3.29851E-09_JPRB,3.59228E-09_JPRB,&
 & 3.90825E-09_JPRB,4.24777E-09_JPRB,4.61227E-09_JPRB,5.00322E-09_JPRB,5.42219E-09_JPRB,&
 & 5.87080E-09_JPRB,6.35072E-09_JPRB,6.86370E-09_JPRB,7.41159E-09_JPRB,7.99628E-09_JPRB,&
 & 8.61974E-09_JPRB,9.28404E-09_JPRB,9.99130E-09_JPRB,1.07437E-08_JPRB,1.15436E-08_JPRB,&
 & 1.23933E-08_JPRB,1.32953E-08_JPRB,1.42522E-08_JPRB,1.52665E-08_JPRB,1.63410E-08_JPRB,&
 & 1.74786E-08_JPRB,1.86820E-08_JPRB,1.99542E-08_JPRB,2.12985E-08_JPRB,2.27179E-08_JPRB,&
 & 2.42158E-08_JPRB,2.57954E-08_JPRB,2.74604E-08_JPRB,2.92141E-08_JPRB,3.10604E-08_JPRB,&
 & 3.30029E-08_JPRB,3.50457E-08_JPRB,3.71925E-08_JPRB,3.94476E-08_JPRB,4.18149E-08_JPRB,&
 & 4.42991E-08_JPRB,4.69043E-08_JPRB,4.96352E-08_JPRB,5.24961E-08_JPRB,5.54921E-08_JPRB,&
 & 5.86277E-08_JPRB,6.19081E-08_JPRB,6.53381E-08_JPRB,6.89231E-08_JPRB,7.26681E-08_JPRB,&
 & 7.65788E-08_JPRB,8.06604E-08_JPRB,8.49187E-08_JPRB,8.93591E-08_JPRB,9.39879E-08_JPRB,&
 & 9.88106E-08_JPRB,1.03834E-07_JPRB,1.09063E-07_JPRB,1.14504E-07_JPRB,1.20165E-07_JPRB,&
 & 1.26051E-07_JPRB,1.32169E-07_JPRB,1.38525E-07_JPRB,1.45128E-07_JPRB,1.51982E-07_JPRB,&
 & 1.59096E-07_JPRB,1.66477E-07_JPRB,1.74132E-07_JPRB,1.82068E-07_JPRB,1.90292E-07_JPRB,&
 & 1.98813E-07_JPRB,2.07638E-07_JPRB,2.16775E-07_JPRB,2.26231E-07_JPRB,2.36015E-07_JPRB,&
 & 2.46135E-07_JPRB,2.56599E-07_JPRB,2.67415E-07_JPRB,2.78592E-07_JPRB,2.90137E-07_JPRB,&
 & 3.02061E-07_JPRB,3.14371E-07_JPRB,3.27077E-07_JPRB,3.40186E-07_JPRB,3.53710E-07_JPRB,&
 & 3.67655E-07_JPRB,3.82031E-07_JPRB,3.96848E-07_JPRB,4.12116E-07_JPRB,4.27842E-07_JPRB,&
 & 4.44039E-07_JPRB,4.60713E-07_JPRB,4.77876E-07_JPRB,4.95537E-07_JPRB,5.13706E-07_JPRB,&
 & 5.32392E-07_JPRB,5.51608E-07_JPRB,5.71360E-07_JPRB,5.91662E-07_JPRB,6.12521E-07_JPRB,&
 & 6.33950E-07_JPRB,6.55958E-07_JPRB,6.78556E-07_JPRB,7.01753E-07_JPRB,7.25562E-07_JPRB,&
 & 7.49992E-07_JPRB,7.75055E-07_JPRB,8.00760E-07_JPRB,8.27120E-07_JPRB,8.54145E-07_JPRB,&
 & 8.81845E-07_JPRB,9.10233E-07_JPRB,9.39318E-07_JPRB,9.69113E-07_JPRB,9.99627E-07_JPRB,&
 & 1.03087E-06_JPRB,1.06286E-06_JPRB,1.09561E-06_JPRB,1.12912E-06_JPRB,1.16340E-06_JPRB,&
 & 1.19848E-06_JPRB,1.23435E-06_JPRB,1.27104E-06_JPRB,1.30855E-06_JPRB,1.34690E-06_JPRB,&
 & 1.38609E-06_JPRB,1.42614E-06_JPRB,1.46706E-06_JPRB,1.50886E-06_JPRB,1.55155E-06_JPRB,&
 & 1.59515E-06_JPRB,1.63967E-06_JPRB,1.68512E-06_JPRB,1.73150E-06_JPRB,1.77884E-06_JPRB,&
 & 1.82715E-06_JPRB,1.87643E-06_JPRB,1.92670E-06_JPRB,1.97797E-06_JPRB,2.03026E-06_JPRB,&
 & 2.08356E-06_JPRB,2.13791E-06_JPRB,2.19330E-06_JPRB,2.24975E-06_JPRB,2.30728E-06_JPRB,&
 & 2.36589E-06_JPRB,2.42560E-06_JPRB,2.48641E-06_JPRB,2.54835E-06_JPRB,2.61142E-06_JPRB,&
 & 2.67563E-06_JPRB,2.74100E-06_JPRB,2.80754E-06_JPRB,2.87526E-06_JPRB,2.94417E-06_JPRB,&
 & 3.01429E-06_JPRB,3.08562E-06_JPRB,3.15819E-06_JPRB,3.23199E-06_JPRB,3.30704E-06_JPRB,&
 & 3.38336E-06_JPRB,3.46096E-06_JPRB,3.53984E-06_JPRB,3.62002E-06_JPRB,3.70151E-06_JPRB,&
 & 3.78433E-06_JPRB,3.86848E-06_JPRB,3.95399E-06_JPRB,4.04084E-06_JPRB,4.12907E-06_JPRB,&
 & 4.21868E-06_JPRB,4.30968E-06_JPRB,4.40209E-06_JPRB,4.49592E-06_JPRB,4.59117E-06_JPRB,&
 & 4.68786E-06_JPRB,4.78600E-06_JPRB,4.88561E-06_JPRB,4.98669E-06_JPRB,5.08926E-06_JPRB,&
 & 5.19332E-06_JPRB/)  

TOTPLNK( :,12) = (/&
 & 2.73921E-10_JPRB,3.04500E-10_JPRB,3.38056E-10_JPRB,3.74835E-10_JPRB,4.15099E-10_JPRB,&
 & 4.59126E-10_JPRB,5.07214E-10_JPRB,5.59679E-10_JPRB,6.16857E-10_JPRB,6.79103E-10_JPRB,&
 & 7.46796E-10_JPRB,8.20335E-10_JPRB,9.00144E-10_JPRB,9.86671E-10_JPRB,1.08039E-09_JPRB,&
 & 1.18180E-09_JPRB,1.29142E-09_JPRB,1.40982E-09_JPRB,1.53757E-09_JPRB,1.67529E-09_JPRB,&
 & 1.82363E-09_JPRB,1.98327E-09_JPRB,2.15492E-09_JPRB,2.33932E-09_JPRB,2.53726E-09_JPRB,&
 & 2.74957E-09_JPRB,2.97710E-09_JPRB,3.22075E-09_JPRB,3.48145E-09_JPRB,3.76020E-09_JPRB,&
 & 4.05801E-09_JPRB,4.37595E-09_JPRB,4.71513E-09_JPRB,5.07672E-09_JPRB,5.46193E-09_JPRB,&
 & 5.87201E-09_JPRB,6.30827E-09_JPRB,6.77205E-09_JPRB,7.26480E-09_JPRB,7.78794E-09_JPRB,&
 & 8.34304E-09_JPRB,8.93163E-09_JPRB,9.55537E-09_JPRB,1.02159E-08_JPRB,1.09151E-08_JPRB,&
 & 1.16547E-08_JPRB,1.24365E-08_JPRB,1.32625E-08_JPRB,1.41348E-08_JPRB,1.50554E-08_JPRB,&
 & 1.60264E-08_JPRB,1.70500E-08_JPRB,1.81285E-08_JPRB,1.92642E-08_JPRB,2.04596E-08_JPRB,&
 & 2.17171E-08_JPRB,2.30394E-08_JPRB,2.44289E-08_JPRB,2.58885E-08_JPRB,2.74209E-08_JPRB,&
 & 2.90290E-08_JPRB,3.07157E-08_JPRB,3.24841E-08_JPRB,3.43371E-08_JPRB,3.62782E-08_JPRB,&
 & 3.83103E-08_JPRB,4.04371E-08_JPRB,4.26617E-08_JPRB,4.49878E-08_JPRB,4.74190E-08_JPRB,&
 & 4.99589E-08_JPRB,5.26113E-08_JPRB,5.53801E-08_JPRB,5.82692E-08_JPRB,6.12826E-08_JPRB,&
 & 6.44245E-08_JPRB,6.76991E-08_JPRB,7.11105E-08_JPRB,7.46634E-08_JPRB,7.83621E-08_JPRB,&
 & 8.22112E-08_JPRB,8.62154E-08_JPRB,9.03795E-08_JPRB,9.47081E-08_JPRB,9.92066E-08_JPRB,&
 & 1.03879E-07_JPRB,1.08732E-07_JPRB,1.13770E-07_JPRB,1.18998E-07_JPRB,1.24422E-07_JPRB,&
 & 1.30048E-07_JPRB,1.35880E-07_JPRB,1.41924E-07_JPRB,1.48187E-07_JPRB,1.54675E-07_JPRB,&
 & 1.61392E-07_JPRB,1.68346E-07_JPRB,1.75543E-07_JPRB,1.82988E-07_JPRB,1.90688E-07_JPRB,&
 & 1.98650E-07_JPRB,2.06880E-07_JPRB,2.15385E-07_JPRB,2.24172E-07_JPRB,2.33247E-07_JPRB,&
 & 2.42617E-07_JPRB,2.52289E-07_JPRB,2.62272E-07_JPRB,2.72571E-07_JPRB,2.83193E-07_JPRB,&
 & 2.94147E-07_JPRB,3.05440E-07_JPRB,3.17080E-07_JPRB,3.29074E-07_JPRB,3.41430E-07_JPRB,&
 & 3.54155E-07_JPRB,3.67259E-07_JPRB,3.80747E-07_JPRB,3.94631E-07_JPRB,4.08916E-07_JPRB,&
 & 4.23611E-07_JPRB,4.38725E-07_JPRB,4.54267E-07_JPRB,4.70245E-07_JPRB,4.86666E-07_JPRB,&
 & 5.03541E-07_JPRB,5.20879E-07_JPRB,5.38687E-07_JPRB,5.56975E-07_JPRB,5.75751E-07_JPRB,&
 & 5.95026E-07_JPRB,6.14808E-07_JPRB,6.35107E-07_JPRB,6.55932E-07_JPRB,6.77293E-07_JPRB,&
 & 6.99197E-07_JPRB,7.21656E-07_JPRB,7.44681E-07_JPRB,7.68278E-07_JPRB,7.92460E-07_JPRB,&
 & 8.17235E-07_JPRB,8.42614E-07_JPRB,8.68606E-07_JPRB,8.95223E-07_JPRB,9.22473E-07_JPRB,&
 & 9.50366E-07_JPRB,9.78915E-07_JPRB,1.00813E-06_JPRB,1.03802E-06_JPRB,1.06859E-06_JPRB,&
 & 1.09986E-06_JPRB,1.13184E-06_JPRB,1.16453E-06_JPRB,1.19796E-06_JPRB,1.23212E-06_JPRB,&
 & 1.26703E-06_JPRB,1.30270E-06_JPRB,1.33915E-06_JPRB,1.37637E-06_JPRB,1.41440E-06_JPRB,&
 & 1.45322E-06_JPRB,1.49286E-06_JPRB,1.53333E-06_JPRB,1.57464E-06_JPRB,1.61679E-06_JPRB,&
 & 1.65981E-06_JPRB,1.70370E-06_JPRB,1.74847E-06_JPRB,1.79414E-06_JPRB,1.84071E-06_JPRB,&
 & 1.88821E-06_JPRB,1.93663E-06_JPRB,1.98599E-06_JPRB,2.03631E-06_JPRB,2.08759E-06_JPRB,&
 & 2.13985E-06_JPRB,2.19310E-06_JPRB,2.24734E-06_JPRB,2.30260E-06_JPRB,2.35888E-06_JPRB,&
 & 2.41619E-06_JPRB/)  

TOTPLNK( :,13) = (/&
 & 4.53634E-11_JPRB,5.11435E-11_JPRB,5.75754E-11_JPRB,6.47222E-11_JPRB,7.26531E-11_JPRB,&
 & 8.14420E-11_JPRB,9.11690E-11_JPRB,1.01921E-10_JPRB,1.13790E-10_JPRB,1.26877E-10_JPRB,&
 & 1.41288E-10_JPRB,1.57140E-10_JPRB,1.74555E-10_JPRB,1.93665E-10_JPRB,2.14613E-10_JPRB,&
 & 2.37548E-10_JPRB,2.62633E-10_JPRB,2.90039E-10_JPRB,3.19948E-10_JPRB,3.52558E-10_JPRB,&
 & 3.88073E-10_JPRB,4.26716E-10_JPRB,4.68719E-10_JPRB,5.14331E-10_JPRB,5.63815E-10_JPRB,&
 & 6.17448E-10_JPRB,6.75526E-10_JPRB,7.38358E-10_JPRB,8.06277E-10_JPRB,8.79625E-10_JPRB,&
 & 9.58770E-10_JPRB,1.04410E-09_JPRB,1.13602E-09_JPRB,1.23495E-09_JPRB,1.34135E-09_JPRB,&
 & 1.45568E-09_JPRB,1.57845E-09_JPRB,1.71017E-09_JPRB,1.85139E-09_JPRB,2.00268E-09_JPRB,&
 & 2.16464E-09_JPRB,2.33789E-09_JPRB,2.52309E-09_JPRB,2.72093E-09_JPRB,2.93212E-09_JPRB,&
 & 3.15740E-09_JPRB,3.39757E-09_JPRB,3.65341E-09_JPRB,3.92579E-09_JPRB,4.21559E-09_JPRB,&
 & 4.52372E-09_JPRB,4.85115E-09_JPRB,5.19886E-09_JPRB,5.56788E-09_JPRB,5.95928E-09_JPRB,&
 & 6.37419E-09_JPRB,6.81375E-09_JPRB,7.27917E-09_JPRB,7.77168E-09_JPRB,8.29256E-09_JPRB,&
 & 8.84317E-09_JPRB,9.42487E-09_JPRB,1.00391E-08_JPRB,1.06873E-08_JPRB,1.13710E-08_JPRB,&
 & 1.20919E-08_JPRB,1.28515E-08_JPRB,1.36514E-08_JPRB,1.44935E-08_JPRB,1.53796E-08_JPRB,&
 & 1.63114E-08_JPRB,1.72909E-08_JPRB,1.83201E-08_JPRB,1.94008E-08_JPRB,2.05354E-08_JPRB,&
 & 2.17258E-08_JPRB,2.29742E-08_JPRB,2.42830E-08_JPRB,2.56545E-08_JPRB,2.70910E-08_JPRB,&
 & 2.85950E-08_JPRB,3.01689E-08_JPRB,3.18155E-08_JPRB,3.35373E-08_JPRB,3.53372E-08_JPRB,&
 & 3.72177E-08_JPRB,3.91818E-08_JPRB,4.12325E-08_JPRB,4.33727E-08_JPRB,4.56056E-08_JPRB,&
 & 4.79342E-08_JPRB,5.03617E-08_JPRB,5.28915E-08_JPRB,5.55270E-08_JPRB,5.82715E-08_JPRB,&
 & 6.11286E-08_JPRB,6.41019E-08_JPRB,6.71951E-08_JPRB,7.04119E-08_JPRB,7.37560E-08_JPRB,&
 & 7.72315E-08_JPRB,8.08424E-08_JPRB,8.45927E-08_JPRB,8.84866E-08_JPRB,9.25281E-08_JPRB,&
 & 9.67218E-08_JPRB,1.01072E-07_JPRB,1.05583E-07_JPRB,1.10260E-07_JPRB,1.15107E-07_JPRB,&
 & 1.20128E-07_JPRB,1.25330E-07_JPRB,1.30716E-07_JPRB,1.36291E-07_JPRB,1.42061E-07_JPRB,&
 & 1.48031E-07_JPRB,1.54206E-07_JPRB,1.60592E-07_JPRB,1.67192E-07_JPRB,1.74015E-07_JPRB,&
 & 1.81064E-07_JPRB,1.88345E-07_JPRB,1.95865E-07_JPRB,2.03628E-07_JPRB,2.11643E-07_JPRB,&
 & 2.19912E-07_JPRB,2.28443E-07_JPRB,2.37244E-07_JPRB,2.46318E-07_JPRB,2.55673E-07_JPRB,&
 & 2.65316E-07_JPRB,2.75252E-07_JPRB,2.85489E-07_JPRB,2.96033E-07_JPRB,3.06891E-07_JPRB,&
 & 3.18070E-07_JPRB,3.29576E-07_JPRB,3.41417E-07_JPRB,3.53600E-07_JPRB,3.66133E-07_JPRB,&
 & 3.79021E-07_JPRB,3.92274E-07_JPRB,4.05897E-07_JPRB,4.19899E-07_JPRB,4.34288E-07_JPRB,&
 & 4.49071E-07_JPRB,4.64255E-07_JPRB,4.79850E-07_JPRB,4.95863E-07_JPRB,5.12300E-07_JPRB,&
 & 5.29172E-07_JPRB,5.46486E-07_JPRB,5.64250E-07_JPRB,5.82473E-07_JPRB,6.01164E-07_JPRB,&
 & 6.20329E-07_JPRB,6.39979E-07_JPRB,6.60122E-07_JPRB,6.80767E-07_JPRB,7.01922E-07_JPRB,&
 & 7.23596E-07_JPRB,7.45800E-07_JPRB,7.68539E-07_JPRB,7.91826E-07_JPRB,8.15669E-07_JPRB,&
 & 8.40076E-07_JPRB,8.65058E-07_JPRB,8.90623E-07_JPRB,9.16783E-07_JPRB,9.43544E-07_JPRB,&
 & 9.70917E-07_JPRB,9.98912E-07_JPRB,1.02754E-06_JPRB,1.05681E-06_JPRB,1.08673E-06_JPRB,&
 & 1.11731E-06_JPRB,1.14856E-06_JPRB,1.18050E-06_JPRB,1.21312E-06_JPRB,1.24645E-06_JPRB,&
 & 1.28049E-06_JPRB/)  

TOTPLNK( :,14) = (/&
 & 1.40113E-11_JPRB,1.59358E-11_JPRB,1.80960E-11_JPRB,2.05171E-11_JPRB,2.32266E-11_JPRB,&
 & 2.62546E-11_JPRB,2.96335E-11_JPRB,3.33990E-11_JPRB,3.75896E-11_JPRB,4.22469E-11_JPRB,&
 & 4.74164E-11_JPRB,5.31466E-11_JPRB,5.94905E-11_JPRB,6.65054E-11_JPRB,7.42522E-11_JPRB,&
 & 8.27975E-11_JPRB,9.22122E-11_JPRB,1.02573E-10_JPRB,1.13961E-10_JPRB,1.26466E-10_JPRB,&
 & 1.40181E-10_JPRB,1.55206E-10_JPRB,1.71651E-10_JPRB,1.89630E-10_JPRB,2.09265E-10_JPRB,&
 & 2.30689E-10_JPRB,2.54040E-10_JPRB,2.79467E-10_JPRB,3.07128E-10_JPRB,3.37190E-10_JPRB,&
 & 3.69833E-10_JPRB,4.05243E-10_JPRB,4.43623E-10_JPRB,4.85183E-10_JPRB,5.30149E-10_JPRB,&
 & 5.78755E-10_JPRB,6.31255E-10_JPRB,6.87910E-10_JPRB,7.49002E-10_JPRB,8.14824E-10_JPRB,&
 & 8.85687E-10_JPRB,9.61914E-10_JPRB,1.04385E-09_JPRB,1.13186E-09_JPRB,1.22631E-09_JPRB,&
 & 1.32761E-09_JPRB,1.43617E-09_JPRB,1.55243E-09_JPRB,1.67686E-09_JPRB,1.80992E-09_JPRB,&
 & 1.95212E-09_JPRB,2.10399E-09_JPRB,2.26607E-09_JPRB,2.43895E-09_JPRB,2.62321E-09_JPRB,&
 & 2.81949E-09_JPRB,3.02844E-09_JPRB,3.25073E-09_JPRB,3.48707E-09_JPRB,3.73820E-09_JPRB,&
 & 4.00490E-09_JPRB,4.28794E-09_JPRB,4.58819E-09_JPRB,4.90647E-09_JPRB,5.24371E-09_JPRB,&
 & 5.60081E-09_JPRB,5.97875E-09_JPRB,6.37854E-09_JPRB,6.80120E-09_JPRB,7.24782E-09_JPRB,&
 & 7.71950E-09_JPRB,8.21740E-09_JPRB,8.74271E-09_JPRB,9.29666E-09_JPRB,9.88054E-09_JPRB,&
 & 1.04956E-08_JPRB,1.11434E-08_JPRB,1.18251E-08_JPRB,1.25422E-08_JPRB,1.32964E-08_JPRB,&
 & 1.40890E-08_JPRB,1.49217E-08_JPRB,1.57961E-08_JPRB,1.67140E-08_JPRB,1.76771E-08_JPRB,&
 & 1.86870E-08_JPRB,1.97458E-08_JPRB,2.08553E-08_JPRB,2.20175E-08_JPRB,2.32342E-08_JPRB,&
 & 2.45077E-08_JPRB,2.58401E-08_JPRB,2.72334E-08_JPRB,2.86900E-08_JPRB,3.02122E-08_JPRB,&
 & 3.18021E-08_JPRB,3.34624E-08_JPRB,3.51954E-08_JPRB,3.70037E-08_JPRB,3.88899E-08_JPRB,&
 & 4.08568E-08_JPRB,4.29068E-08_JPRB,4.50429E-08_JPRB,4.72678E-08_JPRB,4.95847E-08_JPRB,&
 & 5.19963E-08_JPRB,5.45058E-08_JPRB,5.71161E-08_JPRB,5.98309E-08_JPRB,6.26529E-08_JPRB,&
 & 6.55857E-08_JPRB,6.86327E-08_JPRB,7.17971E-08_JPRB,7.50829E-08_JPRB,7.84933E-08_JPRB,&
 & 8.20323E-08_JPRB,8.57035E-08_JPRB,8.95105E-08_JPRB,9.34579E-08_JPRB,9.75488E-08_JPRB,&
 & 1.01788E-07_JPRB,1.06179E-07_JPRB,1.10727E-07_JPRB,1.15434E-07_JPRB,1.20307E-07_JPRB,&
 & 1.25350E-07_JPRB,1.30566E-07_JPRB,1.35961E-07_JPRB,1.41539E-07_JPRB,1.47304E-07_JPRB,&
 & 1.53263E-07_JPRB,1.59419E-07_JPRB,1.65778E-07_JPRB,1.72345E-07_JPRB,1.79124E-07_JPRB,&
 & 1.86122E-07_JPRB,1.93343E-07_JPRB,2.00792E-07_JPRB,2.08476E-07_JPRB,2.16400E-07_JPRB,&
 & 2.24568E-07_JPRB,2.32988E-07_JPRB,2.41666E-07_JPRB,2.50605E-07_JPRB,2.59813E-07_JPRB,&
 & 2.69297E-07_JPRB,2.79060E-07_JPRB,2.89111E-07_JPRB,2.99455E-07_JPRB,3.10099E-07_JPRB,&
 & 3.21049E-07_JPRB,3.32311E-07_JPRB,3.43893E-07_JPRB,3.55801E-07_JPRB,3.68041E-07_JPRB,&
 & 3.80621E-07_JPRB,3.93547E-07_JPRB,4.06826E-07_JPRB,4.20465E-07_JPRB,4.34473E-07_JPRB,&
 & 4.48856E-07_JPRB,4.63620E-07_JPRB,4.78774E-07_JPRB,4.94325E-07_JPRB,5.10280E-07_JPRB,&
 & 5.26648E-07_JPRB,5.43436E-07_JPRB,5.60652E-07_JPRB,5.78302E-07_JPRB,5.96397E-07_JPRB,&
 & 6.14943E-07_JPRB,6.33949E-07_JPRB,6.53421E-07_JPRB,6.73370E-07_JPRB,6.93803E-07_JPRB,&
 & 7.14731E-07_JPRB,7.36157E-07_JPRB,7.58095E-07_JPRB,7.80549E-07_JPRB,8.03533E-07_JPRB,&
 & 8.27050E-07_JPRB/)  

TOTPLNK( :,15) = (/&
 & 3.90483E-12_JPRB,4.47999E-12_JPRB,5.13122E-12_JPRB,5.86739E-12_JPRB,6.69829E-12_JPRB,&
 & 7.63467E-12_JPRB,8.68833E-12_JPRB,9.87221E-12_JPRB,1.12005E-11_JPRB,1.26885E-11_JPRB,&
 & 1.43534E-11_JPRB,1.62134E-11_JPRB,1.82888E-11_JPRB,2.06012E-11_JPRB,2.31745E-11_JPRB,&
 & 2.60343E-11_JPRB,2.92087E-11_JPRB,3.27277E-11_JPRB,3.66242E-11_JPRB,4.09334E-11_JPRB,&
 & 4.56935E-11_JPRB,5.09455E-11_JPRB,5.67338E-11_JPRB,6.31057E-11_JPRB,7.01127E-11_JPRB,&
 & 7.78096E-11_JPRB,8.62554E-11_JPRB,9.55130E-11_JPRB,1.05651E-10_JPRB,1.16740E-10_JPRB,&
 & 1.28858E-10_JPRB,1.42089E-10_JPRB,1.56519E-10_JPRB,1.72243E-10_JPRB,1.89361E-10_JPRB,&
 & 2.07978E-10_JPRB,2.28209E-10_JPRB,2.50173E-10_JPRB,2.73999E-10_JPRB,2.99820E-10_JPRB,&
 & 3.27782E-10_JPRB,3.58034E-10_JPRB,3.90739E-10_JPRB,4.26067E-10_JPRB,4.64196E-10_JPRB,&
 & 5.05317E-10_JPRB,5.49631E-10_JPRB,5.97347E-10_JPRB,6.48689E-10_JPRB,7.03891E-10_JPRB,&
 & 7.63201E-10_JPRB,8.26876E-10_JPRB,8.95192E-10_JPRB,9.68430E-10_JPRB,1.04690E-09_JPRB,&
 & 1.13091E-09_JPRB,1.22079E-09_JPRB,1.31689E-09_JPRB,1.41957E-09_JPRB,1.52922E-09_JPRB,&
 & 1.64623E-09_JPRB,1.77101E-09_JPRB,1.90401E-09_JPRB,2.04567E-09_JPRB,2.19647E-09_JPRB,&
 & 2.35690E-09_JPRB,2.52749E-09_JPRB,2.70875E-09_JPRB,2.90127E-09_JPRB,3.10560E-09_JPRB,&
 & 3.32238E-09_JPRB,3.55222E-09_JPRB,3.79578E-09_JPRB,4.05375E-09_JPRB,4.32682E-09_JPRB,&
 & 4.61574E-09_JPRB,4.92128E-09_JPRB,5.24420E-09_JPRB,5.58536E-09_JPRB,5.94558E-09_JPRB,&
 & 6.32575E-09_JPRB,6.72678E-09_JPRB,7.14964E-09_JPRB,7.59526E-09_JPRB,8.06470E-09_JPRB,&
 & 8.55897E-09_JPRB,9.07916E-09_JPRB,9.62638E-09_JPRB,1.02018E-08_JPRB,1.08066E-08_JPRB,&
 & 1.14420E-08_JPRB,1.21092E-08_JPRB,1.28097E-08_JPRB,1.35446E-08_JPRB,1.43155E-08_JPRB,&
 & 1.51237E-08_JPRB,1.59708E-08_JPRB,1.68581E-08_JPRB,1.77873E-08_JPRB,1.87599E-08_JPRB,&
 & 1.97777E-08_JPRB,2.08423E-08_JPRB,2.19555E-08_JPRB,2.31190E-08_JPRB,2.43348E-08_JPRB,&
 & 2.56045E-08_JPRB,2.69302E-08_JPRB,2.83140E-08_JPRB,2.97578E-08_JPRB,3.12636E-08_JPRB,&
 & 3.28337E-08_JPRB,3.44702E-08_JPRB,3.61755E-08_JPRB,3.79516E-08_JPRB,3.98012E-08_JPRB,&
 & 4.17265E-08_JPRB,4.37300E-08_JPRB,4.58143E-08_JPRB,4.79819E-08_JPRB,5.02355E-08_JPRB,&
 & 5.25777E-08_JPRB,5.50114E-08_JPRB,5.75393E-08_JPRB,6.01644E-08_JPRB,6.28896E-08_JPRB,&
 & 6.57177E-08_JPRB,6.86521E-08_JPRB,7.16959E-08_JPRB,7.48520E-08_JPRB,7.81239E-08_JPRB,&
 & 8.15148E-08_JPRB,8.50282E-08_JPRB,8.86675E-08_JPRB,9.24362E-08_JPRB,9.63380E-08_JPRB,&
 & 1.00376E-07_JPRB,1.04555E-07_JPRB,1.08878E-07_JPRB,1.13349E-07_JPRB,1.17972E-07_JPRB,&
 & 1.22751E-07_JPRB,1.27690E-07_JPRB,1.32793E-07_JPRB,1.38064E-07_JPRB,1.43508E-07_JPRB,&
 & 1.49129E-07_JPRB,1.54931E-07_JPRB,1.60920E-07_JPRB,1.67099E-07_JPRB,1.73473E-07_JPRB,&
 & 1.80046E-07_JPRB,1.86825E-07_JPRB,1.93812E-07_JPRB,2.01014E-07_JPRB,2.08436E-07_JPRB,&
 & 2.16082E-07_JPRB,2.23957E-07_JPRB,2.32067E-07_JPRB,2.40418E-07_JPRB,2.49013E-07_JPRB,&
 & 2.57860E-07_JPRB,2.66963E-07_JPRB,2.76328E-07_JPRB,2.85961E-07_JPRB,2.95868E-07_JPRB,&
 & 3.06053E-07_JPRB,3.16524E-07_JPRB,3.27286E-07_JPRB,3.38345E-07_JPRB,3.49707E-07_JPRB,&
 & 3.61379E-07_JPRB,3.73367E-07_JPRB,3.85676E-07_JPRB,3.98315E-07_JPRB,4.11287E-07_JPRB,&
 & 4.24602E-07_JPRB,4.38265E-07_JPRB,4.52283E-07_JPRB,4.66662E-07_JPRB,4.81410E-07_JPRB,&
 & 4.96535E-07_JPRB/)  

TOTPLNK(1:50,16) = (/ &
   &  0.28639E-12_JPRB,0.33349E-12_JPRB,0.38764E-12_JPRB,0.44977E-12_JPRB,0.52093E-12_JPRB, &
   &  0.60231E-12_JPRB,0.69522E-12_JPRB,0.80111E-12_JPRB,0.92163E-12_JPRB,0.10586E-11_JPRB, &
   &  0.12139E-11_JPRB,0.13899E-11_JPRB,0.15890E-11_JPRB,0.18138E-11_JPRB,0.20674E-11_JPRB, &
   &  0.23531E-11_JPRB,0.26744E-11_JPRB,0.30352E-11_JPRB,0.34401E-11_JPRB,0.38936E-11_JPRB, &
   &  0.44011E-11_JPRB,0.49681E-11_JPRB,0.56010E-11_JPRB,0.63065E-11_JPRB,0.70919E-11_JPRB, &
   &  0.79654E-11_JPRB,0.89357E-11_JPRB,0.10012E-10_JPRB,0.11205E-10_JPRB,0.12526E-10_JPRB, &
   &  0.13986E-10_JPRB,0.15600E-10_JPRB,0.17380E-10_JPRB,0.19342E-10_JPRB,0.21503E-10_JPRB, &
   &  0.23881E-10_JPRB,0.26494E-10_JPRB,0.29362E-10_JPRB,0.32509E-10_JPRB,0.35958E-10_JPRB, &
   &  0.39733E-10_JPRB,0.43863E-10_JPRB,0.48376E-10_JPRB,0.53303E-10_JPRB,0.58679E-10_JPRB, &
   &  0.64539E-10_JPRB,0.70920E-10_JPRB,0.77864E-10_JPRB,0.85413E-10_JPRB,0.93615E-10_JPRB/)
TOTPLNK(51:100,16) = (/ &
   &  0.10252E-09_JPRB,0.11217E-09_JPRB,0.12264E-09_JPRB,0.13397E-09_JPRB,0.14624E-09_JPRB, &
   &  0.15950E-09_JPRB,0.17383E-09_JPRB,0.18930E-09_JPRB,0.20599E-09_JPRB,0.22399E-09_JPRB, &
   &  0.24339E-09_JPRB,0.26427E-09_JPRB,0.28674E-09_JPRB,0.31090E-09_JPRB,0.33686E-09_JPRB, &
   &  0.36474E-09_JPRB,0.39466E-09_JPRB,0.42676E-09_JPRB,0.46115E-09_JPRB,0.49800E-09_JPRB, &
   &  0.53744E-09_JPRB,0.57964E-09_JPRB,0.62476E-09_JPRB,0.67298E-09_JPRB,0.72448E-09_JPRB, &
   &  0.77945E-09_JPRB,0.83809E-09_JPRB,0.90062E-09_JPRB,0.96725E-09_JPRB,0.10382E-08_JPRB, &
   &  0.11138E-08_JPRB,0.11941E-08_JPRB,0.12796E-08_JPRB,0.13704E-08_JPRB,0.14669E-08_JPRB, &
   &  0.15694E-08_JPRB,0.16781E-08_JPRB,0.17934E-08_JPRB,0.19157E-08_JPRB,0.20453E-08_JPRB, &
   &  0.21825E-08_JPRB,0.23278E-08_JPRB,0.24815E-08_JPRB,0.26442E-08_JPRB,0.28161E-08_JPRB, &
   &  0.29978E-08_JPRB,0.31898E-08_JPRB,0.33925E-08_JPRB,0.36064E-08_JPRB,0.38321E-08_JPRB/)
TOTPLNK(101:150,16) = (/ &
   &  0.40700E-08_JPRB,0.43209E-08_JPRB,0.45852E-08_JPRB,0.48636E-08_JPRB,0.51567E-08_JPRB, &
   &  0.54652E-08_JPRB,0.57897E-08_JPRB,0.61310E-08_JPRB,0.64897E-08_JPRB,0.68667E-08_JPRB, &
   &  0.72626E-08_JPRB,0.76784E-08_JPRB,0.81148E-08_JPRB,0.85727E-08_JPRB,0.90530E-08_JPRB, &
   &  0.95566E-08_JPRB,0.10084E-07_JPRB,0.10638E-07_JPRB,0.11217E-07_JPRB,0.11824E-07_JPRB, &
   &  0.12458E-07_JPRB,0.13123E-07_JPRB,0.13818E-07_JPRB,0.14545E-07_JPRB,0.15305E-07_JPRB, &
   &  0.16099E-07_JPRB,0.16928E-07_JPRB,0.17795E-07_JPRB,0.18699E-07_JPRB,0.19643E-07_JPRB, &
   &  0.20629E-07_JPRB,0.21656E-07_JPRB,0.22728E-07_JPRB,0.23845E-07_JPRB,0.25010E-07_JPRB, &
   &  0.26223E-07_JPRB,0.27487E-07_JPRB,0.28804E-07_JPRB,0.30174E-07_JPRB,0.31600E-07_JPRB, &
   &  0.33084E-07_JPRB,0.34628E-07_JPRB,0.36233E-07_JPRB,0.37902E-07_JPRB,0.39637E-07_JPRB, &
   &  0.41440E-07_JPRB,0.43313E-07_JPRB,0.45259E-07_JPRB,0.47279E-07_JPRB,0.49376E-07_JPRB/)
TOTPLNK(151:181,16) = (/ &
   &  0.51552E-07_JPRB,0.53810E-07_JPRB,0.56153E-07_JPRB,0.58583E-07_JPRB,0.61102E-07_JPRB, &
   &  0.63713E-07_JPRB,0.66420E-07_JPRB,0.69224E-07_JPRB,0.72129E-07_JPRB,0.75138E-07_JPRB, &
   &  0.78254E-07_JPRB,0.81479E-07_JPRB,0.84818E-07_JPRB,0.88272E-07_JPRB,0.91846E-07_JPRB, &
   &  0.95543E-07_JPRB,0.99366E-07_JPRB,0.10332E-06_JPRB,0.10740E-06_JPRB,0.11163E-06_JPRB, &
   &  0.11599E-06_JPRB,0.12050E-06_JPRB,0.12515E-06_JPRB,0.12996E-06_JPRB,0.13493E-06_JPRB, &
   &  0.14005E-06_JPRB,0.14534E-06_JPRB,0.15080E-06_JPRB,0.15643E-06_JPRB,0.16224E-06_JPRB, &
   &  0.16823E-06_JPRB/)

!     -----------------------------------------------------------------
!IF (LHOOK) CALL DR_HOOK('SURRTPK',1,ZHOOK_HANDLE)
END SUBROUTINE SURRTPK
