!*******************************************************************************
SUBROUTINE RRTM_TAUMOL8 (KIDIA,KFDIA,KLEV,P_TAU,P_WX,&
 & P_TAUAERL,P_FAC00,P_FAC01,P_FAC10,P_FAC11,P_FORFAC,P_FORFRAC,K_INDFOR,K_JP,K_JT,K_JT1,&
 & P_COLH2O,P_COLO3,P_COLN2O,P_COLCO2,P_COLDRY,K_LAYTROP,P_SELFFAC,P_SELFFRAC,K_INDSELF,PFRAC, &
 & PMINORFRAC,KINDMINOR)  

!     BAND 8:  1080-1180 cm-1 (low (i.e.>~300mb) - H2O; high - O3)

!     AUTHOR.
!     -------
!      JJMorcrette, ECMWF

!     MODIFICATIONS.
!     --------------
!      M.Hamrud      01-Oct-2003 CY28 Cleaning
!      NEC           25-Oct-2007 Optimisations
!      JJMorcrette 20110613 flexible number of g-points
!      ABozzo 201306 updated to rrtmg v4.85
!     band 8:  1080-1180 cm-1 (low key - h2o; low minor - co2,o3,n2o)
!                             (high key - o3; high minor - co2, n2o)
! ---------------------------------------------------------------------------

USE PARKIND1  ,ONLY : JPIM     ,JPRB
!USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK

USE PARRRTM  , ONLY : JPBAND ,JPXSEC
USE YOERRTM  , ONLY : JPGPT  ,NG8   ,NGS7
USE YOERRTWN , ONLY : NSPA   ,NSPB
USE YOERRTA8 , ONLY : ABSA   ,ABSB   ,FRACREFA, FRACREFB,SELFREF,KA_MCO2 ,KB_MCO2  ,&
 & KA_MN2O , KB_MN2O,KA_MO3,CFC12  ,CFC22ADJ,FORREF  
USE YOERRTRF, ONLY : CHI_MLS

IMPLICIT NONE

INTEGER(KIND=JPIM),INTENT(IN)    :: KIDIA
INTEGER(KIND=JPIM),INTENT(IN)    :: KFDIA
INTEGER(KIND=JPIM),INTENT(IN)    :: KLEV 
REAL(KIND=JPRB)   ,INTENT(OUT)   :: P_TAU(KIDIA:KFDIA,JPGPT,KLEV) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_WX(KIDIA:KFDIA,JPXSEC,KLEV) ! Amount of trace gases
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_TAUAERL(KIDIA:KFDIA,KLEV,JPBAND) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_FAC00(KIDIA:KFDIA,KLEV) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_FAC01(KIDIA:KFDIA,KLEV) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_FAC10(KIDIA:KFDIA,KLEV) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_FAC11(KIDIA:KFDIA,KLEV) 
INTEGER(KIND=JPIM),INTENT(IN)    :: K_JP(KIDIA:KFDIA,KLEV) 
INTEGER(KIND=JPIM),INTENT(IN)    :: K_JT(KIDIA:KFDIA,KLEV) 
INTEGER(KIND=JPIM),INTENT(IN)    :: K_JT1(KIDIA:KFDIA,KLEV) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_COLH2O(KIDIA:KFDIA,KLEV) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_COLO3(KIDIA:KFDIA,KLEV) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_COLN2O(KIDIA:KFDIA,KLEV) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_COLCO2(KIDIA:KFDIA,KLEV) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_COLDRY(KIDIA:KFDIA,KLEV) 
INTEGER(KIND=JPIM),INTENT(IN)    :: K_LAYTROP(KIDIA:KFDIA) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_SELFFAC(KIDIA:KFDIA,KLEV) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_SELFFRAC(KIDIA:KFDIA,KLEV) 
INTEGER(KIND=JPIM),INTENT(IN)    :: K_INDSELF(KIDIA:KFDIA,KLEV) 
REAL(KIND=JPRB)   ,INTENT(OUT)   :: PFRAC(KIDIA:KFDIA,JPGPT,KLEV) 

INTEGER(KIND=JPIM),INTENT(IN)   :: K_INDFOR(KIDIA:KFDIA,KLEV)
REAL(KIND=JPRB)   ,INTENT(IN)   :: P_FORFRAC(KIDIA:KFDIA,KLEV) 
REAL(KIND=JPRB)   ,INTENT(IN)   :: P_FORFAC(KIDIA:KFDIA,KLEV) 
REAL(KIND=JPRB)   ,INTENT(IN)   :: PMINORFRAC(KIDIA:KFDIA,KLEV)
INTEGER(KIND=JPIM),INTENT(IN)   :: KINDMINOR(KIDIA:KFDIA,KLEV)

! ---------------------------------------------------------------------------

INTEGER(KIND=JPIM) :: IND0(KLEV),IND1(KLEV),INDS(KLEV),INDF(KLEV),INDM(KLEV)

INTEGER(KIND=JPIM) :: IG, JLAY
INTEGER(KIND=JPIM) :: JLON

REAL(KIND=JPRB) :: ZCHI_CO2, ZRATCO2, ZADJFAC, ZADJCOLCO2(KIDIA:KFDIA,KLEV)
REAL(KIND=JPRB) :: ZTAUFOR,ZTAUSELF, ZABSO3, ZABSCO2, ZABSN2O
!REAL(KIND=JPRB) :: ZHOOK_HANDLE

! Minor gas mapping level:
!     lower - co2, p = 1053.63 mb, t = 294.2 k
!     lower - o3,  p = 317.348 mb, t = 240.77 k
!     lower - n2o, p = 706.2720 mb, t= 278.94 k
!     lower - cfc12,cfc11
!     upper - co2, p = 35.1632 mb, t = 223.28 k
!     upper - n2o, p = 8.716e-2 mb, t = 226.03 k

! Compute the optical depth by interpolating in ln(pressure) and 
! temperature, and appropriate species.  Below laytrop, the water vapor 
! self-continuum and foreign continuum is interpolated (in temperature) 
! separately.

ASSOCIATE(NFLEVG=>KLEV)
!IF (LHOOK) CALL DR_HOOK('RRTM_TAUMOL8',0,ZHOOK_HANDLE)

DO JLAY = 1, KLEV
  DO JLON = KIDIA, KFDIA
    IF (JLAY <= K_LAYTROP(JLON)) THEN
! In atmospheres where the amount of CO2 is too great to be considered
! a minor species, adjust the column amount of CO2 by an empirical factor 
! to obtain the proper contribution.
      ZCHI_CO2 = P_COLCO2(JLON,JLAY)/P_COLDRY(JLON,JLAY)
      ZRATCO2 = 1.E20_JPRB*ZCHI_CO2/CHI_MLS(2,K_JP(JLON,JLAY)+1)
      IF (ZRATCO2 > 3.0_JPRB) THEN
         ZADJFAC = 2.0_JPRB+(ZRATCO2-2.0_JPRB)**0.65_JPRB
         ZADJCOLCO2(JLON,JLAY) = ZADJFAC*CHI_MLS(2,K_JP(JLON,JLAY)+1)*P_COLDRY(JLON,JLAY)*1.E-20_JPRB
      ELSE
         ZADJCOLCO2(JLON,JLAY) = P_COLCO2(JLON,JLAY)
      ENDIF

    
      IND0(JLAY) = ((K_JP(JLON,JLAY)-1)*5+(K_JT(JLON,JLAY)-1))*NSPA(8) + 1
      IND1(JLAY) = (K_JP(JLON,JLAY)*5+(K_JT1(JLON,JLAY)-1))*NSPA(8) + 1
      INDS(JLAY) = K_INDSELF(JLON,JLAY)
      INDF(JLAY) = K_INDFOR(JLON,JLAY)
      INDM(JLAY) = KINDMINOR(JLON,JLAY)
      
!-- DS_000515
!CDIR UNROLL=NG8
      DO IG = 1, NG8
!-- DS_000515
         ZTAUSELF = P_SELFFAC(JLON,JLAY)* (SELFREF(INDS(JLAY),IG) + P_SELFFRAC(JLON,JLAY) * &
           &      (SELFREF(INDS(JLAY)+1,IG) - SELFREF(INDS(JLAY),IG)))
         ZTAUFOR = P_FORFAC(JLON,JLAY) * (FORREF(INDF(JLAY),IG) + P_FORFRAC(JLON,JLAY) * &
           &      (FORREF(INDF(JLAY)+1,IG) - FORREF(INDF(JLAY),IG))) 
         ZABSCO2 =  (KA_MCO2(INDM(JLAY),IG) + PMINORFRAC(JLON,JLAY) * &
           &      (KA_MCO2(INDM(JLAY)+1,IG) - KA_MCO2(INDM(JLAY),IG)))
         ZABSO3 =  (KA_MO3(INDM(JLAY),IG) + PMINORFRAC(JLON,JLAY) * &
           &      (KA_MO3(INDM(JLAY)+1,IG) - KA_MO3(INDM(JLAY),IG)))
         ZABSN2O =  (KA_MN2O(INDM(JLAY),IG) + PMINORFRAC(JLON,JLAY) * &
           &      (KA_MN2O(INDM(JLAY)+1,IG) - KA_MN2O(INDM(JLAY),IG)))

        P_TAU(JLON,NGS7+IG,JLAY) = P_COLH2O(JLON,JLAY) *&
         & (P_FAC00(JLON,JLAY) * ABSA(IND0(JLAY)  ,IG) +&
         & P_FAC10(JLON,JLAY) * ABSA(IND0(JLAY)+1,IG) +&
         & P_FAC01(JLON,JLAY) * ABSA(IND1(JLAY)  ,IG) +&
         & P_FAC11(JLON,JLAY) * ABSA(IND1(JLAY)+1,IG)) &
         & + ZTAUSELF + ZTAUFOR &
         & + ZADJCOLCO2(JLON,JLAY)*ZABSCO2 &
         & + P_COLO3(JLON,JLAY)*ZABSO3 &
         & + P_COLN2O(JLON,JLAY)*ZABSN2O &
         & + P_WX(JLON,3,JLAY) * CFC12(IG)&
         & + P_WX(JLON,4,JLAY) * CFC22ADJ(IG)&
         & + P_TAUAERL(JLON,JLAY,8)  
        PFRAC(JLON,NGS7+IG,JLAY) = FRACREFA(IG)
      ENDDO
    ENDIF

    IF (JLAY > K_LAYTROP(JLON)) THEN

! In atmospheres where the amount of CO2 is too great to be considered
! a minor species, adjust the column amount of CO2 by an empirical factor 
! to obtain the proper contribution.
      ZCHI_CO2 = P_COLCO2(JLON,JLAY)/P_COLDRY(JLON,JLAY)
      ZRATCO2 = 1.E20_JPRB*ZCHI_CO2/CHI_MLS(2,K_JP(JLON,JLAY)+1)
      IF (ZRATCO2 > 3.0_JPRB) THEN
         ZADJFAC = 2.0_JPRB+(ZRATCO2-2.0_JPRB)**0.65_JPRB
         ZADJCOLCO2(JLON,JLAY) = ZADJFAC*CHI_MLS(2,K_JP(JLON,JLAY)+1)*P_COLDRY(JLON,JLAY)*1.E-20_JPRB
      ELSE
         ZADJCOLCO2(JLON,JLAY) = P_COLCO2(JLON,JLAY)
      ENDIF


      IND0(JLAY) = ((K_JP(JLON,JLAY)-13)*5+(K_JT(JLON,JLAY)-1))*NSPB(8) + 1
      IND1(JLAY) = ((K_JP(JLON,JLAY)-12)*5+(K_JT1(JLON,JLAY)-1))*NSPB(8) + 1
      INDM(JLAY) = KINDMINOR(JLON,JLAY)
!-- JJM_000517
!CDIR UNROLL=NG8
      DO IG = 1, NG8
!-- JJM_000517
        ZABSCO2 =  (KB_MCO2(INDM(JLAY),IG) + PMINORFRAC(JLON,JLAY) * &
         &        (KB_MCO2(INDM(JLAY)+1,IG) - KB_MCO2(INDM(JLAY),IG)))
        ZABSN2O =  (KB_MN2O(INDM(JLAY),IG) + PMINORFRAC(JLON,JLAY) * &
         &        (KB_MN2O(INDM(JLAY)+1,IG) - KB_MN2O(INDM(JLAY),IG)))
        P_TAU(JLON,NGS7+IG,JLAY) = P_COLO3(JLON,JLAY) *&
         & (P_FAC00(JLON,JLAY) * ABSB(IND0(JLAY)  ,IG) +&
         & P_FAC10(JLON,JLAY) * ABSB(IND0(JLAY)+1,IG) +&
         & P_FAC01(JLON,JLAY) * ABSB(IND1(JLAY)  ,IG) +&
         & P_FAC11(JLON,JLAY) * ABSB(IND1(JLAY)+1,IG)) &
         & + ZADJCOLCO2(JLON,JLAY)*ZABSCO2 &
         & + P_COLN2O(JLON,JLAY)*ZABSN2O &
         & + P_WX(JLON,3,JLAY) * CFC12(IG)&
         & + P_WX(JLON,4,JLAY) * CFC22ADJ(IG)&
         & + P_TAUAERL(JLON,JLAY,8)  
        PFRAC(JLON,NGS7+IG,JLAY) = FRACREFB(IG)
      ENDDO
    ENDIF
  ENDDO
ENDDO

!IF (LHOOK) CALL DR_HOOK('RRTM_TAUMOL8',1,ZHOOK_HANDLE)

END ASSOCIATE
END SUBROUTINE RRTM_TAUMOL8
