!******************************************************************************
SUBROUTINE RRTM_TAUMOL11 (KIDIA,KFDIA,KLEV,P_TAU,&
 & P_TAUAERL,P_FAC00,P_FAC01,P_FAC10,P_FAC11,P_FORFAC,P_FORFRAC,K_INDFOR,K_JP,K_JT,K_JT1,&
 & P_COLH2O,P_COLO2,K_LAYTROP,P_SELFFAC,P_SELFFRAC,K_INDSELF,PFRAC,P_MINORFRAC,KINDMINOR,PSCALEMINOR)  

!     BAND 11:  1480-1800 cm-1 (low - H2O; high - H2O)

!     AUTHOR.
!     -------
!      JJMorcrette, ECMWF

!     MODIFICATIONS.
!     --------------
!      M.Hamrud      01-Oct-2003 CY28 Cleaning
!      NEC           25-Oct-2007 Optimisations
!      JJMorcrette 20110613 flexible number of g-points
!      ABozzo updated to rrtmg v4.85
!     band 11:  1480-1800 cm-1 (low - h2o; low minor - o2)
!                              (high key - h2o; high minor - o2)
! ---------------------------------------------------------------------------

USE PARKIND1  ,ONLY : JPIM     ,JPRB
!USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK

USE PARRRTM  , ONLY : JPBAND
USE YOERRTM  , ONLY : JPGPT  ,NG11  ,NGS10
USE YOERRTWN , ONLY :      NSPA   ,NSPB
USE YOERRTA11, ONLY : ABSA   ,ABSB   ,FRACREFA, FRACREFB,SELFREF,FORREF, &
                     & KA_MO2, KB_MO2

IMPLICIT NONE

INTEGER(KIND=JPIM),INTENT(IN)    :: KIDIA
INTEGER(KIND=JPIM),INTENT(IN)    :: KFDIA
INTEGER(KIND=JPIM),INTENT(IN)    :: KLEV 
REAL(KIND=JPRB)   ,INTENT(OUT)   :: P_TAU(KIDIA:KFDIA,JPGPT,KLEV) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_TAUAERL(KIDIA:KFDIA,KLEV,JPBAND) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_FAC00(KIDIA:KFDIA,KLEV) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_FAC01(KIDIA:KFDIA,KLEV) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_FAC10(KIDIA:KFDIA,KLEV) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_FAC11(KIDIA:KFDIA,KLEV) 
INTEGER(KIND=JPIM),INTENT(IN)    :: K_JP(KIDIA:KFDIA,KLEV) 
INTEGER(KIND=JPIM),INTENT(IN)    :: K_JT(KIDIA:KFDIA,KLEV) 
INTEGER(KIND=JPIM),INTENT(IN)    :: K_JT1(KIDIA:KFDIA,KLEV) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_COLH2O(KIDIA:KFDIA,KLEV) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_COLO2(KIDIA:KFDIA,KLEV) 
INTEGER(KIND=JPIM),INTENT(IN)    :: K_LAYTROP(KIDIA:KFDIA) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_SELFFAC(KIDIA:KFDIA,KLEV) 
REAL(KIND=JPRB)   ,INTENT(IN)    :: P_SELFFRAC(KIDIA:KFDIA,KLEV) 
INTEGER(KIND=JPIM),INTENT(IN)    :: K_INDSELF(KIDIA:KFDIA,KLEV) 
REAL(KIND=JPRB)   ,INTENT(OUT)   :: PFRAC(KIDIA:KFDIA,JPGPT,KLEV) 

INTEGER(KIND=JPIM),INTENT(IN)   :: K_INDFOR(KIDIA:KFDIA,KLEV)
REAL(KIND=JPRB)   ,INTENT(IN)   :: P_FORFAC(KIDIA:KFDIA,KLEV) 
REAL(KIND=JPRB)   ,INTENT(IN)   :: P_FORFRAC(KIDIA:KFDIA,KLEV) 
REAL(KIND=JPRB)   ,INTENT(IN)   :: P_MINORFRAC(KIDIA:KFDIA,KLEV)
INTEGER(KIND=JPIM),INTENT(IN)   :: KINDMINOR(KIDIA:KFDIA,KLEV)
REAL(KIND=JPRB)   ,INTENT(IN)   :: PSCALEMINOR(KIDIA:KFDIA,KLEV)
! ---------------------------------------------------------------------------

INTEGER(KIND=JPIM) :: IND0(KLEV),IND1(KLEV)
INTEGER(KIND=JPIM) :: INDS(KLEV),INDF(KLEV),INDM(KLEV)

INTEGER(KIND=JPIM) :: IG, JLAY
INTEGER(KIND=JPIM) :: JLON
REAL(KIND=JPRB) :: ZTAUFOR,ZTAUSELF,ZSCALEO2, ZTAUO2
!REAL(KIND=JPRB) :: ZHOOK_HANDLE

! Minor gas mapping level :
!     lower - o2, p = 706.2720 mbar, t = 278.94 k
!     upper - o2, p = 4.758820 mbarm t = 250.85 k

!     Compute the optical depth by interpolating in ln(pressure) and 
!     temperature.  Below LAYTROP, the water vapor self-continuum and foreign continuum 
!     is interpolated (in temperature) separately.
  
ASSOCIATE(NFLEVG=>KLEV)
!IF (LHOOK) CALL DR_HOOK('RRTM_TAUMOL11',0,ZHOOK_HANDLE)

DO JLAY = 1, KLEV
  DO JLON = KIDIA, KFDIA
    IF (JLAY <= K_LAYTROP(JLON)) THEN
      IND0(JLAY) = ((K_JP(JLON,JLAY)-1)*5+(K_JT(JLON,JLAY)-1))*NSPA(11) + 1
      IND1(JLAY) = (K_JP(JLON,JLAY)*5+(K_JT1(JLON,JLAY)-1))*NSPA(11) + 1
      INDS(JLAY) = K_INDSELF(JLON,JLAY)
      INDF(JLAY) = K_INDFOR(JLON,JLAY)
      INDM(JLAY) = KINDMINOR(JLON,JLAY)
      ZSCALEO2 = P_COLO2(JLON,JLAY)*PSCALEMINOR(JLON,JLAY)
!-- DS_000515  
!CDIR UNROLL=NG11
      DO IG = 1, NG11
!-- DS_000515  
        ZTAUSELF = P_SELFFAC(JLON,JLAY) * (SELFREF(INDS(JLAY),IG) + &
     &           P_SELFFRAC(JLON,JLAY) * &
     &           (SELFREF(INDS(JLAY)+1,IG) - SELFREF(INDS(JLAY),IG))) 

        ZTAUFOR =  P_FORFAC(JLON,JLAY) * (FORREF(INDF(JLAY),IG) + &
     &           P_FORFRAC(JLON,JLAY) * (FORREF(INDF(JLAY)+1,IG) - &
     &           FORREF(INDF(JLAY),IG)))  
        ZTAUO2 = ZSCALEO2*(KA_MO2(INDM(JLAY),IG) +   &
     &           P_MINORFRAC(JLON,JLAY) * &
     &           (KA_MO2(INDM(JLAY)+1,IG) - KA_MO2(INDM(JLAY),IG))) 

        P_TAU(JLON,NGS10+IG,JLAY) = P_COLH2O(JLON,JLAY) *&
         & (P_FAC00(JLON,JLAY) * ABSA(IND0(JLAY)  ,IG) +&
         & P_FAC10(JLON,JLAY) * ABSA(IND0(JLAY)+1,IG) +&
         & P_FAC01(JLON,JLAY) * ABSA(IND1(JLAY)  ,IG) +&
         & P_FAC11(JLON,JLAY) * ABSA(IND1(JLAY)+1,IG)) +&
         & ZTAUSELF + ZTAUFOR + ZTAUO2 &
         & + P_TAUAERL(JLON,JLAY,11)  
        PFRAC(JLON,NGS10+IG,JLAY) = FRACREFA(IG)
      ENDDO
    ENDIF

    IF (JLAY > K_LAYTROP(JLON)) THEN
      IND0(JLAY) = ((K_JP(JLON,JLAY)-13)*5+(K_JT(JLON,JLAY)-1))*NSPB(11) + 1
      IND1(JLAY) = ((K_JP(JLON,JLAY)-12)*5+(K_JT1(JLON,JLAY)-1))*NSPB(11) + 1
      INDF(JLAY) = K_INDFOR(JLON,JLAY)
      INDM(JLAY) = KINDMINOR(JLON,JLAY)
      ZSCALEO2 = P_COLO2(JLON,JLAY) * PSCALEMINOR(JLON,JLAY)
!-- JJM_000517
!CDIR UNROLL=NG11
      DO IG = 1, NG11
!-- JJM_000517
        ZTAUFOR = P_FORFAC(JLON,JLAY) * (FORREF(INDF(JLAY),IG) + &
     &           P_FORFRAC(JLON,JLAY) * &
     &           (FORREF(INDF(JLAY)+1,IG) - FORREF(INDF(JLAY),IG))) 

        ZTAUO2 = ZSCALEO2*(KB_MO2(INDM(JLAY),IG) +  &
     &           P_MINORFRAC(JLON,JLAY) * &
     &           (KB_MO2(INDM(JLAY)+1,IG) - KB_MO2(INDM(JLAY),IG)))


        P_TAU(JLON,NGS10+IG,JLAY) = P_COLH2O(JLON,JLAY) *&
         & (P_FAC00(JLON,JLAY) * ABSB(IND0(JLAY)  ,IG) +&
         & P_FAC10(JLON,JLAY) * ABSB(IND0(JLAY)+1,IG) +&
         & P_FAC01(JLON,JLAY) * ABSB(IND1(JLAY)  ,IG) +&
         & P_FAC11(JLON,JLAY) * ABSB(IND1(JLAY)+1,IG)) +&
         & ZTAUFOR + ZTAUO2 + P_TAUAERL(JLON,JLAY,11)  
        PFRAC(JLON,NGS10+IG,JLAY) = FRACREFB(IG)
      ENDDO
    ENDIF
  ENDDO
ENDDO

!IF (LHOOK) CALL DR_HOOK('RRTM_TAUMOL11',1,ZHOOK_HANDLE)

END ASSOCIATE
END SUBROUTINE RRTM_TAUMOL11
