SUBROUTINE RRTM_KGB8

!     Originally by Eli J. Mlawer, Atmospheric & Environmental Research.
!     BAND 8:  1080-1180 cm-1 (low (i.e.>~300mb) - H2O; high - O3)
!     Reformatted for F90 by JJMorcrette, ECMWF
!     R. Elkhatib 12-10-2005 Split for faster and more robust compilation.
!     G.Mozdzynski March 2011 read constants from files
!     ABozzo updated to rrtmg v4.85
!     T. Wilhelmsson and K. Yessad (Oct 2013) Geometry and setup refactoring.
!     ------------------------------------------------------------------

USE PARKIND1  ,ONLY : JPRB
!USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE YOMLUN    ,ONLY : NULRAD
USE MPL_MODULE,ONLY : MPL_BROADCAST
USE YOMTAG    ,ONLY : MTAGRAD
USE YOMMP0    , ONLY : NPROC, MYPROC

USE YOERRTO8 , ONLY : KAO     ,KBO       ,KAO_D,KBO_D,SELFREFO ,FORREFO,FRACREFAO ,&
 & FRACREFBO, CFC12O  ,CFC22ADJO ,KAO_MCO2,KBO_MCO2,&
 & KAO_MN2O,KBO_MN2O,KAO_MO3  


!     ------------------------------------------------------------------

IMPLICIT NONE
!REAL(KIND=JPRB) :: ZHOOK_HANDLE

#include "abor1.intfb.h"

!IF (LHOOK) CALL DR_HOOK('RRTM_KGB8',0,ZHOOK_HANDLE)

IF( MYPROC==1 )THEN
  READ(NULRAD,ERR=1001) KAO_D,KBO_D
 ! Convert the data into model actual precision.
  KAO = REAL(KAO_D,JPRB)
  KBO = REAL(KBO_D,JPRB)
ENDIF
IF( NPROC>1 )THEN
  CALL MPL_BROADCAST (KAO,MTAGRAD,1,CDSTRING='RRTM_KGB8:')
  CALL MPL_BROADCAST (KBO,MTAGRAD,1,CDSTRING='RRTM_KGB8:')
ENDIF


! Planck fraction mapping level : P=473.4280 mb, T = 259.83 K
      FRACREFAO(:) = (/ &
      &  1.6004E-01_JPRB,1.5437E-01_JPRB,1.4502E-01_JPRB,1.3084E-01_JPRB,1.1523E-01_JPRB,9.7743E-02_JPRB, &
      &  8.0376E-02_JPRB,6.0261E-02_JPRB,4.1111E-02_JPRB,4.4772E-03_JPRB,3.6511E-03_JPRB,2.9154E-03_JPRB, &
      &  2.1184E-03_JPRB,1.3048E-03_JPRB,4.6637E-04_JPRB,6.5624E-05_JPRB/)

! Planck fraction mapping level : P=95.5835 mb, T= 215.7 K
      FRACREFBO(:) = (/ &
      &  1.4987E-01_JPRB,1.4665E-01_JPRB,1.4154E-01_JPRB,1.3200E-01_JPRB,1.1902E-01_JPRB,1.0352E-01_JPRB, &
      &  8.4939E-02_JPRB,6.4105E-02_JPRB,4.3190E-02_JPRB,4.5129E-03_JPRB,3.7656E-03_JPRB,2.8733E-03_JPRB, &
      &  2.0947E-03_JPRB,1.3201E-03_JPRB,5.1832E-04_JPRB,7.7473E-05_JPRB/)

! Minor gas mapping level:
!     lower - co2, p = 1053.63 mb, t = 294.2 k
!     lower - o3,  p = 317.348 mb, t = 240.77 k
!     lower - n2o, p = 706.2720 mb, t= 278.94 k
!     lower - cfc12,cfc11
!     upper - co2, p = 35.1632 mb, t = 223.28 k
!     upper - n2o, p = 8.716e-2 mb, t = 226.03 k

CFC12O( :) = (/&
 & 85.4027_JPRB, 89.4696_JPRB, 74.0959_JPRB, 67.7480_JPRB,&
 & 61.2444_JPRB, 59.9073_JPRB, 60.8296_JPRB, 63.0998_JPRB,&
 & 59.6110_JPRB, 64.0735_JPRB, 57.2622_JPRB, 58.9721_JPRB,&
 & 43.5505_JPRB, 26.1192_JPRB, 32.7023_JPRB, 32.8667_JPRB/)  

!     Original CFC22 is multiplied by 1.485 to account for the 780-850 cm-1 
!     and 1290-1335 cm-1 bands.
CFC22ADJO( :) = (/&
 & 135.335_JPRB, 89.6642_JPRB, 76.2375_JPRB, 65.9748_JPRB,&
 & 63.1164_JPRB, 60.2935_JPRB, 64.0299_JPRB, 75.4264_JPRB,&
 & 51.3018_JPRB, 7.07911_JPRB, 5.86928_JPRB, 0.398693_JPRB,&
 & 2.82885_JPRB, 9.12751_JPRB, 6.28271_JPRB, 0.0_JPRB/)  

!     ------------------------------------------------------------------

!     The array KAO contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels > ~100mb and temperatures.  The first
!     index in the array, JT, which runs from 1 to 5, corresponds to 
!     different temperatures.  More specifically, JT = 3 means that the 
!     data are for the corresponding TREF for this  pressure level, 
!     JT = 2 refers to the temperatureTREF-15, JT = 1 is for TREF-30, 
!     JT = 4 is for TREF+15, and JT = 5 is for TREF+30.  The second 
!     index, JP, runs from 1 to 13 and refers to the corresponding 
!     pressure level in PREF (e.g. JP = 1 is for a pressure of 1053.63 mb).  
!     The third index, IG, goes from 1 to 16, and tells us which 
!     g-interval the absorption coefficients are for.
!     The array KA contains absorption coef5s at the 16 chosen g-values 
!     for a range of pressure levels > ~100mb and temperatures.  The first
!     index in the array, JT, which runs from 1 to 5, corresponds to 
!     different temperatures.  More specifically, JT = 3 means that the 
!     data are for the cooresponding TREF for this  pressure level, 
!     JT = 2 refers to the temperature
!     TREF-15, JT = 1 is for TREF-30, JT = 4 is for TREF+15, and JT = 5
!     is for TREF+30.  The second index, JP, runs from 1 to 13 and refers
!     to the corresponding pressure level in PREF (e.g. JP = 1 is for a
!     pressure of 1053.63 mb).  The third index, IG, goes from 1 to 16,
!     and tells us which "g-channel" the absorption coefficients are for.



!     The array KBO contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels < ~100mb and temperatures. The first 
!     index in the array, JT, which runs from 1 to 5, corresponds to 
!     different temperatures.  More specifically, JT = 3 means that the 
!     data are for the reference temperature TREF for this pressure 
!     level, JT = 2 refers to the temperature TREF-15, JT = 1 is for
!     TREF-30, JT = 4 is for TREF+15, and JT = 5 is for TREF+30.  
!     The second index, JP, runs from 13 to 59 and refers to the JPth
!     reference pressure level (see taumol.f for the value of these
!     pressure levels in mb).  The third index, IG, goes from 1 to 16,
!     and tells us which g-interval the absorption coefficients are for.



!     The array KAO_Mxx contains the absorption coefficient for 
!     a minor species at the 16 chosen g-values for a reference pressure
!     level below 100~ mb.   The first index refers to temperature 
!     in 7.2 degree increments.  For instance, JT = 1 refers to a 
!     temperature of 188.0, JT = 2 refers to 195.2, etc. The second index 
!     runs over the g-channel (1 to 16).

      KAO_MCO2(:, 1) = (/ &
     & 8.88964E-07_JPRB, 1.13087E-06_JPRB, 1.43861E-06_JPRB, 1.83010E-06_JPRB, 2.32811E-06_JPRB, &
     & 2.96165E-06_JPRB, 3.76760E-06_JPRB, 4.79286E-06_JPRB, 6.09712E-06_JPRB, 7.75630E-06_JPRB, &
     & 9.86699E-06_JPRB, 1.25521E-05_JPRB, 1.59678E-05_JPRB, 2.03130E-05_JPRB, 2.58407E-05_JPRB, &
     & 3.28727E-05_JPRB, 4.18182E-05_JPRB, 5.31980E-05_JPRB, 6.76745E-05_JPRB/)
      KAO_MCO2(:, 2) = (/ &
     & 1.10492E-05_JPRB, 1.35003E-05_JPRB, 1.64952E-05_JPRB, 2.01545E-05_JPRB, 2.46256E-05_JPRB, &
     & 3.00885E-05_JPRB, 3.67632E-05_JPRB, 4.49188E-05_JPRB, 5.48835E-05_JPRB, 6.70588E-05_JPRB, &
     & 8.19351E-05_JPRB, 1.00111E-04_JPRB, 1.22320E-04_JPRB, 1.49455E-04_JPRB, 1.82610E-04_JPRB, &
     & 2.23121E-04_JPRB, 2.72618E-04_JPRB, 3.33095E-04_JPRB, 4.06988E-04_JPRB/)
      KAO_MCO2(:, 3) = (/ &
     & 1.51034E-05_JPRB, 1.81249E-05_JPRB, 2.17508E-05_JPRB, 2.61020E-05_JPRB, 3.13238E-05_JPRB, &
     & 3.75901E-05_JPRB, 4.51101E-05_JPRB, 5.41344E-05_JPRB, 6.49640E-05_JPRB, 7.79601E-05_JPRB, &
     & 9.35562E-05_JPRB, 1.12272E-04_JPRB, 1.34732E-04_JPRB, 1.61686E-04_JPRB, 1.94031E-04_JPRB, &
     & 2.32847E-04_JPRB, 2.79429E-04_JPRB, 3.35329E-04_JPRB, 4.02411E-04_JPRB/)
      KAO_MCO2(:, 4) = (/ &
     & 1.57088E-05_JPRB, 1.89537E-05_JPRB, 2.28688E-05_JPRB, 2.75928E-05_JPRB, 3.32924E-05_JPRB, &
     & 4.01695E-05_JPRB, 4.84671E-05_JPRB, 5.84787E-05_JPRB, 7.05584E-05_JPRB, 8.51332E-05_JPRB, &
     & 1.02719E-04_JPRB, 1.23937E-04_JPRB, 1.49538E-04_JPRB, 1.80427E-04_JPRB, 2.17697E-04_JPRB, &
     & 2.62666E-04_JPRB, 3.16923E-04_JPRB, 3.82388E-04_JPRB, 4.61376E-04_JPRB/)
      KAO_MCO2(:, 5) = (/ &
     & 3.09299E-05_JPRB, 3.73196E-05_JPRB, 4.50294E-05_JPRB, 5.43320E-05_JPRB, 6.55563E-05_JPRB, &
     & 7.90995E-05_JPRB, 9.54405E-05_JPRB, 1.15157E-04_JPRB, 1.38948E-04_JPRB, 1.67652E-04_JPRB, &
     & 2.02288E-04_JPRB, 2.44078E-04_JPRB, 2.94501E-04_JPRB, 3.55342E-04_JPRB, 4.28751E-04_JPRB, &
     & 5.17327E-04_JPRB, 6.24200E-04_JPRB, 7.53153E-04_JPRB, 9.08745E-04_JPRB/)
      KAO_MCO2(:, 6) = (/ &
     & 1.98653E-05_JPRB, 2.38878E-05_JPRB, 2.87248E-05_JPRB, 3.45413E-05_JPRB, 4.15355E-05_JPRB, &
     & 4.99459E-05_JPRB, 6.00593E-05_JPRB, 7.22206E-05_JPRB, 8.68445E-05_JPRB, 1.04429E-04_JPRB, &
     & 1.25575E-04_JPRB, 1.51003E-04_JPRB, 1.81579E-04_JPRB, 2.18346E-04_JPRB, 2.62559E-04_JPRB, &
     & 3.15724E-04_JPRB, 3.79654E-04_JPRB, 4.56529E-04_JPRB, 5.48971E-04_JPRB/)
      KAO_MCO2(:, 7) = (/ &
     & 1.54276E-06_JPRB, 1.90144E-06_JPRB, 2.34351E-06_JPRB, 2.88836E-06_JPRB, 3.55989E-06_JPRB, &
     & 4.38754E-06_JPRB, 5.40761E-06_JPRB, 6.66485E-06_JPRB, 8.21439E-06_JPRB, 1.01242E-05_JPRB, &
     & 1.24780E-05_JPRB, 1.53790E-05_JPRB, 1.89546E-05_JPRB, 2.33614E-05_JPRB, 2.87928E-05_JPRB, &
     & 3.54869E-05_JPRB, 4.37374E-05_JPRB, 5.39060E-05_JPRB, 6.64388E-05_JPRB/)
      KAO_MCO2(:, 8) = (/ &
     & 1.66907E-06_JPRB, 2.11106E-06_JPRB, 2.67008E-06_JPRB, 3.37714E-06_JPRB, 4.27143E-06_JPRB, &
     & 5.40254E-06_JPRB, 6.83318E-06_JPRB, 8.64266E-06_JPRB, 1.09313E-05_JPRB, 1.38260E-05_JPRB, &
     & 1.74872E-05_JPRB, 2.21180E-05_JPRB, 2.79750E-05_JPRB, 3.53830E-05_JPRB, 4.47527E-05_JPRB, &
     & 5.66036E-05_JPRB, 7.15927E-05_JPRB, 9.05509E-05_JPRB, 1.14529E-04_JPRB/)
      KAO_MCO2(:, 9) = (/ &
     & 1.22817E-06_JPRB, 1.56416E-06_JPRB, 1.99206E-06_JPRB, 2.53703E-06_JPRB, 3.23108E-06_JPRB, &
     & 4.11501E-06_JPRB, 5.24074E-06_JPRB, 6.67445E-06_JPRB, 8.50037E-06_JPRB, 1.08258E-05_JPRB, &
     & 1.37874E-05_JPRB, 1.75592E-05_JPRB, 2.23629E-05_JPRB, 2.84807E-05_JPRB, 3.62721E-05_JPRB, &
     & 4.61950E-05_JPRB, 5.88325E-05_JPRB, 7.49272E-05_JPRB, 9.54249E-05_JPRB/)
      KAO_MCO2(:,10) = (/ &
     & 3.45943E-08_JPRB, 3.84726E-08_JPRB, 4.27856E-08_JPRB, 4.75821E-08_JPRB, 5.29164E-08_JPRB, &
     & 5.88487E-08_JPRB, 6.54460E-08_JPRB, 7.27829E-08_JPRB, 8.09423E-08_JPRB, 9.00164E-08_JPRB, &
     & 1.00108E-07_JPRB, 1.11331E-07_JPRB, 1.23811E-07_JPRB, 1.37691E-07_JPRB, 1.53128E-07_JPRB, &
     & 1.70294E-07_JPRB, 1.89385E-07_JPRB, 2.10616E-07_JPRB, 2.34228E-07_JPRB/)
      KAO_MCO2(:,11) = (/ &
     & 2.89971E-08_JPRB, 3.35110E-08_JPRB, 3.87275E-08_JPRB, 4.47561E-08_JPRB, 5.17230E-08_JPRB, &
     & 5.97745E-08_JPRB, 6.90794E-08_JPRB, 7.98327E-08_JPRB, 9.22599E-08_JPRB, 1.06622E-07_JPRB, &
     & 1.23219E-07_JPRB, 1.42400E-07_JPRB, 1.64567E-07_JPRB, 1.90184E-07_JPRB, 2.19789E-07_JPRB, &
     & 2.54003E-07_JPRB, 2.93542E-07_JPRB, 3.39237E-07_JPRB, 3.92044E-07_JPRB/)
      KAO_MCO2(:,12) = (/ &
     & 2.51330E-08_JPRB, 2.96783E-08_JPRB, 3.50457E-08_JPRB, 4.13837E-08_JPRB, 4.88679E-08_JPRB, &
     & 5.77056E-08_JPRB, 6.81416E-08_JPRB, 8.04650E-08_JPRB, 9.50171E-08_JPRB, 1.12201E-07_JPRB, &
     & 1.32492E-07_JPRB, 1.56454E-07_JPRB, 1.84748E-07_JPRB, 2.18160E-07_JPRB, 2.57614E-07_JPRB, &
     & 3.04203E-07_JPRB, 3.59218E-07_JPRB, 4.24182E-07_JPRB, 5.00895E-07_JPRB/)
      KAO_MCO2(:,13) = (/ &
     & 1.16966E-07_JPRB, 1.13960E-07_JPRB, 1.11032E-07_JPRB, 1.08179E-07_JPRB, 1.05400E-07_JPRB, &
     & 1.02691E-07_JPRB, 1.00053E-07_JPRB, 9.74820E-08_JPRB, 9.49772E-08_JPRB, 9.25368E-08_JPRB, &
     & 9.01591E-08_JPRB, 8.78425E-08_JPRB, 8.55854E-08_JPRB, 8.33863E-08_JPRB, 8.12437E-08_JPRB, &
     & 7.91562E-08_JPRB, 7.71223E-08_JPRB, 7.51407E-08_JPRB, 7.32100E-08_JPRB/)
      KAO_MCO2(:,14) = (/ &
     & 9.17853E-08_JPRB, 8.94322E-08_JPRB, 8.71395E-08_JPRB, 8.49055E-08_JPRB, 8.27289E-08_JPRB, &
     & 8.06080E-08_JPRB, 7.85415E-08_JPRB, 7.65279E-08_JPRB, 7.45660E-08_JPRB, 7.26544E-08_JPRB, &
     & 7.07918E-08_JPRB, 6.89770E-08_JPRB, 6.72086E-08_JPRB, 6.54856E-08_JPRB, 6.38068E-08_JPRB, &
     & 6.21710E-08_JPRB, 6.05772E-08_JPRB, 5.90242E-08_JPRB, 5.75110E-08_JPRB/)
      KAO_MCO2(:,15) = (/ &
     & 8.34607E-08_JPRB, 8.13236E-08_JPRB, 7.92413E-08_JPRB, 7.72122E-08_JPRB, 7.52351E-08_JPRB, &
     & 7.33087E-08_JPRB, 7.14315E-08_JPRB, 6.96025E-08_JPRB, 6.78202E-08_JPRB, 6.60837E-08_JPRB, &
     & 6.43915E-08_JPRB, 6.27427E-08_JPRB, 6.11361E-08_JPRB, 5.95707E-08_JPRB, 5.80453E-08_JPRB, &
     & 5.65590E-08_JPRB, 5.51108E-08_JPRB, 5.36996E-08_JPRB, 5.23246E-08_JPRB/)
      KAO_MCO2(:,16) = (/ &
     & 8.34607E-08_JPRB, 8.13236E-08_JPRB, 7.92413E-08_JPRB, 7.72122E-08_JPRB, 7.52351E-08_JPRB, &
     & 7.33087E-08_JPRB, 7.14315E-08_JPRB, 6.96025E-08_JPRB, 6.78202E-08_JPRB, 6.60837E-08_JPRB, &
     & 6.43915E-08_JPRB, 6.27427E-08_JPRB, 6.11361E-08_JPRB, 5.95707E-08_JPRB, 5.80453E-08_JPRB, &
     & 5.65590E-08_JPRB, 5.51108E-08_JPRB, 5.36996E-08_JPRB, 5.23246E-08_JPRB/)

      KAO_MO3(:, 1) = (/ &
     & 1.18276E-01_JPRB, 1.18009E-01_JPRB, 1.17742E-01_JPRB, 1.17476E-01_JPRB, 1.17210E-01_JPRB, &
     & 1.16945E-01_JPRB, 1.16681E-01_JPRB, 1.16417E-01_JPRB, 1.16153E-01_JPRB, 1.15891E-01_JPRB, &
     & 1.15629E-01_JPRB, 1.15367E-01_JPRB, 1.15106E-01_JPRB, 1.14846E-01_JPRB, 1.14586E-01_JPRB, &
     & 1.14327E-01_JPRB, 1.14069E-01_JPRB, 1.13811E-01_JPRB, 1.13553E-01_JPRB/)
      KAO_MO3(:, 2) = (/ &
     & 1.83777E-01_JPRB, 1.84268E-01_JPRB, 1.84761E-01_JPRB, 1.85255E-01_JPRB, 1.85751E-01_JPRB, &
     & 1.86248E-01_JPRB, 1.86746E-01_JPRB, 1.87245E-01_JPRB, 1.87746E-01_JPRB, 1.88248E-01_JPRB, &
     & 1.88752E-01_JPRB, 1.89257E-01_JPRB, 1.89763E-01_JPRB, 1.90270E-01_JPRB, 1.90779E-01_JPRB, &
     & 1.91290E-01_JPRB, 1.91801E-01_JPRB, 1.92314E-01_JPRB, 1.92829E-01_JPRB/)
      KAO_MO3(:, 3) = (/ &
     & 2.33414E-01_JPRB, 2.34511E-01_JPRB, 2.35614E-01_JPRB, 2.36722E-01_JPRB, 2.37836E-01_JPRB, &
     & 2.38954E-01_JPRB, 2.40078E-01_JPRB, 2.41207E-01_JPRB, 2.42342E-01_JPRB, 2.43481E-01_JPRB, &
     & 2.44626E-01_JPRB, 2.45777E-01_JPRB, 2.46933E-01_JPRB, 2.48094E-01_JPRB, 2.49261E-01_JPRB, &
     & 2.50433E-01_JPRB, 2.51611E-01_JPRB, 2.52794E-01_JPRB, 2.53983E-01_JPRB/)
      KAO_MO3(:, 4) = (/ &
     & 2.84906E-01_JPRB, 2.87358E-01_JPRB, 2.89832E-01_JPRB, 2.92328E-01_JPRB, 2.94844E-01_JPRB, &
     & 2.97383E-01_JPRB, 2.99943E-01_JPRB, 3.02525E-01_JPRB, 3.05130E-01_JPRB, 3.07757E-01_JPRB, &
     & 3.10406E-01_JPRB, 3.13078E-01_JPRB, 3.15774E-01_JPRB, 3.18492E-01_JPRB, 3.21234E-01_JPRB, &
     & 3.24000E-01_JPRB, 3.26789E-01_JPRB, 3.29603E-01_JPRB, 3.32440E-01_JPRB/)
      KAO_MO3(:, 5) = (/ &
     & 3.40508E-01_JPRB, 3.44095E-01_JPRB, 3.47720E-01_JPRB, 3.51383E-01_JPRB, 3.55084E-01_JPRB, &
     & 3.58824E-01_JPRB, 3.62604E-01_JPRB, 3.66424E-01_JPRB, 3.70284E-01_JPRB, 3.74184E-01_JPRB, &
     & 3.78126E-01_JPRB, 3.82109E-01_JPRB, 3.86134E-01_JPRB, 3.90202E-01_JPRB, 3.94312E-01_JPRB, &
     & 3.98466E-01_JPRB, 4.02663E-01_JPRB, 4.06905E-01_JPRB, 4.11191E-01_JPRB/)
      KAO_MO3(:, 6) = (/ &
     & 3.78368E-01_JPRB, 3.83690E-01_JPRB, 3.89086E-01_JPRB, 3.94558E-01_JPRB, 4.00107E-01_JPRB, &
     & 4.05735E-01_JPRB, 4.11441E-01_JPRB, 4.17227E-01_JPRB, 4.23095E-01_JPRB, 4.29046E-01_JPRB, &
     & 4.35080E-01_JPRB, 4.41199E-01_JPRB, 4.47404E-01_JPRB, 4.53697E-01_JPRB, 4.60078E-01_JPRB, &
     & 4.66548E-01_JPRB, 4.73110E-01_JPRB, 4.79764E-01_JPRB, 4.86511E-01_JPRB/)
      KAO_MO3(:, 7) = (/ &
     & 4.51965E-01_JPRB, 4.58461E-01_JPRB, 4.65051E-01_JPRB, 4.71735E-01_JPRB, 4.78516E-01_JPRB, &
     & 4.85394E-01_JPRB, 4.92371E-01_JPRB, 4.99448E-01_JPRB, 5.06627E-01_JPRB, 5.13909E-01_JPRB, &
     & 5.21296E-01_JPRB, 5.28789E-01_JPRB, 5.36390E-01_JPRB, 5.44100E-01_JPRB, 5.51920E-01_JPRB, &
     & 5.59854E-01_JPRB, 5.67901E-01_JPRB, 5.76064E-01_JPRB, 5.84344E-01_JPRB/)
      KAO_MO3(:, 8) = (/ &
     & 3.00557E-01_JPRB, 3.03974E-01_JPRB, 3.07430E-01_JPRB, 3.10925E-01_JPRB, 3.14460E-01_JPRB, &
     & 3.18035E-01_JPRB, 3.21651E-01_JPRB, 3.25307E-01_JPRB, 3.29006E-01_JPRB, 3.32746E-01_JPRB, &
     & 3.36529E-01_JPRB, 3.40355E-01_JPRB, 3.44224E-01_JPRB, 3.48137E-01_JPRB, 3.52095E-01_JPRB, &
     & 3.56098E-01_JPRB, 3.60146E-01_JPRB, 3.64241E-01_JPRB, 3.68381E-01_JPRB/)
      KAO_MO3(:, 9) = (/ &
     & 2.10042E-01_JPRB, 2.12905E-01_JPRB, 2.15806E-01_JPRB, 2.18748E-01_JPRB, 2.21729E-01_JPRB, &
     & 2.24751E-01_JPRB, 2.27814E-01_JPRB, 2.30919E-01_JPRB, 2.34066E-01_JPRB, 2.37256E-01_JPRB, &
     & 2.40489E-01_JPRB, 2.43767E-01_JPRB, 2.47089E-01_JPRB, 2.50457E-01_JPRB, 2.53870E-01_JPRB, &
     & 2.57330E-01_JPRB, 2.60837E-01_JPRB, 2.64392E-01_JPRB, 2.67996E-01_JPRB/)
      KAO_MO3(:,10) = (/ &
     & 2.09288E-01_JPRB, 2.11759E-01_JPRB, 2.14259E-01_JPRB, 2.16789E-01_JPRB, 2.19349E-01_JPRB, &
     & 2.21939E-01_JPRB, 2.24559E-01_JPRB, 2.27210E-01_JPRB, 2.29893E-01_JPRB, 2.32607E-01_JPRB, &
     & 2.35354E-01_JPRB, 2.38133E-01_JPRB, 2.40944E-01_JPRB, 2.43789E-01_JPRB, 2.46667E-01_JPRB, &
     & 2.49580E-01_JPRB, 2.52527E-01_JPRB, 2.55508E-01_JPRB, 2.58525E-01_JPRB/)
      KAO_MO3(:,11) = (/ &
     & 2.28947E-01_JPRB, 2.30609E-01_JPRB, 2.32283E-01_JPRB, 2.33969E-01_JPRB, 2.35667E-01_JPRB, &
     & 2.37378E-01_JPRB, 2.39101E-01_JPRB, 2.40836E-01_JPRB, 2.42584E-01_JPRB, 2.44345E-01_JPRB, &
     & 2.46118E-01_JPRB, 2.47905E-01_JPRB, 2.49704E-01_JPRB, 2.51516E-01_JPRB, 2.53342E-01_JPRB, &
     & 2.55181E-01_JPRB, 2.57033E-01_JPRB, 2.58899E-01_JPRB, 2.60778E-01_JPRB/)
      KAO_MO3(:,12) = (/ &
     & 2.57263E-01_JPRB, 2.58272E-01_JPRB, 2.59285E-01_JPRB, 2.60302E-01_JPRB, 2.61323E-01_JPRB, &
     & 2.62347E-01_JPRB, 2.63376E-01_JPRB, 2.64409E-01_JPRB, 2.65446E-01_JPRB, 2.66487E-01_JPRB, &
     & 2.67532E-01_JPRB, 2.68581E-01_JPRB, 2.69635E-01_JPRB, 2.70692E-01_JPRB, 2.71753E-01_JPRB, &
     & 2.72819E-01_JPRB, 2.73889E-01_JPRB, 2.74963E-01_JPRB, 2.76042E-01_JPRB/)
      KAO_MO3(:,13) = (/ &
     & 2.43322E-01_JPRB, 2.45918E-01_JPRB, 2.48541E-01_JPRB, 2.51192E-01_JPRB, 2.53872E-01_JPRB, &
     & 2.56580E-01_JPRB, 2.59317E-01_JPRB, 2.62083E-01_JPRB, 2.64879E-01_JPRB, 2.67704E-01_JPRB, &
     & 2.70560E-01_JPRB, 2.73446E-01_JPRB, 2.76363E-01_JPRB, 2.79311E-01_JPRB, 2.82290E-01_JPRB, &
     & 2.85302E-01_JPRB, 2.88345E-01_JPRB, 2.91421E-01_JPRB, 2.94529E-01_JPRB/)
      KAO_MO3(:,14) = (/ &
     & 2.10568E-01_JPRB, 2.16529E-01_JPRB, 2.22660E-01_JPRB, 2.28964E-01_JPRB, 2.35446E-01_JPRB, &
     & 2.42113E-01_JPRB, 2.48967E-01_JPRB, 2.56016E-01_JPRB, 2.63265E-01_JPRB, 2.70719E-01_JPRB, &
     & 2.78383E-01_JPRB, 2.86265E-01_JPRB, 2.94370E-01_JPRB, 3.02704E-01_JPRB, 3.11275E-01_JPRB, &
     & 3.20088E-01_JPRB, 3.29150E-01_JPRB, 3.38470E-01_JPRB, 3.48052E-01_JPRB/)
      KAO_MO3(:,15) = (/ &
     & 2.60406E-02_JPRB, 2.78779E-02_JPRB, 2.98448E-02_JPRB, 3.19505E-02_JPRB, 3.42048E-02_JPRB, &
     & 3.66181E-02_JPRB, 3.92017E-02_JPRB, 4.19675E-02_JPRB, 4.49285E-02_JPRB, 4.80985E-02_JPRB, &
     & 5.14920E-02_JPRB, 5.51250E-02_JPRB, 5.90143E-02_JPRB, 6.31781E-02_JPRB, 6.76356E-02_JPRB, &
     & 7.24076E-02_JPRB, 7.75163E-02_JPRB, 8.29854E-02_JPRB, 8.88404E-02_JPRB/)
      KAO_MO3(:,16) = (/ &
     & 2.31483E-02_JPRB, 2.46840E-02_JPRB, 2.63217E-02_JPRB, 2.80681E-02_JPRB, 2.99302E-02_JPRB, &
     & 3.19160E-02_JPRB, 3.40335E-02_JPRB, 3.62914E-02_JPRB, 3.86992E-02_JPRB, 4.12668E-02_JPRB, &
     & 4.40046E-02_JPRB, 4.69242E-02_JPRB, 5.00374E-02_JPRB, 5.33571E-02_JPRB, 5.68971E-02_JPRB, &
     & 6.06720E-02_JPRB, 6.46974E-02_JPRB, 6.89897E-02_JPRB, 7.35669E-02_JPRB/)

      KAO_MN2O(:, 1) = (/ &
     & 3.02276E-02_JPRB, 3.10321E-02_JPRB, 3.18580E-02_JPRB, 3.27059E-02_JPRB, 3.35764E-02_JPRB, &
     & 3.44700E-02_JPRB, 3.53875E-02_JPRB, 3.63293E-02_JPRB, 3.72962E-02_JPRB, 3.82889E-02_JPRB, &
     & 3.93079E-02_JPRB, 4.03541E-02_JPRB, 4.14281E-02_JPRB, 4.25307E-02_JPRB, 4.36627E-02_JPRB, &
     & 4.48248E-02_JPRB, 4.60178E-02_JPRB, 4.72425E-02_JPRB, 4.84999E-02_JPRB/)
      KAO_MN2O(:, 2) = (/ &
     & 6.10132E-02_JPRB, 6.17435E-02_JPRB, 6.24825E-02_JPRB, 6.32304E-02_JPRB, 6.39872E-02_JPRB, &
     & 6.47531E-02_JPRB, 6.55281E-02_JPRB, 6.63124E-02_JPRB, 6.71061E-02_JPRB, 6.79093E-02_JPRB, &
     & 6.87221E-02_JPRB, 6.95446E-02_JPRB, 7.03770E-02_JPRB, 7.12194E-02_JPRB, 7.20718E-02_JPRB, &
     & 7.29344E-02_JPRB, 7.38074E-02_JPRB, 7.46908E-02_JPRB, 7.55848E-02_JPRB/)
      KAO_MN2O(:, 3) = (/ &
     & 1.04479E-01_JPRB, 1.05566E-01_JPRB, 1.06664E-01_JPRB, 1.07774E-01_JPRB, 1.08895E-01_JPRB, &
     & 1.10028E-01_JPRB, 1.11173E-01_JPRB, 1.12329E-01_JPRB, 1.13498E-01_JPRB, 1.14679E-01_JPRB, &
     & 1.15872E-01_JPRB, 1.17077E-01_JPRB, 1.18295E-01_JPRB, 1.19526E-01_JPRB, 1.20770E-01_JPRB, &
     & 1.22026E-01_JPRB, 1.23296E-01_JPRB, 1.24578E-01_JPRB, 1.25875E-01_JPRB/)
      KAO_MN2O(:, 4) = (/ &
     & 2.07260E-01_JPRB, 2.08126E-01_JPRB, 2.08996E-01_JPRB, 2.09869E-01_JPRB, 2.10746E-01_JPRB, &
     & 2.11627E-01_JPRB, 2.12511E-01_JPRB, 2.13399E-01_JPRB, 2.14291E-01_JPRB, 2.15187E-01_JPRB, &
     & 2.16086E-01_JPRB, 2.16989E-01_JPRB, 2.17896E-01_JPRB, 2.18807E-01_JPRB, 2.19721E-01_JPRB, &
     & 2.20640E-01_JPRB, 2.21562E-01_JPRB, 2.22488E-01_JPRB, 2.23418E-01_JPRB/)
      KAO_MN2O(:, 5) = (/ &
     & 3.71566E-01_JPRB, 3.71353E-01_JPRB, 3.71141E-01_JPRB, 3.70928E-01_JPRB, 3.70716E-01_JPRB, &
     & 3.70504E-01_JPRB, 3.70292E-01_JPRB, 3.70080E-01_JPRB, 3.69869E-01_JPRB, 3.69657E-01_JPRB, &
     & 3.69446E-01_JPRB, 3.69234E-01_JPRB, 3.69023E-01_JPRB, 3.68812E-01_JPRB, 3.68601E-01_JPRB, &
     & 3.68390E-01_JPRB, 3.68179E-01_JPRB, 3.67969E-01_JPRB, 3.67758E-01_JPRB/)
      KAO_MN2O(:, 6) = (/ &
     & 5.28092E-01_JPRB, 5.27262E-01_JPRB, 5.26433E-01_JPRB, 5.25605E-01_JPRB, 5.24779E-01_JPRB, &
     & 5.23954E-01_JPRB, 5.23130E-01_JPRB, 5.22307E-01_JPRB, 5.21486E-01_JPRB, 5.20666E-01_JPRB, &
     & 5.19847E-01_JPRB, 5.19030E-01_JPRB, 5.18214E-01_JPRB, 5.17399E-01_JPRB, 5.16586E-01_JPRB, &
     & 5.15773E-01_JPRB, 5.14962E-01_JPRB, 5.14153E-01_JPRB, 5.13344E-01_JPRB/)
      KAO_MN2O(:, 7) = (/ &
     & 3.88140E-01_JPRB, 3.87956E-01_JPRB, 3.87773E-01_JPRB, 3.87590E-01_JPRB, 3.87407E-01_JPRB, &
     & 3.87224E-01_JPRB, 3.87041E-01_JPRB, 3.86858E-01_JPRB, 3.86675E-01_JPRB, 3.86492E-01_JPRB, &
     & 3.86310E-01_JPRB, 3.86127E-01_JPRB, 3.85945E-01_JPRB, 3.85763E-01_JPRB, 3.85580E-01_JPRB, &
     & 3.85398E-01_JPRB, 3.85216E-01_JPRB, 3.85034E-01_JPRB, 3.84852E-01_JPRB/)
      KAO_MN2O(:, 8) = (/ &
     & 3.12991E-01_JPRB, 3.12246E-01_JPRB, 3.11504E-01_JPRB, 3.10763E-01_JPRB, 3.10024E-01_JPRB, &
     & 3.09287E-01_JPRB, 3.08552E-01_JPRB, 3.07818E-01_JPRB, 3.07086E-01_JPRB, 3.06356E-01_JPRB, &
     & 3.05628E-01_JPRB, 3.04901E-01_JPRB, 3.04176E-01_JPRB, 3.03453E-01_JPRB, 3.02732E-01_JPRB, &
     & 3.02012E-01_JPRB, 3.01294E-01_JPRB, 3.00577E-01_JPRB, 2.99863E-01_JPRB/)
      KAO_MN2O(:, 9) = (/ &
     & 4.11761E-01_JPRB, 4.11309E-01_JPRB, 4.10858E-01_JPRB, 4.10407E-01_JPRB, 4.09957E-01_JPRB, &
     & 4.09507E-01_JPRB, 4.09057E-01_JPRB, 4.08608E-01_JPRB, 4.08160E-01_JPRB, 4.07712E-01_JPRB, &
     & 4.07265E-01_JPRB, 4.06818E-01_JPRB, 4.06371E-01_JPRB, 4.05925E-01_JPRB, 4.05480E-01_JPRB, &
     & 4.05035E-01_JPRB, 4.04590E-01_JPRB, 4.04146E-01_JPRB, 4.03703E-01_JPRB/)
      KAO_MN2O(:,10) = (/ &
     & 2.84648E-01_JPRB, 2.87025E-01_JPRB, 2.89421E-01_JPRB, 2.91838E-01_JPRB, 2.94275E-01_JPRB, &
     & 2.96732E-01_JPRB, 2.99210E-01_JPRB, 3.01708E-01_JPRB, 3.04227E-01_JPRB, 3.06768E-01_JPRB, &
     & 3.09329E-01_JPRB, 3.11912E-01_JPRB, 3.14517E-01_JPRB, 3.17143E-01_JPRB, 3.19791E-01_JPRB, &
     & 3.22461E-01_JPRB, 3.25154E-01_JPRB, 3.27869E-01_JPRB, 3.30606E-01_JPRB/)
      KAO_MN2O(:,11) = (/ &
     & 2.75090E-01_JPRB, 2.79370E-01_JPRB, 2.83716E-01_JPRB, 2.88129E-01_JPRB, 2.92611E-01_JPRB, &
     & 2.97163E-01_JPRB, 3.01786E-01_JPRB, 3.06480E-01_JPRB, 3.11248E-01_JPRB, 3.16090E-01_JPRB, &
     & 3.21007E-01_JPRB, 3.26001E-01_JPRB, 3.31072E-01_JPRB, 3.36222E-01_JPRB, 3.41452E-01_JPRB, &
     & 3.46764E-01_JPRB, 3.52158E-01_JPRB, 3.57636E-01_JPRB, 3.63200E-01_JPRB/)
      KAO_MN2O(:,12) = (/ &
     & 1.67753E-01_JPRB, 1.71386E-01_JPRB, 1.75098E-01_JPRB, 1.78890E-01_JPRB, 1.82765E-01_JPRB, &
     & 1.86723E-01_JPRB, 1.90767E-01_JPRB, 1.94899E-01_JPRB, 1.99120E-01_JPRB, 2.03433E-01_JPRB, &
     & 2.07839E-01_JPRB, 2.12340E-01_JPRB, 2.16939E-01_JPRB, 2.21638E-01_JPRB, 2.26438E-01_JPRB, &
     & 2.31342E-01_JPRB, 2.36353E-01_JPRB, 2.41472E-01_JPRB, 2.46701E-01_JPRB/)
      KAO_MN2O(:,13) = (/ &
     & 1.40543E-01_JPRB, 1.42049E-01_JPRB, 1.43571E-01_JPRB, 1.45109E-01_JPRB, 1.46663E-01_JPRB, &
     & 1.48234E-01_JPRB, 1.49822E-01_JPRB, 1.51427E-01_JPRB, 1.53049E-01_JPRB, 1.54689E-01_JPRB, &
     & 1.56346E-01_JPRB, 1.58021E-01_JPRB, 1.59713E-01_JPRB, 1.61424E-01_JPRB, 1.63153E-01_JPRB, &
     & 1.64901E-01_JPRB, 1.66668E-01_JPRB, 1.68453E-01_JPRB, 1.70258E-01_JPRB/)
      KAO_MN2O(:,14) = (/ &
     & 1.51530E-01_JPRB, 1.50944E-01_JPRB, 1.50360E-01_JPRB, 1.49779E-01_JPRB, 1.49199E-01_JPRB, &
     & 1.48622E-01_JPRB, 1.48047E-01_JPRB, 1.47474E-01_JPRB, 1.46903E-01_JPRB, 1.46335E-01_JPRB, &
     & 1.45769E-01_JPRB, 1.45205E-01_JPRB, 1.44643E-01_JPRB, 1.44083E-01_JPRB, 1.43526E-01_JPRB, &
     & 1.42971E-01_JPRB, 1.42418E-01_JPRB, 1.41867E-01_JPRB, 1.41318E-01_JPRB/)
      KAO_MN2O(:,15) = (/ &
     & 2.20492E-01_JPRB, 2.16479E-01_JPRB, 2.12539E-01_JPRB, 2.08671E-01_JPRB, 2.04873E-01_JPRB, &
     & 2.01145E-01_JPRB, 1.97484E-01_JPRB, 1.93890E-01_JPRB, 1.90361E-01_JPRB, 1.86897E-01_JPRB, &
     & 1.83495E-01_JPRB, 1.80156E-01_JPRB, 1.76877E-01_JPRB, 1.73658E-01_JPRB, 1.70497E-01_JPRB, &
     & 1.67394E-01_JPRB, 1.64348E-01_JPRB, 1.61356E-01_JPRB, 1.58420E-01_JPRB/)
      KAO_MN2O(:,16) = (/ &
     & 2.19848E-01_JPRB, 2.15847E-01_JPRB, 2.11919E-01_JPRB, 2.08062E-01_JPRB, 2.04275E-01_JPRB, &
     & 2.00558E-01_JPRB, 1.96908E-01_JPRB, 1.93324E-01_JPRB, 1.89806E-01_JPRB, 1.86351E-01_JPRB, &
     & 1.82960E-01_JPRB, 1.79630E-01_JPRB, 1.76361E-01_JPRB, 1.73151E-01_JPRB, 1.70000E-01_JPRB, &
     & 1.66906E-01_JPRB, 1.63868E-01_JPRB, 1.60886E-01_JPRB, 1.57958E-01_JPRB/)

!     The array KBO_Mxx contains the absorption coefficient for 
!     a minor species at the 16 chosen g-values for a reference pressure
!     level above 100~ mb.   The first index refers to temperature 
!     in 7.2 degree increments.  For instance, JT = 1 refers to a 
!     temperature of 188.0, JT = 2 refers to 195.2, etc. The second index 
!     runs over the g-channel (1 to 16).

      KBO_MCO2(:, 1) = (/ &
     & 4.74280E-08_JPRB, 6.62724E-08_JPRB, 9.26042E-08_JPRB, 1.29398E-07_JPRB, 1.80812E-07_JPRB, &
     & 2.52653E-07_JPRB, 3.53039E-07_JPRB, 4.93310E-07_JPRB, 6.89316E-07_JPRB, 9.63198E-07_JPRB, &
     & 1.34590E-06_JPRB, 1.88067E-06_JPRB, 2.62790E-06_JPRB, 3.67204E-06_JPRB, 5.13104E-06_JPRB, &
     & 7.16974E-06_JPRB, 1.00185E-05_JPRB, 1.39991E-05_JPRB, 1.95613E-05_JPRB/)
      KBO_MCO2(:, 2) = (/ &
     & 1.14872E-07_JPRB, 1.63356E-07_JPRB, 2.32304E-07_JPRB, 3.30352E-07_JPRB, 4.69783E-07_JPRB, &
     & 6.68064E-07_JPRB, 9.50033E-07_JPRB, 1.35101E-06_JPRB, 1.92123E-06_JPRB, 2.73213E-06_JPRB, &
     & 3.88527E-06_JPRB, 5.52513E-06_JPRB, 7.85711E-06_JPRB, 1.11734E-05_JPRB, 1.58893E-05_JPRB, &
     & 2.25957E-05_JPRB, 3.21326E-05_JPRB, 4.56948E-05_JPRB, 6.49811E-05_JPRB/)
      KBO_MCO2(:, 3) = (/ &
     & 3.30676E-07_JPRB, 4.76313E-07_JPRB, 6.86094E-07_JPRB, 9.88267E-07_JPRB, 1.42353E-06_JPRB, &
     & 2.05048E-06_JPRB, 2.95356E-06_JPRB, 4.25439E-06_JPRB, 6.12813E-06_JPRB, 8.82711E-06_JPRB, &
     & 1.27148E-05_JPRB, 1.83147E-05_JPRB, 2.63810E-05_JPRB, 3.79998E-05_JPRB, 5.47359E-05_JPRB, &
     & 7.88430E-05_JPRB, 1.13568E-04_JPRB, 1.63585E-04_JPRB, 2.35632E-04_JPRB/)
      KBO_MCO2(:, 4) = (/ &
     & 6.58642E-07_JPRB, 9.52761E-07_JPRB, 1.37822E-06_JPRB, 1.99368E-06_JPRB, 2.88396E-06_JPRB, &
     & 4.17181E-06_JPRB, 6.03475E-06_JPRB, 8.72960E-06_JPRB, 1.26279E-05_JPRB, 1.82669E-05_JPRB, &
     & 2.64241E-05_JPRB, 3.82239E-05_JPRB, 5.52929E-05_JPRB, 7.99844E-05_JPRB, 1.15702E-04_JPRB, &
     & 1.67369E-04_JPRB, 2.42109E-04_JPRB, 3.50223E-04_JPRB, 5.06617E-04_JPRB/)
      KBO_MCO2(:, 5) = (/ &
     & 1.26418E-06_JPRB, 1.82095E-06_JPRB, 2.62292E-06_JPRB, 3.77810E-06_JPRB, 5.44204E-06_JPRB, &
     & 7.83881E-06_JPRB, 1.12911E-05_JPRB, 1.62640E-05_JPRB, 2.34269E-05_JPRB, 3.37445E-05_JPRB, &
     & 4.86061E-05_JPRB, 7.00131E-05_JPRB, 1.00848E-04_JPRB, 1.45263E-04_JPRB, 2.09239E-04_JPRB, &
     & 3.01392E-04_JPRB, 4.34131E-04_JPRB, 6.25329E-04_JPRB, 9.00733E-04_JPRB/)
      KBO_MCO2(:, 6) = (/ &
     & 2.38529E-06_JPRB, 3.43110E-06_JPRB, 4.93545E-06_JPRB, 7.09937E-06_JPRB, 1.02120E-05_JPRB, &
     & 1.46895E-05_JPRB, 2.11300E-05_JPRB, 3.03943E-05_JPRB, 4.37205E-05_JPRB, 6.28894E-05_JPRB, &
     & 9.04630E-05_JPRB, 1.30126E-04_JPRB, 1.87179E-04_JPRB, 2.69247E-04_JPRB, 3.87296E-04_JPRB, &
     & 5.57104E-04_JPRB, 8.01364E-04_JPRB, 1.15272E-03_JPRB, 1.65812E-03_JPRB/)
      KBO_MCO2(:, 7) = (/ &
     & 5.41398E-06_JPRB, 7.54295E-06_JPRB, 1.05091E-05_JPRB, 1.46417E-05_JPRB, 2.03993E-05_JPRB, &
     & 2.84211E-05_JPRB, 3.95973E-05_JPRB, 5.51683E-05_JPRB, 7.68626E-05_JPRB, 1.07088E-04_JPRB, &
     & 1.49199E-04_JPRB, 2.07869E-04_JPRB, 2.89610E-04_JPRB, 4.03496E-04_JPRB, 5.62165E-04_JPRB, &
     & 7.83229E-04_JPRB, 1.09122E-03_JPRB, 1.52033E-03_JPRB, 2.11818E-03_JPRB/)
      KBO_MCO2(:, 8) = (/ &
     & 1.09995E-05_JPRB, 1.54018E-05_JPRB, 2.15660E-05_JPRB, 3.01973E-05_JPRB, 4.22831E-05_JPRB, &
     & 5.92059E-05_JPRB, 8.29017E-05_JPRB, 1.16081E-04_JPRB, 1.62540E-04_JPRB, 2.27592E-04_JPRB, &
     & 3.18681E-04_JPRB, 4.46226E-04_JPRB, 6.24817E-04_JPRB, 8.74886E-04_JPRB, 1.22504E-03_JPRB, &
     & 1.71533E-03_JPRB, 2.40185E-03_JPRB, 3.36313E-03_JPRB, 4.70915E-03_JPRB/)
      KBO_MCO2(:, 9) = (/ &
     & 3.29051E-05_JPRB, 4.59996E-05_JPRB, 6.43050E-05_JPRB, 8.98950E-05_JPRB, 1.25668E-04_JPRB, &
     & 1.75678E-04_JPRB, 2.45588E-04_JPRB, 3.43319E-04_JPRB, 4.79942E-04_JPRB, 6.70933E-04_JPRB, &
     & 9.37930E-04_JPRB, 1.31118E-03_JPRB, 1.83295E-03_JPRB, 2.56237E-03_JPRB, 3.58206E-03_JPRB, &
     & 5.00753E-03_JPRB, 7.00027E-03_JPRB, 9.78599E-03_JPRB, 1.36803E-02_JPRB/)
      KBO_MCO2(:,10) = (/ &
     & 1.95126E-05_JPRB, 2.65944E-05_JPRB, 3.62463E-05_JPRB, 4.94013E-05_JPRB, 6.73305E-05_JPRB, &
     & 9.17669E-05_JPRB, 1.25072E-04_JPRB, 1.70465E-04_JPRB, 2.32332E-04_JPRB, 3.16652E-04_JPRB, &
     & 4.31575E-04_JPRB, 5.88208E-04_JPRB, 8.01687E-04_JPRB, 1.09264E-03_JPRB, 1.48920E-03_JPRB, &
     & 2.02968E-03_JPRB, 2.76631E-03_JPRB, 3.77029E-03_JPRB, 5.13865E-03_JPRB/)
      KBO_MCO2(:,11) = (/ &
     & 8.67271E-05_JPRB, 1.19228E-04_JPRB, 1.63908E-04_JPRB, 2.25332E-04_JPRB, 3.09774E-04_JPRB, &
     & 4.25860E-04_JPRB, 5.85450E-04_JPRB, 8.04845E-04_JPRB, 1.10646E-03_JPRB, 1.52110E-03_JPRB, &
     & 2.09112E-03_JPRB, 2.87476E-03_JPRB, 3.95207E-03_JPRB, 5.43309E-03_JPRB, 7.46911E-03_JPRB, &
     & 1.02681E-02_JPRB, 1.41161E-02_JPRB, 1.94060E-02_JPRB, 2.66783E-02_JPRB/)
      KBO_MCO2(:,12) = (/ &
     & 3.79194E-07_JPRB, 5.51419E-07_JPRB, 8.01866E-07_JPRB, 1.16606E-06_JPRB, 1.69567E-06_JPRB, &
     & 2.46582E-06_JPRB, 3.58577E-06_JPRB, 5.21438E-06_JPRB, 7.58268E-06_JPRB, 1.10266E-05_JPRB, &
     & 1.60348E-05_JPRB, 2.33176E-05_JPRB, 3.39081E-05_JPRB, 4.93087E-05_JPRB, 7.17040E-05_JPRB, &
     & 1.04271E-04_JPRB, 1.51630E-04_JPRB, 2.20498E-04_JPRB, 3.20644E-04_JPRB/)
      KBO_MCO2(:,13) = (/ &
     & 1.72555E-07_JPRB, 2.29952E-07_JPRB, 3.06441E-07_JPRB, 4.08373E-07_JPRB, 5.44209E-07_JPRB, &
     & 7.25229E-07_JPRB, 9.66461E-07_JPRB, 1.28793E-06_JPRB, 1.71634E-06_JPRB, 2.28724E-06_JPRB, &
     & 3.04805E-06_JPRB, 4.06192E-06_JPRB, 5.41303E-06_JPRB, 7.21356E-06_JPRB, 9.61299E-06_JPRB, &
     & 1.28106E-05_JPRB, 1.70717E-05_JPRB, 2.27503E-05_JPRB, 3.03177E-05_JPRB/)
      KBO_MCO2(:,14) = (/ &
     & 7.42245E-09_JPRB, 7.17780E-09_JPRB, 6.94122E-09_JPRB, 6.71243E-09_JPRB, 6.49118E-09_JPRB, &
     & 6.27723E-09_JPRB, 6.07032E-09_JPRB, 5.87024E-09_JPRB, 5.67675E-09_JPRB, 5.48964E-09_JPRB, &
     & 5.30870E-09_JPRB, 5.13372E-09_JPRB, 4.96451E-09_JPRB, 4.80087E-09_JPRB, 4.64263E-09_JPRB, &
     & 4.48961E-09_JPRB, 4.34163E-09_JPRB, 4.19852E-09_JPRB, 4.06014E-09_JPRB/)
      KBO_MCO2(:,15) = (/ &
     & 7.41847E-09_JPRB, 7.17332E-09_JPRB, 6.93627E-09_JPRB, 6.70705E-09_JPRB, 6.48541E-09_JPRB, &
     & 6.27109E-09_JPRB, 6.06386E-09_JPRB, 5.86347E-09_JPRB, 5.66970E-09_JPRB, 5.48234E-09_JPRB, &
     & 5.30117E-09_JPRB, 5.12599E-09_JPRB, 4.95659E-09_JPRB, 4.79280E-09_JPRB, 4.63441E-09_JPRB, &
     & 4.48126E-09_JPRB, 4.33317E-09_JPRB, 4.18998E-09_JPRB, 4.05152E-09_JPRB/)
      KBO_MCO2(:,16) = (/ &
     & 7.42855E-09_JPRB, 7.18278E-09_JPRB, 6.94513E-09_JPRB, 6.71535E-09_JPRB, 6.49317E-09_JPRB, &
     & 6.27834E-09_JPRB, 6.07062E-09_JPRB, 5.86977E-09_JPRB, 5.67557E-09_JPRB, 5.48779E-09_JPRB, &
     & 5.30622E-09_JPRB, 5.13066E-09_JPRB, 4.96091E-09_JPRB, 4.79678E-09_JPRB, 4.63808E-09_JPRB, &
     & 4.48462E-09_JPRB, 4.33625E-09_JPRB, 4.19278E-09_JPRB, 4.05406E-09_JPRB/)

      KBO_MN2O(:, 1) = (/ &
     & 2.49055E-04_JPRB, 2.53574E-04_JPRB, 2.58175E-04_JPRB, 2.62860E-04_JPRB, 2.67629E-04_JPRB, &
     & 2.72485E-04_JPRB, 2.77429E-04_JPRB, 2.82463E-04_JPRB, 2.87588E-04_JPRB, 2.92806E-04_JPRB, &
     & 2.98119E-04_JPRB, 3.03528E-04_JPRB, 3.09036E-04_JPRB, 3.14643E-04_JPRB, 3.20352E-04_JPRB, &
     & 3.26165E-04_JPRB, 3.32083E-04_JPRB, 3.38109E-04_JPRB, 3.44243E-04_JPRB/)
      KBO_MN2O(:, 2) = (/ &
     & 3.79251E-04_JPRB, 4.04353E-04_JPRB, 4.31117E-04_JPRB, 4.59652E-04_JPRB, 4.90075E-04_JPRB, &
     & 5.22513E-04_JPRB, 5.57097E-04_JPRB, 5.93970E-04_JPRB, 6.33284E-04_JPRB, 6.75200E-04_JPRB, &
     & 7.19890E-04_JPRB, 7.67539E-04_JPRB, 8.18340E-04_JPRB, 8.72505E-04_JPRB, 9.30255E-04_JPRB, &
     & 9.91827E-04_JPRB, 1.05747E-03_JPRB, 1.12747E-03_JPRB, 1.20209E-03_JPRB/)
      KBO_MN2O(:, 3) = (/ &
     & 7.61140E-04_JPRB, 8.36483E-04_JPRB, 9.19284E-04_JPRB, 1.01028E-03_JPRB, 1.11029E-03_JPRB, &
     & 1.22019E-03_JPRB, 1.34098E-03_JPRB, 1.47372E-03_JPRB, 1.61959E-03_JPRB, 1.77991E-03_JPRB, &
     & 1.95610E-03_JPRB, 2.14973E-03_JPRB, 2.36253E-03_JPRB, 2.59639E-03_JPRB, 2.85340E-03_JPRB, &
     & 3.13585E-03_JPRB, 3.44626E-03_JPRB, 3.78740E-03_JPRB, 4.16230E-03_JPRB/)
      KBO_MN2O(:, 4) = (/ &
     & 2.01074E-03_JPRB, 2.26915E-03_JPRB, 2.56077E-03_JPRB, 2.88987E-03_JPRB, 3.26126E-03_JPRB, &
     & 3.68038E-03_JPRB, 4.15337E-03_JPRB, 4.68714E-03_JPRB, 5.28951E-03_JPRB, 5.96929E-03_JPRB, &
     & 6.73643E-03_JPRB, 7.60217E-03_JPRB, 8.57916E-03_JPRB, 9.68172E-03_JPRB, 1.09260E-02_JPRB, &
     & 1.23301E-02_JPRB, 1.39147E-02_JPRB, 1.57030E-02_JPRB, 1.77211E-02_JPRB/)
      KBO_MN2O(:, 5) = (/ &
     & 7.43302E-03_JPRB, 8.32582E-03_JPRB, 9.32585E-03_JPRB, 1.04460E-02_JPRB, 1.17007E-02_JPRB, &
     & 1.31061E-02_JPRB, 1.46803E-02_JPRB, 1.64436E-02_JPRB, 1.84186E-02_JPRB, 2.06309E-02_JPRB, &
     & 2.31090E-02_JPRB, 2.58846E-02_JPRB, 2.89937E-02_JPRB, 3.24762E-02_JPRB, 3.63769E-02_JPRB, &
     & 4.07463E-02_JPRB, 4.56404E-02_JPRB, 5.11223E-02_JPRB, 5.72627E-02_JPRB/)
      KBO_MN2O(:, 6) = (/ &
     & 2.71911E-02_JPRB, 2.94258E-02_JPRB, 3.18441E-02_JPRB, 3.44612E-02_JPRB, 3.72933E-02_JPRB, &
     & 4.03582E-02_JPRB, 4.36750E-02_JPRB, 4.72644E-02_JPRB, 5.11487E-02_JPRB, 5.53523E-02_JPRB, &
     & 5.99014E-02_JPRB, 6.48243E-02_JPRB, 7.01518E-02_JPRB, 7.59172E-02_JPRB, 8.21563E-02_JPRB, &
     & 8.89082E-02_JPRB, 9.62150E-02_JPRB, 1.04122E-01_JPRB, 1.12679E-01_JPRB/)
      KBO_MN2O(:, 7) = (/ &
     & 1.63331E-01_JPRB, 1.80469E-01_JPRB, 1.99406E-01_JPRB, 2.20330E-01_JPRB, 2.43449E-01_JPRB, &
     & 2.68995E-01_JPRB, 2.97221E-01_JPRB, 3.28408E-01_JPRB, 3.62869E-01_JPRB, 4.00945E-01_JPRB, &
     & 4.43017E-01_JPRB, 4.89503E-01_JPRB, 5.40867E-01_JPRB, 5.97621E-01_JPRB, 6.60330E-01_JPRB, &
     & 7.29619E-01_JPRB, 8.06179E-01_JPRB, 8.90772E-01_JPRB, 9.84242E-01_JPRB/)
      KBO_MN2O(:, 8) = (/ &
     & 1.32648E+00_JPRB, 1.33515E+00_JPRB, 1.34387E+00_JPRB, 1.35265E+00_JPRB, 1.36149E+00_JPRB, &
     & 1.37038E+00_JPRB, 1.37933E+00_JPRB, 1.38835E+00_JPRB, 1.39742E+00_JPRB, 1.40655E+00_JPRB, &
     & 1.41574E+00_JPRB, 1.42499E+00_JPRB, 1.43429E+00_JPRB, 1.44367E+00_JPRB, 1.45310E+00_JPRB, &
     & 1.46259E+00_JPRB, 1.47215E+00_JPRB, 1.48176E+00_JPRB, 1.49144E+00_JPRB/)
      KBO_MN2O(:, 9) = (/ &
     & 3.12620E+00_JPRB, 3.03118E+00_JPRB, 2.93905E+00_JPRB, 2.84972E+00_JPRB, 2.76310E+00_JPRB, &
     & 2.67911E+00_JPRB, 2.59768E+00_JPRB, 2.51873E+00_JPRB, 2.44217E+00_JPRB, 2.36794E+00_JPRB, &
     & 2.29596E+00_JPRB, 2.22618E+00_JPRB, 2.15851E+00_JPRB, 2.09290E+00_JPRB, 2.02929E+00_JPRB, &
     & 1.96761E+00_JPRB, 1.90780E+00_JPRB, 1.84982E+00_JPRB, 1.79359E+00_JPRB/)
      KBO_MN2O(:,10) = (/ &
     & 1.60677E-02_JPRB, 1.82485E-02_JPRB, 2.07254E-02_JPRB, 2.35384E-02_JPRB, 2.67332E-02_JPRB, &
     & 3.03617E-02_JPRB, 3.44827E-02_JPRB, 3.91629E-02_JPRB, 4.44785E-02_JPRB, 5.05154E-02_JPRB, &
     & 5.73718E-02_JPRB, 6.51589E-02_JPRB, 7.40027E-02_JPRB, 8.40470E-02_JPRB, 9.54546E-02_JPRB, &
     & 1.08411E-01_JPRB, 1.23125E-01_JPRB, 1.39836E-01_JPRB, 1.58816E-01_JPRB/)
      KBO_MN2O(:,11) = (/ &
     & 1.55287E-02_JPRB, 1.78265E-02_JPRB, 2.04642E-02_JPRB, 2.34922E-02_JPRB, 2.69683E-02_JPRB, &
     & 3.09588E-02_JPRB, 3.55397E-02_JPRB, 4.07984E-02_JPRB, 4.68352E-02_JPRB, 5.37653E-02_JPRB, &
     & 6.17208E-02_JPRB, 7.08535E-02_JPRB, 8.13375E-02_JPRB, 9.33728E-02_JPRB, 1.07189E-01_JPRB, &
     & 1.23049E-01_JPRB, 1.41257E-01_JPRB, 1.62158E-01_JPRB, 1.86152E-01_JPRB/)
      KBO_MN2O(:,12) = (/ &
     & 7.13719E-03_JPRB, 8.18879E-03_JPRB, 9.39535E-03_JPRB, 1.07797E-02_JPRB, 1.23680E-02_JPRB, &
     & 1.41903E-02_JPRB, 1.62811E-02_JPRB, 1.86800E-02_JPRB, 2.14324E-02_JPRB, 2.45902E-02_JPRB, &
     & 2.82134E-02_JPRB, 3.23704E-02_JPRB, 3.71400E-02_JPRB, 4.26122E-02_JPRB, 4.88908E-02_JPRB, &
     & 5.60945E-02_JPRB, 6.43596E-02_JPRB, 7.38424E-02_JPRB, 8.47224E-02_JPRB/)
      KBO_MN2O(:,13) = (/ &
     & 9.28813E-03_JPRB, 1.06108E-02_JPRB, 1.21218E-02_JPRB, 1.38480E-02_JPRB, 1.58199E-02_JPRB, &
     & 1.80727E-02_JPRB, 2.06463E-02_JPRB, 2.35864E-02_JPRB, 2.69452E-02_JPRB, 3.07822E-02_JPRB, &
     & 3.51657E-02_JPRB, 4.01734E-02_JPRB, 4.58941E-02_JPRB, 5.24296E-02_JPRB, 5.98956E-02_JPRB, &
     & 6.84249E-02_JPRB, 7.81688E-02_JPRB, 8.93002E-02_JPRB, 1.02017E-01_JPRB/)
      KBO_MN2O(:,14) = (/ &
     & 2.17205E-02_JPRB, 2.51661E-02_JPRB, 2.91581E-02_JPRB, 3.37835E-02_JPRB, 3.91425E-02_JPRB, &
     & 4.53517E-02_JPRB, 5.25458E-02_JPRB, 6.08811E-02_JPRB, 7.05387E-02_JPRB, 8.17282E-02_JPRB, &
     & 9.46927E-02_JPRB, 1.09714E-01_JPRB, 1.27118E-01_JPRB, 1.47282E-01_JPRB, 1.70645E-01_JPRB, &
     & 1.97715E-01_JPRB, 2.29078E-01_JPRB, 2.65417E-01_JPRB, 3.07520E-01_JPRB/)
      KBO_MN2O(:,15) = (/ &
     & 4.89156E-02_JPRB, 5.70504E-02_JPRB, 6.65379E-02_JPRB, 7.76033E-02_JPRB, 9.05089E-02_JPRB, &
     & 1.05561E-01_JPRB, 1.23116E-01_JPRB, 1.43590E-01_JPRB, 1.67469E-01_JPRB, 1.95320E-01_JPRB, &
     & 2.27802E-01_JPRB, 2.65686E-01_JPRB, 3.09869E-01_JPRB, 3.61401E-01_JPRB, 4.21503E-01_JPRB, &
     & 4.91600E-01_JPRB, 5.73354E-01_JPRB, 6.68703E-01_JPRB, 7.79910E-01_JPRB/)
      KBO_MN2O(:,16) = (/ &
     & 1.13156E-02_JPRB, 1.46199E-02_JPRB, 1.88891E-02_JPRB, 2.44050E-02_JPRB, 3.15316E-02_JPRB, &
     & 4.07393E-02_JPRB, 5.26358E-02_JPRB, 6.80061E-02_JPRB, 8.78649E-02_JPRB, 1.13523E-01_JPRB, &
     & 1.46673E-01_JPRB, 1.89504E-01_JPRB, 2.44841E-01_JPRB, 3.16338E-01_JPRB, 4.08713E-01_JPRB, &
     & 5.28064E-01_JPRB, 6.82266E-01_JPRB, 8.81496E-01_JPRB, 1.13891E+00_JPRB/)

!     The array FORREFO contains the coefficient of the water vapor
!     foreign-continuum (including the energy term).  The first 
!     index refers to reference temperature (296,260,224,260) and 
!     pressure (970,475,219,3 mbar) levels.  The second index 
!     runs over the g-channel (1 to 16).

      FORREFO(1,:) = (/ &
     &4.8166E-07_JPRB,3.7500E-07_JPRB,4.8978E-07_JPRB,5.9624E-07_JPRB,6.3742E-07_JPRB,7.5551E-07_JPRB, &
     &7.7706E-07_JPRB,6.8681E-07_JPRB,7.5212E-07_JPRB,8.0956E-07_JPRB,7.8117E-07_JPRB,7.4835E-07_JPRB, &
     &9.4118E-07_JPRB,1.2585E-06_JPRB,1.4976E-06_JPRB,1.4976E-06_JPRB/)
      FORREFO(2,:) = (/ &
     &3.1320E-07_JPRB,4.0764E-07_JPRB,4.7468E-07_JPRB,5.9976E-07_JPRB,7.3324E-07_JPRB,8.1488E-07_JPRB, &
     &7.6442E-07_JPRB,8.2007E-07_JPRB,7.7721E-07_JPRB,7.6377E-07_JPRB,8.0327E-07_JPRB,7.1881E-07_JPRB, &
     &8.2148E-07_JPRB,1.0203E-06_JPRB,1.5033E-06_JPRB,1.5032E-06_JPRB/)
      FORREFO(3,:) = (/ &
     &4.1831E-07_JPRB,5.5043E-07_JPRB,5.7783E-07_JPRB,6.1294E-07_JPRB,6.3396E-07_JPRB,6.2292E-07_JPRB, &
     &6.1719E-07_JPRB,6.4183E-07_JPRB,7.6180E-07_JPRB,9.5477E-07_JPRB,9.5901E-07_JPRB,1.0207E-06_JPRB, &
     &1.0387E-06_JPRB,1.1305E-06_JPRB,1.3602E-06_JPRB,1.5063E-06_JPRB/)
      FORREFO(4,:) = (/ &
     &8.5878E-07_JPRB,6.0921E-07_JPRB,5.5773E-07_JPRB,5.3374E-07_JPRB,5.0495E-07_JPRB,4.9844E-07_JPRB, &
     &5.1536E-07_JPRB,5.2908E-07_JPRB,4.7977E-07_JPRB,5.3177E-07_JPRB,4.9266E-07_JPRB,4.5403E-07_JPRB, &
     &3.9695E-07_JPRB,3.4792E-07_JPRB,3.4912E-07_JPRB,3.4102E-07_JPRB/)

!     The array SELFREFO contains the coefficient of the water vapor
!     self-continuum (including the energy term).  The first index
!     refers to temperature in 7.2 degree increments.  For instance,
!     JT = 1 refers to a temperature of 245.6, JT = 2 refers to 252.8,
!     etc.  The second index runs over the g-channel (1 to 16).

      SELFREFO(:, 1) = (/ &
     & 3.16029E-02_JPRB, 2.74633E-02_JPRB, 2.38660E-02_JPRB, 2.07399E-02_JPRB, 1.80232E-02_JPRB, &
     & 1.56624E-02_JPRB, 1.36108E-02_JPRB, 1.18280E-02_JPRB, 1.02787E-02_JPRB, 8.93231E-03_JPRB/)
      SELFREFO(:, 2) = (/ &
     & 3.10422E-02_JPRB, 2.71312E-02_JPRB, 2.37130E-02_JPRB, 2.07254E-02_JPRB, 1.81142E-02_JPRB, &
     & 1.58320E-02_JPRB, 1.38374E-02_JPRB, 1.20940E-02_JPRB, 1.05703E-02_JPRB, 9.23854E-03_JPRB/)
      SELFREFO(:, 3) = (/ &
     & 3.08657E-02_JPRB, 2.69431E-02_JPRB, 2.35190E-02_JPRB, 2.05301E-02_JPRB, 1.79210E-02_JPRB, &
     & 1.56435E-02_JPRB, 1.36554E-02_JPRB, 1.19200E-02_JPRB, 1.04051E-02_JPRB, 9.08279E-03_JPRB/)
      SELFREFO(:, 4) = (/ &
     & 3.02668E-02_JPRB, 2.64686E-02_JPRB, 2.31470E-02_JPRB, 2.02422E-02_JPRB, 1.77020E-02_JPRB, &
     & 1.54806E-02_JPRB, 1.35379E-02_JPRB, 1.18390E-02_JPRB, 1.03533E-02_JPRB, 9.05406E-03_JPRB/)
      SELFREFO(:, 5) = (/ &
     & 2.98317E-02_JPRB, 2.61491E-02_JPRB, 2.29210E-02_JPRB, 2.00914E-02_JPRB, 1.76112E-02_JPRB, &
     & 1.54371E-02_JPRB, 1.35314E-02_JPRB, 1.18610E-02_JPRB, 1.03968E-02_JPRB, 9.11332E-03_JPRB/)
      SELFREFO(:, 6) = (/ &
     & 2.95545E-02_JPRB, 2.59083E-02_JPRB, 2.27120E-02_JPRB, 1.99100E-02_JPRB, 1.74537E-02_JPRB, &
     & 1.53004E-02_JPRB, 1.34128E-02_JPRB, 1.17580E-02_JPRB, 1.03074E-02_JPRB, 9.03576E-03_JPRB/)
      SELFREFO(:, 7) = (/ &
     & 2.97352E-02_JPRB, 2.60320E-02_JPRB, 2.27900E-02_JPRB, 1.99517E-02_JPRB, 1.74670E-02_JPRB, &
     & 1.52916E-02_JPRB, 1.33872E-02_JPRB, 1.17200E-02_JPRB, 1.02604E-02_JPRB, 8.98258E-03_JPRB/)
      SELFREFO(:, 8) = (/ &
     & 2.96543E-02_JPRB, 2.59760E-02_JPRB, 2.27540E-02_JPRB, 1.99316E-02_JPRB, 1.74593E-02_JPRB, &
     & 1.52937E-02_JPRB, 1.33967E-02_JPRB, 1.17350E-02_JPRB, 1.02794E-02_JPRB, 9.00437E-03_JPRB/)
      SELFREFO(:, 9) = (/ &
     & 2.97998E-02_JPRB, 2.60786E-02_JPRB, 2.28220E-02_JPRB, 1.99721E-02_JPRB, 1.74781E-02_JPRB, &
     & 1.52955E-02_JPRB, 1.33855E-02_JPRB, 1.17140E-02_JPRB, 1.02512E-02_JPRB, 8.97110E-03_JPRB/)
      SELFREFO(:,10) = (/ &
     & 2.98826E-02_JPRB, 2.61096E-02_JPRB, 2.28130E-02_JPRB, 1.99326E-02_JPRB, 1.74159E-02_JPRB, &
     & 1.52170E-02_JPRB, 1.32957E-02_JPRB, 1.16170E-02_JPRB, 1.01502E-02_JPRB, 8.86867E-03_JPRB/)
      SELFREFO(:,11) = (/ &
     & 2.94710E-02_JPRB, 2.58147E-02_JPRB, 2.26120E-02_JPRB, 1.98066E-02_JPRB, 1.73493E-02_JPRB, &
     & 1.51969E-02_JPRB, 1.33115E-02_JPRB, 1.16600E-02_JPRB, 1.02134E-02_JPRB, 8.94628E-03_JPRB/)
      SELFREFO(:,12) = (/ &
     & 2.96297E-02_JPRB, 2.59544E-02_JPRB, 2.27350E-02_JPRB, 1.99149E-02_JPRB, 1.74446E-02_JPRB, &
     & 1.52808E-02_JPRB, 1.33853E-02_JPRB, 1.17250E-02_JPRB, 1.02706E-02_JPRB, 8.99663E-03_JPRB/)
      SELFREFO(:,13) = (/ &
     & 2.96272E-02_JPRB, 2.59013E-02_JPRB, 2.26440E-02_JPRB, 1.97963E-02_JPRB, 1.73067E-02_JPRB, &
     & 1.51302E-02_JPRB, 1.32275E-02_JPRB, 1.15640E-02_JPRB, 1.01097E-02_JPRB, 8.83833E-03_JPRB/)
      SELFREFO(:,14) = (/ &
     & 2.89906E-02_JPRB, 2.53971E-02_JPRB, 2.22490E-02_JPRB, 1.94911E-02_JPRB, 1.70751E-02_JPRB, &
     & 1.49585E-02_JPRB, 1.31044E-02_JPRB, 1.14800E-02_JPRB, 1.00570E-02_JPRB, 8.81038E-03_JPRB/)
      SELFREFO(:,15) = (/ &
     & 2.80884E-02_JPRB, 2.46987E-02_JPRB, 2.17180E-02_JPRB, 1.90970E-02_JPRB, 1.67924E-02_JPRB, &
     & 1.47659E-02_JPRB, 1.29839E-02_JPRB, 1.14170E-02_JPRB, 1.00392E-02_JPRB, 8.82765E-03_JPRB/)
      SELFREFO(:,16) = (/ &
     & 2.80884E-02_JPRB, 2.46987E-02_JPRB, 2.17180E-02_JPRB, 1.90970E-02_JPRB, 1.67924E-02_JPRB, &
     & 1.47659E-02_JPRB, 1.29839E-02_JPRB, 1.14170E-02_JPRB, 1.00392E-02_JPRB, 8.82765E-03_JPRB/)



!IF (LHOOK) CALL DR_HOOK('RRTM_KGB8',1,ZHOOK_HANDLE)
RETURN

1001 CONTINUE
CALL ABOR1("RRTM_KGB8:ERROR READING FILE RADRRTM")

END SUBROUTINE RRTM_KGB8
