SUBROUTINE RRTM_KGB3

!     Originally by Eli J. Mlawer, Atmospheric & Environmental Research.
!     BAND 3:  500-630 cm-1 (low - H2O,CO2; high - H2O,CO2)
!     Reformatted for F90 by JJMorcrette, ECMWF
!     R. Elkhatib 12-10-2005 Split for faster and more robust compilation.
!     G.Mozdzynski March 2011 read constants from files
!     ABozzo 201305 updated to rrtmg_lw_v4.85:
!     band 3:  500-630 cm-1 (low key - h2o,co2; low minor - n2o)
!                           (high key - h2o,co2; high minor - n2o)     
!     T. Wilhelmsson and K. Yessad (Oct 2013) Geometry and setup refactoring.
!     ------------------------------------------------------------------

USE PARKIND1  ,ONLY : JPRB
!USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE YOMLUN    ,ONLY : NULRAD
USE MPL_MODULE,ONLY : MPL_BROADCAST
USE YOMTAG    ,ONLY : MTAGRAD
USE YOMMP0    , ONLY : NPROC, MYPROC

USE YOERRTO3 , ONLY : KAO     ,KBO     ,KAO_D,KBO_D,SELFREFO   ,FRACREFAO  ,&
 & FRACREFBO  ,FORREFO    ,KAO_MN2O,KBO_MN2O
!USE YOERRTA3 , ONLY :    ETAREF    ,H2OREF     ,&
! & N2OREF     ,CO2REF     ,STRRAT  

!     ------------------------------------------------------------------

IMPLICIT NONE
!REAL(KIND=JPRB) :: ZHOOK_HANDLE

#include "abor1.intfb.h"

!IF (LHOOK) CALL DR_HOOK('RRTM_KGB3',0,ZHOOK_HANDLE)

IF( MYPROC==1 )THEN
  READ(NULRAD,ERR=1001) KAO_D,KBO_D
 ! Convert the data into model actual precision.
  KAO = REAL(KAO_D,JPRB)
  KBO = REAL(KBO_D,JPRB) 
ENDIF
IF( NPROC>1 )THEN
  CALL MPL_BROADCAST (KAO,MTAGRAD,1,CDSTRING='RRTM_KGB3:')
  CALL MPL_BROADCAST (KBO,MTAGRAD,1,CDSTRING='RRTM_KGB3:')
ENDIF


! Planck fraction mapping level: P=212.7250 mbar, T = 223.06 K
      fracrefao(:, 1) = (/ &
     &   1.6251e-01_JPRB,1.5572e-01_JPRB,1.4557e-01_JPRB,1.3208e-01_JPRB,1.1582e-01_JPRB,9.6895e-02_JPRB, &
     &   7.8720e-02_JPRB,5.8462e-02_JPRB,3.9631e-02_JPRB,4.3001e-03_JPRB,3.5555e-03_JPRB,2.8101e-03_JPRB, &
     &   2.0547e-03_JPRB,1.3109e-03_JPRB,4.9403e-04_JPRB,6.9515e-05_JPRB/)
      fracrefao(:, 2) = (/ &
     &   1.6006e-01_JPRB,1.5576e-01_JPRB,1.4609e-01_JPRB,1.3276e-01_JPRB,1.1594e-01_JPRB,9.7336e-02_JPRB, &
     &   7.9035e-02_JPRB,5.8696e-02_JPRB,3.9723e-02_JPRB,4.3001e-03_JPRB,3.5555e-03_JPRB,2.8101e-03_JPRB, &
     &   2.0547e-03_JPRB,1.3109e-03_JPRB,4.9403e-04_JPRB,6.9515e-05_JPRB/)
      fracrefao(:, 3) = (/ &
     &   1.5952e-01_JPRB,1.5566e-01_JPRB,1.4590e-01_JPRB,1.3294e-01_JPRB,1.1599e-01_JPRB,9.7511e-02_JPRB, &
     &   7.9127e-02_JPRB,5.8888e-02_JPRB,3.9874e-02_JPRB,4.3001e-03_JPRB,3.5555e-03_JPRB,2.8102e-03_JPRB, &
     &   2.0547e-03_JPRB,1.3109e-03_JPRB,4.9403e-04_JPRB,6.9515e-05_JPRB/)
      fracrefao(:, 4) = (/ &
     &   1.5907e-01_JPRB,1.5541e-01_JPRB,1.4585e-01_JPRB,1.3316e-01_JPRB,1.1596e-01_JPRB,9.7647e-02_JPRB, &
     &   7.9243e-02_JPRB,5.9024e-02_JPRB,4.0028e-02_JPRB,4.3112e-03_JPRB,3.5555e-03_JPRB,2.8102e-03_JPRB, &
     &   2.0547e-03_JPRB,1.3109e-03_JPRB,4.9403e-04_JPRB,6.9515e-05_JPRB/)
      fracrefao(:, 5) = (/ &
     &   1.5862e-01_JPRB,1.5517e-01_JPRB,1.4588e-01_JPRB,1.3328e-01_JPRB,1.1585e-01_JPRB,9.7840e-02_JPRB, &
     &   7.9364e-02_JPRB,5.9174e-02_JPRB,4.0160e-02_JPRB,4.3403e-03_JPRB,3.5900e-03_JPRB,2.8102e-03_JPRB, &
     &   2.0547e-03_JPRB,1.3109e-03_JPRB,4.9403e-04_JPRB,6.9515e-05_JPRB/)
      fracrefao(:, 6) = (/ &
     &   1.5830e-01_JPRB,1.5490e-01_JPRB,1.4582e-01_JPRB,1.3331e-01_JPRB,1.1567e-01_JPRB,9.8079e-02_JPRB, &
     &   7.9510e-02_JPRB,5.9369e-02_JPRB,4.0326e-02_JPRB,4.3343e-03_JPRB,3.5908e-03_JPRB,2.8527e-03_JPRB, &
     &   2.0655e-03_JPRB,1.3109e-03_JPRB,4.9403e-04_JPRB,6.9515e-05_JPRB/)
      fracrefao(:, 7) = (/ &
     &   1.5789e-01_JPRB,1.5435e-01_JPRB,1.4595e-01_JPRB,1.3304e-01_JPRB,1.1566e-01_JPRB,9.8426e-02_JPRB, &
     &   7.9704e-02_JPRB,5.9618e-02_JPRB,4.0520e-02_JPRB,4.3812e-03_JPRB,3.6147e-03_JPRB,2.8395e-03_JPRB, &
     &   2.1301e-03_JPRB,1.3145e-03_JPRB,4.9403e-04_JPRB,6.9515e-05_JPRB/)
      fracrefao(:, 8) = (/ &
     &   1.5704e-01_JPRB,1.5398e-01_JPRB,1.4564e-01_JPRB,1.3222e-01_JPRB,1.1586e-01_JPRB,9.9230e-02_JPRB, &
     &   8.0011e-02_JPRB,6.0149e-02_JPRB,4.0790e-02_JPRB,4.4253e-03_JPRB,3.6534e-03_JPRB,2.9191e-03_JPRB, &
     &   2.1373e-03_JPRB,1.3558e-03_JPRB,5.1631e-04_JPRB,7.8794e-05_JPRB/)
      fracrefao(:, 9) = (/ &
     &   1.5270e-01_JPRB,1.5126e-01_JPRB,1.4264e-01_JPRB,1.3106e-01_JPRB,1.1740e-01_JPRB,1.0137e-01_JPRB, &
     &   8.3057e-02_JPRB,6.2282e-02_JPRB,4.2301e-02_JPRB,4.6486e-03_JPRB,3.8159e-03_JPRB,3.0472e-03_JPRB, &
     &   2.2870e-03_JPRB,1.4818e-03_JPRB,5.6773e-04_JPRB,7.8794e-05_JPRB/)

! Planck fraction mapping level: p = 95.8 mbar, t = 215.7 k
      fracrefbo(:, 1) = (/ &
     &   1.6413e-01_JPRB,1.5665e-01_JPRB,1.4606e-01_JPRB,1.3184e-01_JPRB,1.1517e-01_JPRB,9.6243e-02_JPRB, &
     &   7.7982e-02_JPRB,5.8165e-02_JPRB,3.9311e-02_JPRB,4.2586e-03_JPRB,3.5189e-03_JPRB,2.7793e-03_JPRB, &
     &   2.0376e-03_JPRB,1.2938e-03_JPRB,4.8853e-04_JPRB,6.8745e-05_JPRB/)
      fracrefbo(:, 2) = (/ &
     &   1.6254e-01_JPRB,1.5674e-01_JPRB,1.4652e-01_JPRB,1.3221e-01_JPRB,1.1535e-01_JPRB,9.6439e-02_JPRB, &
     &   7.8155e-02_JPRB,5.8254e-02_JPRB,3.9343e-02_JPRB,4.2586e-03_JPRB,3.5189e-03_JPRB,2.7793e-03_JPRB, &
     &   2.0376e-03_JPRB,1.2938e-03_JPRB,4.8853e-04_JPRB,6.8745e-05_JPRB/)
      fracrefbo(:, 3) = (/ &
     &   1.6177e-01_JPRB,1.5664e-01_JPRB,1.4669e-01_JPRB,1.3242e-01_JPRB,1.1541e-01_JPRB,9.6536e-02_JPRB, &
     &   7.8257e-02_JPRB,5.8387e-02_JPRB,3.9431e-02_JPRB,4.2587e-03_JPRB,3.5189e-03_JPRB,2.7793e-03_JPRB, &
     &   2.0376e-03_JPRB,1.2938e-03_JPRB,4.8853e-04_JPRB,6.8745e-05_JPRB/)
      fracrefbo(:, 4) = (/ &
     &   1.6077e-01_JPRB,1.5679e-01_JPRB,1.4648e-01_JPRB,1.3273e-01_JPRB,1.1546e-01_JPRB,9.6779e-02_JPRB, &
     &   7.8371e-02_JPRB,5.8546e-02_JPRB,3.9611e-02_JPRB,4.2772e-03_JPRB,3.5190e-03_JPRB,2.7793e-03_JPRB, &
     &   2.0376e-03_JPRB,1.2938e-03_JPRB,4.8853e-04_JPRB,6.8745e-05_JPRB/)
      fracrefbo(:, 5) = (/ &
     &   1.6067e-01_JPRB,1.5608e-01_JPRB,1.4247e-01_JPRB,1.2881e-01_JPRB,1.1449e-01_JPRB,9.8802e-02_JPRB, &
     &   8.0828e-02_JPRB,6.0977e-02_JPRB,4.1494e-02_JPRB,4.5116e-03_JPRB,3.7290e-03_JPRB,2.9460e-03_JPRB, &
     &   2.1948e-03_JPRB,1.3778e-03_JPRB,5.4552e-04_JPRB,7.9969e-05_JPRB/)




!     ------------------------------------------------------------------

!     The array KAO contains absorption coefs for each of the 16 g-intervals
!     for a range of pressure levels > ~100mb, temperatures, and ratios
!     of water vapor to CO2.  The first index in the array, JS, runs
!     from 1 to 10, and corresponds to different water vapor to CO2 ratios,
!     as expressed through the binary species parameter eta, defined as
!     eta = h2o/(h20 + (rat) * co2), where rat is the ratio of the integrated
!     line strength in the band of co2 to that of h2o.  For instance,
!     JS=1 refers to dry air (eta = 0), JS = 10 corresponds to eta = 1.0.
!     The 2nd index in the array, JT, which runs from 1 to 5, corresponds 
!     to different temperatures.  More specifically, JT = 3 means that the 
!     data are for the reference temperature TREF for this  pressure 
!     level, JT = 2 refers to the temperature
!     TREF-15, JT = 1 is for TREF-30, JT = 4 is for TREF+15, and JT = 5
!     is for TREF+30.  The third index, JP, runs from 1 to 13 and refers
!     to the reference pressure level (e.g. JP = 1 is for a
!     pressure of 1053.63 mb).  The fourth index, IG, goes from 1 to 16,
!     and tells us which g-interval the absorption coefficients are for.



!     The array KBO contains absorption coefs for each of the 16 g-intervals
!     for a range of pressure levels  < ~100mb, temperatures, and ratios
!     of H2O to CO2.  The first index in the array, JS, runs from 1 to 5, 
!     and corresponds to different H2O to CO2 ratios, as expressed through 
!     the binary species parameter eta, defined as eta = H2O/(H2O+RAT*CO2), 
!     where RAT is the ratio of the integrated line strength in the band 
!     of CO2 to that of H2O.  For instance, JS=1 refers to no H2O, 
!     JS = 2 corresponds to eta = 0.25, etc.  The second index, JT, which
!     runs from 1 to 5, corresponds to different temperatures.  More 
!     specifically, JT = 3 means that the data are for the corresponding 
!     reference temperature TREF for this  pressure level, JT = 2 refers 
!     to the TREF-15, JT = 1 is for TREF-30, JT = 4 is for TREF+15, and
!     JT = 5 is for TREF+30.  The third index, JP, runs from 13 to 59 and
!     refers to the corresponding pressure level in PREF (e.g. JP = 13 is
!     for a pressure of 95.5835 mb).  The fourth index, IG, goes from 1 to
!     16, and tells us which g-interval the absorption coefficients are for.


!     The array KAO_Mxx contains the absorption coefficient for 
!     a minor species at the 16 chosen g-values for a reference pressure
!     level below 100~ mb.   The first index in the array, JS, runs
!     from 1 to 10, and corresponds to different gas column amount ratios,
!     as expressed through the binary species parameter eta, defined as
!     eta = gas1/(gas1 + (rat) * gas2), where rat is the 
!     ratio of the reference MLS column amount value of gas 1 
!     to that of gas2.  The second index refers to temperature 
!     in 7.2 degree increments.  For instance, JT = 1 refers to a 
!     temperature of 188.0, JT = 2 refers to 195.2, etc. The third index 
!     runs over the g-channel (1 to 16).

      kao_mn2o( 1, :, 1) = (/ &
     & 1.28178e-05_JPRB, 1.55472e-05_JPRB, 1.88578e-05_JPRB, 2.28735e-05_JPRB, 2.77442e-05_JPRB, &
     & 3.36520e-05_JPRB, 4.08179e-05_JPRB, 4.95098e-05_JPRB, 6.00525e-05_JPRB, 7.28401e-05_JPRB, &
     & 8.83508e-05_JPRB, 1.07164e-04_JPRB, 1.29984e-04_JPRB, 1.57663e-04_JPRB, 1.91236e-04_JPRB, &
     & 2.31958e-04_JPRB, 2.81352e-04_JPRB, 3.41263e-04_JPRB, 4.13932e-04_JPRB/)
      kao_mn2o( 2, :, 1) = (/ &
     & 1.00725e-01_JPRB, 1.04470e-01_JPRB, 1.08355e-01_JPRB, 1.12384e-01_JPRB, 1.16563e-01_JPRB, &
     & 1.20898e-01_JPRB, 1.25394e-01_JPRB, 1.30057e-01_JPRB, 1.34893e-01_JPRB, 1.39909e-01_JPRB, &
     & 1.45112e-01_JPRB, 1.50508e-01_JPRB, 1.56104e-01_JPRB, 1.61909e-01_JPRB, 1.67930e-01_JPRB, &
     & 1.74175e-01_JPRB, 1.80652e-01_JPRB, 1.87369e-01_JPRB, 1.94337e-01_JPRB/)
      kao_mn2o( 3, :, 1) = (/ &
     & 1.94143e-01_JPRB, 1.97380e-01_JPRB, 2.00670e-01_JPRB, 2.04016e-01_JPRB, 2.07417e-01_JPRB, &
     & 2.10875e-01_JPRB, 2.14390e-01_JPRB, 2.17964e-01_JPRB, 2.21598e-01_JPRB, 2.25292e-01_JPRB, &
     & 2.29048e-01_JPRB, 2.32867e-01_JPRB, 2.36749e-01_JPRB, 2.40696e-01_JPRB, 2.44708e-01_JPRB, &
     & 2.48788e-01_JPRB, 2.52936e-01_JPRB, 2.57152e-01_JPRB, 2.61439e-01_JPRB/)
      kao_mn2o( 4, :, 1) = (/ &
     & 2.98127e-01_JPRB, 3.00016e-01_JPRB, 3.01916e-01_JPRB, 3.03829e-01_JPRB, 3.05754e-01_JPRB, &
     & 3.07691e-01_JPRB, 3.09640e-01_JPRB, 3.11601e-01_JPRB, 3.13575e-01_JPRB, 3.15562e-01_JPRB, &
     & 3.17561e-01_JPRB, 3.19572e-01_JPRB, 3.21597e-01_JPRB, 3.23634e-01_JPRB, 3.25684e-01_JPRB, &
     & 3.27748e-01_JPRB, 3.29824e-01_JPRB, 3.31913e-01_JPRB, 3.34016e-01_JPRB/)
      kao_mn2o( 5, :, 1) = (/ &
     & 4.45029e-01_JPRB, 4.45243e-01_JPRB, 4.45458e-01_JPRB, 4.45673e-01_JPRB, 4.45889e-01_JPRB, &
     & 4.46104e-01_JPRB, 4.46319e-01_JPRB, 4.46535e-01_JPRB, 4.46750e-01_JPRB, 4.46966e-01_JPRB, &
     & 4.47182e-01_JPRB, 4.47398e-01_JPRB, 4.47614e-01_JPRB, 4.47830e-01_JPRB, 4.48046e-01_JPRB, &
     & 4.48262e-01_JPRB, 4.48479e-01_JPRB, 4.48695e-01_JPRB, 4.48912e-01_JPRB/)
      kao_mn2o( 6, :, 1) = (/ &
     & 7.15677e-01_JPRB, 7.14564e-01_JPRB, 7.13452e-01_JPRB, 7.12342e-01_JPRB, 7.11234e-01_JPRB, &
     & 7.10127e-01_JPRB, 7.09022e-01_JPRB, 7.07919e-01_JPRB, 7.06818e-01_JPRB, 7.05718e-01_JPRB, &
     & 7.04620e-01_JPRB, 7.03524e-01_JPRB, 7.02429e-01_JPRB, 7.01336e-01_JPRB, 7.00245e-01_JPRB, &
     & 6.99156e-01_JPRB, 6.98068e-01_JPRB, 6.96982e-01_JPRB, 6.95898e-01_JPRB/)
      kao_mn2o( 7, :, 1) = (/ &
     & 9.89605e-01_JPRB, 9.85128e-01_JPRB, 9.80671e-01_JPRB, 9.76234e-01_JPRB, 9.71817e-01_JPRB, &
     & 9.67421e-01_JPRB, 9.63044e-01_JPRB, 9.58687e-01_JPRB, 9.54350e-01_JPRB, 9.50032e-01_JPRB, &
     & 9.45734e-01_JPRB, 9.41455e-01_JPRB, 9.37196e-01_JPRB, 9.32956e-01_JPRB, 9.28735e-01_JPRB, &
     & 9.24533e-01_JPRB, 9.20350e-01_JPRB, 9.16187e-01_JPRB, 9.12042e-01_JPRB/)
      kao_mn2o( 8, :, 1) = (/ &
     & 1.12229e+00_JPRB, 1.11502e+00_JPRB, 1.10779e+00_JPRB, 1.10061e+00_JPRB, 1.09348e+00_JPRB, &
     & 1.08639e+00_JPRB, 1.07935e+00_JPRB, 1.07235e+00_JPRB, 1.06540e+00_JPRB, 1.05850e+00_JPRB, &
     & 1.05164e+00_JPRB, 1.04482e+00_JPRB, 1.03805e+00_JPRB, 1.03132e+00_JPRB, 1.02464e+00_JPRB, &
     & 1.01799e+00_JPRB, 1.01140e+00_JPRB, 1.00484e+00_JPRB, 9.98328e-01_JPRB/)
      kao_mn2o( 9, :, 1) = (/ &
     & 7.20959e-01_JPRB, 7.22839e-01_JPRB, 7.24723e-01_JPRB, 7.26612e-01_JPRB, 7.28506e-01_JPRB, &
     & 7.30405e-01_JPRB, 7.32309e-01_JPRB, 7.34218e-01_JPRB, 7.36132e-01_JPRB, 7.38051e-01_JPRB, &
     & 7.39975e-01_JPRB, 7.41904e-01_JPRB, 7.43838e-01_JPRB, 7.45777e-01_JPRB, 7.47721e-01_JPRB, &
     & 7.49670e-01_JPRB, 7.51624e-01_JPRB, 7.53584e-01_JPRB, 7.55548e-01_JPRB/)
      kao_mn2o( 1, :, 2) = (/ &
     & 1.62152e-03_JPRB, 1.81627e-03_JPRB, 2.03443e-03_JPRB, 2.27878e-03_JPRB, 2.55248e-03_JPRB, &
     & 2.85906e-03_JPRB, 3.20245e-03_JPRB, 3.58710e-03_JPRB, 4.01794e-03_JPRB, 4.50053e-03_JPRB, &
     & 5.04109e-03_JPRB, 5.64657e-03_JPRB, 6.32477e-03_JPRB, 7.08444e-03_JPRB, 7.93534e-03_JPRB, &
     & 8.88845e-03_JPRB, 9.95603e-03_JPRB, 1.11518e-02_JPRB, 1.24913e-02_JPRB/)
      kao_mn2o( 2, :, 2) = (/ &
     & 3.73716e-01_JPRB, 3.72491e-01_JPRB, 3.71271e-01_JPRB, 3.70054e-01_JPRB, 3.68841e-01_JPRB, &
     & 3.67633e-01_JPRB, 3.66428e-01_JPRB, 3.65227e-01_JPRB, 3.64031e-01_JPRB, 3.62838e-01_JPRB, &
     & 3.61649e-01_JPRB, 3.60464e-01_JPRB, 3.59283e-01_JPRB, 3.58106e-01_JPRB, 3.56932e-01_JPRB, &
     & 3.55763e-01_JPRB, 3.54597e-01_JPRB, 3.53435e-01_JPRB, 3.52277e-01_JPRB/)
      kao_mn2o( 3, :, 2) = (/ &
     & 5.46240e-01_JPRB, 5.42972e-01_JPRB, 5.39724e-01_JPRB, 5.36495e-01_JPRB, 5.33285e-01_JPRB, &
     & 5.30095e-01_JPRB, 5.26923e-01_JPRB, 5.23771e-01_JPRB, 5.20637e-01_JPRB, 5.17523e-01_JPRB, &
     & 5.14426e-01_JPRB, 5.11349e-01_JPRB, 5.08290e-01_JPRB, 5.05249e-01_JPRB, 5.02226e-01_JPRB, &
     & 4.99221e-01_JPRB, 4.96235e-01_JPRB, 4.93266e-01_JPRB, 4.90315e-01_JPRB/)
      kao_mn2o( 4, :, 2) = (/ &
     & 8.35399e-01_JPRB, 8.36766e-01_JPRB, 8.38135e-01_JPRB, 8.39507e-01_JPRB, 8.40880e-01_JPRB, &
     & 8.42256e-01_JPRB, 8.43635e-01_JPRB, 8.45015e-01_JPRB, 8.46398e-01_JPRB, 8.47783e-01_JPRB, &
     & 8.49170e-01_JPRB, 8.50559e-01_JPRB, 8.51951e-01_JPRB, 8.53345e-01_JPRB, 8.54742e-01_JPRB, &
     & 8.56140e-01_JPRB, 8.57541e-01_JPRB, 8.58944e-01_JPRB, 8.60350e-01_JPRB/)
      kao_mn2o( 5, :, 2) = (/ &
     & 1.04433e+00_JPRB, 1.04864e+00_JPRB, 1.05297e+00_JPRB, 1.05731e+00_JPRB, 1.06168e+00_JPRB, &
     & 1.06606e+00_JPRB, 1.07046e+00_JPRB, 1.07488e+00_JPRB, 1.07932e+00_JPRB, 1.08377e+00_JPRB, &
     & 1.08824e+00_JPRB, 1.09274e+00_JPRB, 1.09725e+00_JPRB, 1.10178e+00_JPRB, 1.10632e+00_JPRB, &
     & 1.11089e+00_JPRB, 1.11547e+00_JPRB, 1.12008e+00_JPRB, 1.12470e+00_JPRB/)
      kao_mn2o( 6, :, 2) = (/ &
     & 1.22341e+00_JPRB, 1.22885e+00_JPRB, 1.23431e+00_JPRB, 1.23980e+00_JPRB, 1.24531e+00_JPRB, &
     & 1.25084e+00_JPRB, 1.25640e+00_JPRB, 1.26199e+00_JPRB, 1.26760e+00_JPRB, 1.27323e+00_JPRB, &
     & 1.27889e+00_JPRB, 1.28458e+00_JPRB, 1.29029e+00_JPRB, 1.29602e+00_JPRB, 1.30178e+00_JPRB, &
     & 1.30757e+00_JPRB, 1.31338e+00_JPRB, 1.31922e+00_JPRB, 1.32508e+00_JPRB/)
      kao_mn2o( 7, :, 2) = (/ &
     & 1.67595e+00_JPRB, 1.68296e+00_JPRB, 1.69000e+00_JPRB, 1.69707e+00_JPRB, 1.70417e+00_JPRB, &
     & 1.71130e+00_JPRB, 1.71846e+00_JPRB, 1.72565e+00_JPRB, 1.73287e+00_JPRB, 1.74012e+00_JPRB, &
     & 1.74740e+00_JPRB, 1.75471e+00_JPRB, 1.76206e+00_JPRB, 1.76943e+00_JPRB, 1.77683e+00_JPRB, &
     & 1.78426e+00_JPRB, 1.79173e+00_JPRB, 1.79922e+00_JPRB, 1.80675e+00_JPRB/)
      kao_mn2o( 8, :, 2) = (/ &
     & 2.76890e+00_JPRB, 2.76981e+00_JPRB, 2.77072e+00_JPRB, 2.77163e+00_JPRB, 2.77254e+00_JPRB, &
     & 2.77345e+00_JPRB, 2.77436e+00_JPRB, 2.77527e+00_JPRB, 2.77618e+00_JPRB, 2.77709e+00_JPRB, &
     & 2.77800e+00_JPRB, 2.77891e+00_JPRB, 2.77982e+00_JPRB, 2.78074e+00_JPRB, 2.78165e+00_JPRB, &
     & 2.78256e+00_JPRB, 2.78348e+00_JPRB, 2.78439e+00_JPRB, 2.78530e+00_JPRB/)
      kao_mn2o( 9, :, 2) = (/ &
     & 8.00944e-01_JPRB, 7.95531e-01_JPRB, 7.90155e-01_JPRB, 7.84815e-01_JPRB, 7.79511e-01_JPRB, &
     & 7.74243e-01_JPRB, 7.69011e-01_JPRB, 7.63813e-01_JPRB, 7.58652e-01_JPRB, 7.53525e-01_JPRB, &
     & 7.48432e-01_JPRB, 7.43374e-01_JPRB, 7.38350e-01_JPRB, 7.33360e-01_JPRB, 7.28404e-01_JPRB, &
     & 7.23482e-01_JPRB, 7.18592e-01_JPRB, 7.13736e-01_JPRB, 7.08912e-01_JPRB/)
      kao_mn2o( 1, :, 3) = (/ &
     & 5.26578e-02_JPRB, 5.59000e-02_JPRB, 5.93419e-02_JPRB, 6.29957e-02_JPRB, 6.68744e-02_JPRB, &
     & 7.09920e-02_JPRB, 7.53631e-02_JPRB, 8.00034e-02_JPRB, 8.49294e-02_JPRB, 9.01586e-02_JPRB, &
     & 9.57099e-02_JPRB, 1.01603e-01_JPRB, 1.07859e-01_JPRB, 1.14500e-01_JPRB, 1.21550e-01_JPRB, &
     & 1.29034e-01_JPRB, 1.36979e-01_JPRB, 1.45413e-01_JPRB, 1.54366e-01_JPRB/)
      kao_mn2o( 2, :, 3) = (/ &
     & 8.18393e-01_JPRB, 8.20623e-01_JPRB, 8.22860e-01_JPRB, 8.25103e-01_JPRB, 8.27352e-01_JPRB, &
     & 8.29608e-01_JPRB, 8.31869e-01_JPRB, 8.34137e-01_JPRB, 8.36410e-01_JPRB, 8.38690e-01_JPRB, &
     & 8.40976e-01_JPRB, 8.43269e-01_JPRB, 8.45567e-01_JPRB, 8.47872e-01_JPRB, 8.50183e-01_JPRB, &
     & 8.52501e-01_JPRB, 8.54825e-01_JPRB, 8.57155e-01_JPRB, 8.59491e-01_JPRB/)
      kao_mn2o( 3, :, 3) = (/ &
     & 1.02454e+00_JPRB, 1.03210e+00_JPRB, 1.03972e+00_JPRB, 1.04740e+00_JPRB, 1.05514e+00_JPRB, &
     & 1.06293e+00_JPRB, 1.07077e+00_JPRB, 1.07868e+00_JPRB, 1.08665e+00_JPRB, 1.09467e+00_JPRB, &
     & 1.10275e+00_JPRB, 1.11089e+00_JPRB, 1.11910e+00_JPRB, 1.12736e+00_JPRB, 1.13568e+00_JPRB, &
     & 1.14407e+00_JPRB, 1.15252e+00_JPRB, 1.16103e+00_JPRB, 1.16960e+00_JPRB/)
      kao_mn2o( 4, :, 3) = (/ &
     & 1.11755e+00_JPRB, 1.12348e+00_JPRB, 1.12944e+00_JPRB, 1.13543e+00_JPRB, 1.14146e+00_JPRB, &
     & 1.14752e+00_JPRB, 1.15360e+00_JPRB, 1.15972e+00_JPRB, 1.16588e+00_JPRB, 1.17206e+00_JPRB, &
     & 1.17828e+00_JPRB, 1.18453e+00_JPRB, 1.19082e+00_JPRB, 1.19714e+00_JPRB, 1.20349e+00_JPRB, &
     & 1.20988e+00_JPRB, 1.21630e+00_JPRB, 1.22275e+00_JPRB, 1.22924e+00_JPRB/)
      kao_mn2o( 5, :, 3) = (/ &
     & 1.41993e+00_JPRB, 1.42353e+00_JPRB, 1.42713e+00_JPRB, 1.43074e+00_JPRB, 1.43436e+00_JPRB, &
     & 1.43799e+00_JPRB, 1.44163e+00_JPRB, 1.44528e+00_JPRB, 1.44894e+00_JPRB, 1.45261e+00_JPRB, &
     & 1.45628e+00_JPRB, 1.45997e+00_JPRB, 1.46367e+00_JPRB, 1.46737e+00_JPRB, 1.47108e+00_JPRB, &
     & 1.47481e+00_JPRB, 1.47854e+00_JPRB, 1.48228e+00_JPRB, 1.48603e+00_JPRB/)
      kao_mn2o( 6, :, 3) = (/ &
     & 1.37725e+00_JPRB, 1.38029e+00_JPRB, 1.38334e+00_JPRB, 1.38640e+00_JPRB, 1.38947e+00_JPRB, &
     & 1.39254e+00_JPRB, 1.39562e+00_JPRB, 1.39870e+00_JPRB, 1.40179e+00_JPRB, 1.40489e+00_JPRB, &
     & 1.40800e+00_JPRB, 1.41111e+00_JPRB, 1.41423e+00_JPRB, 1.41736e+00_JPRB, 1.42049e+00_JPRB, &
     & 1.42363e+00_JPRB, 1.42678e+00_JPRB, 1.42993e+00_JPRB, 1.43309e+00_JPRB/)
      kao_mn2o( 7, :, 3) = (/ &
     & 1.34579e+00_JPRB, 1.34584e+00_JPRB, 1.34589e+00_JPRB, 1.34594e+00_JPRB, 1.34599e+00_JPRB, &
     & 1.34603e+00_JPRB, 1.34608e+00_JPRB, 1.34613e+00_JPRB, 1.34618e+00_JPRB, 1.34623e+00_JPRB, &
     & 1.34627e+00_JPRB, 1.34632e+00_JPRB, 1.34637e+00_JPRB, 1.34642e+00_JPRB, 1.34647e+00_JPRB, &
     & 1.34651e+00_JPRB, 1.34656e+00_JPRB, 1.34661e+00_JPRB, 1.34666e+00_JPRB/)
      kao_mn2o( 8, :, 3) = (/ &
     & 9.15268e-01_JPRB, 9.12779e-01_JPRB, 9.10298e-01_JPRB, 9.07823e-01_JPRB, 9.05355e-01_JPRB, &
     & 9.02893e-01_JPRB, 9.00438e-01_JPRB, 8.97990e-01_JPRB, 8.95549e-01_JPRB, 8.93114e-01_JPRB, &
     & 8.90686e-01_JPRB, 8.88264e-01_JPRB, 8.85849e-01_JPRB, 8.83441e-01_JPRB, 8.81039e-01_JPRB, &
     & 8.78644e-01_JPRB, 8.76255e-01_JPRB, 8.73873e-01_JPRB, 8.71497e-01_JPRB/)
      kao_mn2o( 9, :, 3) = (/ &
     & 1.12514e+00_JPRB, 1.13523e+00_JPRB, 1.14541e+00_JPRB, 1.15568e+00_JPRB, 1.16604e+00_JPRB, &
     & 1.17649e+00_JPRB, 1.18704e+00_JPRB, 1.19768e+00_JPRB, 1.20841e+00_JPRB, 1.21925e+00_JPRB, &
     & 1.23018e+00_JPRB, 1.24121e+00_JPRB, 1.25233e+00_JPRB, 1.26356e+00_JPRB, 1.27489e+00_JPRB, &
     & 1.28632e+00_JPRB, 1.29785e+00_JPRB, 1.30948e+00_JPRB, 1.32122e+00_JPRB/)
      kao_mn2o( 1, :, 4) = (/ &
     & 4.65135e-01_JPRB, 4.69677e-01_JPRB, 4.74264e-01_JPRB, 4.78895e-01_JPRB, 4.83572e-01_JPRB, &
     & 4.88294e-01_JPRB, 4.93063e-01_JPRB, 4.97878e-01_JPRB, 5.02740e-01_JPRB, 5.07649e-01_JPRB, &
     & 5.12607e-01_JPRB, 5.17613e-01_JPRB, 5.22667e-01_JPRB, 5.27771e-01_JPRB, 5.32925e-01_JPRB, &
     & 5.38130e-01_JPRB, 5.43385e-01_JPRB, 5.48691e-01_JPRB, 5.54049e-01_JPRB/)
      kao_mn2o( 2, :, 4) = (/ &
     & 9.71592e-01_JPRB, 9.74472e-01_JPRB, 9.77360e-01_JPRB, 9.80257e-01_JPRB, 9.83163e-01_JPRB, &
     & 9.86077e-01_JPRB, 9.89000e-01_JPRB, 9.91931e-01_JPRB, 9.94871e-01_JPRB, 9.97820e-01_JPRB, &
     & 1.00078e+00_JPRB, 1.00374e+00_JPRB, 1.00672e+00_JPRB, 1.00970e+00_JPRB, 1.01270e+00_JPRB, &
     & 1.01570e+00_JPRB, 1.01871e+00_JPRB, 1.02173e+00_JPRB, 1.02476e+00_JPRB/)
      kao_mn2o( 3, :, 4) = (/ &
     & 1.48090e+00_JPRB, 1.48238e+00_JPRB, 1.48385e+00_JPRB, 1.48532e+00_JPRB, 1.48680e+00_JPRB, &
     & 1.48828e+00_JPRB, 1.48976e+00_JPRB, 1.49124e+00_JPRB, 1.49272e+00_JPRB, 1.49420e+00_JPRB, &
     & 1.49569e+00_JPRB, 1.49717e+00_JPRB, 1.49866e+00_JPRB, 1.50015e+00_JPRB, 1.50164e+00_JPRB, &
     & 1.50313e+00_JPRB, 1.50463e+00_JPRB, 1.50612e+00_JPRB, 1.50762e+00_JPRB/)
      kao_mn2o( 4, :, 4) = (/ &
     & 1.50599e+00_JPRB, 1.50541e+00_JPRB, 1.50483e+00_JPRB, 1.50426e+00_JPRB, 1.50368e+00_JPRB, &
     & 1.50310e+00_JPRB, 1.50252e+00_JPRB, 1.50195e+00_JPRB, 1.50137e+00_JPRB, 1.50079e+00_JPRB, &
     & 1.50022e+00_JPRB, 1.49964e+00_JPRB, 1.49906e+00_JPRB, 1.49849e+00_JPRB, 1.49791e+00_JPRB, &
     & 1.49734e+00_JPRB, 1.49676e+00_JPRB, 1.49619e+00_JPRB, 1.49561e+00_JPRB/)
      kao_mn2o( 5, :, 4) = (/ &
     & 1.25396e+00_JPRB, 1.25230e+00_JPRB, 1.25065e+00_JPRB, 1.24900e+00_JPRB, 1.24735e+00_JPRB, &
     & 1.24570e+00_JPRB, 1.24405e+00_JPRB, 1.24241e+00_JPRB, 1.24077e+00_JPRB, 1.23913e+00_JPRB, &
     & 1.23749e+00_JPRB, 1.23586e+00_JPRB, 1.23423e+00_JPRB, 1.23260e+00_JPRB, 1.23097e+00_JPRB, &
     & 1.22934e+00_JPRB, 1.22772e+00_JPRB, 1.22610e+00_JPRB, 1.22448e+00_JPRB/)
      kao_mn2o( 6, :, 4) = (/ &
     & 1.27104e+00_JPRB, 1.26416e+00_JPRB, 1.25731e+00_JPRB, 1.25050e+00_JPRB, 1.24373e+00_JPRB, &
     & 1.23700e+00_JPRB, 1.23030e+00_JPRB, 1.22364e+00_JPRB, 1.21701e+00_JPRB, 1.21043e+00_JPRB, &
     & 1.20387e+00_JPRB, 1.19735e+00_JPRB, 1.19087e+00_JPRB, 1.18442e+00_JPRB, 1.17801e+00_JPRB, &
     & 1.17163e+00_JPRB, 1.16529e+00_JPRB, 1.15898e+00_JPRB, 1.15270e+00_JPRB/)
      kao_mn2o( 7, :, 4) = (/ &
     & 9.57877e-01_JPRB, 9.49712e-01_JPRB, 9.41617e-01_JPRB, 9.33591e-01_JPRB, 9.25633e-01_JPRB, &
     & 9.17743e-01_JPRB, 9.09920e-01_JPRB, 9.02164e-01_JPRB, 8.94473e-01_JPRB, 8.86849e-01_JPRB, &
     & 8.79289e-01_JPRB, 8.71794e-01_JPRB, 8.64363e-01_JPRB, 8.56995e-01_JPRB, 8.49690e-01_JPRB, &
     & 8.42447e-01_JPRB, 8.35266e-01_JPRB, 8.28147e-01_JPRB, 8.21087e-01_JPRB/)
      kao_mn2o( 8, :, 4) = (/ &
     & 4.75787e-01_JPRB, 4.77208e-01_JPRB, 4.78633e-01_JPRB, 4.80063e-01_JPRB, 4.81496e-01_JPRB, &
     & 4.82934e-01_JPRB, 4.84377e-01_JPRB, 4.85823e-01_JPRB, 4.87274e-01_JPRB, 4.88730e-01_JPRB, &
     & 4.90189e-01_JPRB, 4.91653e-01_JPRB, 4.93122e-01_JPRB, 4.94595e-01_JPRB, 4.96072e-01_JPRB, &
     & 4.97553e-01_JPRB, 4.99039e-01_JPRB, 5.00530e-01_JPRB, 5.02025e-01_JPRB/)
      kao_mn2o( 9, :, 4) = (/ &
     & 2.42533e+00_JPRB, 2.41357e+00_JPRB, 2.40188e+00_JPRB, 2.39024e+00_JPRB, 2.37866e+00_JPRB, &
     & 2.36713e+00_JPRB, 2.35566e+00_JPRB, 2.34425e+00_JPRB, 2.33289e+00_JPRB, 2.32158e+00_JPRB, &
     & 2.31033e+00_JPRB, 2.29914e+00_JPRB, 2.28800e+00_JPRB, 2.27691e+00_JPRB, 2.26588e+00_JPRB, &
     & 2.25490e+00_JPRB, 2.24397e+00_JPRB, 2.23310e+00_JPRB, 2.22228e+00_JPRB/)
      kao_mn2o( 1, :, 5) = (/ &
     & 1.53885e+00_JPRB, 1.53590e+00_JPRB, 1.53297e+00_JPRB, 1.53004e+00_JPRB, 1.52711e+00_JPRB, &
     & 1.52419e+00_JPRB, 1.52128e+00_JPRB, 1.51837e+00_JPRB, 1.51547e+00_JPRB, 1.51257e+00_JPRB, &
     & 1.50968e+00_JPRB, 1.50679e+00_JPRB, 1.50391e+00_JPRB, 1.50104e+00_JPRB, 1.49817e+00_JPRB, &
     & 1.49530e+00_JPRB, 1.49245e+00_JPRB, 1.48959e+00_JPRB, 1.48675e+00_JPRB/)
      kao_mn2o( 2, :, 5) = (/ &
     & 1.83368e+00_JPRB, 1.83530e+00_JPRB, 1.83692e+00_JPRB, 1.83854e+00_JPRB, 1.84016e+00_JPRB, &
     & 1.84178e+00_JPRB, 1.84340e+00_JPRB, 1.84503e+00_JPRB, 1.84665e+00_JPRB, 1.84828e+00_JPRB, &
     & 1.84991e+00_JPRB, 1.85154e+00_JPRB, 1.85317e+00_JPRB, 1.85480e+00_JPRB, 1.85644e+00_JPRB, &
     & 1.85807e+00_JPRB, 1.85971e+00_JPRB, 1.86135e+00_JPRB, 1.86299e+00_JPRB/)
      kao_mn2o( 3, :, 5) = (/ &
     & 1.49593e+00_JPRB, 1.49279e+00_JPRB, 1.48965e+00_JPRB, 1.48652e+00_JPRB, 1.48340e+00_JPRB, &
     & 1.48028e+00_JPRB, 1.47717e+00_JPRB, 1.47406e+00_JPRB, 1.47096e+00_JPRB, 1.46787e+00_JPRB, &
     & 1.46479e+00_JPRB, 1.46171e+00_JPRB, 1.45863e+00_JPRB, 1.45557e+00_JPRB, 1.45251e+00_JPRB, &
     & 1.44946e+00_JPRB, 1.44641e+00_JPRB, 1.44337e+00_JPRB, 1.44033e+00_JPRB/)
      kao_mn2o( 4, :, 5) = (/ &
     & 1.40048e+00_JPRB, 1.39228e+00_JPRB, 1.38413e+00_JPRB, 1.37603e+00_JPRB, 1.36798e+00_JPRB, &
     & 1.35997e+00_JPRB, 1.35201e+00_JPRB, 1.34410e+00_JPRB, 1.33623e+00_JPRB, 1.32841e+00_JPRB, &
     & 1.32064e+00_JPRB, 1.31291e+00_JPRB, 1.30522e+00_JPRB, 1.29758e+00_JPRB, 1.28999e+00_JPRB, &
     & 1.28244e+00_JPRB, 1.27493e+00_JPRB, 1.26747e+00_JPRB, 1.26005e+00_JPRB/)
      kao_mn2o( 5, :, 5) = (/ &
     & 1.22253e+00_JPRB, 1.21202e+00_JPRB, 1.20160e+00_JPRB, 1.19126e+00_JPRB, 1.18102e+00_JPRB, &
     & 1.17087e+00_JPRB, 1.16080e+00_JPRB, 1.15082e+00_JPRB, 1.14092e+00_JPRB, 1.13111e+00_JPRB, &
     & 1.12139e+00_JPRB, 1.11174e+00_JPRB, 1.10219e+00_JPRB, 1.09271e+00_JPRB, 1.08331e+00_JPRB, &
     & 1.07400e+00_JPRB, 1.06476e+00_JPRB, 1.05561e+00_JPRB, 1.04653e+00_JPRB/)
      kao_mn2o( 6, :, 5) = (/ &
     & 1.07930e+00_JPRB, 1.06998e+00_JPRB, 1.06075e+00_JPRB, 1.05159e+00_JPRB, 1.04251e+00_JPRB, &
     & 1.03352e+00_JPRB, 1.02459e+00_JPRB, 1.01575e+00_JPRB, 1.00698e+00_JPRB, 9.98291e-01_JPRB, &
     & 9.89674e-01_JPRB, 9.81131e-01_JPRB, 9.72663e-01_JPRB, 9.64267e-01_JPRB, 9.55944e-01_JPRB, &
     & 9.47692e-01_JPRB, 9.39512e-01_JPRB, 9.31402e-01_JPRB, 9.23363e-01_JPRB/)
      kao_mn2o( 7, :, 5) = (/ &
     & 7.87066e-01_JPRB, 7.82767e-01_JPRB, 7.78490e-01_JPRB, 7.74237e-01_JPRB, 7.70008e-01_JPRB, &
     & 7.65801e-01_JPRB, 7.61617e-01_JPRB, 7.57457e-01_JPRB, 7.53319e-01_JPRB, 7.49203e-01_JPRB, &
     & 7.45110e-01_JPRB, 7.41040e-01_JPRB, 7.36991e-01_JPRB, 7.32965e-01_JPRB, 7.28961e-01_JPRB, &
     & 7.24979e-01_JPRB, 7.21018e-01_JPRB, 7.17079e-01_JPRB, 7.13161e-01_JPRB/)
      kao_mn2o( 8, :, 5) = (/ &
     & 3.83362e-01_JPRB, 3.84405e-01_JPRB, 3.85452e-01_JPRB, 3.86501e-01_JPRB, 3.87552e-01_JPRB, &
     & 3.88607e-01_JPRB, 3.89665e-01_JPRB, 3.90725e-01_JPRB, 3.91788e-01_JPRB, 3.92855e-01_JPRB, &
     & 3.93924e-01_JPRB, 3.94996e-01_JPRB, 3.96071e-01_JPRB, 3.97149e-01_JPRB, 3.98229e-01_JPRB, &
     & 3.99313e-01_JPRB, 4.00400e-01_JPRB, 4.01489e-01_JPRB, 4.02582e-01_JPRB/)
      kao_mn2o( 9, :, 5) = (/ &
     & 8.97278e-01_JPRB, 8.92873e-01_JPRB, 8.88490e-01_JPRB, 8.84128e-01_JPRB, 8.79787e-01_JPRB, &
     & 8.75468e-01_JPRB, 8.71170e-01_JPRB, 8.66893e-01_JPRB, 8.62637e-01_JPRB, 8.58402e-01_JPRB, &
     & 8.54187e-01_JPRB, 8.49994e-01_JPRB, 8.45821e-01_JPRB, 8.41668e-01_JPRB, 8.37536e-01_JPRB, &
     & 8.33424e-01_JPRB, 8.29333e-01_JPRB, 8.25261e-01_JPRB, 8.21209e-01_JPRB/)
      kao_mn2o( 1, :, 6) = (/ &
     & 1.83809e+00_JPRB, 1.84036e+00_JPRB, 1.84264e+00_JPRB, 1.84491e+00_JPRB, 1.84720e+00_JPRB, &
     & 1.84948e+00_JPRB, 1.85177e+00_JPRB, 1.85406e+00_JPRB, 1.85635e+00_JPRB, 1.85864e+00_JPRB, &
     & 1.86094e+00_JPRB, 1.86324e+00_JPRB, 1.86555e+00_JPRB, 1.86785e+00_JPRB, 1.87016e+00_JPRB, &
     & 1.87247e+00_JPRB, 1.87479e+00_JPRB, 1.87711e+00_JPRB, 1.87943e+00_JPRB/)
      kao_mn2o( 2, :, 6) = (/ &
     & 1.82624e+00_JPRB, 1.81564e+00_JPRB, 1.80510e+00_JPRB, 1.79463e+00_JPRB, 1.78421e+00_JPRB, &
     & 1.77386e+00_JPRB, 1.76356e+00_JPRB, 1.75333e+00_JPRB, 1.74315e+00_JPRB, 1.73304e+00_JPRB, &
     & 1.72298e+00_JPRB, 1.71298e+00_JPRB, 1.70304e+00_JPRB, 1.69316e+00_JPRB, 1.68333e+00_JPRB, &
     & 1.67356e+00_JPRB, 1.66385e+00_JPRB, 1.65419e+00_JPRB, 1.64459e+00_JPRB/)
      kao_mn2o( 3, :, 6) = (/ &
     & 1.35442e+00_JPRB, 1.34174e+00_JPRB, 1.32918e+00_JPRB, 1.31673e+00_JPRB, 1.30440e+00_JPRB, &
     & 1.29219e+00_JPRB, 1.28010e+00_JPRB, 1.26811e+00_JPRB, 1.25624e+00_JPRB, 1.24448e+00_JPRB, &
     & 1.23283e+00_JPRB, 1.22129e+00_JPRB, 1.20985e+00_JPRB, 1.19853e+00_JPRB, 1.18731e+00_JPRB, &
     & 1.17619e+00_JPRB, 1.16518e+00_JPRB, 1.15427e+00_JPRB, 1.14347e+00_JPRB/)
      kao_mn2o( 4, :, 6) = (/ &
     & 1.10510e+00_JPRB, 1.09473e+00_JPRB, 1.08446e+00_JPRB, 1.07429e+00_JPRB, 1.06420e+00_JPRB, &
     & 1.05422e+00_JPRB, 1.04433e+00_JPRB, 1.03453e+00_JPRB, 1.02482e+00_JPRB, 1.01520e+00_JPRB, &
     & 1.00568e+00_JPRB, 9.96238e-01_JPRB, 9.86890e-01_JPRB, 9.77629e-01_JPRB, 9.68455e-01_JPRB, &
     & 9.59367e-01_JPRB, 9.50365e-01_JPRB, 9.41447e-01_JPRB, 9.32612e-01_JPRB/)
      kao_mn2o( 5, :, 6) = (/ &
     & 1.01083e+00_JPRB, 1.00221e+00_JPRB, 9.93656e-01_JPRB, 9.85178e-01_JPRB, 9.76772e-01_JPRB, &
     & 9.68437e-01_JPRB, 9.60174e-01_JPRB, 9.51981e-01_JPRB, 9.43859e-01_JPRB, 9.35805e-01_JPRB, &
     & 9.27821e-01_JPRB, 9.19904e-01_JPRB, 9.12055e-01_JPRB, 9.04273e-01_JPRB, 8.96557e-01_JPRB, &
     & 8.88907e-01_JPRB, 8.81323e-01_JPRB, 8.73803e-01_JPRB, 8.66347e-01_JPRB/)
      kao_mn2o( 6, :, 6) = (/ &
     & 5.91415e-01_JPRB, 5.90427e-01_JPRB, 5.89441e-01_JPRB, 5.88457e-01_JPRB, 5.87474e-01_JPRB, &
     & 5.86493e-01_JPRB, 5.85514e-01_JPRB, 5.84536e-01_JPRB, 5.83559e-01_JPRB, 5.82585e-01_JPRB, &
     & 5.81612e-01_JPRB, 5.80640e-01_JPRB, 5.79671e-01_JPRB, 5.78703e-01_JPRB, 5.77736e-01_JPRB, &
     & 5.76771e-01_JPRB, 5.75808e-01_JPRB, 5.74846e-01_JPRB, 5.73886e-01_JPRB/)
      kao_mn2o( 7, :, 6) = (/ &
     & 3.68189e-01_JPRB, 3.70029e-01_JPRB, 3.71877e-01_JPRB, 3.73735e-01_JPRB, 3.75603e-01_JPRB, &
     & 3.77479e-01_JPRB, 3.79365e-01_JPRB, 3.81260e-01_JPRB, 3.83165e-01_JPRB, 3.85079e-01_JPRB, &
     & 3.87003e-01_JPRB, 3.88937e-01_JPRB, 3.90880e-01_JPRB, 3.92833e-01_JPRB, 3.94795e-01_JPRB, &
     & 3.96768e-01_JPRB, 3.98750e-01_JPRB, 4.00742e-01_JPRB, 4.02744e-01_JPRB/)
      kao_mn2o( 8, :, 6) = (/ &
     & 2.98721e-01_JPRB, 2.99932e-01_JPRB, 3.01149e-01_JPRB, 3.02370e-01_JPRB, 3.03597e-01_JPRB, &
     & 3.04828e-01_JPRB, 3.06064e-01_JPRB, 3.07306e-01_JPRB, 3.08552e-01_JPRB, 3.09804e-01_JPRB, &
     & 3.11060e-01_JPRB, 3.12322e-01_JPRB, 3.13589e-01_JPRB, 3.14860e-01_JPRB, 3.16138e-01_JPRB, &
     & 3.17420e-01_JPRB, 3.18707e-01_JPRB, 3.20000e-01_JPRB, 3.21298e-01_JPRB/)
      kao_mn2o( 9, :, 6) = (/ &
     & 3.76116e-01_JPRB, 3.77276e-01_JPRB, 3.78439e-01_JPRB, 3.79606e-01_JPRB, 3.80777e-01_JPRB, &
     & 3.81951e-01_JPRB, 3.83129e-01_JPRB, 3.84310e-01_JPRB, 3.85495e-01_JPRB, 3.86684e-01_JPRB, &
     & 3.87876e-01_JPRB, 3.89072e-01_JPRB, 3.90272e-01_JPRB, 3.91475e-01_JPRB, 3.92682e-01_JPRB, &
     & 3.93893e-01_JPRB, 3.95107e-01_JPRB, 3.96326e-01_JPRB, 3.97548e-01_JPRB/)
      kao_mn2o( 1, :, 7) = (/ &
     & 3.22705e+00_JPRB, 3.21966e+00_JPRB, 3.21230e+00_JPRB, 3.20494e+00_JPRB, 3.19761e+00_JPRB, &
     & 3.19029e+00_JPRB, 3.18299e+00_JPRB, 3.17571e+00_JPRB, 3.16844e+00_JPRB, 3.16119e+00_JPRB, &
     & 3.15395e+00_JPRB, 3.14673e+00_JPRB, 3.13953e+00_JPRB, 3.13235e+00_JPRB, 3.12518e+00_JPRB, &
     & 3.11803e+00_JPRB, 3.11089e+00_JPRB, 3.10377e+00_JPRB, 3.09667e+00_JPRB/)
      kao_mn2o( 2, :, 7) = (/ &
     & 1.43811e+00_JPRB, 1.42367e+00_JPRB, 1.40938e+00_JPRB, 1.39522e+00_JPRB, 1.38121e+00_JPRB, &
     & 1.36735e+00_JPRB, 1.35362e+00_JPRB, 1.34002e+00_JPRB, 1.32657e+00_JPRB, 1.31325e+00_JPRB, &
     & 1.30006e+00_JPRB, 1.28701e+00_JPRB, 1.27408e+00_JPRB, 1.26129e+00_JPRB, 1.24862e+00_JPRB, &
     & 1.23609e+00_JPRB, 1.22367e+00_JPRB, 1.21139e+00_JPRB, 1.19922e+00_JPRB/)
      kao_mn2o( 3, :, 7) = (/ &
     & 1.22586e+00_JPRB, 1.21639e+00_JPRB, 1.20700e+00_JPRB, 1.19767e+00_JPRB, 1.18842e+00_JPRB, &
     & 1.17924e+00_JPRB, 1.17014e+00_JPRB, 1.16110e+00_JPRB, 1.15213e+00_JPRB, 1.14323e+00_JPRB, &
     & 1.13440e+00_JPRB, 1.12564e+00_JPRB, 1.11695e+00_JPRB, 1.10832e+00_JPRB, 1.09976e+00_JPRB, &
     & 1.09127e+00_JPRB, 1.08284e+00_JPRB, 1.07447e+00_JPRB, 1.06618e+00_JPRB/)
      kao_mn2o( 4, :, 7) = (/ &
     & 7.94380e-01_JPRB, 7.92795e-01_JPRB, 7.91213e-01_JPRB, 7.89634e-01_JPRB, 7.88059e-01_JPRB, &
     & 7.86486e-01_JPRB, 7.84917e-01_JPRB, 7.83351e-01_JPRB, 7.81787e-01_JPRB, 7.80227e-01_JPRB, &
     & 7.78671e-01_JPRB, 7.77117e-01_JPRB, 7.75566e-01_JPRB, 7.74019e-01_JPRB, 7.72474e-01_JPRB, &
     & 7.70933e-01_JPRB, 7.69394e-01_JPRB, 7.67859e-01_JPRB, 7.66327e-01_JPRB/)
      kao_mn2o( 5, :, 7) = (/ &
     & 4.46935e-01_JPRB, 4.49760e-01_JPRB, 4.52602e-01_JPRB, 4.55462e-01_JPRB, 4.58340e-01_JPRB, &
     & 4.61237e-01_JPRB, 4.64152e-01_JPRB, 4.67085e-01_JPRB, 4.70037e-01_JPRB, 4.73007e-01_JPRB, &
     & 4.75996e-01_JPRB, 4.79004e-01_JPRB, 4.82031e-01_JPRB, 4.85078e-01_JPRB, 4.88143e-01_JPRB, &
     & 4.91228e-01_JPRB, 4.94332e-01_JPRB, 4.97456e-01_JPRB, 5.00600e-01_JPRB/)
      kao_mn2o( 6, :, 7) = (/ &
     & 4.20211e-01_JPRB, 4.21711e-01_JPRB, 4.23216e-01_JPRB, 4.24726e-01_JPRB, 4.26242e-01_JPRB, &
     & 4.27763e-01_JPRB, 4.29290e-01_JPRB, 4.30822e-01_JPRB, 4.32359e-01_JPRB, 4.33902e-01_JPRB, &
     & 4.35450e-01_JPRB, 4.37004e-01_JPRB, 4.38564e-01_JPRB, 4.40129e-01_JPRB, 4.41700e-01_JPRB, &
     & 4.43276e-01_JPRB, 4.44858e-01_JPRB, 4.46445e-01_JPRB, 4.48038e-01_JPRB/)
      kao_mn2o( 7, :, 7) = (/ &
     & 3.42094e-01_JPRB, 3.43589e-01_JPRB, 3.45091e-01_JPRB, 3.46600e-01_JPRB, 3.48115e-01_JPRB, &
     & 3.49637e-01_JPRB, 3.51165e-01_JPRB, 3.52700e-01_JPRB, 3.54242e-01_JPRB, 3.55791e-01_JPRB, &
     & 3.57346e-01_JPRB, 3.58908e-01_JPRB, 3.60477e-01_JPRB, 3.62053e-01_JPRB, 3.63636e-01_JPRB, &
     & 3.65225e-01_JPRB, 3.66822e-01_JPRB, 3.68426e-01_JPRB, 3.70036e-01_JPRB/)
      kao_mn2o( 8, :, 7) = (/ &
     & 2.94919e-01_JPRB, 2.97460e-01_JPRB, 3.00022e-01_JPRB, 3.02606e-01_JPRB, 3.05212e-01_JPRB, &
     & 3.07841e-01_JPRB, 3.10492e-01_JPRB, 3.13167e-01_JPRB, 3.15864e-01_JPRB, 3.18584e-01_JPRB, &
     & 3.21328e-01_JPRB, 3.24096e-01_JPRB, 3.26887e-01_JPRB, 3.29703e-01_JPRB, 3.32543e-01_JPRB, &
     & 3.35407e-01_JPRB, 3.38296e-01_JPRB, 3.41210e-01_JPRB, 3.44148e-01_JPRB/)
      kao_mn2o( 9, :, 7) = (/ &
     & 2.97441e-01_JPRB, 2.99207e-01_JPRB, 3.00984e-01_JPRB, 3.02772e-01_JPRB, 3.04570e-01_JPRB, &
     & 3.06379e-01_JPRB, 3.08199e-01_JPRB, 3.10029e-01_JPRB, 3.11870e-01_JPRB, 3.13723e-01_JPRB, &
     & 3.15586e-01_JPRB, 3.17460e-01_JPRB, 3.19345e-01_JPRB, 3.21242e-01_JPRB, 3.23150e-01_JPRB, &
     & 3.25069e-01_JPRB, 3.27000e-01_JPRB, 3.28942e-01_JPRB, 3.30895e-01_JPRB/)
      kao_mn2o( 1, :, 8) = (/ &
     & 2.14641e+00_JPRB, 2.12585e+00_JPRB, 2.10549e+00_JPRB, 2.08532e+00_JPRB, 2.06534e+00_JPRB, &
     & 2.04556e+00_JPRB, 2.02596e+00_JPRB, 2.00656e+00_JPRB, 1.98733e+00_JPRB, 1.96830e+00_JPRB, &
     & 1.94944e+00_JPRB, 1.93077e+00_JPRB, 1.91227e+00_JPRB, 1.89395e+00_JPRB, 1.87581e+00_JPRB, &
     & 1.85784e+00_JPRB, 1.84004e+00_JPRB, 1.82242e+00_JPRB, 1.80496e+00_JPRB/)
      kao_mn2o( 2, :, 8) = (/ &
     & 8.83687e-01_JPRB, 8.83170e-01_JPRB, 8.82654e-01_JPRB, 8.82137e-01_JPRB, 8.81621e-01_JPRB, &
     & 8.81106e-01_JPRB, 8.80590e-01_JPRB, 8.80075e-01_JPRB, 8.79560e-01_JPRB, 8.79046e-01_JPRB, &
     & 8.78531e-01_JPRB, 8.78017e-01_JPRB, 8.77504e-01_JPRB, 8.76990e-01_JPRB, 8.76477e-01_JPRB, &
     & 8.75965e-01_JPRB, 8.75452e-01_JPRB, 8.74940e-01_JPRB, 8.74428e-01_JPRB/)
      kao_mn2o( 3, :, 8) = (/ &
     & 4.49840e-01_JPRB, 4.52683e-01_JPRB, 4.55543e-01_JPRB, 4.58421e-01_JPRB, 4.61318e-01_JPRB, &
     & 4.64233e-01_JPRB, 4.67166e-01_JPRB, 4.70118e-01_JPRB, 4.73088e-01_JPRB, 4.76078e-01_JPRB, &
     & 4.79086e-01_JPRB, 4.82113e-01_JPRB, 4.85159e-01_JPRB, 4.88225e-01_JPRB, 4.91310e-01_JPRB, &
     & 4.94414e-01_JPRB, 4.97538e-01_JPRB, 5.00682e-01_JPRB, 5.03845e-01_JPRB/)
      kao_mn2o( 4, :, 8) = (/ &
     & 3.92292e-01_JPRB, 3.93574e-01_JPRB, 3.94861e-01_JPRB, 3.96151e-01_JPRB, 3.97446e-01_JPRB, &
     & 3.98746e-01_JPRB, 4.00049e-01_JPRB, 4.01357e-01_JPRB, 4.02669e-01_JPRB, 4.03985e-01_JPRB, &
     & 4.05306e-01_JPRB, 4.06630e-01_JPRB, 4.07960e-01_JPRB, 4.09293e-01_JPRB, 4.10631e-01_JPRB, &
     & 4.11973e-01_JPRB, 4.13320e-01_JPRB, 4.14671e-01_JPRB, 4.16027e-01_JPRB/)
      kao_mn2o( 5, :, 8) = (/ &
     & 3.38920e-01_JPRB, 3.41151e-01_JPRB, 3.43397e-01_JPRB, 3.45658e-01_JPRB, 3.47934e-01_JPRB, &
     & 3.50225e-01_JPRB, 3.52531e-01_JPRB, 3.54852e-01_JPRB, 3.57189e-01_JPRB, 3.59541e-01_JPRB, &
     & 3.61908e-01_JPRB, 3.64291e-01_JPRB, 3.66689e-01_JPRB, 3.69104e-01_JPRB, 3.71534e-01_JPRB, &
     & 3.73980e-01_JPRB, 3.76443e-01_JPRB, 3.78921e-01_JPRB, 3.81416e-01_JPRB/)
      kao_mn2o( 6, :, 8) = (/ &
     & 3.01673e-01_JPRB, 3.04752e-01_JPRB, 3.07863e-01_JPRB, 3.11005e-01_JPRB, 3.14180e-01_JPRB, &
     & 3.17387e-01_JPRB, 3.20626e-01_JPRB, 3.23899e-01_JPRB, 3.27205e-01_JPRB, 3.30545e-01_JPRB, &
     & 3.33919e-01_JPRB, 3.37328e-01_JPRB, 3.40771e-01_JPRB, 3.44249e-01_JPRB, 3.47763e-01_JPRB, &
     & 3.51313e-01_JPRB, 3.54899e-01_JPRB, 3.58521e-01_JPRB, 3.62181e-01_JPRB/)
      kao_mn2o( 7, :, 8) = (/ &
     & 2.99381e-01_JPRB, 3.02431e-01_JPRB, 3.05512e-01_JPRB, 3.08624e-01_JPRB, 3.11768e-01_JPRB, &
     & 3.14945e-01_JPRB, 3.18153e-01_JPRB, 3.21394e-01_JPRB, 3.24668e-01_JPRB, 3.27976e-01_JPRB, &
     & 3.31317e-01_JPRB, 3.34693e-01_JPRB, 3.38102e-01_JPRB, 3.41547e-01_JPRB, 3.45026e-01_JPRB, &
     & 3.48541e-01_JPRB, 3.52092e-01_JPRB, 3.55679e-01_JPRB, 3.59302e-01_JPRB/)
      kao_mn2o( 8, :, 8) = (/ &
     & 2.87559e-01_JPRB, 2.89153e-01_JPRB, 2.90756e-01_JPRB, 2.92367e-01_JPRB, 2.93987e-01_JPRB, &
     & 2.95617e-01_JPRB, 2.97255e-01_JPRB, 2.98902e-01_JPRB, 3.00559e-01_JPRB, 3.02225e-01_JPRB, &
     & 3.03899e-01_JPRB, 3.05584e-01_JPRB, 3.07277e-01_JPRB, 3.08980e-01_JPRB, 3.10693e-01_JPRB, &
     & 3.12414e-01_JPRB, 3.14146e-01_JPRB, 3.15887e-01_JPRB, 3.17638e-01_JPRB/)
      kao_mn2o( 9, :, 8) = (/ &
     & 2.96238e-01_JPRB, 2.97588e-01_JPRB, 2.98945e-01_JPRB, 3.00309e-01_JPRB, 3.01678e-01_JPRB, &
     & 3.03054e-01_JPRB, 3.04436e-01_JPRB, 3.05824e-01_JPRB, 3.07219e-01_JPRB, 3.08620e-01_JPRB, &
     & 3.10027e-01_JPRB, 3.11441e-01_JPRB, 3.12861e-01_JPRB, 3.14288e-01_JPRB, 3.15721e-01_JPRB, &
     & 3.17161e-01_JPRB, 3.18607e-01_JPRB, 3.20060e-01_JPRB, 3.21520e-01_JPRB/)
      kao_mn2o( 1, :, 9) = (/ &
     & 1.56483e+00_JPRB, 1.55792e+00_JPRB, 1.55105e+00_JPRB, 1.54420e+00_JPRB, 1.53739e+00_JPRB, &
     & 1.53060e+00_JPRB, 1.52384e+00_JPRB, 1.51712e+00_JPRB, 1.51042e+00_JPRB, 1.50376e+00_JPRB, &
     & 1.49712e+00_JPRB, 1.49051e+00_JPRB, 1.48393e+00_JPRB, 1.47738e+00_JPRB, 1.47086e+00_JPRB, &
     & 1.46437e+00_JPRB, 1.45791e+00_JPRB, 1.45147e+00_JPRB, 1.44507e+00_JPRB/)
      kao_mn2o( 2, :, 9) = (/ &
     & 4.09526e-01_JPRB, 4.10301e-01_JPRB, 4.11078e-01_JPRB, 4.11857e-01_JPRB, 4.12637e-01_JPRB, &
     & 4.13418e-01_JPRB, 4.14201e-01_JPRB, 4.14986e-01_JPRB, 4.15771e-01_JPRB, 4.16559e-01_JPRB, &
     & 4.17348e-01_JPRB, 4.18138e-01_JPRB, 4.18930e-01_JPRB, 4.19723e-01_JPRB, 4.20518e-01_JPRB, &
     & 4.21315e-01_JPRB, 4.22112e-01_JPRB, 4.22912e-01_JPRB, 4.23713e-01_JPRB/)
      kao_mn2o( 3, :, 9) = (/ &
     & 3.35672e-01_JPRB, 3.38982e-01_JPRB, 3.42326e-01_JPRB, 3.45702e-01_JPRB, 3.49111e-01_JPRB, &
     & 3.52554e-01_JPRB, 3.56031e-01_JPRB, 3.59543e-01_JPRB, 3.63089e-01_JPRB, 3.66670e-01_JPRB, &
     & 3.70286e-01_JPRB, 3.73938e-01_JPRB, 3.77626e-01_JPRB, 3.81350e-01_JPRB, 3.85111e-01_JPRB, &
     & 3.88909e-01_JPRB, 3.92745e-01_JPRB, 3.96618e-01_JPRB, 4.00530e-01_JPRB/)
      kao_mn2o( 4, :, 9) = (/ &
     & 3.19130e-01_JPRB, 3.23028e-01_JPRB, 3.26973e-01_JPRB, 3.30966e-01_JPRB, 3.35008e-01_JPRB, &
     & 3.39100e-01_JPRB, 3.43241e-01_JPRB, 3.47433e-01_JPRB, 3.51676e-01_JPRB, 3.55971e-01_JPRB, &
     & 3.60319e-01_JPRB, 3.64719e-01_JPRB, 3.69173e-01_JPRB, 3.73682e-01_JPRB, 3.78246e-01_JPRB, &
     & 3.82865e-01_JPRB, 3.87541e-01_JPRB, 3.92274e-01_JPRB, 3.97065e-01_JPRB/)
      kao_mn2o( 5, :, 9) = (/ &
     & 3.04385e-01_JPRB, 3.07155e-01_JPRB, 3.09949e-01_JPRB, 3.12770e-01_JPRB, 3.15616e-01_JPRB, &
     & 3.18488e-01_JPRB, 3.21386e-01_JPRB, 3.24310e-01_JPRB, 3.27261e-01_JPRB, 3.30239e-01_JPRB, &
     & 3.33244e-01_JPRB, 3.36276e-01_JPRB, 3.39336e-01_JPRB, 3.42424e-01_JPRB, 3.45540e-01_JPRB, &
     & 3.48684e-01_JPRB, 3.51857e-01_JPRB, 3.55059e-01_JPRB, 3.58289e-01_JPRB/)
      kao_mn2o( 6, :, 9) = (/ &
     & 2.98789e-01_JPRB, 3.00996e-01_JPRB, 3.03220e-01_JPRB, 3.05460e-01_JPRB, 3.07717e-01_JPRB, &
     & 3.09990e-01_JPRB, 3.12281e-01_JPRB, 3.14588e-01_JPRB, 3.16912e-01_JPRB, 3.19253e-01_JPRB, &
     & 3.21612e-01_JPRB, 3.23988e-01_JPRB, 3.26382e-01_JPRB, 3.28793e-01_JPRB, 3.31222e-01_JPRB, &
     & 3.33669e-01_JPRB, 3.36134e-01_JPRB, 3.38618e-01_JPRB, 3.41119e-01_JPRB/)
      kao_mn2o( 7, :, 9) = (/ &
     & 3.08712e-01_JPRB, 3.10491e-01_JPRB, 3.12281e-01_JPRB, 3.14080e-01_JPRB, 3.15890e-01_JPRB, &
     & 3.17710e-01_JPRB, 3.19541e-01_JPRB, 3.21382e-01_JPRB, 3.23234e-01_JPRB, 3.25097e-01_JPRB, &
     & 3.26970e-01_JPRB, 3.28854e-01_JPRB, 3.30749e-01_JPRB, 3.32655e-01_JPRB, 3.34572e-01_JPRB, &
     & 3.36500e-01_JPRB, 3.38439e-01_JPRB, 3.40390e-01_JPRB, 3.42351e-01_JPRB/)
      kao_mn2o( 8, :, 9) = (/ &
     & 3.10571e-01_JPRB, 3.12262e-01_JPRB, 3.13961e-01_JPRB, 3.15670e-01_JPRB, 3.17388e-01_JPRB, &
     & 3.19115e-01_JPRB, 3.20852e-01_JPRB, 3.22598e-01_JPRB, 3.24354e-01_JPRB, 3.26120e-01_JPRB, &
     & 3.27895e-01_JPRB, 3.29679e-01_JPRB, 3.31474e-01_JPRB, 3.33278e-01_JPRB, 3.35092e-01_JPRB, &
     & 3.36915e-01_JPRB, 3.38749e-01_JPRB, 3.40593e-01_JPRB, 3.42447e-01_JPRB/)
      kao_mn2o( 9, :, 9) = (/ &
     & 3.16436e-01_JPRB, 3.18200e-01_JPRB, 3.19974e-01_JPRB, 3.21759e-01_JPRB, 3.23553e-01_JPRB, &
     & 3.25357e-01_JPRB, 3.27172e-01_JPRB, 3.28996e-01_JPRB, 3.30831e-01_JPRB, 3.32675e-01_JPRB, &
     & 3.34530e-01_JPRB, 3.36396e-01_JPRB, 3.38272e-01_JPRB, 3.40158e-01_JPRB, 3.42055e-01_JPRB, &
     & 3.43962e-01_JPRB, 3.45880e-01_JPRB, 3.47809e-01_JPRB, 3.49749e-01_JPRB/)
      kao_mn2o( 1, :,10) = (/ &
     & 7.68616e-01_JPRB, 7.63263e-01_JPRB, 7.57948e-01_JPRB, 7.52669e-01_JPRB, 7.47428e-01_JPRB, &
     & 7.42223e-01_JPRB, 7.37054e-01_JPRB, 7.31921e-01_JPRB, 7.26824e-01_JPRB, 7.21762e-01_JPRB, &
     & 7.16736e-01_JPRB, 7.11744e-01_JPRB, 7.06788e-01_JPRB, 7.01866e-01_JPRB, 6.96978e-01_JPRB, &
     & 6.92124e-01_JPRB, 6.87304e-01_JPRB, 6.82517e-01_JPRB, 6.77764e-01_JPRB/)
      kao_mn2o( 2, :,10) = (/ &
     & 4.97271e-01_JPRB, 5.10054e-01_JPRB, 5.23165e-01_JPRB, 5.36614e-01_JPRB, 5.50408e-01_JPRB, &
     & 5.64556e-01_JPRB, 5.79069e-01_JPRB, 5.93954e-01_JPRB, 6.09222e-01_JPRB, 6.24883e-01_JPRB, &
     & 6.40946e-01_JPRB, 6.57422e-01_JPRB, 6.74321e-01_JPRB, 6.91655e-01_JPRB, 7.09435e-01_JPRB, &
     & 7.27671e-01_JPRB, 7.46377e-01_JPRB, 7.65563e-01_JPRB, 7.85242e-01_JPRB/)
      kao_mn2o( 3, :,10) = (/ &
     & 2.44443e-01_JPRB, 2.47096e-01_JPRB, 2.49778e-01_JPRB, 2.52489e-01_JPRB, 2.55229e-01_JPRB, &
     & 2.57999e-01_JPRB, 2.60799e-01_JPRB, 2.63630e-01_JPRB, 2.66491e-01_JPRB, 2.69383e-01_JPRB, &
     & 2.72307e-01_JPRB, 2.75262e-01_JPRB, 2.78250e-01_JPRB, 2.81269e-01_JPRB, 2.84322e-01_JPRB, &
     & 2.87408e-01_JPRB, 2.90527e-01_JPRB, 2.93680e-01_JPRB, 2.96868e-01_JPRB/)
      kao_mn2o( 4, :,10) = (/ &
     & 2.01964e-01_JPRB, 2.02869e-01_JPRB, 2.03777e-01_JPRB, 2.04690e-01_JPRB, 2.05606e-01_JPRB, &
     & 2.06527e-01_JPRB, 2.07452e-01_JPRB, 2.08381e-01_JPRB, 2.09314e-01_JPRB, 2.10251e-01_JPRB, &
     & 2.11193e-01_JPRB, 2.12139e-01_JPRB, 2.13089e-01_JPRB, 2.14043e-01_JPRB, 2.15002e-01_JPRB, &
     & 2.15964e-01_JPRB, 2.16932e-01_JPRB, 2.17903e-01_JPRB, 2.18879e-01_JPRB/)
      kao_mn2o( 5, :,10) = (/ &
     & 2.56972e-01_JPRB, 2.56837e-01_JPRB, 2.56702e-01_JPRB, 2.56567e-01_JPRB, 2.56432e-01_JPRB, &
     & 2.56297e-01_JPRB, 2.56162e-01_JPRB, 2.56027e-01_JPRB, 2.55893e-01_JPRB, 2.55758e-01_JPRB, &
     & 2.55624e-01_JPRB, 2.55489e-01_JPRB, 2.55355e-01_JPRB, 2.55220e-01_JPRB, 2.55086e-01_JPRB, &
     & 2.54952e-01_JPRB, 2.54818e-01_JPRB, 2.54684e-01_JPRB, 2.54550e-01_JPRB/)
      kao_mn2o( 6, :,10) = (/ &
     & 2.57322e-01_JPRB, 2.57187e-01_JPRB, 2.57052e-01_JPRB, 2.56917e-01_JPRB, 2.56782e-01_JPRB, &
     & 2.56647e-01_JPRB, 2.56512e-01_JPRB, 2.56377e-01_JPRB, 2.56243e-01_JPRB, 2.56108e-01_JPRB, &
     & 2.55974e-01_JPRB, 2.55839e-01_JPRB, 2.55705e-01_JPRB, 2.55570e-01_JPRB, 2.55436e-01_JPRB, &
     & 2.55302e-01_JPRB, 2.55168e-01_JPRB, 2.55034e-01_JPRB, 2.54900e-01_JPRB/)
      kao_mn2o( 7, :,10) = (/ &
     & 2.56551e-01_JPRB, 2.56421e-01_JPRB, 2.56291e-01_JPRB, 2.56161e-01_JPRB, 2.56030e-01_JPRB, &
     & 2.55900e-01_JPRB, 2.55770e-01_JPRB, 2.55640e-01_JPRB, 2.55511e-01_JPRB, 2.55381e-01_JPRB, &
     & 2.55251e-01_JPRB, 2.55121e-01_JPRB, 2.54992e-01_JPRB, 2.54862e-01_JPRB, 2.54733e-01_JPRB, &
     & 2.54603e-01_JPRB, 2.54474e-01_JPRB, 2.54345e-01_JPRB, 2.54215e-01_JPRB/)
      kao_mn2o( 8, :,10) = (/ &
     & 2.73629e-01_JPRB, 2.73460e-01_JPRB, 2.73291e-01_JPRB, 2.73122e-01_JPRB, 2.72953e-01_JPRB, &
     & 2.72784e-01_JPRB, 2.72615e-01_JPRB, 2.72447e-01_JPRB, 2.72279e-01_JPRB, 2.72110e-01_JPRB, &
     & 2.71942e-01_JPRB, 2.71774e-01_JPRB, 2.71606e-01_JPRB, 2.71438e-01_JPRB, 2.71270e-01_JPRB, &
     & 2.71102e-01_JPRB, 2.70935e-01_JPRB, 2.70767e-01_JPRB, 2.70600e-01_JPRB/)
      kao_mn2o( 9, :,10) = (/ &
     & 2.57294e-01_JPRB, 2.57149e-01_JPRB, 2.57004e-01_JPRB, 2.56860e-01_JPRB, 2.56715e-01_JPRB, &
     & 2.56570e-01_JPRB, 2.56426e-01_JPRB, 2.56282e-01_JPRB, 2.56137e-01_JPRB, 2.55993e-01_JPRB, &
     & 2.55849e-01_JPRB, 2.55705e-01_JPRB, 2.55561e-01_JPRB, 2.55417e-01_JPRB, 2.55273e-01_JPRB, &
     & 2.55129e-01_JPRB, 2.54986e-01_JPRB, 2.54842e-01_JPRB, 2.54698e-01_JPRB/)
      kao_mn2o( 1, :,11) = (/ &
     & 6.91062e-01_JPRB, 6.84151e-01_JPRB, 6.77309e-01_JPRB, 6.70535e-01_JPRB, 6.63829e-01_JPRB, &
     & 6.57190e-01_JPRB, 6.50617e-01_JPRB, 6.44111e-01_JPRB, 6.37669e-01_JPRB, 6.31292e-01_JPRB, &
     & 6.24978e-01_JPRB, 6.18728e-01_JPRB, 6.12540e-01_JPRB, 6.06414e-01_JPRB, 6.00349e-01_JPRB, &
     & 5.94345e-01_JPRB, 5.88401e-01_JPRB, 5.82517e-01_JPRB, 5.76691e-01_JPRB/)
      kao_mn2o( 2, :,11) = (/ &
     & 1.98698e-01_JPRB, 2.01182e-01_JPRB, 2.03698e-01_JPRB, 2.06244e-01_JPRB, 2.08823e-01_JPRB, &
     & 2.11433e-01_JPRB, 2.14077e-01_JPRB, 2.16753e-01_JPRB, 2.19463e-01_JPRB, 2.22207e-01_JPRB, &
     & 2.24985e-01_JPRB, 2.27798e-01_JPRB, 2.30646e-01_JPRB, 2.33529e-01_JPRB, 2.36449e-01_JPRB, &
     & 2.39405e-01_JPRB, 2.42398e-01_JPRB, 2.45429e-01_JPRB, 2.48497e-01_JPRB/)
      kao_mn2o( 3, :,11) = (/ &
     & 2.11950e-01_JPRB, 2.13560e-01_JPRB, 2.15184e-01_JPRB, 2.16819e-01_JPRB, 2.18467e-01_JPRB, &
     & 2.20127e-01_JPRB, 2.21800e-01_JPRB, 2.23486e-01_JPRB, 2.25185e-01_JPRB, 2.26896e-01_JPRB, &
     & 2.28621e-01_JPRB, 2.30358e-01_JPRB, 2.32109e-01_JPRB, 2.33873e-01_JPRB, 2.35651e-01_JPRB, &
     & 2.37442e-01_JPRB, 2.39247e-01_JPRB, 2.41065e-01_JPRB, 2.42897e-01_JPRB/)
      kao_mn2o( 4, :,11) = (/ &
     & 3.14210e-01_JPRB, 3.13143e-01_JPRB, 3.12080e-01_JPRB, 3.11021e-01_JPRB, 3.09965e-01_JPRB, &
     & 3.08913e-01_JPRB, 3.07864e-01_JPRB, 3.06819e-01_JPRB, 3.05777e-01_JPRB, 3.04739e-01_JPRB, &
     & 3.03705e-01_JPRB, 3.02674e-01_JPRB, 3.01646e-01_JPRB, 3.00622e-01_JPRB, 2.99602e-01_JPRB, &
     & 2.98584e-01_JPRB, 2.97571e-01_JPRB, 2.96561e-01_JPRB, 2.95554e-01_JPRB/)
      kao_mn2o( 5, :,11) = (/ &
     & 3.13536e-01_JPRB, 3.12459e-01_JPRB, 3.11386e-01_JPRB, 3.10316e-01_JPRB, 3.09250e-01_JPRB, &
     & 3.08188e-01_JPRB, 3.07129e-01_JPRB, 3.06074e-01_JPRB, 3.05022e-01_JPRB, 3.03974e-01_JPRB, &
     & 3.02930e-01_JPRB, 3.01889e-01_JPRB, 3.00852e-01_JPRB, 2.99819e-01_JPRB, 2.98789e-01_JPRB, &
     & 2.97762e-01_JPRB, 2.96739e-01_JPRB, 2.95720e-01_JPRB, 2.94704e-01_JPRB/)
      kao_mn2o( 6, :,11) = (/ &
     & 3.13215e-01_JPRB, 3.12123e-01_JPRB, 3.11034e-01_JPRB, 3.09949e-01_JPRB, 3.08867e-01_JPRB, &
     & 3.07790e-01_JPRB, 3.06716e-01_JPRB, 3.05646e-01_JPRB, 3.04579e-01_JPRB, 3.03517e-01_JPRB, &
     & 3.02458e-01_JPRB, 3.01403e-01_JPRB, 3.00351e-01_JPRB, 2.99303e-01_JPRB, 2.98259e-01_JPRB, &
     & 2.97219e-01_JPRB, 2.96182e-01_JPRB, 2.95148e-01_JPRB, 2.94119e-01_JPRB/)
      kao_mn2o( 7, :,11) = (/ &
     & 3.14236e-01_JPRB, 3.13123e-01_JPRB, 3.12014e-01_JPRB, 3.10908e-01_JPRB, 3.09806e-01_JPRB, &
     & 3.08709e-01_JPRB, 3.07615e-01_JPRB, 3.06525e-01_JPRB, 3.05439e-01_JPRB, 3.04357e-01_JPRB, &
     & 3.03278e-01_JPRB, 3.02204e-01_JPRB, 3.01133e-01_JPRB, 3.00066e-01_JPRB, 2.99003e-01_JPRB, &
     & 2.97944e-01_JPRB, 2.96888e-01_JPRB, 2.95836e-01_JPRB, 2.94788e-01_JPRB/)
      kao_mn2o( 8, :,11) = (/ &
     & 2.97453e-01_JPRB, 2.96420e-01_JPRB, 2.95391e-01_JPRB, 2.94366e-01_JPRB, 2.93344e-01_JPRB, &
     & 2.92325e-01_JPRB, 2.91311e-01_JPRB, 2.90299e-01_JPRB, 2.89291e-01_JPRB, 2.88287e-01_JPRB, &
     & 2.87286e-01_JPRB, 2.86289e-01_JPRB, 2.85295e-01_JPRB, 2.84304e-01_JPRB, 2.83317e-01_JPRB, &
     & 2.82334e-01_JPRB, 2.81354e-01_JPRB, 2.80377e-01_JPRB, 2.79404e-01_JPRB/)
      kao_mn2o( 9, :,11) = (/ &
     & 3.12694e-01_JPRB, 3.11622e-01_JPRB, 3.10554e-01_JPRB, 3.09489e-01_JPRB, 3.08428e-01_JPRB, &
     & 3.07370e-01_JPRB, 3.06316e-01_JPRB, 3.05266e-01_JPRB, 3.04220e-01_JPRB, 3.03177e-01_JPRB, &
     & 3.02137e-01_JPRB, 3.01101e-01_JPRB, 3.00069e-01_JPRB, 2.99040e-01_JPRB, 2.98015e-01_JPRB, &
     & 2.96993e-01_JPRB, 2.95975e-01_JPRB, 2.94960e-01_JPRB, 2.93949e-01_JPRB/)
      kao_mn2o( 1, :,12) = (/ &
     & 5.30796e-01_JPRB, 5.50444e-01_JPRB, 5.70818e-01_JPRB, 5.91947e-01_JPRB, 6.13857e-01_JPRB, &
     & 6.36579e-01_JPRB, 6.60142e-01_JPRB, 6.84577e-01_JPRB, 7.09916e-01_JPRB, 7.36194e-01_JPRB, &
     & 7.63444e-01_JPRB, 7.91702e-01_JPRB, 8.21007e-01_JPRB, 8.51396e-01_JPRB, 8.82910e-01_JPRB, &
     & 9.15591e-01_JPRB, 9.49481e-01_JPRB, 9.84626e-01_JPRB, 1.02107e+00_JPRB/)
      kao_mn2o( 2, :,12) = (/ &
     & 1.38469e-01_JPRB, 1.40959e-01_JPRB, 1.43493e-01_JPRB, 1.46073e-01_JPRB, 1.48699e-01_JPRB, &
     & 1.51373e-01_JPRB, 1.54094e-01_JPRB, 1.56865e-01_JPRB, 1.59685e-01_JPRB, 1.62556e-01_JPRB, &
     & 1.65478e-01_JPRB, 1.68454e-01_JPRB, 1.71482e-01_JPRB, 1.74565e-01_JPRB, 1.77704e-01_JPRB, &
     & 1.80899e-01_JPRB, 1.84151e-01_JPRB, 1.87462e-01_JPRB, 1.90833e-01_JPRB/)
      kao_mn2o( 3, :,12) = (/ &
     & 1.50741e-01_JPRB, 1.50855e-01_JPRB, 1.50969e-01_JPRB, 1.51084e-01_JPRB, 1.51198e-01_JPRB, &
     & 1.51313e-01_JPRB, 1.51427e-01_JPRB, 1.51542e-01_JPRB, 1.51657e-01_JPRB, 1.51772e-01_JPRB, &
     & 1.51887e-01_JPRB, 1.52002e-01_JPRB, 1.52117e-01_JPRB, 1.52233e-01_JPRB, 1.52348e-01_JPRB, &
     & 1.52463e-01_JPRB, 1.52579e-01_JPRB, 1.52695e-01_JPRB, 1.52810e-01_JPRB/)
      kao_mn2o( 4, :,12) = (/ &
     & 1.80444e-01_JPRB, 1.79944e-01_JPRB, 1.79445e-01_JPRB, 1.78948e-01_JPRB, 1.78452e-01_JPRB, &
     & 1.77958e-01_JPRB, 1.77465e-01_JPRB, 1.76973e-01_JPRB, 1.76483e-01_JPRB, 1.75994e-01_JPRB, &
     & 1.75506e-01_JPRB, 1.75020e-01_JPRB, 1.74535e-01_JPRB, 1.74051e-01_JPRB, 1.73569e-01_JPRB, &
     & 1.73088e-01_JPRB, 1.72609e-01_JPRB, 1.72131e-01_JPRB, 1.71654e-01_JPRB/)
      kao_mn2o( 5, :,12) = (/ &
     & 1.80595e-01_JPRB, 1.80033e-01_JPRB, 1.79474e-01_JPRB, 1.78916e-01_JPRB, 1.78359e-01_JPRB, &
     & 1.77805e-01_JPRB, 1.77252e-01_JPRB, 1.76701e-01_JPRB, 1.76152e-01_JPRB, 1.75604e-01_JPRB, &
     & 1.75058e-01_JPRB, 1.74514e-01_JPRB, 1.73971e-01_JPRB, 1.73430e-01_JPRB, 1.72891e-01_JPRB, &
     & 1.72354e-01_JPRB, 1.71818e-01_JPRB, 1.71284e-01_JPRB, 1.70751e-01_JPRB/)
      kao_mn2o( 6, :,12) = (/ &
     & 1.79904e-01_JPRB, 1.79254e-01_JPRB, 1.78607e-01_JPRB, 1.77962e-01_JPRB, 1.77320e-01_JPRB, &
     & 1.76680e-01_JPRB, 1.76042e-01_JPRB, 1.75406e-01_JPRB, 1.74773e-01_JPRB, 1.74142e-01_JPRB, &
     & 1.73513e-01_JPRB, 1.72887e-01_JPRB, 1.72262e-01_JPRB, 1.71640e-01_JPRB, 1.71021e-01_JPRB, &
     & 1.70403e-01_JPRB, 1.69788e-01_JPRB, 1.69175e-01_JPRB, 1.68564e-01_JPRB/)
      kao_mn2o( 7, :,12) = (/ &
     & 1.78712e-01_JPRB, 1.77868e-01_JPRB, 1.77027e-01_JPRB, 1.76190e-01_JPRB, 1.75357e-01_JPRB, &
     & 1.74528e-01_JPRB, 1.73703e-01_JPRB, 1.72882e-01_JPRB, 1.72064e-01_JPRB, 1.71251e-01_JPRB, &
     & 1.70441e-01_JPRB, 1.69636e-01_JPRB, 1.68834e-01_JPRB, 1.68036e-01_JPRB, 1.67241e-01_JPRB, &
     & 1.66451e-01_JPRB, 1.65664e-01_JPRB, 1.64881e-01_JPRB, 1.64101e-01_JPRB/)
      kao_mn2o( 8, :,12) = (/ &
     & 1.72346e-01_JPRB, 1.70873e-01_JPRB, 1.69413e-01_JPRB, 1.67965e-01_JPRB, 1.66530e-01_JPRB, &
     & 1.65107e-01_JPRB, 1.63696e-01_JPRB, 1.62297e-01_JPRB, 1.60910e-01_JPRB, 1.59535e-01_JPRB, &
     & 1.58171e-01_JPRB, 1.56819e-01_JPRB, 1.55479e-01_JPRB, 1.54150e-01_JPRB, 1.52833e-01_JPRB, &
     & 1.51527e-01_JPRB, 1.50232e-01_JPRB, 1.48948e-01_JPRB, 1.47675e-01_JPRB/)
      kao_mn2o( 9, :,12) = (/ &
     & 1.80517e-01_JPRB, 1.79951e-01_JPRB, 1.79386e-01_JPRB, 1.78823e-01_JPRB, 1.78262e-01_JPRB, &
     & 1.77702e-01_JPRB, 1.77144e-01_JPRB, 1.76588e-01_JPRB, 1.76034e-01_JPRB, 1.75481e-01_JPRB, &
     & 1.74931e-01_JPRB, 1.74382e-01_JPRB, 1.73834e-01_JPRB, 1.73289e-01_JPRB, 1.72745e-01_JPRB, &
     & 1.72202e-01_JPRB, 1.71662e-01_JPRB, 1.71123e-01_JPRB, 1.70586e-01_JPRB/)
      kao_mn2o( 1, :,13) = (/ &
     & 2.41966e-01_JPRB, 2.50534e-01_JPRB, 2.59406e-01_JPRB, 2.68591e-01_JPRB, 2.78102e-01_JPRB, &
     & 2.87950e-01_JPRB, 2.98146e-01_JPRB, 3.08704e-01_JPRB, 3.19635e-01_JPRB, 3.30953e-01_JPRB, &
     & 3.42672e-01_JPRB, 3.54806e-01_JPRB, 3.67370e-01_JPRB, 3.80379e-01_JPRB, 3.93848e-01_JPRB, &
     & 4.07794e-01_JPRB, 4.22234e-01_JPRB, 4.37186e-01_JPRB, 4.52667e-01_JPRB/)
      kao_mn2o( 2, :,13) = (/ &
     & 1.54385e-01_JPRB, 1.54015e-01_JPRB, 1.53646e-01_JPRB, 1.53279e-01_JPRB, 1.52912e-01_JPRB, &
     & 1.52545e-01_JPRB, 1.52180e-01_JPRB, 1.51816e-01_JPRB, 1.51452e-01_JPRB, 1.51089e-01_JPRB, &
     & 1.50728e-01_JPRB, 1.50367e-01_JPRB, 1.50007e-01_JPRB, 1.49647e-01_JPRB, 1.49289e-01_JPRB, &
     & 1.48932e-01_JPRB, 1.48575e-01_JPRB, 1.48219e-01_JPRB, 1.47864e-01_JPRB/)
      kao_mn2o( 3, :,13) = (/ &
     & 2.00518e-01_JPRB, 1.94901e-01_JPRB, 1.89442e-01_JPRB, 1.84136e-01_JPRB, 1.78978e-01_JPRB, &
     & 1.73965e-01_JPRB, 1.69092e-01_JPRB, 1.64356e-01_JPRB, 1.59752e-01_JPRB, 1.55278e-01_JPRB, &
     & 1.50928e-01_JPRB, 1.46701e-01_JPRB, 1.42592e-01_JPRB, 1.38598e-01_JPRB, 1.34715e-01_JPRB, &
     & 1.30942e-01_JPRB, 1.27274e-01_JPRB, 1.23709e-01_JPRB, 1.20244e-01_JPRB/)
      kao_mn2o( 4, :,13) = (/ &
     & 2.03974e-01_JPRB, 1.98258e-01_JPRB, 1.92703e-01_JPRB, 1.87302e-01_JPRB, 1.82054e-01_JPRB, &
     & 1.76952e-01_JPRB, 1.71993e-01_JPRB, 1.67173e-01_JPRB, 1.62489e-01_JPRB, 1.57935e-01_JPRB, &
     & 1.53509e-01_JPRB, 1.49207e-01_JPRB, 1.45026e-01_JPRB, 1.40962e-01_JPRB, 1.37012e-01_JPRB, &
     & 1.33172e-01_JPRB, 1.29440e-01_JPRB, 1.25813e-01_JPRB, 1.22287e-01_JPRB/)
      kao_mn2o( 5, :,13) = (/ &
     & 2.09410e-01_JPRB, 2.03543e-01_JPRB, 1.97841e-01_JPRB, 1.92298e-01_JPRB, 1.86911e-01_JPRB, &
     & 1.81674e-01_JPRB, 1.76585e-01_JPRB, 1.71637e-01_JPRB, 1.66829e-01_JPRB, 1.62155e-01_JPRB, &
     & 1.57612e-01_JPRB, 1.53196e-01_JPRB, 1.48904e-01_JPRB, 1.44733e-01_JPRB, 1.40678e-01_JPRB, &
     & 1.36736e-01_JPRB, 1.32906e-01_JPRB, 1.29182e-01_JPRB, 1.25563e-01_JPRB/)
      kao_mn2o( 6, :,13) = (/ &
     & 2.19808e-01_JPRB, 2.13643e-01_JPRB, 2.07651e-01_JPRB, 2.01827e-01_JPRB, 1.96166e-01_JPRB, &
     & 1.90664e-01_JPRB, 1.85317e-01_JPRB, 1.80119e-01_JPRB, 1.75067e-01_JPRB, 1.70157e-01_JPRB, &
     & 1.65385e-01_JPRB, 1.60746e-01_JPRB, 1.56238e-01_JPRB, 1.51856e-01_JPRB, 1.47596e-01_JPRB, &
     & 1.43457e-01_JPRB, 1.39433e-01_JPRB, 1.35523e-01_JPRB, 1.31722e-01_JPRB/)
      kao_mn2o( 7, :,13) = (/ &
     & 2.47074e-01_JPRB, 2.40127e-01_JPRB, 2.33375e-01_JPRB, 2.26813e-01_JPRB, 2.20436e-01_JPRB, &
     & 2.14238e-01_JPRB, 2.08215e-01_JPRB, 2.02360e-01_JPRB, 1.96671e-01_JPRB, 1.91141e-01_JPRB, &
     & 1.85767e-01_JPRB, 1.80544e-01_JPRB, 1.75467e-01_JPRB, 1.70534e-01_JPRB, 1.65739e-01_JPRB, &
     & 1.61079e-01_JPRB, 1.56550e-01_JPRB, 1.52148e-01_JPRB, 1.47870e-01_JPRB/)
      kao_mn2o( 8, :,13) = (/ &
     & 2.55282e-01_JPRB, 2.48105e-01_JPRB, 2.41130e-01_JPRB, 2.34350e-01_JPRB, 2.27762e-01_JPRB, &
     & 2.21358e-01_JPRB, 2.15135e-01_JPRB, 2.09086e-01_JPRB, 2.03208e-01_JPRB, 1.97495e-01_JPRB, &
     & 1.91942e-01_JPRB, 1.86546e-01_JPRB, 1.81301e-01_JPRB, 1.76204e-01_JPRB, 1.71250e-01_JPRB, &
     & 1.66435e-01_JPRB, 1.61756e-01_JPRB, 1.57208e-01_JPRB, 1.52788e-01_JPRB/)
      kao_mn2o( 9, :,13) = (/ &
     & 2.09991e-01_JPRB, 2.04103e-01_JPRB, 1.98380e-01_JPRB, 1.92818e-01_JPRB, 1.87411e-01_JPRB, &
     & 1.82156e-01_JPRB, 1.77048e-01_JPRB, 1.72084e-01_JPRB, 1.67259e-01_JPRB, 1.62569e-01_JPRB, &
     & 1.58010e-01_JPRB, 1.53580e-01_JPRB, 1.49273e-01_JPRB, 1.45087e-01_JPRB, 1.41019e-01_JPRB, &
     & 1.37065e-01_JPRB, 1.33222e-01_JPRB, 1.29486e-01_JPRB, 1.25855e-01_JPRB/)
      kao_mn2o( 1, :,14) = (/ &
     & 9.08340e-02_JPRB, 9.50421e-02_JPRB, 9.94452e-02_JPRB, 1.04052e-01_JPRB, 1.08873e-01_JPRB, &
     & 1.13917e-01_JPRB, 1.19194e-01_JPRB, 1.24716e-01_JPRB, 1.30494e-01_JPRB, 1.36540e-01_JPRB, &
     & 1.42865e-01_JPRB, 1.49484e-01_JPRB, 1.56409e-01_JPRB, 1.63655e-01_JPRB, 1.71237e-01_JPRB, &
     & 1.79170e-01_JPRB, 1.87471e-01_JPRB, 1.96156e-01_JPRB, 2.05243e-01_JPRB/)
      kao_mn2o( 2, :,14) = (/ &
     & 3.36945e-02_JPRB, 3.45144e-02_JPRB, 3.53542e-02_JPRB, 3.62144e-02_JPRB, 3.70956e-02_JPRB, &
     & 3.79982e-02_JPRB, 3.89228e-02_JPRB, 3.98698e-02_JPRB, 4.08399e-02_JPRB, 4.18336e-02_JPRB, &
     & 4.28515e-02_JPRB, 4.38942e-02_JPRB, 4.49622e-02_JPRB, 4.60562e-02_JPRB, 4.71769e-02_JPRB, &
     & 4.83248e-02_JPRB, 4.95006e-02_JPRB, 5.07051e-02_JPRB, 5.19388e-02_JPRB/)
      kao_mn2o( 3, :,14) = (/ &
     & 9.11678e-02_JPRB, 8.85761e-02_JPRB, 8.60580e-02_JPRB, 8.36116e-02_JPRB, 8.12347e-02_JPRB, &
     & 7.89253e-02_JPRB, 7.66817e-02_JPRB, 7.45017e-02_JPRB, 7.23838e-02_JPRB, 7.03261e-02_JPRB, &
     & 6.83269e-02_JPRB, 6.63845e-02_JPRB, 6.44973e-02_JPRB, 6.26638e-02_JPRB, 6.08824e-02_JPRB, &
     & 5.91516e-02_JPRB, 5.74700e-02_JPRB, 5.58363e-02_JPRB, 5.42490e-02_JPRB/)
      kao_mn2o( 4, :,14) = (/ &
     & 8.43999e-02_JPRB, 8.20004e-02_JPRB, 7.96692e-02_JPRB, 7.74042e-02_JPRB, 7.52037e-02_JPRB, &
     & 7.30656e-02_JPRB, 7.09884e-02_JPRB, 6.89702e-02_JPRB, 6.70094e-02_JPRB, 6.51044e-02_JPRB, &
     & 6.32535e-02_JPRB, 6.14552e-02_JPRB, 5.97081e-02_JPRB, 5.80106e-02_JPRB, 5.63614e-02_JPRB, &
     & 5.47590e-02_JPRB, 5.32022e-02_JPRB, 5.16897e-02_JPRB, 5.02202e-02_JPRB/)
      kao_mn2o( 5, :,14) = (/ &
     & 7.41279e-02_JPRB, 7.20196e-02_JPRB, 6.99712e-02_JPRB, 6.79811e-02_JPRB, 6.60476e-02_JPRB, &
     & 6.41691e-02_JPRB, 6.23440e-02_JPRB, 6.05708e-02_JPRB, 5.88481e-02_JPRB, 5.71743e-02_JPRB, &
     & 5.55482e-02_JPRB, 5.39683e-02_JPRB, 5.24334e-02_JPRB, 5.09421e-02_JPRB, 4.94932e-02_JPRB, &
     & 4.80855e-02_JPRB, 4.67179e-02_JPRB, 4.53891e-02_JPRB, 4.40982e-02_JPRB/)
      kao_mn2o( 6, :,14) = (/ &
     & 5.66805e-02_JPRB, 5.50676e-02_JPRB, 5.35006e-02_JPRB, 5.19782e-02_JPRB, 5.04991e-02_JPRB, &
     & 4.90621e-02_JPRB, 4.76659e-02_JPRB, 4.63096e-02_JPRB, 4.49918e-02_JPRB, 4.37115e-02_JPRB, &
     & 4.24676e-02_JPRB, 4.12592e-02_JPRB, 4.00851e-02_JPRB, 3.89444e-02_JPRB, 3.78362e-02_JPRB, &
     & 3.67595e-02_JPRB, 3.57135e-02_JPRB, 3.46972e-02_JPRB, 3.37099e-02_JPRB/)
      kao_mn2o( 7, :,14) = (/ &
     & 1.23018e-02_JPRB, 1.19517e-02_JPRB, 1.16116e-02_JPRB, 1.12811e-02_JPRB, 1.09601e-02_JPRB, &
     & 1.06482e-02_JPRB, 1.03452e-02_JPRB, 1.00508e-02_JPRB, 9.76474e-03_JPRB, 9.48685e-03_JPRB, &
     & 9.21687e-03_JPRB, 8.95458e-03_JPRB, 8.69974e-03_JPRB, 8.45216e-03_JPRB, 8.21163e-03_JPRB, &
     & 7.97794e-03_JPRB, 7.75091e-03_JPRB, 7.53033e-03_JPRB, 7.31603e-03_JPRB/)
      kao_mn2o( 8, :,14) = (/ &
     & 3.22403e-07_JPRB, 3.75986e-07_JPRB, 4.38475e-07_JPRB, 5.11349e-07_JPRB, 5.96335e-07_JPRB, &
     & 6.95446e-07_JPRB, 8.11028e-07_JPRB, 9.45821e-07_JPRB, 1.10302e-06_JPRB, 1.28634e-06_JPRB, &
     & 1.50012e-06_JPRB, 1.74944e-06_JPRB, 2.04020e-06_JPRB, 2.37928e-06_JPRB, 2.77472e-06_JPRB, &
     & 3.23587e-06_JPRB, 3.77367e-06_JPRB, 4.40085e-06_JPRB, 5.13227e-06_JPRB/)
      kao_mn2o( 9, :,14) = (/ &
     & 7.33052e-02_JPRB, 7.12199e-02_JPRB, 6.91939e-02_JPRB, 6.72255e-02_JPRB, 6.53131e-02_JPRB, &
     & 6.34551e-02_JPRB, 6.16500e-02_JPRB, 5.98963e-02_JPRB, 5.81924e-02_JPRB, 5.65370e-02_JPRB, &
     & 5.49287e-02_JPRB, 5.33661e-02_JPRB, 5.18480e-02_JPRB, 5.03730e-02_JPRB, 4.89401e-02_JPRB, &
     & 4.75479e-02_JPRB, 4.61953e-02_JPRB, 4.48811e-02_JPRB, 4.36044e-02_JPRB/)
      kao_mn2o( 1, :,15) = (/ &
     & 8.80247e-02_JPRB, 9.01793e-02_JPRB, 9.23868e-02_JPRB, 9.46482e-02_JPRB, 9.69650e-02_JPRB, &
     & 9.93385e-02_JPRB, 1.01770e-01_JPRB, 1.04261e-01_JPRB, 1.06813e-01_JPRB, 1.09428e-01_JPRB, &
     & 1.12107e-01_JPRB, 1.14851e-01_JPRB, 1.17662e-01_JPRB, 1.20542e-01_JPRB, 1.23493e-01_JPRB, &
     & 1.26516e-01_JPRB, 1.29613e-01_JPRB, 1.32785e-01_JPRB, 1.36036e-01_JPRB/)
      kao_mn2o( 2, :,15) = (/ &
     & 3.89107e-07_JPRB, 4.53768e-07_JPRB, 5.29173e-07_JPRB, 6.17109e-07_JPRB, 7.19658e-07_JPRB, &
     & 8.39248e-07_JPRB, 9.78710e-07_JPRB, 1.14135e-06_JPRB, 1.33101e-06_JPRB, 1.55220e-06_JPRB, &
     & 1.81013e-06_JPRB, 2.11094e-06_JPRB, 2.46172e-06_JPRB, 2.87080e-06_JPRB, 3.34786e-06_JPRB, &
     & 3.90420e-06_JPRB, 4.55298e-06_JPRB, 5.30958e-06_JPRB, 6.19190e-06_JPRB/)
      kao_mn2o( 3, :,15) = (/ &
     & 3.86537e-07_JPRB, 4.50763e-07_JPRB, 5.25662e-07_JPRB, 6.13006e-07_JPRB, 7.14863e-07_JPRB, &
     & 8.33644e-07_JPRB, 9.72162e-07_JPRB, 1.13370e-06_JPRB, 1.32207e-06_JPRB, 1.54175e-06_JPRB, &
     & 1.79792e-06_JPRB, 2.09666e-06_JPRB, 2.44504e-06_JPRB, 2.85131e-06_JPRB, 3.32508e-06_JPRB, &
     & 3.87758e-06_JPRB, 4.52188e-06_JPRB, 5.27323e-06_JPRB, 6.14943e-06_JPRB/)
      kao_mn2o( 4, :,15) = (/ &
     & 3.81913e-07_JPRB, 4.45369e-07_JPRB, 5.19369e-07_JPRB, 6.05664e-07_JPRB, 7.06297e-07_JPRB, &
     & 8.23651e-07_JPRB, 9.60503e-07_JPRB, 1.12009e-06_JPRB, 1.30620e-06_JPRB, 1.52323e-06_JPRB, &
     & 1.77632e-06_JPRB, 2.07147e-06_JPRB, 2.41565e-06_JPRB, 2.81701e-06_JPRB, 3.28507e-06_JPRB, &
     & 3.83090e-06_JPRB, 4.46741e-06_JPRB, 5.20969e-06_JPRB, 6.07529e-06_JPRB/)
      kao_mn2o( 5, :,15) = (/ &
     & 3.77265e-07_JPRB, 4.39951e-07_JPRB, 5.13053e-07_JPRB, 5.98303e-07_JPRB, 6.97717e-07_JPRB, &
     & 8.13650e-07_JPRB, 9.48846e-07_JPRB, 1.10651e-06_JPRB, 1.29036e-06_JPRB, 1.50477e-06_JPRB, &
     & 1.75480e-06_JPRB, 2.04638e-06_JPRB, 2.38641e-06_JPRB, 2.78294e-06_JPRB, 3.24535e-06_JPRB, &
     & 3.78460e-06_JPRB, 4.41345e-06_JPRB, 5.14679e-06_JPRB, 6.00198e-06_JPRB/)
      kao_mn2o( 6, :,15) = (/ &
     & 3.77877e-07_JPRB, 4.40670e-07_JPRB, 5.13897e-07_JPRB, 5.99292e-07_JPRB, 6.98878e-07_JPRB, &
     & 8.15012e-07_JPRB, 9.50444e-07_JPRB, 1.10838e-06_JPRB, 1.29256e-06_JPRB, 1.50735e-06_JPRB, &
     & 1.75783e-06_JPRB, 2.04993e-06_JPRB, 2.39057e-06_JPRB, 2.78782e-06_JPRB, 3.25107e-06_JPRB, &
     & 3.79131e-06_JPRB, 4.42132e-06_JPRB, 5.15602e-06_JPRB, 6.01280e-06_JPRB/)
      kao_mn2o( 7, :,15) = (/ &
     & 3.80495e-07_JPRB, 4.43726e-07_JPRB, 5.17465e-07_JPRB, 6.03458e-07_JPRB, 7.03741e-07_JPRB, &
     & 8.20689e-07_JPRB, 9.57072e-07_JPRB, 1.11612e-06_JPRB, 1.30160e-06_JPRB, 1.51790e-06_JPRB, &
     & 1.77014e-06_JPRB, 2.06430e-06_JPRB, 2.40735e-06_JPRB, 2.80741e-06_JPRB, 3.27394e-06_JPRB, &
     & 3.81801e-06_JPRB, 4.45249e-06_JPRB, 5.19241e-06_JPRB, 6.05528e-06_JPRB/)
      kao_mn2o( 8, :,15) = (/ &
     & 3.87881e-07_JPRB, 4.52329e-07_JPRB, 5.27486e-07_JPRB, 6.15129e-07_JPRB, 7.17335e-07_JPRB, &
     & 8.36523e-07_JPRB, 9.75515e-07_JPRB, 1.13760e-06_JPRB, 1.32662e-06_JPRB, 1.54704e-06_JPRB, &
     & 1.80409e-06_JPRB, 2.10384e-06_JPRB, 2.45340e-06_JPRB, 2.86105e-06_JPRB, 3.33642e-06_JPRB, &
     & 3.89078e-06_JPRB, 4.53725e-06_JPRB, 5.29112e-06_JPRB, 6.17026e-06_JPRB/)
      kao_mn2o( 9, :,15) = (/ &
     & 3.77265e-07_JPRB, 4.39951e-07_JPRB, 5.13053e-07_JPRB, 5.98303e-07_JPRB, 6.97717e-07_JPRB, &
     & 8.13650e-07_JPRB, 9.48846e-07_JPRB, 1.10651e-06_JPRB, 1.29036e-06_JPRB, 1.50477e-06_JPRB, &
     & 1.75480e-06_JPRB, 2.04638e-06_JPRB, 2.38641e-06_JPRB, 2.78294e-06_JPRB, 3.24535e-06_JPRB, &
     & 3.78460e-06_JPRB, 4.41345e-06_JPRB, 5.14679e-06_JPRB, 6.00198e-06_JPRB/)
      kao_mn2o( 1, :,16) = (/ &
     & 8.84606e-02_JPRB, 9.05971e-02_JPRB, 9.27852e-02_JPRB, 9.50261e-02_JPRB, 9.73212e-02_JPRB, &
     & 9.96717e-02_JPRB, 1.02079e-01_JPRB, 1.04544e-01_JPRB, 1.07069e-01_JPRB, 1.09655e-01_JPRB, &
     & 1.12304e-01_JPRB, 1.15016e-01_JPRB, 1.17794e-01_JPRB, 1.20639e-01_JPRB, 1.23553e-01_JPRB, &
     & 1.26537e-01_JPRB, 1.29593e-01_JPRB, 1.32723e-01_JPRB, 1.35928e-01_JPRB/)
      kao_mn2o( 2, :,16) = (/ &
     & 8.13898e-07_JPRB, 9.49130e-07_JPRB, 1.10683e-06_JPRB, 1.29073e-06_JPRB, 1.50519e-06_JPRB, &
     & 1.75528e-06_JPRB, 2.04693e-06_JPRB, 2.38703e-06_JPRB, 2.78364e-06_JPRB, 3.24615e-06_JPRB, &
     & 3.78551e-06_JPRB, 4.41449e-06_JPRB, 5.14796e-06_JPRB, 6.00331e-06_JPRB, 7.00078e-06_JPRB, &
     & 8.16398e-06_JPRB, 9.52045e-06_JPRB, 1.11023e-05_JPRB, 1.29470e-05_JPRB/)
      kao_mn2o( 3, :,16) = (/ &
     & 8.32666e-07_JPRB, 9.71021e-07_JPRB, 1.13237e-06_JPRB, 1.32052e-06_JPRB, 1.53994e-06_JPRB, &
     & 1.79581e-06_JPRB, 2.09420e-06_JPRB, 2.44217e-06_JPRB, 2.84796e-06_JPRB, 3.32117e-06_JPRB, &
     & 3.87302e-06_JPRB, 4.51656e-06_JPRB, 5.26703e-06_JPRB, 6.14219e-06_JPRB, 7.16277e-06_JPRB, &
     & 8.35294e-06_JPRB, 9.74086e-06_JPRB, 1.13594e-05_JPRB, 1.32468e-05_JPRB/)
      kao_mn2o( 4, :,16) = (/ &
     & 8.70348e-07_JPRB, 1.01496e-06_JPRB, 1.18360e-06_JPRB, 1.38026e-06_JPRB, 1.60959e-06_JPRB, &
     & 1.87703e-06_JPRB, 2.18890e-06_JPRB, 2.55259e-06_JPRB, 2.97671e-06_JPRB, 3.47130e-06_JPRB, &
     & 4.04807e-06_JPRB, 4.72067e-06_JPRB, 5.50502e-06_JPRB, 6.41970e-06_JPRB, 7.48635e-06_JPRB, &
     & 8.73023e-06_JPRB, 1.01808e-05_JPRB, 1.18724e-05_JPRB, 1.38450e-05_JPRB/)
      kao_mn2o( 5, :,16) = (/ &
     & 9.07957e-07_JPRB, 1.05882e-06_JPRB, 1.23475e-06_JPRB, 1.43991e-06_JPRB, 1.67916e-06_JPRB, &
     & 1.95816e-06_JPRB, 2.28352e-06_JPRB, 2.66294e-06_JPRB, 3.10541e-06_JPRB, 3.62139e-06_JPRB, &
     & 4.22310e-06_JPRB, 4.92480e-06_JPRB, 5.74308e-06_JPRB, 6.69733e-06_JPRB, 7.81013e-06_JPRB, &
     & 9.10784e-06_JPRB, 1.06212e-05_JPRB, 1.23859e-05_JPRB, 1.44439e-05_JPRB/)
      kao_mn2o( 6, :,16) = (/ &
     & 8.59072e-04_JPRB, 9.19773e-04_JPRB, 9.84764e-04_JPRB, 1.05435e-03_JPRB, 1.12885e-03_JPRB, &
     & 1.20861e-03_JPRB, 1.29401e-03_JPRB, 1.38544e-03_JPRB, 1.48334e-03_JPRB, 1.58815e-03_JPRB, &
     & 1.70037e-03_JPRB, 1.82052e-03_JPRB, 1.94915e-03_JPRB, 2.08688e-03_JPRB, 2.23434e-03_JPRB, &
     & 2.39222e-03_JPRB, 2.56125e-03_JPRB, 2.74223e-03_JPRB, 2.93599e-03_JPRB/)
      kao_mn2o( 7, :,16) = (/ &
     & 9.17294e-07_JPRB, 1.06971e-06_JPRB, 1.24746e-06_JPRB, 1.45474e-06_JPRB, 1.69646e-06_JPRB, &
     & 1.97835e-06_JPRB, 2.30708e-06_JPRB, 2.69043e-06_JPRB, 3.13748e-06_JPRB, 3.65880e-06_JPRB, &
     & 4.26676e-06_JPRB, 4.97574e-06_JPRB, 5.80251e-06_JPRB, 6.76667e-06_JPRB, 7.89104e-06_JPRB, &
     & 9.20223e-06_JPRB, 1.07313e-05_JPRB, 1.25144e-05_JPRB, 1.45939e-05_JPRB/)
      kao_mn2o( 8, :,16) = (/ &
     & 9.17341e-07_JPRB, 1.06977e-06_JPRB, 1.24752e-06_JPRB, 1.45480e-06_JPRB, 1.69653e-06_JPRB, &
     & 1.97843e-06_JPRB, 2.30716e-06_JPRB, 2.69051e-06_JPRB, 3.13757e-06_JPRB, 3.65890e-06_JPRB, &
     & 4.26686e-06_JPRB, 4.97584e-06_JPRB, 5.80261e-06_JPRB, 6.76677e-06_JPRB, 7.89113e-06_JPRB, &
     & 9.20231e-06_JPRB, 1.07314e-05_JPRB, 1.25145e-05_JPRB, 1.45939e-05_JPRB/)
      kao_mn2o( 9, :,16) = (/ &
     & 9.07957e-07_JPRB, 1.05882e-06_JPRB, 1.23475e-06_JPRB, 1.43991e-06_JPRB, 1.67916e-06_JPRB, &
     & 1.95816e-06_JPRB, 2.28352e-06_JPRB, 2.66294e-06_JPRB, 3.10541e-06_JPRB, 3.62139e-06_JPRB, &
     & 4.22310e-06_JPRB, 4.92480e-06_JPRB, 5.74308e-06_JPRB, 6.69733e-06_JPRB, 7.81013e-06_JPRB, &
     & 9.10784e-06_JPRB, 1.06212e-05_JPRB, 1.23859e-05_JPRB, 1.44439e-05_JPRB/)

!     The array KBO_Mxx contains the absorption coefficient for 
!     a minor species at the 16 chosen g-values for a reference pressure
!     level above 100~ mb.   The first index in the array, JS, runs
!     from 1 to 10, and corresponds to different gas column amounts ratios,
!     as expressed through the binary species parameter eta, defined as
!     eta = gas1/(gas1 + (rat) * gas2), where rat is the 
!     ratio of the reference MLS column amount value of gas 1 to 
!     that of gas2.  The second index refers to temperature 
!     in 7.2 degree increments.  For instance, JT = 1 refers to a 
!     temperature of 188.0, JT = 2 refers to 195.2, etc. The third index 
!     runs over the g-channel (1 to 16).

      kbo_mn2o( 1, :, 1) = (/ &
     & 7.72009e-08_JPRB, 1.15883e-07_JPRB, 1.73947e-07_JPRB, 2.61104e-07_JPRB, 3.91932e-07_JPRB, &
     & 5.88311e-07_JPRB, 8.83088e-07_JPRB, 1.32556e-06_JPRB, 1.98975e-06_JPRB, 2.98672e-06_JPRB, &
     & 4.48324e-06_JPRB, 6.72960e-06_JPRB, 1.01015e-05_JPRB, 1.51629e-05_JPRB, 2.27604e-05_JPRB, &
     & 3.41646e-05_JPRB, 5.12831e-05_JPRB, 7.69787e-05_JPRB, 1.15549e-04_JPRB/)
      kbo_mn2o( 2, :, 1) = (/ &
     & 1.29932e-05_JPRB, 1.78207e-05_JPRB, 2.44419e-05_JPRB, 3.35232e-05_JPRB, 4.59786e-05_JPRB, &
     & 6.30617e-05_JPRB, 8.64920e-05_JPRB, 1.18628e-04_JPRB, 1.62703e-04_JPRB, 2.23155e-04_JPRB, &
     & 3.06067e-04_JPRB, 4.19784e-04_JPRB, 5.75753e-04_JPRB, 7.89671e-04_JPRB, 1.08307e-03_JPRB, &
     & 1.48548e-03_JPRB, 2.03740e-03_JPRB, 2.79439e-03_JPRB, 3.83262e-03_JPRB/)
      kbo_mn2o( 3, :, 1) = (/ &
     & 6.44518e-05_JPRB, 8.10996e-05_JPRB, 1.02047e-04_JPRB, 1.28406e-04_JPRB, 1.61573e-04_JPRB, &
     & 2.03307e-04_JPRB, 2.55821e-04_JPRB, 3.21899e-04_JPRB, 4.05045e-04_JPRB, 5.09667e-04_JPRB, &
     & 6.41313e-04_JPRB, 8.06964e-04_JPRB, 1.01540e-03_JPRB, 1.27768e-03_JPRB, 1.60770e-03_JPRB, &
     & 2.02296e-03_JPRB, 2.54549e-03_JPRB, 3.20298e-03_JPRB, 4.03031e-03_JPRB/)
      kbo_mn2o( 4, :, 1) = (/ &
     & 3.23454e-04_JPRB, 3.82112e-04_JPRB, 4.51408e-04_JPRB, 5.33270e-04_JPRB, 6.29978e-04_JPRB, &
     & 7.44223e-04_JPRB, 8.79187e-04_JPRB, 1.03863e-03_JPRB, 1.22698e-03_JPRB, 1.44949e-03_JPRB, &
     & 1.71235e-03_JPRB, 2.02289e-03_JPRB, 2.38974e-03_JPRB, 2.82311e-03_JPRB, 3.33508e-03_JPRB, &
     & 3.93989e-03_JPRB, 4.65439e-03_JPRB, 5.49845e-03_JPRB, 6.49558e-03_JPRB/)
      kbo_mn2o( 5, :, 1) = (/ &
     & 1.45978e-04_JPRB, 1.75646e-04_JPRB, 2.11344e-04_JPRB, 2.54296e-04_JPRB, 3.05978e-04_JPRB, &
     & 3.68163e-04_JPRB, 4.42986e-04_JPRB, 5.33017e-04_JPRB, 6.41344e-04_JPRB, 7.71687e-04_JPRB, &
     & 9.28522e-04_JPRB, 1.11723e-03_JPRB, 1.34429e-03_JPRB, 1.61750e-03_JPRB, 1.94623e-03_JPRB, &
     & 2.34177e-03_JPRB, 2.81770e-03_JPRB, 3.39035e-03_JPRB, 4.07939e-03_JPRB/)
      kbo_mn2o( 1, :, 2) = (/ &
     & 1.94527e-04_JPRB, 2.38609e-04_JPRB, 2.92680e-04_JPRB, 3.59005e-04_JPRB, 4.40360e-04_JPRB, &
     & 5.40150e-04_JPRB, 6.62554e-04_JPRB, 8.12697e-04_JPRB, 9.96864e-04_JPRB, 1.22276e-03_JPRB, &
     & 1.49986e-03_JPRB, 1.83974e-03_JPRB, 2.25665e-03_JPRB, 2.76803e-03_JPRB, 3.39530e-03_JPRB, &
     & 4.16472e-03_JPRB, 5.10849e-03_JPRB, 6.26613e-03_JPRB, 7.68611e-03_JPRB/)
      kbo_mn2o( 2, :, 2) = (/ &
     & 7.49615e-04_JPRB, 8.82716e-04_JPRB, 1.03945e-03_JPRB, 1.22401e-03_JPRB, 1.44135e-03_JPRB, &
     & 1.69727e-03_JPRB, 1.99863e-03_JPRB, 2.35351e-03_JPRB, 2.77139e-03_JPRB, 3.26347e-03_JPRB, &
     & 3.84293e-03_JPRB, 4.52528e-03_JPRB, 5.32878e-03_JPRB, 6.27495e-03_JPRB, 7.38911e-03_JPRB, &
     & 8.70111e-03_JPRB, 1.02461e-02_JPRB, 1.20653e-02_JPRB, 1.42076e-02_JPRB/)
      kbo_mn2o( 3, :, 2) = (/ &
     & 1.39162e-03_JPRB, 1.59859e-03_JPRB, 1.83634e-03_JPRB, 2.10946e-03_JPRB, 2.42319e-03_JPRB, &
     & 2.78358e-03_JPRB, 3.19758e-03_JPRB, 3.67314e-03_JPRB, 4.21944e-03_JPRB, 4.84698e-03_JPRB, &
     & 5.56786e-03_JPRB, 6.39595e-03_JPRB, 7.34720e-03_JPRB, 8.43992e-03_JPRB, 9.69516e-03_JPRB, &
     & 1.11371e-02_JPRB, 1.27935e-02_JPRB, 1.46962e-02_JPRB, 1.68819e-02_JPRB/)
      kbo_mn2o( 4, :, 2) = (/ &
     & 2.42354e-03_JPRB, 2.73623e-03_JPRB, 3.08926e-03_JPRB, 3.48783e-03_JPRB, 3.93783e-03_JPRB, &
     & 4.44589e-03_JPRB, 5.01950e-03_JPRB, 5.66712e-03_JPRB, 6.39829e-03_JPRB, 7.22379e-03_JPRB, &
     & 8.15581e-03_JPRB, 9.20807e-03_JPRB, 1.03961e-02_JPRB, 1.17374e-02_JPRB, 1.32517e-02_JPRB, &
     & 1.49615e-02_JPRB, 1.68918e-02_JPRB, 1.90712e-02_JPRB, 2.15318e-02_JPRB/)
      kbo_mn2o( 5, :, 2) = (/ &
     & 1.39908e-03_JPRB, 1.59133e-03_JPRB, 1.81000e-03_JPRB, 2.05872e-03_JPRB, 2.34161e-03_JPRB, &
     & 2.66338e-03_JPRB, 3.02937e-03_JPRB, 3.44564e-03_JPRB, 3.91912e-03_JPRB, 4.45766e-03_JPRB, &
     & 5.07021e-03_JPRB, 5.76693e-03_JPRB, 6.55938e-03_JPRB, 7.46073e-03_JPRB, 8.48594e-03_JPRB, &
     & 9.65202e-03_JPRB, 1.09783e-02_JPRB, 1.24869e-02_JPRB, 1.42028e-02_JPRB/)
      kbo_mn2o( 1, :, 3) = (/ &
     & 8.74797e-03_JPRB, 9.66828e-03_JPRB, 1.06854e-02_JPRB, 1.18095e-02_JPRB, 1.30519e-02_JPRB, &
     & 1.44250e-02_JPRB, 1.59426e-02_JPRB, 1.76198e-02_JPRB, 1.94735e-02_JPRB, 2.15221e-02_JPRB, &
     & 2.37863e-02_JPRB, 2.62887e-02_JPRB, 2.90544e-02_JPRB, 3.21110e-02_JPRB, 3.54891e-02_JPRB, &
     & 3.92227e-02_JPRB, 4.33491e-02_JPRB, 4.79095e-02_JPRB, 5.29497e-02_JPRB/)
      kbo_mn2o( 2, :, 3) = (/ &
     & 1.43974e-02_JPRB, 1.56118e-02_JPRB, 1.69286e-02_JPRB, 1.83564e-02_JPRB, 1.99047e-02_JPRB, &
     & 2.15836e-02_JPRB, 2.34041e-02_JPRB, 2.53781e-02_JPRB, 2.75187e-02_JPRB, 2.98397e-02_JPRB, &
     & 3.23566e-02_JPRB, 3.50857e-02_JPRB, 3.80451e-02_JPRB, 4.12540e-02_JPRB, 4.47336e-02_JPRB, &
     & 4.85067e-02_JPRB, 5.25980e-02_JPRB, 5.70344e-02_JPRB, 6.18450e-02_JPRB/)
      kbo_mn2o( 3, :, 3) = (/ &
     & 1.83051e-02_JPRB, 1.96851e-02_JPRB, 2.11692e-02_JPRB, 2.27651e-02_JPRB, 2.44813e-02_JPRB, &
     & 2.63270e-02_JPRB, 2.83117e-02_JPRB, 3.04461e-02_JPRB, 3.27414e-02_JPRB, 3.52097e-02_JPRB, &
     & 3.78642e-02_JPRB, 4.07187e-02_JPRB, 4.37884e-02_JPRB, 4.70896e-02_JPRB, 5.06396e-02_JPRB, &
     & 5.44573e-02_JPRB, 5.85628e-02_JPRB, 6.29777e-02_JPRB, 6.77256e-02_JPRB/)
      kbo_mn2o( 4, :, 3) = (/ &
     & 2.81258e-02_JPRB, 2.97806e-02_JPRB, 3.15328e-02_JPRB, 3.33880e-02_JPRB, 3.53524e-02_JPRB, &
     & 3.74324e-02_JPRB, 3.96348e-02_JPRB, 4.19667e-02_JPRB, 4.44358e-02_JPRB, 4.70502e-02_JPRB, &
     & 4.98185e-02_JPRB, 5.27496e-02_JPRB, 5.58531e-02_JPRB, 5.91393e-02_JPRB, 6.26187e-02_JPRB, &
     & 6.63030e-02_JPRB, 7.02039e-02_JPRB, 7.43344e-02_JPRB, 7.87079e-02_JPRB/)
      kbo_mn2o( 5, :, 3) = (/ &
     & 8.82958e-03_JPRB, 9.53842e-03_JPRB, 1.03042e-02_JPRB, 1.11314e-02_JPRB, 1.20250e-02_JPRB, &
     & 1.29904e-02_JPRB, 1.40333e-02_JPRB, 1.51599e-02_JPRB, 1.63769e-02_JPRB, 1.76917e-02_JPRB, &
     & 1.91120e-02_JPRB, 2.06463e-02_JPRB, 2.23038e-02_JPRB, 2.40944e-02_JPRB, 2.60287e-02_JPRB, &
     & 2.81183e-02_JPRB, 3.03757e-02_JPRB, 3.28142e-02_JPRB, 3.54486e-02_JPRB/)
      kbo_mn2o( 1, :, 4) = (/ &
     & 1.18673e-01_JPRB, 1.22983e-01_JPRB, 1.27449e-01_JPRB, 1.32077e-01_JPRB, 1.36874e-01_JPRB, &
     & 1.41845e-01_JPRB, 1.46996e-01_JPRB, 1.52334e-01_JPRB, 1.57866e-01_JPRB, 1.63599e-01_JPRB, &
     & 1.69541e-01_JPRB, 1.75698e-01_JPRB, 1.82078e-01_JPRB, 1.88691e-01_JPRB, 1.95543e-01_JPRB, &
     & 2.02645e-01_JPRB, 2.10004e-01_JPRB, 2.17631e-01_JPRB, 2.25534e-01_JPRB/)
      kbo_mn2o( 2, :, 4) = (/ &
     & 1.32161e-01_JPRB, 1.36550e-01_JPRB, 1.41084e-01_JPRB, 1.45769e-01_JPRB, 1.50610e-01_JPRB, &
     & 1.55611e-01_JPRB, 1.60779e-01_JPRB, 1.66118e-01_JPRB, 1.71634e-01_JPRB, 1.77334e-01_JPRB, &
     & 1.83223e-01_JPRB, 1.89307e-01_JPRB, 1.95594e-01_JPRB, 2.02089e-01_JPRB, 2.08800e-01_JPRB, &
     & 2.15734e-01_JPRB, 2.22898e-01_JPRB, 2.30300e-01_JPRB, 2.37947e-01_JPRB/)
      kbo_mn2o( 3, :, 4) = (/ &
     & 1.44384e-01_JPRB, 1.48820e-01_JPRB, 1.53392e-01_JPRB, 1.58104e-01_JPRB, 1.62962e-01_JPRB, &
     & 1.67968e-01_JPRB, 1.73128e-01_JPRB, 1.78447e-01_JPRB, 1.83929e-01_JPRB, 1.89580e-01_JPRB, &
     & 1.95404e-01_JPRB, 2.01407e-01_JPRB, 2.07594e-01_JPRB, 2.13972e-01_JPRB, 2.20546e-01_JPRB, &
     & 2.27321e-01_JPRB, 2.34305e-01_JPRB, 2.41503e-01_JPRB, 2.48922e-01_JPRB/)
      kbo_mn2o( 4, :, 4) = (/ &
     & 1.58026e-01_JPRB, 1.62626e-01_JPRB, 1.67360e-01_JPRB, 1.72232e-01_JPRB, 1.77245e-01_JPRB, &
     & 1.82405e-01_JPRB, 1.87714e-01_JPRB, 1.93179e-01_JPRB, 1.98802e-01_JPRB, 2.04589e-01_JPRB, &
     & 2.10544e-01_JPRB, 2.16673e-01_JPRB, 2.22980e-01_JPRB, 2.29471e-01_JPRB, 2.36151e-01_JPRB, &
     & 2.43025e-01_JPRB, 2.50100e-01_JPRB, 2.57380e-01_JPRB, 2.64872e-01_JPRB/)
      kbo_mn2o( 5, :, 4) = (/ &
     & 4.04885e-02_JPRB, 4.16064e-02_JPRB, 4.27551e-02_JPRB, 4.39355e-02_JPRB, 4.51485e-02_JPRB, &
     & 4.63950e-02_JPRB, 4.76759e-02_JPRB, 4.89921e-02_JPRB, 5.03448e-02_JPRB, 5.17347e-02_JPRB, &
     & 5.31630e-02_JPRB, 5.46308e-02_JPRB, 5.61391e-02_JPRB, 5.76890e-02_JPRB, 5.92817e-02_JPRB, &
     & 6.09184e-02_JPRB, 6.26003e-02_JPRB, 6.43286e-02_JPRB, 6.61047e-02_JPRB/)
      kbo_mn2o( 1, :, 5) = (/ &
     & 3.97757e-01_JPRB, 4.01082e-01_JPRB, 4.04434e-01_JPRB, 4.07814e-01_JPRB, 4.11223e-01_JPRB, &
     & 4.14659e-01_JPRB, 4.18125e-01_JPRB, 4.21620e-01_JPRB, 4.25144e-01_JPRB, 4.28697e-01_JPRB, &
     & 4.32280e-01_JPRB, 4.35893e-01_JPRB, 4.39536e-01_JPRB, 4.43209e-01_JPRB, 4.46913e-01_JPRB, &
     & 4.50649e-01_JPRB, 4.54415e-01_JPRB, 4.58213e-01_JPRB, 4.62043e-01_JPRB/)
      kbo_mn2o( 2, :, 5) = (/ &
     & 3.99425e-01_JPRB, 4.02035e-01_JPRB, 4.04662e-01_JPRB, 4.07306e-01_JPRB, 4.09968e-01_JPRB, &
     & 4.12647e-01_JPRB, 4.15343e-01_JPRB, 4.18057e-01_JPRB, 4.20789e-01_JPRB, 4.23539e-01_JPRB, &
     & 4.26307e-01_JPRB, 4.29092e-01_JPRB, 4.31896e-01_JPRB, 4.34719e-01_JPRB, 4.37559e-01_JPRB, &
     & 4.40419e-01_JPRB, 4.43296e-01_JPRB, 4.46193e-01_JPRB, 4.49109e-01_JPRB/)
      kbo_mn2o( 3, :, 5) = (/ &
     & 4.00527e-01_JPRB, 4.02848e-01_JPRB, 4.05182e-01_JPRB, 4.07530e-01_JPRB, 4.09892e-01_JPRB, &
     & 4.12267e-01_JPRB, 4.14656e-01_JPRB, 4.17058e-01_JPRB, 4.19475e-01_JPRB, 4.21906e-01_JPRB, &
     & 4.24351e-01_JPRB, 4.26809e-01_JPRB, 4.29283e-01_JPRB, 4.31770e-01_JPRB, 4.34272e-01_JPRB, &
     & 4.36788e-01_JPRB, 4.39319e-01_JPRB, 4.41865e-01_JPRB, 4.44426e-01_JPRB/)
      kbo_mn2o( 4, :, 5) = (/ &
     & 4.11455e-01_JPRB, 4.13077e-01_JPRB, 4.14705e-01_JPRB, 4.16340e-01_JPRB, 4.17981e-01_JPRB, &
     & 4.19629e-01_JPRB, 4.21283e-01_JPRB, 4.22944e-01_JPRB, 4.24611e-01_JPRB, 4.26285e-01_JPRB, &
     & 4.27966e-01_JPRB, 4.29653e-01_JPRB, 4.31346e-01_JPRB, 4.33047e-01_JPRB, 4.34754e-01_JPRB, &
     & 4.36468e-01_JPRB, 4.38188e-01_JPRB, 4.39916e-01_JPRB, 4.41650e-01_JPRB/)
      kbo_mn2o( 5, :, 5) = (/ &
     & 8.65576e-02_JPRB, 8.83622e-02_JPRB, 9.02044e-02_JPRB, 9.20850e-02_JPRB, 9.40049e-02_JPRB, &
     & 9.59647e-02_JPRB, 9.79655e-02_JPRB, 1.00008e-01_JPRB, 1.02093e-01_JPRB, 1.04221e-01_JPRB, &
     & 1.06394e-01_JPRB, 1.08612e-01_JPRB, 1.10877e-01_JPRB, 1.13188e-01_JPRB, 1.15548e-01_JPRB, &
     & 1.17957e-01_JPRB, 1.20417e-01_JPRB, 1.22927e-01_JPRB, 1.25490e-01_JPRB/)
      kbo_mn2o( 1, :, 6) = (/ &
     & 6.98675e-01_JPRB, 7.00999e-01_JPRB, 7.03331e-01_JPRB, 7.05671e-01_JPRB, 7.08019e-01_JPRB, &
     & 7.10375e-01_JPRB, 7.12738e-01_JPRB, 7.15110e-01_JPRB, 7.17489e-01_JPRB, 7.19876e-01_JPRB, &
     & 7.22271e-01_JPRB, 7.24674e-01_JPRB, 7.27085e-01_JPRB, 7.29504e-01_JPRB, 7.31931e-01_JPRB, &
     & 7.34366e-01_JPRB, 7.36809e-01_JPRB, 7.39261e-01_JPRB, 7.41720e-01_JPRB/)
      kbo_mn2o( 2, :, 6) = (/ &
     & 6.98858e-01_JPRB, 7.01424e-01_JPRB, 7.03999e-01_JPRB, 7.06583e-01_JPRB, 7.09177e-01_JPRB, &
     & 7.11780e-01_JPRB, 7.14393e-01_JPRB, 7.17016e-01_JPRB, 7.19648e-01_JPRB, 7.22289e-01_JPRB, &
     & 7.24941e-01_JPRB, 7.27602e-01_JPRB, 7.30273e-01_JPRB, 7.32954e-01_JPRB, 7.35644e-01_JPRB, &
     & 7.38345e-01_JPRB, 7.41055e-01_JPRB, 7.43775e-01_JPRB, 7.46506e-01_JPRB/)
      kbo_mn2o( 3, :, 6) = (/ &
     & 7.08151e-01_JPRB, 7.10727e-01_JPRB, 7.13311e-01_JPRB, 7.15905e-01_JPRB, 7.18508e-01_JPRB, &
     & 7.21121e-01_JPRB, 7.23743e-01_JPRB, 7.26375e-01_JPRB, 7.29017e-01_JPRB, 7.31668e-01_JPRB, &
     & 7.34329e-01_JPRB, 7.36999e-01_JPRB, 7.39679e-01_JPRB, 7.42369e-01_JPRB, 7.45068e-01_JPRB, &
     & 7.47778e-01_JPRB, 7.50497e-01_JPRB, 7.53226e-01_JPRB, 7.55965e-01_JPRB/)
      kbo_mn2o( 4, :, 6) = (/ &
     & 7.22269e-01_JPRB, 7.24981e-01_JPRB, 7.27704e-01_JPRB, 7.30437e-01_JPRB, 7.33180e-01_JPRB, &
     & 7.35933e-01_JPRB, 7.38697e-01_JPRB, 7.41471e-01_JPRB, 7.44256e-01_JPRB, 7.47051e-01_JPRB, &
     & 7.49856e-01_JPRB, 7.52672e-01_JPRB, 7.55499e-01_JPRB, 7.58336e-01_JPRB, 7.61184e-01_JPRB, &
     & 7.64043e-01_JPRB, 7.66912e-01_JPRB, 7.69792e-01_JPRB, 7.72683e-01_JPRB/)
      kbo_mn2o( 5, :, 6) = (/ &
     & 1.75877e-01_JPRB, 1.78578e-01_JPRB, 1.81321e-01_JPRB, 1.84107e-01_JPRB, 1.86935e-01_JPRB, &
     & 1.89806e-01_JPRB, 1.92722e-01_JPRB, 1.95682e-01_JPRB, 1.98688e-01_JPRB, 2.01740e-01_JPRB, &
     & 2.04839e-01_JPRB, 2.07986e-01_JPRB, 2.11181e-01_JPRB, 2.14425e-01_JPRB, 2.17719e-01_JPRB, &
     & 2.21063e-01_JPRB, 2.24459e-01_JPRB, 2.27907e-01_JPRB, 2.31408e-01_JPRB/)
      kbo_mn2o( 1, :, 7) = (/ &
     & 1.82985e+00_JPRB, 1.83684e+00_JPRB, 1.84386e+00_JPRB, 1.85091e+00_JPRB, 1.85798e+00_JPRB, &
     & 1.86508e+00_JPRB, 1.87221e+00_JPRB, 1.87937e+00_JPRB, 1.88655e+00_JPRB, 1.89376e+00_JPRB, &
     & 1.90100e+00_JPRB, 1.90827e+00_JPRB, 1.91556e+00_JPRB, 1.92288e+00_JPRB, 1.93023e+00_JPRB, &
     & 1.93761e+00_JPRB, 1.94502e+00_JPRB, 1.95245e+00_JPRB, 1.95991e+00_JPRB/)
      kbo_mn2o( 2, :, 7) = (/ &
     & 1.83229e+00_JPRB, 1.83943e+00_JPRB, 1.84659e+00_JPRB, 1.85379e+00_JPRB, 1.86100e+00_JPRB, &
     & 1.86825e+00_JPRB, 1.87553e+00_JPRB, 1.88283e+00_JPRB, 1.89016e+00_JPRB, 1.89753e+00_JPRB, &
     & 1.90492e+00_JPRB, 1.91233e+00_JPRB, 1.91978e+00_JPRB, 1.92726e+00_JPRB, 1.93476e+00_JPRB, &
     & 1.94230e+00_JPRB, 1.94986e+00_JPRB, 1.95746e+00_JPRB, 1.96508e+00_JPRB/)
      kbo_mn2o( 3, :, 7) = (/ &
     & 1.84946e+00_JPRB, 1.85707e+00_JPRB, 1.86471e+00_JPRB, 1.87238e+00_JPRB, 1.88008e+00_JPRB, &
     & 1.88781e+00_JPRB, 1.89558e+00_JPRB, 1.90338e+00_JPRB, 1.91120e+00_JPRB, 1.91907e+00_JPRB, &
     & 1.92696e+00_JPRB, 1.93489e+00_JPRB, 1.94285e+00_JPRB, 1.95084e+00_JPRB, 1.95886e+00_JPRB, &
     & 1.96692e+00_JPRB, 1.97501e+00_JPRB, 1.98313e+00_JPRB, 1.99129e+00_JPRB/)
      kbo_mn2o( 4, :, 7) = (/ &
     & 1.88354e+00_JPRB, 1.89167e+00_JPRB, 1.89983e+00_JPRB, 1.90803e+00_JPRB, 1.91626e+00_JPRB, &
     & 1.92453e+00_JPRB, 1.93283e+00_JPRB, 1.94117e+00_JPRB, 1.94955e+00_JPRB, 1.95796e+00_JPRB, &
     & 1.96641e+00_JPRB, 1.97489e+00_JPRB, 1.98341e+00_JPRB, 1.99197e+00_JPRB, 2.00056e+00_JPRB, &
     & 2.00920e+00_JPRB, 2.01787e+00_JPRB, 2.02657e+00_JPRB, 2.03532e+00_JPRB/)
      kbo_mn2o( 5, :, 7) = (/ &
     & 3.35154e-01_JPRB, 3.43258e-01_JPRB, 3.51557e-01_JPRB, 3.60058e-01_JPRB, 3.68764e-01_JPRB, &
     & 3.77680e-01_JPRB, 3.86812e-01_JPRB, 3.96164e-01_JPRB, 4.05743e-01_JPRB, 4.15553e-01_JPRB, &
     & 4.25601e-01_JPRB, 4.35892e-01_JPRB, 4.46431e-01_JPRB, 4.57225e-01_JPRB, 4.68280e-01_JPRB, &
     & 4.79603e-01_JPRB, 4.91199e-01_JPRB, 5.03075e-01_JPRB, 5.15239e-01_JPRB/)
      kbo_mn2o( 1, :, 8) = (/ &
     & 4.46843e+00_JPRB, 4.49793e+00_JPRB, 4.52763e+00_JPRB, 4.55752e+00_JPRB, 4.58761e+00_JPRB, &
     & 4.61790e+00_JPRB, 4.64839e+00_JPRB, 4.67908e+00_JPRB, 4.70997e+00_JPRB, 4.74106e+00_JPRB, &
     & 4.77236e+00_JPRB, 4.80387e+00_JPRB, 4.83559e+00_JPRB, 4.86751e+00_JPRB, 4.89965e+00_JPRB, &
     & 4.93200e+00_JPRB, 4.96456e+00_JPRB, 4.99733e+00_JPRB, 5.03033e+00_JPRB/)
      kbo_mn2o( 2, :, 8) = (/ &
     & 4.44347e+00_JPRB, 4.47278e+00_JPRB, 4.50228e+00_JPRB, 4.53198e+00_JPRB, 4.56188e+00_JPRB, &
     & 4.59197e+00_JPRB, 4.62227e+00_JPRB, 4.65276e+00_JPRB, 4.68345e+00_JPRB, 4.71435e+00_JPRB, &
     & 4.74544e+00_JPRB, 4.77675e+00_JPRB, 4.80826e+00_JPRB, 4.83998e+00_JPRB, 4.87191e+00_JPRB, &
     & 4.90405e+00_JPRB, 4.93640e+00_JPRB, 4.96896e+00_JPRB, 5.00174e+00_JPRB/)
      kbo_mn2o( 3, :, 8) = (/ &
     & 4.43138e+00_JPRB, 4.46017e+00_JPRB, 4.48916e+00_JPRB, 4.51834e+00_JPRB, 4.54770e+00_JPRB, &
     & 4.57725e+00_JPRB, 4.60700e+00_JPRB, 4.63694e+00_JPRB, 4.66708e+00_JPRB, 4.69741e+00_JPRB, &
     & 4.72793e+00_JPRB, 4.75866e+00_JPRB, 4.78958e+00_JPRB, 4.82071e+00_JPRB, 4.85204e+00_JPRB, &
     & 4.88357e+00_JPRB, 4.91531e+00_JPRB, 4.94725e+00_JPRB, 4.97941e+00_JPRB/)
      kbo_mn2o( 4, :, 8) = (/ &
     & 4.47437e+00_JPRB, 4.50396e+00_JPRB, 4.53375e+00_JPRB, 4.56374e+00_JPRB, 4.59392e+00_JPRB, &
     & 4.62431e+00_JPRB, 4.65490e+00_JPRB, 4.68569e+00_JPRB, 4.71668e+00_JPRB, 4.74788e+00_JPRB, &
     & 4.77928e+00_JPRB, 4.81089e+00_JPRB, 4.84271e+00_JPRB, 4.87474e+00_JPRB, 4.90698e+00_JPRB, &
     & 4.93944e+00_JPRB, 4.97211e+00_JPRB, 5.00500e+00_JPRB, 5.03810e+00_JPRB/)
      kbo_mn2o( 5, :, 8) = (/ &
     & 8.82838e-01_JPRB, 8.92257e-01_JPRB, 9.01777e-01_JPRB, 9.11398e-01_JPRB, 9.21122e-01_JPRB, &
     & 9.30950e-01_JPRB, 9.40883e-01_JPRB, 9.50921e-01_JPRB, 9.61067e-01_JPRB, 9.71321e-01_JPRB, &
     & 9.81685e-01_JPRB, 9.92159e-01_JPRB, 1.00274e+00_JPRB, 1.01344e+00_JPRB, 1.02426e+00_JPRB, &
     & 1.03518e+00_JPRB, 1.04623e+00_JPRB, 1.05739e+00_JPRB, 1.06867e+00_JPRB/)
      kbo_mn2o( 1, :, 9) = (/ &
     & 7.92826e+00_JPRB, 7.83168e+00_JPRB, 7.73628e+00_JPRB, 7.64204e+00_JPRB, 7.54895e+00_JPRB, &
     & 7.45699e+00_JPRB, 7.36616e+00_JPRB, 7.27643e+00_JPRB, 7.18779e+00_JPRB, 7.10023e+00_JPRB, &
     & 7.01374e+00_JPRB, 6.92831e+00_JPRB, 6.84391e+00_JPRB, 6.76054e+00_JPRB, 6.67819e+00_JPRB, &
     & 6.59684e+00_JPRB, 6.51648e+00_JPRB, 6.43710e+00_JPRB, 6.35869e+00_JPRB/)
      kbo_mn2o( 2, :, 9) = (/ &
     & 7.89244e+00_JPRB, 7.79570e+00_JPRB, 7.70014e+00_JPRB, 7.60576e+00_JPRB, 7.51253e+00_JPRB, &
     & 7.42045e+00_JPRB, 7.32949e+00_JPRB, 7.23965e+00_JPRB, 7.15091e+00_JPRB, 7.06325e+00_JPRB, &
     & 6.97668e+00_JPRB, 6.89116e+00_JPRB, 6.80669e+00_JPRB, 6.72326e+00_JPRB, 6.64085e+00_JPRB, &
     & 6.55945e+00_JPRB, 6.47904e+00_JPRB, 6.39963e+00_JPRB, 6.32118e+00_JPRB/)
      kbo_mn2o( 3, :, 9) = (/ &
     & 7.79799e+00_JPRB, 7.70076e+00_JPRB, 7.60474e+00_JPRB, 7.50991e+00_JPRB, 7.41627e+00_JPRB, &
     & 7.32379e+00_JPRB, 7.23247e+00_JPRB, 7.14229e+00_JPRB, 7.05323e+00_JPRB, 6.96528e+00_JPRB, &
     & 6.87843e+00_JPRB, 6.79266e+00_JPRB, 6.70797e+00_JPRB, 6.62432e+00_JPRB, 6.54172e+00_JPRB, &
     & 6.46015e+00_JPRB, 6.37960e+00_JPRB, 6.30005e+00_JPRB, 6.22150e+00_JPRB/)
      kbo_mn2o( 4, :, 9) = (/ &
     & 7.53750e+00_JPRB, 7.43715e+00_JPRB, 7.33814e+00_JPRB, 7.24045e+00_JPRB, 7.14406e+00_JPRB, &
     & 7.04895e+00_JPRB, 6.95510e+00_JPRB, 6.86251e+00_JPRB, 6.77115e+00_JPRB, 6.68101e+00_JPRB, &
     & 6.59206e+00_JPRB, 6.50430e+00_JPRB, 6.41771e+00_JPRB, 6.33227e+00_JPRB, 6.24797e+00_JPRB, &
     & 6.16479e+00_JPRB, 6.08272e+00_JPRB, 6.00174e+00_JPRB, 5.92184e+00_JPRB/)
      kbo_mn2o( 5, :, 9) = (/ &
     & 5.06319e+00_JPRB, 5.08595e+00_JPRB, 5.10881e+00_JPRB, 5.13177e+00_JPRB, 5.15483e+00_JPRB, &
     & 5.17800e+00_JPRB, 5.20127e+00_JPRB, 5.22464e+00_JPRB, 5.24813e+00_JPRB, 5.27171e+00_JPRB, &
     & 5.29540e+00_JPRB, 5.31920e+00_JPRB, 5.34311e+00_JPRB, 5.36712e+00_JPRB, 5.39124e+00_JPRB, &
     & 5.41547e+00_JPRB, 5.43981e+00_JPRB, 5.46426e+00_JPRB, 5.48882e+00_JPRB/)
      kbo_mn2o( 1, :,10) = (/ &
     & 1.05265e+00_JPRB, 1.03986e+00_JPRB, 1.02723e+00_JPRB, 1.01475e+00_JPRB, 1.00243e+00_JPRB, &
     & 9.90250e-01_JPRB, 9.78220e-01_JPRB, 9.66338e-01_JPRB, 9.54599e-01_JPRB, 9.43003e-01_JPRB, &
     & 9.31548e-01_JPRB, 9.20232e-01_JPRB, 9.09054e-01_JPRB, 8.98011e-01_JPRB, 8.87102e-01_JPRB, &
     & 8.76326e-01_JPRB, 8.65681e-01_JPRB, 8.55165e-01_JPRB, 8.44777e-01_JPRB/)
      kbo_mn2o( 2, :,10) = (/ &
     & 1.05246e+00_JPRB, 1.03973e+00_JPRB, 1.02714e+00_JPRB, 1.01471e+00_JPRB, 1.00243e+00_JPRB, &
     & 9.90303e-01_JPRB, 9.78319e-01_JPRB, 9.66480e-01_JPRB, 9.54784e-01_JPRB, 9.43230e-01_JPRB, &
     & 9.31815e-01_JPRB, 9.20539e-01_JPRB, 9.09399e-01_JPRB, 8.98394e-01_JPRB, 8.87522e-01_JPRB, &
     & 8.76782e-01_JPRB, 8.66171e-01_JPRB, 8.55690e-01_JPRB, 8.45335e-01_JPRB/)
      kbo_mn2o( 3, :,10) = (/ &
     & 1.05236e+00_JPRB, 1.03963e+00_JPRB, 1.02704e+00_JPRB, 1.01461e+00_JPRB, 1.00233e+00_JPRB, &
     & 9.90203e-01_JPRB, 9.78219e-01_JPRB, 9.66380e-01_JPRB, 9.54684e-01_JPRB, 9.43130e-01_JPRB, &
     & 9.31715e-01_JPRB, 9.20439e-01_JPRB, 9.09300e-01_JPRB, 8.98295e-01_JPRB, 8.87423e-01_JPRB, &
     & 8.76683e-01_JPRB, 8.66073e-01_JPRB, 8.55591e-01_JPRB, 8.45236e-01_JPRB/)
      kbo_mn2o( 4, :,10) = (/ &
     & 9.30836e-01_JPRB, 9.21099e-01_JPRB, 9.11464e-01_JPRB, 9.01930e-01_JPRB, 8.92495e-01_JPRB, &
     & 8.83159e-01_JPRB, 8.73921e-01_JPRB, 8.64779e-01_JPRB, 8.55733e-01_JPRB, 8.46781e-01_JPRB, &
     & 8.37923e-01_JPRB, 8.29158e-01_JPRB, 8.20485e-01_JPRB, 8.11902e-01_JPRB, 8.03409e-01_JPRB, &
     & 7.95005e-01_JPRB, 7.86689e-01_JPRB, 7.78460e-01_JPRB, 7.70316e-01_JPRB/)
      kbo_mn2o( 5, :,10) = (/ &
     & 1.65786e+01_JPRB, 1.66541e+01_JPRB, 1.67299e+01_JPRB, 1.68062e+01_JPRB, 1.68827e+01_JPRB, &
     & 1.69596e+01_JPRB, 1.70369e+01_JPRB, 1.71145e+01_JPRB, 1.71925e+01_JPRB, 1.72708e+01_JPRB, &
     & 1.73495e+01_JPRB, 1.74285e+01_JPRB, 1.75079e+01_JPRB, 1.75877e+01_JPRB, 1.76678e+01_JPRB, &
     & 1.77483e+01_JPRB, 1.78291e+01_JPRB, 1.79103e+01_JPRB, 1.79919e+01_JPRB/)
      kbo_mn2o( 1, :,11) = (/ &
     & 1.74239e-01_JPRB, 1.77873e-01_JPRB, 1.81583e-01_JPRB, 1.85370e-01_JPRB, 1.89236e-01_JPRB, &
     & 1.93182e-01_JPRB, 1.97211e-01_JPRB, 2.01324e-01_JPRB, 2.05523e-01_JPRB, 2.09809e-01_JPRB, &
     & 2.14185e-01_JPRB, 2.18652e-01_JPRB, 2.23212e-01_JPRB, 2.27867e-01_JPRB, 2.32620e-01_JPRB, &
     & 2.37471e-01_JPRB, 2.42424e-01_JPRB, 2.47479e-01_JPRB, 2.52641e-01_JPRB/)
      kbo_mn2o( 2, :,11) = (/ &
     & 1.74114e-01_JPRB, 1.77756e-01_JPRB, 1.81475e-01_JPRB, 1.85271e-01_JPRB, 1.89147e-01_JPRB, &
     & 1.93104e-01_JPRB, 1.97144e-01_JPRB, 2.01268e-01_JPRB, 2.05479e-01_JPRB, 2.09778e-01_JPRB, &
     & 2.14166e-01_JPRB, 2.18647e-01_JPRB, 2.23221e-01_JPRB, 2.27890e-01_JPRB, 2.32658e-01_JPRB, &
     & 2.37525e-01_JPRB, 2.42494e-01_JPRB, 2.47567e-01_JPRB, 2.52746e-01_JPRB/)
      kbo_mn2o( 3, :,11) = (/ &
     & 1.74142e-01_JPRB, 1.77780e-01_JPRB, 1.81494e-01_JPRB, 1.85286e-01_JPRB, 1.89157e-01_JPRB, &
     & 1.93108e-01_JPRB, 1.97143e-01_JPRB, 2.01261e-01_JPRB, 2.05466e-01_JPRB, 2.09759e-01_JPRB, &
     & 2.14141e-01_JPRB, 2.18615e-01_JPRB, 2.23182e-01_JPRB, 2.27845e-01_JPRB, 2.32605e-01_JPRB, &
     & 2.37464e-01_JPRB, 2.42425e-01_JPRB, 2.47490e-01_JPRB, 2.52661e-01_JPRB/)
      kbo_mn2o( 4, :,11) = (/ &
     & 1.74074e-01_JPRB, 1.77716e-01_JPRB, 1.81435e-01_JPRB, 1.85231e-01_JPRB, 1.89107e-01_JPRB, &
     & 1.93064e-01_JPRB, 1.97104e-01_JPRB, 2.01229e-01_JPRB, 2.05439e-01_JPRB, 2.09738e-01_JPRB, &
     & 2.14127e-01_JPRB, 2.18607e-01_JPRB, 2.23181e-01_JPRB, 2.27852e-01_JPRB, 2.32619e-01_JPRB, &
     & 2.37487e-01_JPRB, 2.42456e-01_JPRB, 2.47529e-01_JPRB, 2.52709e-01_JPRB/)
      kbo_mn2o( 5, :,11) = (/ &
     & 2.31905e+01_JPRB, 2.33011e+01_JPRB, 2.34123e+01_JPRB, 2.35240e+01_JPRB, 2.36362e+01_JPRB, &
     & 2.37489e+01_JPRB, 2.38622e+01_JPRB, 2.39760e+01_JPRB, 2.40904e+01_JPRB, 2.42053e+01_JPRB, &
     & 2.43208e+01_JPRB, 2.44368e+01_JPRB, 2.45533e+01_JPRB, 2.46705e+01_JPRB, 2.47881e+01_JPRB, &
     & 2.49064e+01_JPRB, 2.50252e+01_JPRB, 2.51446e+01_JPRB, 2.52645e+01_JPRB/)
      kbo_mn2o( 1, :,12) = (/ &
     & 1.60269e-01_JPRB, 1.62873e-01_JPRB, 1.65519e-01_JPRB, 1.68208e-01_JPRB, 1.70940e-01_JPRB, &
     & 1.73717e-01_JPRB, 1.76540e-01_JPRB, 1.79408e-01_JPRB, 1.82322e-01_JPRB, 1.85284e-01_JPRB, &
     & 1.88295e-01_JPRB, 1.91354e-01_JPRB, 1.94462e-01_JPRB, 1.97622e-01_JPRB, 2.00832e-01_JPRB, &
     & 2.04095e-01_JPRB, 2.07411e-01_JPRB, 2.10780e-01_JPRB, 2.14205e-01_JPRB/)
      kbo_mn2o( 2, :,12) = (/ &
     & 1.60497e-01_JPRB, 1.63096e-01_JPRB, 1.65738e-01_JPRB, 1.68422e-01_JPRB, 1.71150e-01_JPRB, &
     & 1.73922e-01_JPRB, 1.76738e-01_JPRB, 1.79601e-01_JPRB, 1.82510e-01_JPRB, 1.85466e-01_JPRB, &
     & 1.88469e-01_JPRB, 1.91522e-01_JPRB, 1.94624e-01_JPRB, 1.97776e-01_JPRB, 2.00979e-01_JPRB, &
     & 2.04234e-01_JPRB, 2.07542e-01_JPRB, 2.10903e-01_JPRB, 2.14319e-01_JPRB/)
      kbo_mn2o( 3, :,12) = (/ &
     & 1.60407e-01_JPRB, 1.63006e-01_JPRB, 1.65648e-01_JPRB, 1.68332e-01_JPRB, 1.71060e-01_JPRB, &
     & 1.73832e-01_JPRB, 1.76649e-01_JPRB, 1.79511e-01_JPRB, 1.82420e-01_JPRB, 1.85376e-01_JPRB, &
     & 1.88380e-01_JPRB, 1.91433e-01_JPRB, 1.94535e-01_JPRB, 1.97687e-01_JPRB, 2.00891e-01_JPRB, &
     & 2.04146e-01_JPRB, 2.07454e-01_JPRB, 2.10816e-01_JPRB, 2.14232e-01_JPRB/)
      kbo_mn2o( 4, :,12) = (/ &
     & 1.60475e-01_JPRB, 1.63070e-01_JPRB, 1.65706e-01_JPRB, 1.68386e-01_JPRB, 1.71109e-01_JPRB, &
     & 1.73876e-01_JPRB, 1.76687e-01_JPRB, 1.79544e-01_JPRB, 1.82448e-01_JPRB, 1.85398e-01_JPRB, &
     & 1.88396e-01_JPRB, 1.91442e-01_JPRB, 1.94538e-01_JPRB, 1.97684e-01_JPRB, 2.00881e-01_JPRB, &
     & 2.04129e-01_JPRB, 2.07430e-01_JPRB, 2.10784e-01_JPRB, 2.14192e-01_JPRB/)
      kbo_mn2o( 5, :,12) = (/ &
     & 3.25743e+01_JPRB, 3.27992e+01_JPRB, 3.30256e+01_JPRB, 3.32536e+01_JPRB, 3.34832e+01_JPRB, &
     & 3.37143e+01_JPRB, 3.39471e+01_JPRB, 3.41815e+01_JPRB, 3.44174e+01_JPRB, 3.46550e+01_JPRB, &
     & 3.48943e+01_JPRB, 3.51352e+01_JPRB, 3.53778e+01_JPRB, 3.56220e+01_JPRB, 3.58679e+01_JPRB, &
     & 3.61156e+01_JPRB, 3.63649e+01_JPRB, 3.66159e+01_JPRB, 3.68687e+01_JPRB/)
      kbo_mn2o( 1, :,13) = (/ &
     & 2.01846e-01_JPRB, 2.03110e-01_JPRB, 2.04381e-01_JPRB, 2.05660e-01_JPRB, 2.06947e-01_JPRB, &
     & 2.08242e-01_JPRB, 2.09546e-01_JPRB, 2.10857e-01_JPRB, 2.12177e-01_JPRB, 2.13505e-01_JPRB, &
     & 2.14841e-01_JPRB, 2.16186e-01_JPRB, 2.17539e-01_JPRB, 2.18900e-01_JPRB, 2.20270e-01_JPRB, &
     & 2.21649e-01_JPRB, 2.23036e-01_JPRB, 2.24432e-01_JPRB, 2.25837e-01_JPRB/)
      kbo_mn2o( 2, :,13) = (/ &
     & 2.01756e-01_JPRB, 2.03020e-01_JPRB, 2.04291e-01_JPRB, 2.05570e-01_JPRB, 2.06857e-01_JPRB, &
     & 2.08152e-01_JPRB, 2.09456e-01_JPRB, 2.10767e-01_JPRB, 2.12087e-01_JPRB, 2.13415e-01_JPRB, &
     & 2.14751e-01_JPRB, 2.16096e-01_JPRB, 2.17449e-01_JPRB, 2.18810e-01_JPRB, 2.20181e-01_JPRB, &
     & 2.21559e-01_JPRB, 2.22946e-01_JPRB, 2.24342e-01_JPRB, 2.25747e-01_JPRB/)
      kbo_mn2o( 3, :,13) = (/ &
     & 2.01836e-01_JPRB, 2.03100e-01_JPRB, 2.04371e-01_JPRB, 2.05650e-01_JPRB, 2.06937e-01_JPRB, &
     & 2.08232e-01_JPRB, 2.09536e-01_JPRB, 2.10847e-01_JPRB, 2.12167e-01_JPRB, 2.13495e-01_JPRB, &
     & 2.14831e-01_JPRB, 2.16176e-01_JPRB, 2.17529e-01_JPRB, 2.18890e-01_JPRB, 2.20260e-01_JPRB, &
     & 2.21639e-01_JPRB, 2.23026e-01_JPRB, 2.24422e-01_JPRB, 2.25827e-01_JPRB/)
      kbo_mn2o( 4, :,13) = (/ &
     & 2.01845e-01_JPRB, 2.03103e-01_JPRB, 2.04370e-01_JPRB, 2.05644e-01_JPRB, 2.06926e-01_JPRB, &
     & 2.08217e-01_JPRB, 2.09515e-01_JPRB, 2.10822e-01_JPRB, 2.12136e-01_JPRB, 2.13459e-01_JPRB, &
     & 2.14790e-01_JPRB, 2.16129e-01_JPRB, 2.17477e-01_JPRB, 2.18833e-01_JPRB, 2.20198e-01_JPRB, &
     & 2.21571e-01_JPRB, 2.22952e-01_JPRB, 2.24343e-01_JPRB, 2.25741e-01_JPRB/)
      kbo_mn2o( 5, :,13) = (/ &
     & 5.34154e+01_JPRB, 5.31954e+01_JPRB, 5.29763e+01_JPRB, 5.27582e+01_JPRB, 5.25409e+01_JPRB, &
     & 5.23245e+01_JPRB, 5.21090e+01_JPRB, 5.18943e+01_JPRB, 5.16806e+01_JPRB, 5.14677e+01_JPRB, &
     & 5.12558e+01_JPRB, 5.10446e+01_JPRB, 5.08344e+01_JPRB, 5.06250e+01_JPRB, 5.04165e+01_JPRB, &
     & 5.02089e+01_JPRB, 5.00021e+01_JPRB, 4.97961e+01_JPRB, 4.95910e+01_JPRB/)
      kbo_mn2o( 1, :,14) = (/ &
     & 2.87818e-02_JPRB, 3.17868e-02_JPRB, 3.51056e-02_JPRB, 3.87708e-02_JPRB, 4.28187e-02_JPRB, &
     & 4.72893e-02_JPRB, 5.22266e-02_JPRB, 5.76794e-02_JPRB, 6.37015e-02_JPRB, 7.03523e-02_JPRB, &
     & 7.76976e-02_JPRB, 8.58097e-02_JPRB, 9.47688e-02_JPRB, 1.04663e-01_JPRB, 1.15591e-01_JPRB, &
     & 1.27659e-01_JPRB, 1.40988e-01_JPRB, 1.55708e-01_JPRB, 1.71965e-01_JPRB/)
      kbo_mn2o( 2, :,14) = (/ &
     & 2.88500e-02_JPRB, 3.18494e-02_JPRB, 3.51606e-02_JPRB, 3.88161e-02_JPRB, 4.28517e-02_JPRB, &
     & 4.73068e-02_JPRB, 5.22251e-02_JPRB, 5.76547e-02_JPRB, 6.36488e-02_JPRB, 7.02661e-02_JPRB, &
     & 7.75714e-02_JPRB, 8.56362e-02_JPRB, 9.45395e-02_JPRB, 1.04368e-01_JPRB, 1.15219e-01_JPRB, &
     & 1.27198e-01_JPRB, 1.40422e-01_JPRB, 1.55021e-01_JPRB, 1.71138e-01_JPRB/)
      kbo_mn2o( 3, :,14) = (/ &
     & 2.88036e-02_JPRB, 3.18109e-02_JPRB, 3.51322e-02_JPRB, 3.88002e-02_JPRB, 4.28512e-02_JPRB, &
     & 4.73252e-02_JPRB, 5.22663e-02_JPRB, 5.77232e-02_JPRB, 6.37499e-02_JPRB, 7.04058e-02_JPRB, &
     & 7.77567e-02_JPRB, 8.58751e-02_JPRB, 9.48410e-02_JPRB, 1.04743e-01_JPRB, 1.15679e-01_JPRB, &
     & 1.27757e-01_JPRB, 1.41095e-01_JPRB, 1.55827e-01_JPRB, 1.72096e-01_JPRB/)
      kbo_mn2o( 4, :,14) = (/ &
     & 2.87750e-02_JPRB, 3.17783e-02_JPRB, 3.50951e-02_JPRB, 3.87580e-02_JPRB, 4.28033e-02_JPRB, &
     & 4.72708e-02_JPRB, 5.22046e-02_JPRB, 5.76533e-02_JPRB, 6.36707e-02_JPRB, 7.03162e-02_JPRB, &
     & 7.76553e-02_JPRB, 8.57604e-02_JPRB, 9.47114e-02_JPRB, 1.04597e-01_JPRB, 1.15514e-01_JPRB, &
     & 1.27570e-01_JPRB, 1.40885e-01_JPRB, 1.55589e-01_JPRB, 1.71829e-01_JPRB/)
      kbo_mn2o( 5, :,14) = (/ &
     & 1.11848e+02_JPRB, 1.09489e+02_JPRB, 1.07179e+02_JPRB, 1.04918e+02_JPRB, 1.02705e+02_JPRB, &
     & 1.00538e+02_JPRB, 9.84175e+01_JPRB, 9.63414e+01_JPRB, 9.43091e+01_JPRB, 9.23196e+01_JPRB, &
     & 9.03722e+01_JPRB, 8.84658e+01_JPRB, 8.65996e+01_JPRB, 8.47728e+01_JPRB, 8.29845e+01_JPRB, &
     & 8.12339e+01_JPRB, 7.95203e+01_JPRB, 7.78428e+01_JPRB, 7.62007e+01_JPRB/)
      kbo_mn2o( 1, :,15) = (/ &
     & 1.52234e-02_JPRB, 1.69256e-02_JPRB, 1.88181e-02_JPRB, 2.09222e-02_JPRB, 2.32617e-02_JPRB, &
     & 2.58626e-02_JPRB, 2.87545e-02_JPRB, 3.19696e-02_JPRB, 3.55443e-02_JPRB, 3.95187e-02_JPRB, &
     & 4.39374e-02_JPRB, 4.88503e-02_JPRB, 5.43124e-02_JPRB, 6.03854e-02_JPRB, 6.71373e-02_JPRB, &
     & 7.46443e-02_JPRB, 8.29906e-02_JPRB, 9.22701e-02_JPRB, 1.02587e-01_JPRB/)
      kbo_mn2o( 2, :,15) = (/ &
     & 1.52234e-02_JPRB, 1.69256e-02_JPRB, 1.88181e-02_JPRB, 2.09222e-02_JPRB, 2.32617e-02_JPRB, &
     & 2.58626e-02_JPRB, 2.87545e-02_JPRB, 3.19696e-02_JPRB, 3.55443e-02_JPRB, 3.95187e-02_JPRB, &
     & 4.39374e-02_JPRB, 4.88503e-02_JPRB, 5.43124e-02_JPRB, 6.03854e-02_JPRB, 6.71373e-02_JPRB, &
     & 7.46443e-02_JPRB, 8.29906e-02_JPRB, 9.22701e-02_JPRB, 1.02587e-01_JPRB/)
      kbo_mn2o( 3, :,15) = (/ &
     & 1.52076e-02_JPRB, 1.69049e-02_JPRB, 1.87916e-02_JPRB, 2.08890e-02_JPRB, 2.32203e-02_JPRB, &
     & 2.58119e-02_JPRB, 2.86928e-02_JPRB, 3.18951e-02_JPRB, 3.54549e-02_JPRB, 3.94120e-02_JPRB, &
     & 4.38107e-02_JPRB, 4.87003e-02_JPRB, 5.41357e-02_JPRB, 6.01777e-02_JPRB, 6.68940e-02_JPRB, &
     & 7.43600e-02_JPRB, 8.26593e-02_JPRB, 9.18847e-02_JPRB, 1.02140e-01_JPRB/)
      kbo_mn2o( 4, :,15) = (/ &
     & 1.52422e-02_JPRB, 1.69488e-02_JPRB, 1.88464e-02_JPRB, 2.09565e-02_JPRB, 2.33028e-02_JPRB, &
     & 2.59118e-02_JPRB, 2.88129e-02_JPRB, 3.20389e-02_JPRB, 3.56260e-02_JPRB, 3.96148e-02_JPRB, &
     & 4.40501e-02_JPRB, 4.89821e-02_JPRB, 5.44662e-02_JPRB, 6.05643e-02_JPRB, 6.73452e-02_JPRB, &
     & 7.48853e-02_JPRB, 8.32696e-02_JPRB, 9.25927e-02_JPRB, 1.02959e-01_JPRB/)
      kbo_mn2o( 5, :,15) = (/ &
     & 6.94782e+01_JPRB, 6.73469e+01_JPRB, 6.52810e+01_JPRB, 6.32785e+01_JPRB, 6.13373e+01_JPRB, &
     & 5.94558e+01_JPRB, 5.76319e+01_JPRB, 5.58640e+01_JPRB, 5.41503e+01_JPRB, 5.24892e+01_JPRB, &
     & 5.08791e+01_JPRB, 4.93183e+01_JPRB, 4.78055e+01_JPRB, 4.63390e+01_JPRB, 4.49175e+01_JPRB, &
     & 4.35396e+01_JPRB, 4.22040e+01_JPRB, 4.09094e+01_JPRB, 3.96544e+01_JPRB/)
      kbo_mn2o( 1, :,16) = (/ &
     & 1.08257e-02_JPRB, 1.15188e-02_JPRB, 1.22563e-02_JPRB, 1.30410e-02_JPRB, 1.38759e-02_JPRB, &
     & 1.47643e-02_JPRB, 1.57096e-02_JPRB, 1.67154e-02_JPRB, 1.77857e-02_JPRB, 1.89244e-02_JPRB, &
     & 2.01360e-02_JPRB, 2.14252e-02_JPRB, 2.27970e-02_JPRB, 2.42565e-02_JPRB, 2.58096e-02_JPRB, &
     & 2.74620e-02_JPRB, 2.92203e-02_JPRB, 3.10911e-02_JPRB, 3.30817e-02_JPRB/)
      kbo_mn2o( 2, :,16) = (/ &
     & 1.08257e-02_JPRB, 1.15188e-02_JPRB, 1.22563e-02_JPRB, 1.30410e-02_JPRB, 1.38759e-02_JPRB, &
     & 1.47643e-02_JPRB, 1.57096e-02_JPRB, 1.67154e-02_JPRB, 1.77857e-02_JPRB, 1.89244e-02_JPRB, &
     & 2.01360e-02_JPRB, 2.14252e-02_JPRB, 2.27970e-02_JPRB, 2.42565e-02_JPRB, 2.58096e-02_JPRB, &
     & 2.74620e-02_JPRB, 2.92203e-02_JPRB, 3.10911e-02_JPRB, 3.30817e-02_JPRB/)
      kbo_mn2o( 3, :,16) = (/ &
     & 1.08257e-02_JPRB, 1.15188e-02_JPRB, 1.22563e-02_JPRB, 1.30410e-02_JPRB, 1.38759e-02_JPRB, &
     & 1.47643e-02_JPRB, 1.57096e-02_JPRB, 1.67154e-02_JPRB, 1.77857e-02_JPRB, 1.89244e-02_JPRB, &
     & 2.01360e-02_JPRB, 2.14252e-02_JPRB, 2.27970e-02_JPRB, 2.42565e-02_JPRB, 2.58096e-02_JPRB, &
     & 2.74620e-02_JPRB, 2.92203e-02_JPRB, 3.10911e-02_JPRB, 3.30817e-02_JPRB/)
      kbo_mn2o( 4, :,16) = (/ &
     & 1.08263e-02_JPRB, 1.15191e-02_JPRB, 1.22562e-02_JPRB, 1.30404e-02_JPRB, 1.38749e-02_JPRB, &
     & 1.47627e-02_JPRB, 1.57073e-02_JPRB, 1.67124e-02_JPRB, 1.77818e-02_JPRB, 1.89196e-02_JPRB, &
     & 2.01302e-02_JPRB, 2.14183e-02_JPRB, 2.27888e-02_JPRB, 2.42470e-02_JPRB, 2.57986e-02_JPRB, &
     & 2.74494e-02_JPRB, 2.92058e-02_JPRB, 3.10746e-02_JPRB, 3.30630e-02_JPRB/)
      kbo_mn2o( 5, :,16) = (/ &
     & 4.53450e-08_JPRB, 5.75193e-08_JPRB, 7.29620e-08_JPRB, 9.25509e-08_JPRB, 1.17399e-07_JPRB, &
     & 1.48918e-07_JPRB, 1.88900e-07_JPRB, 2.39616e-07_JPRB, 3.03948e-07_JPRB, 3.85551e-07_JPRB, &
     & 4.89064e-07_JPRB, 6.20369e-07_JPRB, 7.86925e-07_JPRB, 9.98199e-07_JPRB, 1.26619e-06_JPRB, &
     & 1.60614e-06_JPRB, 2.03736e-06_JPRB, 2.58435e-06_JPRB, 3.27819e-06_JPRB/)

!     The array FORREFO contains the coefficient of the water vapor
!     foreign-continuum (including the energy term).  The first 
!     index refers to reference temperature (296,260,224,260) and 
!     pressure (970,475,219,3 mbar) levels.  The second index 
!     runs over the g-channel (1 to 16).

      forrefo(1,:) = (/ &
     &9.0039e-04_JPRB,1.1081e-03_JPRB,1.0732e-03_JPRB,1.1881e-03_JPRB,1.2488e-03_JPRB,1.3170e-03_JPRB, &
     &1.3317e-03_JPRB,1.3168e-03_JPRB,1.3369e-03_JPRB,1.4228e-03_JPRB,1.5385e-03_JPRB,1.7376e-03_JPRB, &
     &1.7122e-03_JPRB,1.9002e-03_JPRB,1.8881e-03_JPRB,2.1595e-03_JPRB/)
      forrefo(2,:) = (/ &
     &1.2726e-03_JPRB,1.3680e-03_JPRB,1.2494e-03_JPRB,1.2049e-03_JPRB,1.2048e-03_JPRB,1.1256e-03_JPRB, &
     &1.1170e-03_JPRB,1.0697e-03_JPRB,1.1177e-03_JPRB,1.1883e-03_JPRB,1.2219e-03_JPRB,1.2179e-03_JPRB, &
     &1.5692e-03_JPRB,1.9103e-03_JPRB,2.0219e-03_JPRB,1.6937e-03_JPRB/)
      forrefo(3,:) = (/ &
     &1.5527e-03_JPRB,1.6477e-03_JPRB,1.4973e-03_JPRB,1.3400e-03_JPRB,1.0820e-03_JPRB,9.3315e-04_JPRB, &
     &8.8132e-04_JPRB,8.1508e-04_JPRB,8.3559e-04_JPRB,7.6492e-04_JPRB,8.2343e-04_JPRB,7.1274e-04_JPRB, &
     &6.6011e-04_JPRB,6.7179e-04_JPRB,6.7039e-04_JPRB,6.7021e-04_JPRB/)
      forrefo(4,:) = (/ &
     &1.6763e-03_JPRB,1.6066e-03_JPRB,1.3927e-03_JPRB,1.2087e-03_JPRB,9.8463e-04_JPRB,8.8414e-04_JPRB, &
     &8.0976e-04_JPRB,7.8758e-04_JPRB,7.7376e-04_JPRB,7.5785e-04_JPRB,7.4152e-04_JPRB,7.3814e-04_JPRB, &
     &7.4278e-04_JPRB,7.1745e-04_JPRB,6.7216e-04_JPRB,6.4097e-04_JPRB/)

!     The array SELFREFO contains the coefficient of the water vapor
!     self-continuum (including the energy term).  The first index
!     refers to temperature in 7.2 degree increments.  For instance,
!     JT = 1 refers to a temperature of 245.6, JT = 2 refers to 252.8,
!     etc.  The second index runs over the g-channel (1 to 16).

      selfrefo(:, 1) = (/ &
     & 5.11926e-01_JPRB, 4.32863e-01_JPRB, 3.66010e-01_JPRB, 3.09482e-01_JPRB, 2.61685e-01_JPRB, &
     & 2.21269e-01_JPRB, 1.87096e-01_JPRB, 1.58200e-01_JPRB, 1.33767e-01_JPRB, 1.13108e-01_JPRB/)
      selfrefo(:, 2) = (/ &
     & 5.02863e-01_JPRB, 4.35008e-01_JPRB, 3.76310e-01_JPRB, 3.25532e-01_JPRB, 2.81606e-01_JPRB, &
     & 2.43607e-01_JPRB, 2.10736e-01_JPRB, 1.82300e-01_JPRB, 1.57701e-01_JPRB, 1.36422e-01_JPRB/)
      selfrefo(:, 3) = (/ &
     & 4.57628e-01_JPRB, 3.99663e-01_JPRB, 3.49040e-01_JPRB, 3.04829e-01_JPRB, 2.66218e-01_JPRB, &
     & 2.32498e-01_JPRB, 2.03049e-01_JPRB, 1.77330e-01_JPRB, 1.54869e-01_JPRB, 1.35252e-01_JPRB/)
      selfrefo(:, 4) = (/ &
     & 4.28634e-01_JPRB, 3.81736e-01_JPRB, 3.39970e-01_JPRB, 3.02773e-01_JPRB, 2.69647e-01_JPRB, &
     & 2.40144e-01_JPRB, 2.13870e-01_JPRB, 1.90470e-01_JPRB, 1.69630e-01_JPRB, 1.51071e-01_JPRB/)
      selfrefo(:, 5) = (/ &
     & 4.21002e-01_JPRB, 3.77493e-01_JPRB, 3.38480e-01_JPRB, 3.03499e-01_JPRB, 2.72133e-01_JPRB, &
     & 2.44009e-01_JPRB, 2.18792e-01_JPRB, 1.96180e-01_JPRB, 1.75905e-01_JPRB, 1.57726e-01_JPRB/)
      selfrefo(:, 6) = (/ &
     & 3.97517e-01_JPRB, 3.61167e-01_JPRB, 3.28140e-01_JPRB, 2.98133e-01_JPRB, 2.70871e-01_JPRB, &
     & 2.46101e-01_JPRB, 2.23597e-01_JPRB, 2.03150e-01_JPRB, 1.84573e-01_JPRB, 1.67695e-01_JPRB/)
      selfrefo(:, 7) = (/ &
     & 3.92114e-01_JPRB, 3.57554e-01_JPRB, 3.26040e-01_JPRB, 2.97304e-01_JPRB, 2.71100e-01_JPRB, &
     & 2.47206e-01_JPRB, 2.25418e-01_JPRB, 2.05550e-01_JPRB, 1.87433e-01_JPRB, 1.70913e-01_JPRB/)
      selfrefo(:, 8) = (/ &
     & 3.79555e-01_JPRB, 3.47264e-01_JPRB, 3.17720e-01_JPRB, 2.90690e-01_JPRB, 2.65959e-01_JPRB, &
     & 2.43332e-01_JPRB, 2.22631e-01_JPRB, 2.03690e-01_JPRB, 1.86361e-01_JPRB, 1.70506e-01_JPRB/)
      selfrefo(:, 9) = (/ &
     & 3.92644e-01_JPRB, 3.58048e-01_JPRB, 3.26500e-01_JPRB, 2.97732e-01_JPRB, 2.71498e-01_JPRB, &
     & 2.47576e-01_JPRB, 2.25762e-01_JPRB, 2.05870e-01_JPRB, 1.87731e-01_JPRB, 1.71190e-01_JPRB/)
      selfrefo(:,10) = (/ &
     & 4.06542e-01_JPRB, 3.71200e-01_JPRB, 3.38930e-01_JPRB, 3.09465e-01_JPRB, 2.82562e-01_JPRB, &
     & 2.57998e-01_JPRB, 2.35569e-01_JPRB, 2.15090e-01_JPRB, 1.96391e-01_JPRB, 1.79318e-01_JPRB/)
      selfrefo(:,11) = (/ &
     & 4.09672e-01_JPRB, 3.76237e-01_JPRB, 3.45530e-01_JPRB, 3.17329e-01_JPRB, 2.91430e-01_JPRB, &
     & 2.67645e-01_JPRB, 2.45801e-01_JPRB, 2.25740e-01_JPRB, 2.07316e-01_JPRB, 1.90396e-01_JPRB/)
      selfrefo(:,12) = (/ &
     & 3.85140e-01_JPRB, 3.61989e-01_JPRB, 3.40230e-01_JPRB, 3.19779e-01_JPRB, 3.00557e-01_JPRB, &
     & 2.82490e-01_JPRB, 2.65510e-01_JPRB, 2.49550e-01_JPRB, 2.34549e-01_JPRB, 2.20451e-01_JPRB/)
      selfrefo(:,13) = (/ &
     & 4.87349e-01_JPRB, 4.42192e-01_JPRB, 4.01220e-01_JPRB, 3.64044e-01_JPRB, 3.30313e-01_JPRB, &
     & 2.99707e-01_JPRB, 2.71937e-01_JPRB, 2.46740e-01_JPRB, 2.23878e-01_JPRB, 2.03134e-01_JPRB/)
      selfrefo(:,14) = (/ &
     & 5.64339e-01_JPRB, 5.06194e-01_JPRB, 4.54040e-01_JPRB, 4.07259e-01_JPRB, 3.65298e-01_JPRB, &
     & 3.27661e-01_JPRB, 2.93901e-01_JPRB, 2.63620e-01_JPRB, 2.36459e-01_JPRB, 2.12096e-01_JPRB/)
      selfrefo(:,15) = (/ &
     & 5.91123e-01_JPRB, 5.26420e-01_JPRB, 4.68800e-01_JPRB, 4.17486e-01_JPRB, 3.71790e-01_JPRB, &
     & 3.31095e-01_JPRB, 2.94854e-01_JPRB, 2.62580e-01_JPRB, 2.33839e-01_JPRB, 2.08243e-01_JPRB/)
      selfrefo(:,16) = (/ &
     & 5.04590e-01_JPRB, 4.65235e-01_JPRB, 4.28950e-01_JPRB, 3.95495e-01_JPRB, 3.64649e-01_JPRB, &
     & 3.36209e-01_JPRB, 3.09987e-01_JPRB, 2.85810e-01_JPRB, 2.63519e-01_JPRB, 2.42966e-01_JPRB/)


!IF (LHOOK) CALL DR_HOOK('RRTM_KGB3',1,ZHOOK_HANDLE)
RETURN

1001 CONTINUE
CALL ABOR1("RRTM_KGB3:ERROR READING FILE RADRRTM")

END SUBROUTINE RRTM_KGB3
