SUBROUTINE RRTM_KGB15

!     Originally by Eli J. Mlawer, Atmospheric & Environmental Research.
!     BAND 15:  2380-2600 cm-1 (low - N2O,CO2; high - nothing)
!     Reformatted for F90 by JJMorcrette, ECMWF
!     R. Elkhatib 12-10-2005 Split for faster and more robust compilation.
!     G.Mozdzynski March 2011 read constants from files
!     ABozzo 2001306 updated to rrtmg v4.85
!     band 15:  2380-2600 cm-1 (low - n2o,co2; low minor - n2)
!                              (high - nothing)
!     T. Wilhelmsson and K. Yessad (Oct 2013) Geometry and setup refactoring.
!     ------------------------------------------------------------------

USE PARKIND1  ,ONLY : JPRB
!USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE YOMLUN    ,ONLY : NULRAD
USE MPL_MODULE,ONLY : MPL_BROADCAST
USE YOMTAG    ,ONLY : MTAGRAD
USE YOMMP0    , ONLY : NPROC, MYPROC

USE YOERRTO15, ONLY : KAO,KAO_D,KAO_MN2  ,SELFREFO,FORREFO   ,FRACREFAO


!     ------------------------------------------------------------------

IMPLICIT NONE
!REAL(KIND=JPRB) :: ZHOOK_HANDLE

#include "abor1.intfb.h"

!IF (LHOOK) CALL DR_HOOK('RRTM_KGB15',0,ZHOOK_HANDLE)

IF( MYPROC==1 )THEN
  READ(NULRAD,ERR=1001) KAO_D
  KAO = REAL(KAO_D,JPRB)
ENDIF
IF( NPROC>1 )THEN
  CALL MPL_BROADCAST (KAO,MTAGRAD,1,CDSTRING='RRTM_KGB15:')
ENDIF

! Planck fraction mapping level : P = 1053. mb, T = 294.2 K
      FRACREFAO(:, 1) = (/ &
     &  1.0689E-01_JPRB,1.1563E-01_JPRB,1.2447E-01_JPRB,1.2921E-01_JPRB,1.2840E-01_JPRB,1.2113E-01_JPRB, &
     &  1.0643E-01_JPRB,8.4987E-02_JPRB,6.0142E-02_JPRB,6.6798E-03_JPRB,5.5293E-03_JPRB,4.3700E-03_JPRB, &
     &  3.2061E-03_JPRB,2.0476E-03_JPRB,7.7366E-04_JPRB,1.0897E-04_JPRB/)
      FRACREFAO(:, 2) = (/ &
     &  1.0782E-01_JPRB,1.1637E-01_JPRB,1.2290E-01_JPRB,1.2911E-01_JPRB,1.2841E-01_JPRB,1.2113E-01_JPRB, &
     &  1.0643E-01_JPRB,8.4987E-02_JPRB,6.0142E-02_JPRB,6.6798E-03_JPRB,5.5293E-03_JPRB,4.3700E-03_JPRB, &
     &  3.2061E-03_JPRB,2.0476E-03_JPRB,7.7366E-04_JPRB,1.0897E-04_JPRB/)
      FRACREFAO(:, 3) = (/ &
     &  1.0858E-01_JPRB,1.1860E-01_JPRB,1.2237E-01_JPRB,1.2665E-01_JPRB,1.2841E-01_JPRB,1.2111E-01_JPRB, &
     &  1.0642E-01_JPRB,8.4987E-02_JPRB,6.0142E-02_JPRB,6.6798E-03_JPRB,5.5293E-03_JPRB,4.3700E-03_JPRB, &
     &  3.2061E-03_JPRB,2.0476E-03_JPRB,7.7366E-04_JPRB,1.0897E-04_JPRB/)
      FRACREFAO(:, 4) = (/ &
     &  1.1022E-01_JPRB,1.1965E-01_JPRB,1.2334E-01_JPRB,1.2383E-01_JPRB,1.2761E-01_JPRB,1.2109E-01_JPRB, &
     &  1.0642E-01_JPRB,8.4987E-02_JPRB,6.0142E-02_JPRB,6.6798E-03_JPRB,5.5293E-03_JPRB,4.3700E-03_JPRB, &
     &  3.2061E-03_JPRB,2.0476E-03_JPRB,7.7366E-04_JPRB,1.0897E-04_JPRB/)
      FRACREFAO(:, 5) = (/ &
     &  1.1342E-01_JPRB,1.2069E-01_JPRB,1.2360E-01_JPRB,1.2447E-01_JPRB,1.2340E-01_JPRB,1.2020E-01_JPRB, &
     &  1.0639E-01_JPRB,8.4987E-02_JPRB,6.0142E-02_JPRB,6.6798E-03_JPRB,5.5293E-03_JPRB,4.3700E-03_JPRB, &
     &  3.2061E-03_JPRB,2.0476E-03_JPRB,7.7366E-04_JPRB,1.0897E-04_JPRB/)
      FRACREFAO(:, 6) = (/ &
     &  1.1771E-01_JPRB,1.2280E-01_JPRB,1.2177E-01_JPRB,1.2672E-01_JPRB,1.2398E-01_JPRB,1.1787E-01_JPRB, &
     &  1.0131E-01_JPRB,8.4987E-02_JPRB,6.0142E-02_JPRB,6.6798E-03_JPRB,5.5293E-03_JPRB,4.3700E-03_JPRB, &
     &  3.2061E-03_JPRB,2.0476E-03_JPRB,7.7366E-04_JPRB,1.0897E-04_JPRB/)
      FRACREFAO(:, 7) = (/ &
     &  1.2320E-01_JPRB,1.2491E-01_JPRB,1.2001E-01_JPRB,1.2936E-01_JPRB,1.2653E-01_JPRB,1.1929E-01_JPRB, &
     &  9.8955E-02_JPRB,7.4887E-02_JPRB,6.0142E-02_JPRB,6.6798E-03_JPRB,5.5293E-03_JPRB,4.3700E-03_JPRB, &
     &  3.2061E-03_JPRB,2.0476E-03_JPRB,7.7366E-04_JPRB,1.0897E-04_JPRB/)
      FRACREFAO(:, 8) = (/ &
     &  1.3105E-01_JPRB,1.2563E-01_JPRB,1.3055E-01_JPRB,1.2854E-01_JPRB,1.3402E-01_JPRB,1.1571E-01_JPRB, &
     &  9.4876E-02_JPRB,6.0459E-02_JPRB,5.6457E-02_JPRB,6.6798E-03_JPRB,5.5293E-03_JPRB,4.3700E-03_JPRB, &
     &  3.2061E-03_JPRB,2.0476E-03_JPRB,7.7366E-04_JPRB,1.0897E-04_JPRB/)
      FRACREFAO(:, 9) = (/ &
     &  1.1375E-01_JPRB,1.2090E-01_JPRB,1.2348E-01_JPRB,1.2458E-01_JPRB,1.2406E-01_JPRB,1.1921E-01_JPRB, &
     &  1.0802E-01_JPRB,8.6613E-02_JPRB,5.8125E-02_JPRB,6.2984E-03_JPRB,5.2359E-03_JPRB,4.0641E-03_JPRB, &
     &  2.9379E-03_JPRB,1.9001E-03_JPRB,7.2646E-04_JPRB,1.0553E-04_JPRB/)


!     ------------------------------------------------------------------

!     The array KAO contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels> ~100mb, temperatures, and binary
!     species parameters (see taumol.f for definition).  The first 
!     index in the array, JS, runs from 1 to 9, and corresponds to 
!     different values of the binary species parameter.  For instance, 
!     JS=1 refers to dry air, JS = 2 corresponds to the paramter value 1/8, 
!     JS = 3 corresponds to the parameter value 2/8, etc.  The second index
!     in the array, JT, which runs from 1 to 5, corresponds to different
!     temperatures.  More specifically, JT = 3 means that the data are for
!     the reference temperature TREF for this  pressure level, JT = 2 refers
!     to TREF-15, JT = 1 is for TREF-30, JT = 4 is for TREF+15, and JT = 5
!     is for TREF+30.  The third index, JP, runs from 1 to 13 and refers
!     to the JPth reference pressure level (see taumol.f for these levels
!     in mb).  The fourth index, IG, goes from 1 to 16, and indicates
!     which g-interval the absorption coefficients are for.


!     The array KA_Mxx contains the absorption coefficient for 
!     a minor species at the 16 chosen g-values for a reference pressure
!     level below 100~ mb.   The first index in the array, JS, runs
!     from 1 to 10, and corresponds to different gas column amount ratios,
!     as expressed through the binary species parameter eta, defined as
!     eta = gas1/(gas1 + (rat) * gas2), where rat is the 
!     ratio of the reference MLS column amount value of gas 1 
!     to that of gas2.  The second index refers to temperature 
!     in 7.2 degree increments.  For instance, JT = 1 refers to a 
!     temperature of 188.0, JT = 2 refers to 195.2, etc. The third index 
!     runs over the g-channel (1 to 16).

       KAO_MN2( 1, :, 1) = (/ &
     & 3.24352E-08_JPRB, 3.39625E-08_JPRB, 3.55618E-08_JPRB, 3.72364E-08_JPRB, 3.89899E-08_JPRB, &
     & 4.08259E-08_JPRB, 4.27484E-08_JPRB, 4.47614E-08_JPRB, 4.68692E-08_JPRB, 4.90763E-08_JPRB, &
     & 5.13873E-08_JPRB, 5.38071E-08_JPRB, 5.63409E-08_JPRB, 5.89940E-08_JPRB, 6.17720E-08_JPRB, &
     & 6.46808E-08_JPRB, 6.77266E-08_JPRB, 7.09158E-08_JPRB, 7.42553E-08_JPRB/)
       KAO_MN2( 2, :, 1) = (/ &
     & 3.44203E-08_JPRB, 3.60254E-08_JPRB, 3.77053E-08_JPRB, 3.94636E-08_JPRB, 4.13038E-08_JPRB, &
     & 4.32299E-08_JPRB, 4.52458E-08_JPRB, 4.73557E-08_JPRB, 4.95640E-08_JPRB, 5.18753E-08_JPRB, &
     & 5.42943E-08_JPRB, 5.68262E-08_JPRB, 5.94761E-08_JPRB, 6.22496E-08_JPRB, 6.51524E-08_JPRB, &
     & 6.81906E-08_JPRB, 7.13704E-08_JPRB, 7.46986E-08_JPRB, 7.81819E-08_JPRB/)
       KAO_MN2( 3, :, 1) = (/ &
     & 3.44344E-08_JPRB, 3.61485E-08_JPRB, 3.79480E-08_JPRB, 3.98370E-08_JPRB, 4.18201E-08_JPRB, &
     & 4.39019E-08_JPRB, 4.60873E-08_JPRB, 4.83815E-08_JPRB, 5.07899E-08_JPRB, 5.33182E-08_JPRB, &
     & 5.59723E-08_JPRB, 5.87586E-08_JPRB, 6.16836E-08_JPRB, 6.47541E-08_JPRB, 6.79776E-08_JPRB, &
     & 7.13614E-08_JPRB, 7.49138E-08_JPRB, 7.86429E-08_JPRB, 8.25577E-08_JPRB/)
       KAO_MN2( 4, :, 1) = (/ &
     & 4.21102E-08_JPRB, 4.38921E-08_JPRB, 4.57493E-08_JPRB, 4.76852E-08_JPRB, 4.97029E-08_JPRB, &
     & 5.18061E-08_JPRB, 5.39982E-08_JPRB, 5.62831E-08_JPRB, 5.86647E-08_JPRB, 6.11470E-08_JPRB, &
     & 6.37344E-08_JPRB, 6.64313E-08_JPRB, 6.92422E-08_JPRB, 7.21722E-08_JPRB, 7.52261E-08_JPRB, &
     & 7.84092E-08_JPRB, 8.17270E-08_JPRB, 8.51852E-08_JPRB, 8.87897E-08_JPRB/)
       KAO_MN2( 5, :, 1) = (/ &
     & 4.78813E-08_JPRB, 5.01015E-08_JPRB, 5.24246E-08_JPRB, 5.48554E-08_JPRB, 5.73989E-08_JPRB, &
     & 6.00603E-08_JPRB, 6.28452E-08_JPRB, 6.57592E-08_JPRB, 6.88083E-08_JPRB, 7.19987E-08_JPRB, &
     & 7.53371E-08_JPRB, 7.88304E-08_JPRB, 8.24855E-08_JPRB, 8.63102E-08_JPRB, 9.03122E-08_JPRB, &
     & 9.44997E-08_JPRB, 9.88815E-08_JPRB, 1.03466E-07_JPRB, 1.08264E-07_JPRB/)
       KAO_MN2( 6, :, 1) = (/ &
     & 7.03115E-08_JPRB, 7.27877E-08_JPRB, 7.53511E-08_JPRB, 7.80048E-08_JPRB, 8.07519E-08_JPRB, &
     & 8.35958E-08_JPRB, 8.65398E-08_JPRB, 8.95875E-08_JPRB, 9.27426E-08_JPRB, 9.60087E-08_JPRB, &
     & 9.93899E-08_JPRB, 1.02890E-07_JPRB, 1.06514E-07_JPRB, 1.10265E-07_JPRB, 1.14148E-07_JPRB, &
     & 1.18168E-07_JPRB, 1.22330E-07_JPRB, 1.26638E-07_JPRB, 1.31098E-07_JPRB/)
       KAO_MN2( 7, :, 1) = (/ &
     & 8.86454E-08_JPRB, 9.20065E-08_JPRB, 9.54951E-08_JPRB, 9.91159E-08_JPRB, 1.02874E-07_JPRB, &
     & 1.06775E-07_JPRB, 1.10823E-07_JPRB, 1.15025E-07_JPRB, 1.19387E-07_JPRB, 1.23913E-07_JPRB, &
     & 1.28612E-07_JPRB, 1.33488E-07_JPRB, 1.38550E-07_JPRB, 1.43803E-07_JPRB, 1.49255E-07_JPRB, &
     & 1.54915E-07_JPRB, 1.60788E-07_JPRB, 1.66885E-07_JPRB, 1.73213E-07_JPRB/)
       KAO_MN2( 8, :, 1) = (/ &
     & 1.34118E-07_JPRB, 1.38267E-07_JPRB, 1.42545E-07_JPRB, 1.46955E-07_JPRB, 1.51502E-07_JPRB, &
     & 1.56189E-07_JPRB, 1.61022E-07_JPRB, 1.66004E-07_JPRB, 1.71140E-07_JPRB, 1.76435E-07_JPRB, &
     & 1.81893E-07_JPRB, 1.87521E-07_JPRB, 1.93323E-07_JPRB, 1.99304E-07_JPRB, 2.05470E-07_JPRB, &
     & 2.11827E-07_JPRB, 2.18381E-07_JPRB, 2.25138E-07_JPRB, 2.32103E-07_JPRB/)
       KAO_MN2( 9, :, 1) = (/ &
     & 5.08256E-08_JPRB, 5.30384E-08_JPRB, 5.53476E-08_JPRB, 5.77573E-08_JPRB, 6.02718E-08_JPRB, &
     & 6.28959E-08_JPRB, 6.56342E-08_JPRB, 6.84917E-08_JPRB, 7.14737E-08_JPRB, 7.45854E-08_JPRB, &
     & 7.78327E-08_JPRB, 8.12213E-08_JPRB, 8.47574E-08_JPRB, 8.84475E-08_JPRB, 9.22983E-08_JPRB, &
     & 9.63167E-08_JPRB, 1.00510E-07_JPRB, 1.04886E-07_JPRB, 1.09452E-07_JPRB/)
       KAO_MN2( 1, :, 2) = (/ &
     & 8.23958E-08_JPRB, 8.39092E-08_JPRB, 8.54504E-08_JPRB, 8.70200E-08_JPRB, 8.86183E-08_JPRB, &
     & 9.02460E-08_JPRB, 9.19036E-08_JPRB, 9.35917E-08_JPRB, 9.53107E-08_JPRB, 9.70614E-08_JPRB, &
     & 9.88442E-08_JPRB, 1.00660E-07_JPRB, 1.02509E-07_JPRB, 1.04391E-07_JPRB, 1.06309E-07_JPRB, &
     & 1.08261E-07_JPRB, 1.10250E-07_JPRB, 1.12275E-07_JPRB, 1.14337E-07_JPRB/)
       KAO_MN2( 2, :, 2) = (/ &
     & 8.52335E-08_JPRB, 8.69254E-08_JPRB, 8.86509E-08_JPRB, 9.04107E-08_JPRB, 9.22054E-08_JPRB, &
     & 9.40357E-08_JPRB, 9.59024E-08_JPRB, 9.78061E-08_JPRB, 9.97476E-08_JPRB, 1.01728E-07_JPRB, &
     & 1.03747E-07_JPRB, 1.05806E-07_JPRB, 1.07907E-07_JPRB, 1.10049E-07_JPRB, 1.12233E-07_JPRB, &
     & 1.14461E-07_JPRB, 1.16733E-07_JPRB, 1.19050E-07_JPRB, 1.21414E-07_JPRB/)
       KAO_MN2( 3, :, 2) = (/ &
     & 1.04608E-07_JPRB, 1.06067E-07_JPRB, 1.07546E-07_JPRB, 1.09046E-07_JPRB, 1.10567E-07_JPRB, &
     & 1.12110E-07_JPRB, 1.13673E-07_JPRB, 1.15259E-07_JPRB, 1.16866E-07_JPRB, 1.18496E-07_JPRB, &
     & 1.20149E-07_JPRB, 1.21825E-07_JPRB, 1.23524E-07_JPRB, 1.25247E-07_JPRB, 1.26994E-07_JPRB, &
     & 1.28765E-07_JPRB, 1.30561E-07_JPRB, 1.32382E-07_JPRB, 1.34229E-07_JPRB/)
       KAO_MN2( 4, :, 2) = (/ &
     & 1.17504E-07_JPRB, 1.18763E-07_JPRB, 1.20036E-07_JPRB, 1.21322E-07_JPRB, 1.22622E-07_JPRB, &
     & 1.23936E-07_JPRB, 1.25265E-07_JPRB, 1.26607E-07_JPRB, 1.27964E-07_JPRB, 1.29335E-07_JPRB, &
     & 1.30721E-07_JPRB, 1.32122E-07_JPRB, 1.33538E-07_JPRB, 1.34969E-07_JPRB, 1.36415E-07_JPRB, &
     & 1.37877E-07_JPRB, 1.39354E-07_JPRB, 1.40848E-07_JPRB, 1.42357E-07_JPRB/)
       KAO_MN2( 5, :, 2) = (/ &
     & 1.23552E-07_JPRB, 1.25200E-07_JPRB, 1.26870E-07_JPRB, 1.28562E-07_JPRB, 1.30277E-07_JPRB, &
     & 1.32015E-07_JPRB, 1.33776E-07_JPRB, 1.35560E-07_JPRB, 1.37368E-07_JPRB, 1.39200E-07_JPRB, &
     & 1.41057E-07_JPRB, 1.42938E-07_JPRB, 1.44845E-07_JPRB, 1.46777E-07_JPRB, 1.48735E-07_JPRB, &
     & 1.50718E-07_JPRB, 1.52729E-07_JPRB, 1.54766E-07_JPRB, 1.56830E-07_JPRB/)
       KAO_MN2( 6, :, 2) = (/ &
     & 1.29682E-07_JPRB, 1.32226E-07_JPRB, 1.34820E-07_JPRB, 1.37464E-07_JPRB, 1.40161E-07_JPRB, &
     & 1.42910E-07_JPRB, 1.45713E-07_JPRB, 1.48571E-07_JPRB, 1.51486E-07_JPRB, 1.54457E-07_JPRB, &
     & 1.57487E-07_JPRB, 1.60576E-07_JPRB, 1.63726E-07_JPRB, 1.66937E-07_JPRB, 1.70212E-07_JPRB, &
     & 1.73551E-07_JPRB, 1.76955E-07_JPRB, 1.80426E-07_JPRB, 1.83965E-07_JPRB/)
       KAO_MN2( 7, :, 2) = (/ &
     & 1.77416E-07_JPRB, 1.78627E-07_JPRB, 1.79846E-07_JPRB, 1.81073E-07_JPRB, 1.82309E-07_JPRB, &
     & 1.83554E-07_JPRB, 1.84806E-07_JPRB, 1.86068E-07_JPRB, 1.87338E-07_JPRB, 1.88616E-07_JPRB, &
     & 1.89904E-07_JPRB, 1.91200E-07_JPRB, 1.92505E-07_JPRB, 1.93819E-07_JPRB, 1.95142E-07_JPRB, &
     & 1.96474E-07_JPRB, 1.97815E-07_JPRB, 1.99165E-07_JPRB, 2.00524E-07_JPRB/)
       KAO_MN2( 8, :, 2) = (/ &
     & 2.20695E-07_JPRB, 2.20451E-07_JPRB, 2.20208E-07_JPRB, 2.19965E-07_JPRB, 2.19722E-07_JPRB, &
     & 2.19480E-07_JPRB, 2.19238E-07_JPRB, 2.18996E-07_JPRB, 2.18754E-07_JPRB, 2.18513E-07_JPRB, &
     & 2.18272E-07_JPRB, 2.18031E-07_JPRB, 2.17790E-07_JPRB, 2.17550E-07_JPRB, 2.17310E-07_JPRB, &
     & 2.17070E-07_JPRB, 2.16831E-07_JPRB, 2.16591E-07_JPRB, 2.16352E-07_JPRB/)
       KAO_MN2( 9, :, 2) = (/ &
     & 1.23015E-07_JPRB, 1.24808E-07_JPRB, 1.26626E-07_JPRB, 1.28471E-07_JPRB, 1.30343E-07_JPRB, &
     & 1.32242E-07_JPRB, 1.34168E-07_JPRB, 1.36123E-07_JPRB, 1.38106E-07_JPRB, 1.40118E-07_JPRB, &
     & 1.42160E-07_JPRB, 1.44231E-07_JPRB, 1.46332E-07_JPRB, 1.48464E-07_JPRB, 1.50627E-07_JPRB, &
     & 1.52822E-07_JPRB, 1.55048E-07_JPRB, 1.57307E-07_JPRB, 1.59599E-07_JPRB/)
       KAO_MN2( 1, :, 3) = (/ &
     & 1.87585E-07_JPRB, 1.89503E-07_JPRB, 1.91440E-07_JPRB, 1.93398E-07_JPRB, 1.95375E-07_JPRB, &
     & 1.97372E-07_JPRB, 1.99390E-07_JPRB, 2.01429E-07_JPRB, 2.03488E-07_JPRB, 2.05568E-07_JPRB, &
     & 2.07670E-07_JPRB, 2.09793E-07_JPRB, 2.11938E-07_JPRB, 2.14105E-07_JPRB, 2.16294E-07_JPRB, &
     & 2.18505E-07_JPRB, 2.20739E-07_JPRB, 2.22996E-07_JPRB, 2.25275E-07_JPRB/)
       KAO_MN2( 2, :, 3) = (/ &
     & 1.82585E-07_JPRB, 1.84249E-07_JPRB, 1.85929E-07_JPRB, 1.87624E-07_JPRB, 1.89335E-07_JPRB, &
     & 1.91061E-07_JPRB, 1.92803E-07_JPRB, 1.94561E-07_JPRB, 1.96335E-07_JPRB, 1.98125E-07_JPRB, &
     & 1.99932E-07_JPRB, 2.01755E-07_JPRB, 2.03594E-07_JPRB, 2.05451E-07_JPRB, 2.07324E-07_JPRB, &
     & 2.09214E-07_JPRB, 2.11122E-07_JPRB, 2.13047E-07_JPRB, 2.14989E-07_JPRB/)
       KAO_MN2( 3, :, 3) = (/ &
     & 1.64711E-07_JPRB, 1.67539E-07_JPRB, 1.70417E-07_JPRB, 1.73343E-07_JPRB, 1.76321E-07_JPRB, &
     & 1.79349E-07_JPRB, 1.82429E-07_JPRB, 1.85562E-07_JPRB, 1.88749E-07_JPRB, 1.91990E-07_JPRB, &
     & 1.95288E-07_JPRB, 1.98642E-07_JPRB, 2.02053E-07_JPRB, 2.05523E-07_JPRB, 2.09053E-07_JPRB, &
     & 2.12643E-07_JPRB, 2.16295E-07_JPRB, 2.20010E-07_JPRB, 2.23788E-07_JPRB/)
       KAO_MN2( 4, :, 3) = (/ &
     & 1.67494E-07_JPRB, 1.71011E-07_JPRB, 1.74601E-07_JPRB, 1.78267E-07_JPRB, 1.82009E-07_JPRB, &
     & 1.85831E-07_JPRB, 1.89732E-07_JPRB, 1.93715E-07_JPRB, 1.97782E-07_JPRB, 2.01935E-07_JPRB, &
     & 2.06174E-07_JPRB, 2.10503E-07_JPRB, 2.14922E-07_JPRB, 2.19434E-07_JPRB, 2.24041E-07_JPRB, &
     & 2.28745E-07_JPRB, 2.33548E-07_JPRB, 2.38451E-07_JPRB, 2.43457E-07_JPRB/)
       KAO_MN2( 5, :, 3) = (/ &
     & 1.97399E-07_JPRB, 2.00092E-07_JPRB, 2.02821E-07_JPRB, 2.05588E-07_JPRB, 2.08393E-07_JPRB, &
     & 2.11236E-07_JPRB, 2.14118E-07_JPRB, 2.17039E-07_JPRB, 2.20000E-07_JPRB, 2.23001E-07_JPRB, &
     & 2.26043E-07_JPRB, 2.29127E-07_JPRB, 2.32252E-07_JPRB, 2.35421E-07_JPRB, 2.38633E-07_JPRB, &
     & 2.41888E-07_JPRB, 2.45188E-07_JPRB, 2.48533E-07_JPRB, 2.51923E-07_JPRB/)
       KAO_MN2( 6, :, 3) = (/ &
     & 2.24021E-07_JPRB, 2.24970E-07_JPRB, 2.25923E-07_JPRB, 2.26880E-07_JPRB, 2.27840E-07_JPRB, &
     & 2.28805E-07_JPRB, 2.29774E-07_JPRB, 2.30747E-07_JPRB, 2.31725E-07_JPRB, 2.32706E-07_JPRB, &
     & 2.33692E-07_JPRB, 2.34681E-07_JPRB, 2.35675E-07_JPRB, 2.36673E-07_JPRB, 2.37675E-07_JPRB, &
     & 2.38682E-07_JPRB, 2.39693E-07_JPRB, 2.40708E-07_JPRB, 2.41727E-07_JPRB/)
       KAO_MN2( 7, :, 3) = (/ &
     & 1.98178E-07_JPRB, 2.00676E-07_JPRB, 2.03205E-07_JPRB, 2.05766E-07_JPRB, 2.08359E-07_JPRB, &
     & 2.10986E-07_JPRB, 2.13645E-07_JPRB, 2.16337E-07_JPRB, 2.19064E-07_JPRB, 2.21825E-07_JPRB, &
     & 2.24621E-07_JPRB, 2.27452E-07_JPRB, 2.30319E-07_JPRB, 2.33222E-07_JPRB, 2.36161E-07_JPRB, &
     & 2.39138E-07_JPRB, 2.42152E-07_JPRB, 2.45204E-07_JPRB, 2.48294E-07_JPRB/)
       KAO_MN2( 8, :, 3) = (/ &
     & 2.83042E-07_JPRB, 2.89941E-07_JPRB, 2.97009E-07_JPRB, 3.04250E-07_JPRB, 3.11666E-07_JPRB, &
     & 3.19264E-07_JPRB, 3.27047E-07_JPRB, 3.35019E-07_JPRB, 3.43186E-07_JPRB, 3.51552E-07_JPRB, &
     & 3.60122E-07_JPRB, 3.68901E-07_JPRB, 3.77893E-07_JPRB, 3.87105E-07_JPRB, 3.96542E-07_JPRB, &
     & 4.06208E-07_JPRB, 4.16111E-07_JPRB, 4.26254E-07_JPRB, 4.36645E-07_JPRB/)
       KAO_MN2( 9, :, 3) = (/ &
     & 1.98963E-07_JPRB, 2.01576E-07_JPRB, 2.04224E-07_JPRB, 2.06907E-07_JPRB, 2.09626E-07_JPRB, &
     & 2.12379E-07_JPRB, 2.15169E-07_JPRB, 2.17996E-07_JPRB, 2.20860E-07_JPRB, 2.23761E-07_JPRB, &
     & 2.26701E-07_JPRB, 2.29679E-07_JPRB, 2.32696E-07_JPRB, 2.35753E-07_JPRB, 2.38851E-07_JPRB, &
     & 2.41988E-07_JPRB, 2.45167E-07_JPRB, 2.48388E-07_JPRB, 2.51651E-07_JPRB/)
       KAO_MN2( 1, :, 4) = (/ &
     & 3.75434E-07_JPRB, 3.79581E-07_JPRB, 3.83775E-07_JPRB, 3.88014E-07_JPRB, 3.92301E-07_JPRB, &
     & 3.96634E-07_JPRB, 4.01016E-07_JPRB, 4.05446E-07_JPRB, 4.09925E-07_JPRB, 4.14453E-07_JPRB, &
     & 4.19032E-07_JPRB, 4.23661E-07_JPRB, 4.28341E-07_JPRB, 4.33073E-07_JPRB, 4.37857E-07_JPRB, &
     & 4.42694E-07_JPRB, 4.47585E-07_JPRB, 4.52529E-07_JPRB, 4.57528E-07_JPRB/)
       KAO_MN2( 2, :, 4) = (/ &
     & 3.76756E-07_JPRB, 3.80760E-07_JPRB, 3.84805E-07_JPRB, 3.88894E-07_JPRB, 3.93027E-07_JPRB, &
     & 3.97203E-07_JPRB, 4.01423E-07_JPRB, 4.05689E-07_JPRB, 4.10000E-07_JPRB, 4.14356E-07_JPRB, &
     & 4.18759E-07_JPRB, 4.23209E-07_JPRB, 4.27706E-07_JPRB, 4.32250E-07_JPRB, 4.36843E-07_JPRB, &
     & 4.41485E-07_JPRB, 4.46176E-07_JPRB, 4.50917E-07_JPRB, 4.55708E-07_JPRB/)
       KAO_MN2( 3, :, 4) = (/ &
     & 3.76258E-07_JPRB, 3.78929E-07_JPRB, 3.81619E-07_JPRB, 3.84329E-07_JPRB, 3.87057E-07_JPRB, &
     & 3.89805E-07_JPRB, 3.92572E-07_JPRB, 3.95359E-07_JPRB, 3.98166E-07_JPRB, 4.00993E-07_JPRB, &
     & 4.03839E-07_JPRB, 4.06706E-07_JPRB, 4.09594E-07_JPRB, 4.12502E-07_JPRB, 4.15430E-07_JPRB, &
     & 4.18379E-07_JPRB, 4.21349E-07_JPRB, 4.24341E-07_JPRB, 4.27353E-07_JPRB/)
       KAO_MN2( 4, :, 4) = (/ &
     & 3.17796E-07_JPRB, 3.22447E-07_JPRB, 3.27166E-07_JPRB, 3.31954E-07_JPRB, 3.36812E-07_JPRB, &
     & 3.41742E-07_JPRB, 3.46743E-07_JPRB, 3.51818E-07_JPRB, 3.56967E-07_JPRB, 3.62191E-07_JPRB, &
     & 3.67492E-07_JPRB, 3.72870E-07_JPRB, 3.78328E-07_JPRB, 3.83865E-07_JPRB, 3.89483E-07_JPRB, &
     & 3.95183E-07_JPRB, 4.00967E-07_JPRB, 4.06835E-07_JPRB, 4.12789E-07_JPRB/)
       KAO_MN2( 5, :, 4) = (/ &
     & 3.33793E-07_JPRB, 3.38941E-07_JPRB, 3.44169E-07_JPRB, 3.49478E-07_JPRB, 3.54868E-07_JPRB, &
     & 3.60342E-07_JPRB, 3.65900E-07_JPRB, 3.71544E-07_JPRB, 3.77275E-07_JPRB, 3.83094E-07_JPRB, &
     & 3.89003E-07_JPRB, 3.95003E-07_JPRB, 4.01096E-07_JPRB, 4.07283E-07_JPRB, 4.13565E-07_JPRB, &
     & 4.19944E-07_JPRB, 4.26421E-07_JPRB, 4.32999E-07_JPRB, 4.39677E-07_JPRB/)
       KAO_MN2( 6, :, 4) = (/ &
     & 3.60052E-07_JPRB, 3.66686E-07_JPRB, 3.73442E-07_JPRB, 3.80323E-07_JPRB, 3.87330E-07_JPRB, &
     & 3.94466E-07_JPRB, 4.01734E-07_JPRB, 4.09136E-07_JPRB, 4.16674E-07_JPRB, 4.24351E-07_JPRB, &
     & 4.32169E-07_JPRB, 4.40132E-07_JPRB, 4.48241E-07_JPRB, 4.56500E-07_JPRB, 4.64910E-07_JPRB, &
     & 4.73476E-07_JPRB, 4.82200E-07_JPRB, 4.91084E-07_JPRB, 5.00132E-07_JPRB/)
       KAO_MN2( 7, :, 4) = (/ &
     & 4.14713E-07_JPRB, 4.21885E-07_JPRB, 4.29181E-07_JPRB, 4.36603E-07_JPRB, 4.44153E-07_JPRB, &
     & 4.51834E-07_JPRB, 4.59648E-07_JPRB, 4.67598E-07_JPRB, 4.75684E-07_JPRB, 4.83910E-07_JPRB, &
     & 4.92279E-07_JPRB, 5.00793E-07_JPRB, 5.09453E-07_JPRB, 5.18264E-07_JPRB, 5.27226E-07_JPRB, &
     & 5.36344E-07_JPRB, 5.45620E-07_JPRB, 5.55055E-07_JPRB, 5.64654E-07_JPRB/)
       KAO_MN2( 8, :, 4) = (/ &
     & 4.15352E-07_JPRB, 4.24386E-07_JPRB, 4.33617E-07_JPRB, 4.43049E-07_JPRB, 4.52685E-07_JPRB, &
     & 4.62532E-07_JPRB, 4.72592E-07_JPRB, 4.82872E-07_JPRB, 4.93374E-07_JPRB, 5.04106E-07_JPRB, &
     & 5.15071E-07_JPRB, 5.26274E-07_JPRB, 5.37721E-07_JPRB, 5.49417E-07_JPRB, 5.61367E-07_JPRB, &
     & 5.73577E-07_JPRB, 5.86053E-07_JPRB, 5.98800E-07_JPRB, 6.11825E-07_JPRB/)
       KAO_MN2( 9, :, 4) = (/ &
     & 3.33820E-07_JPRB, 3.39144E-07_JPRB, 3.44553E-07_JPRB, 3.50048E-07_JPRB, 3.55631E-07_JPRB, &
     & 3.61302E-07_JPRB, 3.67065E-07_JPRB, 3.72919E-07_JPRB, 3.78866E-07_JPRB, 3.84908E-07_JPRB, &
     & 3.91047E-07_JPRB, 3.97284E-07_JPRB, 4.03620E-07_JPRB, 4.10057E-07_JPRB, 4.16597E-07_JPRB, &
     & 4.23241E-07_JPRB, 4.29991E-07_JPRB, 4.36849E-07_JPRB, 4.43816E-07_JPRB/)
       KAO_MN2( 1, :, 5) = (/ &
     & 6.99819E-07_JPRB, 7.04629E-07_JPRB, 7.09472E-07_JPRB, 7.14349E-07_JPRB, 7.19258E-07_JPRB, &
     & 7.24202E-07_JPRB, 7.29180E-07_JPRB, 7.34192E-07_JPRB, 7.39238E-07_JPRB, 7.44319E-07_JPRB, &
     & 7.49435E-07_JPRB, 7.54586E-07_JPRB, 7.59773E-07_JPRB, 7.64995E-07_JPRB, 7.70253E-07_JPRB, &
     & 7.75547E-07_JPRB, 7.80877E-07_JPRB, 7.86245E-07_JPRB, 7.91649E-07_JPRB/)
       KAO_MN2( 2, :, 5) = (/ &
     & 6.98257E-07_JPRB, 7.03182E-07_JPRB, 7.08143E-07_JPRB, 7.13138E-07_JPRB, 7.18169E-07_JPRB, &
     & 7.23235E-07_JPRB, 7.28336E-07_JPRB, 7.33474E-07_JPRB, 7.38648E-07_JPRB, 7.43858E-07_JPRB, &
     & 7.49106E-07_JPRB, 7.54390E-07_JPRB, 7.59711E-07_JPRB, 7.65071E-07_JPRB, 7.70467E-07_JPRB, &
     & 7.75902E-07_JPRB, 7.81376E-07_JPRB, 7.86887E-07_JPRB, 7.92438E-07_JPRB/)
       KAO_MN2( 3, :, 5) = (/ &
     & 6.98531E-07_JPRB, 7.03429E-07_JPRB, 7.08361E-07_JPRB, 7.13328E-07_JPRB, 7.18329E-07_JPRB, &
     & 7.23365E-07_JPRB, 7.28437E-07_JPRB, 7.33545E-07_JPRB, 7.38688E-07_JPRB, 7.43867E-07_JPRB, &
     & 7.49082E-07_JPRB, 7.54335E-07_JPRB, 7.59623E-07_JPRB, 7.64950E-07_JPRB, 7.70313E-07_JPRB, &
     & 7.75714E-07_JPRB, 7.81153E-07_JPRB, 7.86630E-07_JPRB, 7.92145E-07_JPRB/)
       KAO_MN2( 4, :, 5) = (/ &
     & 7.37210E-07_JPRB, 7.38869E-07_JPRB, 7.40532E-07_JPRB, 7.42198E-07_JPRB, 7.43868E-07_JPRB, &
     & 7.45542E-07_JPRB, 7.47219E-07_JPRB, 7.48901E-07_JPRB, 7.50586E-07_JPRB, 7.52275E-07_JPRB, &
     & 7.53967E-07_JPRB, 7.55664E-07_JPRB, 7.57364E-07_JPRB, 7.59068E-07_JPRB, 7.60777E-07_JPRB, &
     & 7.62488E-07_JPRB, 7.64204E-07_JPRB, 7.65924E-07_JPRB, 7.67647E-07_JPRB/)
       KAO_MN2( 5, :, 5) = (/ &
     & 6.07063E-07_JPRB, 6.12893E-07_JPRB, 6.18779E-07_JPRB, 6.24722E-07_JPRB, 6.30721E-07_JPRB, &
     & 6.36778E-07_JPRB, 6.42893E-07_JPRB, 6.49067E-07_JPRB, 6.55301E-07_JPRB, 6.61594E-07_JPRB, &
     & 6.67947E-07_JPRB, 6.74362E-07_JPRB, 6.80838E-07_JPRB, 6.87376E-07_JPRB, 6.93978E-07_JPRB, &
     & 7.00642E-07_JPRB, 7.07371E-07_JPRB, 7.14164E-07_JPRB, 7.21022E-07_JPRB/)
       KAO_MN2( 6, :, 5) = (/ &
     & 6.13354E-07_JPRB, 6.20147E-07_JPRB, 6.27016E-07_JPRB, 6.33961E-07_JPRB, 6.40983E-07_JPRB, &
     & 6.48082E-07_JPRB, 6.55260E-07_JPRB, 6.62518E-07_JPRB, 6.69856E-07_JPRB, 6.77276E-07_JPRB, &
     & 6.84777E-07_JPRB, 6.92362E-07_JPRB, 7.00030E-07_JPRB, 7.07784E-07_JPRB, 7.15624E-07_JPRB, &
     & 7.23550E-07_JPRB, 7.31564E-07_JPRB, 7.39667E-07_JPRB, 7.47859E-07_JPRB/)
       KAO_MN2( 7, :, 5) = (/ &
     & 6.86666E-07_JPRB, 6.92902E-07_JPRB, 6.99195E-07_JPRB, 7.05545E-07_JPRB, 7.11952E-07_JPRB, &
     & 7.18418E-07_JPRB, 7.24943E-07_JPRB, 7.31526E-07_JPRB, 7.38170E-07_JPRB, 7.44874E-07_JPRB, &
     & 7.51639E-07_JPRB, 7.58465E-07_JPRB, 7.65353E-07_JPRB, 7.72304E-07_JPRB, 7.79318E-07_JPRB, &
     & 7.86395E-07_JPRB, 7.93537E-07_JPRB, 8.00744E-07_JPRB, 8.08016E-07_JPRB/)
       KAO_MN2( 8, :, 5) = (/ &
     & 9.39664E-07_JPRB, 9.39765E-07_JPRB, 9.39866E-07_JPRB, 9.39966E-07_JPRB, 9.40067E-07_JPRB, &
     & 9.40168E-07_JPRB, 9.40268E-07_JPRB, 9.40369E-07_JPRB, 9.40470E-07_JPRB, 9.40571E-07_JPRB, &
     & 9.40671E-07_JPRB, 9.40772E-07_JPRB, 9.40873E-07_JPRB, 9.40974E-07_JPRB, 9.41074E-07_JPRB, &
     & 9.41175E-07_JPRB, 9.41276E-07_JPRB, 9.41377E-07_JPRB, 9.41478E-07_JPRB/)
       KAO_MN2( 9, :, 5) = (/ &
     & 6.02847E-07_JPRB, 6.09726E-07_JPRB, 6.16684E-07_JPRB, 6.23722E-07_JPRB, 6.30839E-07_JPRB, &
     & 6.38038E-07_JPRB, 6.45320E-07_JPRB, 6.52684E-07_JPRB, 6.60132E-07_JPRB, 6.67665E-07_JPRB, &
     & 6.75284E-07_JPRB, 6.82991E-07_JPRB, 6.90785E-07_JPRB, 6.98668E-07_JPRB, 7.06641E-07_JPRB, &
     & 7.14705E-07_JPRB, 7.22861E-07_JPRB, 7.31110E-07_JPRB, 7.39453E-07_JPRB/)
       KAO_MN2( 1, :, 6) = (/ &
     & 1.13692E-06_JPRB, 1.13231E-06_JPRB, 1.12772E-06_JPRB, 1.12315E-06_JPRB, 1.11859E-06_JPRB, &
     & 1.11406E-06_JPRB, 1.10954E-06_JPRB, 1.10505E-06_JPRB, 1.10057E-06_JPRB, 1.09610E-06_JPRB, &
     & 1.09166E-06_JPRB, 1.08724E-06_JPRB, 1.08283E-06_JPRB, 1.07844E-06_JPRB, 1.07407E-06_JPRB, &
     & 1.06971E-06_JPRB, 1.06538E-06_JPRB, 1.06106E-06_JPRB, 1.05676E-06_JPRB/)
       KAO_MN2( 2, :, 6) = (/ &
     & 1.13682E-06_JPRB, 1.13221E-06_JPRB, 1.12762E-06_JPRB, 1.12305E-06_JPRB, 1.11849E-06_JPRB, &
     & 1.11396E-06_JPRB, 1.10944E-06_JPRB, 1.10495E-06_JPRB, 1.10047E-06_JPRB, 1.09600E-06_JPRB, &
     & 1.09156E-06_JPRB, 1.08714E-06_JPRB, 1.08273E-06_JPRB, 1.07834E-06_JPRB, 1.07397E-06_JPRB, &
     & 1.06961E-06_JPRB, 1.06528E-06_JPRB, 1.06096E-06_JPRB, 1.05666E-06_JPRB/)
       KAO_MN2( 3, :, 6) = (/ &
     & 1.13642E-06_JPRB, 1.13181E-06_JPRB, 1.12722E-06_JPRB, 1.12265E-06_JPRB, 1.11809E-06_JPRB, &
     & 1.11356E-06_JPRB, 1.10904E-06_JPRB, 1.10455E-06_JPRB, 1.10007E-06_JPRB, 1.09560E-06_JPRB, &
     & 1.09116E-06_JPRB, 1.08674E-06_JPRB, 1.08233E-06_JPRB, 1.07794E-06_JPRB, 1.07357E-06_JPRB, &
     & 1.06921E-06_JPRB, 1.06488E-06_JPRB, 1.06056E-06_JPRB, 1.05626E-06_JPRB/)
       KAO_MN2( 4, :, 6) = (/ &
     & 1.13626E-06_JPRB, 1.13160E-06_JPRB, 1.12696E-06_JPRB, 1.12233E-06_JPRB, 1.11773E-06_JPRB, &
     & 1.11314E-06_JPRB, 1.10858E-06_JPRB, 1.10403E-06_JPRB, 1.09950E-06_JPRB, 1.09498E-06_JPRB, &
     & 1.09049E-06_JPRB, 1.08602E-06_JPRB, 1.08156E-06_JPRB, 1.07712E-06_JPRB, 1.07270E-06_JPRB, &
     & 1.06830E-06_JPRB, 1.06392E-06_JPRB, 1.05955E-06_JPRB, 1.05520E-06_JPRB/)
       KAO_MN2( 5, :, 6) = (/ &
     & 1.22429E-06_JPRB, 1.21163E-06_JPRB, 1.19909E-06_JPRB, 1.18669E-06_JPRB, 1.17441E-06_JPRB, &
     & 1.16226E-06_JPRB, 1.15024E-06_JPRB, 1.13834E-06_JPRB, 1.12656E-06_JPRB, 1.11491E-06_JPRB, &
     & 1.10338E-06_JPRB, 1.09196E-06_JPRB, 1.08067E-06_JPRB, 1.06949E-06_JPRB, 1.05842E-06_JPRB, &
     & 1.04747E-06_JPRB, 1.03664E-06_JPRB, 1.02591E-06_JPRB, 1.01530E-06_JPRB/)
       KAO_MN2( 6, :, 6) = (/ &
     & 1.02400E-06_JPRB, 1.02238E-06_JPRB, 1.02077E-06_JPRB, 1.01916E-06_JPRB, 1.01755E-06_JPRB, &
     & 1.01594E-06_JPRB, 1.01433E-06_JPRB, 1.01273E-06_JPRB, 1.01113E-06_JPRB, 1.00953E-06_JPRB, &
     & 1.00794E-06_JPRB, 1.00635E-06_JPRB, 1.00476E-06_JPRB, 1.00317E-06_JPRB, 1.00159E-06_JPRB, &
     & 1.00000E-06_JPRB, 9.98425E-07_JPRB, 9.96848E-07_JPRB, 9.95273E-07_JPRB/)
       KAO_MN2( 7, :, 6) = (/ &
     & 1.08594E-06_JPRB, 1.08185E-06_JPRB, 1.07778E-06_JPRB, 1.07373E-06_JPRB, 1.06969E-06_JPRB, &
     & 1.06566E-06_JPRB, 1.06165E-06_JPRB, 1.05766E-06_JPRB, 1.05368E-06_JPRB, 1.04971E-06_JPRB, &
     & 1.04576E-06_JPRB, 1.04183E-06_JPRB, 1.03791E-06_JPRB, 1.03400E-06_JPRB, 1.03011E-06_JPRB, &
     & 1.02623E-06_JPRB, 1.02237E-06_JPRB, 1.01852E-06_JPRB, 1.01469E-06_JPRB/)
       KAO_MN2( 8, :, 6) = (/ &
     & 1.25029E-06_JPRB, 1.22508E-06_JPRB, 1.20038E-06_JPRB, 1.17618E-06_JPRB, 1.15247E-06_JPRB, &
     & 1.12924E-06_JPRB, 1.10647E-06_JPRB, 1.08416E-06_JPRB, 1.06231E-06_JPRB, 1.04089E-06_JPRB, &
     & 1.01990E-06_JPRB, 9.99343E-07_JPRB, 9.79196E-07_JPRB, 9.59454E-07_JPRB, 9.40111E-07_JPRB, &
     & 9.21158E-07_JPRB, 9.02587E-07_JPRB, 8.84390E-07_JPRB, 8.66560E-07_JPRB/)
       KAO_MN2( 9, :, 6) = (/ &
     & 1.21299E-06_JPRB, 1.19953E-06_JPRB, 1.18622E-06_JPRB, 1.17305E-06_JPRB, 1.16003E-06_JPRB, &
     & 1.14716E-06_JPRB, 1.13443E-06_JPRB, 1.12184E-06_JPRB, 1.10939E-06_JPRB, 1.09708E-06_JPRB, &
     & 1.08491E-06_JPRB, 1.07287E-06_JPRB, 1.06096E-06_JPRB, 1.04919E-06_JPRB, 1.03755E-06_JPRB, &
     & 1.02603E-06_JPRB, 1.01465E-06_JPRB, 1.00339E-06_JPRB, 9.92253E-07_JPRB/)
       KAO_MN2( 1, :, 7) = (/ &
     & 1.53893E-06_JPRB, 1.51743E-06_JPRB, 1.49623E-06_JPRB, 1.47532E-06_JPRB, 1.45471E-06_JPRB, &
     & 1.43438E-06_JPRB, 1.41434E-06_JPRB, 1.39458E-06_JPRB, 1.37509E-06_JPRB, 1.35588E-06_JPRB, &
     & 1.33694E-06_JPRB, 1.31826E-06_JPRB, 1.29984E-06_JPRB, 1.28167E-06_JPRB, 1.26377E-06_JPRB, &
     & 1.24611E-06_JPRB, 1.22870E-06_JPRB, 1.21153E-06_JPRB, 1.19460E-06_JPRB/)
       KAO_MN2( 2, :, 7) = (/ &
     & 1.53809E-06_JPRB, 1.51665E-06_JPRB, 1.49552E-06_JPRB, 1.47467E-06_JPRB, 1.45412E-06_JPRB, &
     & 1.43386E-06_JPRB, 1.41388E-06_JPRB, 1.39418E-06_JPRB, 1.37475E-06_JPRB, 1.35559E-06_JPRB, &
     & 1.33670E-06_JPRB, 1.31807E-06_JPRB, 1.29970E-06_JPRB, 1.28159E-06_JPRB, 1.26373E-06_JPRB, &
     & 1.24612E-06_JPRB, 1.22875E-06_JPRB, 1.21163E-06_JPRB, 1.19475E-06_JPRB/)
       KAO_MN2( 3, :, 7) = (/ &
     & 1.53883E-06_JPRB, 1.51733E-06_JPRB, 1.49613E-06_JPRB, 1.47522E-06_JPRB, 1.45461E-06_JPRB, &
     & 1.43428E-06_JPRB, 1.41424E-06_JPRB, 1.39448E-06_JPRB, 1.37499E-06_JPRB, 1.35578E-06_JPRB, &
     & 1.33684E-06_JPRB, 1.31816E-06_JPRB, 1.29974E-06_JPRB, 1.28157E-06_JPRB, 1.26367E-06_JPRB, &
     & 1.24601E-06_JPRB, 1.22860E-06_JPRB, 1.21143E-06_JPRB, 1.19450E-06_JPRB/)
       KAO_MN2( 4, :, 7) = (/ &
     & 1.53789E-06_JPRB, 1.51645E-06_JPRB, 1.49532E-06_JPRB, 1.47448E-06_JPRB, 1.45393E-06_JPRB, &
     & 1.43366E-06_JPRB, 1.41368E-06_JPRB, 1.39398E-06_JPRB, 1.37455E-06_JPRB, 1.35539E-06_JPRB, &
     & 1.33650E-06_JPRB, 1.31787E-06_JPRB, 1.29950E-06_JPRB, 1.28139E-06_JPRB, 1.26353E-06_JPRB, &
     & 1.24592E-06_JPRB, 1.22856E-06_JPRB, 1.21143E-06_JPRB, 1.19455E-06_JPRB/)
       KAO_MN2( 5, :, 7) = (/ &
     & 1.54059E-06_JPRB, 1.51888E-06_JPRB, 1.49747E-06_JPRB, 1.47637E-06_JPRB, 1.45557E-06_JPRB, &
     & 1.43505E-06_JPRB, 1.41483E-06_JPRB, 1.39489E-06_JPRB, 1.37523E-06_JPRB, 1.35585E-06_JPRB, &
     & 1.33675E-06_JPRB, 1.31791E-06_JPRB, 1.29934E-06_JPRB, 1.28103E-06_JPRB, 1.26297E-06_JPRB, &
     & 1.24517E-06_JPRB, 1.22763E-06_JPRB, 1.21033E-06_JPRB, 1.19327E-06_JPRB/)
       KAO_MN2( 6, :, 7) = (/ &
     & 1.70605E-06_JPRB, 1.65759E-06_JPRB, 1.61052E-06_JPRB, 1.56478E-06_JPRB, 1.52034E-06_JPRB, &
     & 1.47716E-06_JPRB, 1.43521E-06_JPRB, 1.39445E-06_JPRB, 1.35485E-06_JPRB, 1.31637E-06_JPRB, &
     & 1.27898E-06_JPRB, 1.24266E-06_JPRB, 1.20737E-06_JPRB, 1.17308E-06_JPRB, 1.13976E-06_JPRB, &
     & 1.10739E-06_JPRB, 1.07594E-06_JPRB, 1.04539E-06_JPRB, 1.01570E-06_JPRB/)
       KAO_MN2( 7, :, 7) = (/ &
     & 1.39128E-06_JPRB, 1.36388E-06_JPRB, 1.33702E-06_JPRB, 1.31068E-06_JPRB, 1.28487E-06_JPRB, &
     & 1.25956E-06_JPRB, 1.23475E-06_JPRB, 1.21044E-06_JPRB, 1.18659E-06_JPRB, 1.16322E-06_JPRB, &
     & 1.14031E-06_JPRB, 1.11785E-06_JPRB, 1.09584E-06_JPRB, 1.07425E-06_JPRB, 1.05309E-06_JPRB, &
     & 1.03235E-06_JPRB, 1.01202E-06_JPRB, 9.92088E-07_JPRB, 9.72548E-07_JPRB/)
       KAO_MN2( 8, :, 7) = (/ &
     & 1.15676E-06_JPRB, 1.13709E-06_JPRB, 1.11775E-06_JPRB, 1.09874E-06_JPRB, 1.08005E-06_JPRB, &
     & 1.06168E-06_JPRB, 1.04362E-06_JPRB, 1.02587E-06_JPRB, 1.00842E-06_JPRB, 9.91271E-07_JPRB, &
     & 9.74411E-07_JPRB, 9.57838E-07_JPRB, 9.41547E-07_JPRB, 9.25532E-07_JPRB, 9.09791E-07_JPRB, &
     & 8.94316E-07_JPRB, 8.79105E-07_JPRB, 8.64153E-07_JPRB, 8.49455E-07_JPRB/)
       KAO_MN2( 9, :, 7) = (/ &
     & 1.53483E-06_JPRB, 1.51352E-06_JPRB, 1.49252E-06_JPRB, 1.47180E-06_JPRB, 1.45138E-06_JPRB, &
     & 1.43123E-06_JPRB, 1.41137E-06_JPRB, 1.39178E-06_JPRB, 1.37246E-06_JPRB, 1.35341E-06_JPRB, &
     & 1.33463E-06_JPRB, 1.31610E-06_JPRB, 1.29784E-06_JPRB, 1.27982E-06_JPRB, 1.26206E-06_JPRB, &
     & 1.24454E-06_JPRB, 1.22727E-06_JPRB, 1.21024E-06_JPRB, 1.19344E-06_JPRB/)
       KAO_MN2( 1, :, 8) = (/ &
     & 1.70380E-06_JPRB, 1.67470E-06_JPRB, 1.64609E-06_JPRB, 1.61796E-06_JPRB, 1.59032E-06_JPRB, &
     & 1.56315E-06_JPRB, 1.53645E-06_JPRB, 1.51020E-06_JPRB, 1.48440E-06_JPRB, 1.45904E-06_JPRB, &
     & 1.43411E-06_JPRB, 1.40961E-06_JPRB, 1.38553E-06_JPRB, 1.36186E-06_JPRB, 1.33859E-06_JPRB, &
     & 1.31572E-06_JPRB, 1.29324E-06_JPRB, 1.27115E-06_JPRB, 1.24943E-06_JPRB/)
       KAO_MN2( 2, :, 8) = (/ &
     & 1.70380E-06_JPRB, 1.67470E-06_JPRB, 1.64609E-06_JPRB, 1.61796E-06_JPRB, 1.59032E-06_JPRB, &
     & 1.56315E-06_JPRB, 1.53645E-06_JPRB, 1.51020E-06_JPRB, 1.48440E-06_JPRB, 1.45904E-06_JPRB, &
     & 1.43411E-06_JPRB, 1.40961E-06_JPRB, 1.38553E-06_JPRB, 1.36186E-06_JPRB, 1.33859E-06_JPRB, &
     & 1.31572E-06_JPRB, 1.29324E-06_JPRB, 1.27115E-06_JPRB, 1.24943E-06_JPRB/)
       KAO_MN2( 3, :, 8) = (/ &
     & 1.70380E-06_JPRB, 1.67470E-06_JPRB, 1.64609E-06_JPRB, 1.61796E-06_JPRB, 1.59032E-06_JPRB, &
     & 1.56315E-06_JPRB, 1.53645E-06_JPRB, 1.51020E-06_JPRB, 1.48440E-06_JPRB, 1.45904E-06_JPRB, &
     & 1.43411E-06_JPRB, 1.40961E-06_JPRB, 1.38553E-06_JPRB, 1.36186E-06_JPRB, 1.33859E-06_JPRB, &
     & 1.31572E-06_JPRB, 1.29324E-06_JPRB, 1.27115E-06_JPRB, 1.24943E-06_JPRB/)
       KAO_MN2( 4, :, 8) = (/ &
     & 1.70380E-06_JPRB, 1.67470E-06_JPRB, 1.64609E-06_JPRB, 1.61796E-06_JPRB, 1.59032E-06_JPRB, &
     & 1.56315E-06_JPRB, 1.53645E-06_JPRB, 1.51020E-06_JPRB, 1.48440E-06_JPRB, 1.45904E-06_JPRB, &
     & 1.43411E-06_JPRB, 1.40961E-06_JPRB, 1.38553E-06_JPRB, 1.36186E-06_JPRB, 1.33859E-06_JPRB, &
     & 1.31572E-06_JPRB, 1.29324E-06_JPRB, 1.27115E-06_JPRB, 1.24943E-06_JPRB/)
       KAO_MN2( 5, :, 8) = (/ &
     & 1.70380E-06_JPRB, 1.67470E-06_JPRB, 1.64609E-06_JPRB, 1.61796E-06_JPRB, 1.59032E-06_JPRB, &
     & 1.56315E-06_JPRB, 1.53645E-06_JPRB, 1.51020E-06_JPRB, 1.48440E-06_JPRB, 1.45904E-06_JPRB, &
     & 1.43411E-06_JPRB, 1.40961E-06_JPRB, 1.38553E-06_JPRB, 1.36186E-06_JPRB, 1.33859E-06_JPRB, &
     & 1.31572E-06_JPRB, 1.29324E-06_JPRB, 1.27115E-06_JPRB, 1.24943E-06_JPRB/)
       KAO_MN2( 6, :, 8) = (/ &
     & 1.70380E-06_JPRB, 1.67470E-06_JPRB, 1.64609E-06_JPRB, 1.61796E-06_JPRB, 1.59032E-06_JPRB, &
     & 1.56315E-06_JPRB, 1.53645E-06_JPRB, 1.51020E-06_JPRB, 1.48440E-06_JPRB, 1.45904E-06_JPRB, &
     & 1.43411E-06_JPRB, 1.40961E-06_JPRB, 1.38553E-06_JPRB, 1.36186E-06_JPRB, 1.33859E-06_JPRB, &
     & 1.31572E-06_JPRB, 1.29324E-06_JPRB, 1.27115E-06_JPRB, 1.24943E-06_JPRB/)
       KAO_MN2( 7, :, 8) = (/ &
     & 1.71827E-06_JPRB, 1.65481E-06_JPRB, 1.59370E-06_JPRB, 1.53484E-06_JPRB, 1.47816E-06_JPRB, &
     & 1.42357E-06_JPRB, 1.37099E-06_JPRB, 1.32036E-06_JPRB, 1.27160E-06_JPRB, 1.22464E-06_JPRB, &
     & 1.17941E-06_JPRB, 1.13585E-06_JPRB, 1.09390E-06_JPRB, 1.05350E-06_JPRB, 1.01459E-06_JPRB, &
     & 9.77124E-07_JPRB, 9.41037E-07_JPRB, 9.06284E-07_JPRB, 8.72813E-07_JPRB/)
       KAO_MN2( 8, :, 8) = (/ &
     & 1.77169E-06_JPRB, 1.62858E-06_JPRB, 1.49703E-06_JPRB, 1.37610E-06_JPRB, 1.26494E-06_JPRB, &
     & 1.16276E-06_JPRB, 1.06883E-06_JPRB, 9.82495E-07_JPRB, 9.03131E-07_JPRB, 8.30177E-07_JPRB, &
     & 7.63117E-07_JPRB, 7.01473E-07_JPRB, 6.44810E-07_JPRB, 5.92723E-07_JPRB, 5.44844E-07_JPRB, &
     & 5.00832E-07_JPRB, 4.60376E-07_JPRB, 4.23187E-07_JPRB, 3.89003E-07_JPRB/)
       KAO_MN2( 9, :, 8) = (/ &
     & 1.70025E-06_JPRB, 1.67042E-06_JPRB, 1.64110E-06_JPRB, 1.61231E-06_JPRB, 1.58401E-06_JPRB, &
     & 1.55622E-06_JPRB, 1.52891E-06_JPRB, 1.50208E-06_JPRB, 1.47572E-06_JPRB, 1.44982E-06_JPRB, &
     & 1.42438E-06_JPRB, 1.39939E-06_JPRB, 1.37483E-06_JPRB, 1.35071E-06_JPRB, 1.32700E-06_JPRB, &
     & 1.30372E-06_JPRB, 1.28084E-06_JPRB, 1.25836E-06_JPRB, 1.23628E-06_JPRB/)
       KAO_MN2( 1, :, 9) = (/ &
     & 1.74004E-06_JPRB, 1.70661E-06_JPRB, 1.67383E-06_JPRB, 1.64167E-06_JPRB, 1.61014E-06_JPRB, &
     & 1.57921E-06_JPRB, 1.54887E-06_JPRB, 1.51912E-06_JPRB, 1.48994E-06_JPRB, 1.46132E-06_JPRB, &
     & 1.43325E-06_JPRB, 1.40572E-06_JPRB, 1.37871E-06_JPRB, 1.35223E-06_JPRB, 1.32625E-06_JPRB, &
     & 1.30078E-06_JPRB, 1.27579E-06_JPRB, 1.25128E-06_JPRB, 1.22725E-06_JPRB/)
       KAO_MN2( 2, :, 9) = (/ &
     & 1.74004E-06_JPRB, 1.70661E-06_JPRB, 1.67383E-06_JPRB, 1.64167E-06_JPRB, 1.61014E-06_JPRB, &
     & 1.57921E-06_JPRB, 1.54887E-06_JPRB, 1.51912E-06_JPRB, 1.48994E-06_JPRB, 1.46132E-06_JPRB, &
     & 1.43325E-06_JPRB, 1.40572E-06_JPRB, 1.37871E-06_JPRB, 1.35223E-06_JPRB, 1.32625E-06_JPRB, &
     & 1.30078E-06_JPRB, 1.27579E-06_JPRB, 1.25128E-06_JPRB, 1.22725E-06_JPRB/)
       KAO_MN2( 3, :, 9) = (/ &
     & 1.74004E-06_JPRB, 1.70661E-06_JPRB, 1.67383E-06_JPRB, 1.64167E-06_JPRB, 1.61014E-06_JPRB, &
     & 1.57921E-06_JPRB, 1.54887E-06_JPRB, 1.51912E-06_JPRB, 1.48994E-06_JPRB, 1.46132E-06_JPRB, &
     & 1.43325E-06_JPRB, 1.40572E-06_JPRB, 1.37871E-06_JPRB, 1.35223E-06_JPRB, 1.32625E-06_JPRB, &
     & 1.30078E-06_JPRB, 1.27579E-06_JPRB, 1.25128E-06_JPRB, 1.22725E-06_JPRB/)
       KAO_MN2( 4, :, 9) = (/ &
     & 1.74004E-06_JPRB, 1.70661E-06_JPRB, 1.67383E-06_JPRB, 1.64167E-06_JPRB, 1.61014E-06_JPRB, &
     & 1.57921E-06_JPRB, 1.54887E-06_JPRB, 1.51912E-06_JPRB, 1.48994E-06_JPRB, 1.46132E-06_JPRB, &
     & 1.43325E-06_JPRB, 1.40572E-06_JPRB, 1.37871E-06_JPRB, 1.35223E-06_JPRB, 1.32625E-06_JPRB, &
     & 1.30078E-06_JPRB, 1.27579E-06_JPRB, 1.25128E-06_JPRB, 1.22725E-06_JPRB/)
       KAO_MN2( 5, :, 9) = (/ &
     & 1.74004E-06_JPRB, 1.70661E-06_JPRB, 1.67383E-06_JPRB, 1.64167E-06_JPRB, 1.61014E-06_JPRB, &
     & 1.57921E-06_JPRB, 1.54887E-06_JPRB, 1.51912E-06_JPRB, 1.48994E-06_JPRB, 1.46132E-06_JPRB, &
     & 1.43325E-06_JPRB, 1.40572E-06_JPRB, 1.37871E-06_JPRB, 1.35223E-06_JPRB, 1.32625E-06_JPRB, &
     & 1.30078E-06_JPRB, 1.27579E-06_JPRB, 1.25128E-06_JPRB, 1.22725E-06_JPRB/)
       KAO_MN2( 6, :, 9) = (/ &
     & 1.74004E-06_JPRB, 1.70661E-06_JPRB, 1.67383E-06_JPRB, 1.64167E-06_JPRB, 1.61014E-06_JPRB, &
     & 1.57921E-06_JPRB, 1.54887E-06_JPRB, 1.51912E-06_JPRB, 1.48994E-06_JPRB, 1.46132E-06_JPRB, &
     & 1.43325E-06_JPRB, 1.40572E-06_JPRB, 1.37871E-06_JPRB, 1.35223E-06_JPRB, 1.32625E-06_JPRB, &
     & 1.30078E-06_JPRB, 1.27579E-06_JPRB, 1.25128E-06_JPRB, 1.22725E-06_JPRB/)
       KAO_MN2( 7, :, 9) = (/ &
     & 1.74004E-06_JPRB, 1.70661E-06_JPRB, 1.67383E-06_JPRB, 1.64167E-06_JPRB, 1.61014E-06_JPRB, &
     & 1.57921E-06_JPRB, 1.54887E-06_JPRB, 1.51912E-06_JPRB, 1.48994E-06_JPRB, 1.46132E-06_JPRB, &
     & 1.43325E-06_JPRB, 1.40572E-06_JPRB, 1.37871E-06_JPRB, 1.35223E-06_JPRB, 1.32625E-06_JPRB, &
     & 1.30078E-06_JPRB, 1.27579E-06_JPRB, 1.25128E-06_JPRB, 1.22725E-06_JPRB/)
       KAO_MN2( 8, :, 9) = (/ &
     & 1.08654E-06_JPRB, 1.09039E-06_JPRB, 1.09425E-06_JPRB, 1.09812E-06_JPRB, 1.10201E-06_JPRB, &
     & 1.10592E-06_JPRB, 1.10983E-06_JPRB, 1.11376E-06_JPRB, 1.11771E-06_JPRB, 1.12167E-06_JPRB, &
     & 1.12564E-06_JPRB, 1.12962E-06_JPRB, 1.13363E-06_JPRB, 1.13764E-06_JPRB, 1.14167E-06_JPRB, &
     & 1.14571E-06_JPRB, 1.14977E-06_JPRB, 1.15384E-06_JPRB, 1.15793E-06_JPRB/)
       KAO_MN2( 9, :, 9) = (/ &
     & 1.74382E-06_JPRB, 1.71092E-06_JPRB, 1.67864E-06_JPRB, 1.64697E-06_JPRB, 1.61589E-06_JPRB, &
     & 1.58541E-06_JPRB, 1.55549E-06_JPRB, 1.52615E-06_JPRB, 1.49735E-06_JPRB, 1.46910E-06_JPRB, &
     & 1.44138E-06_JPRB, 1.41419E-06_JPRB, 1.38751E-06_JPRB, 1.36133E-06_JPRB, 1.33564E-06_JPRB, &
     & 1.31045E-06_JPRB, 1.28572E-06_JPRB, 1.26146E-06_JPRB, 1.23766E-06_JPRB/)
       KAO_MN2( 1, :,10) = (/ &
     & 1.73703E-06_JPRB, 1.70249E-06_JPRB, 1.66863E-06_JPRB, 1.63544E-06_JPRB, 1.60292E-06_JPRB, &
     & 1.57104E-06_JPRB, 1.53980E-06_JPRB, 1.50917E-06_JPRB, 1.47916E-06_JPRB, 1.44974E-06_JPRB, &
     & 1.42091E-06_JPRB, 1.39265E-06_JPRB, 1.36496E-06_JPRB, 1.33781E-06_JPRB, 1.31121E-06_JPRB, &
     & 1.28513E-06_JPRB, 1.25957E-06_JPRB, 1.23452E-06_JPRB, 1.20997E-06_JPRB/)
       KAO_MN2( 2, :,10) = (/ &
     & 1.73703E-06_JPRB, 1.70249E-06_JPRB, 1.66863E-06_JPRB, 1.63544E-06_JPRB, 1.60292E-06_JPRB, &
     & 1.57104E-06_JPRB, 1.53980E-06_JPRB, 1.50917E-06_JPRB, 1.47916E-06_JPRB, 1.44974E-06_JPRB, &
     & 1.42091E-06_JPRB, 1.39265E-06_JPRB, 1.36496E-06_JPRB, 1.33781E-06_JPRB, 1.31121E-06_JPRB, &
     & 1.28513E-06_JPRB, 1.25957E-06_JPRB, 1.23452E-06_JPRB, 1.20997E-06_JPRB/)
       KAO_MN2( 3, :,10) = (/ &
     & 1.73703E-06_JPRB, 1.70249E-06_JPRB, 1.66863E-06_JPRB, 1.63544E-06_JPRB, 1.60292E-06_JPRB, &
     & 1.57104E-06_JPRB, 1.53980E-06_JPRB, 1.50917E-06_JPRB, 1.47916E-06_JPRB, 1.44974E-06_JPRB, &
     & 1.42091E-06_JPRB, 1.39265E-06_JPRB, 1.36496E-06_JPRB, 1.33781E-06_JPRB, 1.31121E-06_JPRB, &
     & 1.28513E-06_JPRB, 1.25957E-06_JPRB, 1.23452E-06_JPRB, 1.20997E-06_JPRB/)
       KAO_MN2( 4, :,10) = (/ &
     & 1.73703E-06_JPRB, 1.70249E-06_JPRB, 1.66863E-06_JPRB, 1.63544E-06_JPRB, 1.60292E-06_JPRB, &
     & 1.57104E-06_JPRB, 1.53980E-06_JPRB, 1.50917E-06_JPRB, 1.47916E-06_JPRB, 1.44974E-06_JPRB, &
     & 1.42091E-06_JPRB, 1.39265E-06_JPRB, 1.36496E-06_JPRB, 1.33781E-06_JPRB, 1.31121E-06_JPRB, &
     & 1.28513E-06_JPRB, 1.25957E-06_JPRB, 1.23452E-06_JPRB, 1.20997E-06_JPRB/)
       KAO_MN2( 5, :,10) = (/ &
     & 1.73703E-06_JPRB, 1.70249E-06_JPRB, 1.66863E-06_JPRB, 1.63544E-06_JPRB, 1.60292E-06_JPRB, &
     & 1.57104E-06_JPRB, 1.53980E-06_JPRB, 1.50917E-06_JPRB, 1.47916E-06_JPRB, 1.44974E-06_JPRB, &
     & 1.42091E-06_JPRB, 1.39265E-06_JPRB, 1.36496E-06_JPRB, 1.33781E-06_JPRB, 1.31121E-06_JPRB, &
     & 1.28513E-06_JPRB, 1.25957E-06_JPRB, 1.23452E-06_JPRB, 1.20997E-06_JPRB/)
       KAO_MN2( 6, :,10) = (/ &
     & 1.73703E-06_JPRB, 1.70249E-06_JPRB, 1.66863E-06_JPRB, 1.63544E-06_JPRB, 1.60292E-06_JPRB, &
     & 1.57104E-06_JPRB, 1.53980E-06_JPRB, 1.50917E-06_JPRB, 1.47916E-06_JPRB, 1.44974E-06_JPRB, &
     & 1.42091E-06_JPRB, 1.39265E-06_JPRB, 1.36496E-06_JPRB, 1.33781E-06_JPRB, 1.31121E-06_JPRB, &
     & 1.28513E-06_JPRB, 1.25957E-06_JPRB, 1.23452E-06_JPRB, 1.20997E-06_JPRB/)
       KAO_MN2( 7, :,10) = (/ &
     & 1.73703E-06_JPRB, 1.70249E-06_JPRB, 1.66863E-06_JPRB, 1.63544E-06_JPRB, 1.60292E-06_JPRB, &
     & 1.57104E-06_JPRB, 1.53980E-06_JPRB, 1.50917E-06_JPRB, 1.47916E-06_JPRB, 1.44974E-06_JPRB, &
     & 1.42091E-06_JPRB, 1.39265E-06_JPRB, 1.36496E-06_JPRB, 1.33781E-06_JPRB, 1.31121E-06_JPRB, &
     & 1.28513E-06_JPRB, 1.25957E-06_JPRB, 1.23452E-06_JPRB, 1.20997E-06_JPRB/)
       KAO_MN2( 8, :,10) = (/ &
     & 1.73703E-06_JPRB, 1.70249E-06_JPRB, 1.66863E-06_JPRB, 1.63544E-06_JPRB, 1.60292E-06_JPRB, &
     & 1.57104E-06_JPRB, 1.53980E-06_JPRB, 1.50917E-06_JPRB, 1.47916E-06_JPRB, 1.44974E-06_JPRB, &
     & 1.42091E-06_JPRB, 1.39265E-06_JPRB, 1.36496E-06_JPRB, 1.33781E-06_JPRB, 1.31121E-06_JPRB, &
     & 1.28513E-06_JPRB, 1.25957E-06_JPRB, 1.23452E-06_JPRB, 1.20997E-06_JPRB/)
       KAO_MN2( 9, :,10) = (/ &
     & 1.82903E-06_JPRB, 1.78673E-06_JPRB, 1.74541E-06_JPRB, 1.70505E-06_JPRB, 1.66562E-06_JPRB, &
     & 1.62710E-06_JPRB, 1.58947E-06_JPRB, 1.55271E-06_JPRB, 1.51680E-06_JPRB, 1.48172E-06_JPRB, &
     & 1.44745E-06_JPRB, 1.41398E-06_JPRB, 1.38128E-06_JPRB, 1.34933E-06_JPRB, 1.31813E-06_JPRB, &
     & 1.28765E-06_JPRB, 1.25787E-06_JPRB, 1.22878E-06_JPRB, 1.20036E-06_JPRB/)
       KAO_MN2( 1, :,11) = (/ &
     & 1.73118E-06_JPRB, 1.69710E-06_JPRB, 1.66370E-06_JPRB, 1.63095E-06_JPRB, 1.59885E-06_JPRB, &
     & 1.56737E-06_JPRB, 1.53652E-06_JPRB, 1.50628E-06_JPRB, 1.47663E-06_JPRB, 1.44756E-06_JPRB, &
     & 1.41907E-06_JPRB, 1.39114E-06_JPRB, 1.36376E-06_JPRB, 1.33691E-06_JPRB, 1.31060E-06_JPRB, &
     & 1.28480E-06_JPRB, 1.25951E-06_JPRB, 1.23472E-06_JPRB, 1.21041E-06_JPRB/)
       KAO_MN2( 2, :,11) = (/ &
     & 1.73118E-06_JPRB, 1.69710E-06_JPRB, 1.66370E-06_JPRB, 1.63095E-06_JPRB, 1.59885E-06_JPRB, &
     & 1.56737E-06_JPRB, 1.53652E-06_JPRB, 1.50628E-06_JPRB, 1.47663E-06_JPRB, 1.44756E-06_JPRB, &
     & 1.41907E-06_JPRB, 1.39114E-06_JPRB, 1.36376E-06_JPRB, 1.33691E-06_JPRB, 1.31060E-06_JPRB, &
     & 1.28480E-06_JPRB, 1.25951E-06_JPRB, 1.23472E-06_JPRB, 1.21041E-06_JPRB/)
       KAO_MN2( 3, :,11) = (/ &
     & 1.73118E-06_JPRB, 1.69710E-06_JPRB, 1.66370E-06_JPRB, 1.63095E-06_JPRB, 1.59885E-06_JPRB, &
     & 1.56737E-06_JPRB, 1.53652E-06_JPRB, 1.50628E-06_JPRB, 1.47663E-06_JPRB, 1.44756E-06_JPRB, &
     & 1.41907E-06_JPRB, 1.39114E-06_JPRB, 1.36376E-06_JPRB, 1.33691E-06_JPRB, 1.31060E-06_JPRB, &
     & 1.28480E-06_JPRB, 1.25951E-06_JPRB, 1.23472E-06_JPRB, 1.21041E-06_JPRB/)
       KAO_MN2( 4, :,11) = (/ &
     & 1.73118E-06_JPRB, 1.69710E-06_JPRB, 1.66370E-06_JPRB, 1.63095E-06_JPRB, 1.59885E-06_JPRB, &
     & 1.56737E-06_JPRB, 1.53652E-06_JPRB, 1.50628E-06_JPRB, 1.47663E-06_JPRB, 1.44756E-06_JPRB, &
     & 1.41907E-06_JPRB, 1.39114E-06_JPRB, 1.36376E-06_JPRB, 1.33691E-06_JPRB, 1.31060E-06_JPRB, &
     & 1.28480E-06_JPRB, 1.25951E-06_JPRB, 1.23472E-06_JPRB, 1.21041E-06_JPRB/)
       KAO_MN2( 5, :,11) = (/ &
     & 1.73118E-06_JPRB, 1.69710E-06_JPRB, 1.66370E-06_JPRB, 1.63095E-06_JPRB, 1.59885E-06_JPRB, &
     & 1.56737E-06_JPRB, 1.53652E-06_JPRB, 1.50628E-06_JPRB, 1.47663E-06_JPRB, 1.44756E-06_JPRB, &
     & 1.41907E-06_JPRB, 1.39114E-06_JPRB, 1.36376E-06_JPRB, 1.33691E-06_JPRB, 1.31060E-06_JPRB, &
     & 1.28480E-06_JPRB, 1.25951E-06_JPRB, 1.23472E-06_JPRB, 1.21041E-06_JPRB/)
       KAO_MN2( 6, :,11) = (/ &
     & 1.73118E-06_JPRB, 1.69710E-06_JPRB, 1.66370E-06_JPRB, 1.63095E-06_JPRB, 1.59885E-06_JPRB, &
     & 1.56737E-06_JPRB, 1.53652E-06_JPRB, 1.50628E-06_JPRB, 1.47663E-06_JPRB, 1.44756E-06_JPRB, &
     & 1.41907E-06_JPRB, 1.39114E-06_JPRB, 1.36376E-06_JPRB, 1.33691E-06_JPRB, 1.31060E-06_JPRB, &
     & 1.28480E-06_JPRB, 1.25951E-06_JPRB, 1.23472E-06_JPRB, 1.21041E-06_JPRB/)
       KAO_MN2( 7, :,11) = (/ &
     & 1.73118E-06_JPRB, 1.69710E-06_JPRB, 1.66370E-06_JPRB, 1.63095E-06_JPRB, 1.59885E-06_JPRB, &
     & 1.56737E-06_JPRB, 1.53652E-06_JPRB, 1.50628E-06_JPRB, 1.47663E-06_JPRB, 1.44756E-06_JPRB, &
     & 1.41907E-06_JPRB, 1.39114E-06_JPRB, 1.36376E-06_JPRB, 1.33691E-06_JPRB, 1.31060E-06_JPRB, &
     & 1.28480E-06_JPRB, 1.25951E-06_JPRB, 1.23472E-06_JPRB, 1.21041E-06_JPRB/)
       KAO_MN2( 8, :,11) = (/ &
     & 1.73118E-06_JPRB, 1.69710E-06_JPRB, 1.66370E-06_JPRB, 1.63095E-06_JPRB, 1.59885E-06_JPRB, &
     & 1.56737E-06_JPRB, 1.53652E-06_JPRB, 1.50628E-06_JPRB, 1.47663E-06_JPRB, 1.44756E-06_JPRB, &
     & 1.41907E-06_JPRB, 1.39114E-06_JPRB, 1.36376E-06_JPRB, 1.33691E-06_JPRB, 1.31060E-06_JPRB, &
     & 1.28480E-06_JPRB, 1.25951E-06_JPRB, 1.23472E-06_JPRB, 1.21041E-06_JPRB/)
       KAO_MN2( 9, :,11) = (/ &
     & 1.81037E-06_JPRB, 1.76948E-06_JPRB, 1.72952E-06_JPRB, 1.69045E-06_JPRB, 1.65228E-06_JPRB, &
     & 1.61496E-06_JPRB, 1.57848E-06_JPRB, 1.54283E-06_JPRB, 1.50799E-06_JPRB, 1.47393E-06_JPRB, &
     & 1.44064E-06_JPRB, 1.40810E-06_JPRB, 1.37630E-06_JPRB, 1.34522E-06_JPRB, 1.31484E-06_JPRB, &
     & 1.28514E-06_JPRB, 1.25611E-06_JPRB, 1.22774E-06_JPRB, 1.20002E-06_JPRB/)
       KAO_MN2( 1, :,12) = (/ &
     & 1.73338E-06_JPRB, 1.69915E-06_JPRB, 1.66560E-06_JPRB, 1.63271E-06_JPRB, 1.60046E-06_JPRB, &
     & 1.56886E-06_JPRB, 1.53788E-06_JPRB, 1.50751E-06_JPRB, 1.47774E-06_JPRB, 1.44856E-06_JPRB, &
     & 1.41995E-06_JPRB, 1.39191E-06_JPRB, 1.36442E-06_JPRB, 1.33748E-06_JPRB, 1.31107E-06_JPRB, &
     & 1.28518E-06_JPRB, 1.25980E-06_JPRB, 1.23492E-06_JPRB, 1.21053E-06_JPRB/)
       KAO_MN2( 2, :,12) = (/ &
     & 1.73338E-06_JPRB, 1.69915E-06_JPRB, 1.66560E-06_JPRB, 1.63271E-06_JPRB, 1.60046E-06_JPRB, &
     & 1.56886E-06_JPRB, 1.53788E-06_JPRB, 1.50751E-06_JPRB, 1.47774E-06_JPRB, 1.44856E-06_JPRB, &
     & 1.41995E-06_JPRB, 1.39191E-06_JPRB, 1.36442E-06_JPRB, 1.33748E-06_JPRB, 1.31107E-06_JPRB, &
     & 1.28518E-06_JPRB, 1.25980E-06_JPRB, 1.23492E-06_JPRB, 1.21053E-06_JPRB/)
       KAO_MN2( 3, :,12) = (/ &
     & 1.73338E-06_JPRB, 1.69915E-06_JPRB, 1.66560E-06_JPRB, 1.63271E-06_JPRB, 1.60046E-06_JPRB, &
     & 1.56886E-06_JPRB, 1.53788E-06_JPRB, 1.50751E-06_JPRB, 1.47774E-06_JPRB, 1.44856E-06_JPRB, &
     & 1.41995E-06_JPRB, 1.39191E-06_JPRB, 1.36442E-06_JPRB, 1.33748E-06_JPRB, 1.31107E-06_JPRB, &
     & 1.28518E-06_JPRB, 1.25980E-06_JPRB, 1.23492E-06_JPRB, 1.21053E-06_JPRB/)
       KAO_MN2( 4, :,12) = (/ &
     & 1.73338E-06_JPRB, 1.69915E-06_JPRB, 1.66560E-06_JPRB, 1.63271E-06_JPRB, 1.60046E-06_JPRB, &
     & 1.56886E-06_JPRB, 1.53788E-06_JPRB, 1.50751E-06_JPRB, 1.47774E-06_JPRB, 1.44856E-06_JPRB, &
     & 1.41995E-06_JPRB, 1.39191E-06_JPRB, 1.36442E-06_JPRB, 1.33748E-06_JPRB, 1.31107E-06_JPRB, &
     & 1.28518E-06_JPRB, 1.25980E-06_JPRB, 1.23492E-06_JPRB, 1.21053E-06_JPRB/)
       KAO_MN2( 5, :,12) = (/ &
     & 1.73338E-06_JPRB, 1.69915E-06_JPRB, 1.66560E-06_JPRB, 1.63271E-06_JPRB, 1.60046E-06_JPRB, &
     & 1.56886E-06_JPRB, 1.53788E-06_JPRB, 1.50751E-06_JPRB, 1.47774E-06_JPRB, 1.44856E-06_JPRB, &
     & 1.41995E-06_JPRB, 1.39191E-06_JPRB, 1.36442E-06_JPRB, 1.33748E-06_JPRB, 1.31107E-06_JPRB, &
     & 1.28518E-06_JPRB, 1.25980E-06_JPRB, 1.23492E-06_JPRB, 1.21053E-06_JPRB/)
       KAO_MN2( 6, :,12) = (/ &
     & 1.73338E-06_JPRB, 1.69915E-06_JPRB, 1.66560E-06_JPRB, 1.63271E-06_JPRB, 1.60046E-06_JPRB, &
     & 1.56886E-06_JPRB, 1.53788E-06_JPRB, 1.50751E-06_JPRB, 1.47774E-06_JPRB, 1.44856E-06_JPRB, &
     & 1.41995E-06_JPRB, 1.39191E-06_JPRB, 1.36442E-06_JPRB, 1.33748E-06_JPRB, 1.31107E-06_JPRB, &
     & 1.28518E-06_JPRB, 1.25980E-06_JPRB, 1.23492E-06_JPRB, 1.21053E-06_JPRB/)
       KAO_MN2( 7, :,12) = (/ &
     & 1.73338E-06_JPRB, 1.69915E-06_JPRB, 1.66560E-06_JPRB, 1.63271E-06_JPRB, 1.60046E-06_JPRB, &
     & 1.56886E-06_JPRB, 1.53788E-06_JPRB, 1.50751E-06_JPRB, 1.47774E-06_JPRB, 1.44856E-06_JPRB, &
     & 1.41995E-06_JPRB, 1.39191E-06_JPRB, 1.36442E-06_JPRB, 1.33748E-06_JPRB, 1.31107E-06_JPRB, &
     & 1.28518E-06_JPRB, 1.25980E-06_JPRB, 1.23492E-06_JPRB, 1.21053E-06_JPRB/)
       KAO_MN2( 8, :,12) = (/ &
     & 1.73338E-06_JPRB, 1.69915E-06_JPRB, 1.66560E-06_JPRB, 1.63271E-06_JPRB, 1.60046E-06_JPRB, &
     & 1.56886E-06_JPRB, 1.53788E-06_JPRB, 1.50751E-06_JPRB, 1.47774E-06_JPRB, 1.44856E-06_JPRB, &
     & 1.41995E-06_JPRB, 1.39191E-06_JPRB, 1.36442E-06_JPRB, 1.33748E-06_JPRB, 1.31107E-06_JPRB, &
     & 1.28518E-06_JPRB, 1.25980E-06_JPRB, 1.23492E-06_JPRB, 1.21053E-06_JPRB/)
       KAO_MN2( 9, :,12) = (/ &
     & 2.04857E-06_JPRB, 1.98353E-06_JPRB, 1.92055E-06_JPRB, 1.85957E-06_JPRB, 1.80053E-06_JPRB, &
     & 1.74336E-06_JPRB, 1.68800E-06_JPRB, 1.63441E-06_JPRB, 1.58251E-06_JPRB, 1.53227E-06_JPRB, &
     & 1.48362E-06_JPRB, 1.43651E-06_JPRB, 1.39090E-06_JPRB, 1.34674E-06_JPRB, 1.30398E-06_JPRB, &
     & 1.26257E-06_JPRB, 1.22249E-06_JPRB, 1.18367E-06_JPRB, 1.14609E-06_JPRB/)
       KAO_MN2( 1, :,13) = (/ &
     & 1.73511E-06_JPRB, 1.70072E-06_JPRB, 1.66702E-06_JPRB, 1.63398E-06_JPRB, 1.60159E-06_JPRB, &
     & 1.56985E-06_JPRB, 1.53874E-06_JPRB, 1.50824E-06_JPRB, 1.47835E-06_JPRB, 1.44905E-06_JPRB, &
     & 1.42033E-06_JPRB, 1.39218E-06_JPRB, 1.36459E-06_JPRB, 1.33755E-06_JPRB, 1.31104E-06_JPRB, &
     & 1.28505E-06_JPRB, 1.25958E-06_JPRB, 1.23462E-06_JPRB, 1.21015E-06_JPRB/)
       KAO_MN2( 2, :,13) = (/ &
     & 1.73511E-06_JPRB, 1.70072E-06_JPRB, 1.66702E-06_JPRB, 1.63398E-06_JPRB, 1.60159E-06_JPRB, &
     & 1.56985E-06_JPRB, 1.53874E-06_JPRB, 1.50824E-06_JPRB, 1.47835E-06_JPRB, 1.44905E-06_JPRB, &
     & 1.42033E-06_JPRB, 1.39218E-06_JPRB, 1.36459E-06_JPRB, 1.33755E-06_JPRB, 1.31104E-06_JPRB, &
     & 1.28505E-06_JPRB, 1.25958E-06_JPRB, 1.23462E-06_JPRB, 1.21015E-06_JPRB/)
       KAO_MN2( 3, :,13) = (/ &
     & 1.73511E-06_JPRB, 1.70072E-06_JPRB, 1.66702E-06_JPRB, 1.63398E-06_JPRB, 1.60159E-06_JPRB, &
     & 1.56985E-06_JPRB, 1.53874E-06_JPRB, 1.50824E-06_JPRB, 1.47835E-06_JPRB, 1.44905E-06_JPRB, &
     & 1.42033E-06_JPRB, 1.39218E-06_JPRB, 1.36459E-06_JPRB, 1.33755E-06_JPRB, 1.31104E-06_JPRB, &
     & 1.28505E-06_JPRB, 1.25958E-06_JPRB, 1.23462E-06_JPRB, 1.21015E-06_JPRB/)
       KAO_MN2( 4, :,13) = (/ &
     & 1.73511E-06_JPRB, 1.70072E-06_JPRB, 1.66702E-06_JPRB, 1.63398E-06_JPRB, 1.60159E-06_JPRB, &
     & 1.56985E-06_JPRB, 1.53874E-06_JPRB, 1.50824E-06_JPRB, 1.47835E-06_JPRB, 1.44905E-06_JPRB, &
     & 1.42033E-06_JPRB, 1.39218E-06_JPRB, 1.36459E-06_JPRB, 1.33755E-06_JPRB, 1.31104E-06_JPRB, &
     & 1.28505E-06_JPRB, 1.25958E-06_JPRB, 1.23462E-06_JPRB, 1.21015E-06_JPRB/)
       KAO_MN2( 5, :,13) = (/ &
     & 1.73511E-06_JPRB, 1.70072E-06_JPRB, 1.66702E-06_JPRB, 1.63398E-06_JPRB, 1.60159E-06_JPRB, &
     & 1.56985E-06_JPRB, 1.53874E-06_JPRB, 1.50824E-06_JPRB, 1.47835E-06_JPRB, 1.44905E-06_JPRB, &
     & 1.42033E-06_JPRB, 1.39218E-06_JPRB, 1.36459E-06_JPRB, 1.33755E-06_JPRB, 1.31104E-06_JPRB, &
     & 1.28505E-06_JPRB, 1.25958E-06_JPRB, 1.23462E-06_JPRB, 1.21015E-06_JPRB/)
       KAO_MN2( 6, :,13) = (/ &
     & 1.73511E-06_JPRB, 1.70072E-06_JPRB, 1.66702E-06_JPRB, 1.63398E-06_JPRB, 1.60159E-06_JPRB, &
     & 1.56985E-06_JPRB, 1.53874E-06_JPRB, 1.50824E-06_JPRB, 1.47835E-06_JPRB, 1.44905E-06_JPRB, &
     & 1.42033E-06_JPRB, 1.39218E-06_JPRB, 1.36459E-06_JPRB, 1.33755E-06_JPRB, 1.31104E-06_JPRB, &
     & 1.28505E-06_JPRB, 1.25958E-06_JPRB, 1.23462E-06_JPRB, 1.21015E-06_JPRB/)
       KAO_MN2( 7, :,13) = (/ &
     & 1.73511E-06_JPRB, 1.70072E-06_JPRB, 1.66702E-06_JPRB, 1.63398E-06_JPRB, 1.60159E-06_JPRB, &
     & 1.56985E-06_JPRB, 1.53874E-06_JPRB, 1.50824E-06_JPRB, 1.47835E-06_JPRB, 1.44905E-06_JPRB, &
     & 1.42033E-06_JPRB, 1.39218E-06_JPRB, 1.36459E-06_JPRB, 1.33755E-06_JPRB, 1.31104E-06_JPRB, &
     & 1.28505E-06_JPRB, 1.25958E-06_JPRB, 1.23462E-06_JPRB, 1.21015E-06_JPRB/)
       KAO_MN2( 8, :,13) = (/ &
     & 1.73511E-06_JPRB, 1.70072E-06_JPRB, 1.66702E-06_JPRB, 1.63398E-06_JPRB, 1.60159E-06_JPRB, &
     & 1.56985E-06_JPRB, 1.53874E-06_JPRB, 1.50824E-06_JPRB, 1.47835E-06_JPRB, 1.44905E-06_JPRB, &
     & 1.42033E-06_JPRB, 1.39218E-06_JPRB, 1.36459E-06_JPRB, 1.33755E-06_JPRB, 1.31104E-06_JPRB, &
     & 1.28505E-06_JPRB, 1.25958E-06_JPRB, 1.23462E-06_JPRB, 1.21015E-06_JPRB/)
       KAO_MN2( 9, :,13) = (/ &
     & 2.13403E-06_JPRB, 2.05906E-06_JPRB, 1.98673E-06_JPRB, 1.91694E-06_JPRB, 1.84961E-06_JPRB, &
     & 1.78463E-06_JPRB, 1.72194E-06_JPRB, 1.66145E-06_JPRB, 1.60309E-06_JPRB, 1.54678E-06_JPRB, &
     & 1.49244E-06_JPRB, 1.44002E-06_JPRB, 1.38943E-06_JPRB, 1.34062E-06_JPRB, 1.29353E-06_JPRB, &
     & 1.24809E-06_JPRB, 1.20425E-06_JPRB, 1.16195E-06_JPRB, 1.12113E-06_JPRB/)
       KAO_MN2( 1, :,14) = (/ &
     & 1.73398E-06_JPRB, 1.69941E-06_JPRB, 1.66553E-06_JPRB, 1.63233E-06_JPRB, 1.59979E-06_JPRB, &
     & 1.56790E-06_JPRB, 1.53664E-06_JPRB, 1.50601E-06_JPRB, 1.47598E-06_JPRB, 1.44656E-06_JPRB, &
     & 1.41772E-06_JPRB, 1.38946E-06_JPRB, 1.36176E-06_JPRB, 1.33461E-06_JPRB, 1.30801E-06_JPRB, &
     & 1.28193E-06_JPRB, 1.25637E-06_JPRB, 1.23133E-06_JPRB, 1.20678E-06_JPRB/)
       KAO_MN2( 2, :,14) = (/ &
     & 1.73398E-06_JPRB, 1.69941E-06_JPRB, 1.66553E-06_JPRB, 1.63233E-06_JPRB, 1.59979E-06_JPRB, &
     & 1.56790E-06_JPRB, 1.53664E-06_JPRB, 1.50601E-06_JPRB, 1.47598E-06_JPRB, 1.44656E-06_JPRB, &
     & 1.41772E-06_JPRB, 1.38946E-06_JPRB, 1.36176E-06_JPRB, 1.33461E-06_JPRB, 1.30801E-06_JPRB, &
     & 1.28193E-06_JPRB, 1.25637E-06_JPRB, 1.23133E-06_JPRB, 1.20678E-06_JPRB/)
       KAO_MN2( 3, :,14) = (/ &
     & 1.73398E-06_JPRB, 1.69941E-06_JPRB, 1.66553E-06_JPRB, 1.63233E-06_JPRB, 1.59979E-06_JPRB, &
     & 1.56790E-06_JPRB, 1.53664E-06_JPRB, 1.50601E-06_JPRB, 1.47598E-06_JPRB, 1.44656E-06_JPRB, &
     & 1.41772E-06_JPRB, 1.38946E-06_JPRB, 1.36176E-06_JPRB, 1.33461E-06_JPRB, 1.30801E-06_JPRB, &
     & 1.28193E-06_JPRB, 1.25637E-06_JPRB, 1.23133E-06_JPRB, 1.20678E-06_JPRB/)
       KAO_MN2( 4, :,14) = (/ &
     & 1.73398E-06_JPRB, 1.69941E-06_JPRB, 1.66553E-06_JPRB, 1.63233E-06_JPRB, 1.59979E-06_JPRB, &
     & 1.56790E-06_JPRB, 1.53664E-06_JPRB, 1.50601E-06_JPRB, 1.47598E-06_JPRB, 1.44656E-06_JPRB, &
     & 1.41772E-06_JPRB, 1.38946E-06_JPRB, 1.36176E-06_JPRB, 1.33461E-06_JPRB, 1.30801E-06_JPRB, &
     & 1.28193E-06_JPRB, 1.25637E-06_JPRB, 1.23133E-06_JPRB, 1.20678E-06_JPRB/)
       KAO_MN2( 5, :,14) = (/ &
     & 1.73398E-06_JPRB, 1.69941E-06_JPRB, 1.66553E-06_JPRB, 1.63233E-06_JPRB, 1.59979E-06_JPRB, &
     & 1.56790E-06_JPRB, 1.53664E-06_JPRB, 1.50601E-06_JPRB, 1.47598E-06_JPRB, 1.44656E-06_JPRB, &
     & 1.41772E-06_JPRB, 1.38946E-06_JPRB, 1.36176E-06_JPRB, 1.33461E-06_JPRB, 1.30801E-06_JPRB, &
     & 1.28193E-06_JPRB, 1.25637E-06_JPRB, 1.23133E-06_JPRB, 1.20678E-06_JPRB/)
       KAO_MN2( 6, :,14) = (/ &
     & 1.73398E-06_JPRB, 1.69941E-06_JPRB, 1.66553E-06_JPRB, 1.63233E-06_JPRB, 1.59979E-06_JPRB, &
     & 1.56790E-06_JPRB, 1.53664E-06_JPRB, 1.50601E-06_JPRB, 1.47598E-06_JPRB, 1.44656E-06_JPRB, &
     & 1.41772E-06_JPRB, 1.38946E-06_JPRB, 1.36176E-06_JPRB, 1.33461E-06_JPRB, 1.30801E-06_JPRB, &
     & 1.28193E-06_JPRB, 1.25637E-06_JPRB, 1.23133E-06_JPRB, 1.20678E-06_JPRB/)
       KAO_MN2( 7, :,14) = (/ &
     & 1.73398E-06_JPRB, 1.69941E-06_JPRB, 1.66553E-06_JPRB, 1.63233E-06_JPRB, 1.59979E-06_JPRB, &
     & 1.56790E-06_JPRB, 1.53664E-06_JPRB, 1.50601E-06_JPRB, 1.47598E-06_JPRB, 1.44656E-06_JPRB, &
     & 1.41772E-06_JPRB, 1.38946E-06_JPRB, 1.36176E-06_JPRB, 1.33461E-06_JPRB, 1.30801E-06_JPRB, &
     & 1.28193E-06_JPRB, 1.25637E-06_JPRB, 1.23133E-06_JPRB, 1.20678E-06_JPRB/)
       KAO_MN2( 8, :,14) = (/ &
     & 1.73398E-06_JPRB, 1.69941E-06_JPRB, 1.66553E-06_JPRB, 1.63233E-06_JPRB, 1.59979E-06_JPRB, &
     & 1.56790E-06_JPRB, 1.53664E-06_JPRB, 1.50601E-06_JPRB, 1.47598E-06_JPRB, 1.44656E-06_JPRB, &
     & 1.41772E-06_JPRB, 1.38946E-06_JPRB, 1.36176E-06_JPRB, 1.33461E-06_JPRB, 1.30801E-06_JPRB, &
     & 1.28193E-06_JPRB, 1.25637E-06_JPRB, 1.23133E-06_JPRB, 1.20678E-06_JPRB/)
       KAO_MN2( 9, :,14) = (/ &
     & 1.83423E-06_JPRB, 1.79123E-06_JPRB, 1.74923E-06_JPRB, 1.70821E-06_JPRB, 1.66816E-06_JPRB, &
     & 1.62904E-06_JPRB, 1.59085E-06_JPRB, 1.55354E-06_JPRB, 1.51712E-06_JPRB, 1.48154E-06_JPRB, &
     & 1.44681E-06_JPRB, 1.41288E-06_JPRB, 1.37975E-06_JPRB, 1.34740E-06_JPRB, 1.31581E-06_JPRB, &
     & 1.28496E-06_JPRB, 1.25483E-06_JPRB, 1.22540E-06_JPRB, 1.19667E-06_JPRB/)
       KAO_MN2( 1, :,15) = (/ &
     & 1.73231E-06_JPRB, 1.69765E-06_JPRB, 1.66368E-06_JPRB, 1.63039E-06_JPRB, 1.59776E-06_JPRB, &
     & 1.56579E-06_JPRB, 1.53445E-06_JPRB, 1.50375E-06_JPRB, 1.47366E-06_JPRB, 1.44417E-06_JPRB, &
     & 1.41527E-06_JPRB, 1.38695E-06_JPRB, 1.35919E-06_JPRB, 1.33199E-06_JPRB, 1.30534E-06_JPRB, &
     & 1.27922E-06_JPRB, 1.25362E-06_JPRB, 1.22853E-06_JPRB, 1.20395E-06_JPRB/)
       KAO_MN2( 2, :,15) = (/ &
     & 1.73231E-06_JPRB, 1.69765E-06_JPRB, 1.66368E-06_JPRB, 1.63039E-06_JPRB, 1.59776E-06_JPRB, &
     & 1.56579E-06_JPRB, 1.53445E-06_JPRB, 1.50375E-06_JPRB, 1.47366E-06_JPRB, 1.44417E-06_JPRB, &
     & 1.41527E-06_JPRB, 1.38695E-06_JPRB, 1.35919E-06_JPRB, 1.33199E-06_JPRB, 1.30534E-06_JPRB, &
     & 1.27922E-06_JPRB, 1.25362E-06_JPRB, 1.22853E-06_JPRB, 1.20395E-06_JPRB/)
       KAO_MN2( 3, :,15) = (/ &
     & 1.73231E-06_JPRB, 1.69765E-06_JPRB, 1.66368E-06_JPRB, 1.63039E-06_JPRB, 1.59776E-06_JPRB, &
     & 1.56579E-06_JPRB, 1.53445E-06_JPRB, 1.50375E-06_JPRB, 1.47366E-06_JPRB, 1.44417E-06_JPRB, &
     & 1.41527E-06_JPRB, 1.38695E-06_JPRB, 1.35919E-06_JPRB, 1.33199E-06_JPRB, 1.30534E-06_JPRB, &
     & 1.27922E-06_JPRB, 1.25362E-06_JPRB, 1.22853E-06_JPRB, 1.20395E-06_JPRB/)
       KAO_MN2( 4, :,15) = (/ &
     & 1.73231E-06_JPRB, 1.69765E-06_JPRB, 1.66368E-06_JPRB, 1.63039E-06_JPRB, 1.59776E-06_JPRB, &
     & 1.56579E-06_JPRB, 1.53445E-06_JPRB, 1.50375E-06_JPRB, 1.47366E-06_JPRB, 1.44417E-06_JPRB, &
     & 1.41527E-06_JPRB, 1.38695E-06_JPRB, 1.35919E-06_JPRB, 1.33199E-06_JPRB, 1.30534E-06_JPRB, &
     & 1.27922E-06_JPRB, 1.25362E-06_JPRB, 1.22853E-06_JPRB, 1.20395E-06_JPRB/)
       KAO_MN2( 5, :,15) = (/ &
     & 1.73231E-06_JPRB, 1.69765E-06_JPRB, 1.66368E-06_JPRB, 1.63039E-06_JPRB, 1.59776E-06_JPRB, &
     & 1.56579E-06_JPRB, 1.53445E-06_JPRB, 1.50375E-06_JPRB, 1.47366E-06_JPRB, 1.44417E-06_JPRB, &
     & 1.41527E-06_JPRB, 1.38695E-06_JPRB, 1.35919E-06_JPRB, 1.33199E-06_JPRB, 1.30534E-06_JPRB, &
     & 1.27922E-06_JPRB, 1.25362E-06_JPRB, 1.22853E-06_JPRB, 1.20395E-06_JPRB/)
       KAO_MN2( 6, :,15) = (/ &
     & 1.73231E-06_JPRB, 1.69765E-06_JPRB, 1.66368E-06_JPRB, 1.63039E-06_JPRB, 1.59776E-06_JPRB, &
     & 1.56579E-06_JPRB, 1.53445E-06_JPRB, 1.50375E-06_JPRB, 1.47366E-06_JPRB, 1.44417E-06_JPRB, &
     & 1.41527E-06_JPRB, 1.38695E-06_JPRB, 1.35919E-06_JPRB, 1.33199E-06_JPRB, 1.30534E-06_JPRB, &
     & 1.27922E-06_JPRB, 1.25362E-06_JPRB, 1.22853E-06_JPRB, 1.20395E-06_JPRB/)
       KAO_MN2( 7, :,15) = (/ &
     & 1.73231E-06_JPRB, 1.69765E-06_JPRB, 1.66368E-06_JPRB, 1.63039E-06_JPRB, 1.59776E-06_JPRB, &
     & 1.56579E-06_JPRB, 1.53445E-06_JPRB, 1.50375E-06_JPRB, 1.47366E-06_JPRB, 1.44417E-06_JPRB, &
     & 1.41527E-06_JPRB, 1.38695E-06_JPRB, 1.35919E-06_JPRB, 1.33199E-06_JPRB, 1.30534E-06_JPRB, &
     & 1.27922E-06_JPRB, 1.25362E-06_JPRB, 1.22853E-06_JPRB, 1.20395E-06_JPRB/)
       KAO_MN2( 8, :,15) = (/ &
     & 1.73231E-06_JPRB, 1.69765E-06_JPRB, 1.66368E-06_JPRB, 1.63039E-06_JPRB, 1.59776E-06_JPRB, &
     & 1.56579E-06_JPRB, 1.53445E-06_JPRB, 1.50375E-06_JPRB, 1.47366E-06_JPRB, 1.44417E-06_JPRB, &
     & 1.41527E-06_JPRB, 1.38695E-06_JPRB, 1.35919E-06_JPRB, 1.33199E-06_JPRB, 1.30534E-06_JPRB, &
     & 1.27922E-06_JPRB, 1.25362E-06_JPRB, 1.22853E-06_JPRB, 1.20395E-06_JPRB/)
       KAO_MN2( 9, :,15) = (/ &
     & 1.71602E-06_JPRB, 1.68499E-06_JPRB, 1.65452E-06_JPRB, 1.62461E-06_JPRB, 1.59523E-06_JPRB, &
     & 1.56639E-06_JPRB, 1.53807E-06_JPRB, 1.51026E-06_JPRB, 1.48295E-06_JPRB, 1.45614E-06_JPRB, &
     & 1.42981E-06_JPRB, 1.40395E-06_JPRB, 1.37857E-06_JPRB, 1.35364E-06_JPRB, 1.32917E-06_JPRB, &
     & 1.30513E-06_JPRB, 1.28153E-06_JPRB, 1.25836E-06_JPRB, 1.23561E-06_JPRB/)
       KAO_MN2( 1, :,16) = (/ &
     & 1.73310E-06_JPRB, 1.69826E-06_JPRB, 1.66413E-06_JPRB, 1.63069E-06_JPRB, 1.59791E-06_JPRB, &
     & 1.56580E-06_JPRB, 1.53433E-06_JPRB, 1.50349E-06_JPRB, 1.47328E-06_JPRB, 1.44367E-06_JPRB, &
     & 1.41465E-06_JPRB, 1.38622E-06_JPRB, 1.35836E-06_JPRB, 1.33106E-06_JPRB, 1.30431E-06_JPRB, &
     & 1.27810E-06_JPRB, 1.25241E-06_JPRB, 1.22724E-06_JPRB, 1.20257E-06_JPRB/)
       KAO_MN2( 2, :,16) = (/ &
     & 1.73310E-06_JPRB, 1.69826E-06_JPRB, 1.66413E-06_JPRB, 1.63069E-06_JPRB, 1.59791E-06_JPRB, &
     & 1.56580E-06_JPRB, 1.53433E-06_JPRB, 1.50349E-06_JPRB, 1.47328E-06_JPRB, 1.44367E-06_JPRB, &
     & 1.41465E-06_JPRB, 1.38622E-06_JPRB, 1.35836E-06_JPRB, 1.33106E-06_JPRB, 1.30431E-06_JPRB, &
     & 1.27810E-06_JPRB, 1.25241E-06_JPRB, 1.22724E-06_JPRB, 1.20257E-06_JPRB/)
       KAO_MN2( 3, :,16) = (/ &
     & 1.73310E-06_JPRB, 1.69826E-06_JPRB, 1.66413E-06_JPRB, 1.63069E-06_JPRB, 1.59791E-06_JPRB, &
     & 1.56580E-06_JPRB, 1.53433E-06_JPRB, 1.50349E-06_JPRB, 1.47328E-06_JPRB, 1.44367E-06_JPRB, &
     & 1.41465E-06_JPRB, 1.38622E-06_JPRB, 1.35836E-06_JPRB, 1.33106E-06_JPRB, 1.30431E-06_JPRB, &
     & 1.27810E-06_JPRB, 1.25241E-06_JPRB, 1.22724E-06_JPRB, 1.20257E-06_JPRB/)
       KAO_MN2( 4, :,16) = (/ &
     & 1.73310E-06_JPRB, 1.69826E-06_JPRB, 1.66413E-06_JPRB, 1.63069E-06_JPRB, 1.59791E-06_JPRB, &
     & 1.56580E-06_JPRB, 1.53433E-06_JPRB, 1.50349E-06_JPRB, 1.47328E-06_JPRB, 1.44367E-06_JPRB, &
     & 1.41465E-06_JPRB, 1.38622E-06_JPRB, 1.35836E-06_JPRB, 1.33106E-06_JPRB, 1.30431E-06_JPRB, &
     & 1.27810E-06_JPRB, 1.25241E-06_JPRB, 1.22724E-06_JPRB, 1.20257E-06_JPRB/)
       KAO_MN2( 5, :,16) = (/ &
     & 1.73310E-06_JPRB, 1.69826E-06_JPRB, 1.66413E-06_JPRB, 1.63069E-06_JPRB, 1.59791E-06_JPRB, &
     & 1.56580E-06_JPRB, 1.53433E-06_JPRB, 1.50349E-06_JPRB, 1.47328E-06_JPRB, 1.44367E-06_JPRB, &
     & 1.41465E-06_JPRB, 1.38622E-06_JPRB, 1.35836E-06_JPRB, 1.33106E-06_JPRB, 1.30431E-06_JPRB, &
     & 1.27810E-06_JPRB, 1.25241E-06_JPRB, 1.22724E-06_JPRB, 1.20257E-06_JPRB/)
       KAO_MN2( 6, :,16) = (/ &
     & 1.73310E-06_JPRB, 1.69826E-06_JPRB, 1.66413E-06_JPRB, 1.63069E-06_JPRB, 1.59791E-06_JPRB, &
     & 1.56580E-06_JPRB, 1.53433E-06_JPRB, 1.50349E-06_JPRB, 1.47328E-06_JPRB, 1.44367E-06_JPRB, &
     & 1.41465E-06_JPRB, 1.38622E-06_JPRB, 1.35836E-06_JPRB, 1.33106E-06_JPRB, 1.30431E-06_JPRB, &
     & 1.27810E-06_JPRB, 1.25241E-06_JPRB, 1.22724E-06_JPRB, 1.20257E-06_JPRB/)
       KAO_MN2( 7, :,16) = (/ &
     & 1.73310E-06_JPRB, 1.69826E-06_JPRB, 1.66413E-06_JPRB, 1.63069E-06_JPRB, 1.59791E-06_JPRB, &
     & 1.56580E-06_JPRB, 1.53433E-06_JPRB, 1.50349E-06_JPRB, 1.47328E-06_JPRB, 1.44367E-06_JPRB, &
     & 1.41465E-06_JPRB, 1.38622E-06_JPRB, 1.35836E-06_JPRB, 1.33106E-06_JPRB, 1.30431E-06_JPRB, &
     & 1.27810E-06_JPRB, 1.25241E-06_JPRB, 1.22724E-06_JPRB, 1.20257E-06_JPRB/)
       KAO_MN2( 8, :,16) = (/ &
     & 1.73310E-06_JPRB, 1.69826E-06_JPRB, 1.66413E-06_JPRB, 1.63069E-06_JPRB, 1.59791E-06_JPRB, &
     & 1.56580E-06_JPRB, 1.53433E-06_JPRB, 1.50349E-06_JPRB, 1.47328E-06_JPRB, 1.44367E-06_JPRB, &
     & 1.41465E-06_JPRB, 1.38622E-06_JPRB, 1.35836E-06_JPRB, 1.33106E-06_JPRB, 1.30431E-06_JPRB, &
     & 1.27810E-06_JPRB, 1.25241E-06_JPRB, 1.22724E-06_JPRB, 1.20257E-06_JPRB/)
       KAO_MN2( 9, :,16) = (/ &
     & 1.79375E-06_JPRB, 1.75599E-06_JPRB, 1.71903E-06_JPRB, 1.68284E-06_JPRB, 1.64741E-06_JPRB, &
     & 1.61273E-06_JPRB, 1.57878E-06_JPRB, 1.54554E-06_JPRB, 1.51301E-06_JPRB, 1.48116E-06_JPRB, &
     & 1.44998E-06_JPRB, 1.41945E-06_JPRB, 1.38957E-06_JPRB, 1.36032E-06_JPRB, 1.33168E-06_JPRB, &
     & 1.30365E-06_JPRB, 1.27620E-06_JPRB, 1.24934E-06_JPRB, 1.22304E-06_JPRB/)

!     The array FORREFO contains the coefficient of the water vapor
!     foreign-continuum (including the energy term).  The first 
!     index refers to reference temperature (296,260,224,260) and 
!     pressure (970,475,219,3 mbar) levels.  The second index 
!     runs over the g-channel (1 to 16).

      FORREFO(1,:) = (/ &
     &1.1755E-06_JPRB,6.5398E-07_JPRB,4.3915E-07_JPRB,3.0753E-07_JPRB,1.9677E-07_JPRB,1.4362E-07_JPRB, &
     &9.4598E-08_JPRB,1.1848E-07_JPRB,1.4280E-07_JPRB,1.5821E-07_JPRB,1.5816E-07_JPRB,1.5769E-07_JPRB, &
     &1.5844E-07_JPRB,1.6016E-07_JPRB,1.6232E-07_JPRB,1.6320E-07_JPRB/)
      FORREFO(2,:) = (/ &
     &1.0703E-06_JPRB,6.2783E-07_JPRB,4.7122E-07_JPRB,2.6300E-07_JPRB,1.8538E-07_JPRB,1.5076E-07_JPRB, &
     &1.9474E-07_JPRB,2.9543E-07_JPRB,2.0093E-07_JPRB,1.5819E-07_JPRB,1.5826E-07_JPRB,1.5737E-07_JPRB, &
     &1.5751E-07_JPRB,1.5910E-07_JPRB,1.6181E-07_JPRB,1.6320E-07_JPRB/)
      FORREFO(3,:) = (/ &
     &1.0470E-06_JPRB,5.8184E-07_JPRB,4.8218E-07_JPRB,2.7771E-07_JPRB,1.9036E-07_JPRB,1.5737E-07_JPRB, &
     &1.8633E-07_JPRB,2.5754E-07_JPRB,4.0647E-07_JPRB,1.5839E-07_JPRB,1.5914E-07_JPRB,1.5788E-07_JPRB, &
     &1.5731E-07_JPRB,1.5836E-07_JPRB,1.6103E-07_JPRB,1.6320E-07_JPRB/)
      FORREFO(4,:) = (/ &
     &1.3891E-06_JPRB,5.4901E-07_JPRB,2.8850E-07_JPRB,1.9176E-07_JPRB,1.4549E-07_JPRB,1.3603E-07_JPRB, &
     &1.7472E-07_JPRB,2.9796E-07_JPRB,3.2452E-07_JPRB,2.5231E-07_JPRB,2.8195E-07_JPRB,1.5527E-07_JPRB, &
     &1.5507E-07_JPRB,1.5442E-07_JPRB,1.5275E-07_JPRB,1.6057E-07_JPRB/)


!     The array SELFREFO contains the coefficient of the water vapor
!     self-continuum (including the energy term).  The first index
!     refers to temperature in 7.2 degree increments.  For instance,
!     JT = 1 refers to a temperature of 245.6, JT = 2 refers to 252.8,
!     etc.  The second index runs over the g-channel (1 to 16).

     SELFREFO(:, 1) = (/ &
     & 1.73980E-03_JPRB, 1.41928E-03_JPRB, 1.15780E-03_JPRB, 9.44496E-04_JPRB, 7.70490E-04_JPRB, &
     & 6.28541E-04_JPRB, 5.12744E-04_JPRB, 4.18280E-04_JPRB, 3.41219E-04_JPRB, 2.78356E-04_JPRB/)
      SELFREFO(:, 2) = (/ &
     & 1.84082E-03_JPRB, 1.50228E-03_JPRB, 1.22600E-03_JPRB, 1.00053E-03_JPRB, 8.16525E-04_JPRB, &
     & 6.66359E-04_JPRB, 5.43811E-04_JPRB, 4.43800E-04_JPRB, 3.62182E-04_JPRB, 2.95574E-04_JPRB/)
      SELFREFO(:, 3) = (/ &
     & 1.92957E-03_JPRB, 1.57727E-03_JPRB, 1.28930E-03_JPRB, 1.05390E-03_JPRB, 8.61484E-04_JPRB, &
     & 7.04197E-04_JPRB, 5.75627E-04_JPRB, 4.70530E-04_JPRB, 3.84622E-04_JPRB, 3.14399E-04_JPRB/)
      SELFREFO(:, 4) = (/ &
     & 2.12958E-03_JPRB, 1.73572E-03_JPRB, 1.41470E-03_JPRB, 1.15305E-03_JPRB, 9.39798E-04_JPRB, &
     & 7.65984E-04_JPRB, 6.24317E-04_JPRB, 5.08850E-04_JPRB, 4.14739E-04_JPRB, 3.38034E-04_JPRB/)
      SELFREFO(:, 5) = (/ &
     & 2.30636E-03_JPRB, 1.88401E-03_JPRB, 1.53900E-03_JPRB, 1.25717E-03_JPRB, 1.02695E-03_JPRB, &
     & 8.38891E-04_JPRB, 6.85270E-04_JPRB, 5.59780E-04_JPRB, 4.57270E-04_JPRB, 3.73533E-04_JPRB/)
      SELFREFO(:, 6) = (/ &
     & 2.47824E-03_JPRB, 2.03278E-03_JPRB, 1.66740E-03_JPRB, 1.36769E-03_JPRB, 1.12185E-03_JPRB, &
     & 9.20206E-04_JPRB, 7.54803E-04_JPRB, 6.19130E-04_JPRB, 5.07844E-04_JPRB, 4.16561E-04_JPRB/)
      SELFREFO(:, 7) = (/ &
     & 2.54196E-03_JPRB, 2.10768E-03_JPRB, 1.74760E-03_JPRB, 1.44904E-03_JPRB, 1.20148E-03_JPRB, &
     & 9.96215E-04_JPRB, 8.26019E-04_JPRB, 6.84900E-04_JPRB, 5.67890E-04_JPRB, 4.70870E-04_JPRB/)
      SELFREFO(:, 8) = (/ &
     & 2.52650E-03_JPRB, 2.11773E-03_JPRB, 1.77510E-03_JPRB, 1.48790E-03_JPRB, 1.24717E-03_JPRB, &
     & 1.04539E-03_JPRB, 8.76251E-04_JPRB, 7.34480E-04_JPRB, 6.15646E-04_JPRB, 5.16039E-04_JPRB/)
      SELFREFO(:, 9) = (/ &
     & 2.82351E-03_JPRB, 2.34652E-03_JPRB, 1.95010E-03_JPRB, 1.62065E-03_JPRB, 1.34686E-03_JPRB, &
     & 1.11933E-03_JPRB, 9.30232E-04_JPRB, 7.73080E-04_JPRB, 6.42477E-04_JPRB, 5.33939E-04_JPRB/)
      SELFREFO(:,10) = (/ &
     & 2.98189E-03_JPRB, 2.46741E-03_JPRB, 2.04170E-03_JPRB, 1.68944E-03_JPRB, 1.39795E-03_JPRB, &
     & 1.15676E-03_JPRB, 9.57176E-04_JPRB, 7.92030E-04_JPRB, 6.55377E-04_JPRB, 5.42302E-04_JPRB/)
      SELFREFO(:,11) = (/ &
     & 2.98239E-03_JPRB, 2.46774E-03_JPRB, 2.04190E-03_JPRB, 1.68954E-03_JPRB, 1.39799E-03_JPRB, &
     & 1.15675E-03_JPRB, 9.57137E-04_JPRB, 7.91970E-04_JPRB, 6.55305E-04_JPRB, 5.42224E-04_JPRB/)
      SELFREFO(:,12) = (/ &
     & 2.97833E-03_JPRB, 2.46461E-03_JPRB, 2.03950E-03_JPRB, 1.68772E-03_JPRB, 1.39661E-03_JPRB, &
     & 1.15571E-03_JPRB, 9.56370E-04_JPRB, 7.91410E-04_JPRB, 6.54903E-04_JPRB, 5.41942E-04_JPRB/)
      SELFREFO(:,13) = (/ &
     & 2.97779E-03_JPRB, 2.46463E-03_JPRB, 2.03990E-03_JPRB, 1.68836E-03_JPRB, 1.39741E-03_JPRB, &
     & 1.15659E-03_JPRB, 9.57278E-04_JPRB, 7.92310E-04_JPRB, 6.55771E-04_JPRB, 5.42762E-04_JPRB/)
      SELFREFO(:,14) = (/ &
     & 2.98326E-03_JPRB, 2.46943E-03_JPRB, 2.04410E-03_JPRB, 1.69203E-03_JPRB, 1.40060E-03_JPRB, &
     & 1.15936E-03_JPRB, 9.59673E-04_JPRB, 7.94380E-04_JPRB, 6.57557E-04_JPRB, 5.44301E-04_JPRB/)
      SELFREFO(:,15) = (/ &
     & 2.99407E-03_JPRB, 2.47825E-03_JPRB, 2.05130E-03_JPRB, 1.69790E-03_JPRB, 1.40539E-03_JPRB, &
     & 1.16327E-03_JPRB, 9.62862E-04_JPRB, 7.96980E-04_JPRB, 6.59676E-04_JPRB, 5.46028E-04_JPRB/)
      SELFREFO(:,16) = (/ &
     & 3.00005E-03_JPRB, 2.48296E-03_JPRB, 2.05500E-03_JPRB, 1.70080E-03_JPRB, 1.40765E-03_JPRB, &
     & 1.16503E-03_JPRB, 9.64224E-04_JPRB, 7.98030E-04_JPRB, 6.60481E-04_JPRB, 5.46641E-04_JPRB/)


!IF (LHOOK) CALL DR_HOOK('RRTM_KGB15',1,ZHOOK_HANDLE)
RETURN

1001 CONTINUE
CALL ABOR1("RRTM_KGB15:ERROR READING FILE RADRRTM")

END SUBROUTINE RRTM_KGB15
