SUBROUTINE RRTM_KGB13

!     Originally by Eli J. Mlawer, Atmospheric & Environmental Research.
!     BAND 13:  2080-2250 cm-1 (low - H2O,N2O; high - nothing)
!     Reformatted for F90 by JJMorcrette, ECMWF
!     R. Elkhatib 12-10-2005 Split for faster and more robust compilation.
!     G.Mozdzynski March 2011 read constants from files
!     ABozzo 201306 updated to rrtmg v4.85
!     T. Wilhelmsson and K. Yessad (Oct 2013) Geometry and setup refactoring.
!     ------------------------------------------------------------------

USE PARKIND1  ,ONLY : JPRB
!USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE YOMLUN    ,ONLY : NULRAD
USE YOMMP0    , ONLY : NPROC, MYPROC
USE MPL_MODULE,ONLY : MPL_BROADCAST
USE YOMTAG    ,ONLY : MTAGRAD

USE YOERRTO13, ONLY : KAO     ,KAO_D,SELFREFO, FORREFO ,FRACREFAO, FRACREFBO, KAO_MCO2, KAO_MCO,KBO_MO3


!     ------------------------------------------------------------------

IMPLICIT NONE
!REAL(KIND=JPRB) :: ZHOOK_HANDLE

#include "abor1.intfb.h"

!IF (LHOOK) CALL DR_HOOK('RRTM_KGB13',0,ZHOOK_HANDLE)

IF( MYPROC==1 )THEN
  READ(NULRAD,ERR=1001) KAO_D
  KAO = REAL(KAO_D,JPRB)
ENDIF
IF( NPROC>1 )THEN
  CALL MPL_BROADCAST (KAO,MTAGRAD,1,CDSTRING='RRTM_KGB13:')
ENDIF

! Planck fraction mapping level : P=473.4280 mb, T = 259.83 K      
      FRACREFAO(:, 1) = (/ &
     &  1.7534E-01_JPRB,1.7394E-01_JPRB,1.6089E-01_JPRB,1.3782E-01_JPRB,1.0696E-01_JPRB,8.5853E-02_JPRB, &
     &  6.6548E-02_JPRB,4.9053E-02_JPRB,3.2064E-02_JPRB,3.4820E-03_JPRB,2.8763E-03_JPRB,2.2204E-03_JPRB, &
     &  1.5612E-03_JPRB,9.8572E-04_JPRB,3.6853E-04_JPRB,5.1612E-05_JPRB/)
      FRACREFAO(:, 2) = (/ &
     &  1.7489E-01_JPRB,1.7309E-01_JPRB,1.5981E-01_JPRB,1.3782E-01_JPRB,1.0797E-01_JPRB,8.6367E-02_JPRB, &
     &  6.7042E-02_JPRB,4.9257E-02_JPRB,3.2207E-02_JPRB,3.4820E-03_JPRB,2.8767E-03_JPRB,2.2203E-03_JPRB, &
     &  1.5613E-03_JPRB,9.8571E-04_JPRB,3.6853E-04_JPRB,5.1612E-05_JPRB/)
      FRACREFAO(:, 3) = (/ &
     &  1.7459E-01_JPRB,1.7259E-01_JPRB,1.5948E-01_JPRB,1.3694E-01_JPRB,1.0815E-01_JPRB,8.7376E-02_JPRB, &
     &  6.7339E-02_JPRB,4.9541E-02_JPRB,3.2333E-02_JPRB,3.5019E-03_JPRB,2.8958E-03_JPRB,2.2527E-03_JPRB, &
     &  1.6099E-03_JPRB,9.8574E-04_JPRB,3.6853E-04_JPRB,5.1612E-05_JPRB/)
      FRACREFAO(:, 4) = (/ &
     &  1.7391E-01_JPRB,1.7244E-01_JPRB,1.5921E-01_JPRB,1.3644E-01_JPRB,1.0787E-01_JPRB,8.7776E-02_JPRB, &
     &  6.8361E-02_JPRB,4.9628E-02_JPRB,3.2578E-02_JPRB,3.5117E-03_JPRB,2.9064E-03_JPRB,2.2571E-03_JPRB, &
     &  1.6887E-03_JPRB,1.0045E-03_JPRB,3.6853E-04_JPRB,5.1612E-05_JPRB/)
      FRACREFAO(:, 5) = (/ &
     &  1.7338E-01_JPRB,1.7157E-01_JPRB,1.5957E-01_JPRB,1.3571E-01_JPRB,1.0773E-01_JPRB,8.7966E-02_JPRB, &
     &  6.9000E-02_JPRB,5.0300E-02_JPRB,3.2813E-02_JPRB,3.5470E-03_JPRB,2.9425E-03_JPRB,2.2552E-03_JPRB, &
     &  1.7038E-03_JPRB,1.1025E-03_JPRB,3.6853E-04_JPRB,5.1612E-05_JPRB/)
      FRACREFAO(:, 6) = (/ &
     &  1.7230E-01_JPRB,1.7082E-01_JPRB,1.5917E-01_JPRB,1.3562E-01_JPRB,1.0806E-01_JPRB,8.7635E-02_JPRB, &
     &  6.9815E-02_JPRB,5.1155E-02_JPRB,3.3139E-02_JPRB,3.6264E-03_JPRB,2.9436E-03_JPRB,2.3417E-03_JPRB, &
     &  1.7731E-03_JPRB,1.1156E-03_JPRB,4.4533E-04_JPRB,5.1612E-05_JPRB/)
      FRACREFAO(:, 7) = (/ &
     &  1.7073E-01_JPRB,1.6961E-01_JPRB,1.5844E-01_JPRB,1.3594E-01_JPRB,1.0821E-01_JPRB,8.7791E-02_JPRB, &
     &  7.0502E-02_JPRB,5.1904E-02_JPRB,3.4107E-02_JPRB,3.5888E-03_JPRB,2.9574E-03_JPRB,2.5851E-03_JPRB, &
     &  1.9127E-03_JPRB,1.1537E-03_JPRB,4.7789E-04_JPRB,1.0016E-04_JPRB/)
      FRACREFAO(:, 8) = (/ &
     &  1.6700E-01_JPRB,1.6848E-01_JPRB,1.5628E-01_JPRB,1.3448E-01_JPRB,1.1011E-01_JPRB,8.9016E-02_JPRB, &
     &  7.1973E-02_JPRB,5.2798E-02_JPRB,3.5650E-02_JPRB,3.8534E-03_JPRB,3.4142E-03_JPRB,2.7799E-03_JPRB, &
     &  2.1288E-03_JPRB,1.3043E-03_JPRB,6.2858E-04_JPRB,1.0016E-04_JPRB/)
      FRACREFAO(:, 9) = (/ &
     &  1.6338E-01_JPRB,1.5565E-01_JPRB,1.4470E-01_JPRB,1.3500E-01_JPRB,1.1909E-01_JPRB,9.8312E-02_JPRB, &
     &  7.9023E-02_JPRB,5.5728E-02_JPRB,3.6831E-02_JPRB,3.6569E-03_JPRB,3.0552E-03_JPRB,2.3431E-03_JPRB, &
     &  1.7088E-03_JPRB,1.1082E-03_JPRB,3.6829E-04_JPRB,5.1612E-05_JPRB/)

! Planck fraction mapping level : P=4.758820 mb, T = 250.85 K
      FRACREFBO(:) = (/ &
     &  1.5411E-01_JPRB,1.3573E-01_JPRB,1.2527E-01_JPRB,1.2698E-01_JPRB,1.2394E-01_JPRB,1.0876E-01_JPRB, &
     &  8.9906E-02_JPRB,6.9551E-02_JPRB,4.8240E-02_JPRB,5.2434E-03_JPRB,4.3630E-03_JPRB,3.4262E-03_JPRB, &
     &  2.5124E-03_JPRB,1.5479E-03_JPRB,3.7294E-04_JPRB,5.1050E-05_JPRB/)


!     ------------------------------------------------------------------

!     The array KAO contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels> ~100mb, temperatures, and binary
!     species parameters (see taumol.f for definition).  The first 
!     index in the array, JS, runs from 1 to 9, and corresponds to 
!     different values of the binary species parameter.  For instance, 
!     JS=1 refers to dry air, JS = 2 corresponds to the paramter value 1/8, 
!     JS = 3 corresponds to the parameter value 2/8, etc.  The second index
!     in the array, JT, which runs from 1 to 5, corresponds to different
!     temperatures.  More specifically, JT = 3 means that the data are for
!     the reference temperature TREF for this  pressure level, JT = 2 refers
!     to TREF-15, JT = 1 is for TREF-30, JT = 4 is for TREF+15, and JT = 5
!     is for TREF+30.  The third index, JP, runs from 1 to 13 and refers
!     to the JPth reference pressure level (see taumol.f for these levels
!     in mb).  The fourth index, IG, goes from 1 to 16, and indicates
!     which g-interval the absorption coefficients are for.


!     The array KAO_Mxx contains the absorption coefficient for 
!     a minor species at the 16 chosen g-values for a reference pressure
!     level below 100~ mb.   The first index in the array, JS, runs
!     from 1 to 10, and corresponds to different gas column amount ratios,
!     as expressed through the binary species parameter eta, defined as
!     eta = gas1/(gas1 + (rat) * gas2), where rat is the 
!     ratio of the reference MLS column amount value of gas 1 
!     to that of gas2.  The second index refers to temperature 
!     in 7.2 degree increments.  For instance, JT = 1 refers to a 
!     temperature of 188.0, JT = 2 refers to 195.2, etc. The third index 
!     runs over the g-channel (1 to 16).

      KAO_MCO2( 1, :, 1) = (/ &
     & 1.09539E-04_JPRB, 1.17067E-04_JPRB, 1.25113E-04_JPRB, 1.33712E-04_JPRB, 1.42902E-04_JPRB, &
     & 1.52724E-04_JPRB, 1.63221E-04_JPRB, 1.74439E-04_JPRB, 1.86428E-04_JPRB, 1.99241E-04_JPRB, &
     & 2.12934E-04_JPRB, 2.27569E-04_JPRB, 2.43210E-04_JPRB, 2.59926E-04_JPRB, 2.77790E-04_JPRB, &
     & 2.96883E-04_JPRB, 3.17287E-04_JPRB, 3.39094E-04_JPRB, 3.62400E-04_JPRB/)
      KAO_MCO2( 2, :, 1) = (/ &
     & 1.25202E-04_JPRB, 1.34718E-04_JPRB, 1.44957E-04_JPRB, 1.55974E-04_JPRB, 1.67829E-04_JPRB, &
     & 1.80585E-04_JPRB, 1.94311E-04_JPRB, 2.09079E-04_JPRB, 2.24971E-04_JPRB, 2.42069E-04_JPRB, &
     & 2.60468E-04_JPRB, 2.80265E-04_JPRB, 3.01567E-04_JPRB, 3.24488E-04_JPRB, 3.49150E-04_JPRB, &
     & 3.75688E-04_JPRB, 4.04242E-04_JPRB, 4.34966E-04_JPRB, 4.68026E-04_JPRB/)
      KAO_MCO2( 3, :, 1) = (/ &
     & 1.12112E-04_JPRB, 1.21090E-04_JPRB, 1.30786E-04_JPRB, 1.41259E-04_JPRB, 1.52571E-04_JPRB, &
     & 1.64788E-04_JPRB, 1.77984E-04_JPRB, 1.92237E-04_JPRB, 2.07631E-04_JPRB, 2.24257E-04_JPRB, &
     & 2.42215E-04_JPRB, 2.61611E-04_JPRB, 2.82560E-04_JPRB, 3.05187E-04_JPRB, 3.29625E-04_JPRB, &
     & 3.56021E-04_JPRB, 3.84530E-04_JPRB, 4.15322E-04_JPRB, 4.48580E-04_JPRB/)
      KAO_MCO2( 4, :, 1) = (/ &
     & 9.74130E-05_JPRB, 1.05372E-04_JPRB, 1.13982E-04_JPRB, 1.23295E-04_JPRB, 1.33369E-04_JPRB, &
     & 1.44265E-04_JPRB, 1.56053E-04_JPRB, 1.68803E-04_JPRB, 1.82595E-04_JPRB, 1.97514E-04_JPRB, &
     & 2.13652E-04_JPRB, 2.31109E-04_JPRB, 2.49992E-04_JPRB, 2.70418E-04_JPRB, 2.92512E-04_JPRB, &
     & 3.16412E-04_JPRB, 3.42265E-04_JPRB, 3.70230E-04_JPRB, 4.00479E-04_JPRB/)
      KAO_MCO2( 5, :, 1) = (/ &
     & 8.71018E-05_JPRB, 9.40759E-05_JPRB, 1.01608E-04_JPRB, 1.09744E-04_JPRB, 1.18531E-04_JPRB, &
     & 1.28022E-04_JPRB, 1.38272E-04_JPRB, 1.49343E-04_JPRB, 1.61301E-04_JPRB, 1.74216E-04_JPRB, &
     & 1.88166E-04_JPRB, 2.03232E-04_JPRB, 2.19504E-04_JPRB, 2.37079E-04_JPRB, 2.56062E-04_JPRB, &
     & 2.76565E-04_JPRB, 2.98709E-04_JPRB, 3.22626E-04_JPRB, 3.48458E-04_JPRB/)
      KAO_MCO2( 6, :, 1) = (/ &
     & 7.55256E-05_JPRB, 8.17414E-05_JPRB, 8.84688E-05_JPRB, 9.57500E-05_JPRB, 1.03630E-04_JPRB, &
     & 1.12159E-04_JPRB, 1.21390E-04_JPRB, 1.31381E-04_JPRB, 1.42193E-04_JPRB, 1.53896E-04_JPRB, &
     & 1.66562E-04_JPRB, 1.80270E-04_JPRB, 1.95107E-04_JPRB, 2.11164E-04_JPRB, 2.28543E-04_JPRB, &
     & 2.47353E-04_JPRB, 2.67710E-04_JPRB, 2.89743E-04_JPRB, 3.13589E-04_JPRB/)
      KAO_MCO2( 7, :, 1) = (/ &
     & 5.31515E-05_JPRB, 6.06869E-05_JPRB, 6.92907E-05_JPRB, 7.91143E-05_JPRB, 9.03306E-05_JPRB, &
     & 1.03137E-04_JPRB, 1.17759E-04_JPRB, 1.34454E-04_JPRB, 1.53516E-04_JPRB, 1.75281E-04_JPRB, &
     & 2.00131E-04_JPRB, 2.28504E-04_JPRB, 2.60900E-04_JPRB, 2.97888E-04_JPRB, 3.40121E-04_JPRB, &
     & 3.88341E-04_JPRB, 4.43397E-04_JPRB, 5.06259E-04_JPRB, 5.78033E-04_JPRB/)
      KAO_MCO2( 8, :, 1) = (/ &
     & 2.52471E-04_JPRB, 2.96005E-04_JPRB, 3.47045E-04_JPRB, 4.06886E-04_JPRB, 4.77045E-04_JPRB, &
     & 5.59302E-04_JPRB, 6.55742E-04_JPRB, 7.68811E-04_JPRB, 9.01377E-04_JPRB, 1.05680E-03_JPRB, &
     & 1.23902E-03_JPRB, 1.45267E-03_JPRB, 1.70315E-03_JPRB, 1.99683E-03_JPRB, 2.34114E-03_JPRB, &
     & 2.74482E-03_JPRB, 3.21811E-03_JPRB, 3.77300E-03_JPRB, 4.42358E-03_JPRB/)
      KAO_MCO2( 9, :, 1) = (/ &
     & 4.06711E-05_JPRB, 4.53161E-05_JPRB, 5.04917E-05_JPRB, 5.62583E-05_JPRB, 6.26836E-05_JPRB, &
     & 6.98427E-05_JPRB, 7.78194E-05_JPRB, 8.67071E-05_JPRB, 9.66100E-05_JPRB, 1.07644E-04_JPRB, &
     & 1.19938E-04_JPRB, 1.33636E-04_JPRB, 1.48898E-04_JPRB, 1.65904E-04_JPRB, 1.84852E-04_JPRB, &
     & 2.05964E-04_JPRB, 2.29487E-04_JPRB, 2.55697E-04_JPRB, 2.84900E-04_JPRB/)
      KAO_MCO2( 1, :, 2) = (/ &
     & 2.01759E-04_JPRB, 2.15641E-04_JPRB, 2.30478E-04_JPRB, 2.46336E-04_JPRB, 2.63285E-04_JPRB, &
     & 2.81400E-04_JPRB, 3.00761E-04_JPRB, 3.21455E-04_JPRB, 3.43573E-04_JPRB, 3.67212E-04_JPRB, &
     & 3.92477E-04_JPRB, 4.19482E-04_JPRB, 4.48344E-04_JPRB, 4.79192E-04_JPRB, 5.12162E-04_JPRB, &
     & 5.47401E-04_JPRB, 5.85064E-04_JPRB, 6.25319E-04_JPRB, 6.68343E-04_JPRB/)
      KAO_MCO2( 2, :, 2) = (/ &
     & 2.53461E-04_JPRB, 2.70916E-04_JPRB, 2.89574E-04_JPRB, 3.09516E-04_JPRB, 3.30832E-04_JPRB, &
     & 3.53616E-04_JPRB, 3.77969E-04_JPRB, 4.03999E-04_JPRB, 4.31822E-04_JPRB, 4.61561E-04_JPRB, &
     & 4.93348E-04_JPRB, 5.27324E-04_JPRB, 5.63640E-04_JPRB, 6.02457E-04_JPRB, 6.43948E-04_JPRB, &
     & 6.88295E-04_JPRB, 7.35697E-04_JPRB, 7.86364E-04_JPRB, 8.40519E-04_JPRB/)
      KAO_MCO2( 3, :, 2) = (/ &
     & 2.58821E-04_JPRB, 2.76943E-04_JPRB, 2.96334E-04_JPRB, 3.17082E-04_JPRB, 3.39283E-04_JPRB, &
     & 3.63038E-04_JPRB, 3.88457E-04_JPRB, 4.15655E-04_JPRB, 4.44758E-04_JPRB, 4.75899E-04_JPRB, &
     & 5.09220E-04_JPRB, 5.44874E-04_JPRB, 5.83024E-04_JPRB, 6.23845E-04_JPRB, 6.67525E-04_JPRB, &
     & 7.14263E-04_JPRB, 7.64273E-04_JPRB, 8.17785E-04_JPRB, 8.75043E-04_JPRB/)
      KAO_MCO2( 4, :, 2) = (/ &
     & 2.46588E-04_JPRB, 2.64630E-04_JPRB, 2.83993E-04_JPRB, 3.04771E-04_JPRB, 3.27071E-04_JPRB, &
     & 3.51001E-04_JPRB, 3.76683E-04_JPRB, 4.04244E-04_JPRB, 4.33821E-04_JPRB, 4.65563E-04_JPRB, &
     & 4.99627E-04_JPRB, 5.36183E-04_JPRB, 5.75414E-04_JPRB, 6.17515E-04_JPRB, 6.62697E-04_JPRB, &
     & 7.11185E-04_JPRB, 7.63220E-04_JPRB, 8.19063E-04_JPRB, 8.78991E-04_JPRB/)
      KAO_MCO2( 5, :, 2) = (/ &
     & 2.19140E-04_JPRB, 2.36464E-04_JPRB, 2.55158E-04_JPRB, 2.75330E-04_JPRB, 2.97097E-04_JPRB, &
     & 3.20585E-04_JPRB, 3.45929E-04_JPRB, 3.73277E-04_JPRB, 4.02787E-04_JPRB, 4.34630E-04_JPRB, &
     & 4.68991E-04_JPRB, 5.06068E-04_JPRB, 5.46076E-04_JPRB, 5.89247E-04_JPRB, 6.35831E-04_JPRB, &
     & 6.86097E-04_JPRB, 7.40338E-04_JPRB, 7.98867E-04_JPRB, 8.62022E-04_JPRB/)
      KAO_MCO2( 6, :, 2) = (/ &
     & 1.74073E-04_JPRB, 1.92221E-04_JPRB, 2.12260E-04_JPRB, 2.34388E-04_JPRB, 2.58824E-04_JPRB, &
     & 2.85807E-04_JPRB, 3.15603E-04_JPRB, 3.48505E-04_JPRB, 3.84837E-04_JPRB, 4.24957E-04_JPRB, &
     & 4.69260E-04_JPRB, 5.18181E-04_JPRB, 5.72202E-04_JPRB, 6.31855E-04_JPRB, 6.97727E-04_JPRB, &
     & 7.70466E-04_JPRB, 8.50789E-04_JPRB, 9.39485E-04_JPRB, 1.03743E-03_JPRB/)
      KAO_MCO2( 7, :, 2) = (/ &
     & 1.74359E-04_JPRB, 1.99276E-04_JPRB, 2.27753E-04_JPRB, 2.60299E-04_JPRB, 2.97497E-04_JPRB, &
     & 3.40010E-04_JPRB, 3.88599E-04_JPRB, 4.44130E-04_JPRB, 5.07598E-04_JPRB, 5.80135E-04_JPRB, &
     & 6.63039E-04_JPRB, 7.57789E-04_JPRB, 8.66079E-04_JPRB, 9.89845E-04_JPRB, 1.13130E-03_JPRB, &
     & 1.29296E-03_JPRB, 1.47773E-03_JPRB, 1.68890E-03_JPRB, 1.93025E-03_JPRB/)
      KAO_MCO2( 8, :, 2) = (/ &
     & 1.08215E-03_JPRB, 1.20760E-03_JPRB, 1.34759E-03_JPRB, 1.50382E-03_JPRB, 1.67815E-03_JPRB, &
     & 1.87270E-03_JPRB, 2.08980E-03_JPRB, 2.33206E-03_JPRB, 2.60242E-03_JPRB, 2.90411E-03_JPRB, &
     & 3.24078E-03_JPRB, 3.61648E-03_JPRB, 4.03573E-03_JPRB, 4.50359E-03_JPRB, 5.02568E-03_JPRB, &
     & 5.60830E-03_JPRB, 6.25846E-03_JPRB, 6.98399E-03_JPRB, 7.79363E-03_JPRB/)
      KAO_MCO2( 9, :, 2) = (/ &
     & 1.04969E-04_JPRB, 1.20766E-04_JPRB, 1.38939E-04_JPRB, 1.59848E-04_JPRB, 1.83903E-04_JPRB, &
     & 2.11578E-04_JPRB, 2.43418E-04_JPRB, 2.80049E-04_JPRB, 3.22193E-04_JPRB, 3.70678E-04_JPRB, &
     & 4.26461E-04_JPRB, 4.90638E-04_JPRB, 5.64472E-04_JPRB, 6.49418E-04_JPRB, 7.47147E-04_JPRB, &
     & 8.59583E-04_JPRB, 9.88940E-04_JPRB, 1.13776E-03_JPRB, 1.30898E-03_JPRB/)
      KAO_MCO2( 1, :, 3) = (/ &
     & 3.72106E-04_JPRB, 3.96252E-04_JPRB, 4.21966E-04_JPRB, 4.49347E-04_JPRB, 4.78506E-04_JPRB, &
     & 5.09557E-04_JPRB, 5.42623E-04_JPRB, 5.77834E-04_JPRB, 6.15330E-04_JPRB, 6.55260E-04_JPRB, &
     & 6.97781E-04_JPRB, 7.43060E-04_JPRB, 7.91278E-04_JPRB, 8.42626E-04_JPRB, 8.97304E-04_JPRB, &
     & 9.55532E-04_JPRB, 1.01754E-03_JPRB, 1.08357E-03_JPRB, 1.15388E-03_JPRB/)
      KAO_MCO2( 2, :, 3) = (/ &
     & 4.20563E-04_JPRB, 4.46162E-04_JPRB, 4.73319E-04_JPRB, 5.02130E-04_JPRB, 5.32693E-04_JPRB, &
     & 5.65118E-04_JPRB, 5.99516E-04_JPRB, 6.36007E-04_JPRB, 6.74720E-04_JPRB, 7.15789E-04_JPRB, &
     & 7.59358E-04_JPRB, 8.05579E-04_JPRB, 8.54613E-04_JPRB, 9.06632E-04_JPRB, 9.61817E-04_JPRB, &
     & 1.02036E-03_JPRB, 1.08247E-03_JPRB, 1.14836E-03_JPRB, 1.21826E-03_JPRB/)
      KAO_MCO2( 3, :, 3) = (/ &
     & 4.89664E-04_JPRB, 5.18321E-04_JPRB, 5.48654E-04_JPRB, 5.80764E-04_JPRB, 6.14752E-04_JPRB, &
     & 6.50729E-04_JPRB, 6.88812E-04_JPRB, 7.29124E-04_JPRB, 7.71795E-04_JPRB, 8.16963E-04_JPRB, &
     & 8.64774E-04_JPRB, 9.15384E-04_JPRB, 9.68955E-04_JPRB, 1.02566E-03_JPRB, 1.08569E-03_JPRB, &
     & 1.14922E-03_JPRB, 1.21648E-03_JPRB, 1.28767E-03_JPRB, 1.36303E-03_JPRB/)
      KAO_MCO2( 4, :, 3) = (/ &
     & 4.61143E-04_JPRB, 4.92198E-04_JPRB, 5.25343E-04_JPRB, 5.60720E-04_JPRB, 5.98480E-04_JPRB, &
     & 6.38783E-04_JPRB, 6.81799E-04_JPRB, 7.27713E-04_JPRB, 7.76718E-04_JPRB, 8.29023E-04_JPRB, &
     & 8.84851E-04_JPRB, 9.44438E-04_JPRB, 1.00804E-03_JPRB, 1.07592E-03_JPRB, 1.14837E-03_JPRB, &
     & 1.22571E-03_JPRB, 1.30825E-03_JPRB, 1.39635E-03_JPRB, 1.49038E-03_JPRB/)
      KAO_MCO2( 5, :, 3) = (/ &
     & 4.01988E-04_JPRB, 4.36672E-04_JPRB, 4.74349E-04_JPRB, 5.15278E-04_JPRB, 5.59737E-04_JPRB, &
     & 6.08032E-04_JPRB, 6.60495E-04_JPRB, 7.17484E-04_JPRB, 7.79390E-04_JPRB, 8.46638E-04_JPRB, &
     & 9.19688E-04_JPRB, 9.99041E-04_JPRB, 1.08524E-03_JPRB, 1.17888E-03_JPRB, 1.28059E-03_JPRB, &
     & 1.39109E-03_JPRB, 1.51111E-03_JPRB, 1.64149E-03_JPRB, 1.78313E-03_JPRB/)
      KAO_MCO2( 6, :, 3) = (/ &
     & 3.35536E-04_JPRB, 3.74371E-04_JPRB, 4.17700E-04_JPRB, 4.66045E-04_JPRB, 5.19985E-04_JPRB, &
     & 5.80169E-04_JPRB, 6.47318E-04_JPRB, 7.22238E-04_JPRB, 8.05831E-04_JPRB, 8.99098E-04_JPRB, &
     & 1.00316E-03_JPRB, 1.11927E-03_JPRB, 1.24881E-03_JPRB, 1.39335E-03_JPRB, 1.55461E-03_JPRB, &
     & 1.73455E-03_JPRB, 1.93530E-03_JPRB, 2.15930E-03_JPRB, 2.40921E-03_JPRB/)
      KAO_MCO2( 7, :, 3) = (/ &
     & 3.24677E-04_JPRB, 3.75160E-04_JPRB, 4.33491E-04_JPRB, 5.00893E-04_JPRB, 5.78774E-04_JPRB, &
     & 6.68765E-04_JPRB, 7.72749E-04_JPRB, 8.92900E-04_JPRB, 1.03173E-03_JPRB, 1.19215E-03_JPRB, &
     & 1.37751E-03_JPRB, 1.59170E-03_JPRB, 1.83918E-03_JPRB, 2.12515E-03_JPRB, 2.45558E-03_JPRB, &
     & 2.83738E-03_JPRB, 3.27856E-03_JPRB, 3.78832E-03_JPRB, 4.37735E-03_JPRB/)
      KAO_MCO2( 8, :, 3) = (/ &
     & 2.24656E-03_JPRB, 2.45550E-03_JPRB, 2.68386E-03_JPRB, 2.93347E-03_JPRB, 3.20629E-03_JPRB, &
     & 3.50448E-03_JPRB, 3.83041E-03_JPRB, 4.18665E-03_JPRB, 4.57602E-03_JPRB, 5.00160E-03_JPRB, &
     & 5.46677E-03_JPRB, 5.97519E-03_JPRB, 6.53090E-03_JPRB, 7.13829E-03_JPRB, 7.80217E-03_JPRB, &
     & 8.52780E-03_JPRB, 9.32091E-03_JPRB, 1.01878E-02_JPRB, 1.11353E-02_JPRB/)
      KAO_MCO2( 9, :, 3) = (/ &
     & 2.07746E-04_JPRB, 2.38909E-04_JPRB, 2.74746E-04_JPRB, 3.15959E-04_JPRB, 3.63355E-04_JPRB, &
     & 4.17860E-04_JPRB, 4.80541E-04_JPRB, 5.52625E-04_JPRB, 6.35521E-04_JPRB, 7.30852E-04_JPRB, &
     & 8.40484E-04_JPRB, 9.66561E-04_JPRB, 1.11155E-03_JPRB, 1.27829E-03_JPRB, 1.47004E-03_JPRB, &
     & 1.69055E-03_JPRB, 1.94414E-03_JPRB, 2.23577E-03_JPRB, 2.57115E-03_JPRB/)
      KAO_MCO2( 1, :, 4) = (/ &
     & 7.26052E-04_JPRB, 7.62476E-04_JPRB, 8.00726E-04_JPRB, 8.40896E-04_JPRB, 8.83081E-04_JPRB, &
     & 9.27382E-04_JPRB, 9.73905E-04_JPRB, 1.02276E-03_JPRB, 1.07407E-03_JPRB, 1.12795E-03_JPRB, &
     & 1.18454E-03_JPRB, 1.24396E-03_JPRB, 1.30637E-03_JPRB, 1.37190E-03_JPRB, 1.44073E-03_JPRB, &
     & 1.51300E-03_JPRB, 1.58890E-03_JPRB, 1.66861E-03_JPRB, 1.75232E-03_JPRB/)
      KAO_MCO2( 2, :, 4) = (/ &
     & 4.65815E-04_JPRB, 5.01167E-04_JPRB, 5.39203E-04_JPRB, 5.80126E-04_JPRB, 6.24154E-04_JPRB, &
     & 6.71524E-04_JPRB, 7.22489E-04_JPRB, 7.77322E-04_JPRB, 8.36316E-04_JPRB, 8.99788E-04_JPRB, &
     & 9.68077E-04_JPRB, 1.04155E-03_JPRB, 1.12060E-03_JPRB, 1.20564E-03_JPRB, 1.29714E-03_JPRB, &
     & 1.39559E-03_JPRB, 1.50151E-03_JPRB, 1.61546E-03_JPRB, 1.73807E-03_JPRB/)
      KAO_MCO2( 3, :, 4) = (/ &
     & 3.56225E-04_JPRB, 3.93073E-04_JPRB, 4.33732E-04_JPRB, 4.78598E-04_JPRB, 5.28105E-04_JPRB, &
     & 5.82732E-04_JPRB, 6.43010E-04_JPRB, 7.09524E-04_JPRB, 7.82918E-04_JPRB, 8.63903E-04_JPRB, &
     & 9.53266E-04_JPRB, 1.05187E-03_JPRB, 1.16068E-03_JPRB, 1.28074E-03_JPRB, 1.41322E-03_JPRB, &
     & 1.55941E-03_JPRB, 1.72071E-03_JPRB, 1.89870E-03_JPRB, 2.09511E-03_JPRB/)
      KAO_MCO2( 4, :, 4) = (/ &
     & 3.37845E-04_JPRB, 3.79675E-04_JPRB, 4.26684E-04_JPRB, 4.79514E-04_JPRB, 5.38884E-04_JPRB, &
     & 6.05606E-04_JPRB, 6.80589E-04_JPRB, 7.64855E-04_JPRB, 8.59555E-04_JPRB, 9.65980E-04_JPRB, &
     & 1.08558E-03_JPRB, 1.21999E-03_JPRB, 1.37105E-03_JPRB, 1.54080E-03_JPRB, 1.73157E-03_JPRB, &
     & 1.94597E-03_JPRB, 2.18691E-03_JPRB, 2.45767E-03_JPRB, 2.76197E-03_JPRB/)
      KAO_MCO2( 5, :, 4) = (/ &
     & 3.52456E-04_JPRB, 4.02782E-04_JPRB, 4.60294E-04_JPRB, 5.26017E-04_JPRB, 6.01126E-04_JPRB, &
     & 6.86958E-04_JPRB, 7.85046E-04_JPRB, 8.97140E-04_JPRB, 1.02524E-03_JPRB, 1.17163E-03_JPRB, &
     & 1.33892E-03_JPRB, 1.53010E-03_JPRB, 1.74858E-03_JPRB, 1.99825E-03_JPRB, 2.28358E-03_JPRB, &
     & 2.60964E-03_JPRB, 2.98226E-03_JPRB, 3.40809E-03_JPRB, 3.89471E-03_JPRB/)
      KAO_MCO2( 6, :, 4) = (/ &
     & 4.42884E-04_JPRB, 5.08187E-04_JPRB, 5.83119E-04_JPRB, 6.69100E-04_JPRB, 7.67758E-04_JPRB, &
     & 8.80963E-04_JPRB, 1.01086E-03_JPRB, 1.15991E-03_JPRB, 1.33094E-03_JPRB, 1.52718E-03_JPRB, &
     & 1.75237E-03_JPRB, 2.01075E-03_JPRB, 2.30724E-03_JPRB, 2.64744E-03_JPRB, 3.03780E-03_JPRB, &
     & 3.48572E-03_JPRB, 3.99969E-03_JPRB, 4.58944E-03_JPRB, 5.26614E-03_JPRB/)
      KAO_MCO2( 7, :, 4) = (/ &
     & 8.09850E-04_JPRB, 9.09940E-04_JPRB, 1.02240E-03_JPRB, 1.14876E-03_JPRB, 1.29074E-03_JPRB, &
     & 1.45026E-03_JPRB, 1.62950E-03_JPRB, 1.83089E-03_JPRB, 2.05718E-03_JPRB, 2.31143E-03_JPRB, &
     & 2.59710E-03_JPRB, 2.91808E-03_JPRB, 3.27873E-03_JPRB, 3.68395E-03_JPRB, 4.13926E-03_JPRB, &
     & 4.65083E-03_JPRB, 5.22564E-03_JPRB, 5.87148E-03_JPRB, 6.59715E-03_JPRB/)
      KAO_MCO2( 8, :, 4) = (/ &
     & 3.13265E-03_JPRB, 3.42454E-03_JPRB, 3.74362E-03_JPRB, 4.09243E-03_JPRB, 4.47375E-03_JPRB, &
     & 4.89059E-03_JPRB, 5.34627E-03_JPRB, 5.84441E-03_JPRB, 6.38897E-03_JPRB, 6.98426E-03_JPRB, &
     & 7.63502E-03_JPRB, 8.34642E-03_JPRB, 9.12409E-03_JPRB, 9.97423E-03_JPRB, 1.09036E-02_JPRB, &
     & 1.19195E-02_JPRB, 1.30301E-02_JPRB, 1.42442E-02_JPRB, 1.55714E-02_JPRB/)
      KAO_MCO2( 9, :, 4) = (/ &
     & 5.71287E-04_JPRB, 6.51252E-04_JPRB, 7.42411E-04_JPRB, 8.46330E-04_JPRB, 9.64794E-04_JPRB, &
     & 1.09984E-03_JPRB, 1.25379E-03_JPRB, 1.42929E-03_JPRB, 1.62935E-03_JPRB, 1.85742E-03_JPRB, &
     & 2.11741E-03_JPRB, 2.41380E-03_JPRB, 2.75167E-03_JPRB, 3.13683E-03_JPRB, 3.57591E-03_JPRB, &
     & 4.07645E-03_JPRB, 4.64705E-03_JPRB, 5.29751E-03_JPRB, 6.03903E-03_JPRB/)
      KAO_MCO2( 1, :, 5) = (/ &
     & 2.92395E-04_JPRB, 3.32719E-04_JPRB, 3.78604E-04_JPRB, 4.30818E-04_JPRB, 4.90232E-04_JPRB, &
     & 5.57839E-04_JPRB, 6.34771E-04_JPRB, 7.22312E-04_JPRB, 8.21927E-04_JPRB, 9.35278E-04_JPRB, &
     & 1.06426E-03_JPRB, 1.21104E-03_JPRB, 1.37805E-03_JPRB, 1.56810E-03_JPRB, 1.78435E-03_JPRB, &
     & 2.03043E-03_JPRB, 2.31045E-03_JPRB, 2.62908E-03_JPRB, 2.99166E-03_JPRB/)
      KAO_MCO2( 2, :, 5) = (/ &
     & 3.13069E-04_JPRB, 3.61343E-04_JPRB, 4.17061E-04_JPRB, 4.81371E-04_JPRB, 5.55597E-04_JPRB, &
     & 6.41269E-04_JPRB, 7.40151E-04_JPRB, 8.54280E-04_JPRB, 9.86008E-04_JPRB, 1.13805E-03_JPRB, &
     & 1.31353E-03_JPRB, 1.51608E-03_JPRB, 1.74985E-03_JPRB, 2.01967E-03_JPRB, 2.33110E-03_JPRB, &
     & 2.69055E-03_JPRB, 3.10543E-03_JPRB, 3.58427E-03_JPRB, 4.13696E-03_JPRB/)
      KAO_MCO2( 3, :, 5) = (/ &
     & 3.06937E-04_JPRB, 3.57841E-04_JPRB, 4.17187E-04_JPRB, 4.86375E-04_JPRB, 5.67038E-04_JPRB, &
     & 6.61078E-04_JPRB, 7.70714E-04_JPRB, 8.98532E-04_JPRB, 1.04755E-03_JPRB, 1.22128E-03_JPRB, &
     & 1.42382E-03_JPRB, 1.65996E-03_JPRB, 1.93525E-03_JPRB, 2.25620E-03_JPRB, 2.63038E-03_JPRB, &
     & 3.06661E-03_JPRB, 3.57519E-03_JPRB, 4.16812E-03_JPRB, 4.85937E-03_JPRB/)
      KAO_MCO2( 4, :, 5) = (/ &
     & 4.06428E-04_JPRB, 4.72379E-04_JPRB, 5.49033E-04_JPRB, 6.38125E-04_JPRB, 7.41674E-04_JPRB, &
     & 8.62026E-04_JPRB, 1.00191E-03_JPRB, 1.16449E-03_JPRB, 1.35345E-03_JPRB, 1.57308E-03_JPRB, &
     & 1.82834E-03_JPRB, 2.12503E-03_JPRB, 2.46986E-03_JPRB, 2.87064E-03_JPRB, 3.33647E-03_JPRB, &
     & 3.87788E-03_JPRB, 4.50715E-03_JPRB, 5.23852E-03_JPRB, 6.08858E-03_JPRB/)
      KAO_MCO2( 5, :, 5) = (/ &
     & 6.01967E-04_JPRB, 6.90414E-04_JPRB, 7.91856E-04_JPRB, 9.08204E-04_JPRB, 1.04165E-03_JPRB, &
     & 1.19470E-03_JPRB, 1.37023E-03_JPRB, 1.57156E-03_JPRB, 1.80247E-03_JPRB, 2.06731E-03_JPRB, &
     & 2.37106E-03_JPRB, 2.71944E-03_JPRB, 3.11901E-03_JPRB, 3.57729E-03_JPRB, 4.10290E-03_JPRB, &
     & 4.70574E-03_JPRB, 5.39716E-03_JPRB, 6.19017E-03_JPRB, 7.09969E-03_JPRB/)
      KAO_MCO2( 6, :, 5) = (/ &
     & 1.11622E-03_JPRB, 1.25799E-03_JPRB, 1.41776E-03_JPRB, 1.59783E-03_JPRB, 1.80077E-03_JPRB, &
     & 2.02947E-03_JPRB, 2.28723E-03_JPRB, 2.57773E-03_JPRB, 2.90512E-03_JPRB, 3.27408E-03_JPRB, &
     & 3.68992E-03_JPRB, 4.15856E-03_JPRB, 4.68673E-03_JPRB, 5.28197E-03_JPRB, 5.95282E-03_JPRB, &
     & 6.70887E-03_JPRB, 7.56094E-03_JPRB, 8.52123E-03_JPRB, 9.60348E-03_JPRB/)
      KAO_MCO2( 7, :, 5) = (/ &
     & 3.63860E-03_JPRB, 3.96164E-03_JPRB, 4.31337E-03_JPRB, 4.69632E-03_JPRB, 5.11327E-03_JPRB, &
     & 5.56724E-03_JPRB, 6.06151E-03_JPRB, 6.59967E-03_JPRB, 7.18561E-03_JPRB, 7.82356E-03_JPRB, &
     & 8.51816E-03_JPRB, 9.27443E-03_JPRB, 1.00978E-02_JPRB, 1.09943E-02_JPRB, 1.19705E-02_JPRB, &
     & 1.30332E-02_JPRB, 1.41904E-02_JPRB, 1.54502E-02_JPRB, 1.68219E-02_JPRB/)
      KAO_MCO2( 8, :, 5) = (/ &
     & 5.96957E-03_JPRB, 6.53049E-03_JPRB, 7.14412E-03_JPRB, 7.81541E-03_JPRB, 8.54977E-03_JPRB, &
     & 9.35314E-03_JPRB, 1.02320E-02_JPRB, 1.11934E-02_JPRB, 1.22452E-02_JPRB, 1.33958E-02_JPRB, &
     & 1.46545E-02_JPRB, 1.60315E-02_JPRB, 1.75379E-02_JPRB, 1.91858E-02_JPRB, 2.09886E-02_JPRB, &
     & 2.29608E-02_JPRB, 2.51182E-02_JPRB, 2.74784E-02_JPRB, 3.00604E-02_JPRB/)
      KAO_MCO2( 9, :, 5) = (/ &
     & 1.19381E-03_JPRB, 1.33882E-03_JPRB, 1.50143E-03_JPRB, 1.68379E-03_JPRB, 1.88831E-03_JPRB, &
     & 2.11767E-03_JPRB, 2.37488E-03_JPRB, 2.66333E-03_JPRB, 2.98683E-03_JPRB, 3.34961E-03_JPRB, &
     & 3.75646E-03_JPRB, 4.21272E-03_JPRB, 4.72440E-03_JPRB, 5.29823E-03_JPRB, 5.94176E-03_JPRB, &
     & 6.66345E-03_JPRB, 7.47280E-03_JPRB, 8.38045E-03_JPRB, 9.39835E-03_JPRB/)
      KAO_MCO2( 1, :, 6) = (/ &
     & 4.12429E-04_JPRB, 4.84830E-04_JPRB, 5.69942E-04_JPRB, 6.69995E-04_JPRB, 7.87613E-04_JPRB, &
     & 9.25878E-04_JPRB, 1.08842E-03_JPRB, 1.27949E-03_JPRB, 1.50410E-03_JPRB, 1.76814E-03_JPRB, &
     & 2.07854E-03_JPRB, 2.44343E-03_JPRB, 2.87237E-03_JPRB, 3.37662E-03_JPRB, 3.96938E-03_JPRB, &
     & 4.66621E-03_JPRB, 5.48536E-03_JPRB, 6.44831E-03_JPRB, 7.58031E-03_JPRB/)
      KAO_MCO2( 2, :, 6) = (/ &
     & 6.43498E-04_JPRB, 7.46132E-04_JPRB, 8.65134E-04_JPRB, 1.00312E-03_JPRB, 1.16311E-03_JPRB, &
     & 1.34861E-03_JPRB, 1.56371E-03_JPRB, 1.81310E-03_JPRB, 2.10228E-03_JPRB, 2.43758E-03_JPRB, &
     & 2.82635E-03_JPRB, 3.27714E-03_JPRB, 3.79981E-03_JPRB, 4.40586E-03_JPRB, 5.10855E-03_JPRB, &
     & 5.92333E-03_JPRB, 6.86806E-03_JPRB, 7.96346E-03_JPRB, 9.23357E-03_JPRB/)
      KAO_MCO2( 3, :, 6) = (/ &
     & 1.11336E-03_JPRB, 1.26910E-03_JPRB, 1.44662E-03_JPRB, 1.64897E-03_JPRB, 1.87962E-03_JPRB, &
     & 2.14254E-03_JPRB, 2.44224E-03_JPRB, 2.78385E-03_JPRB, 3.17325E-03_JPRB, 3.61712E-03_JPRB, &
     & 4.12308E-03_JPRB, 4.69981E-03_JPRB, 5.35720E-03_JPRB, 6.10656E-03_JPRB, 6.96073E-03_JPRB, &
     & 7.93439E-03_JPRB, 9.04424E-03_JPRB, 1.03093E-02_JPRB, 1.17514E-02_JPRB/)
      KAO_MCO2( 4, :, 6) = (/ &
     & 1.87991E-03_JPRB, 2.10276E-03_JPRB, 2.35202E-03_JPRB, 2.63082E-03_JPRB, 2.94268E-03_JPRB, &
     & 3.29150E-03_JPRB, 3.68168E-03_JPRB, 4.11810E-03_JPRB, 4.60626E-03_JPRB, 5.15228E-03_JPRB, &
     & 5.76303E-03_JPRB, 6.44617E-03_JPRB, 7.21030E-03_JPRB, 8.06500E-03_JPRB, 9.02102E-03_JPRB, &
     & 1.00904E-02_JPRB, 1.12865E-02_JPRB, 1.26244E-02_JPRB, 1.41208E-02_JPRB/)
      KAO_MCO2( 5, :, 6) = (/ &
     & 3.65848E-03_JPRB, 4.01372E-03_JPRB, 4.40346E-03_JPRB, 4.83104E-03_JPRB, 5.30015E-03_JPRB, &
     & 5.81480E-03_JPRB, 6.37943E-03_JPRB, 6.99888E-03_JPRB, 7.67849E-03_JPRB, 8.42408E-03_JPRB, &
     & 9.24208E-03_JPRB, 1.01395E-02_JPRB, 1.11241E-02_JPRB, 1.22042E-02_JPRB, 1.33893E-02_JPRB, &
     & 1.46894E-02_JPRB, 1.61158E-02_JPRB, 1.76806E-02_JPRB, 1.93975E-02_JPRB/)
      KAO_MCO2( 6, :, 6) = (/ &
     & 5.38476E-03_JPRB, 5.85088E-03_JPRB, 6.35735E-03_JPRB, 6.90765E-03_JPRB, 7.50560E-03_JPRB, &
     & 8.15530E-03_JPRB, 8.86124E-03_JPRB, 9.62829E-03_JPRB, 1.04617E-02_JPRB, 1.13673E-02_JPRB, &
     & 1.23513E-02_JPRB, 1.34205E-02_JPRB, 1.45822E-02_JPRB, 1.58445E-02_JPRB, 1.72160E-02_JPRB, &
     & 1.87062E-02_JPRB, 2.03255E-02_JPRB, 2.20849E-02_JPRB, 2.39966E-02_JPRB/)
      KAO_MCO2( 7, :, 6) = (/ &
     & 6.27017E-03_JPRB, 6.84772E-03_JPRB, 7.47846E-03_JPRB, 8.16731E-03_JPRB, 8.91960E-03_JPRB, &
     & 9.74118E-03_JPRB, 1.06384E-02_JPRB, 1.16183E-02_JPRB, 1.26885E-02_JPRB, 1.38573E-02_JPRB, &
     & 1.51336E-02_JPRB, 1.65276E-02_JPRB, 1.80500E-02_JPRB, 1.97125E-02_JPRB, 2.15283E-02_JPRB, &
     & 2.35112E-02_JPRB, 2.56769E-02_JPRB, 2.80420E-02_JPRB, 3.06249E-02_JPRB/)
      KAO_MCO2( 8, :, 6) = (/ &
     & 9.61932E-03_JPRB, 1.04802E-02_JPRB, 1.14182E-02_JPRB, 1.24401E-02_JPRB, 1.35534E-02_JPRB, &
     & 1.47664E-02_JPRB, 1.60880E-02_JPRB, 1.75278E-02_JPRB, 1.90965E-02_JPRB, 2.08056E-02_JPRB, &
     & 2.26677E-02_JPRB, 2.46964E-02_JPRB, 2.69066E-02_JPRB, 2.93147E-02_JPRB, 3.19383E-02_JPRB, &
     & 3.47967E-02_JPRB, 3.79110E-02_JPRB, 4.13039E-02_JPRB, 4.50005E-02_JPRB/)
      KAO_MCO2( 9, :, 6) = (/ &
     & 2.37921E-03_JPRB, 2.64556E-03_JPRB, 2.94173E-03_JPRB, 3.27105E-03_JPRB, 3.63724E-03_JPRB, &
     & 4.04442E-03_JPRB, 4.49718E-03_JPRB, 5.00064E-03_JPRB, 5.56045E-03_JPRB, 6.18293E-03_JPRB, &
     & 6.87510E-03_JPRB, 7.64475E-03_JPRB, 8.50057E-03_JPRB, 9.45219E-03_JPRB, 1.05103E-02_JPRB, &
     & 1.16870E-02_JPRB, 1.29953E-02_JPRB, 1.44501E-02_JPRB, 1.60677E-02_JPRB/)
      KAO_MCO2( 1, :, 7) = (/ &
     & 4.64970E-03_JPRB, 5.13188E-03_JPRB, 5.66406E-03_JPRB, 6.25144E-03_JPRB, 6.89972E-03_JPRB, &
     & 7.61523E-03_JPRB, 8.40493E-03_JPRB, 9.27654E-03_JPRB, 1.02385E-02_JPRB, 1.13003E-02_JPRB, &
     & 1.24721E-02_JPRB, 1.37655E-02_JPRB, 1.51930E-02_JPRB, 1.67685E-02_JPRB, 1.85075E-02_JPRB, &
     & 2.04267E-02_JPRB, 2.25450E-02_JPRB, 2.48829E-02_JPRB, 2.74633E-02_JPRB/)
      KAO_MCO2( 2, :, 7) = (/ &
     & 6.37148E-03_JPRB, 6.96805E-03_JPRB, 7.62046E-03_JPRB, 8.33397E-03_JPRB, 9.11428E-03_JPRB, &
     & 9.96765E-03_JPRB, 1.09009E-02_JPRB, 1.19216E-02_JPRB, 1.30378E-02_JPRB, 1.42585E-02_JPRB, &
     & 1.55935E-02_JPRB, 1.70536E-02_JPRB, 1.86503E-02_JPRB, 2.03965E-02_JPRB, 2.23062E-02_JPRB, &
     & 2.43948E-02_JPRB, 2.66789E-02_JPRB, 2.91768E-02_JPRB, 3.19086E-02_JPRB/)
      KAO_MCO2( 3, :, 7) = (/ &
     & 7.79364E-03_JPRB, 8.48097E-03_JPRB, 9.22892E-03_JPRB, 1.00428E-02_JPRB, 1.09285E-02_JPRB, &
     & 1.18923E-02_JPRB, 1.29411E-02_JPRB, 1.40825E-02_JPRB, 1.53244E-02_JPRB, 1.66759E-02_JPRB, &
     & 1.81466E-02_JPRB, 1.97470E-02_JPRB, 2.14885E-02_JPRB, 2.33836E-02_JPRB, 2.54458E-02_JPRB, &
     & 2.76899E-02_JPRB, 3.01320E-02_JPRB, 3.27893E-02_JPRB, 3.56811E-02_JPRB/)
      KAO_MCO2( 4, :, 7) = (/ &
     & 8.70586E-03_JPRB, 9.48737E-03_JPRB, 1.03390E-02_JPRB, 1.12672E-02_JPRB, 1.22786E-02_JPRB, &
     & 1.33808E-02_JPRB, 1.45820E-02_JPRB, 1.58910E-02_JPRB, 1.73175E-02_JPRB, 1.88721E-02_JPRB, &
     & 2.05662E-02_JPRB, 2.24124E-02_JPRB, 2.44243E-02_JPRB, 2.66169E-02_JPRB, 2.90062E-02_JPRB, &
     & 3.16101E-02_JPRB, 3.44477E-02_JPRB, 3.75400E-02_JPRB, 4.09099E-02_JPRB/)
      KAO_MCO2( 5, :, 7) = (/ &
     & 9.24510E-03_JPRB, 1.00865E-02_JPRB, 1.10045E-02_JPRB, 1.20061E-02_JPRB, 1.30988E-02_JPRB, &
     & 1.42910E-02_JPRB, 1.55916E-02_JPRB, 1.70106E-02_JPRB, 1.85588E-02_JPRB, 2.02479E-02_JPRB, &
     & 2.20908E-02_JPRB, 2.41013E-02_JPRB, 2.62948E-02_JPRB, 2.86880E-02_JPRB, 3.12990E-02_JPRB, &
     & 3.41476E-02_JPRB, 3.72555E-02_JPRB, 4.06462E-02_JPRB, 4.43455E-02_JPRB/)
      KAO_MCO2( 6, :, 7) = (/ &
     & 1.09559E-02_JPRB, 1.19933E-02_JPRB, 1.31290E-02_JPRB, 1.43722E-02_JPRB, 1.57331E-02_JPRB, &
     & 1.72229E-02_JPRB, 1.88537E-02_JPRB, 2.06390E-02_JPRB, 2.25933E-02_JPRB, 2.47327E-02_JPRB, &
     & 2.70747E-02_JPRB, 2.96384E-02_JPRB, 3.24449E-02_JPRB, 3.55171E-02_JPRB, 3.88802E-02_JPRB, &
     & 4.25619E-02_JPRB, 4.65921E-02_JPRB, 5.10039E-02_JPRB, 5.58335E-02_JPRB/)
      KAO_MCO2( 7, :, 7) = (/ &
     & 1.36116E-02_JPRB, 1.48659E-02_JPRB, 1.62357E-02_JPRB, 1.77318E-02_JPRB, 1.93657E-02_JPRB, &
     & 2.11502E-02_JPRB, 2.30991E-02_JPRB, 2.52276E-02_JPRB, 2.75522E-02_JPRB, 3.00910E-02_JPRB, &
     & 3.28638E-02_JPRB, 3.58921E-02_JPRB, 3.91995E-02_JPRB, 4.28116E-02_JPRB, 4.67565E-02_JPRB, &
     & 5.10650E-02_JPRB, 5.57704E-02_JPRB, 6.09095E-02_JPRB, 6.65221E-02_JPRB/)
      KAO_MCO2( 8, :, 7) = (/ &
     & 1.51783E-02_JPRB, 1.64551E-02_JPRB, 1.78392E-02_JPRB, 1.93399E-02_JPRB, 2.09667E-02_JPRB, &
     & 2.27304E-02_JPRB, 2.46424E-02_JPRB, 2.67153E-02_JPRB, 2.89626E-02_JPRB, 3.13988E-02_JPRB, &
     & 3.40401E-02_JPRB, 3.69035E-02_JPRB, 4.00077E-02_JPRB, 4.33731E-02_JPRB, 4.70216E-02_JPRB, &
     & 5.09770E-02_JPRB, 5.52651E-02_JPRB, 5.99139E-02_JPRB, 6.49538E-02_JPRB/)
      KAO_MCO2( 9, :, 7) = (/ &
     & 1.00072E-02_JPRB, 1.08638E-02_JPRB, 1.17937E-02_JPRB, 1.28032E-02_JPRB, 1.38991E-02_JPRB, &
     & 1.50888E-02_JPRB, 1.63803E-02_JPRB, 1.77824E-02_JPRB, 1.93045E-02_JPRB, 2.09568E-02_JPRB, &
     & 2.27507E-02_JPRB, 2.46980E-02_JPRB, 2.68120E-02_JPRB, 2.91070E-02_JPRB, 3.15984E-02_JPRB, &
     & 3.43031E-02_JPRB, 3.72393E-02_JPRB, 4.04268E-02_JPRB, 4.38872E-02_JPRB/)
      KAO_MCO2( 1, :, 8) = (/ &
     & 1.59610E-02_JPRB, 1.74387E-02_JPRB, 1.90532E-02_JPRB, 2.08171E-02_JPRB, 2.27444E-02_JPRB, &
     & 2.48501E-02_JPRB, 2.71508E-02_JPRB, 2.96645E-02_JPRB, 3.24109E-02_JPRB, 3.54115E-02_JPRB, &
     & 3.86900E-02_JPRB, 4.22720E-02_JPRB, 4.61856E-02_JPRB, 5.04616E-02_JPRB, 5.51334E-02_JPRB, &
     & 6.02378E-02_JPRB, 6.58147E-02_JPRB, 7.19079E-02_JPRB, 7.85653E-02_JPRB/)
      KAO_MCO2( 2, :, 8) = (/ &
     & 1.61961E-02_JPRB, 1.76986E-02_JPRB, 1.93405E-02_JPRB, 2.11348E-02_JPRB, 2.30955E-02_JPRB, &
     & 2.52381E-02_JPRB, 2.75794E-02_JPRB, 3.01380E-02_JPRB, 3.29340E-02_JPRB, 3.59893E-02_JPRB, &
     & 3.93280E-02_JPRB, 4.29766E-02_JPRB, 4.69636E-02_JPRB, 5.13204E-02_JPRB, 5.60815E-02_JPRB, &
     & 6.12843E-02_JPRB, 6.69697E-02_JPRB, 7.31826E-02_JPRB, 7.99718E-02_JPRB/)
      KAO_MCO2( 3, :, 8) = (/ &
     & 1.72034E-02_JPRB, 1.88241E-02_JPRB, 2.05974E-02_JPRB, 2.25377E-02_JPRB, 2.46609E-02_JPRB, &
     & 2.69841E-02_JPRB, 2.95261E-02_JPRB, 3.23076E-02_JPRB, 3.53511E-02_JPRB, 3.86813E-02_JPRB, &
     & 4.23253E-02_JPRB, 4.63126E-02_JPRB, 5.06754E-02_JPRB, 5.54493E-02_JPRB, 6.06728E-02_JPRB, &
     & 6.63885E-02_JPRB, 7.26426E-02_JPRB, 7.94859E-02_JPRB, 8.69738E-02_JPRB/)
      KAO_MCO2( 4, :, 8) = (/ &
     & 1.79777E-02_JPRB, 1.96517E-02_JPRB, 2.14815E-02_JPRB, 2.34817E-02_JPRB, 2.56682E-02_JPRB, &
     & 2.80583E-02_JPRB, 3.06709E-02_JPRB, 3.35268E-02_JPRB, 3.66486E-02_JPRB, 4.00611E-02_JPRB, &
     & 4.37914E-02_JPRB, 4.78690E-02_JPRB, 5.23262E-02_JPRB, 5.71985E-02_JPRB, 6.25245E-02_JPRB, &
     & 6.83464E-02_JPRB, 7.47104E-02_JPRB, 8.16670E-02_JPRB, 8.92713E-02_JPRB/)
      KAO_MCO2( 5, :, 8) = (/ &
     & 2.02540E-02_JPRB, 2.21214E-02_JPRB, 2.41610E-02_JPRB, 2.63887E-02_JPRB, 2.88218E-02_JPRB, &
     & 3.14792E-02_JPRB, 3.43816E-02_JPRB, 3.75516E-02_JPRB, 4.10139E-02_JPRB, 4.47954E-02_JPRB, &
     & 4.89256E-02_JPRB, 5.34366E-02_JPRB, 5.83635E-02_JPRB, 6.37447E-02_JPRB, 6.96220E-02_JPRB, &
     & 7.60413E-02_JPRB, 8.30523E-02_JPRB, 9.07098E-02_JPRB, 9.90734E-02_JPRB/)
      KAO_MCO2( 6, :, 8) = (/ &
     & 2.19009E-02_JPRB, 2.38517E-02_JPRB, 2.59762E-02_JPRB, 2.82899E-02_JPRB, 3.08097E-02_JPRB, &
     & 3.35540E-02_JPRB, 3.65427E-02_JPRB, 3.97976E-02_JPRB, 4.33424E-02_JPRB, 4.72030E-02_JPRB, &
     & 5.14074E-02_JPRB, 5.59863E-02_JPRB, 6.09731E-02_JPRB, 6.64040E-02_JPRB, 7.23187E-02_JPRB, &
     & 7.87603E-02_JPRB, 8.57755E-02_JPRB, 9.34157E-02_JPRB, 1.01736E-01_JPRB/)
      KAO_MCO2( 7, :, 8) = (/ &
     & 2.52383E-02_JPRB, 2.73978E-02_JPRB, 2.97421E-02_JPRB, 3.22869E-02_JPRB, 3.50496E-02_JPRB, &
     & 3.80486E-02_JPRB, 4.13042E-02_JPRB, 4.48383E-02_JPRB, 4.86749E-02_JPRB, 5.28397E-02_JPRB, &
     & 5.73610E-02_JPRB, 6.22690E-02_JPRB, 6.75970E-02_JPRB, 7.33810E-02_JPRB, 7.96598E-02_JPRB, &
     & 8.64758E-02_JPRB, 9.38751E-02_JPRB, 1.01907E-01_JPRB, 1.10627E-01_JPRB/)
      KAO_MCO2( 8, :, 8) = (/ &
     & 3.36506E-02_JPRB, 3.59288E-02_JPRB, 3.83613E-02_JPRB, 4.09584E-02_JPRB, 4.37313E-02_JPRB, &
     & 4.66920E-02_JPRB, 4.98531E-02_JPRB, 5.32283E-02_JPRB, 5.68319E-02_JPRB, 6.06795E-02_JPRB, &
     & 6.47876E-02_JPRB, 6.91739E-02_JPRB, 7.38570E-02_JPRB, 7.88573E-02_JPRB, 8.41960E-02_JPRB, &
     & 8.98962E-02_JPRB, 9.59824E-02_JPRB, 1.02481E-01_JPRB, 1.09419E-01_JPRB/)
      KAO_MCO2( 9, :, 8) = (/ &
     & 2.15151E-02_JPRB, 2.34420E-02_JPRB, 2.55415E-02_JPRB, 2.78291E-02_JPRB, 3.03215E-02_JPRB, &
     & 3.30372E-02_JPRB, 3.59961E-02_JPRB, 3.92200E-02_JPRB, 4.27326E-02_JPRB, 4.65598E-02_JPRB, &
     & 5.07299E-02_JPRB, 5.52734E-02_JPRB, 6.02238E-02_JPRB, 6.56176E-02_JPRB, 7.14944E-02_JPRB, &
     & 7.78977E-02_JPRB, 8.48744E-02_JPRB, 9.24759E-02_JPRB, 1.00758E-01_JPRB/)
      KAO_MCO2( 1, :, 9) = (/ &
     & 3.34296E-02_JPRB, 3.64437E-02_JPRB, 3.97294E-02_JPRB, 4.33114E-02_JPRB, 4.72164E-02_JPRB, &
     & 5.14734E-02_JPRB, 5.61143E-02_JPRB, 6.11735E-02_JPRB, 6.66890E-02_JPRB, 7.27016E-02_JPRB, &
     & 7.92564E-02_JPRB, 8.64022E-02_JPRB, 9.41922E-02_JPRB, 1.02685E-01_JPRB, 1.11943E-01_JPRB, &
     & 1.22035E-01_JPRB, 1.33038E-01_JPRB, 1.45033E-01_JPRB, 1.58109E-01_JPRB/)
      KAO_MCO2( 2, :, 9) = (/ &
     & 3.73946E-02_JPRB, 4.07543E-02_JPRB, 4.44160E-02_JPRB, 4.84066E-02_JPRB, 5.27558E-02_JPRB, &
     & 5.74958E-02_JPRB, 6.26616E-02_JPRB, 6.82915E-02_JPRB, 7.44273E-02_JPRB, 8.11144E-02_JPRB, &
     & 8.84023E-02_JPRB, 9.63449E-02_JPRB, 1.05001E-01_JPRB, 1.14435E-01_JPRB, 1.24717E-01_JPRB, &
     & 1.35922E-01_JPRB, 1.48135E-01_JPRB, 1.61444E-01_JPRB, 1.75949E-01_JPRB/)
      KAO_MCO2( 3, :, 9) = (/ &
     & 4.24539E-02_JPRB, 4.61192E-02_JPRB, 5.01010E-02_JPRB, 5.44265E-02_JPRB, 5.91255E-02_JPRB, &
     & 6.42302E-02_JPRB, 6.97756E-02_JPRB, 7.57998E-02_JPRB, 8.23442E-02_JPRB, 8.94535E-02_JPRB, &
     & 9.71766E-02_JPRB, 1.05566E-01_JPRB, 1.14681E-01_JPRB, 1.24582E-01_JPRB, 1.35338E-01_JPRB, &
     & 1.47022E-01_JPRB, 1.59716E-01_JPRB, 1.73505E-01_JPRB, 1.88485E-01_JPRB/)
      KAO_MCO2( 4, :, 9) = (/ &
     & 5.30296E-02_JPRB, 5.73416E-02_JPRB, 6.20043E-02_JPRB, 6.70462E-02_JPRB, 7.24980E-02_JPRB, &
     & 7.83931E-02_JPRB, 8.47676E-02_JPRB, 9.16604E-02_JPRB, 9.91137E-02_JPRB, 1.07173E-01_JPRB, &
     & 1.15888E-01_JPRB, 1.25311E-01_JPRB, 1.35501E-01_JPRB, 1.46519E-01_JPRB, 1.58433E-01_JPRB, &
     & 1.71316E-01_JPRB, 1.85246E-01_JPRB, 2.00309E-01_JPRB, 2.16597E-01_JPRB/)
      KAO_MCO2( 5, :, 9) = (/ &
     & 6.26111E-02_JPRB, 6.74018E-02_JPRB, 7.25591E-02_JPRB, 7.81111E-02_JPRB, 8.40878E-02_JPRB, &
     & 9.05218E-02_JPRB, 9.74482E-02_JPRB, 1.04904E-01_JPRB, 1.12931E-01_JPRB, 1.21572E-01_JPRB, &
     & 1.30875E-01_JPRB, 1.40889E-01_JPRB, 1.51669E-01_JPRB, 1.63274E-01_JPRB, 1.75767E-01_JPRB, &
     & 1.89216E-01_JPRB, 2.03694E-01_JPRB, 2.19279E-01_JPRB, 2.36058E-01_JPRB/)
      KAO_MCO2( 6, :, 9) = (/ &
     & 7.59080E-02_JPRB, 8.13446E-02_JPRB, 8.71706E-02_JPRB, 9.34139E-02_JPRB, 1.00104E-01_JPRB, &
     & 1.07274E-01_JPRB, 1.14957E-01_JPRB, 1.23190E-01_JPRB, 1.32013E-01_JPRB, 1.41468E-01_JPRB, &
     & 1.51600E-01_JPRB, 1.62458E-01_JPRB, 1.74094E-01_JPRB, 1.86562E-01_JPRB, 1.99924E-01_JPRB, &
     & 2.14243E-01_JPRB, 2.29587E-01_JPRB, 2.46031E-01_JPRB, 2.63652E-01_JPRB/)
      KAO_MCO2( 7, :, 9) = (/ &
     & 8.81942E-02_JPRB, 9.39942E-02_JPRB, 1.00176E-01_JPRB, 1.06763E-01_JPRB, 1.13784E-01_JPRB, &
     & 1.21267E-01_JPRB, 1.29242E-01_JPRB, 1.37742E-01_JPRB, 1.46800E-01_JPRB, 1.56454E-01_JPRB, &
     & 1.66743E-01_JPRB, 1.77708E-01_JPRB, 1.89395E-01_JPRB, 2.01850E-01_JPRB, 2.15124E-01_JPRB, &
     & 2.29272E-01_JPRB, 2.44349E-01_JPRB, 2.60418E-01_JPRB, 2.77544E-01_JPRB/)
      KAO_MCO2( 8, :, 9) = (/ &
     & 6.28535E-02_JPRB, 6.69314E-02_JPRB, 7.12740E-02_JPRB, 7.58982E-02_JPRB, 8.08225E-02_JPRB, &
     & 8.60662E-02_JPRB, 9.16502E-02_JPRB, 9.75965E-02_JPRB, 1.03929E-01_JPRB, 1.10671E-01_JPRB, &
     & 1.17852E-01_JPRB, 1.25498E-01_JPRB, 1.33640E-01_JPRB, 1.42311E-01_JPRB, 1.51544E-01_JPRB, &
     & 1.61376E-01_JPRB, 1.71846E-01_JPRB, 1.82996E-01_JPRB, 1.94868E-01_JPRB/)
      KAO_MCO2( 9, :, 9) = (/ &
     & 6.39196E-02_JPRB, 6.86702E-02_JPRB, 7.37738E-02_JPRB, 7.92568E-02_JPRB, 8.51473E-02_JPRB, &
     & 9.14756E-02_JPRB, 9.82742E-02_JPRB, 1.05578E-01_JPRB, 1.13425E-01_JPRB, 1.21855E-01_JPRB, &
     & 1.30911E-01_JPRB, 1.40641E-01_JPRB, 1.51093E-01_JPRB, 1.62323E-01_JPRB, 1.74387E-01_JPRB, &
     & 1.87348E-01_JPRB, 2.01272E-01_JPRB, 2.16231E-01_JPRB, 2.32301E-01_JPRB/)
      KAO_MCO2( 1, :,10) = (/ &
     & 9.44086E-02_JPRB, 1.02788E-01_JPRB, 1.11911E-01_JPRB, 1.21844E-01_JPRB, 1.32659E-01_JPRB, &
     & 1.44434E-01_JPRB, 1.57253E-01_JPRB, 1.71211E-01_JPRB, 1.86407E-01_JPRB, 2.02952E-01_JPRB, &
     & 2.20966E-01_JPRB, 2.40578E-01_JPRB, 2.61932E-01_JPRB, 2.85180E-01_JPRB, 3.10492E-01_JPRB, &
     & 3.38051E-01_JPRB, 3.68056E-01_JPRB, 4.00723E-01_JPRB, 4.36291E-01_JPRB/)
      KAO_MCO2( 2, :,10) = (/ &
     & 1.29528E-01_JPRB, 1.39646E-01_JPRB, 1.50554E-01_JPRB, 1.62315E-01_JPRB, 1.74994E-01_JPRB, &
     & 1.88664E-01_JPRB, 2.03401E-01_JPRB, 2.19290E-01_JPRB, 2.36419E-01_JPRB, 2.54887E-01_JPRB, &
     & 2.74798E-01_JPRB, 2.96263E-01_JPRB, 3.19406E-01_JPRB, 3.44356E-01_JPRB, 3.71255E-01_JPRB, &
     & 4.00256E-01_JPRB, 4.31522E-01_JPRB, 4.65230E-01_JPRB, 5.01571E-01_JPRB/)
      KAO_MCO2( 3, :,10) = (/ &
     & 1.52325E-01_JPRB, 1.62991E-01_JPRB, 1.74404E-01_JPRB, 1.86616E-01_JPRB, 1.99684E-01_JPRB, &
     & 2.13666E-01_JPRB, 2.28628E-01_JPRB, 2.44637E-01_JPRB, 2.61767E-01_JPRB, 2.80096E-01_JPRB, &
     & 2.99710E-01_JPRB, 3.20696E-01_JPRB, 3.43152E-01_JPRB, 3.67181E-01_JPRB, 3.92892E-01_JPRB, &
     & 4.20403E-01_JPRB, 4.49841E-01_JPRB, 4.81340E-01_JPRB, 5.15045E-01_JPRB/)
      KAO_MCO2( 4, :,10) = (/ &
     & 1.59763E-01_JPRB, 1.70378E-01_JPRB, 1.81698E-01_JPRB, 1.93770E-01_JPRB, 2.06644E-01_JPRB, &
     & 2.20373E-01_JPRB, 2.35015E-01_JPRB, 2.50629E-01_JPRB, 2.67281E-01_JPRB, 2.85039E-01_JPRB, &
     & 3.03977E-01_JPRB, 3.24174E-01_JPRB, 3.45712E-01_JPRB, 3.68681E-01_JPRB, 3.93176E-01_JPRB, &
     & 4.19299E-01_JPRB, 4.47157E-01_JPRB, 4.76866E-01_JPRB, 5.08549E-01_JPRB/)
      KAO_MCO2( 5, :,10) = (/ &
     & 1.79202E-01_JPRB, 1.91125E-01_JPRB, 2.03840E-01_JPRB, 2.17402E-01_JPRB, 2.31866E-01_JPRB, &
     & 2.47292E-01_JPRB, 2.63744E-01_JPRB, 2.81291E-01_JPRB, 3.00005E-01_JPRB, 3.19964E-01_JPRB, &
     & 3.41251E-01_JPRB, 3.63955E-01_JPRB, 3.88169E-01_JPRB, 4.13994E-01_JPRB, 4.41537E-01_JPRB, &
     & 4.70912E-01_JPRB, 5.02242E-01_JPRB, 5.35656E-01_JPRB, 5.71293E-01_JPRB/)
      KAO_MCO2( 6, :,10) = (/ &
     & 1.66628E-01_JPRB, 1.76984E-01_JPRB, 1.87984E-01_JPRB, 1.99668E-01_JPRB, 2.12078E-01_JPRB, &
     & 2.25259E-01_JPRB, 2.39259E-01_JPRB, 2.54129E-01_JPRB, 2.69924E-01_JPRB, 2.86700E-01_JPRB, &
     & 3.04519E-01_JPRB, 3.23446E-01_JPRB, 3.43549E-01_JPRB, 3.64901E-01_JPRB, 3.87580E-01_JPRB, &
     & 4.11669E-01_JPRB, 4.37255E-01_JPRB, 4.64431E-01_JPRB, 4.93297E-01_JPRB/)
      KAO_MCO2( 7, :,10) = (/ &
     & 2.03980E-01_JPRB, 2.17141E-01_JPRB, 2.31152E-01_JPRB, 2.46067E-01_JPRB, 2.61945E-01_JPRB, &
     & 2.78847E-01_JPRB, 2.96839E-01_JPRB, 3.15993E-01_JPRB, 3.36382E-01_JPRB, 3.58087E-01_JPRB, &
     & 3.81193E-01_JPRB, 4.05789E-01_JPRB, 4.31972E-01_JPRB, 4.59845E-01_JPRB, 4.89517E-01_JPRB, &
     & 5.21103E-01_JPRB, 5.54727E-01_JPRB, 5.90520E-01_JPRB, 6.28623E-01_JPRB/)
      KAO_MCO2( 8, :,10) = (/ &
     & 1.96161E-04_JPRB, 2.07177E-04_JPRB, 2.18812E-04_JPRB, 2.31101E-04_JPRB, 2.44079E-04_JPRB, &
     & 2.57787E-04_JPRB, 2.72264E-04_JPRB, 2.87554E-04_JPRB, 3.03703E-04_JPRB, 3.20758E-04_JPRB, &
     & 3.38772E-04_JPRB, 3.57797E-04_JPRB, 3.77891E-04_JPRB, 3.99113E-04_JPRB, 4.21527E-04_JPRB, &
     & 4.45200E-04_JPRB, 4.70202E-04_JPRB, 4.96608E-04_JPRB, 5.24498E-04_JPRB/)
      KAO_MCO2( 9, :,10) = (/ &
     & 1.76275E-01_JPRB, 1.88091E-01_JPRB, 2.00699E-01_JPRB, 2.14152E-01_JPRB, 2.28507E-01_JPRB, &
     & 2.43824E-01_JPRB, 2.60168E-01_JPRB, 2.77607E-01_JPRB, 2.96216E-01_JPRB, 3.16071E-01_JPRB, &
     & 3.37258E-01_JPRB, 3.59865E-01_JPRB, 3.83987E-01_JPRB, 4.09726E-01_JPRB, 4.37190E-01_JPRB, &
     & 4.66495E-01_JPRB, 4.97765E-01_JPRB, 5.31131E-01_JPRB, 5.66733E-01_JPRB/)
      KAO_MCO2( 1, :,11) = (/ &
     & 1.99797E-01_JPRB, 2.14154E-01_JPRB, 2.29543E-01_JPRB, 2.46038E-01_JPRB, 2.63718E-01_JPRB, &
     & 2.82669E-01_JPRB, 3.02981E-01_JPRB, 3.24753E-01_JPRB, 3.48090E-01_JPRB, 3.73104E-01_JPRB, &
     & 3.99915E-01_JPRB, 4.28652E-01_JPRB, 4.59455E-01_JPRB, 4.92471E-01_JPRB, 5.27859E-01_JPRB, &
     & 5.65791E-01_JPRB, 6.06448E-01_JPRB, 6.50027E-01_JPRB, 6.96738E-01_JPRB/)
      KAO_MCO2( 2, :,11) = (/ &
     & 2.20638E-01_JPRB, 2.35685E-01_JPRB, 2.51759E-01_JPRB, 2.68929E-01_JPRB, 2.87271E-01_JPRB, &
     & 3.06863E-01_JPRB, 3.27791E-01_JPRB, 3.50146E-01_JPRB, 3.74026E-01_JPRB, 3.99535E-01_JPRB, &
     & 4.26784E-01_JPRB, 4.55891E-01_JPRB, 4.86983E-01_JPRB, 5.20195E-01_JPRB, 5.55673E-01_JPRB, &
     & 5.93570E-01_JPRB, 6.34052E-01_JPRB, 6.77294E-01_JPRB, 7.23486E-01_JPRB/)
      KAO_MCO2( 3, :,11) = (/ &
     & 2.62988E-01_JPRB, 2.80924E-01_JPRB, 3.00085E-01_JPRB, 3.20552E-01_JPRB, 3.42414E-01_JPRB, &
     & 3.65768E-01_JPRB, 3.90715E-01_JPRB, 4.17363E-01_JPRB, 4.45829E-01_JPRB, 4.76237E-01_JPRB, &
     & 5.08718E-01_JPRB, 5.43414E-01_JPRB, 5.80477E-01_JPRB, 6.20068E-01_JPRB, 6.62359E-01_JPRB, &
     & 7.07535E-01_JPRB, 7.55791E-01_JPRB, 8.07339E-01_JPRB, 8.62403E-01_JPRB/)
      KAO_MCO2( 4, :,11) = (/ &
     & 2.43674E-01_JPRB, 2.59946E-01_JPRB, 2.77304E-01_JPRB, 2.95821E-01_JPRB, 3.15575E-01_JPRB, &
     & 3.36647E-01_JPRB, 3.59127E-01_JPRB, 3.83108E-01_JPRB, 4.08691E-01_JPRB, 4.35981E-01_JPRB, &
     & 4.65094E-01_JPRB, 4.96152E-01_JPRB, 5.29282E-01_JPRB, 5.64626E-01_JPRB, 6.02329E-01_JPRB, &
     & 6.42550E-01_JPRB, 6.85457E-01_JPRB, 7.31229E-01_JPRB, 7.80057E-01_JPRB/)
      KAO_MCO2( 5, :,11) = (/ &
     & 2.23323E-01_JPRB, 2.37553E-01_JPRB, 2.52689E-01_JPRB, 2.68791E-01_JPRB, 2.85918E-01_JPRB, &
     & 3.04136E-01_JPRB, 3.23515E-01_JPRB, 3.44129E-01_JPRB, 3.66057E-01_JPRB, 3.89381E-01_JPRB, &
     & 4.14192E-01_JPRB, 4.40584E-01_JPRB, 4.68657E-01_JPRB, 4.98520E-01_JPRB, 5.30285E-01_JPRB, &
     & 5.64074E-01_JPRB, 6.00016E-01_JPRB, 6.38248E-01_JPRB, 6.78917E-01_JPRB/)
      KAO_MCO2( 6, :,11) = (/ &
     & 2.83716E-01_JPRB, 3.02622E-01_JPRB, 3.22788E-01_JPRB, 3.44298E-01_JPRB, 3.67241E-01_JPRB, &
     & 3.91713E-01_JPRB, 4.17816E-01_JPRB, 4.45658E-01_JPRB, 4.75356E-01_JPRB, 5.07033E-01_JPRB, &
     & 5.40820E-01_JPRB, 5.76859E-01_JPRB, 6.15300E-01_JPRB, 6.56302E-01_JPRB, 7.00037E-01_JPRB, &
     & 7.46686E-01_JPRB, 7.96443E-01_JPRB, 8.49516E-01_JPRB, 9.06126E-01_JPRB/)
      KAO_MCO2( 7, :,11) = (/ &
     & 1.00497E-03_JPRB, 1.06500E-03_JPRB, 1.12863E-03_JPRB, 1.19606E-03_JPRB, 1.26751E-03_JPRB, &
     & 1.34323E-03_JPRB, 1.42348E-03_JPRB, 1.50852E-03_JPRB, 1.59864E-03_JPRB, 1.69414E-03_JPRB, &
     & 1.79535E-03_JPRB, 1.90261E-03_JPRB, 2.01628E-03_JPRB, 2.13673E-03_JPRB, 2.26438E-03_JPRB, &
     & 2.39966E-03_JPRB, 2.54302E-03_JPRB, 2.69494E-03_JPRB, 2.85594E-03_JPRB/)
      KAO_MCO2( 8, :,11) = (/ &
     & 3.22623E-04_JPRB, 3.39937E-04_JPRB, 3.58181E-04_JPRB, 3.77404E-04_JPRB, 3.97658E-04_JPRB, &
     & 4.19000E-04_JPRB, 4.41487E-04_JPRB, 4.65180E-04_JPRB, 4.90146E-04_JPRB, 5.16451E-04_JPRB, &
     & 5.44167E-04_JPRB, 5.73372E-04_JPRB, 6.04143E-04_JPRB, 6.36567E-04_JPRB, 6.70730E-04_JPRB, &
     & 7.06726E-04_JPRB, 7.44655E-04_JPRB, 7.84619E-04_JPRB, 8.26727E-04_JPRB/)
      KAO_MCO2( 9, :,11) = (/ &
     & 2.23872E-01_JPRB, 2.38360E-01_JPRB, 2.53786E-01_JPRB, 2.70210E-01_JPRB, 2.87697E-01_JPRB, &
     & 3.06316E-01_JPRB, 3.26140E-01_JPRB, 3.47247E-01_JPRB, 3.69720E-01_JPRB, 3.93647E-01_JPRB, &
     & 4.19122E-01_JPRB, 4.46246E-01_JPRB, 4.75126E-01_JPRB, 5.05874E-01_JPRB, 5.38613E-01_JPRB, &
     & 5.73470E-01_JPRB, 6.10583E-01_JPRB, 6.50098E-01_JPRB, 6.92170E-01_JPRB/)
      KAO_MCO2( 1, :,12) = (/ &
     & 3.52418E-01_JPRB, 3.76085E-01_JPRB, 4.01341E-01_JPRB, 4.28293E-01_JPRB, 4.57055E-01_JPRB, &
     & 4.87749E-01_JPRB, 5.20504E-01_JPRB, 5.55458E-01_JPRB, 5.92760E-01_JPRB, 6.32567E-01_JPRB, &
     & 6.75047E-01_JPRB, 7.20380E-01_JPRB, 7.68757E-01_JPRB, 8.20383E-01_JPRB, 8.75476E-01_JPRB, &
     & 9.34268E-01_JPRB, 9.97009E-01_JPRB, 1.06396E+00_JPRB, 1.13541E+00_JPRB/)
      KAO_MCO2( 2, :,12) = (/ &
     & 3.38812E-01_JPRB, 3.61001E-01_JPRB, 3.84645E-01_JPRB, 4.09836E-01_JPRB, 4.36678E-01_JPRB, &
     & 4.65278E-01_JPRB, 4.95750E-01_JPRB, 5.28219E-01_JPRB, 5.62814E-01_JPRB, 5.99674E-01_JPRB, &
     & 6.38949E-01_JPRB, 6.80796E-01_JPRB, 7.25384E-01_JPRB, 7.72892E-01_JPRB, 8.23511E-01_JPRB, &
     & 8.77446E-01_JPRB, 9.34913E-01_JPRB, 9.96144E-01_JPRB, 1.06138E+00_JPRB/)
      KAO_MCO2( 3, :,12) = (/ &
     & 3.44644E-01_JPRB, 3.66671E-01_JPRB, 3.90105E-01_JPRB, 4.15038E-01_JPRB, 4.41564E-01_JPRB, &
     & 4.69785E-01_JPRB, 4.99810E-01_JPRB, 5.31754E-01_JPRB, 5.65740E-01_JPRB, 6.01897E-01_JPRB, &
     & 6.40366E-01_JPRB, 6.81293E-01_JPRB, 7.24836E-01_JPRB, 7.71162E-01_JPRB, 8.20448E-01_JPRB, &
     & 8.72885E-01_JPRB, 9.28673E-01_JPRB, 9.88027E-01_JPRB, 1.05117E+00_JPRB/)
      KAO_MCO2( 4, :,12) = (/ &
     & 4.20358E-01_JPRB, 4.47809E-01_JPRB, 4.77053E-01_JPRB, 5.08207E-01_JPRB, 5.41395E-01_JPRB, &
     & 5.76750E-01_JPRB, 6.14414E-01_JPRB, 6.54538E-01_JPRB, 6.97282E-01_JPRB, 7.42818E-01_JPRB, &
     & 7.91327E-01_JPRB, 8.43004E-01_JPRB, 8.98056E-01_JPRB, 9.56703E-01_JPRB, 1.01918E+00_JPRB, &
     & 1.08574E+00_JPRB, 1.15664E+00_JPRB, 1.23217E+00_JPRB, 1.31264E+00_JPRB/)
      KAO_MCO2( 5, :,12) = (/ &
     & 4.42756E-01_JPRB, 4.72000E-01_JPRB, 5.03174E-01_JPRB, 5.36408E-01_JPRB, 5.71837E-01_JPRB, &
     & 6.09606E-01_JPRB, 6.49870E-01_JPRB, 6.92793E-01_JPRB, 7.38551E-01_JPRB, 7.87331E-01_JPRB, &
     & 8.39333E-01_JPRB, 8.94770E-01_JPRB, 9.53868E-01_JPRB, 1.01687E+00_JPRB, 1.08403E+00_JPRB, &
     & 1.15563E+00_JPRB, 1.23196E+00_JPRB, 1.31333E+00_JPRB, 1.40007E+00_JPRB/)
      KAO_MCO2( 6, :,12) = (/ &
     & 1.53662E-01_JPRB, 1.63104E-01_JPRB, 1.73126E-01_JPRB, 1.83764E-01_JPRB, 1.95055E-01_JPRB, &
     & 2.07040E-01_JPRB, 2.19762E-01_JPRB, 2.33265E-01_JPRB, 2.47598E-01_JPRB, 2.62811E-01_JPRB, &
     & 2.78960E-01_JPRB, 2.96100E-01_JPRB, 3.14294E-01_JPRB, 3.33606E-01_JPRB, 3.54104E-01_JPRB, &
     & 3.75862E-01_JPRB, 3.98956E-01_JPRB, 4.23470E-01_JPRB, 4.49490E-01_JPRB/)
      KAO_MCO2( 7, :,12) = (/ &
     & 5.41472E-04_JPRB, 5.65116E-04_JPRB, 5.89793E-04_JPRB, 6.15547E-04_JPRB, 6.42426E-04_JPRB, &
     & 6.70479E-04_JPRB, 6.99757E-04_JPRB, 7.30313E-04_JPRB, 7.62203E-04_JPRB, 7.95486E-04_JPRB, &
     & 8.30223E-04_JPRB, 8.66476E-04_JPRB, 9.04312E-04_JPRB, 9.43801E-04_JPRB, 9.85013E-04_JPRB, &
     & 1.02803E-03_JPRB, 1.07292E-03_JPRB, 1.11977E-03_JPRB, 1.16866E-03_JPRB/)
      KAO_MCO2( 8, :,12) = (/ &
     & 5.94251E-04_JPRB, 6.17650E-04_JPRB, 6.41969E-04_JPRB, 6.67246E-04_JPRB, 6.93518E-04_JPRB, &
     & 7.20824E-04_JPRB, 7.49206E-04_JPRB, 7.78705E-04_JPRB, 8.09366E-04_JPRB, 8.41234E-04_JPRB, &
     & 8.74356E-04_JPRB, 9.08783E-04_JPRB, 9.44566E-04_JPRB, 9.81757E-04_JPRB, 1.02041E-03_JPRB, &
     & 1.06059E-03_JPRB, 1.10235E-03_JPRB, 1.14575E-03_JPRB, 1.19087E-03_JPRB/)
      KAO_MCO2( 9, :,12) = (/ &
     & 4.21683E-01_JPRB, 4.49025E-01_JPRB, 4.78140E-01_JPRB, 5.09142E-01_JPRB, 5.42155E-01_JPRB, &
     & 5.77309E-01_JPRB, 6.14741E-01_JPRB, 6.54601E-01_JPRB, 6.97046E-01_JPRB, 7.42242E-01_JPRB, &
     & 7.90369E-01_JPRB, 8.41617E-01_JPRB, 8.96188E-01_JPRB, 9.54297E-01_JPRB, 1.01617E+00_JPRB, &
     & 1.08206E+00_JPRB, 1.15222E+00_JPRB, 1.22693E+00_JPRB, 1.30649E+00_JPRB/)
      KAO_MCO2( 1, :,13) = (/ &
     & 5.61805E-01_JPRB, 5.98988E-01_JPRB, 6.38631E-01_JPRB, 6.80898E-01_JPRB, 7.25962E-01_JPRB, &
     & 7.74009E-01_JPRB, 8.25236E-01_JPRB, 8.79853E-01_JPRB, 9.38085E-01_JPRB, 1.00017E+00_JPRB, &
     & 1.06637E+00_JPRB, 1.13694E+00_JPRB, 1.21219E+00_JPRB, 1.29242E+00_JPRB, 1.37795E+00_JPRB, &
     & 1.46915E+00_JPRB, 1.56638E+00_JPRB, 1.67005E+00_JPRB, 1.78058E+00_JPRB/)
      KAO_MCO2( 2, :,13) = (/ &
     & 5.55938E-01_JPRB, 5.91800E-01_JPRB, 6.29976E-01_JPRB, 6.70615E-01_JPRB, 7.13876E-01_JPRB, &
     & 7.59927E-01_JPRB, 8.08949E-01_JPRB, 8.61133E-01_JPRB, 9.16683E-01_JPRB, 9.75817E-01_JPRB, &
     & 1.03877E+00_JPRB, 1.10577E+00_JPRB, 1.17711E+00_JPRB, 1.25304E+00_JPRB, 1.33387E+00_JPRB, &
     & 1.41992E+00_JPRB, 1.51152E+00_JPRB, 1.60902E+00_JPRB, 1.71282E+00_JPRB/)
      KAO_MCO2( 3, :,13) = (/ &
     & 5.94615E-01_JPRB, 6.33277E-01_JPRB, 6.74453E-01_JPRB, 7.18307E-01_JPRB, 7.65012E-01_JPRB, &
     & 8.14753E-01_JPRB, 8.67729E-01_JPRB, 9.24149E-01_JPRB, 9.84238E-01_JPRB, 1.04823E+00_JPRB, &
     & 1.11639E+00_JPRB, 1.18898E+00_JPRB, 1.26629E+00_JPRB, 1.34862E+00_JPRB, 1.43631E+00_JPRB, &
     & 1.52970E+00_JPRB, 1.62916E+00_JPRB, 1.73509E+00_JPRB, 1.84791E+00_JPRB/)
      KAO_MCO2( 4, :,13) = (/ &
     & 5.48973E-01_JPRB, 5.84145E-01_JPRB, 6.21570E-01_JPRB, 6.61394E-01_JPRB, 7.03768E-01_JPRB, &
     & 7.48858E-01_JPRB, 7.96836E-01_JPRB, 8.47889E-01_JPRB, 9.02212E-01_JPRB, 9.60015E-01_JPRB, &
     & 1.02152E+00_JPRB, 1.08697E+00_JPRB, 1.15661E+00_JPRB, 1.23071E+00_JPRB, 1.30956E+00_JPRB, &
     & 1.39347E+00_JPRB, 1.48274E+00_JPRB, 1.57774E+00_JPRB, 1.67883E+00_JPRB/)
      KAO_MCO2( 5, :,13) = (/ &
     & 1.49742E-01_JPRB, 1.59049E-01_JPRB, 1.68934E-01_JPRB, 1.79434E-01_JPRB, 1.90586E-01_JPRB, &
     & 2.02432E-01_JPRB, 2.15013E-01_JPRB, 2.28377E-01_JPRB, 2.42571E-01_JPRB, 2.57648E-01_JPRB, &
     & 2.73661E-01_JPRB, 2.90670E-01_JPRB, 3.08736E-01_JPRB, 3.27925E-01_JPRB, 3.48307E-01_JPRB, &
     & 3.69955E-01_JPRB, 3.92949E-01_JPRB, 4.17372E-01_JPRB, 4.43312E-01_JPRB/)
      KAO_MCO2( 6, :,13) = (/ &
     & 8.81777E-04_JPRB, 9.16690E-04_JPRB, 9.52985E-04_JPRB, 9.90718E-04_JPRB, 1.02994E-03_JPRB, &
     & 1.07072E-03_JPRB, 1.11312E-03_JPRB, 1.15719E-03_JPRB, 1.20301E-03_JPRB, 1.25064E-03_JPRB, &
     & 1.30016E-03_JPRB, 1.35163E-03_JPRB, 1.40515E-03_JPRB, 1.46079E-03_JPRB, 1.51862E-03_JPRB, &
     & 1.57875E-03_JPRB, 1.64126E-03_JPRB, 1.70624E-03_JPRB, 1.77380E-03_JPRB/)
      KAO_MCO2( 7, :,13) = (/ &
     & 8.84366E-04_JPRB, 9.20446E-04_JPRB, 9.57999E-04_JPRB, 9.97083E-04_JPRB, 1.03776E-03_JPRB, &
     & 1.08010E-03_JPRB, 1.12417E-03_JPRB, 1.17003E-03_JPRB, 1.21777E-03_JPRB, 1.26745E-03_JPRB, &
     & 1.31916E-03_JPRB, 1.37298E-03_JPRB, 1.42899E-03_JPRB, 1.48729E-03_JPRB, 1.54797E-03_JPRB, &
     & 1.61113E-03_JPRB, 1.67686E-03_JPRB, 1.74527E-03_JPRB, 1.81647E-03_JPRB/)
      KAO_MCO2( 8, :,13) = (/ &
     & 8.92597E-04_JPRB, 9.33069E-04_JPRB, 9.75377E-04_JPRB, 1.01960E-03_JPRB, 1.06583E-03_JPRB, &
     & 1.11416E-03_JPRB, 1.16468E-03_JPRB, 1.21749E-03_JPRB, 1.27269E-03_JPRB, 1.33040E-03_JPRB, &
     & 1.39073E-03_JPRB, 1.45378E-03_JPRB, 1.51970E-03_JPRB, 1.58861E-03_JPRB, 1.66064E-03_JPRB, &
     & 1.73594E-03_JPRB, 1.81465E-03_JPRB, 1.89693E-03_JPRB, 1.98294E-03_JPRB/)
      KAO_MCO2( 9, :,13) = (/ &
     & 1.46280E-01_JPRB, 1.55378E-01_JPRB, 1.65043E-01_JPRB, 1.75308E-01_JPRB, 1.86212E-01_JPRB, &
     & 1.97794E-01_JPRB, 2.10097E-01_JPRB, 2.23164E-01_JPRB, 2.37045E-01_JPRB, 2.51788E-01_JPRB, &
     & 2.67449E-01_JPRB, 2.84084E-01_JPRB, 3.01754E-01_JPRB, 3.20522E-01_JPRB, 3.40458E-01_JPRB, &
     & 3.61634E-01_JPRB, 3.84127E-01_JPRB, 4.08020E-01_JPRB, 4.33398E-01_JPRB/)
      KAO_MCO2( 1, :,14) = (/ &
     & 9.20236E-01_JPRB, 9.80010E-01_JPRB, 1.04367E+00_JPRB, 1.11146E+00_JPRB, 1.18366E+00_JPRB, &
     & 1.26054E+00_JPRB, 1.34242E+00_JPRB, 1.42962E+00_JPRB, 1.52248E+00_JPRB, 1.62137E+00_JPRB, &
     & 1.72669E+00_JPRB, 1.83885E+00_JPRB, 1.95829E+00_JPRB, 2.08549E+00_JPRB, 2.22096E+00_JPRB, &
     & 2.36522E+00_JPRB, 2.51886E+00_JPRB, 2.68247E+00_JPRB, 2.85671E+00_JPRB/)
      KAO_MCO2( 2, :,14) = (/ &
     & 8.39823E-01_JPRB, 8.95471E-01_JPRB, 9.54806E-01_JPRB, 1.01807E+00_JPRB, 1.08553E+00_JPRB, &
     & 1.15746E+00_JPRB, 1.23416E+00_JPRB, 1.31593E+00_JPRB, 1.40313E+00_JPRB, 1.49610E+00_JPRB, &
     & 1.59523E+00_JPRB, 1.70094E+00_JPRB, 1.81364E+00_JPRB, 1.93382E+00_JPRB, 2.06195E+00_JPRB, &
     & 2.19858E+00_JPRB, 2.34426E+00_JPRB, 2.49960E+00_JPRB, 2.66522E+00_JPRB/)
      KAO_MCO2( 3, :,14) = (/ &
     & 5.39252E-01_JPRB, 5.73971E-01_JPRB, 6.10925E-01_JPRB, 6.50259E-01_JPRB, 6.92125E-01_JPRB, &
     & 7.36686E-01_JPRB, 7.84117E-01_JPRB, 8.34601E-01_JPRB, 8.88336E-01_JPRB, 9.45530E-01_JPRB, &
     & 1.00641E+00_JPRB, 1.07120E+00_JPRB, 1.14017E+00_JPRB, 1.21358E+00_JPRB, 1.29171E+00_JPRB, &
     & 1.37488E+00_JPRB, 1.46340E+00_JPRB, 1.55762E+00_JPRB, 1.65790E+00_JPRB/)
      KAO_MCO2( 4, :,14) = (/ &
     & 1.14837E-03_JPRB, 1.19701E-03_JPRB, 1.24770E-03_JPRB, 1.30055E-03_JPRB, 1.35563E-03_JPRB, &
     & 1.41305E-03_JPRB, 1.47289E-03_JPRB, 1.53528E-03_JPRB, 1.60030E-03_JPRB, 1.66808E-03_JPRB, &
     & 1.73873E-03_JPRB, 1.81237E-03_JPRB, 1.88913E-03_JPRB, 1.96914E-03_JPRB, 2.05254E-03_JPRB, &
     & 2.13947E-03_JPRB, 2.23009E-03_JPRB, 2.32454E-03_JPRB, 2.42299E-03_JPRB/)
      KAO_MCO2( 5, :,14) = (/ &
     & 1.14611E-03_JPRB, 1.19424E-03_JPRB, 1.24440E-03_JPRB, 1.29666E-03_JPRB, 1.35111E-03_JPRB, &
     & 1.40786E-03_JPRB, 1.46698E-03_JPRB, 1.52859E-03_JPRB, 1.59279E-03_JPRB, 1.65968E-03_JPRB, &
     & 1.72938E-03_JPRB, 1.80201E-03_JPRB, 1.87769E-03_JPRB, 1.95655E-03_JPRB, 2.03872E-03_JPRB, &
     & 2.12434E-03_JPRB, 2.21355E-03_JPRB, 2.30651E-03_JPRB, 2.40338E-03_JPRB/)
      KAO_MCO2( 6, :,14) = (/ &
     & 1.14203E-03_JPRB, 1.18930E-03_JPRB, 1.23852E-03_JPRB, 1.28979E-03_JPRB, 1.34317E-03_JPRB, &
     & 1.39877E-03_JPRB, 1.45666E-03_JPRB, 1.51695E-03_JPRB, 1.57974E-03_JPRB, 1.64513E-03_JPRB, &
     & 1.71322E-03_JPRB, 1.78413E-03_JPRB, 1.85798E-03_JPRB, 1.93488E-03_JPRB, 2.01497E-03_JPRB, &
     & 2.09837E-03_JPRB, 2.18522E-03_JPRB, 2.27567E-03_JPRB, 2.36986E-03_JPRB/)
      KAO_MCO2( 7, :,14) = (/ &
     & 1.11217E-03_JPRB, 1.15727E-03_JPRB, 1.20421E-03_JPRB, 1.25305E-03_JPRB, 1.30386E-03_JPRB, &
     & 1.35674E-03_JPRB, 1.41177E-03_JPRB, 1.46902E-03_JPRB, 1.52860E-03_JPRB, 1.59059E-03_JPRB, &
     & 1.65510E-03_JPRB, 1.72222E-03_JPRB, 1.79207E-03_JPRB, 1.86475E-03_JPRB, 1.94037E-03_JPRB, &
     & 2.01907E-03_JPRB, 2.10095E-03_JPRB, 2.18616E-03_JPRB, 2.27482E-03_JPRB/)
      KAO_MCO2( 8, :,14) = (/ &
     & 1.21596E-03_JPRB, 1.25817E-03_JPRB, 1.30183E-03_JPRB, 1.34702E-03_JPRB, 1.39377E-03_JPRB, &
     & 1.44214E-03_JPRB, 1.49219E-03_JPRB, 1.54398E-03_JPRB, 1.59757E-03_JPRB, 1.65302E-03_JPRB, &
     & 1.71039E-03_JPRB, 1.76975E-03_JPRB, 1.83117E-03_JPRB, 1.89473E-03_JPRB, 1.96049E-03_JPRB, &
     & 2.02853E-03_JPRB, 2.09893E-03_JPRB, 2.17178E-03_JPRB, 2.24716E-03_JPRB/)
      KAO_MCO2( 9, :,14) = (/ &
     & 1.14611E-03_JPRB, 1.19424E-03_JPRB, 1.24440E-03_JPRB, 1.29666E-03_JPRB, 1.35111E-03_JPRB, &
     & 1.40786E-03_JPRB, 1.46698E-03_JPRB, 1.52859E-03_JPRB, 1.59279E-03_JPRB, 1.65968E-03_JPRB, &
     & 1.72938E-03_JPRB, 1.80201E-03_JPRB, 1.87769E-03_JPRB, 1.95655E-03_JPRB, 2.03872E-03_JPRB, &
     & 2.12434E-03_JPRB, 2.21355E-03_JPRB, 2.30651E-03_JPRB, 2.40338E-03_JPRB/)
      KAO_MCO2( 1, :,15) = (/ &
     & 1.29470E+00_JPRB, 1.37848E+00_JPRB, 1.46768E+00_JPRB, 1.56266E+00_JPRB, 1.66378E+00_JPRB, &
     & 1.77145E+00_JPRB, 1.88609E+00_JPRB, 2.00814E+00_JPRB, 2.13809E+00_JPRB, 2.27645E+00_JPRB, &
     & 2.42376E+00_JPRB, 2.58061E+00_JPRB, 2.74761E+00_JPRB, 2.92541E+00_JPRB, 3.11472E+00_JPRB, &
     & 3.31628E+00_JPRB, 3.53088E+00_JPRB, 3.75938E+00_JPRB, 4.00265E+00_JPRB/)
      KAO_MCO2( 2, :,15) = (/ &
     & 7.23701E-01_JPRB, 7.68508E-01_JPRB, 8.16089E-01_JPRB, 8.66616E-01_JPRB, 9.20272E-01_JPRB, &
     & 9.77250E-01_JPRB, 1.03775E+00_JPRB, 1.10201E+00_JPRB, 1.17024E+00_JPRB, 1.24269E+00_JPRB, &
     & 1.31963E+00_JPRB, 1.40133E+00_JPRB, 1.48809E+00_JPRB, 1.58023E+00_JPRB, 1.67807E+00_JPRB, &
     & 1.78196E+00_JPRB, 1.89229E+00_JPRB, 2.00945E+00_JPRB, 2.13386E+00_JPRB/)
      KAO_MCO2( 3, :,15) = (/ &
     & 1.81684E-03_JPRB, 1.85424E-03_JPRB, 1.89241E-03_JPRB, 1.93137E-03_JPRB, 1.97114E-03_JPRB, &
     & 2.01172E-03_JPRB, 2.05313E-03_JPRB, 2.09540E-03_JPRB, 2.13854E-03_JPRB, 2.18257E-03_JPRB, &
     & 2.22750E-03_JPRB, 2.27336E-03_JPRB, 2.32016E-03_JPRB, 2.36793E-03_JPRB, 2.41668E-03_JPRB, &
     & 2.46643E-03_JPRB, 2.51721E-03_JPRB, 2.56903E-03_JPRB, 2.62192E-03_JPRB/)
      KAO_MCO2( 4, :,15) = (/ &
     & 1.84644E-03_JPRB, 1.88437E-03_JPRB, 1.92309E-03_JPRB, 1.96260E-03_JPRB, 2.00293E-03_JPRB, &
     & 2.04408E-03_JPRB, 2.08608E-03_JPRB, 2.12894E-03_JPRB, 2.17268E-03_JPRB, 2.21732E-03_JPRB, &
     & 2.26288E-03_JPRB, 2.30938E-03_JPRB, 2.35683E-03_JPRB, 2.40525E-03_JPRB, 2.45467E-03_JPRB, &
     & 2.50510E-03_JPRB, 2.55658E-03_JPRB, 2.60910E-03_JPRB, 2.66271E-03_JPRB/)
      KAO_MCO2( 5, :,15) = (/ &
     & 1.88579E-03_JPRB, 1.92454E-03_JPRB, 1.96408E-03_JPRB, 2.00443E-03_JPRB, 2.04561E-03_JPRB, &
     & 2.08764E-03_JPRB, 2.13054E-03_JPRB, 2.17431E-03_JPRB, 2.21898E-03_JPRB, 2.26457E-03_JPRB, &
     & 2.31110E-03_JPRB, 2.35858E-03_JPRB, 2.40704E-03_JPRB, 2.45650E-03_JPRB, 2.50697E-03_JPRB, &
     & 2.55848E-03_JPRB, 2.61104E-03_JPRB, 2.66469E-03_JPRB, 2.71943E-03_JPRB/)
      KAO_MCO2( 6, :,15) = (/ &
     & 1.95322E-03_JPRB, 1.99316E-03_JPRB, 2.03391E-03_JPRB, 2.07549E-03_JPRB, 2.11793E-03_JPRB, &
     & 2.16123E-03_JPRB, 2.20542E-03_JPRB, 2.25051E-03_JPRB, 2.29652E-03_JPRB, 2.34347E-03_JPRB, &
     & 2.39139E-03_JPRB, 2.44028E-03_JPRB, 2.49017E-03_JPRB, 2.54109E-03_JPRB, 2.59304E-03_JPRB, &
     & 2.64605E-03_JPRB, 2.70015E-03_JPRB, 2.75536E-03_JPRB, 2.81169E-03_JPRB/)
      KAO_MCO2( 7, :,15) = (/ &
     & 2.13640E-03_JPRB, 2.17976E-03_JPRB, 2.22400E-03_JPRB, 2.26914E-03_JPRB, 2.31520E-03_JPRB, &
     & 2.36219E-03_JPRB, 2.41013E-03_JPRB, 2.45905E-03_JPRB, 2.50896E-03_JPRB, 2.55988E-03_JPRB, &
     & 2.61184E-03_JPRB, 2.66485E-03_JPRB, 2.71893E-03_JPRB, 2.77412E-03_JPRB, 2.83042E-03_JPRB, &
     & 2.88787E-03_JPRB, 2.94648E-03_JPRB, 3.00629E-03_JPRB, 3.06730E-03_JPRB/)
      KAO_MCO2( 8, :,15) = (/ &
     & 2.17014E-03_JPRB, 2.21411E-03_JPRB, 2.25897E-03_JPRB, 2.30474E-03_JPRB, 2.35143E-03_JPRB, &
     & 2.39908E-03_JPRB, 2.44769E-03_JPRB, 2.49728E-03_JPRB, 2.54788E-03_JPRB, 2.59950E-03_JPRB, &
     & 2.65217E-03_JPRB, 2.70591E-03_JPRB, 2.76073E-03_JPRB, 2.81667E-03_JPRB, 2.87374E-03_JPRB, &
     & 2.93197E-03_JPRB, 2.99137E-03_JPRB, 3.05198E-03_JPRB, 3.11382E-03_JPRB/)
      KAO_MCO2( 9, :,15) = (/ &
     & 1.88579E-03_JPRB, 1.92454E-03_JPRB, 1.96408E-03_JPRB, 2.00443E-03_JPRB, 2.04561E-03_JPRB, &
     & 2.08764E-03_JPRB, 2.13054E-03_JPRB, 2.17431E-03_JPRB, 2.21898E-03_JPRB, 2.26457E-03_JPRB, &
     & 2.31110E-03_JPRB, 2.35858E-03_JPRB, 2.40704E-03_JPRB, 2.45650E-03_JPRB, 2.50697E-03_JPRB, &
     & 2.55848E-03_JPRB, 2.61104E-03_JPRB, 2.66469E-03_JPRB, 2.71943E-03_JPRB/)
      KAO_MCO2( 1, :,16) = (/ &
     & 1.48989E+00_JPRB, 1.58377E+00_JPRB, 1.68356E+00_JPRB, 1.78964E+00_JPRB, 1.90241E+00_JPRB, &
     & 2.02228E+00_JPRB, 2.14971E+00_JPRB, 2.28516E+00_JPRB, 2.42915E+00_JPRB, 2.58221E+00_JPRB, &
     & 2.74492E+00_JPRB, 2.91788E+00_JPRB, 3.10174E+00_JPRB, 3.29718E+00_JPRB, 3.50494E+00_JPRB, &
     & 3.72578E+00_JPRB, 3.96055E+00_JPRB, 4.21010E+00_JPRB, 4.47538E+00_JPRB/)
      KAO_MCO2( 2, :,16) = (/ &
     & 2.10609E-03_JPRB, 2.14759E-03_JPRB, 2.18992E-03_JPRB, 2.23307E-03_JPRB, 2.27708E-03_JPRB, &
     & 2.32196E-03_JPRB, 2.36771E-03_JPRB, 2.41438E-03_JPRB, 2.46196E-03_JPRB, 2.51047E-03_JPRB, &
     & 2.55995E-03_JPRB, 2.61040E-03_JPRB, 2.66184E-03_JPRB, 2.71430E-03_JPRB, 2.76779E-03_JPRB, &
     & 2.82234E-03_JPRB, 2.87796E-03_JPRB, 2.93467E-03_JPRB, 2.99251E-03_JPRB/)
      KAO_MCO2( 3, :,16) = (/ &
     & 2.10609E-03_JPRB, 2.14759E-03_JPRB, 2.18992E-03_JPRB, 2.23307E-03_JPRB, 2.27708E-03_JPRB, &
     & 2.32196E-03_JPRB, 2.36771E-03_JPRB, 2.41438E-03_JPRB, 2.46196E-03_JPRB, 2.51047E-03_JPRB, &
     & 2.55995E-03_JPRB, 2.61040E-03_JPRB, 2.66184E-03_JPRB, 2.71430E-03_JPRB, 2.76779E-03_JPRB, &
     & 2.82234E-03_JPRB, 2.87796E-03_JPRB, 2.93467E-03_JPRB, 2.99251E-03_JPRB/)
      KAO_MCO2( 4, :,16) = (/ &
     & 2.10609E-03_JPRB, 2.14759E-03_JPRB, 2.18992E-03_JPRB, 2.23307E-03_JPRB, 2.27708E-03_JPRB, &
     & 2.32196E-03_JPRB, 2.36771E-03_JPRB, 2.41438E-03_JPRB, 2.46196E-03_JPRB, 2.51047E-03_JPRB, &
     & 2.55995E-03_JPRB, 2.61040E-03_JPRB, 2.66184E-03_JPRB, 2.71430E-03_JPRB, 2.76779E-03_JPRB, &
     & 2.82234E-03_JPRB, 2.87796E-03_JPRB, 2.93467E-03_JPRB, 2.99251E-03_JPRB/)
      KAO_MCO2( 5, :,16) = (/ &
     & 2.10609E-03_JPRB, 2.14759E-03_JPRB, 2.18992E-03_JPRB, 2.23307E-03_JPRB, 2.27708E-03_JPRB, &
     & 2.32196E-03_JPRB, 2.36771E-03_JPRB, 2.41438E-03_JPRB, 2.46196E-03_JPRB, 2.51047E-03_JPRB, &
     & 2.55995E-03_JPRB, 2.61040E-03_JPRB, 2.66184E-03_JPRB, 2.71430E-03_JPRB, 2.76779E-03_JPRB, &
     & 2.82234E-03_JPRB, 2.87796E-03_JPRB, 2.93467E-03_JPRB, 2.99251E-03_JPRB/)
      KAO_MCO2( 6, :,16) = (/ &
     & 2.10609E-03_JPRB, 2.14759E-03_JPRB, 2.18992E-03_JPRB, 2.23307E-03_JPRB, 2.27708E-03_JPRB, &
     & 2.32196E-03_JPRB, 2.36771E-03_JPRB, 2.41438E-03_JPRB, 2.46196E-03_JPRB, 2.51047E-03_JPRB, &
     & 2.55995E-03_JPRB, 2.61040E-03_JPRB, 2.66184E-03_JPRB, 2.71430E-03_JPRB, 2.76779E-03_JPRB, &
     & 2.82234E-03_JPRB, 2.87796E-03_JPRB, 2.93467E-03_JPRB, 2.99251E-03_JPRB/)
      KAO_MCO2( 7, :,16) = (/ &
     & 2.09970E-03_JPRB, 2.14101E-03_JPRB, 2.18312E-03_JPRB, 2.22606E-03_JPRB, 2.26985E-03_JPRB, &
     & 2.31450E-03_JPRB, 2.36003E-03_JPRB, 2.40645E-03_JPRB, 2.45379E-03_JPRB, 2.50205E-03_JPRB, &
     & 2.55127E-03_JPRB, 2.60146E-03_JPRB, 2.65263E-03_JPRB, 2.70481E-03_JPRB, 2.75801E-03_JPRB, &
     & 2.81226E-03_JPRB, 2.86758E-03_JPRB, 2.92399E-03_JPRB, 2.98150E-03_JPRB/)
      KAO_MCO2( 8, :,16) = (/ &
     & 2.09970E-03_JPRB, 2.14101E-03_JPRB, 2.18312E-03_JPRB, 2.22606E-03_JPRB, 2.26985E-03_JPRB, &
     & 2.31450E-03_JPRB, 2.36003E-03_JPRB, 2.40645E-03_JPRB, 2.45379E-03_JPRB, 2.50205E-03_JPRB, &
     & 2.55127E-03_JPRB, 2.60146E-03_JPRB, 2.65263E-03_JPRB, 2.70481E-03_JPRB, 2.75801E-03_JPRB, &
     & 2.81226E-03_JPRB, 2.86758E-03_JPRB, 2.92399E-03_JPRB, 2.98150E-03_JPRB/)
      KAO_MCO2( 9, :,16) = (/ &
     & 2.10609E-03_JPRB, 2.14759E-03_JPRB, 2.18992E-03_JPRB, 2.23307E-03_JPRB, 2.27708E-03_JPRB, &
     & 2.32196E-03_JPRB, 2.36771E-03_JPRB, 2.41438E-03_JPRB, 2.46196E-03_JPRB, 2.51047E-03_JPRB, &
     & 2.55995E-03_JPRB, 2.61040E-03_JPRB, 2.66184E-03_JPRB, 2.71430E-03_JPRB, 2.76779E-03_JPRB, &
     & 2.82234E-03_JPRB, 2.87796E-03_JPRB, 2.93467E-03_JPRB, 2.99251E-03_JPRB/)

      KAO_MCO( 1, :, 1) = (/ &
     & 4.58355E-01_JPRB, 4.47074E-01_JPRB, 4.36070E-01_JPRB, 4.25337E-01_JPRB, 4.14868E-01_JPRB, &
     & 4.04657E-01_JPRB, 3.94697E-01_JPRB, 3.84982E-01_JPRB, 3.75506E-01_JPRB, 3.66264E-01_JPRB, &
     & 3.57249E-01_JPRB, 3.48456E-01_JPRB, 3.39879E-01_JPRB, 3.31514E-01_JPRB, 3.23354E-01_JPRB, &
     & 3.15395E-01_JPRB, 3.07632E-01_JPRB, 3.00061E-01_JPRB, 2.92675E-01_JPRB/)
      KAO_MCO( 2, :, 1) = (/ &
     & 7.03080E-01_JPRB, 6.84132E-01_JPRB, 6.65696E-01_JPRB, 6.47756E-01_JPRB, 6.30300E-01_JPRB, &
     & 6.13314E-01_JPRB, 5.96786E-01_JPRB, 5.80703E-01_JPRB, 5.65053E-01_JPRB, 5.49826E-01_JPRB, &
     & 5.35009E-01_JPRB, 5.20591E-01_JPRB, 5.06561E-01_JPRB, 4.92910E-01_JPRB, 4.79627E-01_JPRB, &
     & 4.66701E-01_JPRB, 4.54124E-01_JPRB, 4.41886E-01_JPRB, 4.29978E-01_JPRB/)
      KAO_MCO( 3, :, 1) = (/ &
     & 8.53018E-01_JPRB, 8.29537E-01_JPRB, 8.06703E-01_JPRB, 7.84497E-01_JPRB, 7.62903E-01_JPRB, &
     & 7.41903E-01_JPRB, 7.21481E-01_JPRB, 7.01621E-01_JPRB, 6.82307E-01_JPRB, 6.63526E-01_JPRB, &
     & 6.45261E-01_JPRB, 6.27499E-01_JPRB, 6.10226E-01_JPRB, 5.93429E-01_JPRB, 5.77094E-01_JPRB, &
     & 5.61208E-01_JPRB, 5.45760E-01_JPRB, 5.30737E-01_JPRB, 5.16128E-01_JPRB/)
      KAO_MCO( 4, :, 1) = (/ &
     & 9.58866E-01_JPRB, 9.31881E-01_JPRB, 9.05654E-01_JPRB, 8.80166E-01_JPRB, 8.55395E-01_JPRB, &
     & 8.31321E-01_JPRB, 8.07925E-01_JPRB, 7.85187E-01_JPRB, 7.63089E-01_JPRB, 7.41613E-01_JPRB, &
     & 7.20742E-01_JPRB, 7.00457E-01_JPRB, 6.80744E-01_JPRB, 6.61586E-01_JPRB, 6.42966E-01_JPRB, &
     & 6.24871E-01_JPRB, 6.07285E-01_JPRB, 5.90194E-01_JPRB, 5.73584E-01_JPRB/)
      KAO_MCO( 5, :, 1) = (/ &
     & 1.07140E+00_JPRB, 1.04056E+00_JPRB, 1.01061E+00_JPRB, 9.81521E-01_JPRB, 9.53269E-01_JPRB, &
     & 9.25829E-01_JPRB, 8.99180E-01_JPRB, 8.73297E-01_JPRB, 8.48160E-01_JPRB, 8.23746E-01_JPRB, &
     & 8.00035E-01_JPRB, 7.77006E-01_JPRB, 7.54641E-01_JPRB, 7.32919E-01_JPRB, 7.11822E-01_JPRB, &
     & 6.91333E-01_JPRB, 6.71433E-01_JPRB, 6.52106E-01_JPRB, 6.33336E-01_JPRB/)
      KAO_MCO( 6, :, 1) = (/ &
     & 1.21046E+00_JPRB, 1.17478E+00_JPRB, 1.14015E+00_JPRB, 1.10655E+00_JPRB, 1.07393E+00_JPRB, &
     & 1.04228E+00_JPRB, 1.01156E+00_JPRB, 9.81740E-01_JPRB, 9.52803E-01_JPRB, 9.24720E-01_JPRB, &
     & 8.97463E-01_JPRB, 8.71011E-01_JPRB, 8.45338E-01_JPRB, 8.20422E-01_JPRB, 7.96240E-01_JPRB, &
     & 7.72771E-01_JPRB, 7.49993E-01_JPRB, 7.27887E-01_JPRB, 7.06433E-01_JPRB/)
      KAO_MCO( 7, :, 1) = (/ &
     & 1.57730E+00_JPRB, 1.52919E+00_JPRB, 1.48255E+00_JPRB, 1.43733E+00_JPRB, 1.39349E+00_JPRB, &
     & 1.35099E+00_JPRB, 1.30978E+00_JPRB, 1.26983E+00_JPRB, 1.23110E+00_JPRB, 1.19355E+00_JPRB, &
     & 1.15715E+00_JPRB, 1.12186E+00_JPRB, 1.08764E+00_JPRB, 1.05446E+00_JPRB, 1.02230E+00_JPRB, &
     & 9.91121E-01_JPRB, 9.60890E-01_JPRB, 9.31583E-01_JPRB, 9.03169E-01_JPRB/)
      KAO_MCO( 8, :, 1) = (/ &
     & 2.43678E+00_JPRB, 2.36595E+00_JPRB, 2.29719E+00_JPRB, 2.23042E+00_JPRB, 2.16560E+00_JPRB, &
     & 2.10266E+00_JPRB, 2.04154E+00_JPRB, 1.98221E+00_JPRB, 1.92460E+00_JPRB, 1.86866E+00_JPRB, &
     & 1.81435E+00_JPRB, 1.76162E+00_JPRB, 1.71042E+00_JPRB, 1.66070E+00_JPRB, 1.61244E+00_JPRB, &
     & 1.56557E+00_JPRB, 1.52007E+00_JPRB, 1.47589E+00_JPRB, 1.43300E+00_JPRB/)
      KAO_MCO( 9, :, 1) = (/ &
     & 9.66296E-01_JPRB, 9.39903E-01_JPRB, 9.14232E-01_JPRB, 8.89262E-01_JPRB, 8.64973E-01_JPRB, &
     & 8.41348E-01_JPRB, 8.18369E-01_JPRB, 7.96017E-01_JPRB, 7.74275E-01_JPRB, 7.53128E-01_JPRB, &
     & 7.32558E-01_JPRB, 7.12549E-01_JPRB, 6.93088E-01_JPRB, 6.74157E-01_JPRB, 6.55744E-01_JPRB, &
     & 6.37834E-01_JPRB, 6.20413E-01_JPRB, 6.03468E-01_JPRB, 5.86985E-01_JPRB/)
      KAO_MCO( 1, :, 2) = (/ &
     & 1.15047E+00_JPRB, 1.12127E+00_JPRB, 1.09281E+00_JPRB, 1.06507E+00_JPRB, 1.03804E+00_JPRB, &
     & 1.01169E+00_JPRB, 9.86010E-01_JPRB, 9.60983E-01_JPRB, 9.36591E-01_JPRB, 9.12818E-01_JPRB, &
     & 8.89649E-01_JPRB, 8.67067E-01_JPRB, 8.45059E-01_JPRB, 8.23610E-01_JPRB, 8.02705E-01_JPRB, &
     & 7.82330E-01_JPRB, 7.62473E-01_JPRB, 7.43119E-01_JPRB, 7.24257E-01_JPRB/)
      KAO_MCO( 2, :, 2) = (/ &
     & 1.43243E+00_JPRB, 1.39430E+00_JPRB, 1.35719E+00_JPRB, 1.32106E+00_JPRB, 1.28590E+00_JPRB, &
     & 1.25167E+00_JPRB, 1.21836E+00_JPRB, 1.18593E+00_JPRB, 1.15436E+00_JPRB, 1.12364E+00_JPRB, &
     & 1.09373E+00_JPRB, 1.06462E+00_JPRB, 1.03628E+00_JPRB, 1.00870E+00_JPRB, 9.81848E-01_JPRB, &
     & 9.55714E-01_JPRB, 9.30275E-01_JPRB, 9.05514E-01_JPRB, 8.81412E-01_JPRB/)
      KAO_MCO( 3, :, 2) = (/ &
     & 1.61389E+00_JPRB, 1.56911E+00_JPRB, 1.52556E+00_JPRB, 1.48323E+00_JPRB, 1.44207E+00_JPRB, &
     & 1.40205E+00_JPRB, 1.36314E+00_JPRB, 1.32531E+00_JPRB, 1.28854E+00_JPRB, 1.25278E+00_JPRB, &
     & 1.21801E+00_JPRB, 1.18421E+00_JPRB, 1.15135E+00_JPRB, 1.11940E+00_JPRB, 1.08834E+00_JPRB, &
     & 1.05814E+00_JPRB, 1.02877E+00_JPRB, 1.00022E+00_JPRB, 9.72466E-01_JPRB/)
      KAO_MCO( 4, :, 2) = (/ &
     & 1.78458E+00_JPRB, 1.73440E+00_JPRB, 1.68564E+00_JPRB, 1.63825E+00_JPRB, 1.59219E+00_JPRB, &
     & 1.54742E+00_JPRB, 1.50391E+00_JPRB, 1.46163E+00_JPRB, 1.42053E+00_JPRB, 1.38059E+00_JPRB, &
     & 1.34178E+00_JPRB, 1.30405E+00_JPRB, 1.26739E+00_JPRB, 1.23175E+00_JPRB, 1.19712E+00_JPRB, &
     & 1.16346E+00_JPRB, 1.13075E+00_JPRB, 1.09896E+00_JPRB, 1.06806E+00_JPRB/)
      KAO_MCO( 5, :, 2) = (/ &
     & 1.92622E+00_JPRB, 1.87172E+00_JPRB, 1.81876E+00_JPRB, 1.76730E+00_JPRB, 1.71730E+00_JPRB, &
     & 1.66871E+00_JPRB, 1.62150E+00_JPRB, 1.57562E+00_JPRB, 1.53104E+00_JPRB, 1.48772E+00_JPRB, &
     & 1.44563E+00_JPRB, 1.40473E+00_JPRB, 1.36498E+00_JPRB, 1.32636E+00_JPRB, 1.28883E+00_JPRB, &
     & 1.25237E+00_JPRB, 1.21693E+00_JPRB, 1.18250E+00_JPRB, 1.14905E+00_JPRB/)
      KAO_MCO( 6, :, 2) = (/ &
     & 2.23194E+00_JPRB, 2.16782E+00_JPRB, 2.10554E+00_JPRB, 2.04505E+00_JPRB, 1.98630E+00_JPRB, &
     & 1.92924E+00_JPRB, 1.87381E+00_JPRB, 1.81998E+00_JPRB, 1.76770E+00_JPRB, 1.71691E+00_JPRB, &
     & 1.66759E+00_JPRB, 1.61968E+00_JPRB, 1.57315E+00_JPRB, 1.52796E+00_JPRB, 1.48406E+00_JPRB, &
     & 1.44143E+00_JPRB, 1.40002E+00_JPRB, 1.35980E+00_JPRB, 1.32073E+00_JPRB/)
      KAO_MCO( 7, :, 2) = (/ &
     & 2.64692E+00_JPRB, 2.57290E+00_JPRB, 2.50096E+00_JPRB, 2.43103E+00_JPRB, 2.36305E+00_JPRB, &
     & 2.29697E+00_JPRB, 2.23275E+00_JPRB, 2.17031E+00_JPRB, 2.10963E+00_JPRB, 2.05064E+00_JPRB, &
     & 1.99330E+00_JPRB, 1.93756E+00_JPRB, 1.88338E+00_JPRB, 1.83072E+00_JPRB, 1.77953E+00_JPRB, &
     & 1.72977E+00_JPRB, 1.68140E+00_JPRB, 1.63438E+00_JPRB, 1.58868E+00_JPRB/)
      KAO_MCO( 8, :, 2) = (/ &
     & 2.86812E+00_JPRB, 2.80121E+00_JPRB, 2.73586E+00_JPRB, 2.67204E+00_JPRB, 2.60970E+00_JPRB, &
     & 2.54882E+00_JPRB, 2.48936E+00_JPRB, 2.43129E+00_JPRB, 2.37457E+00_JPRB, 2.31917E+00_JPRB, &
     & 2.26507E+00_JPRB, 2.21223E+00_JPRB, 2.16062E+00_JPRB, 2.11022E+00_JPRB, 2.06099E+00_JPRB, &
     & 2.01291E+00_JPRB, 1.96595E+00_JPRB, 1.92009E+00_JPRB, 1.87529E+00_JPRB/)
      KAO_MCO( 9, :, 2) = (/ &
     & 1.25243E+00_JPRB, 1.22790E+00_JPRB, 1.20385E+00_JPRB, 1.18027E+00_JPRB, 1.15716E+00_JPRB, &
     & 1.13449E+00_JPRB, 1.11227E+00_JPRB, 1.09049E+00_JPRB, 1.06913E+00_JPRB, 1.04819E+00_JPRB, &
     & 1.02766E+00_JPRB, 1.00754E+00_JPRB, 9.87804E-01_JPRB, 9.68457E-01_JPRB, 9.49490E-01_JPRB, &
     & 9.30894E-01_JPRB, 9.12662E-01_JPRB, 8.94787E-01_JPRB, 8.77263E-01_JPRB/)
      KAO_MCO( 1, :, 3) = (/ &
     & 2.55598E+00_JPRB, 2.48729E+00_JPRB, 2.42045E+00_JPRB, 2.35541E+00_JPRB, 2.29211E+00_JPRB, &
     & 2.23052E+00_JPRB, 2.17058E+00_JPRB, 2.11225E+00_JPRB, 2.05549E+00_JPRB, 2.00025E+00_JPRB, &
     & 1.94650E+00_JPRB, 1.89419E+00_JPRB, 1.84329E+00_JPRB, 1.79376E+00_JPRB, 1.74555E+00_JPRB, &
     & 1.69865E+00_JPRB, 1.65300E+00_JPRB, 1.60858E+00_JPRB, 1.56535E+00_JPRB/)
      KAO_MCO( 2, :, 3) = (/ &
     & 2.93113E+00_JPRB, 2.85257E+00_JPRB, 2.77612E+00_JPRB, 2.70172E+00_JPRB, 2.62932E+00_JPRB, &
     & 2.55885E+00_JPRB, 2.49028E+00_JPRB, 2.42354E+00_JPRB, 2.35859E+00_JPRB, 2.29538E+00_JPRB, &
     & 2.23386E+00_JPRB, 2.17400E+00_JPRB, 2.11573E+00_JPRB, 2.05903E+00_JPRB, 2.00385E+00_JPRB, &
     & 1.95015E+00_JPRB, 1.89788E+00_JPRB, 1.84702E+00_JPRB, 1.79752E+00_JPRB/)
      KAO_MCO( 3, :, 3) = (/ &
     & 3.26626E+00_JPRB, 3.18025E+00_JPRB, 3.09651E+00_JPRB, 3.01497E+00_JPRB, 2.93558E+00_JPRB, &
     & 2.85828E+00_JPRB, 2.78302E+00_JPRB, 2.70973E+00_JPRB, 2.63838E+00_JPRB, 2.56891E+00_JPRB, &
     & 2.50126E+00_JPRB, 2.43540E+00_JPRB, 2.37127E+00_JPRB, 2.30883E+00_JPRB, 2.24803E+00_JPRB, &
     & 2.18883E+00_JPRB, 2.13120E+00_JPRB, 2.07508E+00_JPRB, 2.02044E+00_JPRB/)
      KAO_MCO( 4, :, 3) = (/ &
     & 3.65895E+00_JPRB, 3.56418E+00_JPRB, 3.47187E+00_JPRB, 3.38194E+00_JPRB, 3.29435E+00_JPRB, &
     & 3.20903E+00_JPRB, 3.12591E+00_JPRB, 3.04495E+00_JPRB, 2.96608E+00_JPRB, 2.88926E+00_JPRB, &
     & 2.81443E+00_JPRB, 2.74153E+00_JPRB, 2.67053E+00_JPRB, 2.60136E+00_JPRB, 2.53398E+00_JPRB, &
     & 2.46835E+00_JPRB, 2.40442E+00_JPRB, 2.34214E+00_JPRB, 2.28148E+00_JPRB/)
      KAO_MCO( 5, :, 3) = (/ &
     & 4.13692E+00_JPRB, 4.03459E+00_JPRB, 3.93479E+00_JPRB, 3.83746E+00_JPRB, 3.74254E+00_JPRB, &
     & 3.64997E+00_JPRB, 3.55968E+00_JPRB, 3.47163E+00_JPRB, 3.38576E+00_JPRB, 3.30201E+00_JPRB, &
     & 3.22034E+00_JPRB, 3.14068E+00_JPRB, 3.06299E+00_JPRB, 2.98723E+00_JPRB, 2.91334E+00_JPRB, &
     & 2.84128E+00_JPRB, 2.77100E+00_JPRB, 2.70246E+00_JPRB, 2.63561E+00_JPRB/)
      KAO_MCO( 6, :, 3) = (/ &
     & 4.42856E+00_JPRB, 4.32480E+00_JPRB, 4.22348E+00_JPRB, 4.12453E+00_JPRB, 4.02790E+00_JPRB, &
     & 3.93353E+00_JPRB, 3.84137E+00_JPRB, 3.75137E+00_JPRB, 3.66348E+00_JPRB, 3.57765E+00_JPRB, &
     & 3.49383E+00_JPRB, 3.41198E+00_JPRB, 3.33204E+00_JPRB, 3.25397E+00_JPRB, 3.17774E+00_JPRB, &
     & 3.10329E+00_JPRB, 3.03058E+00_JPRB, 2.95958E+00_JPRB, 2.89024E+00_JPRB/)
      KAO_MCO( 7, :, 3) = (/ &
     & 4.31306E+00_JPRB, 4.21750E+00_JPRB, 4.12406E+00_JPRB, 4.03268E+00_JPRB, 3.94333E+00_JPRB, &
     & 3.85596E+00_JPRB, 3.77053E+00_JPRB, 3.68699E+00_JPRB, 3.60530E+00_JPRB, 3.52542E+00_JPRB, &
     & 3.44731E+00_JPRB, 3.37093E+00_JPRB, 3.29624E+00_JPRB, 3.22321E+00_JPRB, 3.15179E+00_JPRB, &
     & 3.08196E+00_JPRB, 3.01368E+00_JPRB, 2.94691E+00_JPRB, 2.88161E+00_JPRB/)
      KAO_MCO( 8, :, 3) = (/ &
     & 4.38922E+00_JPRB, 4.32180E+00_JPRB, 4.25543E+00_JPRB, 4.19007E+00_JPRB, 4.12571E+00_JPRB, &
     & 4.06234E+00_JPRB, 3.99995E+00_JPRB, 3.93851E+00_JPRB, 3.87802E+00_JPRB, 3.81846E+00_JPRB, &
     & 3.75981E+00_JPRB, 3.70206E+00_JPRB, 3.64520E+00_JPRB, 3.58922E+00_JPRB, 3.53409E+00_JPRB, &
     & 3.47981E+00_JPRB, 3.42636E+00_JPRB, 3.37374E+00_JPRB, 3.32192E+00_JPRB/)
      KAO_MCO( 9, :, 3) = (/ &
     & 1.56810E+00_JPRB, 1.54211E+00_JPRB, 1.51654E+00_JPRB, 1.49139E+00_JPRB, 1.46667E+00_JPRB, &
     & 1.44235E+00_JPRB, 1.41844E+00_JPRB, 1.39492E+00_JPRB, 1.37179E+00_JPRB, 1.34905E+00_JPRB, &
     & 1.32668E+00_JPRB, 1.30469E+00_JPRB, 1.28306E+00_JPRB, 1.26178E+00_JPRB, 1.24086E+00_JPRB, &
     & 1.22029E+00_JPRB, 1.20006E+00_JPRB, 1.18016E+00_JPRB, 1.16059E+00_JPRB/)
      KAO_MCO( 1, :, 4) = (/ &
     & 6.58275E+00_JPRB, 6.43026E+00_JPRB, 6.28130E+00_JPRB, 6.13579E+00_JPRB, 5.99365E+00_JPRB, &
     & 5.85481E+00_JPRB, 5.71918E+00_JPRB, 5.58669E+00_JPRB, 5.45727E+00_JPRB, 5.33085E+00_JPRB, &
     & 5.20736E+00_JPRB, 5.08673E+00_JPRB, 4.96889E+00_JPRB, 4.85379E+00_JPRB, 4.74135E+00_JPRB, &
     & 4.63151E+00_JPRB, 4.52422E+00_JPRB, 4.41942E+00_JPRB, 4.31704E+00_JPRB/)
      KAO_MCO( 2, :, 4) = (/ &
     & 6.59883E+00_JPRB, 6.45139E+00_JPRB, 6.30725E+00_JPRB, 6.16633E+00_JPRB, 6.02855E+00_JPRB, &
     & 5.89386E+00_JPRB, 5.76217E+00_JPRB, 5.63342E+00_JPRB, 5.50756E+00_JPRB, 5.38450E+00_JPRB, &
     & 5.26419E+00_JPRB, 5.14657E+00_JPRB, 5.03158E+00_JPRB, 4.91916E+00_JPRB, 4.80925E+00_JPRB, &
     & 4.70180E+00_JPRB, 4.59675E+00_JPRB, 4.49404E+00_JPRB, 4.39363E+00_JPRB/)
      KAO_MCO( 3, :, 4) = (/ &
     & 6.58521E+00_JPRB, 6.44452E+00_JPRB, 6.30683E+00_JPRB, 6.17209E+00_JPRB, 6.04023E+00_JPRB, &
     & 5.91118E+00_JPRB, 5.78489E+00_JPRB, 5.66130E+00_JPRB, 5.54034E+00_JPRB, 5.42198E+00_JPRB, &
     & 5.30614E+00_JPRB, 5.19277E+00_JPRB, 5.08183E+00_JPRB, 4.97326E+00_JPRB, 4.86701E+00_JPRB, &
     & 4.76303E+00_JPRB, 4.66127E+00_JPRB, 4.56168E+00_JPRB, 4.46422E+00_JPRB/)
      KAO_MCO( 4, :, 4) = (/ &
     & 6.33742E+00_JPRB, 6.20870E+00_JPRB, 6.08260E+00_JPRB, 5.95905E+00_JPRB, 5.83802E+00_JPRB, &
     & 5.71945E+00_JPRB, 5.60328E+00_JPRB, 5.48947E+00_JPRB, 5.37798E+00_JPRB, 5.26875E+00_JPRB, &
     & 5.16174E+00_JPRB, 5.05690E+00_JPRB, 4.95419E+00_JPRB, 4.85357E+00_JPRB, 4.75499E+00_JPRB, &
     & 4.65841E+00_JPRB, 4.56379E+00_JPRB, 4.47110E+00_JPRB, 4.38029E+00_JPRB/)
      KAO_MCO( 5, :, 4) = (/ &
     & 5.99732E+00_JPRB, 5.88459E+00_JPRB, 5.77398E+00_JPRB, 5.66545E+00_JPRB, 5.55896E+00_JPRB, &
     & 5.45447E+00_JPRB, 5.35194E+00_JPRB, 5.25134E+00_JPRB, 5.15263E+00_JPRB, 5.05578E+00_JPRB, &
     & 4.96075E+00_JPRB, 4.86750E+00_JPRB, 4.77601E+00_JPRB, 4.68623E+00_JPRB, 4.59815E+00_JPRB, &
     & 4.51171E+00_JPRB, 4.42691E+00_JPRB, 4.34370E+00_JPRB, 4.26205E+00_JPRB/)
      KAO_MCO( 6, :, 4) = (/ &
     & 5.74529E+00_JPRB, 5.65249E+00_JPRB, 5.56119E+00_JPRB, 5.47136E+00_JPRB, 5.38299E+00_JPRB, &
     & 5.29604E+00_JPRB, 5.21049E+00_JPRB, 5.12633E+00_JPRB, 5.04353E+00_JPRB, 4.96206E+00_JPRB, &
     & 4.88191E+00_JPRB, 4.80306E+00_JPRB, 4.72547E+00_JPRB, 4.64915E+00_JPRB, 4.57405E+00_JPRB, &
     & 4.50017E+00_JPRB, 4.42748E+00_JPRB, 4.35596E+00_JPRB, 4.28560E+00_JPRB/)
      KAO_MCO( 7, :, 4) = (/ &
     & 5.87251E+00_JPRB, 5.79956E+00_JPRB, 5.72753E+00_JPRB, 5.65638E+00_JPRB, 5.58613E+00_JPRB, &
     & 5.51674E+00_JPRB, 5.44822E+00_JPRB, 5.38054E+00_JPRB, 5.31371E+00_JPRB, 5.24771E+00_JPRB, &
     & 5.18253E+00_JPRB, 5.11815E+00_JPRB, 5.05458E+00_JPRB, 4.99180E+00_JPRB, 4.92979E+00_JPRB, &
     & 4.86856E+00_JPRB, 4.80809E+00_JPRB, 4.74837E+00_JPRB, 4.68939E+00_JPRB/)
      KAO_MCO( 8, :, 4) = (/ &
     & 5.68503E+00_JPRB, 5.62827E+00_JPRB, 5.57207E+00_JPRB, 5.51644E+00_JPRB, 5.46136E+00_JPRB, &
     & 5.40684E+00_JPRB, 5.35285E+00_JPRB, 5.29941E+00_JPRB, 5.24650E+00_JPRB, 5.19412E+00_JPRB, &
     & 5.14226E+00_JPRB, 5.09092E+00_JPRB, 5.04009E+00_JPRB, 4.98977E+00_JPRB, 4.93995E+00_JPRB, &
     & 4.89063E+00_JPRB, 4.84180E+00_JPRB, 4.79346E+00_JPRB, 4.74560E+00_JPRB/)
      KAO_MCO( 9, :, 4) = (/ &
     & 2.69278E+00_JPRB, 2.65058E+00_JPRB, 2.60903E+00_JPRB, 2.56814E+00_JPRB, 2.52789E+00_JPRB, &
     & 2.48827E+00_JPRB, 2.44927E+00_JPRB, 2.41088E+00_JPRB, 2.37310E+00_JPRB, 2.33590E+00_JPRB, &
     & 2.29929E+00_JPRB, 2.26325E+00_JPRB, 2.22778E+00_JPRB, 2.19286E+00_JPRB, 2.15849E+00_JPRB, &
     & 2.12466E+00_JPRB, 2.09136E+00_JPRB, 2.05859E+00_JPRB, 2.02632E+00_JPRB/)
      KAO_MCO( 1, :, 5) = (/ &
     & 9.12231E+00_JPRB, 9.00052E+00_JPRB, 8.88036E+00_JPRB, 8.76180E+00_JPRB, 8.64482E+00_JPRB, &
     & 8.52941E+00_JPRB, 8.41553E+00_JPRB, 8.30318E+00_JPRB, 8.19233E+00_JPRB, 8.08295E+00_JPRB, &
     & 7.97504E+00_JPRB, 7.86857E+00_JPRB, 7.76352E+00_JPRB, 7.65987E+00_JPRB, 7.55760E+00_JPRB, &
     & 7.45671E+00_JPRB, 7.35715E+00_JPRB, 7.25893E+00_JPRB, 7.16202E+00_JPRB/)
      KAO_MCO( 2, :, 5) = (/ &
     & 8.37315E+00_JPRB, 8.27808E+00_JPRB, 8.18410E+00_JPRB, 8.09118E+00_JPRB, 7.99931E+00_JPRB, &
     & 7.90849E+00_JPRB, 7.81871E+00_JPRB, 7.72994E+00_JPRB, 7.64217E+00_JPRB, 7.55541E+00_JPRB, &
     & 7.46963E+00_JPRB, 7.38482E+00_JPRB, 7.30098E+00_JPRB, 7.21809E+00_JPRB, 7.13614E+00_JPRB, &
     & 7.05512E+00_JPRB, 6.97502E+00_JPRB, 6.89582E+00_JPRB, 6.81753E+00_JPRB/)
      KAO_MCO( 3, :, 5) = (/ &
     & 8.14557E+00_JPRB, 8.06533E+00_JPRB, 7.98587E+00_JPRB, 7.90720E+00_JPRB, 7.82930E+00_JPRB, &
     & 7.75217E+00_JPRB, 7.67580E+00_JPRB, 7.60018E+00_JPRB, 7.52530E+00_JPRB, 7.45117E+00_JPRB, &
     & 7.37776E+00_JPRB, 7.30508E+00_JPRB, 7.23311E+00_JPRB, 7.16186E+00_JPRB, 7.09130E+00_JPRB, &
     & 7.02144E+00_JPRB, 6.95227E+00_JPRB, 6.88378E+00_JPRB, 6.81596E+00_JPRB/)
      KAO_MCO( 4, :, 5) = (/ &
     & 8.18046E+00_JPRB, 8.11056E+00_JPRB, 8.04126E+00_JPRB, 7.97256E+00_JPRB, 7.90444E+00_JPRB, &
     & 7.83690E+00_JPRB, 7.76994E+00_JPRB, 7.70355E+00_JPRB, 7.63773E+00_JPRB, 7.57247E+00_JPRB, &
     & 7.50777E+00_JPRB, 7.44362E+00_JPRB, 7.38002E+00_JPRB, 7.31697E+00_JPRB, 7.25445E+00_JPRB, &
     & 7.19247E+00_JPRB, 7.13101E+00_JPRB, 7.07008E+00_JPRB, 7.00968E+00_JPRB/)
      KAO_MCO( 5, :, 5) = (/ &
     & 8.30092E+00_JPRB, 8.23529E+00_JPRB, 8.17019E+00_JPRB, 8.10559E+00_JPRB, 8.04151E+00_JPRB, &
     & 7.97794E+00_JPRB, 7.91487E+00_JPRB, 7.85230E+00_JPRB, 7.79022E+00_JPRB, 7.72863E+00_JPRB, &
     & 7.66753E+00_JPRB, 7.60691E+00_JPRB, 7.54678E+00_JPRB, 7.48711E+00_JPRB, 7.42792E+00_JPRB, &
     & 7.36920E+00_JPRB, 7.31094E+00_JPRB, 7.25314E+00_JPRB, 7.19580E+00_JPRB/)
      KAO_MCO( 6, :, 5) = (/ &
     & 8.30014E+00_JPRB, 8.24466E+00_JPRB, 8.18955E+00_JPRB, 8.13481E+00_JPRB, 8.08044E+00_JPRB, &
     & 8.02642E+00_JPRB, 7.97277E+00_JPRB, 7.91948E+00_JPRB, 7.86655E+00_JPRB, 7.81396E+00_JPRB, &
     & 7.76173E+00_JPRB, 7.70985E+00_JPRB, 7.65832E+00_JPRB, 7.60713E+00_JPRB, 7.55628E+00_JPRB, &
     & 7.50577E+00_JPRB, 7.45560E+00_JPRB, 7.40577E+00_JPRB, 7.35627E+00_JPRB/)
      KAO_MCO( 7, :, 5) = (/ &
     & 7.95931E+00_JPRB, 7.93958E+00_JPRB, 7.91989E+00_JPRB, 7.90025E+00_JPRB, 7.88066E+00_JPRB, &
     & 7.86112E+00_JPRB, 7.84163E+00_JPRB, 7.82219E+00_JPRB, 7.80279E+00_JPRB, 7.78344E+00_JPRB, &
     & 7.76414E+00_JPRB, 7.74489E+00_JPRB, 7.72568E+00_JPRB, 7.70653E+00_JPRB, 7.68742E+00_JPRB, &
     & 7.66836E+00_JPRB, 7.64934E+00_JPRB, 7.63038E+00_JPRB, 7.61146E+00_JPRB/)
      KAO_MCO( 8, :, 5) = (/ &
     & 9.32576E+00_JPRB, 9.31747E+00_JPRB, 9.30919E+00_JPRB, 9.30092E+00_JPRB, 9.29265E+00_JPRB, &
     & 9.28439E+00_JPRB, 9.27613E+00_JPRB, 9.26789E+00_JPRB, 9.25965E+00_JPRB, 9.25142E+00_JPRB, &
     & 9.24320E+00_JPRB, 9.23498E+00_JPRB, 9.22677E+00_JPRB, 9.21857E+00_JPRB, 9.21038E+00_JPRB, &
     & 9.20219E+00_JPRB, 9.19401E+00_JPRB, 9.18584E+00_JPRB, 9.17767E+00_JPRB/)
      KAO_MCO( 9, :, 5) = (/ &
     & 4.13116E+00_JPRB, 4.08426E+00_JPRB, 4.03788E+00_JPRB, 3.99204E+00_JPRB, 3.94671E+00_JPRB, &
     & 3.90190E+00_JPRB, 3.85760E+00_JPRB, 3.81380E+00_JPRB, 3.77049E+00_JPRB, 3.72768E+00_JPRB, &
     & 3.68536E+00_JPRB, 3.64351E+00_JPRB, 3.60214E+00_JPRB, 3.56124E+00_JPRB, 3.52081E+00_JPRB, &
     & 3.48083E+00_JPRB, 3.44131E+00_JPRB, 3.40224E+00_JPRB, 3.36361E+00_JPRB/)
      KAO_MCO( 1, :, 6) = (/ &
     & 1.21200E+01_JPRB, 1.21580E+01_JPRB, 1.21961E+01_JPRB, 1.22344E+01_JPRB, 1.22728E+01_JPRB, &
     & 1.23113E+01_JPRB, 1.23499E+01_JPRB, 1.23886E+01_JPRB, 1.24275E+01_JPRB, 1.24664E+01_JPRB, &
     & 1.25056E+01_JPRB, 1.25448E+01_JPRB, 1.25841E+01_JPRB, 1.26236E+01_JPRB, 1.26632E+01_JPRB, &
     & 1.27029E+01_JPRB, 1.27428E+01_JPRB, 1.27827E+01_JPRB, 1.28228E+01_JPRB/)
      KAO_MCO( 2, :, 6) = (/ &
     & 1.25231E+01_JPRB, 1.25625E+01_JPRB, 1.26020E+01_JPRB, 1.26417E+01_JPRB, 1.26815E+01_JPRB, &
     & 1.27214E+01_JPRB, 1.27614E+01_JPRB, 1.28015E+01_JPRB, 1.28418E+01_JPRB, 1.28822E+01_JPRB, &
     & 1.29228E+01_JPRB, 1.29634E+01_JPRB, 1.30042E+01_JPRB, 1.30451E+01_JPRB, 1.30862E+01_JPRB, &
     & 1.31274E+01_JPRB, 1.31687E+01_JPRB, 1.32101E+01_JPRB, 1.32517E+01_JPRB/)
      KAO_MCO( 3, :, 6) = (/ &
     & 1.27566E+01_JPRB, 1.27983E+01_JPRB, 1.28401E+01_JPRB, 1.28820E+01_JPRB, 1.29241E+01_JPRB, &
     & 1.29663E+01_JPRB, 1.30087E+01_JPRB, 1.30512E+01_JPRB, 1.30938E+01_JPRB, 1.31366E+01_JPRB, &
     & 1.31795E+01_JPRB, 1.32225E+01_JPRB, 1.32657E+01_JPRB, 1.33090E+01_JPRB, 1.33525E+01_JPRB, &
     & 1.33961E+01_JPRB, 1.34399E+01_JPRB, 1.34838E+01_JPRB, 1.35278E+01_JPRB/)
      KAO_MCO( 4, :, 6) = (/ &
     & 1.27132E+01_JPRB, 1.27454E+01_JPRB, 1.27777E+01_JPRB, 1.28101E+01_JPRB, 1.28425E+01_JPRB, &
     & 1.28750E+01_JPRB, 1.29077E+01_JPRB, 1.29403E+01_JPRB, 1.29731E+01_JPRB, 1.30060E+01_JPRB, &
     & 1.30389E+01_JPRB, 1.30720E+01_JPRB, 1.31051E+01_JPRB, 1.31383E+01_JPRB, 1.31716E+01_JPRB, &
     & 1.32049E+01_JPRB, 1.32384E+01_JPRB, 1.32719E+01_JPRB, 1.33055E+01_JPRB/)
      KAO_MCO( 5, :, 6) = (/ &
     & 1.33151E+01_JPRB, 1.33523E+01_JPRB, 1.33896E+01_JPRB, 1.34271E+01_JPRB, 1.34646E+01_JPRB, &
     & 1.35022E+01_JPRB, 1.35400E+01_JPRB, 1.35779E+01_JPRB, 1.36158E+01_JPRB, 1.36539E+01_JPRB, &
     & 1.36921E+01_JPRB, 1.37303E+01_JPRB, 1.37687E+01_JPRB, 1.38072E+01_JPRB, 1.38458E+01_JPRB, &
     & 1.38846E+01_JPRB, 1.39234E+01_JPRB, 1.39623E+01_JPRB, 1.40013E+01_JPRB/)
      KAO_MCO( 6, :, 6) = (/ &
     & 1.41448E+01_JPRB, 1.41902E+01_JPRB, 1.42357E+01_JPRB, 1.42814E+01_JPRB, 1.43272E+01_JPRB, &
     & 1.43732E+01_JPRB, 1.44194E+01_JPRB, 1.44656E+01_JPRB, 1.45121E+01_JPRB, 1.45586E+01_JPRB, &
     & 1.46054E+01_JPRB, 1.46522E+01_JPRB, 1.46993E+01_JPRB, 1.47464E+01_JPRB, 1.47938E+01_JPRB, &
     & 1.48413E+01_JPRB, 1.48889E+01_JPRB, 1.49367E+01_JPRB, 1.49846E+01_JPRB/)
      KAO_MCO( 7, :, 6) = (/ &
     & 1.56578E+01_JPRB, 1.56938E+01_JPRB, 1.57299E+01_JPRB, 1.57661E+01_JPRB, 1.58024E+01_JPRB, &
     & 1.58388E+01_JPRB, 1.58752E+01_JPRB, 1.59117E+01_JPRB, 1.59484E+01_JPRB, 1.59851E+01_JPRB, &
     & 1.60218E+01_JPRB, 1.60587E+01_JPRB, 1.60957E+01_JPRB, 1.61327E+01_JPRB, 1.61698E+01_JPRB, &
     & 1.62070E+01_JPRB, 1.62443E+01_JPRB, 1.62817E+01_JPRB, 1.63192E+01_JPRB/)
      KAO_MCO( 8, :, 6) = (/ &
     & 1.73627E+01_JPRB, 1.74761E+01_JPRB, 1.75903E+01_JPRB, 1.77052E+01_JPRB, 1.78208E+01_JPRB, &
     & 1.79373E+01_JPRB, 1.80544E+01_JPRB, 1.81724E+01_JPRB, 1.82911E+01_JPRB, 1.84106E+01_JPRB, &
     & 1.85309E+01_JPRB, 1.86519E+01_JPRB, 1.87738E+01_JPRB, 1.88964E+01_JPRB, 1.90198E+01_JPRB, &
     & 1.91441E+01_JPRB, 1.92692E+01_JPRB, 1.93950E+01_JPRB, 1.95217E+01_JPRB/)
      KAO_MCO( 9, :, 6) = (/ &
     & 7.16326E+00_JPRB, 7.12921E+00_JPRB, 7.09531E+00_JPRB, 7.06158E+00_JPRB, 7.02800E+00_JPRB, &
     & 6.99459E+00_JPRB, 6.96133E+00_JPRB, 6.92824E+00_JPRB, 6.89530E+00_JPRB, 6.86252E+00_JPRB, &
     & 6.82989E+00_JPRB, 6.79742E+00_JPRB, 6.76510E+00_JPRB, 6.73293E+00_JPRB, 6.70092E+00_JPRB, &
     & 6.66906E+00_JPRB, 6.63736E+00_JPRB, 6.60580E+00_JPRB, 6.57439E+00_JPRB/)
      KAO_MCO( 1, :, 7) = (/ &
     & 2.09288E+01_JPRB, 2.10487E+01_JPRB, 2.11692E+01_JPRB, 2.12904E+01_JPRB, 2.14124E+01_JPRB, &
     & 2.15350E+01_JPRB, 2.16583E+01_JPRB, 2.17823E+01_JPRB, 2.19070E+01_JPRB, 2.20325E+01_JPRB, &
     & 2.21587E+01_JPRB, 2.22855E+01_JPRB, 2.24132E+01_JPRB, 2.25415E+01_JPRB, 2.26706E+01_JPRB, &
     & 2.28004E+01_JPRB, 2.29310E+01_JPRB, 2.30623E+01_JPRB, 2.31943E+01_JPRB/)
      KAO_MCO( 2, :, 7) = (/ &
     & 2.08159E+01_JPRB, 2.09509E+01_JPRB, 2.10867E+01_JPRB, 2.12234E+01_JPRB, 2.13610E+01_JPRB, &
     & 2.14994E+01_JPRB, 2.16388E+01_JPRB, 2.17791E+01_JPRB, 2.19202E+01_JPRB, 2.20623E+01_JPRB, &
     & 2.22053E+01_JPRB, 2.23493E+01_JPRB, 2.24942E+01_JPRB, 2.26400E+01_JPRB, 2.27867E+01_JPRB, &
     & 2.29345E+01_JPRB, 2.30831E+01_JPRB, 2.32328E+01_JPRB, 2.33834E+01_JPRB/)
      KAO_MCO( 3, :, 7) = (/ &
     & 2.10827E+01_JPRB, 2.12409E+01_JPRB, 2.14002E+01_JPRB, 2.15608E+01_JPRB, 2.17225E+01_JPRB, &
     & 2.18855E+01_JPRB, 2.20497E+01_JPRB, 2.22151E+01_JPRB, 2.23818E+01_JPRB, 2.25497E+01_JPRB, &
     & 2.27189E+01_JPRB, 2.28893E+01_JPRB, 2.30611E+01_JPRB, 2.32341E+01_JPRB, 2.34084E+01_JPRB, &
     & 2.35840E+01_JPRB, 2.37609E+01_JPRB, 2.39392E+01_JPRB, 2.41188E+01_JPRB/)
      KAO_MCO( 4, :, 7) = (/ &
     & 2.13866E+01_JPRB, 2.15772E+01_JPRB, 2.17694E+01_JPRB, 2.19634E+01_JPRB, 2.21590E+01_JPRB, &
     & 2.23565E+01_JPRB, 2.25556E+01_JPRB, 2.27566E+01_JPRB, 2.29594E+01_JPRB, 2.31639E+01_JPRB, &
     & 2.33703E+01_JPRB, 2.35785E+01_JPRB, 2.37886E+01_JPRB, 2.40005E+01_JPRB, 2.42144E+01_JPRB, &
     & 2.44301E+01_JPRB, 2.46477E+01_JPRB, 2.48673E+01_JPRB, 2.50889E+01_JPRB/)
      KAO_MCO( 5, :, 7) = (/ &
     & 1.93714E+01_JPRB, 1.95595E+01_JPRB, 1.97493E+01_JPRB, 1.99410E+01_JPRB, 2.01345E+01_JPRB, &
     & 2.03300E+01_JPRB, 2.05273E+01_JPRB, 2.07265E+01_JPRB, 2.09277E+01_JPRB, 2.11308E+01_JPRB, &
     & 2.13359E+01_JPRB, 2.15430E+01_JPRB, 2.17521E+01_JPRB, 2.19632E+01_JPRB, 2.21764E+01_JPRB, &
     & 2.23917E+01_JPRB, 2.26090E+01_JPRB, 2.28284E+01_JPRB, 2.30500E+01_JPRB/)
      KAO_MCO( 6, :, 7) = (/ &
     & 1.70418E+01_JPRB, 1.72109E+01_JPRB, 1.73817E+01_JPRB, 1.75541E+01_JPRB, 1.77283E+01_JPRB, &
     & 1.79041E+01_JPRB, 1.80818E+01_JPRB, 1.82612E+01_JPRB, 1.84423E+01_JPRB, 1.86253E+01_JPRB, &
     & 1.88101E+01_JPRB, 1.89967E+01_JPRB, 1.91852E+01_JPRB, 1.93755E+01_JPRB, 1.95678E+01_JPRB, &
     & 1.97619E+01_JPRB, 1.99580E+01_JPRB, 2.01560E+01_JPRB, 2.03560E+01_JPRB/)
      KAO_MCO( 7, :, 7) = (/ &
     & 1.31735E+01_JPRB, 1.32921E+01_JPRB, 1.34118E+01_JPRB, 1.35326E+01_JPRB, 1.36545E+01_JPRB, &
     & 1.37775E+01_JPRB, 1.39015E+01_JPRB, 1.40267E+01_JPRB, 1.41531E+01_JPRB, 1.42805E+01_JPRB, &
     & 1.44091E+01_JPRB, 1.45389E+01_JPRB, 1.46698E+01_JPRB, 1.48019E+01_JPRB, 1.49353E+01_JPRB, &
     & 1.50698E+01_JPRB, 1.52055E+01_JPRB, 1.53424E+01_JPRB, 1.54806E+01_JPRB/)
      KAO_MCO( 8, :, 7) = (/ &
     & 4.97361E+00_JPRB, 4.96550E+00_JPRB, 4.95740E+00_JPRB, 4.94931E+00_JPRB, 4.94124E+00_JPRB, &
     & 4.93318E+00_JPRB, 4.92513E+00_JPRB, 4.91709E+00_JPRB, 4.90907E+00_JPRB, 4.90106E+00_JPRB, &
     & 4.89307E+00_JPRB, 4.88509E+00_JPRB, 4.87712E+00_JPRB, 4.86916E+00_JPRB, 4.86122E+00_JPRB, &
     & 4.85329E+00_JPRB, 4.84537E+00_JPRB, 4.83747E+00_JPRB, 4.82958E+00_JPRB/)
      KAO_MCO( 9, :, 7) = (/ &
     & 1.76121E+01_JPRB, 1.75887E+01_JPRB, 1.75653E+01_JPRB, 1.75420E+01_JPRB, 1.75187E+01_JPRB, &
     & 1.74955E+01_JPRB, 1.74722E+01_JPRB, 1.74490E+01_JPRB, 1.74259E+01_JPRB, 1.74027E+01_JPRB, &
     & 1.73796E+01_JPRB, 1.73566E+01_JPRB, 1.73335E+01_JPRB, 1.73105E+01_JPRB, 1.72875E+01_JPRB, &
     & 1.72646E+01_JPRB, 1.72416E+01_JPRB, 1.72188E+01_JPRB, 1.71959E+01_JPRB/)
      KAO_MCO( 1, :, 8) = (/ &
     & 5.99126E+00_JPRB, 6.08386E+00_JPRB, 6.17790E+00_JPRB, 6.27339E+00_JPRB, 6.37035E+00_JPRB, &
     & 6.46881E+00_JPRB, 6.56880E+00_JPRB, 6.67033E+00_JPRB, 6.77343E+00_JPRB, 6.87812E+00_JPRB, &
     & 6.98443E+00_JPRB, 7.09238E+00_JPRB, 7.20201E+00_JPRB, 7.31332E+00_JPRB, 7.42636E+00_JPRB, &
     & 7.54115E+00_JPRB, 7.65771E+00_JPRB, 7.77607E+00_JPRB, 7.89626E+00_JPRB/)
      KAO_MCO( 2, :, 8) = (/ &
     & 4.71621E+00_JPRB, 4.78830E+00_JPRB, 4.86149E+00_JPRB, 4.93580E+00_JPRB, 5.01124E+00_JPRB, &
     & 5.08784E+00_JPRB, 5.16561E+00_JPRB, 5.24456E+00_JPRB, 5.32473E+00_JPRB, 5.40612E+00_JPRB, &
     & 5.48875E+00_JPRB, 5.57264E+00_JPRB, 5.65782E+00_JPRB, 5.74430E+00_JPRB, 5.83211E+00_JPRB, &
     & 5.92125E+00_JPRB, 6.01176E+00_JPRB, 6.10365E+00_JPRB, 6.19694E+00_JPRB/)
      KAO_MCO( 3, :, 8) = (/ &
     & 2.77067E+00_JPRB, 2.81437E+00_JPRB, 2.85876E+00_JPRB, 2.90385E+00_JPRB, 2.94965E+00_JPRB, &
     & 2.99617E+00_JPRB, 3.04343E+00_JPRB, 3.09143E+00_JPRB, 3.14019E+00_JPRB, 3.18972E+00_JPRB, &
     & 3.24003E+00_JPRB, 3.29114E+00_JPRB, 3.34305E+00_JPRB, 3.39578E+00_JPRB, 3.44934E+00_JPRB, &
     & 3.50374E+00_JPRB, 3.55901E+00_JPRB, 3.61514E+00_JPRB, 3.67216E+00_JPRB/)
      KAO_MCO( 4, :, 8) = (/ &
     & 1.22388E+00_JPRB, 1.24248E+00_JPRB, 1.26136E+00_JPRB, 1.28053E+00_JPRB, 1.29999E+00_JPRB, &
     & 1.31974E+00_JPRB, 1.33979E+00_JPRB, 1.36015E+00_JPRB, 1.38082E+00_JPRB, 1.40181E+00_JPRB, &
     & 1.42311E+00_JPRB, 1.44473E+00_JPRB, 1.46669E+00_JPRB, 1.48897E+00_JPRB, 1.51160E+00_JPRB, &
     & 1.53457E+00_JPRB, 1.55789E+00_JPRB, 1.58156E+00_JPRB, 1.60559E+00_JPRB/)
      KAO_MCO( 5, :, 8) = (/ &
     & 1.41479E+00_JPRB, 1.43540E+00_JPRB, 1.45631E+00_JPRB, 1.47752E+00_JPRB, 1.49904E+00_JPRB, &
     & 1.52088E+00_JPRB, 1.54303E+00_JPRB, 1.56550E+00_JPRB, 1.58831E+00_JPRB, 1.61144E+00_JPRB, &
     & 1.63491E+00_JPRB, 1.65872E+00_JPRB, 1.68288E+00_JPRB, 1.70740E+00_JPRB, 1.73227E+00_JPRB, &
     & 1.75750E+00_JPRB, 1.78310E+00_JPRB, 1.80907E+00_JPRB, 1.83542E+00_JPRB/)
      KAO_MCO( 6, :, 8) = (/ &
     & 1.43154E+00_JPRB, 1.46074E+00_JPRB, 1.49053E+00_JPRB, 1.52093E+00_JPRB, 1.55196E+00_JPRB, &
     & 1.58361E+00_JPRB, 1.61591E+00_JPRB, 1.64887E+00_JPRB, 1.68250E+00_JPRB, 1.71682E+00_JPRB, &
     & 1.75184E+00_JPRB, 1.78757E+00_JPRB, 1.82403E+00_JPRB, 1.86123E+00_JPRB, 1.89920E+00_JPRB, &
     & 1.93793E+00_JPRB, 1.97746E+00_JPRB, 2.01779E+00_JPRB, 2.05895E+00_JPRB/)
      KAO_MCO( 7, :, 8) = (/ &
     & 2.49358E+00_JPRB, 2.56028E+00_JPRB, 2.62875E+00_JPRB, 2.69906E+00_JPRB, 2.77124E+00_JPRB, &
     & 2.84536E+00_JPRB, 2.92146E+00_JPRB, 2.99960E+00_JPRB, 3.07982E+00_JPRB, 3.16219E+00_JPRB, &
     & 3.24677E+00_JPRB, 3.33360E+00_JPRB, 3.42276E+00_JPRB, 3.51430E+00_JPRB, 3.60829E+00_JPRB, &
     & 3.70480E+00_JPRB, 3.80388E+00_JPRB, 3.90562E+00_JPRB, 4.01007E+00_JPRB/)
      KAO_MCO( 8, :, 8) = (/ &
     & 4.32513E+00_JPRB, 4.39903E+00_JPRB, 4.47420E+00_JPRB, 4.55065E+00_JPRB, 4.62841E+00_JPRB, &
     & 4.70750E+00_JPRB, 4.78794E+00_JPRB, 4.86975E+00_JPRB, 4.95296E+00_JPRB, 5.03759E+00_JPRB, &
     & 5.12367E+00_JPRB, 5.21122E+00_JPRB, 5.30027E+00_JPRB, 5.39084E+00_JPRB, 5.48295E+00_JPRB, &
     & 5.57664E+00_JPRB, 5.67193E+00_JPRB, 5.76885E+00_JPRB, 5.86743E+00_JPRB/)
      KAO_MCO( 9, :, 8) = (/ &
     & 3.35160E+01_JPRB, 3.36789E+01_JPRB, 3.38425E+01_JPRB, 3.40069E+01_JPRB, 3.41722E+01_JPRB, &
     & 3.43382E+01_JPRB, 3.45050E+01_JPRB, 3.46727E+01_JPRB, 3.48412E+01_JPRB, 3.50105E+01_JPRB, &
     & 3.51806E+01_JPRB, 3.53515E+01_JPRB, 3.55233E+01_JPRB, 3.56959E+01_JPRB, 3.58693E+01_JPRB, &
     & 3.60436E+01_JPRB, 3.62187E+01_JPRB, 3.63947E+01_JPRB, 3.65715E+01_JPRB/)
      KAO_MCO( 1, :, 9) = (/ &
     & 8.68159E-01_JPRB, 9.13680E-01_JPRB, 9.61587E-01_JPRB, 1.01201E+00_JPRB, 1.06507E+00_JPRB, &
     & 1.12091E+00_JPRB, 1.17969E+00_JPRB, 1.24154E+00_JPRB, 1.30664E+00_JPRB, 1.37515E+00_JPRB, &
     & 1.44726E+00_JPRB, 1.52314E+00_JPRB, 1.60300E+00_JPRB, 1.68705E+00_JPRB, 1.77551E+00_JPRB, &
     & 1.86861E+00_JPRB, 1.96658E+00_JPRB, 2.06970E+00_JPRB, 2.17822E+00_JPRB/)
      KAO_MCO( 2, :, 9) = (/ &
     & 9.04391E-01_JPRB, 9.49669E-01_JPRB, 9.97214E-01_JPRB, 1.04714E+00_JPRB, 1.09956E+00_JPRB, &
     & 1.15461E+00_JPRB, 1.21242E+00_JPRB, 1.27312E+00_JPRB, 1.33685E+00_JPRB, 1.40378E+00_JPRB, &
     & 1.47406E+00_JPRB, 1.54786E+00_JPRB, 1.62535E+00_JPRB, 1.70673E+00_JPRB, 1.79217E+00_JPRB, &
     & 1.88190E+00_JPRB, 1.97611E+00_JPRB, 2.07505E+00_JPRB, 2.17893E+00_JPRB/)
      KAO_MCO( 3, :, 9) = (/ &
     & 9.67479E-01_JPRB, 1.01312E+00_JPRB, 1.06092E+00_JPRB, 1.11098E+00_JPRB, 1.16339E+00_JPRB, &
     & 1.21828E+00_JPRB, 1.27576E+00_JPRB, 1.33595E+00_JPRB, 1.39898E+00_JPRB, 1.46499E+00_JPRB, &
     & 1.53411E+00_JPRB, 1.60649E+00_JPRB, 1.68228E+00_JPRB, 1.76165E+00_JPRB, 1.84476E+00_JPRB, &
     & 1.93180E+00_JPRB, 2.02294E+00_JPRB, 2.11839E+00_JPRB, 2.21833E+00_JPRB/)
      KAO_MCO( 4, :, 9) = (/ &
     & 1.05240E+00_JPRB, 1.09817E+00_JPRB, 1.14592E+00_JPRB, 1.19576E+00_JPRB, 1.24776E+00_JPRB, &
     & 1.30202E+00_JPRB, 1.35864E+00_JPRB, 1.41772E+00_JPRB, 1.47937E+00_JPRB, 1.54371E+00_JPRB, &
     & 1.61084E+00_JPRB, 1.68089E+00_JPRB, 1.75398E+00_JPRB, 1.83026E+00_JPRB, 1.90985E+00_JPRB, &
     & 1.99290E+00_JPRB, 2.07957E+00_JPRB, 2.17000E+00_JPRB, 2.26437E+00_JPRB/)
      KAO_MCO( 5, :, 9) = (/ &
     & 1.25800E+00_JPRB, 1.30557E+00_JPRB, 1.35494E+00_JPRB, 1.40618E+00_JPRB, 1.45935E+00_JPRB, &
     & 1.51454E+00_JPRB, 1.57181E+00_JPRB, 1.63125E+00_JPRB, 1.69293E+00_JPRB, 1.75695E+00_JPRB, &
     & 1.82339E+00_JPRB, 1.89234E+00_JPRB, 1.96389E+00_JPRB, 2.03816E+00_JPRB, 2.11523E+00_JPRB, &
     & 2.19522E+00_JPRB, 2.27823E+00_JPRB, 2.36438E+00_JPRB, 2.45378E+00_JPRB/)
      KAO_MCO( 6, :, 9) = (/ &
     & 1.76509E+00_JPRB, 1.80550E+00_JPRB, 1.84683E+00_JPRB, 1.88911E+00_JPRB, 1.93235E+00_JPRB, &
     & 1.97658E+00_JPRB, 2.02183E+00_JPRB, 2.06811E+00_JPRB, 2.11546E+00_JPRB, 2.16388E+00_JPRB, &
     & 2.21342E+00_JPRB, 2.26408E+00_JPRB, 2.31591E+00_JPRB, 2.36893E+00_JPRB, 2.42315E+00_JPRB, &
     & 2.47862E+00_JPRB, 2.53536E+00_JPRB, 2.59340E+00_JPRB, 2.65277E+00_JPRB/)
      KAO_MCO( 7, :, 9) = (/ &
     & 2.03543E+00_JPRB, 2.05285E+00_JPRB, 2.07042E+00_JPRB, 2.08815E+00_JPRB, 2.10602E+00_JPRB, &
     & 2.12405E+00_JPRB, 2.14223E+00_JPRB, 2.16057E+00_JPRB, 2.17907E+00_JPRB, 2.19772E+00_JPRB, &
     & 2.21654E+00_JPRB, 2.23551E+00_JPRB, 2.25465E+00_JPRB, 2.27395E+00_JPRB, 2.29342E+00_JPRB, &
     & 2.31305E+00_JPRB, 2.33285E+00_JPRB, 2.35282E+00_JPRB, 2.37296E+00_JPRB/)
      KAO_MCO( 8, :, 9) = (/ &
     & 3.18883E+00_JPRB, 3.20538E+00_JPRB, 3.22200E+00_JPRB, 3.23872E+00_JPRB, 3.25552E+00_JPRB, &
     & 3.27241E+00_JPRB, 3.28939E+00_JPRB, 3.30645E+00_JPRB, 3.32360E+00_JPRB, 3.34085E+00_JPRB, &
     & 3.35818E+00_JPRB, 3.37560E+00_JPRB, 3.39311E+00_JPRB, 3.41071E+00_JPRB, 3.42841E+00_JPRB, &
     & 3.44619E+00_JPRB, 3.46407E+00_JPRB, 3.48204E+00_JPRB, 3.50011E+00_JPRB/)
      KAO_MCO( 9, :, 9) = (/ &
     & 3.97585E+00_JPRB, 3.96333E+00_JPRB, 3.95084E+00_JPRB, 3.93839E+00_JPRB, 3.92598E+00_JPRB, &
     & 3.91361E+00_JPRB, 3.90128E+00_JPRB, 3.88899E+00_JPRB, 3.87674E+00_JPRB, 3.86452E+00_JPRB, &
     & 3.85235E+00_JPRB, 3.84021E+00_JPRB, 3.82811E+00_JPRB, 3.81605E+00_JPRB, 3.80402E+00_JPRB, &
     & 3.79204E+00_JPRB, 3.78009E+00_JPRB, 3.76818E+00_JPRB, 3.75631E+00_JPRB/)
      KAO_MCO( 1, :,10) = (/ &
     & 8.62646E-01_JPRB, 9.35164E-01_JPRB, 1.01378E+00_JPRB, 1.09900E+00_JPRB, 1.19139E+00_JPRB, &
     & 1.29154E+00_JPRB, 1.40011E+00_JPRB, 1.51781E+00_JPRB, 1.64541E+00_JPRB, 1.78373E+00_JPRB, &
     & 1.93367E+00_JPRB, 2.09623E+00_JPRB, 2.27245E+00_JPRB, 2.46348E+00_JPRB, 2.67057E+00_JPRB, &
     & 2.89507E+00_JPRB, 3.13844E+00_JPRB, 3.40227E+00_JPRB, 3.68828E+00_JPRB/)
      KAO_MCO( 2, :,10) = (/ &
     & 8.04693E-01_JPRB, 8.72167E-01_JPRB, 9.45298E-01_JPRB, 1.02456E+00_JPRB, 1.11047E+00_JPRB, &
     & 1.20358E+00_JPRB, 1.30450E+00_JPRB, 1.41389E+00_JPRB, 1.53244E+00_JPRB, 1.66094E+00_JPRB, &
     & 1.80021E+00_JPRB, 1.95115E+00_JPRB, 2.11476E+00_JPRB, 2.29208E+00_JPRB, 2.48427E+00_JPRB, &
     & 2.69258E+00_JPRB, 2.91835E+00_JPRB, 3.16305E+00_JPRB, 3.42827E+00_JPRB/)
      KAO_MCO( 3, :,10) = (/ &
     & 7.66566E-01_JPRB, 8.24651E-01_JPRB, 8.87137E-01_JPRB, 9.54358E-01_JPRB, 1.02667E+00_JPRB, &
     & 1.10447E+00_JPRB, 1.18815E+00_JPRB, 1.27818E+00_JPRB, 1.37503E+00_JPRB, 1.47922E+00_JPRB, &
     & 1.59131E+00_JPRB, 1.71189E+00_JPRB, 1.84160E+00_JPRB, 1.98114E+00_JPRB, 2.13126E+00_JPRB, &
     & 2.29275E+00_JPRB, 2.46648E+00_JPRB, 2.65337E+00_JPRB, 2.85442E+00_JPRB/)
      KAO_MCO( 4, :,10) = (/ &
     & 5.40305E-01_JPRB, 5.77106E-01_JPRB, 6.16414E-01_JPRB, 6.58400E-01_JPRB, 7.03245E-01_JPRB, &
     & 7.51145E-01_JPRB, 8.02307E-01_JPRB, 8.56954E-01_JPRB, 9.15323E-01_JPRB, 9.77668E-01_JPRB, &
     & 1.04426E+00_JPRB, 1.11539E+00_JPRB, 1.19136E+00_JPRB, 1.27250E+00_JPRB, 1.35918E+00_JPRB, &
     & 1.45175E+00_JPRB, 1.55064E+00_JPRB, 1.65625E+00_JPRB, 1.76906E+00_JPRB/)
      KAO_MCO( 5, :,10) = (/ &
     & 8.22474E-01_JPRB, 8.02911E-01_JPRB, 7.83814E-01_JPRB, 7.65171E-01_JPRB, 7.46971E-01_JPRB, &
     & 7.29204E-01_JPRB, 7.11860E-01_JPRB, 6.94928E-01_JPRB, 6.78399E-01_JPRB, 6.62263E-01_JPRB, &
     & 6.46511E-01_JPRB, 6.31133E-01_JPRB, 6.16122E-01_JPRB, 6.01467E-01_JPRB, 5.87161E-01_JPRB, &
     & 5.73195E-01_JPRB, 5.59562E-01_JPRB, 5.46252E-01_JPRB, 5.33260E-01_JPRB/)
      KAO_MCO( 6, :,10) = (/ &
     & 1.28162E+00_JPRB, 1.25110E+00_JPRB, 1.22131E+00_JPRB, 1.19223E+00_JPRB, 1.16384E+00_JPRB, &
     & 1.13613E+00_JPRB, 1.10908E+00_JPRB, 1.08267E+00_JPRB, 1.05689E+00_JPRB, 1.03173E+00_JPRB, &
     & 1.00716E+00_JPRB, 9.83184E-01_JPRB, 9.59774E-01_JPRB, 9.36921E-01_JPRB, 9.14613E-01_JPRB, &
     & 8.92836E-01_JPRB, 8.71577E-01_JPRB, 8.50825E-01_JPRB, 8.30567E-01_JPRB/)
      KAO_MCO( 7, :,10) = (/ &
     & 1.92679E+00_JPRB, 1.90551E+00_JPRB, 1.88446E+00_JPRB, 1.86365E+00_JPRB, 1.84307E+00_JPRB, &
     & 1.82271E+00_JPRB, 1.80258E+00_JPRB, 1.78267E+00_JPRB, 1.76298E+00_JPRB, 1.74351E+00_JPRB, &
     & 1.72425E+00_JPRB, 1.70520E+00_JPRB, 1.68637E+00_JPRB, 1.66774E+00_JPRB, 1.64932E+00_JPRB, &
     & 1.63111E+00_JPRB, 1.61309E+00_JPRB, 1.59527E+00_JPRB, 1.57765E+00_JPRB/)
      KAO_MCO( 8, :,10) = (/ &
     & 4.66485E+00_JPRB, 4.60869E+00_JPRB, 4.55320E+00_JPRB, 4.49838E+00_JPRB, 4.44423E+00_JPRB, &
     & 4.39072E+00_JPRB, 4.33786E+00_JPRB, 4.28563E+00_JPRB, 4.23404E+00_JPRB, 4.18306E+00_JPRB, &
     & 4.13270E+00_JPRB, 4.08295E+00_JPRB, 4.03379E+00_JPRB, 3.98523E+00_JPRB, 3.93725E+00_JPRB, &
     & 3.88985E+00_JPRB, 3.84301E+00_JPRB, 3.79675E+00_JPRB, 3.75104E+00_JPRB/)
      KAO_MCO( 9, :,10) = (/ &
     & 1.41505E+00_JPRB, 1.37820E+00_JPRB, 1.34232E+00_JPRB, 1.30736E+00_JPRB, 1.27332E+00_JPRB, &
     & 1.24016E+00_JPRB, 1.20786E+00_JPRB, 1.17641E+00_JPRB, 1.14578E+00_JPRB, 1.11594E+00_JPRB, &
     & 1.08688E+00_JPRB, 1.05858E+00_JPRB, 1.03101E+00_JPRB, 1.00416E+00_JPRB, 9.78015E-01_JPRB, &
     & 9.52547E-01_JPRB, 9.27742E-01_JPRB, 9.03583E-01_JPRB, 8.80053E-01_JPRB/)
      KAO_MCO( 1, :,11) = (/ &
     & 3.40468E-03_JPRB, 4.05994E-03_JPRB, 4.84130E-03_JPRB, 5.77305E-03_JPRB, 6.88412E-03_JPRB, &
     & 8.20902E-03_JPRB, 9.78890E-03_JPRB, 1.16728E-02_JPRB, 1.39194E-02_JPRB, 1.65983E-02_JPRB, &
     & 1.97927E-02_JPRB, 2.36020E-02_JPRB, 2.81444E-02_JPRB, 3.35610E-02_JPRB, 4.00200E-02_JPRB, &
     & 4.77222E-02_JPRB, 5.69067E-02_JPRB, 6.78588E-02_JPRB, 8.09187E-02_JPRB/)
      KAO_MCO( 2, :,11) = (/ &
     & 3.85021E-02_JPRB, 4.02208E-02_JPRB, 4.20162E-02_JPRB, 4.38918E-02_JPRB, 4.58512E-02_JPRB, &
     & 4.78980E-02_JPRB, 5.00361E-02_JPRB, 5.22697E-02_JPRB, 5.46031E-02_JPRB, 5.70405E-02_JPRB, &
     & 5.95868E-02_JPRB, 6.22468E-02_JPRB, 6.50254E-02_JPRB, 6.79282E-02_JPRB, 7.09605E-02_JPRB, &
     & 7.41282E-02_JPRB, 7.74372E-02_JPRB, 8.08940E-02_JPRB, 8.45051E-02_JPRB/)
      KAO_MCO( 3, :,11) = (/ &
     & 5.24852E-01_JPRB, 5.10480E-01_JPRB, 4.96501E-01_JPRB, 4.82905E-01_JPRB, 4.69681E-01_JPRB, &
     & 4.56820E-01_JPRB, 4.44310E-01_JPRB, 4.32143E-01_JPRB, 4.20310E-01_JPRB, 4.08800E-01_JPRB, &
     & 3.97606E-01_JPRB, 3.86718E-01_JPRB, 3.76128E-01_JPRB, 3.65828E-01_JPRB, 3.55810E-01_JPRB, &
     & 3.46067E-01_JPRB, 3.36590E-01_JPRB, 3.27373E-01_JPRB, 3.18409E-01_JPRB/)
      KAO_MCO( 4, :,11) = (/ &
     & 5.86290E-01_JPRB, 5.70241E-01_JPRB, 5.54632E-01_JPRB, 5.39450E-01_JPRB, 5.24683E-01_JPRB, &
     & 5.10321E-01_JPRB, 4.96352E-01_JPRB, 4.82765E-01_JPRB, 4.69550E-01_JPRB, 4.56697E-01_JPRB, &
     & 4.44196E-01_JPRB, 4.32036E-01_JPRB, 4.20210E-01_JPRB, 4.08708E-01_JPRB, 3.97520E-01_JPRB, &
     & 3.86638E-01_JPRB, 3.76055E-01_JPRB, 3.65761E-01_JPRB, 3.55749E-01_JPRB/)
      KAO_MCO( 5, :,11) = (/ &
     & 1.66977E+00_JPRB, 1.61807E+00_JPRB, 1.56798E+00_JPRB, 1.51943E+00_JPRB, 1.47239E+00_JPRB, &
     & 1.42681E+00_JPRB, 1.38264E+00_JPRB, 1.33983E+00_JPRB, 1.29835E+00_JPRB, 1.25815E+00_JPRB, &
     & 1.21920E+00_JPRB, 1.18146E+00_JPRB, 1.14488E+00_JPRB, 1.10943E+00_JPRB, 1.07509E+00_JPRB, &
     & 1.04180E+00_JPRB, 1.00955E+00_JPRB, 9.78295E-01_JPRB, 9.48008E-01_JPRB/)
      KAO_MCO( 6, :,11) = (/ &
     & 1.96627E+00_JPRB, 1.90948E+00_JPRB, 1.85432E+00_JPRB, 1.80076E+00_JPRB, 1.74875E+00_JPRB, &
     & 1.69823E+00_JPRB, 1.64918E+00_JPRB, 1.60155E+00_JPRB, 1.55529E+00_JPRB, 1.51036E+00_JPRB, &
     & 1.46674E+00_JPRB, 1.42437E+00_JPRB, 1.38323E+00_JPRB, 1.34328E+00_JPRB, 1.30448E+00_JPRB, &
     & 1.26680E+00_JPRB, 1.23021E+00_JPRB, 1.19467E+00_JPRB, 1.16016E+00_JPRB/)
      KAO_MCO( 7, :,11) = (/ &
     & 1.67574E+00_JPRB, 1.63510E+00_JPRB, 1.59544E+00_JPRB, 1.55674E+00_JPRB, 1.51898E+00_JPRB, &
     & 1.48213E+00_JPRB, 1.44618E+00_JPRB, 1.41111E+00_JPRB, 1.37688E+00_JPRB, 1.34348E+00_JPRB, &
     & 1.31090E+00_JPRB, 1.27910E+00_JPRB, 1.24808E+00_JPRB, 1.21780E+00_JPRB, 1.18826E+00_JPRB, &
     & 1.15944E+00_JPRB, 1.13132E+00_JPRB, 1.10388E+00_JPRB, 1.07710E+00_JPRB/)
      KAO_MCO( 8, :,11) = (/ &
     & 2.00764E+00_JPRB, 1.96233E+00_JPRB, 1.91803E+00_JPRB, 1.87474E+00_JPRB, 1.83242E+00_JPRB, &
     & 1.79106E+00_JPRB, 1.75063E+00_JPRB, 1.71111E+00_JPRB, 1.67249E+00_JPRB, 1.63474E+00_JPRB, &
     & 1.59784E+00_JPRB, 1.56177E+00_JPRB, 1.52652E+00_JPRB, 1.49206E+00_JPRB, 1.45838E+00_JPRB, &
     & 1.42546E+00_JPRB, 1.39329E+00_JPRB, 1.36184E+00_JPRB, 1.33110E+00_JPRB/)
      KAO_MCO( 9, :,11) = (/ &
     & 1.83026E+00_JPRB, 1.77349E+00_JPRB, 1.71849E+00_JPRB, 1.66519E+00_JPRB, 1.61355E+00_JPRB, &
     & 1.56350E+00_JPRB, 1.51501E+00_JPRB, 1.46803E+00_JPRB, 1.42250E+00_JPRB, 1.37838E+00_JPRB, &
     & 1.33563E+00_JPRB, 1.29421E+00_JPRB, 1.25407E+00_JPRB, 1.21517E+00_JPRB, 1.17749E+00_JPRB, &
     & 1.14097E+00_JPRB, 1.10558E+00_JPRB, 1.07129E+00_JPRB, 1.03807E+00_JPRB/)
      KAO_MCO( 1, :,12) = (/ &
     & 3.90309E-04_JPRB, 4.81310E-04_JPRB, 5.93528E-04_JPRB, 7.31909E-04_JPRB, 9.02554E-04_JPRB, &
     & 1.11299E-03_JPRB, 1.37248E-03_JPRB, 1.69247E-03_JPRB, 2.08708E-03_JPRB, 2.57368E-03_JPRB, &
     & 3.17374E-03_JPRB, 3.91370E-03_JPRB, 4.82617E-03_JPRB, 5.95140E-03_JPRB, 7.33897E-03_JPRB, &
     & 9.05007E-03_JPRB, 1.11601E-02_JPRB, 1.37621E-02_JPRB, 1.69707E-02_JPRB/)
      KAO_MCO( 2, :,12) = (/ &
     & 9.80585E-02_JPRB, 9.77457E-02_JPRB, 9.74339E-02_JPRB, 9.71231E-02_JPRB, 9.68132E-02_JPRB, &
     & 9.65044E-02_JPRB, 9.61965E-02_JPRB, 9.58897E-02_JPRB, 9.55838E-02_JPRB, 9.52789E-02_JPRB, &
     & 9.49749E-02_JPRB, 9.46719E-02_JPRB, 9.43699E-02_JPRB, 9.40689E-02_JPRB, 9.37688E-02_JPRB, &
     & 9.34697E-02_JPRB, 9.31715E-02_JPRB, 9.28743E-02_JPRB, 9.25780E-02_JPRB/)
      KAO_MCO( 3, :,12) = (/ &
     & 3.15258E-01_JPRB, 3.09936E-01_JPRB, 3.04704E-01_JPRB, 2.99560E-01_JPRB, 2.94503E-01_JPRB, &
     & 2.89532E-01_JPRB, 2.84645E-01_JPRB, 2.79840E-01_JPRB, 2.75116E-01_JPRB, 2.70472E-01_JPRB, &
     & 2.65906E-01_JPRB, 2.61417E-01_JPRB, 2.57004E-01_JPRB, 2.52666E-01_JPRB, 2.48401E-01_JPRB, &
     & 2.44207E-01_JPRB, 2.40085E-01_JPRB, 2.36032E-01_JPRB, 2.32048E-01_JPRB/)
      KAO_MCO( 4, :,12) = (/ &
     & 9.74407E-01_JPRB, 9.46900E-01_JPRB, 9.20170E-01_JPRB, 8.94195E-01_JPRB, 8.68952E-01_JPRB, &
     & 8.44422E-01_JPRB, 8.20585E-01_JPRB, 7.97421E-01_JPRB, 7.74910E-01_JPRB, 7.53035E-01_JPRB, &
     & 7.31777E-01_JPRB, 7.11120E-01_JPRB, 6.91046E-01_JPRB, 6.71538E-01_JPRB, 6.52581E-01_JPRB, &
     & 6.34159E-01_JPRB, 6.16257E-01_JPRB, 5.98861E-01_JPRB, 5.81956E-01_JPRB/)
      KAO_MCO( 5, :,12) = (/ &
     & 1.04234E+00_JPRB, 1.01364E+00_JPRB, 9.85726E-01_JPRB, 9.58581E-01_JPRB, 9.32184E-01_JPRB, &
     & 9.06514E-01_JPRB, 8.81551E-01_JPRB, 8.57275E-01_JPRB, 8.33668E-01_JPRB, 8.10710E-01_JPRB, &
     & 7.88385E-01_JPRB, 7.66675E-01_JPRB, 7.45563E-01_JPRB, 7.25032E-01_JPRB, 7.05066E-01_JPRB, &
     & 6.85650E-01_JPRB, 6.66769E-01_JPRB, 6.48408E-01_JPRB, 6.30552E-01_JPRB/)
      KAO_MCO( 6, :,12) = (/ &
     & 1.79052E+00_JPRB, 1.73725E+00_JPRB, 1.68557E+00_JPRB, 1.63543E+00_JPRB, 1.58678E+00_JPRB, &
     & 1.53957E+00_JPRB, 1.49377E+00_JPRB, 1.44933E+00_JPRB, 1.40622E+00_JPRB, 1.36439E+00_JPRB, &
     & 1.32380E+00_JPRB, 1.28442E+00_JPRB, 1.24621E+00_JPRB, 1.20913E+00_JPRB, 1.17316E+00_JPRB, &
     & 1.13826E+00_JPRB, 1.10440E+00_JPRB, 1.07155E+00_JPRB, 1.03967E+00_JPRB/)
      KAO_MCO( 7, :,12) = (/ &
     & 2.99551E+00_JPRB, 2.90366E+00_JPRB, 2.81462E+00_JPRB, 2.72831E+00_JPRB, 2.64464E+00_JPRB, &
     & 2.56355E+00_JPRB, 2.48494E+00_JPRB, 2.40874E+00_JPRB, 2.33487E+00_JPRB, 2.26328E+00_JPRB, &
     & 2.19387E+00_JPRB, 2.12660E+00_JPRB, 2.06139E+00_JPRB, 1.99818E+00_JPRB, 1.93690E+00_JPRB, &
     & 1.87751E+00_JPRB, 1.81993E+00_JPRB, 1.76413E+00_JPRB, 1.71003E+00_JPRB/)
      KAO_MCO( 8, :,12) = (/ &
     & 2.89665E+00_JPRB, 2.81184E+00_JPRB, 2.72951E+00_JPRB, 2.64960E+00_JPRB, 2.57202E+00_JPRB, &
     & 2.49672E+00_JPRB, 2.42362E+00_JPRB, 2.35266E+00_JPRB, 2.28378E+00_JPRB, 2.21692E+00_JPRB, &
     & 2.15201E+00_JPRB, 2.08900E+00_JPRB, 2.02784E+00_JPRB, 1.96847E+00_JPRB, 1.91084E+00_JPRB, &
     & 1.85489E+00_JPRB, 1.80059E+00_JPRB, 1.74787E+00_JPRB, 1.69669E+00_JPRB/)
      KAO_MCO( 9, :,12) = (/ &
     & 1.03145E+00_JPRB, 1.00335E+00_JPRB, 9.76014E-01_JPRB, 9.49426E-01_JPRB, 9.23561E-01_JPRB, &
     & 8.98402E-01_JPRB, 8.73927E-01_JPRB, 8.50120E-01_JPRB, 8.26961E-01_JPRB, 8.04433E-01_JPRB, &
     & 7.82518E-01_JPRB, 7.61201E-01_JPRB, 7.40464E-01_JPRB, 7.20293E-01_JPRB, 7.00670E-01_JPRB, &
     & 6.81583E-01_JPRB, 6.63015E-01_JPRB, 6.44953E-01_JPRB, 6.27383E-01_JPRB/)
      KAO_MCO( 1, :,13) = (/ &
     & 5.27769E-04_JPRB, 6.65449E-04_JPRB, 8.39047E-04_JPRB, 1.05793E-03_JPRB, 1.33392E-03_JPRB, &
     & 1.68190E-03_JPRB, 2.12066E-03_JPRB, 2.67388E-03_JPRB, 3.37143E-03_JPRB, 4.25094E-03_JPRB, &
     & 5.35990E-03_JPRB, 6.75816E-03_JPRB, 8.52117E-03_JPRB, 1.07441E-02_JPRB, 1.35470E-02_JPRB, &
     & 1.70810E-02_JPRB, 2.15370E-02_JPRB, 2.71554E-02_JPRB, 3.42395E-02_JPRB/)
      KAO_MCO( 2, :,13) = (/ &
     & 1.08329E-01_JPRB, 1.10179E-01_JPRB, 1.12060E-01_JPRB, 1.13974E-01_JPRB, 1.15920E-01_JPRB, &
     & 1.17899E-01_JPRB, 1.19913E-01_JPRB, 1.21960E-01_JPRB, 1.24043E-01_JPRB, 1.26161E-01_JPRB, &
     & 1.28316E-01_JPRB, 1.30507E-01_JPRB, 1.32735E-01_JPRB, 1.35002E-01_JPRB, 1.37307E-01_JPRB, &
     & 1.39652E-01_JPRB, 1.42037E-01_JPRB, 1.44462E-01_JPRB, 1.46929E-01_JPRB/)
      KAO_MCO( 3, :,13) = (/ &
     & 1.95992E-01_JPRB, 1.94515E-01_JPRB, 1.93049E-01_JPRB, 1.91594E-01_JPRB, 1.90150E-01_JPRB, &
     & 1.88717E-01_JPRB, 1.87294E-01_JPRB, 1.85882E-01_JPRB, 1.84481E-01_JPRB, 1.83091E-01_JPRB, &
     & 1.81711E-01_JPRB, 1.80341E-01_JPRB, 1.78982E-01_JPRB, 1.77633E-01_JPRB, 1.76294E-01_JPRB, &
     & 1.74965E-01_JPRB, 1.73646E-01_JPRB, 1.72337E-01_JPRB, 1.71038E-01_JPRB/)
      KAO_MCO( 4, :,13) = (/ &
     & 4.49766E-01_JPRB, 4.42749E-01_JPRB, 4.35841E-01_JPRB, 4.29042E-01_JPRB, 4.22348E-01_JPRB, &
     & 4.15759E-01_JPRB, 4.09272E-01_JPRB, 4.02887E-01_JPRB, 3.96601E-01_JPRB, 3.90414E-01_JPRB, &
     & 3.84323E-01_JPRB, 3.78327E-01_JPRB, 3.72424E-01_JPRB, 3.66614E-01_JPRB, 3.60894E-01_JPRB, &
     & 3.55264E-01_JPRB, 3.49721E-01_JPRB, 3.44265E-01_JPRB, 3.38894E-01_JPRB/)
      KAO_MCO( 5, :,13) = (/ &
     & 1.07498E+00_JPRB, 1.04736E+00_JPRB, 1.02045E+00_JPRB, 9.94232E-01_JPRB, 9.68686E-01_JPRB, &
     & 9.43797E-01_JPRB, 9.19547E-01_JPRB, 8.95920E-01_JPRB, 8.72900E-01_JPRB, 8.50471E-01_JPRB, &
     & 8.28619E-01_JPRB, 8.07329E-01_JPRB, 7.86585E-01_JPRB, 7.66374E-01_JPRB, 7.46683E-01_JPRB, &
     & 7.27498E-01_JPRB, 7.08805E-01_JPRB, 6.90593E-01_JPRB, 6.72849E-01_JPRB/)
      KAO_MCO( 6, :,13) = (/ &
     & 1.66569E+00_JPRB, 1.61740E+00_JPRB, 1.57052E+00_JPRB, 1.52500E+00_JPRB, 1.48080E+00_JPRB, &
     & 1.43787E+00_JPRB, 1.39620E+00_JPRB, 1.35573E+00_JPRB, 1.31643E+00_JPRB, 1.27827E+00_JPRB, &
     & 1.24122E+00_JPRB, 1.20524E+00_JPRB, 1.17031E+00_JPRB, 1.13638E+00_JPRB, 1.10344E+00_JPRB, &
     & 1.07146E+00_JPRB, 1.04040E+00_JPRB, 1.01025E+00_JPRB, 9.80963E-01_JPRB/)
      KAO_MCO( 7, :,13) = (/ &
     & 1.52948E+00_JPRB, 1.48763E+00_JPRB, 1.44693E+00_JPRB, 1.40735E+00_JPRB, 1.36884E+00_JPRB, &
     & 1.33139E+00_JPRB, 1.29497E+00_JPRB, 1.25954E+00_JPRB, 1.22508E+00_JPRB, 1.19156E+00_JPRB, &
     & 1.15896E+00_JPRB, 1.12725E+00_JPRB, 1.09641E+00_JPRB, 1.06641E+00_JPRB, 1.03724E+00_JPRB, &
     & 1.00886E+00_JPRB, 9.81259E-01_JPRB, 9.54412E-01_JPRB, 9.28301E-01_JPRB/)
      KAO_MCO( 8, :,13) = (/ &
     & 3.81027E+00_JPRB, 3.69422E+00_JPRB, 3.58170E+00_JPRB, 3.47261E+00_JPRB, 3.36684E+00_JPRB, &
     & 3.26429E+00_JPRB, 3.16486E+00_JPRB, 3.06847E+00_JPRB, 2.97501E+00_JPRB, 2.88439E+00_JPRB, &
     & 2.79654E+00_JPRB, 2.71136E+00_JPRB, 2.62878E+00_JPRB, 2.54871E+00_JPRB, 2.47108E+00_JPRB, &
     & 2.39581E+00_JPRB, 2.32284E+00_JPRB, 2.25209E+00_JPRB, 2.18350E+00_JPRB/)
      KAO_MCO( 9, :,13) = (/ &
     & 1.12516E+00_JPRB, 1.09531E+00_JPRB, 1.06625E+00_JPRB, 1.03796E+00_JPRB, 1.01042E+00_JPRB, &
     & 9.83616E-01_JPRB, 9.57520E-01_JPRB, 9.32117E-01_JPRB, 9.07387E-01_JPRB, 8.83314E-01_JPRB, &
     & 8.59880E-01_JPRB, 8.37067E-01_JPRB, 8.14859E-01_JPRB, 7.93241E-01_JPRB, 7.72196E-01_JPRB, &
     & 7.51709E-01_JPRB, 7.31766E-01_JPRB, 7.12352E-01_JPRB, 6.93454E-01_JPRB/)
      KAO_MCO( 1, :,14) = (/ &
     & 4.79165E-04_JPRB, 6.26966E-04_JPRB, 8.20356E-04_JPRB, 1.07340E-03_JPRB, 1.40450E-03_JPRB, &
     & 1.83772E-03_JPRB, 2.40457E-03_JPRB, 3.14628E-03_JPRB, 4.11676E-03_JPRB, 5.38660E-03_JPRB, &
     & 7.04813E-03_JPRB, 9.22216E-03_JPRB, 1.20668E-02_JPRB, 1.57889E-02_JPRB, 2.06590E-02_JPRB, &
     & 2.70314E-02_JPRB, 3.53694E-02_JPRB, 4.62792E-02_JPRB, 6.05542E-02_JPRB/)
      KAO_MCO( 2, :,14) = (/ &
     & 4.75367E-04_JPRB, 6.21987E-04_JPRB, 8.13830E-04_JPRB, 1.06484E-03_JPRB, 1.39328E-03_JPRB, &
     & 1.82302E-03_JPRB, 2.38530E-03_JPRB, 3.12101E-03_JPRB, 4.08365E-03_JPRB, 5.34318E-03_JPRB, &
     & 6.99121E-03_JPRB, 9.14756E-03_JPRB, 1.19690E-02_JPRB, 1.56607E-02_JPRB, 2.04909E-02_JPRB, &
     & 2.68111E-02_JPRB, 3.50806E-02_JPRB, 4.59007E-02_JPRB, 6.00580E-02_JPRB/)
      KAO_MCO( 3, :,14) = (/ &
     & 1.39594E-01_JPRB, 1.42407E-01_JPRB, 1.45276E-01_JPRB, 1.48202E-01_JPRB, 1.51188E-01_JPRB, &
     & 1.54234E-01_JPRB, 1.57342E-01_JPRB, 1.60512E-01_JPRB, 1.63745E-01_JPRB, 1.67044E-01_JPRB, &
     & 1.70410E-01_JPRB, 1.73843E-01_JPRB, 1.77345E-01_JPRB, 1.80918E-01_JPRB, 1.84563E-01_JPRB, &
     & 1.88282E-01_JPRB, 1.92075E-01_JPRB, 1.95945E-01_JPRB, 1.99892E-01_JPRB/)
      KAO_MCO( 4, :,14) = (/ &
     & 2.73418E-01_JPRB, 2.71322E-01_JPRB, 2.69242E-01_JPRB, 2.67177E-01_JPRB, 2.65129E-01_JPRB, &
     & 2.63096E-01_JPRB, 2.61079E-01_JPRB, 2.59077E-01_JPRB, 2.57091E-01_JPRB, 2.55120E-01_JPRB, &
     & 2.53164E-01_JPRB, 2.51223E-01_JPRB, 2.49297E-01_JPRB, 2.47386E-01_JPRB, 2.45489E-01_JPRB, &
     & 2.43607E-01_JPRB, 2.41739E-01_JPRB, 2.39886E-01_JPRB, 2.38047E-01_JPRB/)
      KAO_MCO( 5, :,14) = (/ &
     & 5.01880E-01_JPRB, 4.95066E-01_JPRB, 4.88344E-01_JPRB, 4.81713E-01_JPRB, 4.75173E-01_JPRB, &
     & 4.68721E-01_JPRB, 4.62357E-01_JPRB, 4.56079E-01_JPRB, 4.49887E-01_JPRB, 4.43778E-01_JPRB, &
     & 4.37753E-01_JPRB, 4.31809E-01_JPRB, 4.25946E-01_JPRB, 4.20163E-01_JPRB, 4.14458E-01_JPRB, &
     & 4.08830E-01_JPRB, 4.03279E-01_JPRB, 3.97804E-01_JPRB, 3.92403E-01_JPRB/)
      KAO_MCO( 6, :,14) = (/ &
     & 9.46125E-01_JPRB, 9.29642E-01_JPRB, 9.13447E-01_JPRB, 8.97533E-01_JPRB, 8.81897E-01_JPRB, &
     & 8.66533E-01_JPRB, 8.51437E-01_JPRB, 8.36603E-01_JPRB, 8.22029E-01_JPRB, 8.07708E-01_JPRB, &
     & 7.93636E-01_JPRB, 7.79810E-01_JPRB, 7.66225E-01_JPRB, 7.52876E-01_JPRB, 7.39760E-01_JPRB, &
     & 7.26872E-01_JPRB, 7.14209E-01_JPRB, 7.01766E-01_JPRB, 6.89540E-01_JPRB/)
      KAO_MCO( 7, :,14) = (/ &
     & 2.47697E+00_JPRB, 2.41183E+00_JPRB, 2.34840E+00_JPRB, 2.28664E+00_JPRB, 2.22650E+00_JPRB, &
     & 2.16795E+00_JPRB, 2.11093E+00_JPRB, 2.05541E+00_JPRB, 2.00136E+00_JPRB, 1.94872E+00_JPRB, &
     & 1.89747E+00_JPRB, 1.84757E+00_JPRB, 1.79898E+00_JPRB, 1.75167E+00_JPRB, 1.70560E+00_JPRB, &
     & 1.66074E+00_JPRB, 1.61707E+00_JPRB, 1.57454E+00_JPRB, 1.53313E+00_JPRB/)
      KAO_MCO( 8, :,14) = (/ &
     & 2.19323E+00_JPRB, 2.13926E+00_JPRB, 2.08662E+00_JPRB, 2.03528E+00_JPRB, 1.98519E+00_JPRB, &
     & 1.93635E+00_JPRB, 1.88870E+00_JPRB, 1.84222E+00_JPRB, 1.79689E+00_JPRB, 1.75268E+00_JPRB, &
     & 1.70955E+00_JPRB, 1.66748E+00_JPRB, 1.62645E+00_JPRB, 1.58643E+00_JPRB, 1.54739E+00_JPRB, &
     & 1.50932E+00_JPRB, 1.47218E+00_JPRB, 1.43595E+00_JPRB, 1.40062E+00_JPRB/)
      KAO_MCO( 9, :,14) = (/ &
     & 5.68351E-01_JPRB, 5.60360E-01_JPRB, 5.52481E-01_JPRB, 5.44712E-01_JPRB, 5.37053E-01_JPRB, &
     & 5.29502E-01_JPRB, 5.22057E-01_JPRB, 5.14716E-01_JPRB, 5.07479E-01_JPRB, 5.00343E-01_JPRB, &
     & 4.93308E-01_JPRB, 4.86372E-01_JPRB, 4.79533E-01_JPRB, 4.72790E-01_JPRB, 4.66142E-01_JPRB, &
     & 4.59588E-01_JPRB, 4.53126E-01_JPRB, 4.46754E-01_JPRB, 4.40473E-01_JPRB/)
      KAO_MCO( 1, :,15) = (/ &
     & 7.87937E-04_JPRB, 1.01733E-03_JPRB, 1.31351E-03_JPRB, 1.69591E-03_JPRB, 2.18964E-03_JPRB, &
     & 2.82712E-03_JPRB, 3.65018E-03_JPRB, 4.71286E-03_JPRB, 6.08493E-03_JPRB, 7.85644E-03_JPRB, &
     & 1.01437E-02_JPRB, 1.30969E-02_JPRB, 1.69098E-02_JPRB, 2.18327E-02_JPRB, 2.81889E-02_JPRB, &
     & 3.63956E-02_JPRB, 4.69915E-02_JPRB, 6.06722E-02_JPRB, 7.83357E-02_JPRB/)
      KAO_MCO( 2, :,15) = (/ &
     & 7.87937E-04_JPRB, 1.01733E-03_JPRB, 1.31351E-03_JPRB, 1.69591E-03_JPRB, 2.18964E-03_JPRB, &
     & 2.82712E-03_JPRB, 3.65018E-03_JPRB, 4.71286E-03_JPRB, 6.08493E-03_JPRB, 7.85644E-03_JPRB, &
     & 1.01437E-02_JPRB, 1.30969E-02_JPRB, 1.69098E-02_JPRB, 2.18327E-02_JPRB, 2.81889E-02_JPRB, &
     & 3.63956E-02_JPRB, 4.69915E-02_JPRB, 6.06722E-02_JPRB, 7.83357E-02_JPRB/)
      KAO_MCO( 3, :,15) = (/ &
     & 1.97281E-01_JPRB, 2.00714E-01_JPRB, 2.04206E-01_JPRB, 2.07760E-01_JPRB, 2.11375E-01_JPRB, &
     & 2.15053E-01_JPRB, 2.18795E-01_JPRB, 2.22603E-01_JPRB, 2.26476E-01_JPRB, 2.30417E-01_JPRB, &
     & 2.34426E-01_JPRB, 2.38506E-01_JPRB, 2.42656E-01_JPRB, 2.46878E-01_JPRB, 2.51174E-01_JPRB, &
     & 2.55545E-01_JPRB, 2.59992E-01_JPRB, 2.64516E-01_JPRB, 2.69119E-01_JPRB/)
      KAO_MCO( 4, :,15) = (/ &
     & 4.47509E-01_JPRB, 4.52222E-01_JPRB, 4.56985E-01_JPRB, 4.61799E-01_JPRB, 4.66663E-01_JPRB, &
     & 4.71578E-01_JPRB, 4.76545E-01_JPRB, 4.81565E-01_JPRB, 4.86637E-01_JPRB, 4.91763E-01_JPRB, &
     & 4.96942E-01_JPRB, 5.02177E-01_JPRB, 5.07466E-01_JPRB, 5.12811E-01_JPRB, 5.18213E-01_JPRB, &
     & 5.23671E-01_JPRB, 5.29187E-01_JPRB, 5.34761E-01_JPRB, 5.40393E-01_JPRB/)
      KAO_MCO( 5, :,15) = (/ &
     & 1.02732E+00_JPRB, 1.02091E+00_JPRB, 1.01453E+00_JPRB, 1.00820E+00_JPRB, 1.00191E+00_JPRB, &
     & 9.95660E-01_JPRB, 9.89447E-01_JPRB, 9.83273E-01_JPRB, 9.77137E-01_JPRB, 9.71039E-01_JPRB, &
     & 9.64980E-01_JPRB, 9.58958E-01_JPRB, 9.52974E-01_JPRB, 9.47027E-01_JPRB, 9.41118E-01_JPRB, &
     & 9.35245E-01_JPRB, 9.29409E-01_JPRB, 9.23609E-01_JPRB, 9.17846E-01_JPRB/)
      KAO_MCO( 6, :,15) = (/ &
     & 1.13766E+00_JPRB, 1.12944E+00_JPRB, 1.12128E+00_JPRB, 1.11318E+00_JPRB, 1.10514E+00_JPRB, &
     & 1.09715E+00_JPRB, 1.08923E+00_JPRB, 1.08136E+00_JPRB, 1.07355E+00_JPRB, 1.06579E+00_JPRB, &
     & 1.05809E+00_JPRB, 1.05045E+00_JPRB, 1.04286E+00_JPRB, 1.03532E+00_JPRB, 1.02784E+00_JPRB, &
     & 1.02042E+00_JPRB, 1.01305E+00_JPRB, 1.00573E+00_JPRB, 9.98462E-01_JPRB/)
      KAO_MCO( 7, :,15) = (/ &
     & 1.13268E+00_JPRB, 1.12496E+00_JPRB, 1.11730E+00_JPRB, 1.10969E+00_JPRB, 1.10213E+00_JPRB, &
     & 1.09462E+00_JPRB, 1.08717E+00_JPRB, 1.07976E+00_JPRB, 1.07241E+00_JPRB, 1.06510E+00_JPRB, &
     & 1.05785E+00_JPRB, 1.05064E+00_JPRB, 1.04349E+00_JPRB, 1.03638E+00_JPRB, 1.02932E+00_JPRB, &
     & 1.02231E+00_JPRB, 1.01535E+00_JPRB, 1.00843E+00_JPRB, 1.00156E+00_JPRB/)
      KAO_MCO( 8, :,15) = (/ &
     & 1.11982E+00_JPRB, 1.11343E+00_JPRB, 1.10707E+00_JPRB, 1.10075E+00_JPRB, 1.09447E+00_JPRB, &
     & 1.08822E+00_JPRB, 1.08201E+00_JPRB, 1.07583E+00_JPRB, 1.06969E+00_JPRB, 1.06358E+00_JPRB, &
     & 1.05751E+00_JPRB, 1.05147E+00_JPRB, 1.04547E+00_JPRB, 1.03950E+00_JPRB, 1.03356E+00_JPRB, &
     & 1.02766E+00_JPRB, 1.02180E+00_JPRB, 1.01596E+00_JPRB, 1.01016E+00_JPRB/)
      KAO_MCO( 9, :,15) = (/ &
     & 1.03561E+00_JPRB, 1.02902E+00_JPRB, 1.02246E+00_JPRB, 1.01595E+00_JPRB, 1.00948E+00_JPRB, &
     & 1.00305E+00_JPRB, 9.96667E-01_JPRB, 9.90320E-01_JPRB, 9.84013E-01_JPRB, 9.77747E-01_JPRB, &
     & 9.71520E-01_JPRB, 9.65334E-01_JPRB, 9.59186E-01_JPRB, 9.53078E-01_JPRB, 9.47008E-01_JPRB, &
     & 9.40978E-01_JPRB, 9.34985E-01_JPRB, 9.29031E-01_JPRB, 9.23115E-01_JPRB/)
      KAO_MCO( 1, :,16) = (/ &
     & 1.22217E-03_JPRB, 1.56836E-03_JPRB, 2.01261E-03_JPRB, 2.58271E-03_JPRB, 3.31429E-03_JPRB, &
     & 4.25310E-03_JPRB, 5.45784E-03_JPRB, 7.00383E-03_JPRB, 8.98775E-03_JPRB, 1.15336E-02_JPRB, &
     & 1.48007E-02_JPRB, 1.89931E-02_JPRB, 2.43731E-02_JPRB, 3.12771E-02_JPRB, 4.01367E-02_JPRB, &
     & 5.15059E-02_JPRB, 6.60956E-02_JPRB, 8.48179E-02_JPRB, 1.08843E-01_JPRB/)
      KAO_MCO( 2, :,16) = (/ &
     & 1.22217E-03_JPRB, 1.56836E-03_JPRB, 2.01261E-03_JPRB, 2.58271E-03_JPRB, 3.31429E-03_JPRB, &
     & 4.25310E-03_JPRB, 5.45784E-03_JPRB, 7.00383E-03_JPRB, 8.98775E-03_JPRB, 1.15336E-02_JPRB, &
     & 1.48007E-02_JPRB, 1.89931E-02_JPRB, 2.43731E-02_JPRB, 3.12771E-02_JPRB, 4.01367E-02_JPRB, &
     & 5.15059E-02_JPRB, 6.60956E-02_JPRB, 8.48179E-02_JPRB, 1.08843E-01_JPRB/)
      KAO_MCO( 3, :,16) = (/ &
     & 1.22217E-03_JPRB, 1.56836E-03_JPRB, 2.01261E-03_JPRB, 2.58271E-03_JPRB, 3.31429E-03_JPRB, &
     & 4.25310E-03_JPRB, 5.45784E-03_JPRB, 7.00383E-03_JPRB, 8.98775E-03_JPRB, 1.15336E-02_JPRB, &
     & 1.48007E-02_JPRB, 1.89931E-02_JPRB, 2.43731E-02_JPRB, 3.12771E-02_JPRB, 4.01367E-02_JPRB, &
     & 5.15059E-02_JPRB, 6.60956E-02_JPRB, 8.48179E-02_JPRB, 1.08843E-01_JPRB/)
      KAO_MCO( 4, :,16) = (/ &
     & 1.01221E+00_JPRB, 1.01660E+00_JPRB, 1.02101E+00_JPRB, 1.02544E+00_JPRB, 1.02989E+00_JPRB, &
     & 1.03436E+00_JPRB, 1.03884E+00_JPRB, 1.04335E+00_JPRB, 1.04788E+00_JPRB, 1.05243E+00_JPRB, &
     & 1.05699E+00_JPRB, 1.06158E+00_JPRB, 1.06619E+00_JPRB, 1.07081E+00_JPRB, 1.07546E+00_JPRB, &
     & 1.08012E+00_JPRB, 1.08481E+00_JPRB, 1.08952E+00_JPRB, 1.09425E+00_JPRB/)
      KAO_MCO( 5, :,16) = (/ &
     & 1.01221E+00_JPRB, 1.01660E+00_JPRB, 1.02101E+00_JPRB, 1.02544E+00_JPRB, 1.02989E+00_JPRB, &
     & 1.03436E+00_JPRB, 1.03884E+00_JPRB, 1.04335E+00_JPRB, 1.04788E+00_JPRB, 1.05243E+00_JPRB, &
     & 1.05699E+00_JPRB, 1.06158E+00_JPRB, 1.06619E+00_JPRB, 1.07081E+00_JPRB, 1.07546E+00_JPRB, &
     & 1.08012E+00_JPRB, 1.08481E+00_JPRB, 1.08952E+00_JPRB, 1.09425E+00_JPRB/)
      KAO_MCO( 6, :,16) = (/ &
     & 1.01221E+00_JPRB, 1.01660E+00_JPRB, 1.02101E+00_JPRB, 1.02544E+00_JPRB, 1.02989E+00_JPRB, &
     & 1.03436E+00_JPRB, 1.03884E+00_JPRB, 1.04335E+00_JPRB, 1.04788E+00_JPRB, 1.05243E+00_JPRB, &
     & 1.05699E+00_JPRB, 1.06158E+00_JPRB, 1.06619E+00_JPRB, 1.07081E+00_JPRB, 1.07546E+00_JPRB, &
     & 1.08012E+00_JPRB, 1.08481E+00_JPRB, 1.08952E+00_JPRB, 1.09425E+00_JPRB/)
      KAO_MCO( 7, :,16) = (/ &
     & 1.01221E+00_JPRB, 1.01660E+00_JPRB, 1.02101E+00_JPRB, 1.02544E+00_JPRB, 1.02989E+00_JPRB, &
     & 1.03436E+00_JPRB, 1.03884E+00_JPRB, 1.04335E+00_JPRB, 1.04788E+00_JPRB, 1.05243E+00_JPRB, &
     & 1.05699E+00_JPRB, 1.06158E+00_JPRB, 1.06619E+00_JPRB, 1.07081E+00_JPRB, 1.07546E+00_JPRB, &
     & 1.08012E+00_JPRB, 1.08481E+00_JPRB, 1.08952E+00_JPRB, 1.09425E+00_JPRB/)
      KAO_MCO( 8, :,16) = (/ &
     & 1.01221E+00_JPRB, 1.01660E+00_JPRB, 1.02101E+00_JPRB, 1.02544E+00_JPRB, 1.02989E+00_JPRB, &
     & 1.03436E+00_JPRB, 1.03884E+00_JPRB, 1.04335E+00_JPRB, 1.04788E+00_JPRB, 1.05243E+00_JPRB, &
     & 1.05699E+00_JPRB, 1.06158E+00_JPRB, 1.06619E+00_JPRB, 1.07081E+00_JPRB, 1.07546E+00_JPRB, &
     & 1.08012E+00_JPRB, 1.08481E+00_JPRB, 1.08952E+00_JPRB, 1.09425E+00_JPRB/)
      KAO_MCO( 9, :,16) = (/ &
     & 1.01221E+00_JPRB, 1.01660E+00_JPRB, 1.02101E+00_JPRB, 1.02544E+00_JPRB, 1.02989E+00_JPRB, &
     & 1.03436E+00_JPRB, 1.03884E+00_JPRB, 1.04335E+00_JPRB, 1.04788E+00_JPRB, 1.05243E+00_JPRB, &
     & 1.05699E+00_JPRB, 1.06158E+00_JPRB, 1.06619E+00_JPRB, 1.07081E+00_JPRB, 1.07546E+00_JPRB, &
     & 1.08012E+00_JPRB, 1.08481E+00_JPRB, 1.08952E+00_JPRB, 1.09425E+00_JPRB/)

!     The array KBO_Mxx contains the absorption coefficient for 
!     a minor species at the 16 chosen g-values for a reference pressure
!     level above 100~ mb.   The first index refers to temperature 
!     in 7.2 degree increments.  For instance, JT = 1 refers to a 
!     temperature of 188.0, JT = 2 refers to 195.2, etc. The second index 
!     runs over the g-channel (1 to 16).

      KBO_MO3(:, 1) = (/ &
     & 1.07596E-02_JPRB, 1.12146E-02_JPRB, 1.16887E-02_JPRB, 1.21830E-02_JPRB, 1.26981E-02_JPRB, &
     & 1.32350E-02_JPRB, 1.37946E-02_JPRB, 1.43779E-02_JPRB, 1.49858E-02_JPRB, 1.56194E-02_JPRB, &
     & 1.62799E-02_JPRB, 1.69682E-02_JPRB, 1.76857E-02_JPRB, 1.84334E-02_JPRB, 1.92129E-02_JPRB, &
     & 2.00252E-02_JPRB, 2.08719E-02_JPRB, 2.17544E-02_JPRB, 2.26743E-02_JPRB/)
      KBO_MO3(:, 2) = (/ &
     & 9.48276E-02_JPRB, 9.66591E-02_JPRB, 9.85260E-02_JPRB, 1.00429E-01_JPRB, 1.02369E-01_JPRB, &
     & 1.04346E-01_JPRB, 1.06361E-01_JPRB, 1.08416E-01_JPRB, 1.10510E-01_JPRB, 1.12644E-01_JPRB, &
     & 1.14820E-01_JPRB, 1.17037E-01_JPRB, 1.19298E-01_JPRB, 1.21602E-01_JPRB, 1.23951E-01_JPRB, &
     & 1.26345E-01_JPRB, 1.28785E-01_JPRB, 1.31273E-01_JPRB, 1.33808E-01_JPRB/)
      KBO_MO3(:, 3) = (/ &
     & 3.54721E-01_JPRB, 3.55779E-01_JPRB, 3.56841E-01_JPRB, 3.57906E-01_JPRB, 3.58973E-01_JPRB, &
     & 3.60044E-01_JPRB, 3.61119E-01_JPRB, 3.62196E-01_JPRB, 3.63277E-01_JPRB, 3.64360E-01_JPRB, &
     & 3.65448E-01_JPRB, 3.66538E-01_JPRB, 3.67631E-01_JPRB, 3.68728E-01_JPRB, 3.69828E-01_JPRB, &
     & 3.70932E-01_JPRB, 3.72038E-01_JPRB, 3.73148E-01_JPRB, 3.74262E-01_JPRB/)
      KBO_MO3(:, 4) = (/ &
     & 6.46454E-01_JPRB, 6.43823E-01_JPRB, 6.41202E-01_JPRB, 6.38593E-01_JPRB, 6.35994E-01_JPRB, &
     & 6.33405E-01_JPRB, 6.30827E-01_JPRB, 6.28260E-01_JPRB, 6.25703E-01_JPRB, 6.23156E-01_JPRB, &
     & 6.20620E-01_JPRB, 6.18094E-01_JPRB, 6.15578E-01_JPRB, 6.13073E-01_JPRB, 6.10578E-01_JPRB, &
     & 6.08093E-01_JPRB, 6.05618E-01_JPRB, 6.03153E-01_JPRB, 6.00698E-01_JPRB/)
      KBO_MO3(:, 5) = (/ &
     & 9.29832E-01_JPRB, 9.22877E-01_JPRB, 9.15975E-01_JPRB, 9.09124E-01_JPRB, 9.02324E-01_JPRB, &
     & 8.95576E-01_JPRB, 8.88877E-01_JPRB, 8.82229E-01_JPRB, 8.75631E-01_JPRB, 8.69082E-01_JPRB, &
     & 8.62582E-01_JPRB, 8.56130E-01_JPRB, 8.49727E-01_JPRB, 8.43372E-01_JPRB, 8.37064E-01_JPRB, &
     & 8.30803E-01_JPRB, 8.24589E-01_JPRB, 8.18422E-01_JPRB, 8.12301E-01_JPRB/)
      KBO_MO3(:, 6) = (/ &
     & 1.43531E+00_JPRB, 1.42616E+00_JPRB, 1.41706E+00_JPRB, 1.40802E+00_JPRB, 1.39903E+00_JPRB, &
     & 1.39010E+00_JPRB, 1.38124E+00_JPRB, 1.37242E+00_JPRB, 1.36367E+00_JPRB, 1.35496E+00_JPRB, &
     & 1.34632E+00_JPRB, 1.33773E+00_JPRB, 1.32919E+00_JPRB, 1.32071E+00_JPRB, 1.31229E+00_JPRB, &
     & 1.30391E+00_JPRB, 1.29559E+00_JPRB, 1.28733E+00_JPRB, 1.27911E+00_JPRB/)
      KBO_MO3(:, 7) = (/ &
     & 2.68664E+00_JPRB, 2.67196E+00_JPRB, 2.65736E+00_JPRB, 2.64284E+00_JPRB, 2.62840E+00_JPRB, &
     & 2.61404E+00_JPRB, 2.59975E+00_JPRB, 2.58555E+00_JPRB, 2.57142E+00_JPRB, 2.55737E+00_JPRB, &
     & 2.54340E+00_JPRB, 2.52950E+00_JPRB, 2.51568E+00_JPRB, 2.50193E+00_JPRB, 2.48826E+00_JPRB, &
     & 2.47466E+00_JPRB, 2.46114E+00_JPRB, 2.44769E+00_JPRB, 2.43432E+00_JPRB/)
      KBO_MO3(:, 8) = (/ &
     & 2.45343E+00_JPRB, 2.43442E+00_JPRB, 2.41556E+00_JPRB, 2.39684E+00_JPRB, 2.37827E+00_JPRB, &
     & 2.35984E+00_JPRB, 2.34156E+00_JPRB, 2.32342E+00_JPRB, 2.30541E+00_JPRB, 2.28755E+00_JPRB, &
     & 2.26983E+00_JPRB, 2.25224E+00_JPRB, 2.23479E+00_JPRB, 2.21747E+00_JPRB, 2.20029E+00_JPRB, &
     & 2.18324E+00_JPRB, 2.16633E+00_JPRB, 2.14954E+00_JPRB, 2.13289E+00_JPRB/)
      KBO_MO3(:, 9) = (/ &
     & 1.55879E-01_JPRB, 1.55998E-01_JPRB, 1.56118E-01_JPRB, 1.56238E-01_JPRB, 1.56358E-01_JPRB, &
     & 1.56478E-01_JPRB, 1.56599E-01_JPRB, 1.56719E-01_JPRB, 1.56840E-01_JPRB, 1.56960E-01_JPRB, &
     & 1.57081E-01_JPRB, 1.57201E-01_JPRB, 1.57322E-01_JPRB, 1.57443E-01_JPRB, 1.57564E-01_JPRB, &
     & 1.57685E-01_JPRB, 1.57806E-01_JPRB, 1.57928E-01_JPRB, 1.58049E-01_JPRB/)
      KBO_MO3(:,10) = (/ &
     & 8.75149E-03_JPRB, 8.88794E-03_JPRB, 9.02651E-03_JPRB, 9.16725E-03_JPRB, 9.31018E-03_JPRB, &
     & 9.45534E-03_JPRB, 9.60276E-03_JPRB, 9.75248E-03_JPRB, 9.90454E-03_JPRB, 1.00590E-02_JPRB, &
     & 1.02158E-02_JPRB, 1.03751E-02_JPRB, 1.05368E-02_JPRB, 1.07011E-02_JPRB, 1.08680E-02_JPRB, &
     & 1.10374E-02_JPRB, 1.12095E-02_JPRB, 1.13843E-02_JPRB, 1.15618E-02_JPRB/)
      KBO_MO3(:,11) = (/ &
     & 8.83874E-03_JPRB, 8.97926E-03_JPRB, 9.12201E-03_JPRB, 9.26703E-03_JPRB, 9.41436E-03_JPRB, &
     & 9.56403E-03_JPRB, 9.71608E-03_JPRB, 9.87055E-03_JPRB, 1.00275E-02_JPRB, 1.01869E-02_JPRB, &
     & 1.03488E-02_JPRB, 1.05134E-02_JPRB, 1.06805E-02_JPRB, 1.08503E-02_JPRB, 1.10228E-02_JPRB, &
     & 1.11980E-02_JPRB, 1.13761E-02_JPRB, 1.15569E-02_JPRB, 1.17407E-02_JPRB/)
      KBO_MO3(:,12) = (/ &
     & 9.59461E-03_JPRB, 9.70417E-03_JPRB, 9.81498E-03_JPRB, 9.92705E-03_JPRB, 1.00404E-02_JPRB, &
     & 1.01550E-02_JPRB, 1.02710E-02_JPRB, 1.03883E-02_JPRB, 1.05069E-02_JPRB, 1.06269E-02_JPRB, &
     & 1.07482E-02_JPRB, 1.08709E-02_JPRB, 1.09951E-02_JPRB, 1.11206E-02_JPRB, 1.12476E-02_JPRB, &
     & 1.13760E-02_JPRB, 1.15059E-02_JPRB, 1.16373E-02_JPRB, 1.17702E-02_JPRB/)
      KBO_MO3(:,13) = (/ &
     & 1.13077E-02_JPRB, 1.14079E-02_JPRB, 1.15089E-02_JPRB, 1.16109E-02_JPRB, 1.17138E-02_JPRB, &
     & 1.18176E-02_JPRB, 1.19223E-02_JPRB, 1.20279E-02_JPRB, 1.21344E-02_JPRB, 1.22419E-02_JPRB, &
     & 1.23504E-02_JPRB, 1.24598E-02_JPRB, 1.25702E-02_JPRB, 1.26816E-02_JPRB, 1.27939E-02_JPRB, &
     & 1.29073E-02_JPRB, 1.30216E-02_JPRB, 1.31370E-02_JPRB, 1.32534E-02_JPRB/)
      KBO_MO3(:,14) = (/ &
     & 6.74844E-03_JPRB, 6.82637E-03_JPRB, 6.90519E-03_JPRB, 6.98493E-03_JPRB, 7.06558E-03_JPRB, &
     & 7.14717E-03_JPRB, 7.22970E-03_JPRB, 7.31318E-03_JPRB, 7.39762E-03_JPRB, 7.48304E-03_JPRB, &
     & 7.56945E-03_JPRB, 7.65686E-03_JPRB, 7.74527E-03_JPRB, 7.83470E-03_JPRB, 7.92517E-03_JPRB, &
     & 8.01668E-03_JPRB, 8.10925E-03_JPRB, 8.20289E-03_JPRB, 8.29761E-03_JPRB/)
      KBO_MO3(:,15) = (/ &
     & 7.94595E-03_JPRB, 8.00015E-03_JPRB, 8.05472E-03_JPRB, 8.10966E-03_JPRB, 8.16497E-03_JPRB, &
     & 8.22067E-03_JPRB, 8.27674E-03_JPRB, 8.33320E-03_JPRB, 8.39004E-03_JPRB, 8.44727E-03_JPRB, &
     & 8.50489E-03_JPRB, 8.56290E-03_JPRB, 8.62130E-03_JPRB, 8.68011E-03_JPRB, 8.73932E-03_JPRB, &
     & 8.79893E-03_JPRB, 8.85895E-03_JPRB, 8.91937E-03_JPRB, 8.98021E-03_JPRB/)
      KBO_MO3(:,16) = (/ &
     & 1.85967E-03_JPRB, 1.86082E-03_JPRB, 1.86197E-03_JPRB, 1.86312E-03_JPRB, 1.86428E-03_JPRB, &
     & 1.86543E-03_JPRB, 1.86658E-03_JPRB, 1.86774E-03_JPRB, 1.86889E-03_JPRB, 1.87005E-03_JPRB, &
     & 1.87121E-03_JPRB, 1.87236E-03_JPRB, 1.87352E-03_JPRB, 1.87468E-03_JPRB, 1.87584E-03_JPRB, &
     & 1.87700E-03_JPRB, 1.87816E-03_JPRB, 1.87932E-03_JPRB, 1.88049E-03_JPRB/)

!     The array FORREFO contains the coefficient of the water vapor
!     foreign-continuum (including the energy term).  The first 
!     index refers to reference temperature (296,260,224,260) and 
!     pressure (970,475,219,3 mbar) levels.  The second index 
!     runs over the g-channel (1 to 16).

      FORREFO(1,:) = (/ &
     &1.6586E-05_JPRB,1.9995E-05_JPRB,1.8582E-05_JPRB,1.3988E-05_JPRB,1.3650E-05_JPRB,1.1079E-05_JPRB, &
     &9.5855E-06_JPRB,8.4062E-06_JPRB,1.3558E-05_JPRB,1.8620E-05_JPRB,2.2652E-05_JPRB,1.7883E-05_JPRB, &
     &2.6241E-05_JPRB,3.1171E-05_JPRB,3.9386E-05_JPRB,4.4415E-05_JPRB/)
      FORREFO(2,:) = (/ &
     &2.0730E-05_JPRB,2.3258E-05_JPRB,2.1543E-05_JPRB,1.5660E-05_JPRB,9.7872E-06_JPRB,8.1078E-06_JPRB, &
     &7.0246E-06_JPRB,6.0428E-06_JPRB,4.8793E-06_JPRB,4.4937E-06_JPRB,4.7078E-06_JPRB,4.6898E-06_JPRB, &
     &6.9481E-06_JPRB,8.6269E-06_JPRB,3.1761E-06_JPRB,3.1440E-06_JPRB/)
      FORREFO(3,:) = (/ &
     &1.5737E-05_JPRB,2.2501E-05_JPRB,2.3520E-05_JPRB,2.0288E-05_JPRB,1.2083E-05_JPRB,6.8256E-06_JPRB, &
     &6.0637E-06_JPRB,5.5434E-06_JPRB,4.3888E-06_JPRB,3.8435E-06_JPRB,3.8477E-06_JPRB,3.8314E-06_JPRB, &
     &3.8251E-06_JPRB,3.3637E-06_JPRB,3.1950E-06_JPRB,3.1440E-06_JPRB/)
      FORREFO(4,:) = (/ &
     &1.1400E-05_JPRB,7.9751E-06_JPRB,8.8659E-06_JPRB,1.5884E-05_JPRB,1.9118E-05_JPRB,1.9429E-05_JPRB, &
     &2.0532E-05_JPRB,2.2155E-05_JPRB,2.3894E-05_JPRB,2.2984E-05_JPRB,2.3731E-05_JPRB,2.4538E-05_JPRB, &
     &2.6697E-05_JPRB,1.9329E-05_JPRB,3.3306E-06_JPRB,3.2018E-06_JPRB/)


!     The array SELFREFO contains the coefficient of the water vapor
!     self-continuum (including the energy term).  The first index
!     refers to temperature in 7.2 degree increments.  For instance,
!     JT = 1 refers to a temperature of 245.6, JT = 2 refers to 252.8,
!     etc.  The second index runs over the g-channel (1 to 16).

      SELFREFO(:, 1) = (/ &
     & 9.62275E-03_JPRB, 8.29909E-03_JPRB, 7.15750E-03_JPRB, 6.17294E-03_JPRB, 5.32382E-03_JPRB, &
     & 4.59150E-03_JPRB, 3.95991E-03_JPRB, 3.41520E-03_JPRB, 2.94542E-03_JPRB, 2.54026E-03_JPRB/)
      SELFREFO(:, 2) = (/ &
     & 9.76664E-03_JPRB, 8.47783E-03_JPRB, 7.35910E-03_JPRB, 6.38799E-03_JPRB, 5.54504E-03_JPRB, &
     & 4.81331E-03_JPRB, 4.17815E-03_JPRB, 3.62680E-03_JPRB, 3.14821E-03_JPRB, 2.73277E-03_JPRB/)
      SELFREFO(:, 3) = (/ &
     & 9.53856E-03_JPRB, 8.23750E-03_JPRB, 7.11390E-03_JPRB, 6.14356E-03_JPRB, 5.30558E-03_JPRB, &
     & 4.58190E-03_JPRB, 3.95693E-03_JPRB, 3.41720E-03_JPRB, 2.95109E-03_JPRB, 2.54856E-03_JPRB/)
      SELFREFO(:, 4) = (/ &
     & 8.47621E-03_JPRB, 7.29518E-03_JPRB, 6.27870E-03_JPRB, 5.40385E-03_JPRB, 4.65091E-03_JPRB, &
     & 4.00287E-03_JPRB, 3.44513E-03_JPRB, 2.96510E-03_JPRB, 2.55196E-03_JPRB, 2.19638E-03_JPRB/)
      SELFREFO(:, 5) = (/ &
     & 6.71258E-03_JPRB, 5.95346E-03_JPRB, 5.28020E-03_JPRB, 4.68307E-03_JPRB, 4.15348E-03_JPRB, &
     & 3.68377E-03_JPRB, 3.26718E-03_JPRB, 2.89770E-03_JPRB, 2.57000E-03_JPRB, 2.27937E-03_JPRB/)
      SELFREFO(:, 6) = (/ &
     & 6.29140E-03_JPRB, 5.55557E-03_JPRB, 4.90580E-03_JPRB, 4.33203E-03_JPRB, 3.82536E-03_JPRB, &
     & 3.37795E-03_JPRB, 2.98287E-03_JPRB, 2.63400E-03_JPRB, 2.32593E-03_JPRB, 2.05389E-03_JPRB/)
      SELFREFO(:, 7) = (/ &
     & 6.00229E-03_JPRB, 5.28180E-03_JPRB, 4.64780E-03_JPRB, 4.08990E-03_JPRB, 3.59897E-03_JPRB, &
     & 3.16696E-03_JPRB, 2.78682E-03_JPRB, 2.45230E-03_JPRB, 2.15794E-03_JPRB, 1.89891E-03_JPRB/)
      SELFREFO(:, 8) = (/ &
     & 5.78892E-03_JPRB, 5.07191E-03_JPRB, 4.44370E-03_JPRB, 3.89330E-03_JPRB, 3.41108E-03_JPRB, &
     & 2.98858E-03_JPRB, 2.61842E-03_JPRB, 2.29410E-03_JPRB, 2.00995E-03_JPRB, 1.76100E-03_JPRB/)
      SELFREFO(:, 9) = (/ &
     & 4.96186E-03_JPRB, 4.56767E-03_JPRB, 4.20480E-03_JPRB, 3.87076E-03_JPRB, 3.56325E-03_JPRB, &
     & 3.28017E-03_JPRB, 3.01959E-03_JPRB, 2.77970E-03_JPRB, 2.55887E-03_JPRB, 2.35559E-03_JPRB/)
      SELFREFO(:,10) = (/ &
     & 4.56849E-03_JPRB, 4.35527E-03_JPRB, 4.15200E-03_JPRB, 3.95822E-03_JPRB, 3.77348E-03_JPRB, &
     & 3.59736E-03_JPRB, 3.42946E-03_JPRB, 3.26940E-03_JPRB, 3.11681E-03_JPRB, 2.97134E-03_JPRB/)
      SELFREFO(:,11) = (/ &
     & 4.47310E-03_JPRB, 4.32453E-03_JPRB, 4.18090E-03_JPRB, 4.04204E-03_JPRB, 3.90779E-03_JPRB, &
     & 3.77799E-03_JPRB, 3.65251E-03_JPRB, 3.53120E-03_JPRB, 3.41392E-03_JPRB, 3.30053E-03_JPRB/)
      SELFREFO(:,12) = (/ &
     & 4.46459E-03_JPRB, 4.24031E-03_JPRB, 4.02730E-03_JPRB, 3.82499E-03_JPRB, 3.63284E-03_JPRB, &
     & 3.45035E-03_JPRB, 3.27702E-03_JPRB, 3.11240E-03_JPRB, 2.95605E-03_JPRB, 2.80755E-03_JPRB/)
      SELFREFO(:,13) = (/ &
     & 4.43961E-03_JPRB, 4.35658E-03_JPRB, 4.27510E-03_JPRB, 4.19514E-03_JPRB, 4.11669E-03_JPRB, &
     & 4.03969E-03_JPRB, 3.96414E-03_JPRB, 3.89000E-03_JPRB, 3.81725E-03_JPRB, 3.74585E-03_JPRB/)
      SELFREFO(:,14) = (/ &
     & 4.40512E-03_JPRB, 4.41515E-03_JPRB, 4.42520E-03_JPRB, 4.43527E-03_JPRB, 4.44537E-03_JPRB, &
     & 4.45549E-03_JPRB, 4.46563E-03_JPRB, 4.47580E-03_JPRB, 4.48599E-03_JPRB, 4.49620E-03_JPRB/)
      SELFREFO(:,15) = (/ &
     & 3.21965E-03_JPRB, 3.42479E-03_JPRB, 3.64300E-03_JPRB, 3.87512E-03_JPRB, 4.12202E-03_JPRB, &
     & 4.38466E-03_JPRB, 4.66403E-03_JPRB, 4.96120E-03_JPRB, 5.27731E-03_JPRB, 5.61355E-03_JPRB/)
      SELFREFO(:,16) = (/ &
     & 3.11402E-03_JPRB, 3.35870E-03_JPRB, 3.62260E-03_JPRB, 3.90724E-03_JPRB, 4.21424E-03_JPRB, &
     & 4.54536E-03_JPRB, 4.90250E-03_JPRB, 5.28770E-03_JPRB, 5.70317E-03_JPRB, 6.15128E-03_JPRB/)




!IF (LHOOK) CALL DR_HOOK('RRTM_KGB13',1,ZHOOK_HANDLE)
RETURN

1001 CONTINUE
CALL ABOR1("RRTM_KGB13:ERROR READING FILE RADRRTM")

END SUBROUTINE RRTM_KGB13
