MODULE YOERDU

! Special remark J.-F. Grailet (13/09/2022): updated this (initially a 
! source file from radCEP.d/module.d_1/ in forMARv3.12) by following 
! same conventions as for yoerad.F90.

USE PARKIND1, ONLY : JPIM, JPRB

IMPLICIT NONE

SAVE

!     ------------------------------------------------------------------
!*    ** *YOERDU* - CONTROL, PARAMETERS AND SECURITY IN RADIATION
!     ------------------------------------------------------------------

INTEGER(KIND=JPIM) :: NUAER
INTEGER(KIND=JPIM) :: NTRAER
INTEGER(KIND=JPIM) :: NIMP
INTEGER(KIND=JPIM) :: NOUT
REAL(KIND=JPRB) :: RCDAY
REAL(KIND=JPRB) :: R10E
REAL(KIND=JPRB) :: REPLOG
REAL(KIND=JPRB) :: REPSC
REAL(KIND=JPRB) :: REPSCO
REAL(KIND=JPRB) :: REPSCQ
REAL(KIND=JPRB) :: REPSCT
REAL(KIND=JPRB) :: REPSCW
REAL(KIND=JPRB) :: DIFF

!        * E.C.M.W.F. PHYSICS PACKAGE *

!     J.-J. MORCRETTE       E.C.M.W.F.      89/07/14

!  NAME     TYPE     PURPOSE
!  ----  :  ----   : ---------------------------------------------------
! NUAER  : INTEGER   NUMBER OF ABSORBER AMOUNTS        W OR W/O AEROSOLS
! NTRAER : INTEGER   NUMBER OF TRANSMISSION FUNCTIONS  W OR W/O AEROSOLS
! NIMP   : INTEGER   INDEX FOR EXTRA PRINTS WITHIN RADIATION CODE
! NOUT   : INTEGER   UNIT NUMBER FOR THE EXTRA PRINTS
! RCDAY  : REAL
! CCO2   : REAL      CONVERSION COEFFICIENT FOR CO2 IN S.W. CODE
! CH2O   : REAL      CONVERSION COEFFICIENT FOR H2O IN S.W. CODE
! R10E   : REAL      DECIMAL/NATURAL LOG.FACTOR
! DIFF   : REAL      DIFFUSIVITY FACTOR
!-SECURITY THRESHOLDS
! REPLOG : REAL      SEC. EPSILON FOR ABS.AMOUNT IN LAPLACE TRANSFORM
! REPSC  : REAL      SEC. EPSILON FOR CLOUD COVER
! REPSCO : REAL      SEC. EPSILON FOR OZONE AMOUNT
! REPSCQ : REAL      SEC. EPSILON FOR WATER VAPOR
! REPSCT : REAL      SEC. EPSILON FOR SHORTWAVE OPTICAL THICKNESS
! REPSCW : REAL      SEC. EPSILON FOR CLOUD LIQUID WATER PATH
! ----------------------------------------------------------------------

! J.-F. Grailet: kept this just in case.
!$OMP threadprivate ( &
!$OMP   NUAER &
!$OMP , NTRAER &
!$OMP , NIMP &
!$OMP , NOUT &
!$OMP , RCDAY &
!$OMP , R10E &
!$OMP , REPLOG &
!$OMP , REPSC &
!$OMP , REPSCO &
!$OMP , REPSCQ &
!$OMP , REPSCT &
!$OMP , REPSCW &
!$OMP , DIFF &
!$OMP )

END MODULE YOERDU
