MODULE INCMAR

USE PARKIND1, ONLY : JPIM, JPRB

IMPLICIT NONE

SAVE

!     ------------------------------------------------------------------
!*    ** *INCMAR* - ADDITIONAL VARIABLES FOR INCLUSION IN MAR
!     ------------------------------------------------------------------

! ------------------------------------------------------------------
! J.-F. GRAILET ULiège 16/09/2022 ~ 21/09/2022
! 
! Additional variables brought to include ecRad 1.5.0 in the MAR model. Said 
! variables are used in the IFS code provided in the ecRad 1.5.0 archive, but 
! their declaration was not found in the same files. This module therefore 
! declares them for the MAR inclusion and provides a short description and 
! values to use (inferred on the basis of the "driver" code and parts of the 
! provided IFS source files or provided by the ECMWF). A few extra variables 
! specifically used for the inclusion in MAR are declared as well.
! 
! Note that several variables normally come from a YRERAD derived type, which 
! exist in the IFS as part of the YOERAD module. Such a module exists in the 
! ecRad 1.5.0 archive, but does not provide a derived type, though some 
! variables from YRERAD are declared outside a derived type in yoerad.F90.
! 
! 17/11/2022: NLWSCATTERING has been split into LCLD_SCATTERING and 
! LAER_SCATTERING so users can activate longwave scattering for clouds and 
! aerosols independently (the latter being relevant only with MACC). Extra 
! variables have been added to be able to use ecCKD gas model as an 
! alternative to RRTM-G (default gas model).
! 
! ------------------------------------------------------------------

! Scaling factor for the solar constant (RI0), as MAR only simulates the troposphere
REAL(KIND=JPRB) :: RI0_SCALING
! Typical value is 0.9962 (1366 -> 1360.8, the solar constant used by MAR prior to using ecRad)

! MACC climatology for aerosols
INTEGER(KIND=JPIM) :: NAERMACC
! 0 to use Tegen aerosol climatology (default)
! 1 to use MACC aerosol climatology

! Longwave solver
INTEGER(KIND=JPIM) :: NLWSOLVER
! 0 = McICA (N.B.: McICA is for operational forecasting)
! 1 = SPARTACUS
! 2 = SPARTACUS with 3D effects
! 3 = Tripleclouds (JFG addition)

! Shortwave solver
INTEGER(KIND=JPIM) :: NSWSOLVER
! 0 = McICA (N.B.: McICA is for operational forecasting)
! 1 = SPARTACUS
! 2 = SPARTACUS with 3D effects
! 3 = Tripleclouds (JFG addition)

! Representation of longwave scattering, respectively with clouds (LCLD_) and aerosols (LAER_)
LOGICAL :: LCLD_SCATTERING
! Set this to true to activate
LOGICAL :: LAER_SCATTERING
! Set this to true to activate (N.B.: only taken into account if NAERMACC > 0)

! Fractional standard deviation of in-cloud water content
REAL(KIND=JPRB) :: RCLOUD_FRAC_STD
! 1.0, 0.75, 0.5, etc. (see Table 1 in http://www.met.rdg.ac.uk/~swrhgnrj/publications/shonk_part1.pdf)

! Constant decorrelation depth scales for CLOUD_OVERLAP_DECORR_LEN (when NDECOLAT=0)
REAL(KIND=JPRB) :: RCLOUD_DECORR_CF ! Cloud fraction (suggested value: 2.0_JPRB)
REAL(KIND=JPRB) :: RCLOUD_DECORR_CW ! Condensate (suggested value: 1.0_JPRB)

! Gas model
INTEGER(KIND=JPIM) :: NGASMODEL
! 0 = RRTM-G (default)
! 1 = ecCKD (experimental)

! Files used by ecCKD gas model
INTEGER, PARAMETER :: ECCKD_FILENAME_LEN = 100
CHARACTER(LEN=ECCKD_FILENAME_LEN) :: ECCKD_LW_FILE
CHARACTER(LEN=ECCKD_FILENAME_LEN) :: ECCKD_SW_FILE

! 05/04/2023: Additional variables to choose and tune the cloud fraction parametrization used to 
! compute the cloud fraction values (one per grid cell) sent to ecRad. There are four options for 
! the parametrization: use the same cloud fraction as compute in hydmic.f90, two variants of an 
! old ECMWF parametrization and a fourth option based on a paper by Xu and Randall (which can also 
! be used optionally in hydmic.f90). On 14/04, a few more variables were added to include the 
! Sundqvist's parametrization based on relative humidity.

INTEGER(KIND=JPIM) :: NCLOUD_PARAM
! 0 = MAR cloud fraction (from hydmic.f90)
! 1 = ECMWF Large Scale Cloudiness, crude version (without snowflakes)
! 2 = ECMWF Large Scale Cloudiness, complete version (same formula as in hydmic.f90)
! 3 = Parametrization based on relative humidity by Sundqvist (1989 in Monthly Weather Review 117)
! 4 = Semiempirical parametrization by Xu and Randall (1996 in JAS)

REAL(KIND=JPRB) :: RCLOUD_PARAM_ALPHA ! For Xu and Randall only
REAL(KIND=JPRB) :: RCLOUD_PARAM_GAMMA ! Formerly RGAMMAS in PHYrad2CEP, used in ECMWF/Xu & Randall
REAL(KIND=JPRB) :: RCLOUD_PARAM_P ! For Xu and Randall only

! Relative humidity thresholds for Sundqvist's parametrization
REAL(KIND=JPRB) :: RCLOUD_RH_THRESHOLD_LAND
REAL(KIND=JPRB) :: RCLOUD_RH_THRESHOLD_SEA

! 20/04/2023: Additional variables to control cloud overlap in ecRad. The two parameters that can 
! be currently controlled by the user is the ratio of decorrelation length for cloud water content 
! inhomogeneities and cloud boundaries (real value) and the use of beta cloud overlap (Shonk et 
! al., 2010) rather than alpha overlap (Hogan and Illingworth, 2000).

REAL(KIND=JPRB) :: RCLOUD_DECORR_LEN_RATIO ! Usually 0.5
LOGICAL :: LCLOUD_BETA_OVERLAP ! True if using beta overlap

! 14/02/2023: Additional variable to use blanket layers, a new optional feature for MAR. These 
! so-called "blanket layers" are additional pressure levels added on top of the MAR grid before 
! running ecRad on the whole to guarantee the stratosphere can be modeled up to the stratopause. 
! The number of additional levels and their upper limits can be tuned, but typically, three levels 
! are recommended with upper limits 30 hPa, 10 hPa and 1 hPa (stratopause). The limits must stay 
! within [1, 50] hPa for consistency's sake (MAR grid usually goes up to the tropopause, around 
! 70~80 hPa). This feature was designed to approximate the radiative effects of the stratosphere 
! on shortwave radiation, and in particular their spectral effect (e.g., effect of ozone on UVs). 
! The feature is considered activated when BLANKET_LAYERS is allocated. Why the name "blanket" ? 
! Cf. https://www.youtube.com/watch?v=xuCn8ux2gbs (around 3:00).

REAL(KIND=JPRB), DIMENSION(:), ALLOCATABLE :: BLANKET_LAYERS

! 13/03/2023: Additional variables to adjust the mixing ratios of: water vapor, ice crystals, 
! dropplets, hydrometeors (rain and snow). These variables are meant to allow users to toy around 
! with these values to mitigate the radiative fluxes biases (in wait for a more in-depth solution 
! for correcting such biases). Ideally, these scaling variables should be in [0.8, 1.2] maximum, 
! default value being 1 (no scaling).

REAL(KIND=JPRB) :: SCALING_PQ = 1.
REAL(KIND=JPRB) :: SCALING_PQIWP = 1.
REAL(KIND=JPRB) :: SCALING_PQLWP = 1.
REAL(KIND=JPRB) :: SCALING_PQRAIN = 1.
REAL(KIND=JPRB) :: SCALING_PQSNOW = 1.

! Minimum number of air columns each CPU should process
INTEGER(KIND=JPIM) :: COLUMNS_PER_THREAD

END MODULE INCMAR
