#include "MAR_pp.def"
subroutine dynwww
    ! +------------------------------------------------------------------------+
    ! | MAR DYNAMICS   DIAGNOSTICS                             06-21-2022  MAR |
    ! |   subroutine dynwww computes Vertical Wind Speed wairDY (z Coordinate) |
    ! |                                                                        |
    ! +------------------------------------------------------------------------+
    ! |                                                                        |
    ! |   INPUT  (via common block)                                            |
    ! |   ^^^^^   psigDY(i,j,k): Vertical Wind Speed (Sigma Coordinate system) |
    ! |                          on Level k                                    |
    ! |           uairDY(i,j,k): k Sigma Level Wind (x-direction)        [m/s] |
    ! |           vairDY(i,j,k): k Sigma Level Wind (y-direction)        [m/s] |
    ! |           gplvDY(i,j,k): k Sigma Level Geopotential            [m2/s2] |
    ! |           tairDY(i,j,k): k Sigma Level Temperature                 [K] |
    ! |                                                                        |
    ! |   OUTPUT (via common block)                                            |
    ! |   ^^^^^^  wairDY(i,j,k)= -(R T /p) g dSigma /dt + (u dz /dx +v dz /dy) |
    ! |                                                                 [cm/s] |
    ! |                                                                        |
    ! +------------------------------------------------------------------------+

    use marphy
    use mardim
    use margrd
    use mar_dy
    use mar_wk
    use marvec

    implicit none

    integer i, j, k, m

    !$OMP PARALLEL do default(shared) private(i,j,k)
      do j = 1, my
        do i = 1, mx
    do k = 1, mz
        ! +--u d(phi)/d(x)
        ! +  =============

                WKxyz2(i, j,k) = &
                    fac43 * (gplvDY(ip1(i), j, k) - gplvDY(im1(i), j, k) &
                             - 0.125 * (gplvDY(ip2(i), j, k) - gplvDY(im2(i), j, k))) * dyinv3(i, j)

                WKxyz1(i, j, k) = WKxyz2(i, j,k) * uairDY(i, j, k)

        ! +--v d(phi)/d(y)
        ! +  =============
        if(mmy > 1) then

                    WKxyz2(i, j, k) = &
                        fac43 * (gplvDY(i, jp1(j), k) - gplvDY(i, jm1(j), k) &
                                 - 0.125 * (gplvDY(i, jp2(j), k) - gplvDY(i, jm2(j), k))) * dyinv3(i, j)

                    WKxyz1(i, j, k) = WKxyz1(i, j, k) &
                                      + WKxyz2(i, j, k) * vairDY(i, j, k)

        endif

        ! +--Vertical Wind Speed (cm/s)
        ! +  ==========================

                wairDY(i, j, k) = -RDryAi * tairDY(i, j, k) * psigDY(i, j, k) * grvinv &
                                  / (pstDY(i, j) * sigma(k) + ptopDY) * 100. &
                                  +WKxyz1(i, j, k) * grvinv * 100.

                WKxyz2(i, j, k) = 0.0
                WKxyz1(i, j, k) = 0.0
            enddo
        enddo
    enddo
!$OMP END PARALLEL DO

    return
endsubroutine dynwww
