subroutine dynrho
    ! +------------------------------------------------------------------------+
    ! | MAR DYNAMICS                                           16-12-2000  MAR |
    ! |   subroutine dynrho computes the Air Specific Mass                     |
    ! |                                                                        |
    ! +------------------------------------------------------------------------+
    ! |                                                                        |
    ! |   INPUT   (via common block)                                           |
    ! |   ^^^^^   pstDY(mx,my)   : Atmosphere Thickness                  [kPa] |
    ! |          tairDY(mx,my,mz): Air Temperature                         [K] |
    ! |           virDY(mx,my,mz): Air Loading by Water Vapor and Hydrometeors |
    ! |                                                                        |
    ! |   OUTPUT  (via common block)                                           |
    ! |   ^^^^^^ rolvDY(mx,my,mz): Air Specific Mass at Sigma Levels    [T/m3] |
    ! |          romiDY(mx,my,mz): Air Specific Mass in Sigma Layers    [T/m3] |
    ! |          pstDY2(mx,my)   : Atmosphere Thickness Squared         [kPa2] |
    ! |                                                                        |
    ! +------------------------------------------------------------------------+
    use marphy
    use mardim
    use margrd
    use mar_dy
    use mar_sl

    implicit none

    ! +--Local  Variables
    ! +  ================
    integer i, j, k, m
    real sigmmz
    ! +
    ! +--Perfect Gas Law Relationship
    ! +  ----------------------------
    ! +
    do k = 1, mz
        do j = 1, my
            do i = 1, mx
                ! rolvDY(i,j,k) : Air Specific Mass at grid point (i,j,k)
                !              0.715 allows to include vir by 0.715=0.608/0.850
                rolvDY(i, j, k) = (pstDYn(i, j) * sigma(k) + ptopDY) &
                                  / (RDryAi * tairDY(i, j, k) * (1.0 + 0.715 * virDY(i, j, k)))
            enddo
        enddo
    enddo
    ! +
    do k = 1, mmz1
        do j = 1, my
            do i = 1, mx
                ! romiDY(i,j,k) : Air Specific Mass at grid point (i,j,k+1/2)
                romiDY(i, j, k) = (pstDYn(i, j) * sigmid(kp1(k)) + ptopDY) &
                                  / (RDryAi * 0.5 * (tairDY(i, j, k) * (1.0 + 0.715 * virDY(i, j, k)) &
                                                     + tairDY(i, j, kp1(k)) * (1.0 + 0.715 * virDY(i, j, kp1(k)))))
            enddo
        enddo
    enddo
    ! +
    sigmmz = 0.500 * (1.0 + sigma(mz))
    do j = 1, my
        do i = 1, mx
            romiDY(i, j, mz) = (pstDYn(i, j) * sigmmz + ptopDY) &
                               / (RDryAi * 0.50 * (tairDY(i, j, mz) + TairSL(i, j)) &
                                  * (1.0 + 0.715 * virDY(i, j, mz)))
            pstDY2(i, j) = pstDY(i, j) * pstDY(i, j)
        enddo
    enddo
    return
endsubroutine dynrho
