#include "MAR_pp.def"
subroutine DYNqqm(specQt, kk, eval_s, eval_p)
    !--------------------------------------------------------------------------+
    !   MAR DYNAMICS   SLOW                                Wed 08-09-2017  MAR |
    !                                                                          |
    !     subroutine DYNqqm restaures Water Mass                               |
    !                                                                          |
    !--------------------------------------------------------------------------+

    use marphy
    use mardim
    use margrd
    use mar_ge
    use mar_dy
    use mar_fi
    use marqqm
    use mar_wk
    use marmagic

    implicit none

    logical RetroD
    logical Set_MM
    logical logqqm
    common / DYNqqm_log / logqqm
    real specQt(mx, my, mz)
    character * 3 eval_s
    character * 6 eval_p

    !  Local  Variables
    !  ================

    integer i, j, k, m
    character * 6 eval0p
    common / DYNqqm_cha / eval0p

    real fac_mm, summmm, sum_mm, countr
    real sumnew, qqnmin(mz), qqnmax(mz)
    real sumbak(mz), qqxmin(mz), qqxmax(mz) &
        , qqnFil(mx, my, mz)
    common / DYNqqm_rea / sumbak, qqxmin, qqxmax &
        , qqnFil

    data RetroD/.false./
    data Set_MM/.false./
    data logqqm/.false./
    real FacFIk
    integer kk

    !    FacFIk=humidity_magic*max(0.8,min(1.2,(25000./dx)**0.25))

    FacFIk = max(1., min(humidity_magic, 25.))

    !  Conservation Constraint Boundary
    !  ================================

    if(.not. logqqm) then
        logqqm = .true.
        ! write(6,6) lb
        !6      format(/,'*** DYNqqm: lb =',i3,' ***',/,'    ******',/)
    endif

    !  Retro-diffusion (Before Process)
    !  ================================

    !$OMP PARALLEL do private (i,j,k, fac_mm,summmm,sum_mm,countr,sumnew)
    do k = kk, mz
        if(RetroD) then
            do j = 1, my
                do i = 1, mx
                    WKxyz1(i, j, k) = (FIsloQ / FIslou) &
                                      * FIkhmn * (specQt(i - 1, j, k) - 4. &
                                                  *specQt(i, j, k) + specQt(i + 1, j, k) &
                                                  + specQt(i, j - 1, k) + specQt(i, j + 1, k)) &
                                      * dtx / dx
                enddo
            enddo
            !  end do
            !  do k=1,mz
            do j = 1, my
                do i = 1, mx
                    specQt(i, j, k) = specQt(i, j, k) - WKxyz1(i, j, k)
                    WKxyz1(i, j, k) = 0.
                enddo
            enddo
            ! end do
        endif

        !  Mass Evaluation (Before Process)
        !  ================================

        if(eval_s == 'BAK') then
            eval0p = eval_p
            ! do k=1,mz
            qqxmax(k) = 0.0
            qqxmin(k) = 1.e20
            do j = 1, my
                do i = 1, mx
                    qqnFil(i, j, k) = specQt(i, j, k) * pstDYn(i, j) &
                                      / (SFm_DY(i, j) * SFm_DY(i, j))
                    qqxmax(k) = max(qqxmax(k), qqnFil(i, j, k))
                    qqxmin(k) = min(qqxmin(k), qqnFil(i, j, k))
                enddo
            enddo
            ! end do

            if(FIBord) then
                ! do k=1,mz
                sumbak(k) = 0.0
                do j = lgy, ldy
                    do i = lgx, ldx
                        sumbak(k) = sumbak(k) + qqnFil(i, j, k)
                    enddo
                enddo
                ! end do

                if(eval_p(1:3) == 'FIL') then

                    ! do k=1,mz
                    do j = lgy, ldy
                        sumbak(k) = sumbak(k) + dtx &
                                    * (FIkhmn * FacFIk * &
                                       (specQt(lgx1, j, k) * pstDYn(lgx1, j) &
                                        - specQt(lgx, j, k) * pstDYn(lgx, j) &
                                        + specQt(ldx1, j, k) * pstDYn(ldx1, j) &
                                        - specQt(ldx, j, k) * pstDYn(ldx, j))) / &
                                    dx
                    enddo

                    do i = lgx, ldx
                        sumbak(k) = sumbak(k) + dtx &
                                    * (FIkhmn * FacFIk * &
                                       (specQt(i, lgy1, k) * pstDYn(i, lgy1) &
                                        - specQt(i, lgy, k) * pstDYn(i, lgy) &
                                        + specQt(i, ldy1, k) * pstDYn(i, ldy1) &
                                        - specQt(i, ldy, k) * pstDYn(i, ldy))) / &
                                    dx
                    enddo
                    ! end do
                endif
            else
                ! do k=1,mz
                sumbak(k) = 0.0
                do j = 1, my
                    do i = 1, mx
                        sumbak(k) = sumbak(k) + qqnFil(i, j, k)
                    enddo
                enddo
                ! end do
            endif

        else if(eval_s == 'SET') then
            !  Mass Reset (After  Process)
            !  ===========================
            if(eval_p /= eval0p) then
                write(6, 6010) eval_p, eval0p
6010            format('Problem in Mass Reset, Process', a7, ' .NE. ', a6)
                STOP
            endif
            ! do k=1,mz
            qqnmax(k) = 0.0
            qqnmin(k) = 1.e20
            do j = 1, my
                do i = 1, mx
                    WKxyz1(i, j, k) = specQt(i, j, k) * pstDYn(i, j) &
                                      / (SFm_DY(i, j) * SFm_DY(i, j))
                enddo
            enddo
            ! end do
#ifdef VQ
            summmm = 0.0
#endif
            if(FIBord) then
                ! do k=1,mz
                sumnew = 0.0
                do j = lgy, ldy
                    do i = lgx, ldx
                        sumnew = WKxyz1(i, j, k) + sumnew
                    enddo
                enddo
                sumnew = max(eps9, sumnew)
                countr = (ldx - lgx + 1) * (ldy - lgy + 1)
                fac_mm = sumbak(k) / sumnew
#ifdef VQ
                summmm = summmm + dsigm1(k) * fac_mm
#endif
                do j = 1, my
                    do i = 1, mx
                        specQt(i, j, k) = specQt(i, j, k) * fac_mm
                        WKxyz1(i, j, k) = WKxyz1(i, j, k) * fac_mm
                        qqnmax(k) = max(WKxyz1(i, j, k), qqnmax(k))
                        qqnmin(k) = min(WKxyz1(i, j, k), qqnmin(k))
                    enddo
                enddo
                sumbak(k) = sumbak(k) / countr
                ! end do
            else
                ! do k=1,mz
                sumnew = 0.0
                do j = 1, my
                    do i = 1, mx
                        sumnew = WKxyz1(i, j, k) + sumnew
                    enddo
                enddo
                sumnew = max(eps9, sumnew)
                countr = mx * my
                fac_mm = sumbak(k) / sumnew
#ifdef VQ
                summmm = summmm + dsigm1(k) * fac_mm
#endif
                do j = 1, my
                    do i = 1, mx
                        specQt(i, j, k) = specQt(i, j, k) * fac_mm
                        WKxyz1(i, j, k) = WKxyz1(i, j, k) * fac_mm
                        qqnmax(k) = max(WKxyz1(i, j, k), qqnmax(k))
                        qqnmin(k) = min(WKxyz1(i, j, k), qqnmin(k))
                    enddo
                enddo
                sumbak(k) = sumbak(k) / countr
                ! end do
            endif

            !  Maximorum/Minimorum RESET (water vapor only)
            !  ============================================

            if(eval_p == 'FIL_Qv' .and. Set_MM) then
#ifdef VQ
                sum_mm = 0.
#endif
                ! do k=1,mz
                fac_mm = (qqxmax(k) - sumbak(k)) &
                         / (max(epsi, qqnmax(k) - sumbak(k)))
                fac_mm = min((sumbak(k) - sigma(k) * 103.5 * epsq) &
                             / (sumbak(k) - qqnmin(k)), fac_mm)
                fac_mm = max(1.0, fac_mm)
#ifdef VQ
                sum_mm = sum_mm + dsigm1(k) * fac_mm
#endif
                do j = 1, my
                    do i = 1, mx
                        WKxyz1(i, j, k) = sumbak(k) + fac_mm * (WKxyz1(i, j, k) - sumbak(k))
                        specQt(i, j, k) = WKxyz1(i, j, k) * SFm_DY(i, j) * SFm_DY(i, j) &
                                          / pstDYn(i, j)
                    enddo
                enddo
                ! end do

                !  Output of Statistics
                !  ====================
#ifdef VQ
                if(mod(jhurGE, 3) == 0 .and. minuGE == 0 .and. jsecGE == 0) write(24, 240)
240             format(21x, 'RESTORE MASS ... EXTREMA')
                write(24, 241) jdarGE, labmGE(mmarGE), iyrrGE &
                    , jhurGE, minuGE, jsecGE &
                    , summmm, sum_mm
241             format(i3, '-', a3, '-', i4, i3, 'h', i2, ':', i2, 2f12.6)
#endif
            endif

            !  Work Array(s) reset
            !  ===================

            ! do k=1,mz
            do j = 1, my
                do i = 1, mx
                    WKxyz1(i, j, k) = 0.
                enddo
            enddo
            ! end do

        else
            write(6, 6020) eval_s
6020        format('Problem in Mass Reset, Type   ', a4)
            STOP
        ENDif
    enddo
    !$OMP END PARALLEL DO

    return
endsubroutine DYNqqm
