#include "MAR_pp.def"
subroutine dynloa
    ! +------------------------------------------------------------------------+
    ! | MAR DYNAMICS                                      Mon 11-Apr-2011  MAR |
    ! |   subroutine dynloa computes the Air Loading due to the Precipitation  |
    ! |                                                                        |
    ! +------------------------------------------------------------------------+
    ! |                                                                        |
    ! |   INPUT   (via common block)                                           |
    ! |   ^^^^^   qvDY(mx,my,mz) : Air Specific Humidity               [kg/kg] |
    ! |           qwHY(mx,my,mz) : Cloud Droplets     Concentration    [kg/kg] |
    ! |           qiHY(mx,my,mz) : Cloud ice Crystals Concentration    [kg/kg] |
    ! |           qrHY(mx,my,mz) : Rain  Drops        Concentration    [kg/kg] |
    ! |           qsHY(mx,my,mz) : Snow  Flakes       Concentration    [kg/kg] |
    ! |                                                                        |
    ! |   OUTPUT  (via common block)                                           |
    ! |   ^^^^^^ virDY(mx,my,mz) : Air Loading by Water Vapor & Hydrometeors   |
    ! |          virSL(mx,my)    : Air Loading by Water Vapor & Hydrometeors   |
    ! |                            (in the Surface Layer)                      |
    ! |                                                                        |
    ! +------------------------------------------------------------------------+
    use marctr
    use marphy
    use mardim
    use margrd
    use mar_dy
    use mar_hy
    use mar_sl
#ifdef TC
    use mar_tc
#endif
#ifdef BV
    use marvec
#endif

    implicit none

    integer i, j, k, m
#ifdef BV
    integer kdim
    real deltav
    data deltav/0.20/
#endif

    ! +--Air Loading including Specific Humidity (Level 0)
    ! +  =================================================
    ! CAaiso qvDY is initialized to 0 with the compiler
    do k = 1, mz
        do j = 1, my
            do i = 1, mx
                virDY(i, j, k) = qvDY(i, j, k)
            enddo
        enddo
    enddo

    ! +--Air Loading including all Hydrometeors  (Level 1)
    ! +  =================================================
    do k = 1, mz
        do j = 1, my
            do i = 1, mx
                virDY(i, j, k) = qvDY(i, j, k) &
                                 - 1.64 * min(demi, qwHY(i, j, k) + qiHY(i, j, k) + &
                                              qrHY(i, j, k) + qsHY(i, j, k))
            enddo
        enddo
    enddo

    ! +--Air Loading including Correction Factor (Level 2)
    ! +  =================================================
    do k = 1, mz
        do j = 1, my
            do i = 1, mx
                virDY(i, j, k) = 0.850 * virDY(i, j, k)
            enddo
        enddo
    enddo

    ! +--Lateral Boundary Conditions
    ! +  ===========================
    do k = 1, mz
        do j = 1, my
            virDY(1, j, k) = virDY(ip11, j, k)
            virDY(mx, j, k) = virDY(mx1, j, k)
        enddo
        do i = 1, mx
            virDY(i, 1, k) = virDY(i, jp11, k)
            virDY(i, my, k) = virDY(i, my1, k)
        enddo
    enddo

#ifdef BV
    ! +--Air Loading for SBL Parameterization
    ! +  ====================================
    dumeps(1) = deltav
    do j = 1, my
        do i = 1, mx
            dumy3D(i, j, 1) = fracSL * 0.715 * virDY(i, j, mz) &
                              + (1.0 - fracSL) * virSL(i, j)
        enddo
    enddo
    kdim = 1
    ! +--Filtering
    ! +  ---------
    if(mmx > 1) then
        if(mmy == 1) then
            ! +  *********
            call DYNfil_1D(dumy3D, dumeps, kdim)
            ! +  *********
        else
            if(no_vec) then
                if(openmp) then
                    !    **********
                    call DYNfil_3D_mp(dumy3D, dumeps, kdim)
                    !    **********
                else
                    !    **********
                    call DYNfil_3D(dumy3D, dumeps, kdim)
                    !    **********
                endif
            else
                ! CAa : DYNfilv3D does not exist
                !                ! +  *********
                !                call DYNfilv3D (dumy3D, dumeps, kdim)
                !                ! +  *********
            endif
        endif
    endif
    do j = 1, my
        do i = 1, mx
            virSL(i, j) = dumy3D(i, j, 1)
        enddo
    enddo
#endif
#ifdef OM
    ! +--NO Loading included in case of Mountain Waves Tests
    ! +  ===================================================
    do k = 1, mz
        do j = 1, my
            do i = 1, mx
                virDY(i, j, k) = 0.0d+0
            enddo
        enddo
    enddo
#endif
    return
endsubroutine dynloa
