subroutine dyngpo_mp
    ! +------------------------------------------------------------------------+
    ! | MAR DYNAMICS   FAST                                    16-12-2000  MAR |
    ! |   subroutine DYNgpo contains the Integration of Hydrostatic Relation   |
    ! |                          and the Computation of Real Temperature t [K] |
    ! |                                                                        |
    ! +------------------------------------------------------------------------+
    ! |                                                                        |
    ! |   INPUT   (via common block)                                           |
    ! |   ^^^^^   pktaDY(mx,my,mzz): Reduced Potential Temperature             |
    ! |           gplvDY(mx,my,mzz): Surface Geopotential (i.e. for k=mzz)     |
    ! |            virDY(mx,my,mz) : Air Loading by water vapor & hydrometeors |
    ! |                                                                        |
    ! |   OUTPUT  (via common block)                                           |
    ! |   ^^^^^^    pkDY(mx,my,mz) : Exner Potential                           |
    ! |           tairDY(mx,my,mz) : Temperature                           [K] |
    ! |           gplvDY(mx,my,mzz): Geopotential                      [m2/s2] |
    ! |                                                                        |
    ! +------------------------------------------------------------------------+
    use marphy
    use mardim
    use margrd
    use mar_dy
    use mar_wk

    implicit none

    integer i, j, k, m
    real ab

    ! +--EXNER Potential and Temperature
    ! +  ===============================
    ab = 0.5 * (1.0 - sigmid(mz)) / (1.0 - sigmid(mmz1))

!$OMP PARALLEL DO private(i,j,k)
    do j = 1, my
        do k = 1, mz
            do i = 1, mx
                pkDY(i, j, k) = exp(cap * log(pstDYn(i, j) * sigma(k) + ptopDY))
                tairDY(i, j, k) = pktaDY(i, j, k) * pkDY(i, j, k)
                WTxyz1(i, j, k) = cp * pkDY(i, j, k)
            enddo
            ! end do
        enddo

        do k = 1, mmz1
            ! do j=1,my
            do i = 1, mx
                WTxyz2(i, j, k) = cp * pkDY(i, j, kp1(k))
            enddo
            ! end do
        enddo

        ! do j=1,my
        do i = 1, mx
            WTxyz2(i, j, mz) = cp * &
                               exp(cap * log(pstDYn(i, j) + ptopDY))
        enddo
        ! end do

        ! +--Integration of the Hydrostatic Equation / Work Arrays Reset
        ! +  ===========================================================

        ! do j=1,my
        do i = 1, mx
            gplvDY(i, j, mz) = gplvDY(i, j, mzz) + (WTxyz2(i, j, mz) - WTxyz1(i, j, mz)) &
                               * ((1.0 + ab) * pktaDY(i, j, mz) * (1.0 + virDY(i, j, mz)) &
                                  - ab * pktaDY(i, j, mmz1) * (1.0 + virDY(i, j, mmz1)))
            WTxyz1(i, j, mz) = 0.0
            WTxyz2(i, j, mz) = 0.0
        enddo
        ! end do

        do k = mmz1, 1, -1
            ! do j=1,my
            do i = 1, mx
                gplvDY(i, j, k) = gplvDY(i, j, kp1(k)) + (WTxyz2(i, j, k) - WTxyz1(i, j, k)) &
                                  * (pktaDY(i, j, k) * (1.0 + virDY(i, j, k)) &
                                     + pktaDY(i, j, kp1(k)) * (1.0 + virDY(i, j, kp1(k)))) * 0.5

            enddo
        enddo
    enddo
!$OMP END PARALLEL DO

    return
endsubroutine dyngpo_mp
