#include "MAR_pp.def"
subroutine DYNfil_1D(f1_fil, e1_fil, k1_fil)
    ! +------------------------------------------------------------------------+
    ! | MAR DYNAMICS FILTER (1-D)                              24-09-2001  MAR |
    ! |   subroutine DYNfil_1D  is used to Filter Horizontal Fields in 2D Code |
    ! |                                                                        |
    ! +------------------------------------------------------------------------+
    ! |                                                                        |
    ! |   INPUT:  f1_fil   : filtered variable                                 |
    ! |   ^^^^^   e1_fil   : value of the selectivity parameter                |
    ! |           k1_fil   : vertical dimension of the problem                 |
    ! |                                                                        |
    ! |   OUTPUT:(via common block)                                            |
    ! |   ^^^^^^  f1_fil                                                       |
    ! |                                                                        |
    ! |   LATERAL BOUNDARIES:                                                  |
    ! |   ^^^^^^^^^^^^^^^^^^^                                                  |
    ! |   1. The value    of the variable is fixed at the Boundary             |
    ! |   2. Filter Selectivity Parameter may be increased near the Boundary   |
    ! |                                                                (#EP)   |
    ! |                                                                        |
    ! |   REFER. : Alpert (1981), J.Comput.Phys. 44, pp.212--219               |
    ! |   ^^^^^^^^                                                             |
    ! +------------------------------------------------------------------------+
    ! +
    use marphy
    use mardim
    use marvec
    ! +
    implicit none
    ! +
    real f1_fil(mx, my, mz), e1_fil(mz)
    integer k1_fil
    ! +
    ! +
    ! +--Local  Variables
    ! +  ================
    integer kindex
    integer m, i
    integer m1, m2
    real aa, bb
#ifdef EP
    integer m3, m4
    real delt2, delt3, delt4
#endif
    ! +
    ! +
    ! +--Initialisation of the Gaussian Elimination Algorithm
    ! +  ====================================================
    ! +
    m = mx
    m1 = m - 1
    m2 = m - 2
#ifdef EP
    m3 = m - 3
    m4 = m - 4
#endif
    ! +
    do kindex = 1, k1_fil
        ! +
        vecx1(1) = 0.0
        vecx2(1) = 1.0
        vecx1(m) = 0.0
        vecx2(m) = 1.0
        vecx4(1) = f1_fil(1, 1, kindex)
        vecx4(m) = f1_fil(m, 1, kindex)
        ! +
        delta = e1_fil(kindex)
        ! +
#ifdef EP
        delt4 = delta + delta
        delt3 = delt4 + delt4
        delt2 = delt3 + delt3
#endif
        ! +..   Filter Selectivity Parameter Increase near the Boundaries
        ! +
        aa = 1.0 - delta
        bb = 2.0 * (1.0 + delta)
        ! +
        do i = 2, m1
            vecx1(i) = aa
            vecx2(i) = bb
            vecx4(i) = f1_fil(i - 1, 1, kindex) + 2.0 * f1_fil(i, 1, kindex) &
                       + f1_fil(i + 1, 1, kindex)
        enddo
        ! +
#ifdef EP
        vecx1(2) = 1.0 - delt2
        vecx1(3) = 1.0 - delt3
        vecx1(4) = 1.0 - delt4
        vecx2(2) = 2.0 * (1.0 + delt2)
        vecx2(3) = 2.0 * (1.0 + delt3)
        vecx2(4) = 2.0 * (1.0 + delt4)
        vecx1(m2) = vecx1(2)
        vecx1(m3) = vecx1(3)
        vecx1(m4) = vecx1(4)
        vecx2(m2) = vecx2(2)
        vecx2(m3) = vecx2(3)
        vecx2(m4) = vecx2(4)
#endif
        ! +
        do i = 1, m
            vecxa(i) = f1_fil(i, 1, kindex)
            vecx5(i) = 0.
            vecx6(i) = 0.
        enddo
        ! +
        ! +
        ! +--Gaussian Elimination Algorithm
        ! +  ==============================
        ! +
        ! +  *********
        call tlat(vecx1, vecx2, vecx1, vecx4, vecx5, vecx6, m, m, vecxa)
        ! +  *********
        ! +
        do i = 1, m
            f1_fil(i, 1, kindex) = vecxa(i)
        enddo
        ! +
    enddo
    ! +
    return
endsubroutine DYNfil_1D
