#include "MAR_pp.def"
subroutine DYNadv_sal
    ! +------------------------------------------------------------------------+
    ! | MAR DYNAMICS   SLOW                               Tue 10-Jan-2012  MAR |
    ! |   subroutine DYNadv_sal includes the Horizontal Advection Contribution |
    ! |                                  of Saltating Snow                     |
    ! |                                                                        |
    ! +------------------------------------------------------------------------+
    ! |                                                                        |
    ! |   INPUT   (via common block)                                           |
    ! |   ^^^^^    iterun: Run   Iteration                        Counter      |
    ! |            micphy: Cloud Microphysics                     Switch       |
    ! |            openLB: Open  Lateral Boundary Condition (LBC) Switch       |
    ! |                                                                        |
    ! |   INPUT  / uairDY,vairDY, qsHY, uss_HY                                 |
    ! |   OUTPUT : snobSL  : snow eroded        thickness            [m w.e.]  |
    ! |   ^^^^^^^^ snohSL  : snow precipitation thickness            [m w.e.]  |
    ! |                                                                        |
    ! |   METHOD : The following Contributions are taken into account:         |
    ! |   ^^^^^^^^     dq/dt:=-(ud(qp*)/dx -vd(qp*)/dy)/p*                     |
    ! |                                                                        |
    ! |   REFER. : Alpert, thesis, 1980                                        |
    ! |   ^^^^^^^^ Pielke, Mesoscale Meteorological Modeling, 297--307, 1984   |
    ! |            Seibert and Morariu, JAM, p.118, 1991                       |
    ! |                                                                        |
    ! +------------------------------------------------------------------------+

    use marctr
    use marphy
    use mardim
    use margrd
    use mar_dy
    use mar_hy
    use mar_bs
    use mar_sl
    use mar_wk

    implicit none

    ! +--Local  Variables
    ! +  ================

    integer i, j, k, m
    real facFLX
    common / DYNadv_sal_r / facFLX

    if(iterun <= 1) then
        !         if (zsigma(mz).LT.1.5)
        !    .    STOP ' in DYNadv_sal: z_sbl inacceptable'
        !         facFLX=0.1+0.8*exp(-(zsigma(mz)-0.5)*0.15)
        facFLX = 2.0 + 6.0 * exp(-(zsigma(mz) - 0.4) * 1.50) - 1.
    endif

    !  +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

    !  Additional Snow Particles Horizontal Flux
    !  =========================================

    k = mz
    !        k = mz (i.e., Consider SBL only)

    do j = 1, my
        do i = 1, mx
            WKxy0(i, j) = pstDY(i, j) &
                          * facFLX * qsHY(i, j, k) * min(unun, sign(unun, zero - uss_HY(i, j)))
        enddo
    enddo

    do j = 1, my
        do i = 1, mx
            WKxy1(i, j) = WKxy0(i, j) * uairDY(i, j, k)
            WKxy2(i, j) = WKxy0(i, j) * vairDY(i, j, k)
        enddo
    enddo

    !  Flux Convergence
    !  ================

    do j = jp11, my1
        do i = ip11, mx1
            qsHY(i, j, k) = qsHY(i, j, k) &
                            + (dtx * (WKxy1(im1(i), j) - WKxy1(ip1(i), j)) &
                               + dty * (WKxy2(i, jm1(j)) - WKxy2(i, jp1(j)))) &
                            / (2.0 * pstDY(i, j))
        enddo
    enddo

    do j = 1, my
        do i = 1, mx
            WKxy0(i, j) = 0.
            WKxy1(i, j) = 0.
            WKxy2(i, j) = 0.
        enddo
    enddo

    !  +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

    return
endsubroutine DYNadv_sal
