subroutine DYNadv_dLF_mp(nordAV, ffx, ffy, advffx, advffy)
    ! +------------------------------------------------------------------------+
    ! | MAR DYNAMICS   FAST                                    07-04-2021  MAR |
    ! |   subroutine DYNadv_dLF generates Advection Contribution               |
    ! |                                                                        |
    ! +------------------------------------------------------------------------+
    ! |                                                                        |
    ! |   INPUT/           ffx(mx,my,mz): Advected  Variable                   |
    ! |   ^^^^^^                                                               |
    ! |                                                                        |
    ! |   INPUT/  (via common block)                                           |
    ! |   ^^^^^^        uairDY(mx,my,mz): Advection Vector: x-----Direction    |
    ! |                 vairDY(mx,my,mz): Advection Vector: y-----Direction    |
    ! |                 wsigDY(mx,my,mz): Advection Vector: sigma-Direction    |
    ! |                                                                        |
    ! |   OUTPUT        advffx(mx,my,mz): Advection Contribution               |
    ! |   ^^^^^^                                                               |
    ! |                                                                        |
    ! |   METHOD:  2th order accurate Time       Scheme (leapfrog backw.) .and.|
    ! |   ^^^^^^  (2th order accurate Horizontal Scheme on Arakawa A grid .OR. |
    ! |            4th order accurate Horizontal Scheme on Arakawa A grid     )|
    ! |            2th order          Vertical   Scheme                        |
    ! |                                                                        |
    ! |   REFER.:  Use of  A grid: Purser   & Leslie,   1988, MWR 116, p.2069  |
    ! |   ^^^^^^   Time    Scheme: Haltiner & Williams, 1980, 5-2,     p.152   |
    ! |            Spatial Scheme: Haltiner & Williams, 1980, 5-6-5,   p.135   |
    ! |                                                                        |
    ! +------------------------------------------------------------------------+

    use marctr
    use mardim
    use margrd
    use mar_dy
    use mar_wk

    implicit none

    integer i, j, k, m
    integer nordAV

    real ffx(mx, my, mz) ! uairdy
    real advffx(mx, my, mz)

    real ffy(mx, my, mz) ! vairdy
    real advffy(mx, my, mz)

    ! +--Contribution to Advection
    ! +  =========================
    !$OMP PARALLEL do private (i,j,k)
    do k = 1, mz
        do j = 1, my
            do i = 1, mx
                WTxyz8(i, j, k) = ffx(i, j, k)
                WPxyz8(i, j, k) = ffy(i, j, k)
            enddo
        enddo
        ! end do

        ! +--2th centered Differences / x-----Direction
        ! +  ------------------------------------------

        if(nordAV == 2) then

            !       do k=1,mz
            do i = 1, mx
                do j = 1, my
                    WTxyz1(i, j, k) = uairDY(i, j, k) * dxinv3(i, j) * ( &
                                      WTxyz8(im1(i), j, k) - WTxyz8(ip1(i), j, k))
                    WPxyz1(i, j, k) = uairDY(i, j, k) * dxinv3(i, j) * ( &
                                      WPxyz8(im1(i), j, k) - WPxyz8(ip1(i), j, k))
                enddo
            enddo
            !c #vL   end do

            ! +--2th centered Differences / y-----Direction
            ! +  ------------------------------------------

            !c #vL   do k=1,mz
            do j = 1, my
                do i = 1, mx
                    WTxyz2(i, j, k) = vairDY(i, j, k) * dyinv3(i, j) * ( &
                                      WTxyz8(i, jm1(j), k) - WTxyz8(i, jp1(j), k))
                    WPxyz2(i, j, k) = vairDY(i, j, k) * dyinv3(i, j) * ( &
                                      WPxyz8(i, jm1(j), k) - WPxyz8(i, jp1(j), k))
                enddo
            enddo
            ! end do

        else
            ! +--4th centered Differences / x-----Direction
            ! +  ------------------------------------------

            ! do k=1,mz
            do i = 1, mx
                do j = 1, my
                    WTxyz1(i, j, k) = uairDY(i, j, k) * dxinv3(i, j) * fac43 * ( &
                                      0.125 * (WTxyz8(ip2(i), j, k) - WTxyz8(im2(i), j, k)) &
                                      - WTxyz8(ip1(i), j, k) + WTxyz8(im1(i), j, k))
                    WPxyz1(i, j, k) = uairDY(i, j, k) * dxinv3(i, j) * fac43 * ( &
                                      0.125 * (WPxyz8(ip2(i), j, k) - WPxyz8(im2(i), j, k)) &
                                      - WPxyz8(ip1(i), j, k) + WPxyz8(im1(i), j, k))
                enddo
            enddo
            !c #vL   end do

            ! +--4th centered Differences / y-----Direction
            ! +  ------------------------------------------
            !c #vL   do k=1,mz
            do j = 1, my
                do i = 1, mx
                    WTxyz2(i, j, k) = vairDY(i, j, k) * dyinv3(i, j) * fac43 * ( &
                                      0.125 * (WTxyz8(i, jp2(j), k) - WTxyz8(i, jm2(j), k)) &
                                      - WTxyz8(i, jp1(j), k) + WTxyz8(i, jm1(j), k))
                    WPxyz2(i, j, k) = vairDY(i, j, k) * dyinv3(i, j) * fac43 * ( &
                                      0.125 * (WPxyz8(i, jp2(j), k) - WPxyz8(i, jm2(j), k)) &
                                      - WPxyz8(i, jp1(j), k) + WPxyz8(i, jm1(j), k))
                enddo
            enddo
            ! end do
        endif

        ! +--2th centered Differences  / sigma-Direction  / Energy conserving
        ! +  --- (Haltiner and Williams, 1980, 7.2.2, Eqn. (7-47b) p.220) ---
        ! +      --------------------------------------------------------

        !  do k=   1,mz
        do j = jp11, my1
            do i = ip11, mx1
                WTxyz6(i, j, k) = ffx(i, j, k) - ffx(i, j, kp1(k))
                WPxyz6(i, j, k) = ffy(i, j, k) - ffy(i, j, kp1(k))
                if(k >= 2) then
                    WTxyz6(i, j, km1(k)) = ffx(i, j, km1(k)) - ffx(i, j, k)
                    WPxyz6(i, j, km1(k)) = ffy(i, j, km1(k)) - ffy(i, j, k)
                endif
            enddo
        enddo
        ! end do

        if(k == 1) then
            do j = jp11, my1
                do i = ip11, mx1
                    WTxyz3(i, j, k) = WTxyz6(i, j, k) * wsigDY(i, j, k) &
                                      * 0.5 / dsigm1(1)
                    WPxyz3(i, j, k) = WPxyz6(i, j, k) * wsigDY(i, j, k) &
                                      * 0.5 / dsigm1(1)
                enddo
            enddo
        else
            do j = jp11, my1
                do i = ip11, mx1
                    WTxyz3(i, j, k) = (WTxyz6(i, j, k) * wsigDY(i, j, k) &
                                       + WTxyz6(i, j, km1(k)) * wsigDY(i, j, km1(k))) &
                                      * 0.5 / dsigm1(k)
                    WPxyz3(i, j, k) = (WPxyz6(i, j, k) * wsigDY(i, j, k) &
                                       + WPxyz6(i, j, km1(k)) * wsigDY(i, j, km1(k))) &
                                      * 0.5 / dsigm1(k)
                enddo
            enddo
        endif

        ! +--Sum of the Contributions
        ! +  ========================

        do i = ip11, mx1
            do j = jp11, my1
                !  do k=   1,mz
                advffx(i, j, k) = WTxyz1(i, j, k) + WTxyz2(i, j, k) + WTxyz3(i, j, k)
                advffy(i, j, k) = WPxyz1(i, j, k) + WPxyz2(i, j, k) + WPxyz3(i, j, k)
                !  end do
            enddo
        enddo
    enddo
    !$OMP END PARALLEL DO

    return
end
