#include "MAR_pp.def"
subroutine CVAgen_MNH
    ! +------------------------------------------------------------------------+
    ! | MAR CONVECTION                                     Mon 25-01-2021  MAR |
    ! |   subroutine CVAgen links MAR to a CONVECTIVE ADJUSMENT procedure      |
    ! |                                                                        |
    ! +------------------------------------------------------------------------+
    ! |                                                                        |
    ! |   INPUT (via common block)                                             |
    ! |   ^^^^^         itexpe           : Experiment Iteration Counter        |
    ! |                 itConv           : Adjustment Calls     Counter        |
    ! |                 dt_loc2           : Mass Flux  Scheme:   Time Step      |
    ! |                                                                        |
    ! |                     dx           : grid  spacing                   (m) |
    ! |                     dy           : grid  spacing                   (m) |
    ! |                 tairDY(mx,my,mz) : air   temperature               (K) |
    ! |                   qiHY(mx,my,mz) : air   cloud crystals conc.  (kg/kg) |
    ! |                   qsHY(mx,my,mz) : air   snow  flakes   conc.  (kg/kg) |
    ! |                   qwHY(mx,my,mz) : air   cloud droplets conc.  (kg/kg) |
    ! |                   qrHY(mx,my,mz) : air   rain  drops    conc.  (kg/kg) |
    ! |                                                                        |
    ! |   INPUT / OUTPUT:   dx           : grid  spacing                   (m) |
    ! |   ^^^^^^^^^^^^^^^   dy           : grid  spacing                   (m) |
    ! |                 pktaDY(mx,my,mz) : air   temperature               (K) |
    ! |                   qvDY(mx,my,mz) : air   specific humidity     (kg/kg) |
    ! |                 rainHY(mx,my)    : rain  Precipitation             (m) |
    ! |                 rainCA(mx,my)    : rain  Precipitation             (m) |
    ! |                                                                        |
    ! |   REFER. : 1) MesoNH CONVECTIVE ADJUSMENT Routine                      |
    ! |   ^^^^^^^^ 2) cfr.  head of subroutine CONVECTION                      |
    ! |                                                                        |
    ! | # OPTIONS: #pb  Limited Scalar Operations ==>   NO vectorization       |
    ! | # ^^^^^^^^ #EW  Energy and Water ?Conservation                         |
    ! | #          #AN  Anabatic Wind Parameterization                         |
    ! | #          #GU  Gust Front    Parameterization                         |
    ! | #          #gu  Gust Front    Parameterization (NO vectorization)      |
    ! | #          #GW  Gust Front    Parameterization (OUTPUT)                |
    ! |                                                                        |
    ! |   MODIF. HGall?e: 18-11-2004: Adaptation to CVAmnh.f90.laurent         |
    ! |   ^^^^^^                      (Argument kensbl of CONVECTION removed)  |
    ! |                                                                        |
    ! +------------------------------------------------------------------------+
    
    use marctr
    use marphy
    use mardim
    use margrd
    use mar_dy
    use mar_te
    use mar_hy
    use mar_ca
    use mar_pb
    use mar_sl
    use mar_ra
    use marmagic
#ifdef EW
    use mar_ew
#endif
    
    implicit none
#ifdef AN
    real rANA, hANA(mx, my)
    common / CVAgen_MNH_ANA / rANA, hANA
#endif
#ifdef GW
    integer i_Gmax, k_Gmax, i_Gmin, k_Gmin
    real waGmax, TaGmin
#endif
#ifdef GU
    real waGust(mx, my, mzz)
    real TaGust(mx, my, mz), dtxLoc
    common / CVAgen_MNHgust / TaGust, dtxLoc
#endif
    
    logical Odeep, Oshal
    common / CVAgen_MNH_lt / Odeep, Oshal
    real pdtCVx, pdtCV, PTdcv, PTscv
    integer nntCV0, jjtCV0, iitCV0
    common / CVAgen_MNH_rt / pdtCVx, pdtCV, PTdcv, PTscv
    common / CVAgen_MNH_nt / nntCV0, jjtCV0, iitCV0
    
    integer KLON_0, KLEV_0
    parameter(KLON_0 = KLON, KLEV_0 = KLEV)
    
    ! +--Local  Variables
    ! +  ================
    
    integer i, j, k, m
    character * 3 vectcv
    integer klcvOK, dt_loc2
    integer iklon, klc
    
    logical Odeep0, Oshal0, Orset0, Odown0, OsetA0, OCvTC0
    integer kidia0, kfdia0, kbdia0, ktdia0, kIce_0, kensbl
    
    real pdtCV0, PTdcv0, PTscv0
    real Pdxdy0(KLON)
    real P_pa_0(KLON, KLEV)
    real P_za_0(KLON, KLEV)
    real P_Ta_0(KLON, KLEV)
    real P_Qa_0(KLON, KLEV)
    real P_Qw_0(KLON, KLEV)
    real P_Qi_0(KLON, KLEV)
    real P_Ua_0(KLON, KLEV)
    real P_Va_0(KLON, KLEV)
    real P_Wa_0(KLON, KLEV)
    real P_TKE(KLON, KLEV)
    real ratio_rfsf, ratio_temp, ratio_prec
    
    integer locCVA
    real OK_CVA, MAX_TT(mx, my), min_TT_off
    real wrk1(mx, my, mz), wrk1_mx
#ifdef AN
    real bANA, zANA, wANA(mx, my, mz), zlev
    real dANA, vANA, xANA
#endif

#ifdef EW
    ! +--Diagnostic Variables
    ! +  --------------------
    integer irmx, jrmx, iter_0
    real rr_max, temp_r, energ0, water0, waterb
#endif
    
    ! +--Mass Flux convective Scheme: Set Up DATA
    ! +  ========================================
    
    data kidia0/1/
    ! +...     kidia0  :  value of the first point in x
    
    data kbdia0/1/
    ! +...     kbdia0  :  vertical computations: lowest                 level
    
    data ktdia0/1/
    ! +...     ktdia0  :  vertical computations: over KLEV + 1 - ktdia0 levels
    
    data pdtCV0/600./
    !XF
    ! +...     pdtCV0  :  time interval between 2 CALLs of deep convection
    
    data Odeep0/.true./
    ! +...     Odeep0  :  Deep    Convection Switch
    
    data Oshal0/.true./
    ! +...     Oshal0  :  Shallow Convection Switch
    
    data Orset0/.true./
    ! +...     Orset0  :  refresh or not all tendencies at every call
    
    data Odown0/.true./
    ! +...     Odown0  :  take or not convective downdrafts into account
    
    data kIce_0/1/
    ! +...     kIce_0  :  flag for ice ( 1 = yes,
    ! +                                  0 = no ice )
    data OsetA0/.true./
    ! +...     OsetA0  :  logical to set convective adjustment time by user
    
    data PTdcv0/1200./
    ! +...     PTdcv0  :  user defined deep    adjustment time
    
    data PTscv0/1200./
    ! +...     PTscv0  :  user defined shallow adjustment time
    
    data kensbl/3/
    ! +...     kensbl  :  value for a "climate" run
    
    data OCvTC0/.false./
    ! +...     OCvTC0  :  flag to compute convective transport
    ! +                                   for  chemical tracer
    
    ! XF
    data min_TT_off/270.15/
    ! +        min_TT_off : temperature min for switching on the convect. adjust.

#ifdef AN
    ! +--Anabatic Breeze Parameterization
    ! +  --------------------------------
    ! xANA : Characteristic Mountain Width Scale
    data xANA/10.0e+3/
    ! vANA : Characteristic Mountain Breeze Wind Scale
    data vANA/4.0e+0/
#endif
    
    ! +--SET UP CONVECTION SWITCHES
    ! +  ==========================
    
    do i = 1, mx; do j = 1, my
        if(adj_CA(i, j) == 0 .or. itexpe == 0) then
            drr_CA(i, j) = 0.
            dss_CA(i, j) = 0.
            do k = 1, mz
                dpktCA(i, j, k) = 0.
                dqv_CA(i, j, k) = 0.
                dqw_CA(i, j, k) = 0.
                dqi_CA(i, j, k) = 0.
            enddo
        endif
    enddo;
    enddo
    
    if(iterun == 0) then
        !XF
        if(MFLX_d) then
            Odeep = MFLX_d
        else
            Odeep = Odeep0
            write(6, *) 'Deep    Convection Switch     set to ', Odeep
        endif
        if(MFLX_s) then
            Oshal = MFLX_s
        else
            Oshal = Oshal0
            write(6, *) 'Shallow Convection Switch     set to ', Oshal
        endif
        
        if(tMFLXd > 0.) then
            pdtCVx = tMFLXd
        else
            !XF
            pdtCVx = max(600., min(pdtCV0, 4. * dt))
#ifdef AC
            pdtCVx = 1800.
#endif
#ifdef GL
            pdtCVx = 1200.
#endif
            write(6, *) 'Interv. Convection call       set to ', pdtCVx
        endif
        
        if(aMFLXd > 0.) then
            PTdcv = aMFLXd
        else
            ! OsetA0 must be .true.
            PTdcv = max(600., min(PTdcv0, 4. * dt))
#ifdef GL
            PTdcv = 1200.
#endif
#ifdef AC
            PTdcv = 1800.
#endif
            write(6, *) 'Deep    Convection Time Scale set to ', PTdcv
        endif
        if(aMFLXs > 0.) then
            PTscv = aMFLXs
        else
            ! OsetA0 must be .true.
            PTscv = max(600., min(PTscv0, 4. * dt))
#ifdef GL
            ! PTscv  = 2 * PTdcv
            PTscv = 1200
#endif
#ifdef AC
            PTscv = 1800.
#endif
            write(6, *) 'Shallow Convection Time Scale set to ', PTscv
        endif
    
    endif
    
    ! +--Set UP Anabatic Breeze Parameterization
    ! +  =======================================
    
    if(itexpe == 0) then
#ifdef GU
        open(unit = 70, status = 'new', file = 'W_GUST.out')
        rewind 70
        dtxLoc = dt_loc2 / dx
#endif
#ifdef AN
        ! rANA      : Subgrid Mountain Breeze: Horizontal Divergence
        ! +                  (Factor 2 included  for 2 horizontal Directions)
        rANA = 2.0d+0 * vANA / xANA
        do j = 1, my
            do i = 1, mx
                dANA = sh(i, j) &
                        - 0.25 * (sh(im1(i), j) + sh(ip1(i), j) &
                                + sh(i, jm1(j)) + sh(i, jp1(j)))
                ! hANA: D("Subgrid Mountain" Height - "Resolved Mountain" Height)
                hANA(i, j) = abs(dANA) * max(zero, dx / xANA - unun)
                hANA(i, j) = sh(i, j) * 2.0d+0
            enddo
        enddo
#endif
#ifdef GU
        do k = 1, mz
            do j = 1, my
                do i = 1, mx
                    TaGust(i, j, k) = 0.
                enddo
            enddo
        enddo
#endif
        
        ! +--Set UP Verification
        ! +  ===================
        
        klcvOK = mx2 * my2
        klcvOK = 1
        if(klon /= klcvOK) then
            if(klon > 1) then
                vectcv = 'NON'
            else
                vectcv = '   '
            endif
            write(6, 6000) klon, klcvOK, vectcv
            6000        format(/, '++++++++ klon (mardim_mod.f90) =', i6, ' .NE.', i6, ' ++++++++++++++', &
                    /, '++++++++ NOT adapted to a ', a3, ' vectorized code ++++++++++++++', &
                    /, '++++++++ BAD SET UP of #pb or klon parameter  ++++++++++++++', &
                    /, '     ==> !?%@&* Emergency EXIT in CVAgen_MNH')
            stop
        endif

#ifdef EW
        ! +--Mass Flux convective Scheme: Set Up Energy/Water Verification
        ! +  =============================================================
        energ0 = 0.0
        water0 = 0.0
        iter_0 = 0
        write(6, 600)
        600     format(/, ' CVAgen_MNH: Energy/Water Verification Set UP')
#endif
    endif
    
    ! +--Mass Flux Scheme: Set Up Time Stepping
    ! +  ======================================
    
    dt_loc2 = dt ! cvagen_mnh is called every time step
    
    if(iterun == 0) then
        
        adj_CA = -1
        
        pdtCV = pdtCVx
#ifdef xx
        pdtCV = min(dt_loc2, pdtCVx)
#endif
        if(pdtCV < dt_loc2) then
            pdtCV = dt_loc2
            jjtCV0 = 1
        else
            jjtCV0 = pdtCV / dt_loc2
            ! +...      jjtCV0 :  Number of  Diffusion Steps for 1 Convective Step
            
            pdtCV = dt_loc2 * jjtCV0
            ! +...      pdtCV  :  Calibrated Convection                  Time Step
        
        endif
        iitCV0 = 0
    endif
    
    ! +--Update Convective Mass Flux
    ! +  ===========================
    
    if(mod(iitCV0, jjtCV0) == 0) then

#ifdef AN
        ! +--Contribution from Subgrid Mountain Breeze
        ! +  -----------------------------------------
        do k = 1, mz
            do j = 1, my
                do i = 1, mx
                    zlev = gplvDY(i, j, k) * grvinv
                    bANA = min(zlev, zi__TE(i, j))
                    zANA = hANA(i, j) + 2.0 * bANA
                    if(zlev <= zANA .and. &
                            TairSL(i, j) > tairDY(i, j, mz)) then
                        ! Half Integrated Horizontal Divergence
                        wANA(i, j, k) = rANA * 0.5 * bANA
                    else
                        wANA(i, j, k) = 0.0
                    endif
                enddo
            enddo
        enddo
#endif

#ifdef GW
        ! +--Contribution from the Cold Air Pool
        ! +  -----------------------------------
        waGmax = 0.
        TaGmin = 0.
#endif
#ifdef GU
        do k = mz, 2, -1
            do j = jp11, my1
                do i = ip11, mx1
                    waGust(i, j, k) = ((4.0 * TaGust(i, j, k) &
                            - TaGust(ip1(i), j, k) - TaGust(i, jp1(j), k) &
                            - TaGust(im1(i), j, k) - TaGust(i, jm1(j), k)) &
                            * (0.50e6 / dx) &
                            * (gpmiDY(i, j, k) - gpmiDY(i, j, k + 1)) &
                            + waGust(i, j, k + 1) * gplvDY(i, j, k + 1)) &
                            / gplvDY(i, j, k) &
                            * max(zero, sign(unun, zi__TE(i, j) &
                                    - gplvDY(i, j, k) * grvinv))
                    waGust(i, j, k) = max(zero, waGust(i, j, k))
#endif
#ifdef GW
                    if(TaGmin < TaGust(i, j, k)) then
                        TaGmin = TaGust(i, j, k)
                        i_Gmin = i
                        k_Gmin = k
                    endif
                    if(waGmax < waGust(i, j, k)) then
                        waGmax = waGust(i, j, k)
                        i_Gmax = i
                        k_Gmax = k
                    endif
#endif
#ifdef GU
                enddo
            enddo
        enddo
#endif
#ifdef GW
        i_Gmax = max(2, i_Gmax)
        i_Gmax = min(mx1, i_Gmax)
        k_Gmax = max(1, k_Gmax)
        k_Gmax = min(mz, k_Gmax)
        write(70, 700) itexpe, &
                i_Gmax, k_Gmax, (waGust(i, 1, k_Gmax), i = i_Gmax - 1, i_Gmax + 1), &
                i_Gmin, k_Gmin, (TaGust(i, 1, k_Gmax), i = i_Gmax - 1, i_Gmax + 1), &
                grvinv * gplvDY(i_Gmax, 1, k_Gmax), zi__TE(i_Gmax, 1)
        700     format(2i6, i4, 3f9.3, i6, i4, 3f9.3, 2f12.0)
#endif
        
        ! +--Mass Flux convective Scheme: Set Up Vertical Profiles
        ! +  -----------------------------------------------------
        
        kfdia0 = klon
        ! +...      kfdia0  :   value of the last  point in x
        
        iklon = 0
        
        !XF
        max_TT = -273.15
        
        !$OMP PARALLEL do &
        !$OMP firstprivate(i,k,klc,iklon,OK_CVA, &
        !$OMP              kidia0, kfdia0, kbdia0, ktdia0, &
        !$OMP              pdtCV , Odeep , Oshal , Orset0, Odown0, kIce_0, &
        !$OMP              OsetA0, PTdcv , PTscv , &
        !$OMP              kensbl,ratio_rfsf   ,ratio_temp,ratio_prec, &
        !$OMP      P_pa_0, P_za_0, Pdxdy0, &
        !$OMP      P_Ta_0, P_Qa_0, P_Qw_0, P_Qi_0, P_Ua_0, P_Va_0, P_Wa_0, &
        !$OMP      Kstep1, PdTa_1, PdQa_1, PdQw_1, PdQi_1, &
        !$OMP                      Pdrr_1, Pdss_1, &
        !$OMP      PuMF_1, PdMF_1, Pfrr_1, Pfss_1, Pcape1, K_CbT1, K_CbB1, &
        !$OMP      OCvTC0, P_CH_0, PdCH_1,P_TKE) &
        !$OMP schedule(dynamic)
        
        do j = 6, my - 5
            do i = 6, mx - 5
                
                iklon = 1 + iklon
                iklon = 1
                
                Pdxdy0(iklon) = dx3(i, j) * dy3(i, j)
                ! +...       Pdxdy0           : grid area                            [m2]
                
                do klc = 1, klev
                    k = mzz - klc
                    P_pa_0(iklon, klc) = (pstDY(i, j) * sigma(k) + ptopDY) * 1.e3
                    ! +...       P_pa_0            : pressure     in layer               [Pa]
                    
                    P_za_0(iklon, klc) = gplvDY(i, j, k) * grvinv
                    ! +...       P_za_0            : height of model layer                [m]
                    
                    P_Ta_0(iklon, klc) = tairDY(i, j, k)
                    ! +...       P_Ta_0            : grid scale T           at time t     [K]
                    
                    !XF
                    max_TT(i, j) = max(max_TT(i, j), tairDY(i, j, k))
                    !XF! P_Qa_0 : grid scale water vapor at time t [kg/kg]
                    P_Qa_0(iklon, klc) = qvDY(i, j, k)
                    ! P_Qw_0 : grid scale Cloud drops at time t [kg/kg]
                    P_Qw_0(iklon, klc) = qwHY(i, j, k) / (1.0 - qwHY(i, j, k))
                    !XF bug ?
                    ! P_Qi_0 : grid scale Cloud ice   at time t [kg/kg]
                    P_Qi_0(iklon, klc) = qiHY(i, j, k) / (1.0 - qiHY(i, j, k))
                    !XF bug ?
                    ! P_Ua_0 : grid scale hor. wind u at time t   [m/s]
                    P_Ua_0(iklon, klc) = uairDY(i, j, k)
                    ! P_Va_0 : grid scale hor. wind v at time t   [m/s]
                    P_Va_0(iklon, klc) = vairDY(i, j, k)
                    ! P_Wa_0 : grid scale vertic.wind at time t   [m/s]
                    P_Wa_0(iklon, klc) = wairDY(i, j, k) * 0.01 &
                            + sqrt(2. * ect_TE(i, j, k) / 3.)
#ifdef AN
                    P_Wa_0(iklon, klc) = P_Wa_0(iklon, klc) + wANA(i, j, k)
#endif
#ifdef GU
                    P_Wa_0(iklon, klc) = P_Wa_0(iklon, klc) + waGust(i, j, k)
#endif
                
                enddo
                adj_CA(i, j) = 0.
                
                if(radsol(i, j) <= 10 .and. tairDY(i, j, mz) <= 283.15 .and. &
                        tairDY(i, j, mz) < (tairDY(i, j, mz - 1) + tairDY(i, j, mz - 2)) / 2.) &
                        MAX_TT(i, j) = -273.15 ! night + inversion + tt < 10 deg
                
                ! +--Mass Flux convective Scheme: iteration, in case of no vectorization
                ! +  -------------------------------------------------------------------
                
                if(MAX_TT(i, j) >= min_tt_off) then
                    ! +       ***************
                    call CONVECTION(&
                            KLON_0, KLEV_0, kidia0, kfdia0, kbdia0, ktdia0, &
                            pdtCV, Odeep, Oshal, Orset0, Odown0, kIce_0, &
                            OsetA0, PTdcv, PTscv, &
                            kensbl, &
                            P_pa_0, P_za_0, Pdxdy0, &
                            P_Ta_0, P_Qa_0, P_Qw_0, P_Qi_0, P_Ua_0, P_Va_0, P_Wa_0, &
                            Kstep1, PdTa_1, PdQa_1, PdQw_1, PdQi_1, &
                            Pdrr_1, Pdss_1, &
                            PuMF_1, PdMF_1, Pfrr_1, Pfss_1, Pcape1, K_CbT1, K_CbB1, &
                            OCvTC0, KTCCH0, P_CH_0, PdCH_1, P_TKE)
                    ! +       ***************
                    
                    ! +--Mass Flux convective Scheme: products,  in case of no vectorization
                    ! +  -------------------------------------------------------------------
                    
                    capeCA(i, j) = Pcape1(iklon)
                    adj_CA(i, j) = Kstep1(iklon)
                    drr_CA(i, j) = Pdrr_1(iklon) * dt_loc2
                    dss_CA(i, j) = Pdss_1(iklon) * dt_loc2
                    
                    drr_CA(i, j) = max(0., drr_CA(i, j) - dss_CA(i, j))
                    !XF Pdrr_1 = pecip total
                    
                    ratio_temp = (tairDY(i, j, mz - 1) + tairDY(i, j, mz - 2) &
                            + tairDY(i, j, mz - 3) + tairDY(i, j, mz - 4)) / 4.
                    
                    ratio_prec = drr_CA(i, j)
                    
                    ratio_rfsf = max(0., min(1., &
                            (ratio_temp - rain_snow_limit) / 2.))
                    
                    drr_CA(i, j) = ratio_prec * ratio_rfsf
                    dss_CA(i, j) = dss_CA(i, j) + ratio_prec * (1. - ratio_rfsf)
                    
                    if(isnan(capeCA(i, j))) adj_CA(i, j) = -1
                    if(isnan(drr_CA(i, j))) adj_CA(i, j) = -1
                    if(isnan(dss_CA(i, j))) adj_CA(i, j) = -1
                    if(drr_CA(i, j) > 0.1) adj_CA(i, j) = -1
                    if(drr_CA(i, j) < 0) adj_CA(i, j) = -1
                    if(dss_CA(i, j) > 0.1) adj_CA(i, j) = -1
                    if(dss_CA(i, j) < 0) adj_CA(i, j) = -1
                    if(abs(dpktCA(i, j, k)) > 2) adj_CA(i, j) = -1
                    if(abs(dqv_CA(i, j, k)) > 0.002) adj_CA(i, j) = -1
                    
                    do klc = 1, klev
                        k = mzz - klc
                        
                        dpktCA(i, j, k) = PdTa_1(iklon, klc) * dt_loc2 / pkDY(i, j, k)
                        dqv_CA(i, j, k) = PdQa_1(iklon, klc) * dt_loc2
                        dqw_CA(i, j, k) = PdQw_1(iklon, klc) * dt_loc2
                        dqi_CA(i, j, k) = PdQi_1(iklon, klc) * dt_loc2
#ifdef gu
                        TaGust(i, j, k) = TaGust(i, j, k) * exp(-dtxLoc * ssvSL(i, j, k)) &
                                + PdTa_1(iklon, klc) * dt_loc2
                        TaGust(i, j, k) = min(TaGust(i, j, k), zero)
#endif
                        if(isnan(dpktCA(i, j, k))) adj_CA(i, j) = -1
                        if(isnan(dqv_CA(i, j, k))) adj_CA(i, j) = -1
                        if(isnan(dqw_CA(i, j, k))) adj_CA(i, j) = -1
                        if(isnan(dqi_CA(i, j, k))) adj_CA(i, j) = -1
                    enddo
                endif
                
                if(adj_CA(i, j) <= 0 .or. MAX_TT(i, j) < min_tt_off) then
                    capeCA(i, j) = 0.
                    drr_CA(i, j) = 0.
                    dss_CA(i, j) = 0.
                    do klc = 1, klev
                        k = mzz - klc
                        dpktCA(i, j, k) = 0.
                        dqv_CA(i, j, k) = 0.
                        dqw_CA(i, j, k) = 0.
                        dqi_CA(i, j, k) = 0.
                    enddo
                endif
            
            enddo
        enddo
        !$OMP END PARALLEL DO
        
        ! +--Mass Flux convective Scheme: iteration, in case of    vectorization
        ! +  -------------------------------------------------------------------
        
        if(klon > 1) then
            
            ! +       ***************
            call CONVECTION(&
                    KLON_0, KLEV_0, kidia0, kfdia0, kbdia0, ktdia0, &
                    pdtCV, Odeep, Oshal, Orset0, Odown0, kIce_0, &
                    OsetA0, PTdcv, PTscv, &
                    kensbl, &
                    P_pa_0, P_za_0, Pdxdy0, &
                    P_Ta_0, P_Qa_0, P_Qw_0, P_Qi_0, P_Ua_0, P_Va_0, P_Wa_0, &
                    Kstep1, PdTa_1, PdQa_1, PdQw_1, PdQi_1, &
                    Pdrr_1, Pdss_1, &
                    PuMF_1, PdMF_1, Pfrr_1, Pfss_1, Pcape1, K_CbT1, K_CbB1, &
                    OCvTC0, KTCCH0, P_CH_0, PdCH_1, P_TKE)
            ! +       ***************
            
            ! +--Mass Flux convective Scheme: products,  in case of    vectorization
            ! +  -------------------------------------------------------------------
            
            iklon = 0
            do j = jp11, my1
                do i = ip11, mx1
                    iklon = 1 + iklon
                    
                    capeCA(i, j) = Pcape1(iklon)
                    adj_CA(i, j) = Kstep1(iklon)
                    drr_CA(i, j) = Pdrr_1(iklon) * dt_loc2
                    dss_CA(i, j) = Pdss_1(iklon) * dt_loc2
                    
                    do klc = 1, klev
                        k = mzz - klc
                        
                        dpktCA(i, j, k) = PdTa_1(iklon, klc) * dt_loc2 / pkDY(i, j, k)
                        dqv_CA(i, j, k) = PdQa_1(iklon, klc) * dt_loc2
                        dqw_CA(i, j, k) = PdQw_1(iklon, klc) * dt_loc2
                        dqi_CA(i, j, k) = PdQi_1(iklon, klc) * dt_loc2
#ifdef GU
                        TaGust(i, j, k) = TaGust(i, j, k) * exp(-dtxLoc * ssvSL(i, j, k)) &
                                + PdTa_1(iklon, klc) * dt_loc2
                        TaGust(i, j, k) = min(TaGust(i, j, k), zero)
#endif
                    enddo
                enddo
            enddo
        
        endif
#ifdef EW
        ! +--Vertical Integrated Energy and Water Content
        ! +  ============================================
        
        do j = jp11, my1
            do i = ip11, mx1
                enr0EW(i, j) = 0.0
                wat0EW(i, j) = 0.0
                do k = 1, mz
                    temp_r = pktaDY(i, j, k) * pkDY(i, j, k)
                    enr0EW(i, j) = enr0EW(i, j) &
                            + (temp_r &
                                    - (qwHY(i, j, k) + qrHY(i, j, k)) * r_LvCp &
                                    - (qiHY(i, j, k) + qsHY(i, j, k)) * r_LsCp) * dsigm1(k)
                    wat0EW(i, j) = wat0EW(i, j) &
                            + (qvDY(i, j, k) &
                                    + qwHY(i, j, k) + qrHY(i, j, k) &
                                    + qiHY(i, j, k) + qsHY(i, j, k)) * dsigm1(k)
                enddo
                enr0EW(i, j) = enr0EW(i, j) * pstDYn(i, j) * grvinv
                ! wat0EW [m] contains implicit factor 1.d3 [kPa-->Pa] /ro_Wat
                wat0EW(i, j) = wat0EW(i, j) * pstDYn(i, j) * grvinv
                energ0 = energ0 - enr0EW(i, j)
                water0 = water0 - wat0EW(i, j)
            enddo
        enddo
#endif
        
        ! +     ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        
        ! +--filtering
        ! +  =========
        
        do j = jp11, my1
            do i = ip11, mx1
                wrk1(i, j, 1) = adj_CA(i, j)
                wrk1(i, j, 2) = drr_CA(i, j)
                wrk1(i, j, 3) = dss_CA(i, j)
            enddo
        enddo
        
        call cva_filtering(wrk1, 3)
        do j = jp11, my1
            do i = ip11, mx1
                if(wrk1(i, j, 1) <= 0) then
                    drr_CA(i, j) = 0.
                    dss_CA(i, j) = 0.
                    adj_CA(i, j) = 0.
                else
                    adj_CA(i, j) = max(1, nint(wrk1(i, j, 1)))
                    drr_CA(i, j) = wrk1(i, j, 2)
                    dss_CA(i, j) = wrk1(i, j, 3)
                endif
            enddo
        enddo
        
        call cva_filtering(dpktCA, mz)
        call cva_filtering(dqv_CA, mz)
        call cva_filtering(dqw_CA, mz)
        call cva_filtering(dqi_CA, mz)
    
    endif
    
    ! +--Mass Flux convective Scheme
    ! +  ===========================
    
    do j = 6, my - 5
        do i = 6, mx - 5
            
            ! +     ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
            
            locCVA = min(adj_CA(i, j), 1)
            OK_CVA = max(locCVA, 0)
            !XF
            if(adj_CA(i, j) > 0 &
                    .and. max(drr_CA(i, j), dss_CA(i, j)) < 0.25 * dt_loc2 / 3600 &
                    .and. min(drr_CA(i, j), dss_CA(i, j)) >= 0) then
                !               !MIN= 0 - MAX= 250mm/h
                OK_CVA = 1.0
                adj_CA(i, j) = adj_CA(i, j) - 1
                ! +...      ^^^^ Number of remaining time step before the end of convection
                
                adj_CA(i, j) = max(adj_CA(i, j), 0)
                
                ! +----Temporal tendencies on pktaDY, qvDY and rainHY
                ! +    ----------------------------------------------
                DO k = 1, mz
                    pktaDY(i, j, k) = pktaDY(i, j, k) + dpktCA(i, j, k) * OK_CVA
                    qvDY(i, j, k) = max(qvDY(i, j, k) + dqv_CA(i, j, k) * OK_CVA &
                            , epsq)
                    !if(k>=mzhyd) then
                    qwHY(i, j, k) = max(qwHY(i, j, k) + dqw_CA(i, j, k) * OK_CVA, eps9)
                    qiHY(i, j, k) = max(qiHY(i, j, k) + dqi_CA(i, j, k) * OK_CVA, eps9)
                    !end if
                enddo
                
                rainHY(i, j) = rainHY(i, j) + drr_CA(i, j) * OK_CVA
                rainCA(i, j) = rainCA(i, j) + drr_CA(i, j) * OK_CVA
                
                snowHY(i, j) = snowHY(i, j) + dss_CA(i, j) * OK_CVA
                snowCA(i, j) = snowCA(i, j) + dss_CA(i, j) * OK_CVA
                snohSL(i, j) = snohSL(i, j) + dss_CA(i, j) * OK_CVA
            
            else          !  { adj_CA(i,j).gt. 0 }
                
                do k = 1, mz
                    dpktCA(i, j, k) = 0.
                    dqv_CA(i, j, k) = 0.
                    dqw_CA(i, j, k) = 0.
                    dqi_CA(i, j, k) = 0.
                enddo
            
            endif
            
            ! +     ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
        
        enddo
    enddo

#ifdef EW
    ! +--Vertical Integrated Energy and Water Content
    ! +  ============================================
    do j = jp11, my1
        do i = ip11, mx1
            enr1EW(i, j) = 0.0
            wat1EW(i, j) = 0.0
            watfEW(i, j) = -drr_CA(i, j)
            do k = 1, mz
                temp_r = pktaDY(i, j, k) * pkDY(i, j, k)
                enr1EW(i, j) = enr1EW(i, j) &
                        + (temp_r &
                                - (qwHY(i, j, k) + qrHY(i, j, k)) * r_LvCp &
                                - (qiHY(i, j, k) + qsHY(i, j, k)) * r_LsCp) * dsigm1(k)
                wat1EW(i, j) = wat1EW(i, j) &
                        + (qvDY(i, j, k) &
                                + qwHY(i, j, k) + qrHY(i, j, k) &
                                + qiHY(i, j, k) + qsHY(i, j, k)) * dsigm1(k)
            enddo
            enr1EW(i, j) = enr1EW(i, j) * pstDYn(i, j) * grvinv &
                    - drr_CA(i, j) * r_LvCp
            ! wat1EW [m] contains implicit factor 1.d3 [kPa-->Pa] /ro_Wat
            wat1EW(i, j) = wat1EW(i, j) * pstDYn(i, j) * grvinv
            energ0 = energ0 + enr1EW(i, j)
            water0 = water0 + wat1EW(i, j)
            iter_0 = iter_0 + 1
        enddo
    enddo
#endif

#ifdef EW
    ! +--Vertical Integrated Energy and Water Content: OUTPUT
    ! +  ====================================================
    irmx = imez
    jrmx = jmez
    rr_max = 0.0
    do j = jp11, my1
        do i = ip11, mx1
            if(drr_CA(i, j) > rr_max) then
                rr_max = drr_CA(i, j)
                irmx = i
                jrmx = j
            endif
        enddo
    enddo
    waterb = wat1EW(irmx, jrmx) - wat0EW(irmx, jrmx) - watfEW(irmx, jrmx)
    write(6, 606) itexpe, enr0EW(irmx, jrmx), 1.d3 * wat0EW(irmx, jrmx), &
            irmx, jrmx, enr1EW(irmx, jrmx), 1.d3 * wat1EW(irmx, jrmx), &
            1.d3 * watfEW(irmx, jrmx), &
            1.d3 * waterb, &
            energ0 / iter_0, water0 / iter_0
    606 format(i9, '  Before CVAj:  E0 =', f12.6, '  W0 = ', f9.6, &
            /, i5, i4, '  After  CVAj:  E1 =', f12.6, '  W1 = ', f9.6, &
            '  W Flux =', f9.6, &
            '  Div(W) =', e9.3, &
            /, 9x, '         Mean   dE =', f12.9, '  dW = ', e9.3)
#endif
    
    iitCV0 = iitCV0 + 1
    
    return
endsubroutine CVAgen_MNH
