subroutine cva_filtering(wrk1, level1)

    ! +------------------------------------------------------------------------+
    ! | MAR CONVECTION                                         11-01-2016  MAR |
    ! |                                                                        |
    ! |   subroutine CVA_filtering                                             |
    ! |                                                                        |
    ! +------------------------------------------------------------------------+

    use marctr
    use marphy
    use mardim
    use margrd
    use mar_dy

    implicit none

    ! weight : weight for the central pixel
    real, parameter :: weight = 8

    integer i, j, k, m
    integer l, kk, level1, level2
    real wrk1(mx, my, mz), uu, vv
    real wrk2(mx, my), wrk3(mx, my), w

    level2 = min(max(1, level1), mz)

!$OMP PARALLEL DO private(i,j,k,kk,l,w,uu,vv,wrk3,wrk2)
    do kk = 1, level2
        do j = 6, my - 5
            do i = 6, mx - 5

                wrk3(i, j) = 0
                wrk2(i, j) = 0

                do k = -1, 1
                    do l = -1, 1
                        w = 1
                        if(l == 0) w = 2
                        if(k == 0) w = 2
                        if(l == 0 .and. k == 0) w = weight

                        if(i + k > mx - 5 .or. i + k < 6) w = 0
                        if(j + l > my - 5 .or. j + l < 6) w = 0

                        wrk3(i, j) = wrk3(i, j) + w
                        wrk2(i, j) = wrk2(i, j) + wrk1(i + k, j + l, kk) * w
                    enddo
                enddo

                wrk2(i, j) = wrk2(i, j) / wrk3(i, j)
            enddo
        enddo

        do j = 6, my - 5
            do i = 6, mx - 5
                wrk1(i, j, kk) = wrk2(i, j)
            enddo
        enddo
    enddo
!$OMP END PARALLEL DO

endsubroutine cva_filtering
