
C +---Buffered data for bicubic interpolation (10/05/2022 JFG)
C +   --------------------------------------------------------
C +   Additional variables used to buffer sampling data in order to 
C +   speed up bicubic horizontal interpolation operations in NESTOR. 
C +   The idea is to keep track of the 4x4 squares that will be used 
C +   to compute the splines for each pixel during the interpolation, 
C +   as the real costly operation for this mode of horizontal 
C +   interpolation is to find, for each NST pixel, the square in the 
C +   LSC domain that is the closest. For the sake of simplicity, only 
C +   the indexes of the top-left corner pixel of each square is kept.
C +   Note also the bicNb variable, which is set to either 1 or 16, 
C +   the former being an extreme situation (where the LSC grid is 
C +   unusually small), much like bilNb in intBil.inc.

      INTEGER bicNb ! One or 16 (4x4) square
      INTEGER bicSqr(mx,my,2) ! Stores indexes of top-left corner
      
      COMMON/intBic_i/bicNb,bicSqr

