C   +-------------------------------------------------------------------+
C   |  Subroutine bufLim                                 23-07-2022  XF |
C   +-------------------------------------------------------------------+

      SUBROUTINE bufLim (cy, difLat, minLat, dimLat)
      
      IMPLICIT NONE
      
      INCLUDE 'NSTdim.inc' ! Gets mx, my
      INCLUDE 'NSTvar.inc' ! Gets NST__y
      
      real, parameter :: reso=0.00833333
      
      ! cy and  difLat differ depending on the calling routine
      integer :: cy
      real :: difLat
      
      integer :: i,j, jns, idTop, idBot ! id = index, bot = bottom
      integer :: minLat, maxLat, dimLat
      real :: degY
      
      ! J.-F. Grailet: this code considers MAR pixels cannot be larger 
      ! than 1° in latitude in order to buffer enough pixels top and 
      ! bottom of the selected band.
      
      degY = (cy / 360) / 2 ! 0.5 degree
      
      minLat = cy
      maxLat = 0

      do j=1,my
      do i=1,mx
       if(abs(NST__y(i,j))>80) degY = (cy / 360) !1 deg
      enddo
      enddo

      DO j=1,my
      DO i=1,mx
       jns = nint((NST__y(i,j) + difLat) / reso)
       idTop = jns - nint(degY)
       idBot = jns + nint(degY)
       if (idTop < minLat) minLat = idTop
       if (idBot > maxLat) maxLat = idBot
      ENDDO
      ENDDO      
      
      ! Cuts latitude to 1 or cy if minLat/maxLat are too low/high
      if (minLat < 1) minLat = 1 ! Northernmost point of the grid
      if (maxLat > cy) maxLat = cy ! Southernmost point of the grid
      
      dimLat = maxLat - minLat
      
      RETURN
      
      END SUBROUTINE
