C   +-------------------------------------------------------------------+
C   |  Subroutine NSTvgd                                 13-04-2022 JFG |
C   +-------------------------------------------------------------------+
C   |                                                                   |
C   | Creation of the (nested) vertical grid of a given model.          |
C   |                                                                   |
C   | Input : - NSTmod : selected NST (nested) model                    |
C   | ^^^^^^^ - nz     : number of vertical levels (N.B.: nz rather     |
C   |                    than nk because nk already used in NSTdim.inc) |
C   |         - k      : if specified, the level at which pressure and  |
C   |                    hybrid coordinate has to be computed           |
C   |         - VGD_sp(mx,my) : surface pressure                        |
C   |                                                                   |
C   | Output: Vertical grid of the LSC model :                          |
C   | ^^^^^^^ - VGD__p(mx,my,nz+1) : pressure at each level  [kPa]      |
C   |         - VGD_hp(mx,my,nz+1) : local hybrid coord. for vertical   |
C   |                                interpolation                      |
C   |         - VGDgdz(nz  ) : model coordinates (sigma)                |
C   |                                                                   |
C   | J.-F. Grailet remarks:                                            |
C   | ^^^^^^^^^^^^^^^^^^^^^^                                            |
C   | 1) Contrary to LSCvgd, this routine does not require the complete |
C   |    dimensions of the input grids as parameters. This is because   |
C   |    NSTvgd is exclusively used in practice with the dimensions of  |
C   |    the nested grid (LSCvgd can be used with both).                |
C   | 2) There is also no fID parameter either, because subroutines     |
C   |    read mandatory files (e.g., MARgrd.ctr) or hard-codes the      |
C   |    pressure levels (see GRAvgd.f).                                |
C   |                                                                   |
C   +-------------------------------------------------------------------+

      SUBROUTINE NSTvgd (NSTmod,nz,k,VGD_sp,VGD__p,VGD_hp,VGDgdz)

      IMPLICIT NONE

      INCLUDE 'NSTdim.inc' ! Provides mx, my

C +---Local variables
C +   ===============

      INTEGER nz,k
 
      REAL VGD_sp(mx,my),VGD__p(mx,my,nz+1),VGD_hp(mx,my,nz+1),
     .     VGDgdz(nz)

      CHARACTER*3 NSTmod
 
C +---Creation of the vertical grid depending on the specified model
C +   ==============================================================

C +---Modele Atmospherique Regional (MAR)
C +   -----------------------------------

      IF (NSTmod.eq.'MAR'.or.NSTmod.eq.'M2D')

     . CALL MRNvgd (nz,k,VGD_sp,VGD__p,VGD_hp,VGDgdz)

C +---GRADS output analysis
C +   ---------------------

      ! J.-F. G. remark: also no VGDgdz as argument in original code
      IF (NSTmod.eq.'GRA') 

     . CALL GRAvgd (nz,k,VGD_sp,VGD__p,VGD_hp)

C +---Output for SVAT coupling
C +   ------------------------

      IF (NSTmod.eq.'CPL') 

     . CALL CPLvgd (nz,k,VGD_sp,VGD__p,VGD_hp,VGDgdz)

      RETURN
      END
