C +************************************************************************+
C |                                                                        |
C |                                                                        |
C |               ************************************                     |
C |               *                                  *                     |
C |               *    N    E    S    T    O    R    *                     |
C |               *                                  *                     |
C |               ************************************                     |
C |                                                                        |
C |                                                                        |
C |     NESTing Organization for the preparation of                        |
C |             meteorological and surface fields in Regional models       |
C |                                                                        |
C |                 \__ _                    ____ /                        |
C |               \_/     ****              /    \                         |
C |               / \    ******            /    / \                        |
C |              /   \  ******            |    /   |                       |
C |                    ....                \  /   / UCL-IAG                |
C |                   .....                 \/___/ LGGE                    |
C |                  .....                  / LTHE                         |
C |                                                                        |
C |                                                                        |
C |        Institut d'Astronomie et de Geophysique Georges Lemaitre        |
C |                                                                        |
C |                  Universite catholique de Louvain                      |
C |                       Chemin du Cyclotron, 2                           |
C |                   1348 Louvain-la-Neuve - BELGIUM                      |
C |                                                                        |
C |                  - - - - - - - - - - - - - - - - -                     |
C |                                                                        |
C |                  L. G. G. E.   -    G R E N O B L E                    |
C |                                                                        |
C |    Laboratoire de Glaciologie et de Geophysique de l'Environnement     |
C |                       Rue Moliere, 54 - BP 96                          |
C |                    38402 St-Martin d'Heres CEDEX                       |
C |                                                                        |
C |                                                                        |
C |                  - - - - - - - - - - - - - - - - -                     |
C |                                                                        |
C |                  L. T. H. E.   -    G R E N O B L E                    |
C |                                                                        |
C |   Laboratoire d'Etude des Transferts en Hydrologie et Environnement    |
C |                   Domaine Universitaire - BP 53                        |
C |                    Rue de la Piscine 1023-1025                         |
C |                  38041 Grenoble Cedex 9 - FRANCE                       |
C |                                                                        |
C +************************************************************************+
C |                                                                        |
C |  NESTOR 4.1.5                              Date : 08 Jan   2025        |
C |  ------------                              ------                      |
C |                                                                        |
C |  Development :                                                         |
C |                                                                        |
C |      Olivier Brasseur  (brasseur@oma.be):                              |
C |         General structure, development (several components).           |
C |                                                                        |
C |      Hubert Gallee     (gallee@lgge.obs.ujf-grenoble.fr):              |
C |         General structure, MAR team manager.                           |
C |                                                                        |
C |      Philippe Marbaix  (marbaix@astr.ucl.ac.be):                       |
C |         Development (1st version, atmospheric data interpolation)      |
C |                                                                        |
C |      Xavier Fettweis   (xavier.fettweis@uliege.be)                     |
C |         Maintainer: version NESTOR > 4.0.0                             |
C |                                                                        |
C |      J.-F; Grailet     (Jean-Francois.Grailet@uliege.be)               |
C |         2022 optimization (version 4.x.y TODO)                         |
C |                                                                        |
C +************************************************************************+

      PROGRAM NESTOR

C +************************************************************************+

      IMPLICIT NONE

C +---LSC and NST domain dimensions
C +   -----------------------------

      INCLUDE 'NSTdim.inc'

C +---LSC,INT,NST variables
C +   ---------------------

      INCLUDE 'CTRvar.inc'
      INCLUDE 'LSCvar.inc'
      INCLUDE 'INTvar.inc'
      INCLUDE 'NSTvar.inc'
      INCLUDE 'LSCmod.inc'
      INCLUDE 'DESvar.inc'
      INCLUDE 'NESTOR.inc'      
            
C +---Soil and surface data files locations
C +   -------------------------------------
      INCLUDE 'LOCfil.inc'

C +---Local variables
C +   ---------------

      INTEGER  VARSIZE
      EXTERNAL VARSIZE

      LOGICAL  Vtrue
      
C +---Additions by J.-F. Grailet (warnings about unusable parameters)
C +   ---------------------------------------------------------------

      INTEGER selMod !, rainDg, metWGE
      LOGICAL useSnd, SSTrey

C +---Data
C +   ----

      DATA Vtrue   /  .true.  /

C +---Soil and surface data files locations
C +   -------------------------------------
C +   (code to actually set the paths)
      INCLUDE 'LOCset.inc'

C ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

C +---START MESSAGE
C +   ============= 

      write(6,*)
      write(6,*)
      write(6,*) '    ***********************************************'
      write(6,*) '    *                                             *'
      write(6,*) '    *         N    E    S    T    O    R          *'
      write(6,*) '    *                                             *'
      write(6,*) '    *   NESTing Organization for the preparation  *'
      write(6,*) '    *   of meteorological and surface fields in   *'
      write(6,*) '    *             3-D Regional models.            *'
      write(6,*) '    *                                             *'
C +---J.-F. Grailet (02/05/2022): as rain disagregation and wind gust 
C +   estimate moves have been removed (temporarily ?), the next four 
C +   lines have been commented for accuracy.
C      write(6,*) '    *          Rain disagregation models          *'
C      write(6,*) '    *                                             *'
C      write(6,*) '    *         Wind gust estimate methods          *'
C      write(6,*) '    *                                             *'
      write(6,*) '    ***********************************************'
      write(6,*)
      write(6,*) '              ---   Version  4.1.8   ---           '
      write(6,*) '              ---     20/06/2004     ---           '
      write(6,*)
      write(6,*)

C ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

C +   Reading of control file
C +   =======================

      OPEN (unit=20,status='old',file='NSTing.ctr')
      
      read (20,*) !- - - - - - - - - - - - - - - - - -
      read (20,*) !- - - - - - - - - - - - - - - - - -
      read (20,*) !- - - - - - - - - - - - - - - - - -
      read (20,*) !- - - - - - - - - - - - - - - - - -
      read (20,*) !- - - - - - - - - - - - - - - - - -
      read (20,*) !- - - - - - - - - - - - - - - - - -
      read (20,'(i4)')    selMod
      read (20,*) !- - - - - - - - - - - - - - - - - -
      read (20,*) !- - - - - - - - - - - - - - - - - -
      read (20,*) !- - - - - - - - - - - - - - - - - -
      read (20,'(A3)')    LABLio
      read (20,*) !- - - - - - - - - - - - - - - - - -
      read (20,'(A60)')   NSTdir
      read (20,*) !- - - - - - - - - - - - - - - - - -
      read (20,'(A3)')    LSCmod
      read (20,*) !- - - - - - - - - - - - - - - - - -
      read (20,'(A3)')    NSTmod
      read (20,*) !- - - - - - - - - - - - - - - - - -
      read (20,'(A3)')    region
      read (20,*) !- - - - - - - - - - - - - - - - - -
      read (20,'(i4,3(x,i2))') RUNiyr,RUNmma,RUNjda,RUNjhu
      read (20,'(i10,x,i2)')                 DURjda,DURjhu
      read (20,'(i13)')                             FORjhu
      read (20,*) !- - - - - - - - - - - - - - - - - -
      read (20,*) !- - - - - - - - - - - - - - - - - -
      read (20,'(l4)')    LoutDA
      read (20,'(l4)')    ASCfor 
      read (20,'(l4)')    LoutLS 
      read (20,*) !- - - - - - - - - - - - - - - - - -
      read (20,'(l4)')    SPHgrd
      read (20,*) !- - - - - - - - - - - - - - - - - -
      read (20,*)         HORint
      read (20,*) !- - - - - - - - - - - - - - - - - -
      read (20,*)         VERint
      read (20,*) !- - - - - - - - - - - - - - - - - -
      read (20,*) !- - - - - - - - - - - - - - - - - -
      read (20,'(l4)')    TOPetopo
      read (20,'(a4)')    TOP30 ! WARNING: string on purpose !!!
      read (20,*) !- - - - - - - - - - - - - - - - - -
      read (20,*) !- - - - - - - - - - - - - - - - - -
      read (20,'(l4)')    TOPcst
      read (20,'(l4)')    TOPcstLSC
      read (20,'(l4)')    TOPdomLSC
      read (20,'(l4)')    TOPcst0
      read (20,'(l4)')    TOPfilt
      read (20,*) !- - - - - - - - - - - - - - - - - -
      read (20,*) !- - - - - - - - - - - - - - - - - -
      read (20,'(l4)')    CORzz6
      read (20,'(l4)')    CORsurf
      read (20,*) !- - - - - - - - - - - - - - - - - -
      read (20,*) !- - - - - - - - - - - - - - - - - -
      read (20,'(l4)')    RUGdat
      read (20,*) !- - - - - - - - - - - - - - - - - -
      read (20,*) !- - - - - - - - - - - - - - - - - -
      read (20,'(l4)')    VEGdat
      read (20,'(l4)')    VEGcor
      read (20,'(l4)')    VEGcov
      read (20,*) !- - - - - - - - - - - - - - - - - -
      read (20,*) !- - - - - - - - - - - - - - - - - -
      read (20,'(l4)')    NDV1km
      read (20,'(l4)')    MERRA_lai ; NDV8km=.false.
      if(MERRA_lai)                   NDV1km=.false.
      read (20,*) !- - - - - - - - - - - - - - - - - -
      read (20,*) !- - - - - - - - - - - - - - - - - -
      read (20,'(l4)')    SVTmod
      read (20,*)         SVTwet
      read (20,'(l4)')    SVTlsc
      read (20,*) !- - - - - - - - - - - - - - - - - -
      read (20,*) !- - - - - - - - - - - - - - - - - -
      read (20,'(l4)')    SSTrey
      read (20,*) !- - - - - - - - - - - - - - - - - -
      read (20,*) !- - - - - - - - - - - - - - - - - -
      read (20,'(l4)')    useSnd
      read (20,*) !- - - - - - - - - - - - - - - - - -
      read (20,*) ! Ignored | read (20,'(A57)')   SNDfil
      read (20,*) !- - - - - - - - - - - - - - - - - -
      read (20,*) !- - - - - - - - - - - - - - - - - -
      read (20,'(l4)')    CLDcor
      read (20,*) !- - - - - - - - - - - - - - - - - -
      read (20,*) !- - - - - - - - - - - - - - - - - -
      read (20,*) ! Ignored | read (20,'(i4)')    rainDg
      read (20,*) !- - - - - - - - - - - - - - - - - -
      read (20,*) !- - - - - - - - - - - - - - - - - -
      read (20,*) !- - - - - - - - - - - - - - - - - -
      read (20,*) !- - - - - - - - - - - - - - - - - -
      read (20,*) ! Ignored | read (20,'(i4)')    metWGE
      read (20,*) !- - - - - - - - - - - - - - - - - -
      read (20,*) !- - - - - - - - - - - - - - - - - -
      read (20,*) !- - - - - - - - - - - - - - - - - -

      ! Add this when NSTing.ctr files will be updated
      ! read (20,*) !- - - - - - - - - - - - - - - - - -
      ! read (20,*) !- - - - - - - - - - - - - - - - - -
      ! read (20,'(l4)')    vrbose
      ! read (20,*) !- - - - - - - - - - - - - - - - - -

      CLOSE(unit=20)
      
      vrbose=.false. ! Hard-coded for now
      
C +        ******
      CALL WARNms
C +        ******

C ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

C +   Special message(s) (J.-F. Grailet): updated or removed features
C +   ===============================================================

      WRITE(6,*) 'NOTA BENE: this version of NESTOR provides minimal'
      WRITE(6,*) 'output for each time step (except for the first).'
      WRITE(6,*) 'To have the whole console output provided by former'
      WRITE(6,*) 'versions of NESTOR, please set the vrbose variable'
      WRITE(6,*) 'to true in NESTOR.f. Activation of the verbose mode'
      WRITE(6,*) 'via NST script and NSTing.ctr files will be made'
      WRITE(6,*) 'possible later.'

      IF ((selMod.NE.1).or.useSnd.or.TOP30.eq.'T   '.or.SSTrey) THEN
        WRITE(6,*)
        WRITE(6,*) 'WARNING: your NSTing.ctr file is providing values'
        WRITE(6,*) 'corresponding to features that are no longer'
        WRITE(6,*) 'usable in NESTOR. The execution will stop now to'
        WRITE(6,*) 'let you review the deprecated features you wanted'
        WRITE(6,*) 'to use (see below) and modify your control file'
        WRITE(6,*) 'accordingly. NST script and NSTing.ctr control'
        WRITE(6,*) 'will be updated later.'
        WRITE(6,*)
        IF (selMod.NE.1) THEN
         WRITE(6,*) 'Rain disagregation and wind gust estimation modes'
         WRITE(6,*) 'are deprecated.'
        ENDIF
        IF (useSnd) THEN
         WRITE(6,*) 'Initialization with sounding is deprecated.'
        ENDIF
        IF (TOP30.eq.'T   ') THEN
         WRITE(6,*) 'GTOPO dataset (ETOPOg routine) is deprecated.'
        ENDIF
        IF (SSTrey) THEN
         WRITE(6,*) 'Imposed Reynolds SST is deprecated.'
        ENDIF
        STOP
      ENDIF
      
      IF (VERint.EQ.3.AND.nk.lt.mz) THEN
       VERint=1
       WRITE(6,*)
       WRITE(6,*) 'WARNING: vertical cubic interpolation is not'
       WRITE(6,*) 'recommended with nk < mz. The number of vertical'
       WRITE(6,*) 'levels in the source data should be greater than'
       WRITE(6,*) 'or equal to the number of vertical levels in the'
       WRITE(6,*) 'output. Otherwise, results may be unsatisfying.'
       WRITE(6,*) 'To enforce VERint=3 with nk < mz, edit the NESTOR.f'
       WRITE(6,*) 'source file and re-compile NESTOR.'
      ENDIF
      
      IF (.not.SVTmod) THEN
       SVTmod = .true.
       WRITE(6,*)
       WRITE(6,*) 'WARNING: the De Ridder and Schayes soil model is'
       WRITE(6,*) 'imposed in the current NESTOR version. To enforce'
       WRITE(6,*) 'it, please modify NESTOR.f and re-compile NESTOR.'
      ENDIF

      WRITE(6,*)

C ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      WRITE(6,*) "NESTOR characteristics"
      WRITE(6,*) "~~~~~~~~~~~~~~~~~~~~~~"

C +---MODELS
C +   ======

      WRITE(6,'(A,$)') ' Forcing fields  (LSC) : '

      IF (LSCmod.eq.'ECM') WRITE(6,*) 'ECMWF - Hybrid levels'
      IF (LSCmod.eq.'E15') WRITE(6,*) 'ERA-15 - Hybrid levels'
      IF (LSCmod.eq.'E40') WRITE(6,*) 'ERA-40 - Hybrid levels'
      IF (LSCmod.eq.'E20') WRITE(6,*) 'ERA-20C - Hybrid levels'
      IF (LSCmod.eq.'ER5') WRITE(6,*) 'ERA5 - Hybrid levels'
      IF (LSCmod.eq.'EIN') WRITE(6,*) 'ERA-Interim - Hybrid levels'
      IF (LSCmod.eq.'ECP') WRITE(6,*) 'ECMWF - Pressure levels'
      IF (LSCmod.eq.'MAR') WRITE(6,*) 'MAR'
      IF (LSCmod.eq.'NCP') WRITE(6,*) 'NCEP'
      IF (LSCmod.eq.'GFS') WRITE(6,*) 'GFS'
      IF (LSCmod.eq.'ALA') WRITE(6,*) 'ALADIN'
      IF (LSCmod.eq.'CAN') WRITE(6,*) 'CanESM2 (CMIP5)'
      IF (LSCmod.eq.'CM3') WRITE(6,*) 'HadCM3 (ICE2SEA)'
      IF (LSCmod.eq.'EM5') WRITE(6,*) 'ECHAM5 (ICE2SEA)'
      IF (LSCmod.eq.'NOR') WRITE(6,*) 'NorESM1 (CMIP5)'
      IF (LSCmod.eq.'CSI') WRITE(6,*) 'CSIRO-Mk3 (CMIP5)'
      IF (LSCmod.eq.'BCC') WRITE(6,*) 'BCC-CSM1-1 (CMIP5)'
      IF (LSCmod.eq.'20C') WRITE(6,*) 
     .    '20th Century Reanalysis V2 (NOAA-CIRES)'
      IF (LSCmod.eq.'MIR') WRITE(6,*) 'MIROC5 (CMIP5)'
      IF (LSCmod.eq.'CM5') WRITE(6,*) 'CNRM-CM5 (CMIP5)'
      IF (LSCmod.eq.'AC3') WRITE(6,*) 'ACCESS1-3 (CMIP5)'
      IF (LSCmod.eq.'NC1') WRITE(6,*) 'NCEP-NCAPv1'
      IF (LSCmod.eq.'NC2') WRITE(6,*) 'NCEP-NCAPv2'
      IF (LSCmod.eq.'JRA') WRITE(6,*) 'JRA-55'
      IF (LSCmod.eq.'ME2') WRITE(6,*) 'MERRA2 (NASA)'


      WRITE(6,'(A,$)') ' Nested model    (NST) : '

      IF (NSTmod.eq.'MAR') WRITE(6,*) 'MAR'
      IF (NSTmod.eq.'M2D') WRITE(6,*) 'MAR - 2D version'
      IF (NSTmod.eq.'GRA') WRITE(6,*) 'GRADS'
      IF (NSTmod.eq.'CPL') WRITE(6,*) 'SVAT - Coupling'
      
      WRITE(6,*)

      IF (LSCmod.eq.'MAR') THEN
       REGgrd=.false.      ! Non-regular input grid (lat/long)
      ELSE
       REGgrd=.true.       ! Regular input grid (lat/long)
      ENDIF

                           f28d=.false. 
      IF (LSCmod.EQ.'CM3') M30d=.true.
      IF (LSCmod.EQ.'CAN') f28d=.true.
      IF (LSCmod.EQ.'NOR') f28d=.true.
      IF (LSCmod.EQ.'MIR') f28d=.true.
      IF (LSCmod.EQ.'CSI') f28d=.true.
      IF (LSCmod.EQ.'BCC') f28d=.true.

C +---REGION
C +   ======
   
      WRITE(6,'(A,$)') ' Region                : '

      IF (mw.EQ.1) STOP '#@!&  mw badly specified / must be > 1'

      IF (region.eq.'GRD') then
          WRITE(6,*) 'GRD (Greenland)'
          USRreg='GRD'
      ENDIF
      IF (region.eq.'ANT') then
          WRITE(6,*) 'ANT (Antarctic)'
          IF (mw.NE.2) STOP '#@!&  mw badly specified / must be = 2'
          region='GRD'
          USRreg='ANT'
      ENDIF
      IF (region.eq.'EUR') WRITE(6,*) 'EUR (Europe)'
      IF (region.eq.'WAF')  region="AFW"
      IF (region.eq.'AFW')                                          THEN
                           WRITE(6,*) 'AFW (West Africa)'
      END IF
      IF (region.eq.' NO') WRITE(6,*) 'No specified'

C ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

C +---CONTROL OF DATES
C +   ================   

C +---Initial, incremental, and final dates of run
C +   --------------------------------------------

C +        ******
      CALL DATcnv (RUNiyr,RUNmma,RUNjda,RUNjhu,DATini,Vtrue)
C +        ******
C +...Initial date of run

      DAT_dt=FORjhu
C +...Time interval

      DATfin=DATini+24*DURjda+DURjhu
C +...End date of run

C +---Number of steps
C +   ---------------

      DATstp=(DATfin-DATini)/DAT_dt + 1

C +---Initialisation
C +   --------------

      DATtim=DATini

C ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

C +---HORIZONTAL GRID IN NESTED MODEL
C +   ===============================

C +---Modele Atmospherique Regional (MAR)
C +   -----------------------------------

      IF (NSTmod.eq.'MAR'.or.NSTmod.eq.'M2D') THEN

C +         ******
       CALL MARhgd
C +         ******

      ENDIF

C +---GRADS graphic output
C +   --------------------

      IF (NSTmod.eq.'GRA') THEN

C +         ******
       CALL GRAhgd
C +         ******

      ENDIF

C +---Hydrology - meteo coupling
C +   --------------------------

      IF (NSTmod.eq.'CPL') THEN

C +         ******
       CALL CPLhgd
C +         ******

      ENDIF

C ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

C +---TOPOGRAPHY SOURCES
C +   ==================
C +
C +---Bamber data set (1 km)/Racmo2 topo
C +   ----------------------------------
      IF (USRreg.eq."ANT" ) THEN

C +            ******
          CALL ETOPO22           !   ETOPO 1min
          CALL ICEmsk           !
C +            ******

       IF (TOP30.eq."NSID" .OR. TOP30.eq."nsid") THEN

C +            ******
          CALL USRann('NSIDC ') !+  NSIDC   (2009)                          +!
C +            ******

       ELSE

C +            ******
          CALL USRant('bedma3') !+ 'Bamber' (2009)/'bedmap' (2013)/'Racmo2' / 'bedmac' 'Bedmachinev2,2019) +!
C +            ****** !bedma3 'Bedmachinev3'

       END IF
C +
C +---ETOPO data set (1/5 minutes)
C +   ----------------------------
      ELSE IF (TOPetopo) THEN

C +         ******
       CALL ETOPO22 ! ETOPO 1min
       CALL ICEmsk 
C +         ******

      ENDIF ! GTOPO removed (old unmaintained code)

C ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++


C +---CORRECTION OF PRESCRIBED TOPOGRAPHY
C +   ===================================

C +---Border of constant NST topography at boundaries
C +   -----------------------------------------------

      IF (TOPcst) THEN

       TOPopt=1
C +         ******
       CALL TOPcor (TOPopt)
C +         ******

      ENDIF


C +---Zero topography in the relaxation zone
C +   --------------------------------------

      IF (TOPcst0) THEN

       TOPopt=4
C +         ******
       CALL TOPcor (TOPopt)
C +         ******

      ENDIF


C +---Topography filtering (2D and 3D)
C +   --------------------------------

      IF (TOPfilt) THEN

       TOPopt=5

       CALL LSCinp
       CALL NSTint !! for having INT_sh
       
       ! Additional line return outside verbose mode (prettier display)
       IF (.not.vrbose) THEN
        WRITE(6,*)
       ENDIF

C +         ******
       CALL TOPcor (TOPopt)
C +         ******

      ELSE

       print *,"Are you sure to not filter the topo"
     .  //" at the boundaries ???" ; stop

      ENDIF
  
C ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++


C +---VEGETATION CHACTERISTICS
C +   ========================


C +---Global land cover - IGBP (only Africa and Europe)
C +   -------------------------------------------------

      IF (VEGdat.or.NDV1km) THEN

C +         ******
       CALL GLOveg
C +         ******

       ENDIF


C +---Vegetation cover in Europe (Corine)
C +   -----------------------------------

      IF (VEGcor) THEN

C +         ******
       CALL CORveg
C +         ******

      ENDIF


C +---Vegetation cover in Belgium
C +   ---------------------------

      IF (VEGbel) THEN

C +         ******
       CALL BELveg
C +         ******

      ENDIF

C +---Global Vegetation cover
C +   -----------------------

      IF (VEGcov) THEN

C +         ******
       CALL GLOveg
       CALL GLOcov
C +         ******

      ENDIF

C ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++


C +---SOIL CHACTERISTICS
C +   ==================


C +---FAO soil types classification
C +   -----------------------------

C +        ******
c     CALL FAOsol
C +        ******

C +---GSWP soil types classification
C +   ------------------------------

C +        ******
      CALL GSWPsl
      CALL HWSDsl
C +        ******

C +---Surface characteristics
C +   -----------------------

C +        ******
      CALL SOLdom
C +        ******

  
C ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

C +---CORRECTED VEGETATION FRACTION WITH MAX. NDVI INDEX
C +   ==================================================


C +---NDVI index (1 or 8 km resolution)
C +   ---------------------------------

      IF (NDV1km.or.NDV8km) THEN

C +         ******
       CALL GLOfrc
C +         ******

       ENDIF

      IF (USRreg.eq."ANT" ) THEN
       IF (TOP30.eq."NSID" .OR. TOP30.eq."nsid") THEN
C +            ******
          CALL USRann('NSIDC ') !+  NSIDC   (2009)                          +!
C +            ******
       ELSE
C +            ******
          CALL USRant('bedma3') !+ 'Bamber' (2009)/'bedmap' (2013)/'Racmo2' / 'bedmac' 'Bedmachinev2,2019) +!
C +            ****** ! bedma3 => bedmachine3
       END IF
      END IF

C ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      DO iter=1,DATstp    ! TEMPORAL ITERATION

C ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

C +---SELECT A LSC DATA FILE
C +   ======================

      IF (SVTmod) THEN

C +         ******
       CALL LSCinp
C +         ******

      ENDIF

C +---MAIN TREATMENT
C +   ==============

C +---1. Interpolation forcing fields for NST model
C +   ---------------------------------------------

      IF (SVTmod) THEN

C +         ******
       CALL NSTint
C +         ******

      ENDIF

C +---CORRECTION OF SURFACE CHARACTERISTICS
C +   =====================================

      IF (iter.eq.1) THEN

       ! Additional line return outside verbose mode (prettier display)
       IF (.not.vrbose) THEN
        WRITE(6,*)
       ENDIF
       
C +         ******
       CALL SOLdom
C +         ******

      ENDIF

C +...Note : this call is useful only if NSTint subroutine has
C +   modified the surface types (specified in NSTsol variable)

C +---CORRECTION OF FIELDS IN THE SURFACE LAYER
C +   =========================================

      IF (CORsurf) THEN

C +         ******
       CALL SL_cor
C +         ******

      ENDIF

C +---PROGNOSTIC AND ADDITIONAL VARIABLES FOR SVAT MODEL
C +   ==================================================

      IF (SVTmod) THEN

C +         ******
       CALL SVTpar
C +         ******

      ENDIF

C +---CORRECTED GREEN LEAF FRACTION WITH NDVI INDEX
C +   =============================================

C +---NDVI index (1 or 8-km resolution)
C +   ---------------------------------

      IF (NDV1km.or.NDV8km) THEN

C +         ******
       CALL GLOglf
C +         ******

      ENDIF

      IF(MERRA_lai) CALL MERlai

C +---OUTPUT FILES
C +   ============

C +---Modele Atmospherique Regional (MAR)
C +   -----------------------------------

      IF (NSTmod.eq.'MAR'.or.NSTmod.eq.'M2D'.or.NSTmod.eq.'CPL') THEN

C +         ******
       CALL MARout
C +         ******

      ENDIF

C +---GRAPHIC (NetCDF) FILES
C +   ======================

C +---Standard fields
C +   ---------------

      IF (LoutLS) THEN

C +         ******
       CALL NSTout
C +         ******

      ENDIF

C ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      DATtim=DATtim+DAT_dt

      ENDDO               ! TEMPORAL ITERATION

C ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

C +        ******
      CALL DATcnv (RUNiyr,RUNmma,RUNjda,RUNjhu,DATtim,Vtrue)
C +        ******      

      open (unit=1,status='replace',file='NST.OK')
      write (1,111) RUNjda,RUNmma,RUNiyr,RUNjhu  
  111 format("NESTOR execution stopped normaly the",i2,"/",i2,"/",i4,
     .       " at ",i2,"h.")
      close(1)  

      write(6,*)
      write(6,*)
      write(6,*) '    ***********************************************'
      write(6,*)
      write(6,*) '            END    OF    N  E  S  T  O  R          '
      write(6,*)
      write(6,*)

      END
