C   +-------------------------------------------------------------------+
C   |  Subroutine LSCvgd                                 12-04-2022 JFG |
C   +-------------------------------------------------------------------+
C   |                                                                   |
C   | Creation of a vertical grid for a given LSC model.                |
C   |                                                                   |
C   | Input : - LSCmod : selected LSC model                             |
C   | ^^^^^^^ - fID    : identificator of the Netcdf data file          |
C   |         - nk     : number of vertical levels                      |
C   |         - baseI  : minimum X index of the relevant LSC sub-region |
C   |         - baseJ  : minimum Y index of the relevant LSC sub-region |
C   |         - maxI   : maximum X index of the relevant LSC sub-region |
C   |         - maxJ   : maximum Y index of the relevant LSC sub-region |
C   |         - k      : if specified, the level at which pressure and  |
C   |                    hybrid coordinate has to be computed           |
C   |         - VGD_sp(ni,nj) : surface pressure                        |
C   |                                                                   |
C   | Output: Vertical grid of the LSC model :                          |
C   | ^^^^^^^ - VGD__p(ni,nj,nk) : pressure at each level  [kPa]        |
C   |         - VGD_hp(ni,nj,nk) : local hybrid coord. for vertic.      |
C   |                              interpolation                        |
C   |                                                                   |
C   | Remarks on optimization via sub-region selection (29/05/2022):    |
C   | -to compute the vertical grid for the full LSC domain, use        |
C   |  baseI=1, baseJ=1, maxI=ni, maxJ=nj.                              |
C   | -code assumes that the user will use 1 <= baseI <= maxI <= ni and |
C   |  1 <= baseJ <= maxJ <= nj.                                        |
C   | -if the variables baseI, baseJ, maxI and maxJ are set to delimit  |
C   |  a sub-region of the LSC grid, only this sub-region will be       |
C   |  completed in the output grids.                                   |
C   +-------------------------------------------------------------------+

      SUBROUTINE LSCvgd(LSCmod,fID,ni,nj,nk,baseI,baseJ,maxI,maxJ,klev,
     .                  VGD_sp,VGD__p,VGD_hp)

      IMPLICIT NONE

      INCLUDE 'CTRvar.inc'

C +---Local variables
C +   ===============

      INTEGER fID,ni,nj,baseI,baseJ,maxI,maxJ,nk,klev
 
      REAL VGD_sp(ni,nj),VGD__p(ni,nj,nk),VGD_hp(ni,nj,nk)

      CHARACTER*3 LSCmod

C +---Creation of the vertical grid depending on the specified model
C +   ==============================================================

C +---European Center of Medium-Range Forecast (ECMWF)
C +   ------------------------------------------------

C +---Hybrid levels
C +   -------------

      IF (LSCmod.eq.'ECM'.or.LSCmod.eq.'E15'.or.LSCmod.eq.'E40')

     . CALL ECMvgd(fID,ni,nj,nk,baseI,baseJ,maxI,maxJ,klev,.false.,
     .             VGD_sp,VGD__p,VGD_hp)

      IF (LSCmod.eq.'GCM')

     . CALL ECMvgd(fID,ni,nj,nk,baseI,baseJ,maxI,maxJ,klev,.true.,
     .             VGD_sp,VGD__p,VGD_hp)

C +---Pressure levels
C +   ---------------

      IF (LSCmod.eq.'ECP')

     . CALL XCPvgd(fID,ni,nj,nk,baseI,baseJ,maxI,maxJ,klev,.false.,
     .             VGD_sp,VGD__p,VGD_hp)

C +---NCEP analysis
C +   -------------

      IF (LSCmod.eq.'NCP') 

     . CALL XCPvgd(fID,ni,nj,nk,baseI,baseJ,maxI,maxJ,klev,.true.,
     .             VGD_sp,VGD__p,VGD_hp)
     
C +---Modele Atmospherique Regional (MAR)
C +   -----------------------------------

      IF (LSCmod.eq.'MAR') 

     . CALL MRLvgd(fID,ni,nj,nk,baseI,baseJ,maxI,maxJ,klev,
     .             VGD_sp,VGD__p,VGD_hp)

      RETURN
      END
