C   +-------------------------------------------------------------------+
C   |  Subroutine HWSDsl                              JAN 2018  NESTING |
C   +-------------------------------------------------------------------+

      SUBROUTINE HWSDsl

      IMPLICIT none

C +---General variables
C +   -----------------

      INCLUDE 'NSTdim.inc'
      INCLUDE 'NSTvar.inc'
      INCLUDE 'LOCfil.inc'
      INCLUDE 'NetCDF.inc'
      INCLUDE 'NESTOR.inc'

      real   ,parameter :: reso=0.00833333
      integer,parameter :: cx  = 43200
      integer,parameter :: cy  = 17760

      ! J.-F. Grailet: renamed in/jn as ins/jns (s=size) to avoid
      ! a potential confusion with the "in" keyword in Fortran (it is 
      ! highlighted as such in my code editor).

      integer minL, dimL
      integer ins,jns,i,j,k,l,kk,ll,x,y
      integer NET_ID,NETcid,Rcode
      integer ilc(mw+1),lcmax
      integer cov
      
      ! WIP
      integer :: fiCell(2), nCells(2)
      integer, dimension(:,:), allocatable :: arrCov

      ! J.-F. Grailet remark: previous_dx2 has not practical use.
      real dx1,dx2,dy1,dy2,previous_dx1,previous_dx2
      real lc(0:13),nbr_lc
      real dx3,dy3,dx4,dy4

      NETcid = NCOPN("input/SOIL/HWSDglob.nc",NCNOWRIT,Rcode)
      NET_ID = NCVID(NETcid,'HWS',Rcode)

      write(6,*) 'HSWD SOIL Cover'
      write(6,*) '~~~~~~~~~~~~~~~'
      write(6,*) ' '

      previous_dx1=5
      previous_dx2=5
      
      ! Loads a single large data band for the whole dual loop
      CALL bufLim (cy, 58., minL, dimL)
      
      fiCell(1) = 1
      fiCell(2) = minL+1
      nCells(1) = cx
      nCells(2) = dimL
      
      allocate(arrCov(cx, dimL))
      RCode = nf_get_vara_int(NETcid,NET_ID,fiCell,nCells,arrCov)

      DO j=1,my
      
      ! Old display is no longer useful given the time/memory trade-off
      ! WRITE(6,'(i4,$)') j
      
      DO i=1,mx

C +   *****

      IF(NSTsol(i,j)>=3.)THEN

C+    +---No data areas !CKittel 07/10/16
C+    if HWSDsl.f is very slow, please verify 
C+    http://webarchive.iiasa.ac.at/Research/LUC/External-World-soil-database/HTML/
C+    and if no data over your area add it below

      IF (NST__y(i,j)<-58                          .or.  !Antarctica
     .   (NST__y(i,j)<-40   .and. NST__y(i,j)>-55        !Kerguelen     Island
     .                      .and. NST__x(i,j)> 60 
     .                      .and. NST__X(i,j)< 75) .or.
     .   (NST__y(i,j)<-46.5 .and. NST__y(i,j)>-47.25     !Prince Edward Islands
     .                      .and. NST__x(i,j)> 37 
     .                      .and. NST__X(i,j)< 38) .or.
     .   (NST__y(i,j)<-50   .and. NST__y(i,j)>-55        !South Georgia and the South Sandwich Islands
     .                      .and. NST__x(i,j)>-42 
     .                      .and. NST__X(i,j)<-30)   
     .                                              ) then 
      GOTO 2222
      endif
C +   *****

       dx1=abs(NST__x(i,j)-
     .      NST__x(max(1,min(mx,i-1)),max(1,min(my,j))))
       dx2=abs(NST__x(i,j)-
     .      NST__x(max(1,min(mx,i+1)),max(1,min(my,j))))

       dx3=abs(NST__x(i,j)-
     .      NST__x(max(1,min(mx,i)),max(1,min(my,j-1))))
       dx4=abs(NST__x(i,j)-
     .      NST__x(max(1,min(mx,i)),max(1,min(my,j+1))))

       dx1=max(dx1,max(dx2,max(dx3,dx4)))

       dy1=abs(NST__y(i,j)-
     .      NST__y(max(1,min(mx,i  )),max(1,min(my,j-1))))
       dy2=abs(NST__y(i,j)-
     .      NST__y(max(1,min(mx,i  )),max(1,min(my,j+1))))

       dy3=abs(NST__y(i,j)-
     .      NST__y(max(1,min(mx,i-1)),max(1,min(my,j))))
       dy4=abs(NST__y(i,j)-
     .      NST__y(max(1,min(mx,i+1)),max(1,min(my,j))))

       dy1=max(dy1,max(dy2,max(dy3,dy4)))

       if(dx1<50) then 
        dx1=dx1/(2.*reso)
       else
        dx1=previous_dx1
       endif

       dy1=dy1/(2.*reso)

       ins=nint((NST__x(i,j)+180.)/reso)
       jns=nint((NST__y(i,j)+ 58.)/reso)  

       nbr_lc=0
 
       do while(nbr_lc==0)
        
        lc=0.

        do k=ins-nint(dx1),ins+nint(dx1)
        do l=jns-nint(dy1),jns+nint(dy1) 

         kk=k 
         ll=l
         if(kk<1)  kk=cx+kk
         if(ll<1)  ll=1  ! cy+ll (previous code used lat. rollover ?)
         if(kk>cx) kk=kk-cx
         if(ll>cy) ll=cy ! ll-cy (ditto)

         kk=max(1,min(cx,kk))
         ll=max(1,min(cy,ll))
         
         cov = arrCov(kk,ll-minL)

         if(cov==1)   lc(11)= lc(11)+1
         if(cov==2)   lc(10)= lc(10)+1
         if(cov==3)   lc(11)= lc(11)+1
         if(cov==4)   lc(7) = lc(7) +1
         if(cov==5)   lc(8) = lc(8) +1 
         if(cov==6)   lc(4) = lc(4) +1
         if(cov==7)   lc(4) = lc(4) +1
         if(cov==8)   lc(9) = lc(9) +1
         if(cov==9)   lc(5) = lc(5) +1
         if(cov==10)  lc(6) = lc(6) +1
         if(cov==11)  lc(3) = lc(3) +1
         if(cov==12)  lc(2) = lc(2) +1
         if(cov==13)  lc(1) = lc(1) +1

         if(cov==-1)  lc(0) = lc(0)+1

        enddo ; enddo

        nbr_lc=0

        do l=0,12
         nbr_lc=nbr_lc+lc(l)
        enddo

        dx1=dx1*1.5
        dx2=dx2*1.5
        dy1=dy1*1.5
        dy2=dy2*1.5
 
       enddo

      ilc=-1
 
      lcmax=0 ; l=1

      do k=0,12

       if(l==1.and.lc(k)>=lcmax) then
        lcmax=lc(k)
        ilc(l)=k
       endif
   
      enddo
 
      if(ilc(l)>0) then
       NSTtex(i,j) = ilc(l)
       NSTtex(i,j) = max(1   ,min(12 ,NSTtex(i,j)))
      endif
     
C +   *****
2222  continue
      ENDIF  ! Continental area
C +   *****

      ENDDO
      ENDDO
      
      if (allocated(arrCov)) deallocate (arrCov)

      END SUBROUTINE HWSDsl
